<?php

    class mop_detalle extends MY_Model{

        public function __construct(){
            parent :: __construct();
            $this->table = "op_detalle";
            $this->alias = 'op';

            $this->selectDefault = "".
                $this->alias.".id
            ,".$this->alias.".semanaActual
            ,".$this->alias.".semanaAnual
            ,".$this->alias.".fecha
            ,".$this->alias.".idFraccionamiento
            ,".$this->alias.".idPaqPpto
            ,".$this->alias.".idAvance
            ,".$this->alias.".idEstimado
            ,".$this->alias.".idEstimaciones
            ,".$this->alias.".idPaquete
            ,".$this->alias.".idOrdenPago
            ,".$this->alias.".idProyecto
            ,".$this->alias.".idPresupuesto
            ,".$this->alias.".idConstructor
            ,".$this->alias.".idSupervisor
            ,".$this->alias.".idInspector
            ,".$this->alias.".tipoLote
            ,".$this->alias.".iniciado
            ,".$this->alias.".calidad
            ,".$this->alias.".descripcion
            ,".$this->alias.".precioUnitario
            ,".$this->alias.".cantidad
            ,".$this->alias.".percent_fg
            ,".$this->alias.".fg
            ,".$this->alias.".importe
            ,".$this->alias.".importe
            ,".$this->alias.".tipoActividad
            ,".$this->alias.".tipoExtra
            ,".$this->alias.".status
            ,IF(".$this->alias.".status > 0,'Activo','Inactivo') AS txtstatus";
        }
        // Populate values
        private function _populateValues($r)
        {
            $array = array(
                'id' => '',
                'semanaActual' => '',
                'semanaAnual' => '',
                'fecha' => '',
                'idFraccionamiento' => '',
                'idPaqPpto' => '',
                'idAvance' => '',
                'idEstimado' => '',
                'idEstimaciones' => '',
                'idPaquete' => '',
                'idOrdenPago' => '',
                'idProyecto' => '',
                'idPresupuesto' => '',
                'idConstructor' => '',
                'idSupervisor' => '',
                'idInspector' => '',
                'tipoLote' => '',
                'iniciado' => '',
                'calidad' => '',
                'descripcion' => '',
                'precioUnitario' => '',
                'cantidad' => '',
                'percent_fg' => '',
                'fg' => '',
                'importe' => '',
                'importe' => '',
                'tipoActividad' => '',
                'tipoExtra' => '',
                'status' => '',
                'txtstatus' => ''
            );

            if (!is_numeric($r)) {
                $array['id'] = $r->row()->id;
                $array['semanaActual'] = $r->row()->semanaActual;
                $array['semanaAnual'] = $r->row()->semanaAnual;
                $array['fecha'] = $r->row()->fecha;
                $array['idFraccionamiento'] = $r->row()->idFraccionamiento;
                $array['idPaqPpto'] = $r->row()->idPaqPpto;
                $array['idAvance'] = $r->row()->idAvance;
                $array['idEstimado'] = $r->row()->idEstimado;
                $array['idEstimaciones'] = $r->row()->idEstimaciones;
                $array['idPaquete'] = $r->row()->idPaquete;
                $array['idOrdenPago'] = $r->row()->idOrdenPago;
                $array['idProyecto'] = $r->row()->idProyecto;
                $array['idPresupuesto'] = $r->row()->idPresupuesto;
                $array['idConstructor'] = $r->row()->idConstructor;
                $array['idSupervisor'] = $r->row()->idSupervisor;
                $array['idInspector'] = $r->row()->idInspector;
                $array['tipoLote'] = $r->row()->tipoLote;
                $array['iniciado'] = $r->row()->iniciado;
                $array['calidad'] = $r->row()->calidad;
                $array['descripcion'] = $r->row()->descripcion;
                $array['precioUnitario'] = $r->row()->precioUnitario;
                $array['cantidad'] = $r->row()->cantidad;
                $array['percent_fg'] = $r->row()->percent_fg;
                $array['fg'] = $r->row()->fg;
                $array['importe'] = $r->row()->importe;
                $array['importe'] = $r->row()->importe;
                $array['tipoActividad'] = $r->row()->tipoActividad;
                $array['tipoExtra'] = $r->row()->tipoExtra;
                $array['status'] = $r->row()->status;
                $array['txtstatus'] = $r->row()->txtstatus;
            }
            $array['msg'] = '';
            return $array;
        }

        function getAll(){
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.status' => true);
            $this->db->where($arrayWhere);
            $this->db->order_by($this->alias.'.id', "asc");
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $query;
            }else{
                return 0;
            }
        }

        function getById($id){
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.id' => $id);
            $this->db->where($arrayWhere);
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $this->_populateValues($query);
            }else{
                return 0;
            }
        }
    }