<?php
    class mnotaria extends MY_Model{

        public function __construct(){
            parent :: __construct();
            $this->table = "notarias";
            $this->alias = 'n';

            $this->selectDefault = "".
                $this->alias.".id
            ,".$this->alias.".nombre
            ,".$this->alias.".apellidoP
            ,".$this->alias.".apellidoM
            ,".$this->alias.".telefono
            ,".$this->alias.".email
            ,".$this->alias.".status
            ,IF(".$this->alias.".status > 0,'Activo','Inactivo') AS txtstatus";

            $this->selectResult = "".
                $this->alias.".id
            ,CONCAT(".$this->alias.".nombre,' ',".$this->alias.".apellidoP) AS titulo";

        }


        // Populate values
        private function _populateValues($r)
        {
            $array = array(
                'id' => '',
                'nombre' => '',
                'apellidoP' => '',
                'apellidoM' => '',
                'telefono' => '',
                'email' => '',
                'status' => '',
                'txtstatus' => ''
            );

            if (!is_numeric($r)) {
                $array['id'] = $r->row()->id;
                $array['nombre'] = $r->row()->nombre;
                $array['apellidoP'] = $r->row()->apellidoP;
                $array['apellidoM'] = $r->row()->apellidoM;
                $array['telefono'] = $r->row()->telefono;
                $array['email'] = $r->row()->email;
                $array['status'] = $r->row()->status;
                $array['txtstatus'] = $r->row()->txtstatus;

            }
                $array['msg'] = '';
            return $array;
        }

        function getAll(){
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.status' => true);
            $this->db->where($arrayWhere);
            $this->db->order_by($this->alias.'.id', "desc");
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $query;
            }else{
                return 0;
            }
        }

         function getById($id){
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.id' => $id);
            $this->db->where($arrayWhere);
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $this->_populateValues($query);
            }
            return 0;
        }

        function getSelectResult(){
            $this->db->select($this->selectResult,FALSE);
            $arrayWhere = array($this->alias.'.status' => true);
            $this->db->where($arrayWhere);
            $this->db->order_by($this->alias.'.id', "desc");
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $query;
            }else{
                return 0;
            }
        }


       
    }