<?php

    class Mmovimientospromotor extends MY_Model{

        public function __construct(){
            parent :: __construct();
            $this->table = "movimientos_promotores";
            $this->alias = 'mp';

            $this->selectDefault = "".
                $this->alias.".id
            ,".$this->alias.".idAltaVenta
            ,".$this->alias.".idPromotor
            ,".$this->alias.".cargo
            ,".$this->alias.".descripcion
            ,".$this->alias.".tipo
            ,".$this->alias.".status
            ,".$this->alias.".created
            ,".$this->alias.".updated
            ,".$this->alias.".status
            ,IF(".$this->alias.".status > 0,'Activo','Inactivo') AS txtstatus";
        }

        // Populate values
        private function _populateValues($r)
        {
            $array = array(
                'id' => '',
                'idAltaVenta' => '',
                'idPromotor' => '',
                'cargo' => '',
                'descripcion' => '',
                'tipo' => '',
                'status' => '',
                'created' => '',
                'updated' => '',
                'status' => '',
                'txtstatus' => ''
            );

            if (!is_numeric($r)) {
                $array['id'] = $r->row()->id;
                $array['idAltaVenta'] = $r->row()->idAltaVenta;
                $array['idPromotor'] = $r->row()->idPromotor;
                $array['cargo'] = $r->row()->cargo;
                $array['descripcion'] = $r->row()->descripcion;
                $array['tipo'] = $r->row()->tipo;
                $array['status'] = $r->row()->status;
                $array['created'] = $r->row()->created;
                $array['updated'] = $r->row()->updated;
                $array['status'] = $r->row()->status;
                $array['txtstatus'] = $r->row()->txtstatus;

            }
                $array['msg'] = '';
            return $array;
        }


        function getAll(){
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.status' => true);
            //$this->db->where($arrayWhere);
            $this->db->order_by($this->alias.'.id', "desc");
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $query;
            }else{
                return 0;
            }
        }

        function getById($id){
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.id' => $id);
            $this->db->where($arrayWhere);
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $this->_populateValues($query);
            }
            else{
                return 0;
            }
        }

        function getByIdPromotor($id=null,$idAltaVenta=null){
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.idPromotor' => $id);
            $this->db->where($arrayWhere);
            if($idAltaVenta>0){
                $this->db->where($this->alias.'.idAltaVenta', $idAltaVenta);
            }
            $this->db->order_by($this->alias.'.id', "DESC");
            $this->db->limit(1);
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                if($query->row()->saldo > 0){
                    return 0;
                }
                return $query;
            }else{
                return 0;
            }
        }

        function getSumIngresos($idPromotor=null)
        {
            $query = $this->db->query("
                SELECT
                IF
                    ( SUM( cargo ) > 0, SUM( cargo ), 0 ) AS ingresos 
                FROM
                    movimientos_promotores 
                WHERE
                    idPromotor = $idPromotor 
                    AND tipo = 'Ingresos';
            ");

            return $query->row()->ingresos;
        }

        function getSumEgresos($idPromotor=null)
        {
            $query = $this->db->query("
                SELECT
                IF
                    ( SUM( cargo ) > 0, SUM( cargo ), 0 ) AS egresos 
                FROM
                    movimientos_promotores 
                WHERE
                    idPromotor = $idPromotor 
                    AND tipo = 'Egresos';
            ");

            return $query->row()->egresos;
        }

        function getPendientes()
        {
            $query = $this->db->query("
                SELECT
                    mp.idPromotor,
                    ( SELECT CONCAT( nombre, ' ', apellidoP, ' ', apellidoM ) FROM usuarios WHERE id = mp.idPromotor ) AS promotor,
                    ( SELECT tipoPromotor FROM usuarios WHERE id = mp.idPromotor ) AS tipo,
                    (
                    SELECT
                    IF
                        ( SUM( cargo ) > 0, SUM( cargo ), 0 ) AS egresos 
                    FROM
                        movimientos_promotores 
                    WHERE
                        idPromotor = mp.idPromotor 
                        AND tipo = 'Ingresos' 
                    ) AS ingresos,
                    (
                    SELECT
                    IF
                        ( SUM( cargo ) > 0, SUM( cargo ), 0 ) AS egresos 
                    FROM
                        movimientos_promotores 
                    WHERE
                        idPromotor = mp.idPromotor 
                        AND tipo = 'Egresos' 
                    ) AS egresos,
                    ((
                        SELECT
                        IF
                            ( SUM( cargo ) > 0, SUM( cargo ), 0 ) AS egresos 
                        FROM
                            movimientos_promotores 
                        WHERE
                            idPromotor = mp.idPromotor 
                            AND tipo = 'Ingresos' 
                            ) - (
                        SELECT
                        IF
                            ( SUM( cargo ) > 0, SUM( cargo ), 0 ) AS egresos 
                        FROM
                            movimientos_promotores 
                        WHERE
                            idPromotor = mp.idPromotor 
                            AND tipo = 'Egresos' 
                        )) AS saldo 
                FROM
                    movimientos_promotores AS mp 
                GROUP BY
                    mp.idPromotor;
            ");

            if($query->num_rows()>0){
                return $query;
            }else{
                return 0;
            }
        }

    }