<?php
    class Mmatrizcomisiones extends MY_Model{

        public function __construct(){
            parent :: __construct();
            $this->table = "matriz_comisiones";
            $this->alias = 'm';

            $this->selectDefault = "".
                $this->alias.".id
            ,".$this->alias.".ventas
            ,".$this->alias.".porcentajeVentas
            ,".$this->alias.".tipoPromotor
            ,".$this->alias.".status
            ,IF(".$this->alias.".status > 0,'Activo','Inactivo') AS txtstatus";

        }


        // Populate values
        private function _populateValues($r)
        {
            $array = array(
                'id' => '',
                'ventas' => '',
                'porcentajeVentas' => '',
                'tipoPromotor' => '',
                'status' => '',
            );

            if (!is_numeric($r)) {
                $array['id'] = $r->row()->id;
                $array['ventas'] = $r->row()->ventas;
                $array['porcentajeVentas'] = $r->row()->porcentajeVentas;
                $array['tipoPromotor'] = $r->row()->tipoPromotor;
                $array['status'] = $r->row()->status;
            }
                $array['msg'] = '';
            return $array;
        }

        function getAll(){
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.status' => true);
            $this->db->where($arrayWhere);
            $this->db->order_by($this->alias.'.id', "asc");
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $query;
            }else{
                return 0;
            }
        }

         function getById($id){
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.id' => $id);
            $this->db->where($arrayWhere);
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $this->_populateValues($query);
            }
            return 0;
        }

        function getByVentasTipoPromotor($numVentas, $tipoPromotor){
            $ventas = 0;
            $numVentas = (int)$numVentas;
            if($tipoPromotor == 'Interno'){
                if($numVentas == 1){
                    $ventas = 1;
                }else if($numVentas == 2){
                    $ventas = 2;
                }else if($numVentas == 3){
                    $ventas = 3;
                }else if($numVentas == 4){
                    $ventas = 4;
                }else if($numVentas >= 5){
                    $ventas = 5;
                }
            }else if($tipoPromotor == 'Externo'){
                if($numVentas >= 1){
                    $ventas = 1;
                }

            }else if($tipoPromotor == 'Ex-interno'){
                if($numVentas >= 1){
                    $ventas = 1;
                }
            }
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.ventas' => $ventas, $this->alias.'.tipoPromotor' => $tipoPromotor);
            $this->db->where($arrayWhere);
            $this->db->order_by($this->alias.'.id', "asc");
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $this->_populateValues($query);
            }else{
                return 0;
            }
        }

        function getByTipoPromotor($tipoPromotor){
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.tipoPromotor' => $tipoPromotor);
            $this->db->where($arrayWhere);
            $this->db->order_by($this->alias.'.id', "asc");
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $query;
            }else{
                return 0;
            }
        }

    }