<?php
    class mmaterialesactividadprototipo extends MY_Model{

        public function __construct(){
            parent :: __construct();
            $this->table = "materialesactividadprototipo";
            $this->alias = 'm';

            $this->selectDefault = "".
                $this->alias.".id
            ,".$this->alias.".idActividadPrototipo
            ,".$this->alias.".idMaterial
            ,".$this->alias.".cantidad
            ,".$this->alias.".tipo
            ,".$this->alias.".status
            ,IF(".$this->alias.".status > 0,'Activo','Inactivo') AS txtstatus";

            $this->selectResult = "".
                $this->alias.".id
            ,CONCAT(".$this->alias.".unidad,' ',".$this->alias.".abreviatura) AS titulo";     
         }
        // Populate values
        private function _populateValues($r)
        {
            $array = array(
                'id' => '',
                'idActividadPrototipo' => '',
                'idMaterial' => '',
                'cantidad' => '',
                'tipo' => '',
                'status' => '',
            );

            if (!is_numeric($r)) {
                $array['id'] = $r->row()->id;
                $array['idActividadPrototipo'] = $r->row()->idActividadPrototipo;
                $array['idMaterial'] = $r->row()->idMaterial;
                $array['cantidad'] = $r->row()->cantidad;
                $array['tipo'] = $r->row()->tipo;
                $array['status'] = $r->row()->status;
            }
                $array['msg'] = '';
            return $array;
        }

        function getAll(){
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.status' => true);
            //$this->db->where($arrayWhere);
            $this->db->order_by($this->alias.'.id', "desc");
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $query;
            }else{
                return 0;
            }
        }

        function getAllMaterialesbyidActividadPrototipo($idActividadPrototipo){
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.idActividadPrototipo' => $idActividadPrototipo);
            $this->db->where($arrayWhere);
            $this->db->order_by($this->alias.'.id', "asc");
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $query;
            }else{
                return 0;
            }
        }

        function getById($id){
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.id' => $id);
            $this->db->where($arrayWhere);
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $this->_populateValues($query);
            }else{
                return 0;
            }
        }

        function getSelectResult(){
            $this->db->select($this->selectResult,FALSE);
            $arrayWhere = array($this->alias.'.status' => true);
            $this->db->where($arrayWhere);
            $this->db->order_by($this->alias.'.id', "desc");
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $query;
            }else{
                return 0;
            }
        }    

        function getIdsMateriales($id){
            $this->db->select($this->alias.'.idMaterial',FALSE);
            $arrayWhere = array($this->alias.'.idActividadPrototipo' => $id);
            $this->db->where($arrayWhere);
            //$this->db->order_by($this->alias.'.id', "desc");
            $query = $this->db->get($this->table.' AS '.$this->alias);

            if($query->num_rows()>0){
               $items = array();
               //sprint_r($query->result()); exit();
                foreach($query->result() as $row) {
                 $items[] = $row->idMaterial;
                }
                return $items;
            }else{
                return 0;
            }
        }
        function getIdsMaterialesActividadPrototipo($id){
            $this->db->select($this->alias.'.id',FALSE);
            $arrayWhere = array($this->alias.'.idActividadPrototipo' => $id);
            $this->db->where($arrayWhere);
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
               $items = array();
                foreach($query->result() as $row) {
                    $this->borrar($row->id);
                    //$items[] = $row->id;
                }
                return $items;
            }else{
                return 0;
            }
        }  

        function ValidategetMateriales($id){
            $this->db->select($this->selectResult,FALSE);
            $arrayWhere = array($this->alias.'.status' => true);
            $this->db->where($arrayWhere);
            $this->db->order_by($this->alias.'.id', "desc");
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $query;
            }else{
                return 0;
            }
        }

        function getMaterialesNews($idActividadPrototipo){
            $query = $this->db->query('
                    SELECT m.id, p.idMaterialesPrototipo, p.id AS idPresupuestoMAT, m.idActividadPrototipo, m.idMaterial, m.cantidad, p.precioUnitario, p.semana
                    FROM materialesactividadprototipo AS m LEFT JOIN presupuesto_mat AS p ON m.id = p.idMaterialesPrototipo
                    WHERE m.idActividadPrototipo = ' . $idActividadPrototipo . ' ORDER BY m.id ASC;
                ');
            if ($query->num_rows() > 0) {
                return $query;
            } else {
                return 0;
            }
        }
        #actualizar tabla 
          function updateMatActProt($data){
           #datos a ctualizar
            $dat = array(
                'cantidad' => $data['cantidad'],
                );
            #consulta para actuaizar
            $this->db->where('idActividadPrototipo', $data['idActividadPrototipo']);
            $this->db->where('idMaterial', $data['idMaterial']);
            $this->db->where('tipo', $data['tipo']);
            $this->db->update('materialesactividadprototipo', $dat);

        }

        function getByIdMaterial($idMaterial)
        {
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.idMaterial' => $idMaterial);
            $this->db->where($arrayWhere);
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $this->_populateValues($query);
            }else{
                return 0;
            }
        }
    }