<?php
    class mmateriales extends MY_Model{

        public function __construct(){
            parent :: __construct();
            $this->table = "materiales";
            $this->alias = 'm';

            $this->selectDefault = "".
                $this->alias.".id
            ,".$this->alias.".idEmpresa
            ,".$this->alias.".clave
            ,".$this->alias.".nombre AS titulo
            ,".$this->alias.".nombre
            ,".$this->alias.".id_linea_art
            ,".$this->alias.".linea_art
            ,".$this->alias.".unidad_venta
            ,".$this->alias.".unidad_compra
            ,".$this->alias.".contenido_unidad_compra
            ,".$this->alias.".notas_ventas
            ,".$this->alias.".notas_compras
            ,".$this->alias.".estatus";

            $this->selectResult = "".
                $this->alias.".id
            ,".$this->alias.".clave
            ,".$this->alias.".nombre AS titulo";

        }

        // Populate values
        private function _populateValues($r)
        {
            $array = array(
                'id' => '',
                'idEmpresa' => '',
                'clave' => '',
                'nombre' => '',
                'id_linea_art' => '',
                'linea_art' => '',
                'unidad_venta' => '',
                'unidad_compra' => '',
                'contenido_unidad_compra' => '',
                'notas_ventas' => '',
                'notas_compras' => '',
                'estatus' => '',
            );

            if (!is_numeric($r)) {
                $array['id'] = $r->row()->id;
                $array['idEmpresa'] = $r->row()->idEmpresa;
                $array['clave'] = $r->row()->clave;
                $array['nombre'] = $r->row()->nombre;
                $array['id_linea_art'] = $r->row()->id_linea_art;
                $array['linea_art'] = $r->row()->linea_art;
                $array['unidad_venta'] = $r->row()->unidad_venta;
                $array['unidad_compra'] = $r->row()->unidad_compra;
                $array['contenido_unidad_compra'] = $r->row()->contenido_unidad_compra;
                $array['notas_ventas'] = $r->row()->notas_ventas;
                $array['notas_compras'] = $r->row()->notas_compras;
                $array['estatus'] = $r->row()->estatus;
            }
                $array['msg'] = '';
            return $array;
        }

        function getAll(){
            $this->db->select($this->selectDefault,FALSE);
            $this->db->order_by($this->alias.'.id', "desc");
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $query;
            }else{
                return 0;
            }
        }

        function getAllExcelRows(){
            $id = $_SESSION["viv"]['idEmpresa'];
            $query=$this->db->query("
                SELECT `clave`,`nombre`,`linea_art`,`unidad_venta`,`unidad_compra`
                FROM `materiales` 
                WHERE `idEmpresa`= $id ORDER BY  id  DESC
            ");
             
            if($query->num_rows()>0){
                return $query;
            }else{
                return 0;
            }
        }

        function getById($id){
            $this->db->select($this->selectDefault,FALSE);
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $this->_populateValues($query);
            }else{
                return 0;
            }
        }

        function getByIdEmpresa($id,$idEmpresa){
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.id' => $id, $this->alias.'.idEmpresa' => $idEmpresa);
            $this->db->where($arrayWhere);
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $this->_populateValues($query);
            }else{
                return 0;
            }
        }
        

        function getSelectResult($idEmpresa=0){
            $idEmpresa=($idEmpresa==0) ? $_SESSION["viv"]["idEmpresa"] : $idEmpresa;
            $query=$this->db->query("
            (SELECT id,clave,nombre titulo FROM materiales WHERE idEmpresa=$idEmpresa AND clave) 
            UNION 
            (SELECT cv.idArticulo id,cv.clave,mat.nombre titulo FROM claves_articulos cv LEFT JOIN materiales mat ON mat.id=cv.idArticulo 
            WHERE cv.idEmpresa=$idEmpresa AND mat.idEmpresa=$idEmpresa)");
            if($query->num_rows()>0){
                return $query;
            }else{
                return 0;
            }
        }

        function getMaterialesWhereNotIn($ids){
            $this->db->select($this->selectResult,FALSE);
            if(count($ids)>0 && !empty($ids)){
                $this->db->where_not_in($this->alias.'.id', $ids);
            }        
            $this->db->order_by($this->alias.'.id', "desc");
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $query;
            }else{
                return 0;
            }
        }

        function getByClave($clave, $idEmpresa){
            $query="";
            if($clave!=''){
                $pri=$this->db->query("SELECT id,clave FROM materiales WHERE clave='$clave' AND idEmpresa=$idEmpresa");
                $sec=$this->db->query("SELECT idArticulo id,clave FROM claves_articulos WHERE clave='$clave' AND idEmpresa=$idEmpresa ");
                $priVal=false;
                $secVal=false;
                if($pri->num_rows()>0){
                    $priVal=true;
                }
                if($sec->num_rows()>0){
                    $secVal=true;
                }
                if($priVal && $secVal){
                    echo $clave." | se repite en primaria y secundaria | ".$idEmpresa."<br>";
                }else{
                    if($priVal){
                        $query=$pri;
                    }else if($secVal){
                        $query=$sec;
                    }else{
                        echo $clave." | clave no encontrada | ".$idEmpresa."<br>";
                    }
                }
                if($query->num_rows()>0){
                    return $query->row();
                }else{
                    return 0;
                }
            }else{
                echo "Clave vacía<br>";
            }
        }

        function valInsert($id,$idEmpresa){
            $query=$this->db->query("SELECT id FROM materiales WHERE id=$id AND idEmpresa=$idEmpresa");
            return ($query->num_rows()>0) ? false : true;
        }

        function valUpdate($id,$data){
            $search="";
            foreach ($data as $key => $val) {
                switch ($key) {
                    case 'id':
                        $id=$val;
                        break;
                    case 'idEmpresa':
                        $search .= " AND idEmpresa = $val";
                        break;
                    default:
                        $search.=" AND ".$key."='".$val."'";
                }
            }
            $query=$this->db->query("SELECT id FROM materiales WHERE id=$id $search ");
            return ($query->num_rows()>0) ? false : true;
        }

        function getById2($id,$idEmpresa){
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.id' => $id, $this->alias.'.idEmpresa' => $idEmpresa);
            $this->db->where($arrayWhere);
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $this->_populateValues($query);
            }else{
                return 0;
            }
        }

        function getAllFiltro($idEmpresa){
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.idEmpresa' => $idEmpresa);
            $this->db->where($arrayWhere);
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $query;
            }else{
                return 0;
            }
        }

        //FUNCIONES DEL SERVERSIDE

        var $column_order = array(null, 'clave','nombre','linea_art','unidad_venta','unidad_compra'); //set column field database for datatable orderable
        var $column_search = array('clave','nombre','linea_art','unidad_venta','unidad_compra'); //set column field database for datatable searchable
        var $order = array('id' => 'desc'); // default order
        
        private function _get_datatables_query()
        {

            $this->db->from($this->table);

            if($_SESSION["viv"]["idEmpresa"] > 0){
                 $id=$_SESSION["viv"]["idEmpresa"];
                 $arrayWhere = array('idEmpresa' => $id);
                 $this->db->where($arrayWhere);
            }

            $i = 0;

            foreach ($this->column_search as $item) // loop column
            {
                if($_POST['search']['value']) // if datatable send POST for search
                {

                    if($i===0) // first loop
                    {
                        $this->db->group_start(); // open bracket. query Where with OR clause better with bracket. because maybe can combine with other WHERE with AND.
                        $this->db->like($item, $_POST['search']['value']);
                    }
                    else
                    {
                        $this->db->or_like($item, $_POST['search']['value']);
                    }

                    if(count($this->column_search) - 1 == $i) //last loop
                        $this->db->group_end(); //close bracket
                }
                $i++;
            }

            if(isset($_POST['order'])) // here order processing
            {
                $this->db->order_by($this->column_order[$_POST['order']['0']['column']], $_POST['order']['0']['dir']);
            }
            else if(isset($this->order))
            {
                $order = $this->order;
                $this->db->order_by(key($order), $order[key($order)]);
            }
        }

        function get_datatables()
        {
            $this->_get_datatables_query();
            if($_POST['length'] != -1)
            $this->db->limit($_POST['length'], $_POST['start']);
            $query = $this->db->get();
            return $query->result();
        }

        function count_filtered()
        {
            $this->_get_datatables_query();
            $query = $this->db->get();
            return $query->num_rows();
        }

        public function count_all()
        {
            $this->db->from($this->table);
            return $this->db->count_all_results();
        }
}