<?php

    class Mmaterial extends MY_Model{

        public function __construct(){
            parent :: __construct();
            $this->table = "material";
            $this->alias = 'm';

            $this->selectDefault = "".
                $this->alias.".id
            ,".$this->alias.".idEmpresa
            ,".$this->alias.".idFraccionamiento
            ,".$this->alias.".idPrototipo
            ,".$this->alias.".idPaquete
            ,".$this->alias.".tipo
            ,".$this->alias.".idArranque
            ,".$this->alias.".status
            ,IF(".$this->alias.".status > 0,'Activo','Inactivo') AS txtstatus";
        }
        // Populate values
        private function _populateValues($r)
        {
            $array = array(
                'id' => '',
                'idEmpresa' => '',
                'idFraccionamiento' => '',
                'idPrototipo' => '',
                'idPaquete' => '',
                'tipo' => '',
                'idArranque' => '',
                'status' => '',
                'txtstatus' => ''
            );

            if (!is_numeric($r)) {
                $array['id'] = $r->row()->id;
                $array['idEmpresa'] = $r->row()->idEmpresa;
                $array['idFraccionamiento'] = $r->row()->idFraccionamiento;
                $array['idPrototipo'] = $r->row()->idPrototipo;
                $array['idPaquete'] = $r->row()->idPaquete;
                $array['tipo'] = $r->row()->tipo;
                $array['idArranque'] = $r->row()->idArranque;
                $array['status'] = $r->row()->status;
                $array['txtstatus'] = $r->row()->txtstatus;

            }
                $array['msg'] = '';
            return $array;
        }

        function getByIdEmpresa($id){
            $this->db->select($this->selectDefault,FALSE);
             $arrayWhere = array($this->alias.'.idEmpresa' => $id,$this->alias.'.tipo' => 0);
            $this->db->where($arrayWhere);
            $this->db->order_by($this->alias.'.id', "desc");
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $query;
            }else{
                return 0;
            }
        }

        function getAll(){
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.status' => true);
            //$this->db->where($arrayWhere);
            $this->db->order_by($this->alias.'.id', "desc");
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $query;
            }else{
                return 0;
            }
        }    

         function getAllExcelRows(){
               $id=$_SESSION["viv"]["idEmpresa"];
              $query = $this->db->query("
                SELECT 
                (select nombre from prototipos where id = idPrototipo) AS 'nombre', 
                (select titulo from paquetes where id = idPaquete) AS 'titulo' 
                FROM `material` where idEmpresa = $id ORDER BY  id  DESC");

            if($query->num_rows()>0){
                return $query;
            }else{
                return 0;
            }
        }     
    


        function getById($id){
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.id' => $id);
            $this->db->where($arrayWhere);
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $this->_populateValues($query);
            }
            else{
                return 0;
            }
        }

        function getByIdManoObra($idManoObra){
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.status' => true);
            $arrayWhere = array($this->alias.'.idManoObra' => $idManoObra);
            $this->db->where($arrayWhere);
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $this->_populateValues($query);
            }
            else{
                return 0;
            }
        }

        function getByIdFraccIdProtIdMO($idFraccionamiento, $idPrototipo, $idPaquete){
            $this->db->select($this->selectDefault, FALSE);
            $arrayWhere = array($this->alias . '.idFraccionamiento' => $idFraccionamiento, $this->alias . '.idPrototipo' => $idPrototipo, $this->alias . '.idPaquete' => $idPaquete);
            $this->db->where($arrayWhere);
            $this->db->limit(1);
            $query = $this->db->get($this->table . ' AS ' . $this->alias);
            if ($query->num_rows() > 0) {
                return $this->_populateValues($query);
            } else {
                return 0;
            }
        }

        function getByIdPaquete($idPaquete){
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.status' => true);
            $arrayWhere = array($this->alias.'.idPaquete' => $idPaquete);
            $this->db->where($arrayWhere);
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $this->_populateValues($query);
            }
            else{
                return 0;
            }
        }

    }