<?php
    class mmantenimientovehiculo extends MY_Model{

        public function __construct(){
            parent :: __construct();
            $this->table = "mantenimiento_vehiculos";
            $this->alias = 'mv';

            $this->selectDefault = "".
                $this->alias.".id
            ,".$this->alias.".idVehiculo
            ,".$this->alias.".descripcion
            ,".$this->alias.".fecha
            ,".$this->alias.".statusMantenimiento
            ,".$this->alias.".status
            ,IF(".$this->alias.".status > 0,'Activo','Inactivo') AS txtstatus";

        }


        // Populate values
        private function _populateValues($r)
        {
            $array = array(
                'id' => '',
                'idVehiculo' => '',
                'descripcion' => '',
                'fecha' => '',
                'statusMantenimiento' => '',
                'status' => '',
                'txtstatus' => ''
            );

            if (!is_numeric($r)) {
                $array['id'] = $r->row()->id;
                $array['idVehiculo'] = $r->row()->idVehiculo;
                $array['descripcion'] = $r->row()->descripcion;
                $array['fecha'] = $r->row()->fecha;
                $array['statusMantenimiento'] = $r->row()->statusMantenimiento;
                $array['status'] = $r->row()->status;
                $array['txtstatus'] = $r->row()->txtstatus;

            }
                $array['msg'] = '';
            return $array;
        }

        function getAll(){
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.status' => true);
            $this->db->where($arrayWhere);
            $this->db->order_by($this->alias.'.id', "desc");
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $query;
            }else{
                return 0;
            }
        }

        function getAllByIdV($id=null,$statusMantenimiento=null){
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.idVehiculo' => $id);
            $this->db->where($arrayWhere);
            if($statusMantenimiento!=null){
               $this->db->where($this->alias.'.statusMantenimiento = ', $statusMantenimiento); 
            } 
            $this->db->order_by($this->alias.'.id', "desc");
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $query;
            }else{
                return 0;
            }
        }

        function getById($id){
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.id' => $id);
            $this->db->where($arrayWhere);
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $this->_populateValues($query);
            }
            return 0;
        }

        function getByIdV($id,$statusMantenimiento = null,$limit=1){
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.idVehiculo' => $id); // $this->alias.'.statusMantenimiento' => 1
            $this->db->where($arrayWhere);
            if($statusMantenimiento!=null){
               $this->db->where($this->alias.'.statusMantenimiento = ', $statusMantenimiento); 
            }            
            $this->db->order_by($this->alias.'.id', 'DESC');
            $this->db->limit($limit);
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $this->_populateValues($query);
            }
            return 0;
        }

       
    }