<?php

    class Mmanoobra extends MY_Model{

        public function __construct(){
            parent :: __construct();
            $this->table = "mano_obra";
            $this->alias = 'm';

            $this->selectDefault = "".
                $this->alias.".id
            ,".$this->alias.".idFraccionamiento
            ,".$this->alias.".idPrototipo
            ,".$this->alias.".titulo
            ,".$this->alias.".tipo
            ,".$this->alias.".status
            ,IF(".$this->alias.".status > 0,'Activo','Inactivo') AS txtstatus";
        }
        // Populate values
        private function _populateValues($r)
        {
            $array = array(
                'id' => '',
                'idFraccionamiento' => '',
                'idPrototipo' => '',
                'titulo' => '',
                'tipo' => '',
                'status' => '',
                'txtstatus' => ''
            );

            if (!is_numeric($r)) {
                $array['id'] = $r->row()->id;
                $array['idFraccionamiento'] = $r->row()->idFraccionamiento;
                $array['idPrototipo'] = $r->row()->idPrototipo;
                $array['titulo'] = $r->row()->titulo;
                $array['tipo'] = $r->row()->tipo;
                $array['status'] = $r->row()->status;
                $array['txtstatus'] = $r->row()->txtstatus;

            }
                $array['msg'] = '';
            return $array;
        }

        function getAll(){
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.status' => true,$this->alias.'.tipo' => 0);
            $this->db->where($arrayWhere);
            $this->db->order_by($this->alias.'.id', "desc");
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $query;
            }else{
                return 0;
            }
        }

        function getById($id){
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.id' => $id);
            $this->db->where($arrayWhere);
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $this->_populateValues($query);
            }
            else{
                return 0;
            }
        }

        function getByIdPaquete($idPaquete){
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.status' => true);
            $arrayWhere = array($this->alias.'.idPaquete' => $idPaquete);
            $this->db->where($arrayWhere);
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $this->_populateValues($query);
            }
            else{
                return 0;
            }
        }

        function getByIdFraccionamientoPrototipo($idFraccionamiento, $idPrototipo, $subQuery = false, $nameTable = '', $id = '')
        {
            $this->db->select($this->selectDefault, FALSE);
            $arrayWhere = array($this->alias . '.status' => true, $this->alias . '.idFraccionamiento' => $idFraccionamiento, $this->alias . '.idPrototipo' => $idPrototipo);
            $this->db->where($arrayWhere);
            if($subQuery == true && $nameTable != ''){
                $this->db->where($this->alias . '.id NOT IN (SELECT idManoObra FROM '. $nameTable .')');
                if(is_numeric($id)){
                    $this->db->or_where($this->alias . '.id = '. $id);
                }
            }
            $query = $this->db->get($this->table . ' AS ' . $this->alias);
            if ($query->num_rows() > 0) {
                return $query;
            } else {
                return 0;
            }
        }

        function getByNotInPaquetes()
        {
            $this->db->select($this->selectDefault, FALSE);
            $arrayWhere = array($this->alias . '.status' => true);
            $this->db->where($arrayWhere);
            $this->db->where($this->alias . '.id NOT IN (SELECT idManoObra FROM paquetes)');
            $query = $this->db->get($this->table . ' AS ' . $this->alias);
            if ($query->num_rows() > 0) {
                return $query;
            } else {
                return 0;
            }
        }
    }