<?php

    class mlineascredito extends MY_Model{

        public function __construct(){
            parent :: __construct();
            $this->table = "lineas_credito";
            $this->alias = 'lc';

            $this->selectDefault = "".
                $this->alias.".id
            ,".$this->alias.".valor
            ,".$this->alias.".titulo
            ,".$this->alias.".status
            ,".$this->alias.".created
            ,IF(".$this->alias.".status > 0,'Activo','Inactivo') AS txtstatus";
        }
        // Populate values
        private function _populateValues($r)
        {
            $array = array(
                'id' => '',
                'valor' => '',
                'titulo' => '',
                'status' => '',
                'txtstatus' => ''
            );

            if (!is_numeric($r)) {
                $array['id'] = $r->row()->id;
                $array['valor'] = $r->row()->valor;
                $array['titulo'] = $r->row()->titulo;
                $array['status'] = $r->row()->status;
                $array['created'] = $r->row()->created;
                $array['txtstatus'] = $r->row()->txtstatus;

            }
                $array['msg'] = '';
            return $array;
        }

        function getAll($id = 0, $all=false){
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.status' => true);
            $this->db->where($arrayWhere);
            $this->db->order_by($this->alias.'.id', "desc");
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $query;
            }else{
                return 0;
            }
        }

        function getById($id){
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.id' => $id);
            $this->db->where($arrayWhere);
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $this->_populateValues($query);
            }else{
                return 0;
            }
        }

    }