<?php

    class mgestoria extends MY_Model{

        public function __construct(){
            parent :: __construct();
            $this->table = "gestoria";
            $this->alias = 'ges';

            $this->selectDefault = "".
                $this->alias.".id
            ,".$this->alias.".idAltaVenta
            ,".$this->alias.".aplicaFolio
            ,".$this->alias.".numeroFolio
            ,".$this->alias.".numeroCredito
            ,".$this->alias.".numeroCredito2
            ,".$this->alias.".fechaIngreso
            ,".$this->alias.".certificadoLibertad
            ,".$this->alias.".constanciaNoAdeudo
            ,".$this->alias.".precioVentaOci
            ,".$this->alias.".montoOci
            ,".$this->alias.".subCuenta
            ,".$this->alias.".gastosTitulacion
            ,".$this->alias.".ahorroVol
            ,".$this->alias.".subsidio
            ,".$this->alias.".sumaFinal
            ,".$this->alias.".difPropioPeculioTitulacion
            ,".$this->alias.".fechaFirma
            ,".$this->alias.".ronda
            ,".$this->alias.".precioVentaOci
            ,".$this->alias.".pdf_8
            ,".$this->alias.".pdf_9
            ,".$this->alias.".pdf_10
            ,".$this->alias.".pdf_11
            ,".$this->alias.".statusGestoria
            ,".$this->alias.".fechaCambio
            ,".$this->alias.".motivoCancelacion
            ,".$this->alias.".idMotivo
            ,".$this->alias.".fechaCancelacion
            ,".$this->alias.".fechaEscritura
            ,".$this->alias.".superficieTerreno
            ,".$this->alias.".status
            ,IF(".$this->alias.".status > 0,'Activo','Inactivo') AS txtstatus";
        }
        // Populate values
        private function _populateValues($r)
        {
            $array = array(
                'id' => '',
                'idAltaVenta' => '',
                'aplicaFolio' => '',
                'numeroFolio' => '',
                'numeroCredito' => '',
                'numeroCredito2' => '',
                'fechaIngreso' => '',
                'certificadoLibertad' => '',
                'constanciaNoAdeudo' => '',
                'fechaFirma' => '',
                'ronda' => '',
                'precioVentaOci' => '',
                'montoOci' => '',
                'subCuenta' => '',
                'gastosTitulacion' => '',
                'ahorroVol' => '',
                'subsidio' => '',
                'sumaFinal' => '',
                'difPropioPeculioTitulacion' => '',
                'statusGestoria' => '',
                'fechaCambio' => '',
                'motivoCancelacion' => '',
                'idMotivo' => '',
                'fechaCancelacion' => '',
                'fechaEscritura' => '',
                'superficieTerreno' => '',
                'status' => '',
                'txtstatus' => ''
            );
            if (!is_numeric($r)) {
                $array['id'] = $r->row()->id;
                $array['idAltaVenta'] = $r->row()->idAltaVenta;
                $array['aplicaFolio'] = $r->row()->aplicaFolio;
                $array['numeroFolio'] = $r->row()->numeroFolio;
                $array['numeroCredito'] = $r->row()->numeroCredito;
                $array['numeroCredito2'] = $r->row()->numeroCredito2;
                $array['fechaIngreso'] = $r->row()->fechaIngreso;
                $array['certificadoLibertad'] = $r->row()->certificadoLibertad;
                $array['constanciaNoAdeudo'] = $r->row()->constanciaNoAdeudo;
                $array['fechaFirma'] = $r->row()->fechaFirma;
                $array['ronda'] = $r->row()->ronda;
                $array['precioVentaOci'] = $r->row()->precioVentaOci;
                $array['montoOci'] = $r->row()->montoOci;
                $array['subCuenta'] = $r->row()->subCuenta;
                $array['gastosTitulacion'] = $r->row()->gastosTitulacion;
                $array['ahorroVol'] = $r->row()->ahorroVol;
                $array['subsidio'] = $r->row()->subsidio;
                $array['sumaFinal'] = $r->row()->sumaFinal;
                $array['difPropioPeculioTitulacion'] = $r->row()->difPropioPeculioTitulacion;
                $array['statusGestoria'] = $r->row()->statusGestoria;
                $array['fechaCambio'] = $r->row()->fechaCambio;
                $array['motivoCancelacion'] = $r->row()->motivoCancelacion;
                $array['idMotivo'] = $r->row()->idMotivo;
                $array['fechaEscritura'] = $r->row()->fechaEscritura;
                $array['superficieTerreno'] = $r->row()->superficieTerreno;
                $array['status'] = $r->row()->status;
                $array['txtstatus'] = $r->row()->txtstatus;
            }
            $array['msg'] = '';
            return $array;
        }

        function getAll(){
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.status' => true);
            //$this->db->where($arrayWhere);
            $this->db->order_by($this->alias.'.id', "desc");
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $query;
            }else{
                return 0;
            }
        }

        function getById($id){
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.id' => $id);
            $this->db->where($arrayWhere);
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $this->_populateValues($query);
            }
            else{
                return 0;
            }
        }

        function getByIdAV($id){
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.idAltaVenta' => $id);
            $this->db->where($arrayWhere);
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $this->_populateValues($query);
            }
            else{
                return 0;
            }
        }

        function getIdByIdAv($id=null){
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.idAltaVenta' => $id);
            $this->db->where($arrayWhere);
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $query->row()->id;
            }
            else{
                return 0;
            }
        }

        function getRondas(){

            $this->db->distinct();

            $this->db->select($this->alias.'.ronda as id,'.$this->alias.'.ronda as titulo',FALSE);

            $this->db->where($this->alias.'.ronda > ',0);

            $this->db->where("(SELECT pdf_1 FROM alta_venta WHERE alta_venta.id = ges.idAltaVenta)<>''", NULL, FALSE);

            $this->db->where($this->alias.'.pdf_9 <> ','');

            $this->db->where($this->alias.'.pdf_15 <> ','');

            $this->db->order_by($this->alias.'.ronda','ASC');

            $query = $this->db->get($this->table.' AS '.$this->alias);

            if($query->num_rows()>0){

                return $query;
            }

            else{

                return 0;
            }
        }

        function getRondaByIdAv($id=null){

            $this->db->select($this->alias.'.ronda',FALSE);

            $arrayWhere = array($this->alias.'.idAltaVenta' => $id);

            $this->db->where($arrayWhere);

            $query = $this->db->get($this->table.' AS '.$this->alias);

            if($query->num_rows()>0){

                return $query->row()->ronda;

            }else{

                return 0;
                
            }
        }

        function getByRonda($ronda=null){

            $this->db->select($this->alias.'.id,'.$this->alias.'.idAltaVenta',FALSE);

            $arrayWhere = array($this->alias.'.ronda' => $ronda);
            
            //if($ronda>0){

                $this->db->where($arrayWhere);

            //}

            $query = $this->db->get($this->table.' AS '.$this->alias);

            if($query->num_rows()>0 && is_numeric($ronda)){

                return $query;

            }else{

                return 0;
            }
        }

    }