<?php

    class mfraccionamientoxusuario extends MY_Model{

        public function __construct(){
            parent :: __construct();
            $this->table = "fraccionamientosxusuarios";
            $this->alias = 'fu';
            $this->aliasUser = 'u';

            $this->selectDefault = "".
                $this->alias.".id
            ,".$this->alias.".idFraccionamiento
            ,".$this->alias.".idUsuario
            ,".$this->alias.".status
            ,IF(".$this->alias.".status > 0,'Activo','Inactivo') AS txtstatus";

            $this->SelectResult = "".
            $this->aliasUser.".id,"
            ."CONCAT(".$this->aliasUser.".nombre,' ',".$this->aliasUser.".apellidoP) as titulo";

            $this->SelectIds = "".
            $this->aliasUser.".id";
        }
        // Populate values
        private function _populateValues($r)
        {
            $array = array(
                'id' => '',
                'idFraccionamiento' => '',
                'idUsuario' => '',
                'status' => '',
                'txtstatus' => ''
            );

            if (!is_numeric($r)) {
                $array['id'] = $r->row()->id;
                $array['idFraccionamiento'] = $r->row()->idFraccionamiento;
                $array['idUsuario'] = $r->row()->idUsuario;
                $array['status'] = $r->row()->status;
                $array['txtstatus'] = $r->row()->txtstatus;

            }
                $array['msg'] = '';
            return $array;
        }

        function getAll(){
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.status' => true);
            //$this->db->where($arrayWhere);
            $this->db->order_by($this->alias.'.id', "desc");
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $query;
            }else{
                return 0;
            }
        }

        function getById($id){
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.id' => $id);
            $this->db->where($arrayWhere);
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $this->_populateValues($query);
            }
            else{
                return 0;
            }
        }

        function getByIdUsuario($id){
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.idUsuario' => $id);
            $this->db->where($arrayWhere);
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $query;
            }
            else{
                return 0;
            }
        }

        function getArrayFraccByIdUsuario($id){
            $idsFracc = array();
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.idUsuario' => $id);
            $this->db->where($arrayWhere);
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                $i=0;
                foreach ($query->result() as $f) {
                    # code...
                    $idsFracc[$i] = $f->idFraccionamiento;
                    $i++;
                }
                
            }
            
            return $idsFracc;

            /*else{
                return 0;
            }*/
        }

        function getTecnicaSelectResultByIdFracc($id = null){
            $this->db->select($this->SelectIds,FALSE);
            $arrayWhere = array('u.rol' => 5, $this->alias.'.idFraccionamiento' => $id, $this->alias.'.status' => true);
            $this->db->where($arrayWhere);
            $this->db->join("fraccionamientos f", "f.id=fu.idFraccionamiento");
            $this->db->join("usuarios u", "u.id=fu.idUsuario");
            $this->db->order_by($this->alias.'.id', "desc");
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $query;
            }else{
                return 0;
            }
        }

        function getGteVSelectResultByIdFracc($id = null){ //Gte. Ventas
            $this->db->select($this->SelectResult,FALSE);
            $arrayWhere = array('u.rol' => 4, $this->alias.'.idFraccionamiento' => $id, $this->alias.'.status' => true);
            $this->db->where($arrayWhere);
            $this->db->join("fraccionamientos f", "f.id=fu.idFraccionamiento");
            $this->db->join("usuarios u", "u.id=fu.idUsuario");             
            $this->db->order_by($this->alias.'.id', "desc");
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $query;
            }else{
                return 0;
            }
        }        

        function getPromotoresSelectResultByIdFracc($id = null){
            $this->db->select($this->SelectIds,FALSE);
            $arrayWhere = array('u.rol' => 2, $this->alias.'.idFraccionamiento' => $id, $this->alias.'.status' => true);
            $this->db->where($arrayWhere);
            $this->db->where($this->aliasUser.'.status =', 1);
            $this->db->join("fraccionamientos f", "f.id=fu.idFraccionamiento");
            $this->db->join("usuarios u", "u.id=fu.idUsuario");            
            $this->db->order_by($this->alias.'.id', "desc");
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $query;
            }else{
                return 0;
            }
        }

        function getBestPromedioPromotoresByIdF($id = null){
            $query = $this->db->query(
                "
                SELECT idPromotor AS id ,(SELECT nombre FROM usuarios WHERE id=idPromotor) promotor,(SUM(tiempo) / COUNT(idPromotor)) promedio FROM prospectos WHERE idFraccionamiento = $id GROUP BY idPromotor ORDER BY promedio ASC 
                "
            );
            if($query->num_rows()>0){
                return $query;
            }else{
                return 0;
            }
        }

        function getGestoriaSelectResultByIdFracc($id = null){
            $this->db->select($this->SelectIds,FALSE);
            $arrayWhere = array('u.rol' => 3, $this->alias.'.idFraccionamiento' => $id, $this->alias.'.status' => true);
            $this->db->where($arrayWhere);
            $this->db->join("fraccionamientos f", "f.id = fu.idFraccionamiento");
            $this->db->join("usuarios u", "u.id=fu.idUsuario");            
            $this->db->order_by($this->alias.'.id', "desc");
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $query;
            }else{
                return 0;
            }
        }

        function getPostventaSelectResultByIdFracc($id = null){
            $this->db->select($this->SelectIds,FALSE);
            $arrayWhere = array('u.rol' => 6, $this->alias.'.idFraccionamiento' => $id, $this->alias.'.status' => true);
            $this->db->where($arrayWhere);
            $this->db->join("fraccionamientos f", "f.id=fu.idFraccionamiento");
            $this->db->join("usuarios u", "u.id=fu.idUsuario");            
            $this->db->order_by($this->alias.'.id', "desc");
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $query;
            }else{
                return 0;
            }
        }

        function getContabilidadSelectResultByIdFracc($id = null){
            $this->db->select($this->SelectIds,FALSE);
            $arrayWhere = array('u.rol' => 7, $this->alias.'.idFraccionamiento' => $id, $this->alias.'.status' => true);
            $this->db->where($arrayWhere);
            $this->db->join("fraccionamientos f", "f.id=fu.idFraccionamiento");
            $this->db->join("usuarios u", "u.id=fu.idUsuario");            
            $this->db->order_by($this->alias.'.id', "desc");
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $query;
            }else{
                return 0;
            }
        }

        function getRolSelectResultByIdFracc($id = null,$rol = null){
            $this->db->select($this->SelectIds,FALSE);
            $arrayWhere = array('u.rol' => $rol, $this->alias.'.idFraccionamiento' => $id, $this->alias.'.status' => true);
            $this->db->where($arrayWhere);
            $this->db->join("fraccionamientos f", "f.id=fu.idFraccionamiento");
            $this->db->join("usuarios u", "u.id=fu.idUsuario");            
            $this->db->order_by($this->alias.'.id', "desc");
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $query;
            }else{
                return 0;
            }
        }
        
        function getFraccByIdUsuario($rol='')
        {
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array('u.rol' => $rol);
            $this->db->where($arrayWhere);
            $this->db->join("usuarios u", "u.id=fu.idUsuario");            
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if ( $query->num_rows() > 0 ) {
                return $query;
            }
            else {
                return 0;
            }
        }

    }