<?php
    class mestimados extends MY_Model{

        public function __construct(){
            parent :: __construct();
            $this->table = "estimados";
            $this->alias = 'e';

            $this->selectDefault = "".
                $this->alias.".id
            ,".$this->alias.".idPresupuesto
            ,".$this->alias.".idEstimaciones
            ,".$this->alias.".estimacion
            ,".$this->alias.".estimacionC
            ,".$this->alias.".status
            ,IF(".$this->alias.".status > 0,'Activo','Inactivo') AS txtstatus";
        }


        // Populate values
        private function _populateValues($r)
        {
            $array = array(
                'id' => '',
                'idPresupuesto' => '',
                'idEstimaciones' => '',
                'estimacion' => '',
                'estimacionC' => '',
                'status' => '',
            );

            if (!is_numeric($r)) {
                $array['id'] = $r->row()->id;
                $array['idPresupuesto'] = $r->row()->idPresupuesto;
                $array['idEstimaciones'] = $r->row()->idEstimaciones;
                $array['estimacion'] = $r->row()->estimacion;
                $array['estimacionC'] = $r->row()->estimacionC;
                $array['status'] = $r->row()->status;
            }
                $array['msg'] = '';
            return $array;
        }

        function getAll(){
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.status' => true);
            $this->db->where($arrayWhere);
            $this->db->order_by($this->alias.'.id', "desc");
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $query;
            }else{
                return 0;
            }
        }

        function getById($id){
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.id' => $id);
            $this->db->where($arrayWhere);
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $this->_populateValues($query);
            }
            return 0;
        }

        function getAllByIdPresupuesto($idPresupuesto){
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.idPresupuesto' => $idPresupuesto);
            $this->db->where($arrayWhere);
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $query;
            }else{
                return 0;
            }
        }

        function getAllByIdEstimaciones($idEstimaciones){
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.idEstimaciones' => $idEstimaciones);
            $this->db->where($arrayWhere);
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $query;
            }else{
                return 0;
            }
        }

        function getLotesGuardados($idPresupuesto){
            $this->db->select_sum($this->alias.'.estimacion');
            $arrayWhere = array($this->alias.'.idPresupuesto' => $idPresupuesto);
            $this->db->where($arrayWhere);
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $query->row()->estimacion;
            }else{
                return 0;
            }
        }

        function getAllInIdEstimaciones($idsEstimaciones){
            $this->db->select($this->selectDefault,FALSE);
            $this->db->where_in($this->alias.'.idEstimaciones', $idsEstimaciones);
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $query;
            }else{
                return 0;
            }
        }

        function getEstimadosDias($idEstimacion){
            $query = $this->db->query('
                SELECT e.id AS idEstimados, c.id AS idCategoria, c.clave AS claveCategoria, c.categoria AS categoria, a.id AS idActividad, a.clave AS claveActividad, a.descripcion AS actividad, e.estimados_dia
                FROM estimados AS e INNER JOIN presupuesto_mo AS p ON e.idPresupuesto = p.id
                INNER JOIN actividadesprototipo AS ap ON p.idActividadPrototipo = ap.id
                INNER JOIN actividades_mo AS a ON ap.idActividad = a.id
                INNER JOIN categorias_mo AS c ON a.idCategoria = c.id
                WHERE e.idEstimaciones = '.$idEstimacion.'
            ');
            if($query->num_rows()>0){
                return $query;
            }else{
                return 0;
            }
        }
    }
    
    ?>