<?php
    class Mestimacionesprograma extends MY_Model{

        public function __construct(){
            parent :: __construct();
            $this->table = "estimaciones_programa";
            $this->alias = 'e';

            $this->selectDefault = "".
                $this->alias.".id
            ,".$this->alias.".idEstimacion
            ,".$this->alias.".nEstimacion
            ,".$this->alias.".fecha
            ,".$this->alias.".tipo
            ,".$this->alias.".status
            ,IF(".$this->alias.".status > 0,'Activo','Inactivo') AS txtstatus";
        }


        // Populate values
        private function _populateValues($r)
        {
            $array = array(
                'id' => '',
                'idEstimacion' => '',
                'nEstimacion' => '',
                'fecha' => '',
                'tipo' => '',
                'status' => '',
            );

            if (!is_numeric($r)) {
                $array['id'] = $r->row()->id;
                $array['idEstimacion'] = $r->row()->idEstimacion;
                $array['nEstimacion'] = $r->row()->nEstimacion;
                $array['fecha'] = $r->row()->fecha;
                $array['tipo'] = $r->row()->tipo;
                $array['status'] = $r->row()->status;
            }

            $array['msg'] = '';
            return $array;
        }

        function getAll(){
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.status' => true);
            $this->db->where($arrayWhere);
            $this->db->order_by($this->alias.'.id', "desc");
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $query;
            }else{
                return 0;
            }
        }

         function getById($id){
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.id' => $id);
            $this->db->where($arrayWhere);
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $this->_populateValues($query);
            }
            return 0;
        }

        function getByIdEstimacion($idEstimacion){
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.idEstimacion' => $idEstimacion);
            $this->db->where($arrayWhere);
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $query;
            }else{
                return 0;
            }
        }

        function getLastWeekByIdEstimacion($idEstimacion){
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.idEstimacion' => $idEstimacion);
            $this->db->where($arrayWhere);
            $this->db->order_by($this->alias.'.fecha', "DESC");
            $query = $this->db->get($this->table.' AS '.$this->alias, 1);
            if($query->num_rows()>0){
                return $this->_populateValues($query);
            }else{
                return 0;
            }
        }

        function getEstimacionesAnterioresById($id){
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = $this->alias. '.nEstimacion <= (SELECT nEstimacion FROM estimaciones_programa WHERE id = ' . $id .') AND ' . $this->alias.'.idEstimacion = (SELECT idEstimacion FROM estimaciones_programa WHERE id = ' . $id . ')';
            $this->db->where($arrayWhere);
            $this->db->order_by($this->alias.'.fecha', "ASC");
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $query;
            }else{
                return 0;
            }
        }
    }