<?php

    class mentrega extends MY_Model{

        public function __construct(){
            parent :: __construct();
            $this->table = "entrega";
            $this->alias = 'e';

            $this->selectDefault = "".
                $this->alias.".id
            ,".$this->alias.".idAltaVenta
            ,".$this->alias.".fechaEntrega
            ,".$this->alias.".pdf_12
            ,".$this->alias.".pdf_13
            ,".$this->alias.".data_1
            ,".$this->alias.".data_2
            ,".$this->alias.".hidroneumatico
            ,".$this->alias.".conectoresGas
            ,".$this->alias.".calentador
            ,".$this->alias.".tarjaAcero
            ,".$this->alias.".llavesCuadroMedidor
            ,".$this->alias.".focosAhorradores
            ,".$this->alias.".statusEntrega
            ,".$this->alias.".statusPago2
            ,".$this->alias.".status
            ,IF(".$this->alias.".status > 0,'Activo','Inactivo') AS txtstatus";
        }
        // Populate values
        private function _populateValues($r)
        {
            $array = array(
                'id' => '',
                'idAltaVenta' => '',
                'fechaEntrega' => '',
                'pdf_12' => '',
                'pdf_13' => '',
                'data_1' => '',
                'data_2' => '',
                'hidroneumatico' => '',
                'conectoresGas' => '',
                'calentador' => '',
                'tarjaAcero' => '',
                'llavesCuadroMedidor' => '',
                'focosAhorradores' => '',
                'statusEntrega' => '',
                'statusPago2' => '',
                'status' => '',
                'txtstatus' => ''
            );
            if (!is_numeric($r)) {
                $array['id'] = $r->row()->id;
                $array['idAltaVenta'] = $r->row()->idAltaVenta;
                $array['fechaEntrega'] = $r->row()->fechaEntrega;
                $array['pdf_12'] = $r->row()->pdf_12;
                $array['pdf_13'] = $r->row()->pdf_13;
                $array['data_1'] = $r->row()->data_1;
                $array['data_2'] = $r->row()->data_2;
                $array['hidroneumatico'] = $r->row()->hidroneumatico;
                $array['conectoresGas'] = $r->row()->conectoresGas;
                $array['calentador'] = $r->row()->calentador;
                $array['tarjaAcero'] = $r->row()->tarjaAcero;
                $array['llavesCuadroMedidor'] = $r->row()->llavesCuadroMedidor;
                $array['focosAhorradores'] = $r->row()->focosAhorradores;
                $array['statusEntrega'] = $r->row()->statusEntrega;
                $array['statusPago2'] = $r->row()->statusPago2;
                $array['status'] = $r->row()->status;
                $array['txtstatus'] = $r->row()->txtstatus;
            }
            $array['msg'] = '';
            return $array;
        }

        function getAll(){
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.status' => true);
            //$this->db->where($arrayWhere);
            $this->db->order_by($this->alias.'.id', "desc");
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $query;
            }else{
                return 0;
            }
        }

        function getById($id){
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.id' => $id);
            $this->db->where($arrayWhere);
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $this->_populateValues($query);
            }
            else{
                return 0;
            }
        }

        function getByIdAltaVenta($id){
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.idAltaVenta' => $id);
            $this->db->where($arrayWhere);
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $this->_populateValues($query);
            }
            else{
                return 0;
            }
        }
        
        function getByIdAV($id){
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.idAltaVenta' => $id);
            $this->db->where($arrayWhere);
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $this->_populateValues($query);
            }
            else{
                return 0;
            }
        }

    }