<?php  
    class mencuestavivienda extends MY_Model {
        public function __construct() {
            parent :: __construct();
            $this->table = "encuestavivienda";
            $this->alias = 'ev';
            
            $this->selectDefault = "".
            $this->alias.".id
            ,".$this->alias.".idAltaVenta
            ,".$this->alias.".fecha
            ,".$this->alias.".tratoAsesor
            ,".$this->alias.".tratoAsesorWhy
            ,".$this->alias.".nosotros
            ,".$this->alias.".nosotrosOtro
            ,".$this->alias.".casaMuestra
            ,".$this->alias.".viviendaAdquirir
            ,".$this->alias.".tiempoTramite
            ,".$this->alias.".gradoAceptacionFracc
            ,".$this->alias.".razonEleccion
            ,".$this->alias.".mejorasVivienda
            ,".$this->alias.".mejorasfracc
            ,".$this->alias.".created
            ,".$this->alias.".condicionEntregaVivienda
            ,".$this->alias.".condicionEntregaViviendaWhy
            ,".$this->alias.".recomendacionCompra
            ,".$this->alias.".recomendacionCompraWhy
            ,".$this->alias.".status
            ,IF(".$this->alias.".status > 0,'Activo','Inactivo') AS txtstatus";
        }
        
        private function _populateValues($r) {
            $array = array(
                'id' => '',
                'idAltaVenta' => '',
                'fecha' => '',
                'tratoAsesor' => '',
                'tratoAsesorWhy' => '',
                'nosotros' => '',
                'nosotrosOtro' => '',
                'casaMuestra' => '',
                'viviendaAdquirir' => '',
                'tiempoTramite' => '',
                'gradoAceptacionFracc' => '',
                'razonEleccion' => '',
                'mejorasVivienda' => '',
                'mejorasfracc' => '',
                'created' => '',
                'condicionEntregaVivienda' => '',
                'condicionEntregaViviendaWhy' => '',
                'recomendacionCompra' => '',
                'recomendacionCompraWhy' => '',
                'status' => '',
                'txtstatus' => ''
            );

            if (!is_numeric($r)) {
                $array['id'] = $r->row()->id;
                $array['idAltaVenta'] = $r->row()->idAltaVenta;
                $array['fecha'] = $r->row()->fecha;
                $array['tratoAsesor'] = $r->row()->tratoAsesor;
                $array['tratoAsesorWhy'] = $r->row()->tratoAsesorWhy;
                $array['nosotros'] = $r->row()->nosotros;
                $array['nosotrosOtro'] = $r->row()->nosotrosOtro;
                $array['casaMuestra'] = $r->row()->casaMuestra;
                $array['viviendaAdquirir'] = $r->row()->viviendaAdquirir;
                $array['tiempoTramite'] = $r->row()->tiempoTramite;
                $array['gradoAceptacionFracc'] = $r->row()->gradoAceptacionFracc;
                $array['razonEleccion'] = $r->row()->razonEleccion;
                $array['mejorasVivienda'] = $r->row()->mejorasVivienda;
                $array['mejorasfracc'] = $r->row()->mejorasfracc;
                $array['created'] = $r->row()->created;
                $array['condicionEntregaVivienda'] = $r->row()->condicionEntregaVivienda;
                $array['condicionEntregaViviendaWhy'] = $r->row()->condicionEntregaViviendaWhy;
                $array['recomendacionCompra'] = $r->row()->recomendacionCompra;
                $array['recomendacionCompraWhy'] = $r->row()->recomendacionCompraWhy;
                $array['status'] = $r->row()->status;
                $array['txtstatus'] = $r->row()->txtstatus;
            }
            $array['msg'] = '';
            return $array;
        }
        
        function getAll() {
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.status' => true);
            // $this->db->where($arrayWhere);
            $this->db->order_by($this->alias.'.id', "desc");
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0) {
                return $query;
            }
            else { 
                return 0;
            }
        }
        
        function getById($id) {
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.id' => $id);
            $this->db->where($arrayWhere);
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $this->_populateValues($query);
            }
            else{
                return 0;
            }
        }
        
        function getByIdAltaVenta($id) {
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.idAltaVenta' => $id);
            $this->db->where($arrayWhere);
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $this->_populateValues($query);
            }
            else{
                return 0;
            }
        }
        
        function getByIdAV($id){
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.idAltaVenta' => $id);
            $this->db->where($arrayWhere);
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $this->_populateValues($query);
            }
            else{
                return 0;
            }
        }
    }
?>