<?php

    class Mdiferenciapromotor extends MY_Model{

        public function __construct(){
            parent :: __construct();
            $this->table = "diferencia_promotores";
            $this->alias = 'dp';

            $this->selectDefault = "".
                $this->alias.".id
            ,".$this->alias.".idAltaVenta
            ,".$this->alias.".idPromotor
            ,".$this->alias.".cargo
            ,".$this->alias.".abono
            ,".$this->alias.".saldo
            ,".$this->alias.".descripcion
            ,".$this->alias.".status
            ,".$this->alias.".created
            ,".$this->alias.".updated
            ,".$this->alias.".status
            ,IF(".$this->alias.".status > 0,'Activo','Inactivo') AS txtstatus";
        }

        // Populate values
        private function _populateValues($r)
        {
            $array = array(
                'id' => '',
                'idAltaVenta' => '',
                'idPromotor' => '',
                'cargo' => '',
                'abono' => '',
                'saldo' => '',
                'descripcion' => '',
                'status' => '',
                'created' => '',
                'updated' => '',
                'status' => '',
                'txtstatus' => ''
            );

            if (!is_numeric($r)) {
                $array['id'] = $r->row()->id;
                $array['idAltaVenta'] = $r->row()->idAltaVenta;
                $array['idPromotor'] = $r->row()->idPromotor;
                $array['cargo'] = $r->row()->cargo;
                $array['abono'] = $r->row()->abono;
                $array['saldo'] = $r->row()->saldo;
                $array['descripcion'] = $r->row()->descripcion;
                $array['status'] = $r->row()->status;
                $array['created'] = $r->row()->created;
                $array['updated'] = $r->row()->updated;
                $array['status'] = $r->row()->status;
                $array['txtstatus'] = $r->row()->txtstatus;

            }
                $array['msg'] = '';
            return $array;
        }


        function getAll(){
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.status' => true);
            //$this->db->where($arrayWhere);
            $this->db->order_by($this->alias.'.id', "desc");
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $query;
            }else{
                return 0;
            }
        }

        function getById($id){
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.id' => $id);
            $this->db->where($arrayWhere);
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $this->_populateValues($query);
            }
            else{
                return 0;
            }
        }

        function getByIdPromotor($id=null,$idAltaVenta=null){
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.idPromotor' => $id);
            $this->db->where($arrayWhere);
            if($idAltaVenta>0){
                $this->db->where($this->alias.'.idAltaVenta', $idAltaVenta);
            }
            $this->db->order_by($this->alias.'.id', "DESC");
            $this->db->limit(1);
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                if($query->row()->saldo > 0){
                    return 0;
                }
                return $query;
            }else{
                return 0;
            }
        }

        function getPendientes(){ // Retrieving the last record in each group - MySQL
            $query = $this->db->query("
                SELECT 
                idPromotor
                ,(SELECT CONCAT(nombre,' ',apellidoP,' ',apellidoM) FROM usuarios WHERE id = idPromotor) AS promotor
                ,(SELECT tipoPromotor FROM usuarios WHERE id = idPromotor) AS tipo
                ,saldo
                FROM diferencia_promotores
                WHERE id IN (
                    SELECT MAX(id)
                    FROM diferencia_promotores
                    GROUP BY idPromotor
                ) AND saldo < 0;
            ");
            if($query->num_rows()>0){
                return $query;
            }else{
                return 0;
            }
        }

    }