<?php

    class Mdetalleorden extends MY_Model{

        public function __construct(){
            parent :: __construct();
            $this->table = "detalle_orden";
            $this->alias = 'd';

            $this->selectDefault = "".
                $this->alias.".id
            ,".$this->alias.".idPresupuestoMat
            ,".$this->alias.".semana
            ,".$this->alias.".id_orden_compra
            ,".$this->alias.".clave_articulo
            ,".$this->alias.".id_articulo
            ,".$this->alias.".unidades
            ,".$this->alias.".precio_unitario
            ,".$this->alias.".descuento_art";
        }
        // Populate values
        private function _populateValues($r)
        {
            $array = array(
                'id' => '',
                'idPresupuestoMat' => '',
                'semana' => '',
                'id_orden_compra' => '',
                'clave_articulo' => '',
                'id_articulo' => '',
                'unidades' => '',
                'precio_unitario' => '',
                'descuento_art' => '',
                'txtstatus' => ''
            );

            if (!is_numeric($r)) {
                $array['id'] = $r->row()->id;
                $array['idPresupuestoMat'] = $r->row()->idPresupuestoMat;
                $array['semana'] = $r->row()->semana;
                $array['id_orden_compra'] = $r->row()->id_orden_compra;
                $array['clave_articulo'] = $r->row()->clave_articulo;
                $array['id_articulo'] = $r->row()->id_articulo;
                $array['unidades'] = $r->row()->unidades;
                $array['precio_unitario'] = $r->row()->precio_unitario;
                $array['descuento_art'] = $r->row()->descuento_art;
            }
                $array['msg'] = '';
            return $array;
        }

        function getAll(){
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.status' => true);
            //$this->db->where($arrayWhere);
            $this->db->order_by($this->alias.'.id', "desc");
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $query;
            }else{
                return 0;
            }
        }

        function getById($id){
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.id' => $id);
            $this->db->where($arrayWhere);
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $this->_populateValues($query);
            }
            else{
                return 0;
            }
        }

        function getCantidadByIdOrden($idOrden)
        {
            $this->db->select_sum($this->alias . '.unidades');
            $arrayWhere = array($this->alias . '.idOrden' => $idOrden);
            $this->db->where($arrayWhere);
            $query = $this->db->get($this->table . ' AS ' . $this->alias);
            if ($query->row()->unidades > 0) {
                return $query->row()->unidades;
            } else {
                return 0;
            }
        }

        function getPrecioUnitarioByIdOrden($idOrden)
        {
            $this->db->select_sum($this->alias . '.precio_unitario');
            $arrayWhere = array($this->alias . '.idOrden' => $idOrden);
            $this->db->where($arrayWhere);
            $query = $this->db->get($this->table . ' AS ' . $this->alias);
            if ($query->row()->precioUnitario > 0) {
                return $query->row()->precioUnitario;
            } else {
                return 0;
            }
        }

        function getSemanaByIdOrden($idOrden)
        {
            $this->db->select($this->alias . '.semana');
            $arrayWhere = array($this->alias . '.id_orden_compra' => $idOrden);
            $this->db->where($arrayWhere);
            $this->db->group_by($this->alias . '.semana');
            $query = $this->db->get($this->table . ' AS ' . $this->alias);
            if ($query->num_rows() > 0) {
                return $query->row()->semana;
            } else {
                return 0;
            }
        }

        function getImporteByIdOrden($idOrden)
        {
            $this->db->select('SUM('.$this->alias.'.unidades * '.$this->alias.'.precio_unitario) AS importe');
            $arrayWhere = array($this->alias . '.id_orden_compra' => $idOrden);
            $this->db->where($arrayWhere);
            $query = $this->db->get($this->table . ' AS ' . $this->alias);
            if ($query->row()->importe > 0) {
                return $query->row()->importe;
            } else {
                return 0;
            }
        }

        function valInsert($id,$idEmpresa){
            $query=$this->db->query("SELECT id FROM detalle_orden WHERE id=$id AND idEmpresa=$idEmpresa");
            return ($query->num_rows()>0) ? false : true;
        }

        function valUpdate($id,$data){
            $search="";
            foreach ($data as $key => $val) {
                switch ($key) {
                    case 'id':
                        $id=$val;
                        break;
                    default:
                        $search.=' AND '.$key.'="'.$val.'"';
                }
            }
            $query=$this->db->query("SELECT id FROM detalle_orden WHERE id=$id $search");
            return ($query->num_rows()>0) ? false : true;
        }

        function actualiza($data,$id){
            $idEmpresa=$data["idEmpresa"];
            $data['updated'] = date("Y-m-d H:i:s");
            $this->db->update($this->table, $data," id = $id AND idEmpresa=$idEmpresa ");
            return true;
        }

        function getAllByIdOrdenCASC($idOrden){
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.id_orden_compra' => $idOrden);
            $this->db->where($arrayWhere);
            $this->db->order_by($this->alias.'.id', "asc");
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $query;
            }else{
                return 0;
            }
        }
    }