<?php
    class mcoordenadas_lotes extends MY_Model{

        public function __construct(){
            parent :: __construct();
            $this->table = "coordenadas_lotes";
            $this->alias = 'cl';

            $this->selectDefault = "".
                $this->alias.".id
            ,".$this->alias.".idFraccionamiento
            ,".$this->alias.".idProyecto
            ,".$this->alias.".lote
            ,".$this->alias.".manzana
            ,".$this->alias.".coordenadas
            ,".$this->alias.".status";
        }

        // Populate values
        private function _populateValues($r)
        {
            $array = array(
                'id' => '',
                'idFraccionamiento' => '',
                'idProyecto' => '',
                'lote' => '',
                'manzana' => '',
                'coordenadas' => '',
                'status' => '',
            );

            if (!is_numeric($r)) {
                $array['id'] = $r->row()->id;
                $array['idFraccionamiento'] = $r->row()->idFraccionamiento;
                $array['idProyecto'] = $r->row()->idProyecto;
                $array['lote'] = $r->row()->lote;
                $array['manzana'] = $r->row()->manzana;
                $array['coordenadas'] = $r->row()->coordenadas;
                $array['status'] = $r->row()->status;
            }
                $array['msg'] = '';
            return $array;
        }

        function getAll(){
            $this->db->select($this->selectDefault,FALSE);
            $this->db->order_by($this->alias.'.id', "desc");
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $query;
            }else{
                return 0;
            }
        }

        function getById($id){
            $this->db->select($this->selectDefault,FALSE);
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $this->_populateValues($query);
            }else{
                return 0;
            }
        }

        function getCoordenadasByFracc($id){
            //colores
            $rojo='c9211e';
            $amarillo='ffff00';
            $verde='92d050';
            $default_color='9b9b9b';
            //Arrays de estatus
            $status1="('apartado',
                        'correccion de rfc',
                        'solicitud de avaluo',
                        'correccion de avaluo',
                        'complemento de expediente',
                        'revision de condiciones',
                        'espera de ubicacion')"; //ROJO
            $status2="('autorizado',
                        'espera de inscripcion',
                        'inscrito',
                        'ahorro voluntario',
                        'revision de condiciones',
                        'notaria',
                        'programado firma de escritura')"; //AMARILLO
            $status3="('firmado','detonado')";//VERDE
            //Subqueries base
            $statusGestoria="(SELECT statusGestoria FROM gestoria WHERE (SELECT idProyecto FROM alta_venta WHERE id=idAltaVenta)=cl.idProyecto ORDER BY id DESC LIMIT 1)";
            $statusValidacion="(SELECT statusValidacion2 FROM alta_venta av WHERE av.idProyecto=cl.idProyecto ORDER BY id DESC LIMIT 1)";
            $cond="(CASE
                WHEN ($statusGestoria IN $status3) THEN '%val3'
                WHEN (($statusValidacion IN $status2) OR ($statusGestoria IN $status2)) THEN '%val2'
                WHEN ($statusValidacion IN $status1) THEN '%val1'
            ELSE '%default'
            END) %alias";

            $titulo_status="(CASE
                WHEN ($statusGestoria IN $status3) THEN $statusGestoria
                WHEN ($statusGestoria IN $status2) THEN $statusGestoria
                WHEN ($statusValidacion IN $status2) THEN $statusValidacion
                WHEN ($statusValidacion IN $status1) THEN $statusValidacion
            ELSE 'Disponible'
            END) titulo_status";
            $idPrototipo="(SELECT idPrototipo FROM proyectos WHERE id=cl.idProyecto ORDER BY id DESC LIMIT 1)";
            
            //Armado de condiciones
            $color=str_replace(['%val1','%val2','%val3','%default','%alias'],[$rojo,$amarillo,$verde,$default_color,'color'],$cond);
            $id_status=str_replace(['%val1','%val2','%val3','%default','%alias'],['1','2','3','0','id_status'],$cond);
            $classTooltip=str_replace(['%val1','%val2','%val3','%default','%alias'],['tooltipRojo','tooltipAmarillo','tooltipVerde','tooltipGris','classTooltip'],$cond);
            $classTitle=str_replace(['%val1','%val2','%val3','%default','%alias'],['titleRojo','titleAmarillo','titleVerde','titleGris','classTitle'],$cond);
            $lte_mza="CONCAT('LOTE ',lote,' (MZA ',manzana,')') lte_mza";
            $precio="'$1,250' precio";
            $prototipo="IF($idPrototipo AND $idPrototipo>0,(SELECT nombre FROM prototipos WHERE id=$idPrototipo),'Sin asignar') prototipo";
            $query="SELECT id,idProyecto,coordenadas,$lte_mza,$id_status,$precio,$classTooltip,$titulo_status,$color,$classTitle,$prototipo FROM coordenadas_lotes cl
            WHERE idFraccionamiento=$id";
            //echo $query;
            //exit();
            $query=$this->db->query($query);
            if($query->num_rows()>0){
                return $query;
            }else{
                return 0;
            }
        }

        function getCoordenadasByFraccObra($id){
            //colores
            $rojo='c9211e';
            $amarillo='ffff00';
            $verde='92d050';
            $naranja='f44611';
            $azul='06aeff';
            $default_color='9b9b9b';

            $cond="        
            (CASE
            WHEN ent.statusEntrega=1 THEN '%val5'
            WHEN (SELECT tipo FROM logs_notifications ln WHERE ln.idProyecto=cl.idProyecto AND ln.tipo='entrega' LIMIT 1)='entrega'  THEN '%val4'
            WHEN (SELECT tipo FROM logs_notifications ln WHERE ln.idProyecto=cl.idProyecto AND ln.tipo='acabados' LIMIT 1)='acabados' THEN '%val3'
            WHEN (SELECT tipo FROM logs_notifications ln WHERE ln.idProyecto=cl.idProyecto AND ln.tipo='obra negra' LIMIT 1)='obra negra' THEN '%val2'
            WHEN (arr.estatus_arranque AND arr.estatus_arranque > 0) THEN '%val1'
            ELSE '%default' 
            END) '%alias'";

            //Armado de condiciones
            $color=str_replace(['%val1','%val2','%val3','%val4','%val5','%default','%alias'],[$rojo,$azul,$amarillo,$naranja,$verde,$default_color,'color'],$cond);
            $titulo_status=str_replace(['%val1','%val2','%val3','%val4','%val5','%default','%alias'],['Arranque','Obra Negra','Acabados','Equipamiento','Entregado','Disponible','titulo_status'],$cond);
            $id_status=str_replace(['%val1','%val2','%val3','%val4','%val5','%default','%alias'],['1','2','3','4','5',0,'id_status'],$cond);
            $classTooltip=str_replace(['%val1','%val2','%val3','%val4','%val5','%default','%alias'],['tooltipRojo','tooltipAzul','tooltipAmarillo','tooltipNaranja','tooltipVerde','tooltipGris','classTooltip'],$cond);
            $classTitle=str_replace(['%val1','%val2','%val3','%val4','%val5','%default','%alias'],['titleRojo','titleAzul','titleAmarillo','titleNaranja','titleVerde','titleGris','classTitle'],$cond);

            $lte_mza="CONCAT('LOTE ',cl.lote,' (MZA ',cl.manzana,')') lte_mza";
            $precio="'$1,250' precio";
            $prototipo="IF(pro.idPrototipo AND pro.idPrototipo>0,(SELECT nombre FROM prototipos WHERE id=pro.idPrototipo),'Sin asignar') prototipo";

            $query="SELECT cl.id,dp.idPaquete,cl.idProyecto,$lte_mza,$id_status,$precio,$classTooltip,$titulo_status,$color,$classTitle,$prototipo,
            cl.coordenadas
            FROM coordenadas_lotes cl 
            LEFT JOIN proyectos pro ON pro.id=cl.idProyecto 
            LEFT JOIN detalle_paquete dp ON dp.idProyecto=cl.idProyecto 
            LEFT JOIN paquetes paq ON paq.id=dp.idPaquete 
            LEFT JOIN arranque arr ON FIND_IN_SET(dp.idPaquete,arr.idPaquetes)
            LEFT JOIN alta_venta av ON av.idProyecto=cl.idProyecto AND av.status=1 
            LEFT JOIN entrega ent ON ent.idAltaVenta=av.id
            WHERE cl.idFraccionamiento=$id";
            //echo $query;
            //exit();
            $query=$this->db->query($query);
            if($query->num_rows()>0){
                return $query;
            }else{
                return 0;
            }
        }
}