<?php

    class mcontadocuentas extends MY_Model{

        public function __construct(){
            parent :: __construct();
            $this->table = "contado_cuentas";
            $this->alias = 'cc';

            $this->selectDefault = "".
                $this->alias.".id
            ,".$this->alias.".idAltaVenta
            ,".$this->alias.".fecha
            ,".$this->alias.".monto
            ,".$this->alias.".saldo
            ,".$this->alias.".plazos
            ,".$this->alias.".pagos
            ,".$this->alias.".interes
            ,".$this->alias.".statusCuenta
            ,".$this->alias.".statusObra
            ,".$this->alias.".status
            ,IF(".$this->alias.".status > 0,'Activo','Inactivo') AS txtstatus";
        }

        // Populate values
        private function _populateValues($r)
        {
            $array = array(
                'id' => '',
                'idAltaVenta' => '',
                'fecha' => '',
                'monto' => '',
                'saldo' => '',
                'plazos' => '',
                'pagos' => '',
                'interes' => '',
                'statusCuenta' => '',
                'statusObra' => '',
                'status' => '',
                'txtstatus' => ''
            );
            
            if (!is_numeric($r)) {
                $array['id'] = $r->row()->id;
                $array['idAltaVenta'] = $r->row()->idAltaVenta;
                $array['fecha'] = $r->row()->fecha;
                $array['monto'] = $r->row()->monto;
                $array['saldo'] = $r->row()->saldo;
                $array['plazos'] = $r->row()->plazos;
                $array['pagos'] = $r->row()->pagos;
                $array['interes'] = $r->row()->interes;
                $array['statusCuenta'] = $r->row()->statusCuenta;
                $array['statusObra'] = $r->row()->statusObra;
                $array['status'] = $r->row()->status;
                $array['txtstatus'] = $r->row()->txtstatus;
            }
            $array['msg'] = '';
            return $array;
        }

        function getAll(){
            $this->db->select($this->selectDefault,FALSE);
         /*   $arrayWhere = array($this->alias.'.id' => $id);
            $this->db->where($arrayWhere);*/
            $this->db->order_by($this->alias.'.id', "desc");
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows() > 0){
                return $query;
            }
            else{
                return 0;
            }
        }

        function getById($id){
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.id' => $id);
            $this->db->where($arrayWhere);
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $this->_populateValues($query);
            }
            else{
                return 0;
            }
        }
        
        function getByIdAV($id){
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.idAltaVenta' => $id);
            $this->db->where($arrayWhere);
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $this->_populateValues($query);
            }
            else{
                return 0;
            }
        }
    }