<?php
    class Mcomisionesfraccionamientos extends MY_Model{

        public function __construct(){
            parent :: __construct();
            $this->table = "comisiones_fraccionamientos";
            $this->alias = 'c';

            $this->selectDefault = "".
                $this->alias.".id
            ,".$this->alias.".idFraccionamiento
            ,".$this->alias.".porcentajeComision
            ,".$this->alias.".status
            ,IF(".$this->alias.".status > 0,'Activo','Inactivo') AS txtstatus";

        }


        // Populate values
        private function _populateValues($r)
        {
            $array = array(
                'id' => '',
                'idFraccionamiento' => '',
                'porcentajeComision' => '',
                'status' => '',
            );

            if (!is_numeric($r)) {
                $array['id'] = $r->row()->id;
                $array['idFraccionamiento'] = $r->row()->idFraccionamiento;
                $array['porcentajeComision'] = $r->row()->porcentajeComision;
                $array['status'] = $r->row()->status;
            }
            return $array;
        }

        function getAll(){
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.status' => true);
            //$this->db->where($arrayWhere);
            $this->db->order_by($this->alias.'.id', "asc");
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $query;
            }else{
                return 0;
            }
        }

         function getById($id){
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.id' => $id);
            $this->db->where($arrayWhere);
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $this->_populateValues($query);
            }
            return 0;
        }

        function getByIdFraccionamiento($idFraccionamiento){
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.idFraccionamiento' => $idFraccionamiento);
            $this->db->where($arrayWhere);
            //$this->db->order_by($this->alias.'.id', "asc");
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $this->_populateValues($query);
            }else{
                return 0;
            }
        }

        function getByIdFraccionamiento2($idFraccionamiento){
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.idFraccionamiento' => $idFraccionamiento, $this->alias.'.status' => true);
            $this->db->where($arrayWhere);
            //$this->db->order_by($this->alias.'.id', "asc");
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $query;
            }else{
                return 0;
            }
        }

    }