<?php

    class mcomisiones extends MY_Model{

        public function __construct(){
            parent :: __construct();
            $this->table = "comisiones";
            $this->alias = 'co';

            $this->selectDefault = "".
                $this->alias.".id
            ,".$this->alias.".idAltaVenta
            ,".$this->alias.".fechaDetonacion
            ,".$this->alias.".precioVenta
            ,".$this->alias.".tipoComision
            ,".$this->alias.".porcentajeComision
            ,".$this->alias.".comision
            ,".$this->alias.".porcentajePago1
            ,".$this->alias.".pago1
            ,".$this->alias.".porcentajeImptoPago1
            ,".$this->alias.".imptoPago1
            ,".$this->alias.".totalPago1
            ,".$this->alias.".fechaPago1
            ,".$this->alias.".statusAutorizacionPago1
            ,".$this->alias.".fechaAutorizacionPago1
            ,".$this->alias.".saldo
            ,".$this->alias.".diferenciaAsesorPago1
            ,".$this->alias.".formaPago1
            ,".$this->alias.".porcentajeComisionAjuste
            ,".$this->alias.".comisionAjuste
            ,".$this->alias.".porcentajeAjuste
            ,".$this->alias.".ajuste
            ,".$this->alias.".porcentajeImptoAjuste
            ,".$this->alias.".imptoAjuste
            ,".$this->alias.".totalAjuste
            ,".$this->alias.".fechaAjuste
            ,".$this->alias.".statusAutorizacionAjuste
            ,".$this->alias.".fechaAutorizacionAjuste
            ,".$this->alias.".saldoAjuste
            ,".$this->alias.".diferenciaAsesorAjuste
            ,".$this->alias.".formaPagoAjuste
            ,".$this->alias.".porcentajePago2
            ,".$this->alias.".pago2
            ,".$this->alias.".porcentajeImptoPago2
            ,".$this->alias.".imptoPago2
            ,".$this->alias.".totalPago2
            ,".$this->alias.".fechaPago2
            ,".$this->alias.".statusAutorizacionPago2
            ,".$this->alias.".fechaAutorizacionPago2
            ,".$this->alias.".diferenciaAsesorPago2
            ,".$this->alias.".formaPago2
            ,".$this->alias.".statusEntrega
            ,".$this->alias.".asistioEntregaAsesor
            ,".$this->alias.".status
            ,IF(".$this->alias.".status > 0,'Activo','Inactivo') AS txtstatus";
        }

        // Populate values
        private function _populateValues($r)
        {
            $array = array(
                'id' => '',
                'idAltaVenta' => '',
                'fechaDetonacion' => '',
                'precioVenta' => '',
                'tipoComision' => '',
                'porcentajeComision' => '',
                'comision' => '',
                'porcentajePago1' => '',
                'pago1' => '',
                'porcentajeImptoPago1' => '',
                'imptoPago1' => '',
                'totalPago1' => '',
                'fechaPago1' => '',
                'statusAutorizacionPago1' => '',
                'fechaAutorizacionPago1' => '',
                'saldo' => '',
                'diferenciaAsesorPago1' => '',
                'formaPago1' => '',
                'porcentajeComisionAjuste' => '',
                'comisionAjuste' => '',
                'porcentajeAjuste' => '',
                'ajuste' => '',
                'porcentajeImptoAjuste' => '',
                'imptoAjuste' => '',
                'totalAjuste' => '',
                'fechaAjuste' => '',
                'statusAutorizacionAjuste' => '',
                'fechaAutorizacionAjuste' => '',
                'saldoAjuste' => '',
                'diferenciaAsesorAjuste' => '',
                'formaPagoAjuste' => '',
                'porcentajePago2' => '',
                'pago2' => '',
                'porcentajeImptoPago2' => '',
                'imptoPago2' => '',
                'totalPago2' => '',
                'fechaPago2' => '',
                'statusAutorizacionPago2' => '',
                'fechaAutorizacionPago2' => '',
                'diferenciaAsesorPago2' => '',
                'formaPago2' => '',
                'statusEntrega' => '',
                'asistioEntregaAsesor' => '',
                'status' => '',
                'txtstatus' => ''
            );
            if (!is_numeric($r)) {
                $array['id'] = $r->row()->id;
                $array['idAltaVenta'] = $r->row()->idAltaVenta;
                $array['fechaDetonacion'] = $r->row()->fechaDetonacion;
                $array['precioVenta'] = $r->row()->precioVenta;
                $array['tipoComision'] = $r->row()->tipoComision;
                $array['porcentajeComision'] = $r->row()->porcentajeComision;
                $array['comision'] = $r->row()->comision;
                $array['porcentajePago1'] = $r->row()->porcentajePago1;
                $array['pago1'] = $r->row()->pago1;
                $array['porcentajeImptoPago1'] = $r->row()->porcentajeImptoPago1;
                $array['imptoPago1'] = $r->row()->imptoPago1;
                $array['totalPago1'] = $r->row()->totalPago1;
                $array['fechaPago1'] = $r->row()->fechaPago1;
                $array['statusAutorizacionPago1'] = $r->row()->statusAutorizacionPago1;
                $array['fechaAutorizacionPago1'] = $r->row()->fechaAutorizacionPago1;
                $array['saldo'] = $r->row()->saldo;
                $array['diferenciaAsesorPago1'] = $r->row()->diferenciaAsesorPago1;
                $array['formaPago1'] = $r->row()->formaPago1;
                $array['porcentajeComisionAjuste'] = $r->row()->porcentajeComisionAjuste;
                $array['comisionAjuste'] = $r->row()->comisionAjuste;
                $array['porcentajeAjuste'] = $r->row()->porcentajeAjuste;
                $array['ajuste'] = $r->row()->ajuste;
                $array['porcentajeImptoAjuste'] = $r->row()->porcentajeImptoAjuste;
                $array['imptoAjuste'] = $r->row()->imptoAjuste;
                $array['totalAjuste'] = $r->row()->totalAjuste;
                $array['fechaAjuste'] = $r->row()->fechaAjuste;
                $array['statusAutorizacionAjuste'] = $r->row()->statusAutorizacionAjuste;
                $array['fechaAutorizacionAjuste'] = $r->row()->fechaAutorizacionAjuste;
                $array['saldoAjuste'] = $r->row()->saldoAjuste;
                $array['diferenciaAsesorAjuste'] = $r->row()->diferenciaAsesorAjuste;
                $array['formaPagoAjuste'] = $r->row()->formaPagoAjuste;
                $array['porcentajePago2'] = $r->row()->porcentajePago2;
                $array['pago2'] = $r->row()->pago2;
                $array['porcentajeImptoPago2'] = $r->row()->porcentajeImptoPago2;
                $array['imptoPago2'] = $r->row()->imptoPago2;
                $array['totalPago2'] = $r->row()->totalPago2;
                $array['fechaPago2'] = $r->row()->fechaPago2;
                $array['statusAutorizacionPago2'] = $r->row()->statusAutorizacionPago2;
                $array['fechaAutorizacionPago2'] = $r->row()->fechaAutorizacionPago2;
                $array['diferenciaAsesorPago2'] = $r->row()->diferenciaAsesorPago2;
                $array['formaPago2'] = $r->row()->formaPago2;
                $array['statusEntrega'] = $r->row()->statusEntrega;
                $array['asistioEntregaAsesor'] = $r->row()->asistioEntregaAsesor;
                $array['status'] = $r->row()->status;
                $array['txtstatus'] = $r->row()->txtstatus;
            }
            $array['msg'] = '';
            return $array;
        }



        function getAll(){
            $info = (isset($_REQUEST['info'])) ? $_REQUEST['info'] : 0;
            $andFilter = '';
            if(!is_numeric($info)){
                $fecha_inicio = '';
                $fecha_fin = '';
                foreach ($info as $key => $val) {
                    if($val != "" AND $val != 0){
                        switch($key){
                            case 'fecha_inicio': 
                                $fecha_inicio = date_format(new DateTime($val),"Y-m-d");
                                break;
                            case 'fecha_fin': 
                                $fecha_fin = date_format(new DateTime($val),"Y-m-d");
                                if ($fecha_inicio != "" && $fecha_fin != "") {
                                    if($fecha_inicio != $fecha_fin){
                                        $andFilter .=" fechaDetonacion >= '$fecha_inicio' AND fechaDetonacion <= '$fecha_fin' + INTERVAL 1 DAY ";
                                    }else{
                                        $andFilter .=" DATE(fechaDetonacion) = DATE('$fecha_inicio') ";
                                    }
                                }
                                break;
                        }
                    }
                }
            }
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.status' => true);
            $this->db->where($arrayWhere);
            if($andFilter != ''){
                $this->db->where($andFilter);
            }
            $this->db->order_by($this->alias.'.id', "desc");
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $query;
            }else{
                return 0;
            }
        }

        function getById($id){
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.id' => $id);
            $this->db->where($arrayWhere);
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $this->_populateValues($query);
            }
            else{
                return 0;
            }
        }
        
        function getByIdAV($id){
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.idAltaVenta' => $id);
            $this->db->where($arrayWhere);
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $this->_populateValues($query);
            }
            else{
                return 0;
            }
        }


        function getVentasMes($idPromotor=null,$fechaVenta=null){
            $query = $this->db->query(
                "
                SELECT 
                av.id
                ,av.idProyecto
                ,av.idProspecto
                ,av.fechaVenta
                FROM alta_venta AS av
                JOIN prospectos AS pros ON pros.id = av.idProspecto
                JOIN proyectos AS proy ON proy.id = av.idProyecto
                JOIN gestoria AS ges ON ges.idAltaventa = av.id
                WHERE av.statusValidacion>=4 
                AND proy.statusVenta = 3
                AND ges.statusGestoria = 'detonado'
                AND YEAR(av.fechaVenta) = YEAR('".$fechaVenta."') -- CURRENT_DATE() 
                AND MONTH(av.fechaVenta) = MONTH('".$fechaVenta."') -- CURRENT_DATE()
                AND pros.idPromotor = ".$idPromotor."

                "
            );

            if($query->num_rows()>0){
                return $query->num_rows();
            }
            else{
                return 0;
            }
        }

        public function getComisionesInsert($id=null){
            $and = ($id > 0) ? " AND alta_venta.id = ".$id:"";
            $query=$this->db->query('
                SELECT 
                    fechaVenta AS "statusPago",
                    id,
                    idProyecto,
                    idProspecto,
                    (SELECT lineaCredito FROM proyectos WHERE id=idProyecto)  AS "tCred",
                    (SELECT ronda FROM gestoria WHERE idAltaVenta = alta_venta.id) AS "ronda",
                    (SELECT idPromotor FROM prospectos WHERE id=idProspecto) AS "idPromotor",
                    (SELECT tipoPromotor FROM usuarios WHERE id = (SELECT idPromotor FROM prospectos WHERE id=idProspecto)) AS "tipoPromotor",
                    (SELECT UPPER(CONCAT(nombre," ",apellidoP," ",apellidoM)) FROM usuarios WHERE id=(SELECT idPromotor FROM prospectos WHERE id=idProspecto)) AS "promotor",
                    (SELECT UPPER(CONCAT(nombre," ",apellidoP," ",apellidoM)) FROM prospectos WHERE id=idProspecto) AS "cliente",
                    (SELECT UPPER(titulo) FROM fraccionamientos WHERE id = (SELECT idFraccionamiento FROM proyectos WHERE id = idProyecto)) AS "fraccionamiento",
                    (SELECT manzana FROM proyectos WHERE id=idProyecto) AS "manzana",
                    (SELECT lote FROM proyectos WHERE id=idProyecto) AS "lote",
                    UPPER(tipoCredito) AS "tCred2",
                    (SELECT precioVenta FROM proyectos WHERE id=idProyecto) AS "pVenta"
                FROM 
                    alta_venta
                WHERE 
                    statusValidacion >= 4
                    AND status=1
                    AND (SELECT status FROM fraccionamientos WHERE status=1 AND id= (SELECT idFraccionamiento FROM proyectos WHERE id=idProyecto))
                    AND idProyecto>0
                    AND ((SELECT idAltaVenta FROM entrega WHERE entrega.idAltaVenta = alta_venta.id AND statusPago2=0) OR (alta_venta.id NOT IN (SELECT idAltaVenta FROM comisiones_bonos WHERE comisiones_bonos.idAltaVenta = alta_venta.id) AND statusValidacion >= 4 AND CAST(fechaVenta AS CHAR(10))!="0000-00-00" AND CAST(fechaVenta AS CHAR(1))!=""))
                    AND id IN (SELECT idAltaVenta FROM comisiones)

                '.$and.' 
            ');

            if($query->num_rows() > 0){
                return $query;
            }else{
                return 0;
            }
        }

        public function getAllServerSide()
        {
            $info = (isset($_REQUEST['info'])) ? $_REQUEST['info'] : 0;
            $andFilter = '';
            if(!is_numeric($info)){
                $fecha_inicio = '';
                $fecha_fin = '';
                foreach ($info as $key => $val) {
                    if($val != "" AND $val != 0){
                        switch($key){
                            case 'fecha_inicio': 
                                $fecha_inicio = date_format(new DateTime($val),"Y-m-d");
                                break;
                            case 'fecha_fin': 
                                $fecha_fin = date_format(new DateTime($val),"Y-m-d");
                                if ($fecha_inicio != "" && $fecha_fin != "") {
                                    if($fecha_inicio != $fecha_fin){
                                        $andFilter .=" fechaDetonacion >= '$fecha_inicio' AND fechaDetonacion <= '$fecha_fin' + INTERVAL 1 DAY ";
                                    }else{
                                        $andFilter .=" DATE(fechaDetonacion) = DATE('$fecha_inicio') ";
                                    }
                                }
                                break;
                        }
                    }
                }
            }
            $select = '
                co.*,
                (SELECT fechaVenta FROM alta_venta WHERE id = co.idAltaVenta) AS statusPago,
                (SELECT idProyecto FROM alta_venta WHERE id = co.idAltaVenta) AS idProyecto,
                (SELECT idProspecto FROM alta_venta WHERE id = co.idAltaVenta) AS idProspecto,
                (SELECT lineaCredito FROM proyectos WHERE id=(SELECT idProyecto FROM alta_venta WHERE id = co.idAltaVenta)) AS tCred,
                (SELECT ronda FROM gestoria WHERE idAltaVenta = co.idAltaVenta) AS ronda,
                (SELECT idPromotor FROM prospectos WHERE id=(SELECT idProspecto FROM alta_venta WHERE id = co.idAltaVenta)) AS idPromotor,
                (SELECT tipoPromotor FROM usuarios WHERE id = (SELECT idPromotor FROM prospectos WHERE id=(SELECT idProspecto FROM alta_venta WHERE id = co.idAltaVenta))) AS tipoPromotor,
                (SELECT UPPER(CONCAT(nombre," ",apellidoP," ",apellidoM)) FROM usuarios WHERE id=(SELECT idPromotor FROM prospectos WHERE id=(SELECT idProspecto FROM alta_venta WHERE id = co.idAltaVenta))) AS promotor,
                (SELECT UPPER(CONCAT(nombre," ",apellidoP," ",apellidoM)) FROM prospectos WHERE id=(SELECT idProspecto FROM alta_venta WHERE id = co.idAltaVenta)) AS cliente,
                (SELECT UPPER(titulo) FROM fraccionamientos WHERE id = (SELECT idFraccionamiento FROM proyectos WHERE id = (SELECT idProyecto FROM alta_venta WHERE id = co.idAltaVenta))) AS fraccionamiento,
                (SELECT manzana FROM proyectos WHERE id=(SELECT idProyecto FROM alta_venta WHERE id = co.idAltaVenta)) AS manzana,
                (SELECT lote FROM proyectos WHERE id=(SELECT idProyecto FROM alta_venta WHERE id = co.idAltaVenta)) AS lote,
                (SELECT UPPER(tipoCredito) FROM alta_venta WHERE id = co.idAltaVenta) AS tCred2,
                (SELECT precioVenta FROM proyectos WHERE id=(SELECT idProyecto FROM alta_venta WHERE id = co.idAltaVenta)) AS pVenta
            ';
            $this->db->select($select,FALSE);
            $arrayWhere = array($this->alias.'.status' => true);
            $this->db->where($arrayWhere);
            if($andFilter != ''){
                $this->db->where($andFilter);
            }
            $draw = intval($_POST['draw']);
            $start = intval($_POST['start']);
            $length = intval($_POST['length']);
            $order = (isset($_POST['order'])) ? $_POST['order'] : '';
            $search= $_POST['search'];
            $search = $search['value'];
            $col = 0;
            $dir = "";

            if(!empty($order)){
                foreach($order as $o)
                {
                    $col = $o['column'];
                    $dir= $o['dir'];
                }

            }

            if($dir != "asc" && $dir != "desc")
            {
                $dir = "desc";
            }

            $valid_columns_order = array(
                0=>'co.fechaDetonacion',
                1=>'tCred',
                2=>'promotor',
                3=>'cliente',
                4=>'fraccionamiento',
                5=>'ronda',
                6=>'manzana',
                7=>'lote',
                8=>'precioVenta',
                9=>'co.porcentajeComision',
                10=>'co.comision',
                11=>'co.pago1',
                12=>'co.imptoPago1',
                13=>'co.diferenciaAsesorPago1',
                14=>'co.totalPago1',
                15=>'co.fechaPago1',
                16=>'co.formaPago1',
                19=>'co.porcentajeComisionAjuste',
                20=>'co.comisionAjuste',
                21=>'co.ajuste',
                22=>'co.imptoAjuste',
                23=>'co.diferenciaAsesorAjuste',
                24=>'co.totalAjuste',
                25=>'co.formaPagoAjuste',
                28=>'co.pago2',
                29=>'co.imptoPago2',
                30=>'co.diferenciaAsesorPago2',
                31=>'co.totalPago2',
                32=>'co.fechaPago2',
                33=>'co.formaPago2',
            );

            $valid_columns = array(
                0=>'co.id',
                1=>'co.fechaDetonacion',
                2=>'(SELECT lineaCredito FROM proyectos WHERE id=(SELECT idProyecto FROM alta_venta WHERE id = co.idAltaVenta))',
                3=>'(SELECT UPPER(CONCAT(nombre," ",apellidoP," ",apellidoM)) FROM usuarios WHERE id=(SELECT idPromotor FROM prospectos WHERE id=(SELECT idProspecto FROM alta_venta WHERE id = co.idAltaVenta)))',
                4=>'(SELECT UPPER(CONCAT(nombre," ",apellidoP," ",apellidoM)) FROM prospectos WHERE id=(SELECT idProspecto FROM alta_venta WHERE id = co.idAltaVenta))',
                5=>'(SELECT UPPER(titulo) FROM fraccionamientos WHERE id = (SELECT idFraccionamiento FROM proyectos WHERE id = (SELECT idProyecto FROM alta_venta WHERE id = co.idAltaVenta)))',
                6=>'(SELECT ronda FROM gestoria WHERE idAltaVenta = (SELECT id FROM alta_venta WHERE id = co.idAltaVenta))',
                7=>'(SELECT manzana FROM proyectos WHERE id=(SELECT idProyecto FROM alta_venta WHERE id = co.idAltaVenta))',
                8=>'(SELECT lote FROM proyectos WHERE id=(SELECT idProyecto FROM alta_venta WHERE id = co.idAltaVenta))',
                9=>'(SELECT precioVenta FROM proyectos WHERE id=(SELECT idProyecto FROM alta_venta WHERE id = co.idAltaVenta))',
                10=>'(SELECT precioVenta FROM proyectos WHERE id=(SELECT idProyecto FROM alta_venta WHERE id = co.idAltaVenta))',
                11=>'co.porcentajeComision',
                12=>'co.comision',
                13=>'co.pago1',
                14=>'co.imptoPago1',
                15=>'co.totalPago1',
                16=>'co.fechaPago1',
                17=>'co.statusAutorizacionPago1',
                18=>'co.saldo',
                19=>'co.porcentajeComisionAjuste',
                20=>'co.comisionAjuste',
                21=>'co.ajuste',
                22=>'co.imptoAjuste',
                23=>'co.totalAjuste',
                24=>'co.statusAutorizacionAjuste',
                25=>'co.saldoAjuste',
                26=>'co.pago2',
                27=>'co.imptoPago2',
                28=>'co.totalPago2',
                29=>'co.fechaPago2',
                30=>'co.statusAutorizacionPago2',
            );

            if(!isset($valid_columns_order[$col]))
            {
                $order = null;
            }else{
                $order = $valid_columns_order[$col];
            }

            if($order !=null)
            {
                $this->db->order_by($order, $dir);
            }else{
                $this->db->order_by($this->alias.'.id', "desc");
            }

            if(!empty($search))
            {
                $x=0;
                foreach($valid_columns as $sterm)
                {
                    if($x==0)
                    {
                        $this->db->like($sterm,$search);
                    }
                    else
                    {
                        $this->db->or_like($sterm,$search);
                    }
                    $x++;
                }                 
            }

            if($length > -1){
                $this->db->limit($length,$start);
            }
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if ($query->num_rows() > 0){
                return $query;
            } else {
                return 0;
            }
        }
    }