<?php

    class mcomisionbono extends MY_Model{

        public function __construct(){
            parent :: __construct();
            $this->table = "comisiones_bonos";
            $this->alias = 'cb';

            $this->selectDefault = "".
                $this->alias.".id
            ,".$this->alias.".idAltaVenta
            ,".$this->alias.".difPropioPeculio
            ,".$this->alias.".resultado
            ,".$this->alias.".saldo
            ,".$this->alias.".cierre
            ,".$this->alias.".importeComision
            ,".$this->alias.".netoVenta
            ,".$this->alias.".diferenciaVendedor
            ,".$this->alias.".status
            ,IF(".$this->alias.".status > 0,'Activo','Inactivo') AS txtstatus";
        }
        // Populate values
        private function _populateValues($r)
        {
            $array = array(
                'id' => '',
                'idAltaVenta' => '',
                'resultado' => '',
                'saldo' => '',
                'cierre' => '',
                'importeComision' => '',
                'netoVenta' => '',
                'diferenciaVendedor' => '',
                'status' => '',
                'txtstatus' => ''
            );
            if (!is_numeric($r)) {
                $array['id'] = $r->row()->id;
                $array['idAltaVenta'] = $r->row()->idAltaVenta;
                $array['difPropioPeculio'] = $r->row()->difPropioPeculio;
                $array['resultado'] = $r->row()->resultado;
                $array['saldo'] = $r->row()->saldo;
                $array['cierre'] = $r->row()->cierre;
                $array['importeComision'] = $r->row()->importeComision;
                $array['netoVenta'] = $r->row()->netoVenta;
                $array['diferenciaVendedor'] = $r->row()->diferenciaVendedor;
                $array['status'] = $r->row()->status;
                $array['txtstatus'] = $r->row()->txtstatus;
            }
            $array['msg'] = '';
            return $array;
        }

        function getAll(){
            $query = $this->db->query("SELECT * FROM alta_venta,comisiones_bonos,proyectos WHERE
            comisiones_bonos.idAltaVenta=alta_venta.id AND alta_venta.idProyecto=proyectos.id AND proyectos.idFraccionamiento=".$_SESSION['viv']['idFraccionamiento']);
            if($query->num_rows()>0){
                return $query;
            }else{
                return 0;
            }
        }

        function getById($id){
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.id' => $id);
            $this->db->where($arrayWhere);
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $this->_populateValues($query);
            }
            else{
                return 0;
            }
        }
        
        function getByIdAV($id){
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.idAltaVenta' => $id);
            $this->db->where($arrayWhere);
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $this->_populateValues($query);
            }
            else{
                return 0;
            }
        }


        function getVentasMes($idPromotor=null,$fechaVenta=null){
            $query = $this->db->query(
                "
                SELECT 
                av.id
                ,av.idProyecto
                ,av.idProspecto
                ,av.fechaVenta
                FROM alta_venta AS av
                JOIN prospectos AS pros ON pros.id = av.idProspecto
                JOIN proyectos AS proy ON proy.id = av.idProyecto
                JOIN gestoria AS ges ON ges.idAltaventa = av.id
                WHERE av.statusValidacion>=4 
                AND proy.statusVenta = 3
                AND ges.statusGestoria = 'detonado'
                AND YEAR(av.fechaVenta) = YEAR('".$fechaVenta."') -- CURRENT_DATE() 
                AND MONTH(av.fechaVenta) = MONTH('".$fechaVenta."') -- CURRENT_DATE()
                AND pros.idPromotor = ".$idPromotor."

                "
            );

            if($query->num_rows()>0){
                return $query->num_rows();
            }
            else{
                return 0;
            }
        }


        ////////SUBQUERY
        /*function getVentasMes($fechaVenta){
           $query = $this->db->query("
                SELECT id
                ,idProyecto
                ,idProspecto
                ,(SELECT prospectos.idPromotor FROM prospectos WHERE id=(SELECT idProspecto FROM alta_venta WHERE prospectos.id=alta_venta.idProspecto LIMIT 1) AND prospectos.idPromotor=163 LIMIT 1) AS 'idPromotor'
                ,fechaVenta 
                FROM alta_venta 
                WHERE statusValidacion>=4 
                AND (SELECT statusVenta FROM proyectos WHERE alta_venta.idProyecto = proyectos.id AND proyectos.statusVenta LIMIT 1)=3
                AND (SELECT statusGestoria FROM gestoria WHERE alta_venta.id = gestoria.idAltaventa LIMIT 1)='detonado'
                AND YEAR(fechaVenta) = YEAR('".$fechaVenta."') -- CURRENT_DATE() 
                AND MONTH(fechaVenta) = MONTH('".$fechaVenta."') -- CURRENT_DATE()



                -- AND (SELECT usuarios.id FROM usuarios WHERE usuarios.id=(SELECT prospectos.idPromotor FROM prospectos WHERE prospectos.id=(SELECT alta_venta.idProspecto FROM alta_venta WHERE alta_venta.idProspecto = prospectos.id LIMIT 1) LIMIT 1) LIMIT 1)=163
                -- and (SELECT prospectos.idPromotor FROM prospectos WHERE id=(SELECT idProspecto FROM alta_venta WHERE prospectos.id=alta_venta.idProspecto) limit 1 ) = 163
            ");
           if($query->num_rows()>0){
                return $query;
            }
            else{
                return 0;
            }
        }*/
    }