<?php

    class mclaves_articulos extends MY_Model{

        public function __construct(){
            parent :: __construct();
            $this->table = "claves_articulos";
            $this->alias = 'ca';

            $this->selectDefault = "".
                $this->alias.".id
            ,".$this->alias.".idEmpresa
            ,".$this->alias.".idArticulo
            ,".$this->alias.".clave
            ,".$this->alias.".status
            ,IF(".$this->alias.".status > 0,'Activo','Inactivo') AS txtstatus";
        }
        // Populate values
        private function _populateValues($r){
            $array = array(
                'id' => '',
                'idEmpresa' => '',
                'idArticulo' => '',
                'clave' => '',
                'status' => '',
                'txtstatus' => ''
            );

            if (!is_numeric($r)) {
                $array['id'] = $r->row()->id;
                $array['idEmpresa'] = $r->row()->idEmpresa;
                $array['idArticulo'] = $r->row()->idArticulo;
                $array['clave'] = $r->row()->clave;
                $array['status'] = $r->row()->status;
                $array['txtstatus'] = $r->row()->txtstatus;
            }
                $array['msg'] = '';
            return $array;
        }

        function getAll(){
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.status' => true);
            //$this->db->where($arrayWhere);
            $this->db->order_by($this->alias.'.id', "asc");
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $query;
            }else{
                return 0;
            }
        }

        function getById($id){
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.id' => $id);
            $this->db->where($arrayWhere);
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $this->_populateValues($query);
            }
            else{
                return 0;
            }
        }

        function valInsert($idEmpresa,$idArticulo,$clave){
            $query=$this->db->query("SELECT id FROM claves_articulos WHERE idEmpresa='$idEmpresa' AND idArticulo='$idArticulo' AND clave='$clave'");
            if($query->num_rows()>0){
                return $query;
            }else{
                return 0;
            }
        }
    }