<?php

    class mbonificaciones_descuentos extends MY_Model{
 
        public function __construct(){
            parent :: __construct();
            $this->table = "bonificaciones_descuentos";
            $this->alias = 'b';

            $this->selectDefault = "".
                $this->alias.".id
            ,".$this->alias.".idBonificacion
            ,".$this->alias.".concepto
            ,".$this->alias.".importe
            ,".$this->alias.".status
            ,IF(".$this->alias.".status > 0,'Activo','Inactivo') AS txtstatus";
        }

        // Populate values
        private function _populateValues($r)
        {
            $array = array(
                'id' => '',
                'idBonificacion' => '',
                'concepto' => '',
                'importe' => '',
                'status' => '',
                'txtstatus' => ''
            );
            
            if (!is_numeric($r)) {
                $array['id'] = $r->row()->id;
                $array['idBonificacion'] = $r->row()->idBonificacion;
                $array['concepto'] = $r->row()->concepto;
                $array['importe'] = $r->row()->importe;
                $array['status'] = $r->row()->status;
                $array['txtstatus'] = $r->row()->txtstatus;
            }
            $array['msg'] = '';
            return $array;
        }

        function getAll(){
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.id' => $id);
            $this->db->where($arrayWhere);
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows() > 0){
                return $query;
            }
            else{
                return 0;
            }
        }

        function getById($id){
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.id' => $id);
            $this->db->where($arrayWhere);
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $this->_populateValues($query);
            }
            else{
                return 0;
            }
        }
        
        function getByIdBonificacion($idBonificacion){
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.idBonificacion' => $idBonificacion);
            $this->db->where($arrayWhere);
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows() > 0){
                return $query;
            }else{
                return 0;
            }
        }

        function getSumByIdBonificacion($idBonificacion){
            $query = $this->db->query("SELECT IF(SUM(importe) > 0,SUM(importe),0) AS descuento FROM bonificaciones_descuentos WHERE idBonificacion = $idBonificacion");
            if($query->num_rows() > 0){
                return $query->row()->descuento;
            }else{
                return 0;
            }
        }

    }