<?php
    class mblackboard extends MY_Model {
        public function __construct() {
            parent :: __construct();
            $this->table = "blackboard";
            $this->alias = 'b';

            $this->selectDefault = "".
            $this->alias.".id
            ,".$this->alias.".idFraccionamiento
            ,".$this->alias.".idUsuario
            ,".$this->alias.".asunto
            ,".$this->alias.".proyecto
            ,".$this->alias.".delegado
            ,".$this->alias.".mail
            ,".$this->alias.".nombreOtros
            ,".$this->alias.".emailOtros
            ,".$this->alias.".fechaInicio
            ,".$this->alias.".fechaTermino
            ,".$this->alias.".checked
            ,".$this->alias.".statusCumplido
            ,".$this->alias.".statusAlert
            ,".$this->alias.".status
            ,IF(".$this->alias.".status > 0,'Activo','Inactivo') AS txtstatus";
        }

        private function _populateValues($r) {
            $array = array(
                'id' => '',
                'idFraccionamiento' => '',
                'idUsuario' => '',
                'asunto' => '',
                'proyecto' => '',
                'delegado' => '',
                'mail' => '',
                'fechaInicio' => '',
                'fechaTermino' => '',
                'checked' => '',
                'statusCumplido' => '',
                'statusAlert' => '',
                'status' => '',
                'txtstatus' => ''
            );

            if (!is_numeric($r)) {
                $array['id'] = $r->row()->id;
                $array['idFraccionamiento'] = $r->row()->idFraccionamiento;
                $array['idUsuario'] = $r->row()->idUsuario;
                $array['asunto'] = $r->row()->asunto;
                $array['proyecto'] = $r->row()->proyecto;
                $array['delegado'] = $r->row()->delegado;
                $array['mail'] = $r->row()->mail;
                $array['nombreOtros'] = $r->row()->nombreOtros;
                $array['emailOtros'] = $r->row()->emailOtros;
                $array['fechaInicio'] = $r->row()->fechaInicio;
                $array['fechaTermino'] = $r->row()->fechaTermino;
                $array['checked'] = $r->row()->checked;
                $array['statusCumplido'] = $r->row()->statusCumplido;
                $array['statusAlert'] = $r->row()->statusAlert;
                $array['status'] = $r->row()->status;
                $array['txtstatus'] = $r->row()->txtstatus;
            }
            $array['msg'] = '';
            return $array;
        }

        function getAll() {
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.status' => true, $this->alias.'.idFraccionamiento' => $_SESSION['viv']['idFraccionamiento']);
            $this->db->where($arrayWhere);
            $this->db->order_by($this->alias.'.id', "desc");
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0) {
                return $query;
            }
            else {
                return 0;
            }
        }

        function getAllByCronJob() {
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.status' => true,$this->alias.'.statusAlert' => 0);
            $this->db->where($arrayWhere);
            $this->db->order_by($this->alias.'.id', "desc");
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0) {
                return $query;
            }
            else {
                return 0;
            }
        }

        function getAllList() {
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.status' => true,$this->alias.'.statusCumplido' => 0);
            $this->db->where($arrayWhere);
            if ( $_SESSION['viv']['rol'] != 1 ) {
                //$this->db->where($this->alias.".idUsuario" , $_SESSION['viv']['id']);
                $this->db->like($this->alias.".idUsuario",$_SESSION['viv']['id']);
            }
            $this->db->order_by($this->alias.'.id', "desc");
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0) {
                return $query;
            }
            else {
                return 0;
            }
        }

        function getAllListComplete() {
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.status' => true,$this->alias.'.statusCumplido' => 1);
            $this->db->where($arrayWhere);
            if ( $_SESSION['viv']['rol'] != 1 ) {
                //$this->db->where($this->alias.".idUsuario" , $_SESSION['viv']['id']);
                $this->db->like($this->alias.".idUsuario",$_SESSION['viv']['id']);
            }
            $this->db->order_by($this->alias.'.id', "desc");
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0) {
                return $query;
            }
            else {
                return 0;
            }
        }

        function getById($id) {
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.id' => $id);
            $this->db->where($arrayWhere);
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $this->_populateValues($query);
            }
            else{
                return 0;
            }
        }
    }
?>