<?php
class Mareastatus extends MY_Model{

    public function __construct(){
        parent :: __construct();
        $this->table = "area_status";
        $this->alias = 'ae';

        $this->selectDefault = "".
            $this->alias.".id
        ,".$this->alias.".idArea
        ,".$this->alias.".idAltaVenta
        ,".$this->alias.".idStatus
        ,".$this->alias.".fecha
        ,".$this->alias.".status
        ,IF(".$this->alias.".status > 0,'Activo','Inactivo') AS txtstatus";

    }

    // Populate values
    private function _populateValues($r)
    {
        $array = array(
            'id' => '',
            'idArea' => '',
            'idAltaVenta' => '',
            'idStatus' => '',
            'fecha' => '',
            'status' => '',
            'txtstatus' => ''
        );
        if (!is_numeric($r)) {
            $array['id'] = $r->row()->id;
            $array['idArea'] = $r->row()->idArea;
            $array['idAltaVenta'] = $r->row()->idAltaVenta;
            $array['idStatus'] = $r->row()->idStatus;
            $array['fecha'] = $r->row()->fecha;
            $array['status'] = $r->row()->status;
            $array['txtstatus'] = $r->row()->txtstatus;

        }

        $array['msg'] = '';

        return $array;
    }

    function getAll(){
        $this->db->select($this->selectDefault,FALSE);
        $arrayWhere = array($this->alias.'.status' => true);
        $this->db->where($arrayWhere);
        $this->db->order_by($this->alias.'.id', "desc");
        $query = $this->db->get($this->table.' AS '.$this->alias);
        if($query->num_rows()>0){
            return $query;
        }else{
            return 0;
        }
    }

    function getById($id){
        $this->db->select($this->selectDefault,FALSE);
        $arrayWhere = array($this->alias.'.id' => $id);
        $this->db->where($arrayWhere);
        $query = $this->db->get($this->table.' AS '.$this->alias);
        if($query->num_rows()>0){
            return $this->_populateValues($query);
        }
        return 0;
    }

    function getByIdAreaAv($idArea=null, $idAltaVenta=null, $estatus=null){
        $this->db->select($this->selectDefault,FALSE);
        $arrayWhere = array($this->alias.'.idArea' => $idArea,$this->alias.'.idAltaVenta' => $idAltaVenta);
        $this->db->where($arrayWhere);
        if($estatus!=null){
            $this->db->where($this->alias.'.idStatus =',$estatus);
        }
        $this->db->order_by($this->alias.'.id', "desc");
        $this->db->limit(1);
        $query = $this->db->get($this->table.' AS '.$this->alias);
        if($query->num_rows()>0){
            return $this->_populateValues($query);
        }
        return 0;
    }

    //para tuberia gestoría
    function getStatusByDate($status=''){
        $query = $this->db->query("
            SELECT id FROM area_status WHERE idStatus = '".$status."' AND idArea=1 
            AND DATE(fecha) = CURDATE()
        ");
        if($query->num_rows()>0){
            return $query->num_rows();
        }
        else{
            return 0;
        }
    }

    //para tuberia titulación
    function getStatusTByDate($status=''){
        $query = $this->db->query("
            SELECT id FROM area_status WHERE idStatus = '".$status."' AND idArea=2 
            AND DATE(fecha) = CURDATE()
        ");
        if($query->num_rows()>0){
            return $query->num_rows();
        }
        else{
            return 0;
        }
    }

}