<?php

    class maltaventa extends MY_Model{

        public function __construct(){
            parent :: __construct();
            $this->table = "alta_venta";
            $this->alias = 'av';

            $this->alias2 = 'pro';//prospecto
            $this->alias3 = 'proy';//proyecto
            $this->alias4 = 'prom'; //promotor
            $this->alias5 = 'ges'; //gestoria
            $this->alias6 = 'cb'; // comsiones-bonos
            $this->alias7 = 'az';//Autorizaciones
            $this->alias10 = 'd';//depositos
            $this->alias8 = 'e';//entrega
            $this->alias9 = 'pv';//postventa
            $this->alias10 = 'depa';//detallepaquete
            $this->alias11 = 'paq';//paquete

            //alta venta
            $this->selectDefault = "".//campos de la tabla alta_venta
                $this->alias.".id
            ,".$this->alias.".idProyecto
            ,".$this->alias.".idProspecto
            ,".$this->alias.".idNotaria
            ,".$this->alias.".idUnidadValuadora
            ,".$this->alias.".numNotaria
            ,".$this->alias.".descripcion
            ,".$this->alias.".monto
            ,".$this->alias.".subCuenta
            ,".$this->alias.".gastosOperacion
            ,".$this->alias.".total
            ,".$this->alias.".fechaPreca
            ,".$this->alias.".fechaValidacion
            ,".$this->alias.".fechaApartado
            ,".$this->alias.".fechaProceso
            ,".$this->alias.".fechaVenta
            ,".$this->alias.".fechaCambio

            ,".$this->alias.".revisionMontos
            ,".$this->alias.".motivo
            ,".$this->alias.".motivoCancelacionAv
            ,".$this->alias.".idMotivo
            ,".$this->alias.".fechaCancelacionAv
            ,".$this->alias.".tipoCredito
            ,".$this->alias.".tipoCredito2
            ,".$this->alias.".otroTCredito
            ,".$this->alias.".diferenciaCliente
            ,".$this->alias.".diferenciaAsesor
            ,".$this->alias.".diferenciaEmpresa
            ,".$this->alias.".diferencia
            ,".$this->alias.".bonoEquipamiento
            ,".$this->alias.".numPagare
            ,".$this->alias.".montoPagare
            ,".$this->alias.".fechaPagoPagare
            ,".$this->alias.".numSeriePagare
            ,".$this->alias.".interesPagare

            ,".$this->alias.".pdf_1
            ,".$this->alias.".statusPdf_1
            ,".$this->alias.".pdf_2
            ,".$this->alias.".statusPdf_2
            ,".$this->alias.".pdf_3
            ,".$this->alias.".statusPdf_3
            ,".$this->alias.".pdf_4
            ,".$this->alias.".statusPdf_4
            ,".$this->alias.".pdf_5
            ,".$this->alias.".statusPdf_5
            ,".$this->alias.".pdf_6
            ,".$this->alias.".statusPdf_6
            ,".$this->alias.".pdf_7
            ,".$this->alias.".statusPdf_7
            ,".$this->alias.".pdf_16
            ,".$this->alias.".statusPdf_16
            ,".$this->alias.".pdf_17
            ,".$this->alias.".statusValidacion
            ,".$this->alias.".statusValidacion2
            ,".$this->alias.".statusEncuesta
            ,".$this->alias.".created
            ,".$this->alias.".created_by
            ,".$this->alias.".status
            ,IF(".$this->alias.".status > 0,'Activo','Inactivo') AS txtstatus";

            $this->selectProyecto = "".//campos de la tabla proyecto
                $this->alias3.".idFraccionamiento
            ,".$this->alias3.".idPrototipo
            ,".$this->alias3.".numPaquete
            ,".$this->alias3.".lote
            ,".$this->alias3.".manzana
            ,".$this->alias3.".calle
            ,".$this->alias3.".nOficial
            ,".$this->alias3.".cuv
            ,".$this->alias3.".claveCatastral
            ,".$this->alias3.".supTerreno
            ,".$this->alias3.".supConstruccion
            ,".$this->alias3.".precioVenta
            ,".$this->alias3.".statusProyecto
            ,".$this->alias3.".puntaje
            ,".$this->alias3.".porcentajeAvance
            ,".$this->alias3.".contratista
            ,".$this->alias3.".avaluo
            ,".$this->alias3.".folioAvaluo
            ,".$this->alias3.".unidadVerificadora
            ,".$this->alias3.".fechaVencimiento
            ,".$this->alias3.".fechaDtu
            ,".$this->alias3.".lineaCredito
            ,".$this->alias3.".statusObra
            ,".$this->alias3.".statusVenta";

            /*
            $this->selectPromotor = "".
                $this->alias4.".nombre AS nombreProm
            ,".$this->alias4.".apellidoP AS apellidoPProm
            ,".$this->alias4.".apellidoM AS apellidoMProm
            ,".$this->alias4.".comision";*/

            $this->selectProspecto = "". //campos de la tabla prospecto
                $this->alias2.".idPromotor
            ,".$this->alias2.".nombre
            ,".$this->alias2.".apellidoP
            ,".$this->alias2.".apellidoM
            ,".$this->alias2.".genero
            ,".$this->alias2.".rfc
            ,".$this->alias2.".telefono
            ,".$this->alias2.".celular
            ,".$this->alias2.".email
            ,".$this->alias2.".regimen
            ,".$this->alias2.".edoCivil
            ,".$this->alias2.".nombre2
            ,".$this->alias2.".apellidoP2
            ,".$this->alias2.".apellidoM2
            ,".$this->alias2.".rfc2
            ,".$this->alias2.".telefono2
            ,".$this->alias2.".fecha
            ,".$this->alias2.".fechaNac
            ,".$this->alias2.".fechaNac2
            ,".$this->alias2.".lugarProspeccion
            ,".$this->alias2.".otroLugar
            ,".$this->alias2.".nss
            ,".$this->alias2.".curp

            ,".$this->alias2.".nss2
            ,".$this->alias2.".nombreR1
            ,".$this->alias2.".apellidoPR1
            ,".$this->alias2.".apellidoMR1
            ,".$this->alias2.".nombreR2
            ,".$this->alias2.".apellidoPR2
            ,".$this->alias2.".apellidoMR2
            ,".$this->alias2.".curp2
            ,".$this->alias2.".celular2
            ,".$this->alias2.".email2
            ,".$this->alias2.".nrp2
            ,".$this->alias2.".telEmpresa2

            ,".$this->alias2.".statusProspecto
            ,".$this->alias2.".comentario
            ,".$this->alias2.".prototipo
            ,".$this->alias2.".claveElector
            ,".$this->alias2.".claveElector2
            ,".$this->alias2.".calleProspecto
            ,".$this->alias2.".numeroCasa
            ,".$this->alias2.".codigoPostal
            ,".$this->alias2.".colonia
            ,".$this->alias2.".entidad
            ,".$this->alias2.".ciudad
            ,".$this->alias2.".tipoVivienda
            ,".$this->alias2.".empresaTrabajador
            ,".$this->alias2.".telEmpresa
            ,".$this->alias2.".nrp
            ,".$this->alias2.".empresaTrabajador2
            ,".$this->alias2.".nombreR1
            ,".$this->alias2.".telR1
            ,".$this->alias2.".celR1
            ,".$this->alias2.".nombreR2
            ,".$this->alias2.".telR2
            ,".$this->alias2.".celR2
            ";

            $this->selectGestoria = "". //campos de la tabla gestoría
                $this->alias5.".id AS idGestoria
            ,".$this->alias5.".idAltaVenta
            ,".$this->alias5.".aplicaFolio
            ,".$this->alias5.".numeroFolio
            ,".$this->alias5.".numeroCredito
            ,".$this->alias5.".numeroCredito2
            ,".$this->alias5.".numeroEscritura
            ,".$this->alias5.".valorTerreno
            ,".$this->alias5.".numeroAvaluo
            ,".$this->alias5.".fechaIngreso
            ,".$this->alias5.".certificadoLibertad
            ,".$this->alias5.".constanciaNoAdeudo
            ,".$this->alias5.".precioVentaOci
            ,".$this->alias5.".montoOci
            ,".$this->alias5.".subCuenta
            ,".$this->alias5.".gastosTitulacion
            ,".$this->alias5.".ahorroVol
            ,".$this->alias5.".seguroCalidad
            ,".$this->alias5.".subsidio
            ,".$this->alias5.".sumaFinal
            ,".$this->alias5.".difPropioPeculioTitulacion
            ,".$this->alias5.".fechaFirma
            ,".$this->alias5.".ronda
            ,".$this->alias5.".pdf_8
            ,".$this->alias5.".statusPdf_8
            ,".$this->alias5.".pdf_9
            ,".$this->alias5.".statusPdf_9
            ,".$this->alias5.".pdf_10
            ,".$this->alias5.".statusPdf_10
            ,".$this->alias5.".pdf_11
            ,".$this->alias5.".statusPdf_11
            ,".$this->alias5.".pdf_15
            ,".$this->alias5.".statusGestoria
            ,".$this->alias5.".fechaCambio
            ,".$this->alias5.".motivoCancelacion
            ,".$this->alias5.".fechaCancelacion
            ,".$this->alias5.".fechaEscritura
            ,".$this->alias5.".superficieTerreno";

            $this->selectComisiones = "". //campos de la tabla comisiones
                $this->alias6.".idAltaVenta AS idAltaVentaComisiones
                ,".$this->alias6.".id AS idComision
                ,".$this->alias6.".difPropioPeculio
                ,".$this->alias6.".resultado
                ,".$this->alias6.".saldo
                ,".$this->alias6.".cierre
                ,".$this->alias6.".importeComision
                ,".$this->alias6.".netoVenta
                ,".$this->alias6.".diferenciaVendedor
                ,".$this->alias6.".comentarios
                ,".$this->alias6.".created as createdComisiones
                ";

            $this->selectAutorizaciones = "". // campos de la tabla autorizaciones
                $this->alias7.".idAltaVenta AS idAltaVentaAutorizaciones
                ,".$this->alias7.".id AS idAutorizacion
                ,".$this->alias7.".montoTotal
                ,".$this->alias7.".difPropPeculio AS peculioAutorizaciones
                ,".$this->alias7.".resultado AS resultadoAutorizaciones
                ,".$this->alias7.".propVenta
                ,".$this->alias7.".statusAutorizacion
                ,".$this->alias7.".porcentajePrimerPago
                ,".$this->alias7.".primerPagoPromotor
                ,".$this->alias7.".fechaPrimerPagoPromotor
                ,".$this->alias7.".tPago1
                ,".$this->alias7.".segundoPagoPromotor
                ,".$this->alias7.".fechaSegundoPagoPromotor
                ,".$this->alias7.".tPago2
                ,".$this->alias7.".primerPagoCoordinador
                ,".$this->alias7.".fechaPrimerPagoCoordinador
                ,".$this->alias7.".segundoPagoCoordinador
                ,".$this->alias7.".fechaSegundoPagoCoordinador
                ,".$this->alias7.".pctjeComisionTotal
                ,".$this->alias7.".bonificacion
                ,".$this->alias7.".fechaBonificacion
                ,".$this->alias7.".created as createdAutorizaciones
                ,".$this->alias7.".updated as updatedAutorizaciones";

            $this->selectDepositos = "". //campos de la tabla depositos
                $this->alias10.".idAltaVenta AS idAltaVentaDepositos
                ,".$this->alias10.".id AS idDeposito
                ,".$this->alias10.".montoTotal AS montoTotalDepositos
                ,".$this->alias10.".difPropPeculio AS peculioDepositos
                ,".$this->alias10.".resultado AS resultadoDepositos
                ,".$this->alias10.".propVenta AS propVentaDepositos
                ,".$this->alias10.".statusAutorizacion AS statusAutorizacionDepositos
                ,".$this->alias10.".depositoInfonavit
                ,".$this->alias10.".depositoConavi
                ,".$this->alias10.".fechaDeposito
                ,".$this->alias10.".cuentaDepositada
                ,".$this->alias10.".pagoUno
                ,".$this->alias10.".fechaPagoUno
                ,".$this->alias10.".pagoDos
                ,".$this->alias10.".fechaPagoDos
                ,".$this->alias10.".pagoTres
                ,".$this->alias10.".fechaPagoTres
                ,".$this->alias10.".pagoCuatro
                ,".$this->alias10.".fechaPagoCuatro
                ,".$this->alias10.".pagoCinco
                ,".$this->alias10.".fechaPagoCinco
                ,".$this->alias10.".pagoSeis
                ,".$this->alias10.".fechaPagoSeis
                ,".$this->alias10.".pagoSiete
                ,".$this->alias10.".fechaPagoSiete
                ,".$this->alias10.".pagoOcho
                ,".$this->alias10.".fechaPagoOcho
                ,".$this->alias10.".pagoNueve
                ,".$this->alias10.".fechaPagoNueve
                ,".$this->alias10.".pagoDiez
                ,".$this->alias10.".fechaPagoDiez
                ,".$this->alias10.".pagoOnce
                ,".$this->alias10.".fechaPagoOnce
                ,".$this->alias10.".created as createdDepositos
                ";

            $this->selectEntrega = "". //campos de la tabla entrega
                $this->alias8.".idAltaVenta AS idAltaVentaEntrega
                ,".$this->alias8.".id AS idEntrega
                ,".$this->alias8.".fechaEntrega
                ,".$this->alias8.".data_1
                ,".$this->alias8.".data_2
                ,".$this->alias8.".pdf_12
                ,".$this->alias8.".pdf_13
                ,".$this->alias8.".created as createdEntrega";

            $this->selectPostventa = "". // campos de la tabla postventa
                $this->alias9.".idAltaVenta AS idAltaVentaPostventa
                ,".$this->alias9.".id AS idPostventa
                ,".$this->alias9.".instElectricas
                ,".$this->alias9.".instHidraulicas
                ,".$this->alias9.".instSanitarias
                ,".$this->alias9.".instGas
                ,".$this->alias9.".canceleria
                ,".$this->alias9.".impermeabilizacion
                ,".$this->alias9.".acabados
                ,".$this->alias9.".estructural
                ,".$this->alias9.".accesorios
                ,".$this->alias9.".calentadorAgua
                ,".$this->alias9.".pdf_14
                ,".$this->alias9.".statusIncidencia
                ,".$this->alias9.".created as createdPostventa";
            
            $this->selectDetallepaquete = "". // campos de la tabla postventa
                $this->alias10.".id AS idP
                ,".$this->alias10.".idPaquete";

            $this->selectPaquete = "". // campos de la tabla postventa
                $this->alias11.".id AS idPaq
                ,".$this->alias11.".idConstructor
                ,".$this->alias11.".idResidentes";
        }
        // Populate values alta_venta
        private function _populateValues($r)
        {
            $array = array(
                'id' => '',
                'idProyecto' => '',
                'status' => '',
                'txtstatus' => ''
            );

            if (!is_numeric($r)) {
                $array['id'] = $r->row()->id;
                $array['idProyecto'] = $r->row()->idProyecto;
                $array['idProspecto'] = $r->row()->idProspecto;
                $array['idNotaria'] = $r->row()->idNotaria;
                $array['idUnidadValuadora'] = $r->row()->idUnidadValuadora;
                $array['numNotaria'] = $r->row()->numNotaria;
                $array['descripcion'] = $r->row()->descripcion;
                $array['monto'] = $r->row()->monto;
                $array['subCuenta'] = $r->row()->subCuenta;
                $array['gastosOperacion'] = $r->row()->gastosOperacion;
                $array['total'] = $r->row()->total;
                $array['fechaPreca'] = $r->row()->fechaPreca;
                $array['fechaValidacion'] = $r->row()->fechaValidacion;
                $array['fechaProceso'] = $r->row()->fechaProceso;
                $array['fechaVenta'] = $r->row()->fechaVenta;
                $array['fechaCambio'] = $r->row()->fechaCambio;


                //campos usados en validacion de venta
                $array['revisionMontos'] = $r->row()->revisionMontos;
                $array['motivo'] = $r->row()->motivo;
                $array['motivoCancelacionAv'] = $r->row()->motivoCancelacionAv;
                $array['idMotivo'] = $r->row()->idMotivo;
                $array['fechaCancelacionAv'] = $r->row()->fechaCancelacionAv;
                $array['tipoCredito'] = $r->row()->tipoCredito;
                $array['tipoCredito2'] = $r->row()->tipoCredito2;
                $array['otroTCredito'] = $r->row()->otroTCredito;
                $array['diferenciaCliente'] = $r->row()->diferenciaCliente;
                $array['diferenciaAsesor'] = $r->row()->diferenciaAsesor;
                $array['diferenciaEmpresa'] = $r->row()->diferenciaEmpresa;
                $array['diferencia'] = $r->row()->diferencia;
                $array['bonoEquipamiento'] = $r->row()->bonoEquipamiento;
                $array['numPagare'] = $r->row()->numPagare;
                $array['montoPagare'] = $r->row()->montoPagare;
                $array['fechaPagoPagare'] = $r->row()->fechaPagoPagare;
                $array['numSeriePagare'] = $r->row()->numSeriePagare;
                $array['interesPagare'] = $r->row()->interesPagare;

                $array['pdf_1'] = $r->row()->pdf_1;
                $array['statusPdf_1'] = $r->row()->statusPdf_1; // 1 indica validado
                $array['pdf_2'] = $r->row()->pdf_2;
                $array['statusPdf_2'] = $r->row()->statusPdf_2;
                $array['pdf_3'] = $r->row()->pdf_3;
                $array['statusPdf_3'] = $r->row()->statusPdf_3;
                $array['pdf_4'] = $r->row()->pdf_4;
                $array['statusPdf_4'] = $r->row()->statusPdf_4;
                $array['pdf_5'] = $r->row()->pdf_5;
                $array['statusPdf_5'] = $r->row()->statusPdf_5;
                $array['pdf_6'] = $r->row()->pdf_6;
                $array['statusPdf_6'] = $r->row()->statusPdf_6;
                $array['pdf_7'] = $r->row()->pdf_7;
                $array['statusPdf_7'] = $r->row()->statusPdf_7;
                $array['pdf_16'] = $r->row()->pdf_16;
                $array['statusPdf_16'] = $r->row()->statusPdf_16;
                $array['pdf_17'] = $r->row()->pdf_17;
                $array['statusValidacion'] = $r->row()->statusValidacion; // cero indica que se mostrara en modulo alta de venta, 1 indica que se mostrará en modulo validación de venta
                $array['statusValidacion2'] = $r->row()->statusValidacion2;
                $array['statusEncuesta'] = $r->row()->statusEncuesta;
                $array['created'] = $r->row()->created;
                $array['created_by'] = $r->row()->created_by;
                $array['status'] = $r->row()->status;
                $array['txtstatus'] = $r->row()->txtstatus;

            }
                $array['msg'] = '';
            return $array;
        }

        //Populate para validación de venta
        private function _populateValuesAll($r)
        {
            $array = array(
                'id' => '',
                'idProyecto' => '',
                'status' => '',
                'txtstatus' => ''
            );
            if (!is_numeric($r)) {
                //Relaciones fraccionamiento,prospecto,proyecto
                $array['id'] = $r->row()->id; //id alta venta
                $array['idFraccionamiento'] = $r->row()->idFraccionamiento; //viene de tabla proyectos
                $array['idProyecto'] = $r->row()->idProyecto;
                $array['idPromotor'] = $r->row()->idPromotor; //viene de tabla prospecto
                $array['idProspecto'] = $r->row()->idProspecto;
                $array['idNotaria'] = $r->row()->idNotaria;
                $array['idUnidadValuadora'] = $r->row()->idUnidadValuadora;
                $array['numNotaria'] = $r->row()->numNotaria;

                //datos proyecto (vivienda)
                $array['idPrototipo'] = $r->row()->idPrototipo;
                $array['lote'] = $r->row()->lote;
                $array['nOficial'] = $r->row()->nOficial;
                $array['manzana'] = $r->row()->manzana;
                $array['calle'] = $r->row()->calle;
                $array['numPaquete'] = $r->row()->numPaquete;
                $array['cuv'] = $r->row()->cuv;
                $array['precioVenta'] = $r->row()->precioVenta;
                $array['avaluo'] = $r->row()->avaluo;
                $array['folioAvaluo'] = $r->row()->folioAvaluo;
                $array['lineaCredito'] = $r->row()->lineaCredito;


                $array['supTerreno'] = $r->row()->supTerreno;
                $array['supConstruccion'] = $r->row()->supConstruccion;

                //datos prospecto
                $array['nombre'] = $r->row()->nombre;
                $array['apellidoP'] = $r->row()->apellidoP;
                $array['apellidoM'] = $r->row()->apellidoM;
                $array['fecha'] = $r->row()->fecha;
                $array['rfc'] = $r->row()->rfc;
                $array['nss'] = $r->row()->nss;
                $array['curp'] = $r->row()->curp;

                $array['nss2'] = $r->row()->nss2;
                $array['apellidoPR1'] = $r->row()->apellidoPR1;
                $array['apellidoMR1'] = $r->row()->apellidoMR1;
                $array['apellidoPR2'] = $r->row()->apellidoPR2;
                $array['apellidoMR2'] = $r->row()->apellidoMR2;
                $array['curp2'] = $r->row()->curp2;
                $array['celular2'] = $r->row()->celular2;
                $array['email2'] = $r->row()->email2;
                $array['nrp2'] = $r->row()->nrp2;
                $array['telEmpresa2'] = $r->row()->telEmpresa2;

                $array['telefono'] = $r->row()->telefono;
                $array['celular'] = $r->row()->celular;
                $array['email'] = $r->row()->email;
                $array['regimen'] = $r->row()->regimen;
                $array['edoCivil'] = $r->row()->edoCivil;
                $array['nombre2'] = $r->row()->nombre2;
                $array['apellidoP2'] = $r->row()->apellidoP2;
                $array['apellidoM2'] = $r->row()->apellidoM2;
                $array['rfc2'] = $r->row()->rfc2;
                $array['telefono2'] = $r->row()->telefono2;
                $array['fechaNac'] = $r->row()->fechaNac;
                $array['fechaNac2'] = $r->row()->fechaNac2;

                $array['claveElector'] = $r->row()->claveElector;
                $array['claveElector2'] = $r->row()->claveElector2;
                $array['calleProspecto'] = $r->row()->calleProspecto;
                $array['numeroCasa'] = $r->row()->numeroCasa;
                $array['codigoPostal'] = $r->row()->codigoPostal;
                $array['colonia'] = $r->row()->colonia;
                $array['entidad'] = $r->row()->entidad;
                $array['ciudad'] = $r->row()->ciudad;
                $array['tipoVivienda'] = $r->row()->tipoVivienda;
                $array['empresaTrabajador'] = $r->row()->empresaTrabajador;
                $array['telEmpresa'] = $r->row()->telEmpresa;
                $array['nrp'] = $r->row()->nrp;
                $array['empresaTrabajador2'] = $r->row()->empresaTrabajador2;
                $array['nombreR1'] = $r->row()->nombreR1;
                $array['telR1'] = $r->row()->telR1;
                $array['celR1'] = $r->row()->celR1;
                $array['nombreR2'] = $r->row()->nombreR2;
                $array['telR2'] = $r->row()->telR2;
                $array['celR2'] = $r->row()->celR2;

                //datos venta
                $array['descripcion'] = $r->row()->descripcion;
                $array['monto'] = $r->row()->monto;
                $array['subCuenta'] = $r->row()->subCuenta;
                $array['gastosOperacion'] = $r->row()->gastosOperacion;
                $array['total'] = $r->row()->total;
                $array['fechaPreca'] = $r->row()->fechaPreca;
                $array['fechaValidacion'] = $r->row()->fechaValidacion;
                $array['fechaVenta'] = $r->row()->fechaVenta;
                $array['fechaCambio'] = $r->row()->fechaCambio;
                $array['pdf_1'] = $r->row()->pdf_1;
                $array['pdf_2'] = $r->row()->pdf_2;
                $array['pdf_3'] = $r->row()->pdf_3;
                $array['pdf_4'] = $r->row()->pdf_4;
                $array['pdf_5'] = $r->row()->pdf_5;
                $array['pdf_6'] = $r->row()->pdf_6;
                $array['pdf_7'] = $r->row()->pdf_7;
                $array['pdf_16'] = $r->row()->pdf_16;
                $array['pdf_17'] = $r->row()->pdf_17;

                //Validación de venta
                $array['revisionMontos'] = $r->row()->revisionMontos;
                $array['motivo'] = $r->row()->motivo;
                $array['motivoCancelacionAv'] = $r->row()->motivoCancelacionAv;
                $array['idMotivo'] = $r->row()->idMotivo;
                $array['fechaCancelacionAv'] = $r->row()->fechaCancelacionAv;
                $array['tipoCredito'] = $r->row()->tipoCredito;
                $array['tipoCredito2'] = $r->row()->tipoCredito2;
                $array['otroTCredito'] = $r->row()->otroTCredito;
                $array['diferenciaCliente'] = $r->row()->diferenciaCliente;
                $array['diferenciaAsesor'] = $r->row()->diferenciaAsesor;
                $array['diferenciaEmpresa'] = $r->row()->diferenciaEmpresa;
                $array['diferencia'] = $r->row()->diferencia;
                $array['bonoEquipamiento'] = $r->row()->bonoEquipamiento;
                $array['numPagare'] = $r->row()->numPagare;
                $array['montoPagare'] = $r->row()->montoPagare;
                $array['fechaPagoPagare'] = $r->row()->fechaPagoPagare;
                $array['numSeriePagare'] = $r->row()->numSeriePagare;
                $array['interesPagare'] = $r->row()->interesPagare;

                $array['statusPdf_1'] = $r->row()->statusPdf_1;
                $array['statusPdf_2'] = $r->row()->statusPdf_2;
                $array['statusPdf_3'] = $r->row()->statusPdf_3;
                $array['statusPdf_4'] = $r->row()->statusPdf_4;
                $array['statusPdf_5'] = $r->row()->statusPdf_5;
                $array['statusPdf_6'] = $r->row()->statusPdf_6;
                $array['statusPdf_7'] = $r->row()->statusPdf_7;
                $array['statusPdf_16'] = $r->row()->statusPdf_16;
                $array['statusValidacion'] = $r->row()->statusValidacion;
                $array['statusValidacion2'] = $r->row()->statusValidacion2;

                $array['created'] = $r->row()->created;
                $array['created_by'] = $r->row()->created_by;
                $array['status'] = $r->row()->status;
                $array['txtstatus'] = $r->row()->txtstatus;
            }
            return $array;
        }

        //Populate para gestoría
        private function _populateValuesGestoria($r,$modulo="")
        {
            $array = array(
                'id' => '',
                'idProyecto' => '',
                'status' => '',
                'txtstatus' => ''
            );
            if (!is_numeric($r)) {
                //Relaciones fraccionamiento,prospecto,proyecto
                $array['id'] = $r->row()->id; //id alta venta
                $array['idFraccionamiento'] = $r->row()->idFraccionamiento; //viene de tabla proyectos
                $array['idProyecto'] = $r->row()->idProyecto;
                $array['idPromotor'] = $r->row()->idPromotor; //viene de tabla prospecto
                $array['idProspecto'] = $r->row()->idProspecto;
                $array['idNotaria'] = $r->row()->idNotaria;
                $array['idUnidadValuadora'] = $r->row()->idUnidadValuadora;
                $array['numNotaria'] = $r->row()->numNotaria;

                //datos proyecto (vivienda)
                $array['lote'] = $r->row()->lote;
                $array['manzana'] = $r->row()->manzana;
                $array['calle'] = $r->row()->calle;
                $array['nOficial'] = $r->row()->nOficial;
                $array['numPaquete'] = $r->row()->numPaquete;
                $array['cuv'] = $r->row()->cuv;
                $array['precioVenta'] = $r->row()->precioVenta;
                $array['avaluo'] = $r->row()->avaluo;
                $array['folioAvaluo'] = $r->row()->folioAvaluo;
                $array['statusProyecto'] = $r->row()->statusProyecto;
                $array['lineaCredito'] = $r->row()->lineaCredito;

                //datos prospecto
                $array['nombre'] = $r->row()->nombre;
                $array['apellidoP'] = $r->row()->apellidoP;
                $array['apellidoM'] = $r->row()->apellidoM;
                $array['genero'] = $r->row()->genero;
                $array['fecha'] = $r->row()->fecha;
                $array['rfc'] = $r->row()->rfc;
                $array['nss'] = $r->row()->nss;
                $array['curp'] = $r->row()->curp;

                $array['nss2'] = $r->row()->nss2;
                $array['apellidoPR1'] = $r->row()->apellidoPR1;
                $array['apellidoMR1'] = $r->row()->apellidoMR1;
                $array['apellidoPR2'] = $r->row()->apellidoPR2;
                $array['apellidoMR2'] = $r->row()->apellidoMR2;
                $array['curp2'] = $r->row()->curp2;
                $array['celular2'] = $r->row()->celular2;
                $array['email2'] = $r->row()->email2;
                $array['nrp2'] = $r->row()->nrp2;
                $array['telEmpresa2'] = $r->row()->telEmpresa2;

                $array['telefono'] = $r->row()->telefono;
                $array['celular'] = $r->row()->celular;
                $array['email'] = $r->row()->email;
                $array['regimen'] = $r->row()->regimen;
                $array['edoCivil'] = $r->row()->edoCivil;
                $array['nombre2'] = $r->row()->nombre2;
                $array['apellidoP2'] = $r->row()->apellidoP2;
                $array['apellidoM2'] = $r->row()->apellidoM2;
                $array['rfc2'] = $r->row()->rfc2;
                $array['telefono2'] = $r->row()->telefono2;
                $array['fechaNac'] = $r->row()->fechaNac;
                $array['fechaNac2'] = $r->row()->fechaNac2;

                $array['claveElector'] = $r->row()->claveElector;
                $array['claveElector2'] = $r->row()->claveElector2;
                $array['calleProspecto'] = $r->row()->calleProspecto;
                $array['numeroCasa'] = $r->row()->numeroCasa;
                $array['codigoPostal'] = $r->row()->codigoPostal;
                $array['colonia'] = $r->row()->colonia;
                $array['entidad'] = $r->row()->entidad;
                $array['ciudad'] = $r->row()->ciudad;
                $array['tipoVivienda'] = $r->row()->tipoVivienda;
                $array['empresaTrabajador'] = $r->row()->empresaTrabajador;
                $array['telEmpresa'] = $r->row()->telEmpresa;
                $array['nrp'] = $r->row()->nrp;
                $array['empresaTrabajador2'] = $r->row()->empresaTrabajador2;
                $array['nombreR1'] = $r->row()->nombreR1;
                $array['telR1'] = $r->row()->telR1;
                $array['celR1'] = $r->row()->celR1;
                $array['nombreR2'] = $r->row()->nombreR2;
                $array['telR2'] = $r->row()->telR2;
                $array['celR2'] = $r->row()->celR2;

                //datos venta
                $array['descripcion'] = $r->row()->descripcion;
                $array['monto'] = $r->row()->monto;
                $array['subCuenta'] = $r->row()->subCuenta;
                $array['gastosOperacion'] = $r->row()->gastosOperacion;
                $array['total'] = $r->row()->total;
                $array['fechaPreca'] = $r->row()->fechaPreca;
                $array['fechaValidacion'] = $r->row()->fechaValidacion;
                $array['fechaVenta'] = $r->row()->fechaVenta;
                $array['fechaCambio'] = $r->row()->fechaCambio;
                $array['pdf_1'] = $r->row()->pdf_1;
                $array['pdf_2'] = $r->row()->pdf_2;
                $array['pdf_3'] = $r->row()->pdf_3;
                $array['pdf_4'] = $r->row()->pdf_4;
                $array['pdf_5'] = $r->row()->pdf_5;
                $array['pdf_6'] = $r->row()->pdf_6;
                $array['pdf_7'] = $r->row()->pdf_7;
                $array['pdf_16'] = $r->row()->pdf_16;
                $array['pdf_17'] = $r->row()->pdf_17;

                //Validación de venta
                $array['revisionMontos'] = $r->row()->revisionMontos;
                $array['motivo'] = $r->row()->motivo;
                $array['motivoCancelacionAv'] = $r->row()->motivoCancelacionAv;
                $array['idMotivo'] = $r->row()->idMotivo;
                $array['fechaCancelacionAv'] = $r->row()->fechaCancelacionAv;
                $array['tipoCredito'] = $r->row()->tipoCredito;
                $array['tipoCredito2'] = $r->row()->tipoCredito2;
                $array['otroTCredito'] = $r->row()->otroTCredito;
                $array['diferenciaCliente'] = $r->row()->diferenciaCliente;
                $array['diferenciaAsesor'] = $r->row()->diferenciaAsesor;
                $array['diferenciaEmpresa'] = $r->row()->diferenciaEmpresa;
                $array['diferencia'] = $r->row()->diferencia;
                $array['bonoEquipamiento'] = $r->row()->bonoEquipamiento;
                $array['numPagare'] = $r->row()->numPagare;
                $array['montoPagare'] = $r->row()->montoPagare;
                $array['fechaPagoPagare'] = $r->row()->fechaPagoPagare;
                $array['numSeriePagare'] = $r->row()->numSeriePagare;
                $array['interesPagare'] = $r->row()->interesPagare;

                $array['statusPdf_1'] = $r->row()->statusPdf_1;
                $array['statusPdf_2'] = $r->row()->statusPdf_2;
                $array['statusPdf_3'] = $r->row()->statusPdf_3;
                $array['statusPdf_4'] = $r->row()->statusPdf_4;
                $array['statusPdf_5'] = $r->row()->statusPdf_5;
                $array['statusPdf_6'] = $r->row()->statusPdf_6;
                $array['statusPdf_7'] = $r->row()->statusPdf_7;
                $array['statusPdf_16'] = $r->row()->statusPdf_16;
                $array['statusValidacion'] = $r->row()->statusValidacion;
                $array['statusValidacion2'] = $r->row()->statusValidacion2;

                //Gestoria
                $array['idGestoria'] = $r->row()->idGestoria;
                $array['idAltaVenta'] = $r->row()->idAltaVenta;
                $array['statusGestoria'] = $r->row()->statusGestoria;
                $array['fechaCambio'] = $r->row()->fechaCambio;
                $array['aplicaFolio'] = $r->row()->aplicaFolio;
                $array['numeroFolio'] = $r->row()->numeroFolio;
                $array['numeroCredito'] = $r->row()->numeroCredito;
                $array['numeroEscritura'] = $r->row()->numeroEscritura;
                $array['numeroCredito2'] = $r->row()->numeroCredito2;
                $array['valorTerreno'] = $r->row()->valorTerreno;
                $array['numeroAvaluo'] = $r->row()->numeroAvaluo;
                $array['fechaIngreso'] = $r->row()->fechaIngreso;
                $array['certificadoLibertad'] = $r->row()->certificadoLibertad;
                $array['constanciaNoAdeudo'] = $r->row()->constanciaNoAdeudo;
                $array['precioVentaOci'] = $r->row()->precioVentaOci;
                $array['montoOci'] = $r->row()->montoOci;
                $array['subCuenta'] = $r->row()->subCuenta;
                $array['gastosTitulacion'] = $r->row()->gastosTitulacion;
                $array['ahorroVol'] = $r->row()->ahorroVol;
                $array['seguroCalidad'] = $r->row()->seguroCalidad;
                $array['subsidio'] = $r->row()->subsidio;
                $array['sumaFinal'] = $r->row()->sumaFinal;
                $array['difPropioPeculioTitulacion'] = $r->row()->difPropioPeculioTitulacion;
                $array['fechaFirma'] = $r->row()->fechaFirma;
                $array['ronda'] = $r->row()->ronda;
                $array['motivoCancelacion'] = $r->row()->motivoCancelacion;
                $array['fechaEscritura'] = $r->row()->fechaEscritura;
                $array['superficieTerreno'] = $r->row()->superficieTerreno;
                $array['pdf_8'] = $r->row()->pdf_8;
                $array['statusPdf_8'] = $r->row()->statusPdf_8;
                $array['pdf_9'] = $r->row()->pdf_9;
                $array['statusPdf_9'] = $r->row()->statusPdf_9;
                $array['pdf_10'] = $r->row()->pdf_10;
                $array['statusPdf_10'] = $r->row()->statusPdf_10;
                $array['pdf_11'] = $r->row()->pdf_11;
                $array['statusPdf_11'] = $r->row()->statusPdf_11;
                $array['pdf_15'] = $r->row()->pdf_15;

                switch ($modulo) {
                    case 'getComisiones': //regresamos los campos referente a comisiones y bonos
                        //$array['idAltaVentaComisiones'] = $r->row()->idAltaVentaComisiones;
                        $array['idComision'] = $r->row()->idComision;
                        $array['difPropioPeculio'] = $r->row()->difPropioPeculio;
                        $array['resultado'] = $r->row()->resultado;
                        $array['saldo'] = $r->row()->saldo;
                        $array['cierre'] = $r->row()->cierre;
                        $array['importeComision'] = $r->row()->importeComision;
                        $array['netoVenta'] = $r->row()->netoVenta;
                        $array['diferenciaVendedor'] = $r->row()->diferenciaVendedor;
                        $array['comentarios'] = $r->row()->comentarios;
                        break;

                    case 'getAutorizaciones':
                        $array['idAutorizacion'] = $r->row()->idAutorizacion;
                        //Campos referente a comisiones y bonos
                        $array['idComision'] = $r->row()->idComision;
                        $array['difPropioPeculio'] = $r->row()->difPropioPeculio;
                        $array['resultado'] = $r->row()->resultado;
                        $array['saldo'] = $r->row()->saldo;
                        $array['cierre'] = $r->row()->cierre;
                        $array['importeComision'] = $r->row()->importeComision;
                        $array['netoVenta'] = $r->row()->netoVenta;
                        $array['diferenciaVendedor'] = $r->row()->diferenciaVendedor;
                        $array['comentarios'] = $r->row()->comentarios;

                        //Campos referentes a autorizaciones
                        $array['montoTotal'] = $r->row()->montoTotal;
                        $array['peculioAutorizaciones'] = $r->row()->peculioAutorizaciones;
                        $array['resultadoAutorizaciones'] = $r->row()->resultadoAutorizaciones;
                        $array['propVenta'] = $r->row()->propVenta;
                        $array['statusAutorizacion'] = $r->row()->statusAutorizacion;
                        $array['porcentajePrimerPago'] = $r->row()->porcentajePrimerPago;
                        $array['primerPagoPromotor'] = $r->row()->primerPagoPromotor;
                        $array['fechaPrimerPagoPromotor'] = $r->row()->fechaPrimerPagoPromotor;
                        $array['tPago1'] = $r->row()->tPago1;
                        $array['segundoPagoPromotor'] = $r->row()->segundoPagoPromotor;
                        $array['fechaSegundoPagoPromotor'] = $r->row()->fechaSegundoPagoPromotor;
                        $array['pctjeComisionTotal'] = $r->row()->pctjeComisionTotal;
                        $array['tPago2'] = $r->row()->tPago2;
                        $array['primerPagoCoordinador'] = $r->row()->primerPagoCoordinador;
                        $array['fechaPrimerPagoCoordinador'] = $r->row()->fechaPrimerPagoCoordinador;
                        $array['segundoPagoCoordinador'] = $r->row()->segundoPagoCoordinador;
                        $array['fechaSegundoPagoCoordinador'] = $r->row()->fechaSegundoPagoCoordinador;
                        $array['bonificacion'] = $r->row()->bonificacion;
                        $array['fechaBonificacion'] = $r->row()->fechaBonificacion;
                        $array['createdAutorizaciones'] = $r->row()->createdAutorizaciones;
                        break;

                    case 'getDepositos':
                        //$array['idAutorizacion'] = $r->row()->idAutorizacion;

                        //Campos referente a comisiones y bonos
                        $array['idComision'] = $r->row()->idComision;
                        $array['difPropioPeculio'] = $r->row()->difPropioPeculio;
                        $array['resultado'] = $r->row()->resultado;
                        $array['saldo'] = $r->row()->saldo;
                        $array['cierre'] = $r->row()->cierre;
                        $array['importeComision'] = $r->row()->importeComision;
                        $array['netoVenta'] = $r->row()->netoVenta;
                        $array['diferenciaVendedor'] = $r->row()->diferenciaVendedor;
                        $array['comentarios'] = $r->row()->comentarios;
                        $array['pagoUno'] = $r->row()->pagoUno;
                        $array['fechaPagoUno'] = $r->row()->fechaPagoUno;
                        $array['pagoDos'] = $r->row()->pagoDos;
                        $array['fechaPagoDos'] = $r->row()->fechaPagoDos;
                        $array['pagoTres'] = $r->row()->pagoTres;
                        $array['fechaPagoTres'] = $r->row()->fechaPagoTres;
                        $array['pagoCuatro'] = $r->row()->pagoCuatro;
                        $array['fechaPagoCuatro'] = $r->row()->fechaPagoCuatro;
                        $array['pagoCinco'] = $r->row()->pagoCinco;
                        $array['fechaPagoCinco'] = $r->row()->fechaPagoCinco;
                        $array['pagoSeis'] = $r->row()->pagoSeis;
                        $array['fechaPagoSeis'] = $r->row()->fechaPagoSeis;
                        $array['pagoSiete'] = $r->row()->pagoSiete;
                        $array['fechaPagoSiete'] = $r->row()->fechaPagoSiete;
                        $array['pagoOcho'] = $r->row()->pagoOcho;
                        $array['fechaPagoOcho'] = $r->row()->fechaPagoOcho;
                        $array['pagoNueve'] = $r->row()->pagoNueve;
                        $array['fechaPagoNueve'] = $r->row()->fechaPagoNueve;
                        $array['pagoDiez'] = $r->row()->pagoDiez;
                        $array['fechaPagoDiez'] = $r->row()->fechaPagoDiez;
                         $array['pagoOnce'] = $r->row()->pagoOnce;
                        $array['fechaPagoOnce'] = $r->row()->fechaPagoOnce;
                        //Campos referentes a autorizaciones
                       /* $array['montoTotal'] = $r->row()->montoTotal;
                        $array['peculioAutorizaciones'] = $r->row()->peculioAutorizaciones;
                        $array['resultadoAutorizaciones'] = $r->row()->resultadoAutorizaciones;
                        $array['propVenta'] = $r->row()->propVenta;
                        $array['statusAutorizacion'] = $r->row()->statusAutorizacion;*/

                        //Campos referentes a depositos
                        $array['idDeposito'] = $r->row()->idDeposito;
                        $array['montoTotalDepositos'] = $r->row()->montoTotalDepositos;
                        $array['peculioDepositos'] = $r->row()->peculioDepositos;
                        $array['resultadoDepositos'] = $r->row()->resultadoDepositos;
                        $array['propVentaDepositos'] = $r->row()->propVentaDepositos;
                        $array['statusAutorizacionDepositos'] = $r->row()->statusAutorizacionDepositos;
                        $array['depositoInfonavit'] = $r->row()->depositoInfonavit;
                        $array['depositoConavi'] = $r->row()->depositoConavi;
                        $array['fechaDeposito'] = $r->row()->fechaDeposito;
                        $array['cuentaDepositada'] = $r->row()->cuentaDepositada;
                        break;

                    case 'getEntrega':
                        $array['idEntrega'] = $r->row()->idEntrega;
                        $array['fechaEntrega'] = $r->row()->fechaEntrega;
                        $array['pdf_12'] = $r->row()->pdf_12;
                        $array['pdf_13'] = $r->row()->pdf_13;
                        break;

                    case 'getPostventa': //regresamos los campos referente a la tabla postventa, anexamos datos de entrega

                        $array['idEntrega'] = $r->row()->idEntrega;
                        $array['fechaEntrega'] = $r->row()->fechaEntrega;
                        $array['pdf_12'] = $r->row()->pdf_12;
                        $array['pdf_13'] = $r->row()->pdf_13;

                        $array['idPostventa'] = $r->row()->idPostventa;
                        $array['instElectricas'] = $r->row()->instElectricas;
                        $array['instHidraulicas'] = $r->row()->instHidraulicas;
                        $array['instSanitarias'] = $r->row()->instSanitarias;
                        $array['instGas'] = $r->row()->instGas;
                        $array['canceleria'] = $r->row()->canceleria;
                        $array['impermeabilizacion'] = $r->row()->impermeabilizacion;
                        $array['acabados'] = $r->row()->acabados;
                        $array['estructural'] = $r->row()->estructural;
                        $array['accesorios'] = $r->row()->accesorios;
                        $array['calentadorAgua'] = $r->row()->calentadorAgua;
                        $array['pdf_14'] = $r->row()->pdf_14;
                        break;

                    default:
                        # code...
                        break;
                }

                $array['status'] = $r->row()->status;
                $array['txtstatus'] = $r->row()->txtstatus;
            }

            return $array;
        }

        /*
        private function _populateValuesComisiones($r){
            $array = array();
            if (!is_numeric($r)){
                $array['idAltaVentaComisiones'] = $r->row()->idAltaVentaComisiones;
                $array['difPropioPeculio'] = $r->row()->difPropioPeculio;
                $array['resultado'] = $r->row()->resultado;
                $array['saldo'] = $r->row()->saldo;
                $array['cierre'] = $r->row()->cierre;
                $array['importeComision'] = $r->row()->importeComision;
                $array['netoVenta'] = $r->row()->netoVenta;
            }
            return $array;
        }*/

        function getAll(){
            $id=$_SESSION["viv"]["id"];
            $query="SELECT ".$this->selectDefault.",".$this->selectProspecto.",".$this->selectProyecto." FROM prospectos AS pro, alta_venta AS av
                    LEFT JOIN proyectos AS proy ON proy.id = av.idProyecto
                    LEFT JOIN prospectos AS pros ON pros.id = av.idProspecto
                    WHERE pro.id=av.idProspecto
                    AND av.status = 1 ";
            if($_SESSION["viv"]["rol"] > 1 && $_SESSION["viv"]["rol"] != 2){
                $query.=" AND proy.idFraccionamiento IN (SELECT idFraccionamiento FROM fraccionamientosxusuarios WHERE idUsuario=$id)";
            }
            if($_SESSION["viv"]["rol"]==2){
                $query.=" AND pro.idPromotor=$id AND pros.idFraccionamiento IN (SELECT idFraccionamiento FROM fraccionamientosxusuarios WHERE idUsuario=$id) ";
            }//antes era proy.idFraccionamiento
            $query .= " AND (SELECT f.status FROM fraccionamientos AS f WHERE f.id=pros.idFraccionamiento)=1";
            $query .= " ORDER BY av.id DESC";
            $query=$this->db->query($query);
            if($query->num_rows()>0){
                return $query;
            }else{
                return 0;
            }
        }

        function csvCufrisa2(){
            //$id=$_SESSION['viv']['id'];
            $query = $this->db->query("
                SELECT av.id AS 'No'
                ,UPPER(pro.nombre) AS 'Nombre(s)'
                ,UPPER(pro.apellidoP) AS 'Primer Apellido'
                ,UPPER(pro.apellidoM) AS 'Segundo Apellido'
                ,pro.nss AS 'Número de Seguro Social'
                ,UPPER(pro.curp) AS 'CURP'
                ,UPPER(pro.rfc) AS 'RFC'
                ,pro.fechaNac AS 'Fecha de nacimiento'
                ,UPPER(pro.paisNac) AS 'País de Nacimiento'
                ,UPPER(pro.paisResidencia) AS 'País de Residencia'
                ,UPPER(pro.nacionalidad) AS 'Nacionalidad'
                ,UPPER(pro.entidadNac) AS 'Entidad Federativa de nacimiento'
                ,UPPER(pro.calleProspecto) AS 'Calle'
                ,pro.numeroCasa AS '# Exterior'
                ,pro.numeroInterior AS '# Interior'
                ,UPPER(pro.colonia) AS 'Colonia'
                ,pro.codigoPostal AS 'Código Postal'
                ,UPPER(pro.entidad) AS 'Entidad Federativa'
                ,UPPER(pro.ciudad) AS 'Delegación/Municipio'
                ,UPPER(pro.genero) AS 'Género Masculino/Femenino'
                ,pro.telefono AS 'Número telefónico'
                ,UPPER(pro.ocupacion) AS 'Ocupación'
                ,pro.email AS 'Correo Electrónico'
                ,'' AS 'Firma Electrónica (FIEL)'
                ,av.numNotaria AS 'Número de Notaría'
                ,UPPER(no.nombre) AS 'Nombre Notario'
                ,UPPER(no.apellidoP) AS 'Apellido Paterno Notario'
                ,UPPER(no.apellidoM) AS 'Apellido Materno Notario'
                ,UPPER(pro.credito) AS 'Crédito - Individual/Mancomunado'
                ,ges.numeroEscritura AS 'Número de escritura'
                ,UPPER(proy.calle) AS 'Calle vivienda'
                ,proy.manzana AS 'Manzana vivienda'
                ,proy.lote AS 'Lote vivienda'
                ,'' AS 'Edificio'
                ,proy.nivel AS 'Nivel (Piso)'
                ,proy.nOficial AS 'Número Exterior'
                ,proy.numeroInterior AS 'Número Interior'
                ,UPPER(fra.estado) AS 'Entidad Federativa Vivienda'
                ,UPPER(fra.municipio) AS 'Delegación/Municipio Vivienda'
                ,UPPER(fra.colonia) AS 'Colonia vivienda'
                ,fra.cp AS 'Código Postal vivienda'
                ,ges.sumaFinal AS 'Monto de crédito'
                ,ges.numeroCredito AS 'Número de crédito'
                ,ges.subsidio AS 'Monto de subsidio (Conavi)'
                ,ges.precioVentaOci AS 'Valor de vivienda'
                ,av.diferencia AS 'Diferencias'
                ,ges.valorTerreno AS 'Valor del terreno'
                ,ges.numeroAvaluo AS 'Número de avalúo'
                ,'' AS 'Fecha de Avalúo'
                ,IF(proy.cuv IS NULL or proy.cuv='','',concat(proy.cuv,' ','.'))  AS 'Clave Única de Vivienda (CUV)'
                ,ges.ronda AS 'Ronda'
                FROM alta_venta AS av
                JOIN prospectos AS pro ON pro.id = av.idProspecto
                LEFT JOIN notarias AS no ON no.id = av.idNotaria
                JOIN proyectos AS proy ON proy.id = av.idProyecto
                JOIN fraccionamientos AS fra ON fra.id = pro.idFraccionamiento
                JOIN gestoria AS ges ON av.id = ges.idAltaVenta
                -- JOIN autorizaciones AS au ON av.id = au.idAltaVenta
                WHERE fra.status=1
                ORDER BY av.id ASC
            ");

            /*
                FROM prospectos AS pro
                LEFT JOIN alta_venta AS av ON pro.id = av.idProspecto
                LEFT JOIN proyectos AS proy ON proy.id = av.idProyecto
                LEFT JOIN notarias AS no ON no.id = av.idNotaria
                LEFT JOIN gestoria AS ges ON av.id = ges.idAltaVenta
                LEFT JOIN fraccionamientos AS fra ON fra.id = pro.idFraccionamiento

                -- WHERE av.statusValidacion = 5

                ORDER BY pro.id ASC
            */

            if($query->num_rows()>0){
                return $query;
            }else{
                return 0;
            }
        }

        function csvCufrisa(){

            $query = $this->db->query("

                (SELECT av.id AS No
                -- ,pro.id AS id
                -- ,pro.credito  AS 'credito'
                ,UPPER(pro.nombre) AS 'Nombre(s)'
                ,UPPER(pro.apellidoP) AS 'Primer Apellido'
                ,UPPER(pro.apellidoM) AS 'Segundo Apellido'
                ,pro.nss AS 'Número de Seguro Social'
                ,UPPER(pro.curp) AS 'CURP'
                ,UPPER(pro.rfc) AS 'RFC'
                ,pro.fechaNac AS 'Fecha de nacimiento'
                ,UPPER(pro.paisNac) AS 'País de Nacimiento'
                ,UPPER(pro.paisResidencia) AS 'País de Residencia'
                ,UPPER(pro.nacionalidad) AS 'Nacionalidad'
                ,UPPER(pro.entidadNac) AS 'Entidad Federativa de nacimiento'
                ,UPPER(pro.calleProspecto) AS 'Calle'
                ,pro.numeroCasa AS '# Exterior'
                ,pro.numeroInterior AS '# Interior'
                ,UPPER(pro.colonia) AS 'Colonia'
                ,pro.codigoPostal AS 'Código Postal'
                ,UPPER(pro.entidad) AS 'Entidad Federativa'
                ,UPPER(pro.ciudad) AS 'Delegación/Municipio'
                ,UPPER(pro.genero) AS 'Género Masculino/Femenino'
                ,pro.telefono AS 'Número telefónico'
                ,UPPER(pro.ocupacion) AS 'Ocupación'
                ,pro.email AS 'Correo Electrónico'
                ,'' AS 'Firma Electrónica (FIEL)'
                ,av.numNotaria AS 'Número de Notaría'
                ,UPPER(no.nombre) AS 'Nombre Notario'
                ,UPPER(no.apellidoP) AS 'Apellido Paterno Notario'
                ,UPPER(no.apellidoM) AS 'Apellido Materno Notario'
                ,UPPER(pro.credito) AS 'Crédito - Individual/Mancomunado'
                ,ges.numeroEscritura AS 'Número de escritura'
                ,UPPER(proy.calle) AS 'Calle vivienda'
                ,proy.manzana AS 'Manzana vivienda'
                ,proy.lote AS 'Lote vivienda'
                ,'' AS 'Edificio'
                ,proy.nivel AS 'Nivel (Piso)'
                ,proy.nOficial AS 'Número Exterior'
                ,proy.numeroInterior AS 'Número Interior'
                ,UPPER(fra.estado) AS 'Entidad Federativa Vivienda'
                ,UPPER(fra.municipio) AS 'Delegación/Municipio Vivienda'
                ,UPPER(fra.colonia) AS 'Colonia vivienda'
                ,fra.cp AS 'Código Postal vivienda'
                ,ges.sumaFinal AS 'Monto de crédito'
                ,ges.numeroCredito AS 'Número de crédito'
                ,ges.subsidio AS 'Monto de subsidio (Conavi)'
                ,ges.precioVentaOci AS 'Valor de vivienda'
                ,av.diferencia AS 'Diferencias'
                ,aut.difPropPeculio AS 'Dif. Propio Peculio'
                ,prot.nombre AS 'Prototipo'
                ,ges.valorTerreno AS 'Valor del terreno'
                ,ges.superficieTerreno AS 'Superficie del Terreno'
                ,ges.numeroAvaluo AS 'Número de avalúo'
                ,'' AS 'Fecha de Avalúo'
                ,IF(proy.cuv IS NULL OR proy.cuv='','',CONCAT(proy.cuv,' ','.'))  AS 'Clave Única de Vivienda (CUV)'
                ,ges.ronda AS 'Ronda'
                FROM alta_venta AS av
                JOIN prospectos AS pro ON pro.id = av.idProspecto
                LEFT JOIN notarias AS no ON no.id = av.idNotaria
                JOIN proyectos AS proy ON proy.id = av.idProyecto
                JOIN fraccionamientos AS fra ON fra.id = pro.idFraccionamiento
                JOIN gestoria AS ges ON av.id = ges.idAltaVenta
                LEFT JOIN autorizaciones aut ON aut.idAltaventa=av.id
                LEFT JOIN prototipos prot ON prot.id=proy.idPrototipo
                WHERE fra.status=1
                AND pro.credito = 'mancomunado'
                -- ORDER BY pro.id ASC
                )

                UNION
                (SELECT av.id AS No
                -- ,pro.id AS id
                -- ,pro.credito  AS 'credito'
                ,UPPER(pro.nombre2) AS 'Nombre(s)'
                ,UPPER(pro.apellidoP2) AS 'Primer Apellido'
                ,UPPER(pro.apellidoM2) AS 'Segundo Apellido'
                ,pro.nss2 AS 'Número de Seguro Social'
                ,UPPER(pro.curp2) AS 'CURP'
                ,UPPER(pro.rfc2) AS 'RFC'
                ,pro.fechaNac2 AS 'Fecha de nacimiento'
                ,UPPER(pro.paisNac) AS 'País de Nacimiento'
                ,UPPER(pro.paisResidencia) AS 'País de Residencia'
                ,UPPER(pro.nacionalidad) AS 'Nacionalidad'
                ,UPPER(pro.entidadNac) AS 'Entidad Federativa de nacimiento'
                ,UPPER(pro.calleProspecto) AS 'Calle'
                ,pro.numeroCasa AS '# Exterior'
                ,pro.numeroInterior AS '# Interior'
                ,UPPER(pro.colonia) AS 'Colonia'
                ,pro.codigoPostal AS 'Código Postal'
                ,UPPER(pro.entidad) AS 'Entidad Federativa'
                ,UPPER(pro.ciudad) AS 'Delegación/Municipio'
                ,IF(pro.genero='masculino','FEMENINO','MASCULINO') AS 'Género Masculino/Femenino'
                ,pro.telefono2 AS 'Número telefónico'
                ,UPPER(pro.ocupacion) AS 'Ocupación'
                ,pro.email AS 'Correo Electrónico'
                ,'' AS 'Firma Electrónica (FIEL)'
                ,av.numNotaria AS 'Número de Notaría'
                ,UPPER(no.nombre) AS 'Nombre Notario'
                ,UPPER(no.apellidoP) AS 'Apellido Paterno Notario'
                ,UPPER(no.apellidoM) AS 'Apellido Materno Notario'
                ,UPPER(pro.credito) AS 'Crédito - Individual/Mancomunado'
                ,ges.numeroEscritura AS 'Número de escritura'
                ,UPPER(proy.calle) AS 'Calle vivienda'
                ,proy.manzana AS 'Manzana vivienda'
                ,proy.lote AS 'Lote vivienda'
                ,'' AS 'Edificio'
                ,proy.nivel AS 'Nivel (Piso)'
                ,proy.nOficial AS 'Número Exterior'
                ,proy.numeroInterior AS 'Número Interior'
                ,UPPER(fra.estado) AS 'Entidad Federativa Vivienda'
                ,UPPER(fra.municipio) AS 'Delegación/Municipio Vivienda'
                ,UPPER(fra.colonia) AS 'Colonia vivienda'
                ,fra.cp AS 'Código Postal vivienda'
                ,ges.sumaFinal AS 'Monto de crédito'
                ,ges.numeroCredito2 AS 'Número de crédito'
                ,ges.subsidio AS 'Monto de subsidio (Conavi)'
                ,ges.precioVentaOci AS 'Valor de vivienda'
                ,av.diferencia AS 'Diferencias'
                ,aut.difPropPeculio AS 'Dif. Propio Peculio'
                ,prot.nombre AS 'Prototipo'
                ,ges.valorTerreno AS 'Valor del terreno'
                ,ges.superficieTerreno AS 'Superficie del Terreno'
                ,ges.numeroAvaluo AS 'Número de avalúo'
                ,'' AS 'Fecha de Avalúo'
                ,IF(proy.cuv IS NULL OR proy.cuv='','',CONCAT(proy.cuv,' ','.'))  AS 'Clave Única de Vivienda (CUV)'
                ,ges.ronda AS 'Ronda'
                FROM alta_venta AS av
                JOIN prospectos AS pro ON pro.id = av.idProspecto
                LEFT JOIN notarias AS no ON no.id = av.idNotaria
                JOIN proyectos AS proy ON proy.id = av.idProyecto
                JOIN fraccionamientos AS fra ON fra.id = pro.idFraccionamiento
                JOIN gestoria AS ges ON av.id = ges.idAltaVenta
                LEFT JOIN autorizaciones aut ON aut.idAltaventa=av.id
                LEFT JOIN prototipos prot ON prot.id=proy.idPrototipo
                WHERE fra.status=1
                AND pro.credito = 'mancomunado'
                -- ORDER BY pro.id ASC
                )

                UNION

                (SELECT av.id AS No
                -- ,pro.id AS id
                -- ,pro.credito  AS 'credito'
                ,UPPER(pro.nombre) AS 'Nombre(s)'
                ,UPPER(pro.apellidoP) AS 'Primer Apellido'
                ,UPPER(pro.apellidoM) AS 'Segundo Apellido'
                ,pro.nss AS 'Número de Seguro Social'
                ,UPPER(pro.curp) AS 'CURP'
                ,UPPER(pro.rfc) AS 'RFC'
                ,pro.fechaNac AS 'Fecha de nacimiento'
                ,UPPER(pro.paisNac) AS 'País de Nacimiento'
                ,UPPER(pro.paisResidencia) AS 'País de Residencia'
                ,UPPER(pro.nacionalidad) AS 'Nacionalidad'
                ,UPPER(pro.entidadNac) AS 'Entidad Federativa de nacimiento'
                ,UPPER(pro.calleProspecto) AS 'Calle'
                ,pro.numeroCasa AS '# Exterior'
                ,pro.numeroInterior AS '# Interior'
                ,UPPER(pro.colonia) AS 'Colonia'
                ,pro.codigoPostal AS 'Código Postal'
                ,UPPER(pro.entidad) AS 'Entidad Federativa'
                ,UPPER(pro.ciudad) AS 'Delegación/Municipio'
                ,UPPER(pro.genero) AS 'Género Masculino/Femenino'
                ,pro.telefono AS 'Número telefónico'
                ,UPPER(pro.ocupacion) AS 'Ocupación'
                ,pro.email AS 'Correo Electrónico'
                ,'' AS 'Firma Electrónica (FIEL)'
                ,av.numNotaria AS 'Número de Notaría'
                ,UPPER(no.nombre) AS 'Nombre Notario'
                ,UPPER(no.apellidoP) AS 'Apellido Paterno Notario'
                ,UPPER(no.apellidoM) AS 'Apellido Materno Notario'
                ,UPPER(pro.credito) AS 'Crédito - Individual/Mancomunado'
                ,ges.numeroEscritura AS 'Número de escritura'
                ,UPPER(proy.calle) AS 'Calle vivienda'
                ,proy.manzana AS 'Manzana vivienda'
                ,proy.lote AS 'Lote vivienda'
                ,'' AS 'Edificio'
                ,proy.nivel AS 'Nivel (Piso)'
                ,proy.nOficial AS 'Número Exterior'
                ,proy.numeroInterior AS 'Número Interior'
                ,UPPER(fra.estado) AS 'Entidad Federativa Vivienda'
                ,UPPER(fra.municipio) AS 'Delegación/Municipio Vivienda'
                ,UPPER(fra.colonia) AS 'Colonia vivienda'
                ,fra.cp AS 'Código Postal vivienda'
                ,ges.sumaFinal AS 'Monto de crédito'
                ,ges.numeroCredito AS 'Número de crédito'
                ,ges.subsidio AS 'Monto de subsidio (Conavi)'
                ,ges.precioVentaOci AS 'Valor de vivienda'
                ,av.diferencia AS 'Diferencias'
                ,aut.difPropPeculio AS 'Dif. Propio Peculio'
                ,prot.nombre AS 'Prototipo'
                ,ges.valorTerreno AS 'Valor del terreno'
                ,ges.superficieTerreno AS 'Superficie del Terreno'
                ,ges.numeroAvaluo AS 'Número de avalúo'
                ,'' AS 'Fecha de Avalúo'
                ,IF(proy.cuv IS NULL OR proy.cuv='','',CONCAT(proy.cuv,' ','.'))  AS 'Clave Única de Vivienda (CUV)'
                ,ges.ronda AS 'Ronda'
                FROM alta_venta AS av
                JOIN prospectos AS pro ON pro.id = av.idProspecto
                LEFT JOIN notarias AS no ON no.id = av.idNotaria
                JOIN proyectos AS proy ON proy.id = av.idProyecto
                JOIN fraccionamientos AS fra ON fra.id = pro.idFraccionamiento
                JOIN gestoria AS ges ON av.id = ges.idAltaVenta
                LEFT JOIN autorizaciones aut ON aut.idAltaventa=av.id
                LEFT JOIN prototipos prot ON prot.id=proy.idPrototipo
                WHERE fra.status=1
                -- AND (pro.credito != 'mancomunado')
                -- ORDER BY pro.id ASC
                )

                ORDER BY No ASC

                ");

            if($query->num_rows()>0){
                return $query;
            }else{
                return 0;
            }
        }

        function getReasignacion(){
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.status' => true);
            $this->db->where($arrayWhere);
            //$this->db->where("proy.idFraccionamiento = ".$_SESSION['viv']['idFraccionamiento']);
            $this->db->join("proyectos proy", "proy.id=av.idProyecto");
            $this->db->order_by($this->alias.'.id', "desc");
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $query;
            }else{
                return 0;
            }
        }

        function getAllList() {
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.status' => true);
            $this->db->where($arrayWhere);
            $this->db->order_by($this->alias.'.id', "desc");
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $query;
            }else{
                return 0;
            }
        }

        function getAllListJoinProspectos() {
            $this->db->select($this->selectDefault.",".$this->selectProspecto.",pro.idFraccionamiento",FALSE);
            $arrayWhere = array($this->alias.'.status' => true);
            $this->db->where($arrayWhere);
            $this->db->join("prospectos pro", "pro.id=av.idProspecto");
            $this->db->order_by($this->alias.'.id', "desc");
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $query;
            }else{
                return 0;
            }
        }

        //se obtiene info de la tabla alta_venta
        function getById($id){
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.id' => $id);
            $this->db->where($arrayWhere);
            $this->db->join("prospectos pro", "pro.id=av.idProspecto");
            $this->db->join("proyectos proy", "proy.id=av.idProyecto",'left');
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $this->_populateValues($query);
            }
            else{
                return 0;
            }
        }

        //se obtiene info de alta_venta, prospecto, proyecto
        function getByIdAll($id){//obtiene por id de la tabla alta venta
            $this->db->select($this->selectDefault.",".$this->selectProspecto.",".$this->selectProyecto,FALSE);
            $arrayWhere = array($this->alias.'.id' => $id);
            $this->db->where($arrayWhere);
            $this->db->join("prospectos pro", "pro.id=av.idProspecto");
            $this->db->join("proyectos proy", "proy.id=av.idProyecto");
            //$this->db->order_by($this->alias.'.id', "desc");
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $this->_populateValuesAll($query);
            }
            else{
                return 0;
            }
        }

        function getAllJoin(){
            $id=$_SESSION['viv']['id'];
            $query="SELECT ".$this->selectDefault.",".$this->selectProspecto.",".$this->selectProyecto."
            FROM prospectos AS pro,alta_venta AS av
            LEFT JOIN proyectos AS proy ON proy.id = av.idProyecto
            WHERE (av.statusValidacion=1 OR av.statusValidacion=2 OR av.statusValidacion>2)
            AND av.status=1 AND idProspecto=pro.id AND proy.id=idProyecto ";
            if($_SESSION['viv']['rol'] > 1 && $_SESSION['viv']['rol'] != 4){
                $query.=" AND idProyecto IN (SELECT id FROM proyectos WHERE idFraccionamiento IN (SELECT idFraccionamiento FROM fraccionamientosxusuarios WHERE idUsuario=$id))";
            }
            if($_SESSION['viv']['rol'] == 4){
                $query.=" AND idPromotor IN (SELECT usuarios.id FROM usuarios, fraccionamientosxusuarios WHERE idUsuario=usuarios.id AND rol=2 AND usuarios.created_by LIKE '%$id%')";
            }
            $query .= " AND (SELECT f.status FROM fraccionamientos AS f WHERE f.id=pro.idFraccionamiento)=1";
            $query .= " ORDER BY av.id DESC";
            $query=$this->db->query($query);
            if($query->num_rows()>0){
                return $query;
            }else{
                return 0;
            }
        }

        function getPendientesGestoria(){//pendientes para gestoria
            $id=$_SESSION['viv']['id'];
            $query="SELECT ".$this->selectDefault.",".$this->selectProspecto.",pro.idFraccionamiento
            FROM prospectos AS pro,alta_venta AS av

            WHERE av.statusValidacion=0
            AND av.status=1 AND idProspecto=pro.id ";
            if($_SESSION['viv']['rol'] > 1 && $_SESSION['viv']['rol'] != 4){
                //$query.=" AND idProyecto IN (SELECT id FROM proyectos WHERE idFraccionamiento IN (SELECT idFraccionamiento FROM fraccionamientosxusuarios WHERE idUsuario=$id))";
            }
            if($_SESSION['viv']['rol'] == 4){
                //$query.=" AND idPromotor IN (SELECT usuarios.id FROM usuarios, fraccionamientosxusuarios WHERE idUsuario=usuarios.id AND rol=2 AND usuarios.created_by LIKE '%$id%')";
            }
            $query .= " AND (SELECT f.status FROM fraccionamientos AS f WHERE f.id=pro.idFraccionamiento)=1";
            $query .= " ORDER BY av.id DESC";
            $query=$this->db->query($query);
            if($query->num_rows()>0){
                return $query;
            }else{
                return 0;
            }
        }

        function getAllJoinCron(){ //obtiene los clientes que estan en validacion de venta, estatusValidacion 1
            $query="SELECT av.id AS idAltaVenta,pro.id idProspecto,pro.idFraccionamiento idFraccionamiento,proy.id idProyecto,pro.idPromotor,av.created FROM alta_venta av JOIN prospectos pro ON av.idProspecto = pro.id JOIN proyectos proy ON av.idProyecto = proy.id WHERE av.statusValidacion=2 AND av.status = 1 AND av.idProspecto = pro.id AND proy.id = av.idProyecto ORDER BY av.id DESC"; // (av.statusValidacion=1 OR av.statusValidacion=2 OR av.statusValidacion>2)
            $query=$this->db->query($query);
            if($query->num_rows()>0){
                return $query;
            }else{
                return 0;
            }
        }

        function getJoinGestoria(){ //obtiene los clientes que estan en gestoría (ahora se llamará titulación)
            $id=$_SESSION["viv"]["id"];
            $query="SELECT ".$this->selectDefault.",".$this->selectProspecto.",".$this->selectProyecto.",".$this->selectGestoria." FROM alta_venta AS av,prospectos AS pro,proyectos AS proy,gestoria AS ges WHERE
            pro.id=av.idProspecto AND proy.id=av.idProyecto AND ges.idAltaVenta=av.id AND (av.statusValidacion=3 OR av.statusValidacion=4 OR av.statusValidacion=5) AND av.status=1";
            if($_SESSION["viv"]["rol"] > 1){
                $query.=" AND proy.idFraccionamiento IN (SELECT idFraccionamiento FROM fraccionamientosxusuarios WHERE idUsuario=$id)";
            }
            /*
            $this->db->select($this->selectDefault.",".$this->selectProspecto.",".$this->selectProyecto.",".$this->selectGestoria,FALSE);
            $arrayWhere = array($this->alias.'.statusValidacion' => 3, $this->alias.'.status' => true);
            $this->db->where($arrayWhere);
            $this->db->or_where('av.statusValidacion = 4 AND av.status=1');//indica que a este registros se encuentra disponible para agregar comision
            $this->db->or_where('av.statusValidacion = 5 AND av.status=1'); // indica que a este registros se le ha agregado una comision
            $this->db->join("prospectos pro", "pro.id=av.idProspecto");
            $this->db->join("proyectos proy", "proy.id=av.idProyecto");
            $this->db->join("gestoria ges", "ges.idAltaVenta=av.id");
            $this->db->order_by($this->alias.'.id', "desc");
            $query = $this->db->get($this->table.' AS '.$this->alias);*/
            $query .= " AND (SELECT f.status FROM fraccionamientos AS f WHERE f.id=pro.idFraccionamiento)=1";
            $query.=" ORDER BY av.id DESC";
            $query=$this->db->query($query);
            if($query->num_rows()>0){
                return $query;
            }else{
                return 0;
            }
        }

        function getPendientesTitulacion(){ //obtiene los clientes pendientes para agregar a titulación
            $id=$_SESSION["viv"]["id"];
            $query="SELECT ".$this->selectDefault.",".$this->selectProspecto.",".$this->selectProyecto." FROM alta_venta AS av,prospectos AS pro,proyectos AS proy WHERE
            pro.id=av.idProspecto AND proy.id=av.idProyecto AND av.statusValidacion=2  AND av.status=1";
            if($_SESSION["viv"]["rol"] > 1){
                $query.=" AND proy.idFraccionamiento IN (SELECT idFraccionamiento FROM fraccionamientosxusuarios WHERE idUsuario=$id)";
            }
            $query .= " AND (SELECT f.status FROM fraccionamientos AS f WHERE f.id=pro.idFraccionamiento)=1";
            $query.=" ORDER BY av.id DESC";
            $query=$this->db->query($query);
            if($query->num_rows()>0){
                return $query;
            }else{
                return 0;
            }
        }

        function getPendientesTitulacionCSV(){ //obtiene los clientes pendientes para agregar a titulación
            $id=$_SESSION["viv"]["id"];
            $query="SELECT
            (SELECT titulo FROM fraccionamientos WHERE id = proy.idFraccionamiento) AS 'FRACCIONAMIENTO'
            ,UPPER(CONCAT(pro.nombre,' ',pro.apellidoP)) AS 'CLIENTE'
            ,pro.nss AS 'NSS'
            ,(SELECT UPPER(CONCAT(nombre,' ',apellidoP,' ',apellidoM)) FROM usuarios WHERE id = pro.idPromotor) AS 'PROMOTOR'
            ,proy.lote AS 'LOTE'
            ,proy.manzana AS 'MANZANA'
            ,proy.nOficial AS 'NÚMERO OFICIAL'
            ,proy.calle AS 'CALLE'
            ,proy.cuv AS 'CUV'
            ,av.monto AS 'MONTO'
            ,av.gastosOperacion AS 'GASTOS DE OPERACIÓN'
            ,av.total AS 'TOTAL'
            ,av.diferencia AS 'DIFERENCIA'
            ,av.bonoEquipamiento AS 'BONO DE EQUIPAMIENTO'
            ,proy.precioVenta AS 'PRECIO DE VENTA'
            ,proy.avaluo AS 'AVALUO'
            FROM alta_venta AS av,prospectos AS pro,proyectos AS proy WHERE
            pro.id=av.idProspecto AND proy.id=av.idProyecto AND av.statusValidacion=2  AND av.status=1";
            if($_SESSION["viv"]["rol"] > 1){
                $query.=" AND proy.idFraccionamiento IN (SELECT idFraccionamiento FROM fraccionamientosxusuarios WHERE idUsuario=$id)";
            }
            $query.=" ORDER BY av.id DESC";
            $query=$this->db->query($query);
            if($query->num_rows()>0){
                return $query;
            }else{
                return 0;
            }
        }

        function getJoinGestoriaCancel(){ //obtiene los clientes que estan en gestoría
            $this->db->select($this->selectDefault.",".$this->selectProspecto.",".$this->selectProyecto.",".$this->selectGestoria,FALSE);
            $arrayWhere = array($this->alias.'.status' => false);//$this->alias.'.statusValidacion' => 3,
            $this->db->where($arrayWhere);
            $this->db->where('fra.status',1);

            $this->db->join("prospectos pro", "pro.id=av.idProspecto");
            $this->db->join("proyectos proy", "proy.id=av.idProyecto",'LEFT');
            $this->db->join("gestoria ges", "ges.idAltaVenta=av.id",'LEFT');
            $this->db->join("fraccionamientos fra", "pro.idFraccionamiento=fra.id",'LEFT');
            $this->db->order_by($this->alias.'.id', "desc");
            $query = $this->db->get($this->table.' AS '.$this->alias);

            if($query->num_rows()>0){
                return $query;
            }
            else{
                return 0;
            }
        }

        function getJoinComisiones(){ //obtiene los promotores que pueden ganar comisión
            $id=$_SESSION["viv"]["id"];
            $query="SELECT ".$this->selectDefault.",".$this->selectProspecto.",".$this->selectProyecto.",".$this->selectGestoria.",".$this->selectComisiones." FROM proyectos AS proy,prospectos AS pro,gestoria AS ges,comisiones_bonos AS cb,alta_venta AS av WHERE pro.id=av.idProspecto AND proy.id=av.idProyecto AND ges.idAltaVenta=av.id AND cb.idAltaVenta=av.id
            AND av.statusValidacion=5 AND av.status=1";
            if($_SESSION["viv"]["rol"] > 1){
                $query.=" AND proy.idFraccionamiento IN (SELECT idFraccionamiento FROM fraccionamientosxusuarios WHERE idUsuario=$id)";
            }
            $query .= " AND (SELECT f.status FROM fraccionamientos AS f WHERE f.id=pro.idFraccionamiento)=1";
            $query=$this->db->query($query);
            if($query->num_rows()>0){
                return $query;
            }else{
                return 0;
            }
        }

        function getComisionesPendientes(){ //obtiene los promotores que pueden ganar comisión
            $id=$_SESSION["viv"]["id"];
            $query="
                SELECT ".$this->selectDefault.",".$this->selectProspecto.",".$this->selectProyecto.",".$this->selectGestoria."
                FROM proyectos AS proy,prospectos AS pro,gestoria AS ges,alta_venta AS av
                    WHERE pro.id=av.idProspecto
                    AND proy.id=av.idProyecto
                    AND ges.idAltaVenta=av.id
                    AND proy.statusVenta = 3
                    AND av.statusValidacion=4
                    AND av.status=1
                    AND av.id NOT IN (SELECT idAltaVenta FROM comisiones_bonos)
                ";
            if($_SESSION["viv"]["rol"] > 1){
                $query.=" AND proy.idFraccionamiento IN (SELECT idFraccionamiento FROM fraccionamientosxusuarios WHERE idUsuario=$id)";
            }
            $query=$this->db->query($query);
            if($query->num_rows()>0){
                return $query;
            }else{
                return 0;
            }
        }

        function getJoinComisiones2(){ //obtiene los promotores que pueden ganar comisión
            $this->db->select($this->selectDefault.",".$this->selectProspecto.",".$this->selectProyecto.",".$this->selectGestoria.",".$this->selectComisiones,FALSE);
            $arrayWhere = array($this->alias.'.statusValidacion' => 5, $this->alias.'.status' => true);
            $this->db->where($arrayWhere);
            $id=$_SESSION["viv"]["id"];
            //$this->db->or_where($this->alias.'.statusValidacion = ', 2);
            if($_SESSION['viv']['rol'] == 4){
                $this->db->like('cb.created_by', '%$id%');
                $this->db->where("proy.idFraccionamiento IN (SELECT idFraccionamiento FROM fraccionamientosxusuarios WHERE id=$id)");
            }
            $this->db->join("prospectos pro", "pro.id=av.idProspecto");
            $this->db->join("proyectos proy", "proy.id=av.idProyecto");
            $this->db->join("gestoria ges", "ges.idAltaVenta=av.id");
            $this->db->join("comisiones_bonos cb", "cb.idAltaVenta=av.id");
            $this->db->order_by($this->alias.'.id', "desc");
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $query;
            }else{
                return 0;
            }
        }

        //ESTE MODELO NO SE ETÁ USANDO AL 100 POR AHORA, STAND BY EN AUTORIZACIONES
        function getJoinAutorizaciones(){ //obtiene los proyectos para el módulo de autorizaciones
            $id = $_SESSION["viv"]["id"];
            $this->db->select($this->selectDefault.",".$this->selectProspecto.",".$this->selectProyecto.",".$this->selectGestoria.",".$this->selectComisiones,FALSE);
            $arrayWhere = array($this->alias.'.statusValidacion' => 5, $this->alias.'.status' => true, $this->alias5.'.statusGestoria' => 'detonado');
            $this->db->where($arrayWhere);
            //$this->db->or_where($this->alias.'.statusValidacion = ', 2);
            if($_SESSION["viv"]["rol"] > 1){
                $this->db->where("proy.idFraccionamiento IN (SELECT idFraccionamiento FROM fraccionamientosxusuarios WHERE idUsuario=$id)");
            }
            $this->db->where('fra.status',1);
            $this->db->join("prospectos pro", "pro.id=av.idProspecto");
            $this->db->join("proyectos proy", "proy.id=av.idProyecto");
            $this->db->join("gestoria ges", "ges.idAltaVenta=av.id");
            $this->db->join("comisiones_bonos cb", "cb.idAltaVenta=av.id");
            $this->db->join("fraccionamientos fra", "pro.idFraccionamiento=fra.id",'LEFT');
            $this->db->order_by($this->alias.'.id', "desc");
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $query;
            }
            else{
                return 0;
            }
        }

        function getJoinEntrega(){ //obtiene los clientes que tienen status detonado (notaria) en el modulo de gestoria
            $id = $_SESSION["viv"]["id"];
            $this->db->select($this->selectDefault.",".$this->selectProspecto.",".$this->selectProyecto.",".$this->selectGestoria.",".$this->selectDetallepaquete.",".$this->selectPaquete,FALSE);
            $arrayWhere = array($this->alias.'.status' => true, $this->alias5.'.statusGestoria' => 'detonado');//notaria
            //$this->db->or_where($this->alias.'.statusValidacion = ', 4);//indica que a este registros se encuentra disponible para agregar comision
            //$this->db->or_where($this->alias.'.statusValidacion = ', 5); // indica que a este registros se le ha agregado una comision
            if($_SESSION["viv"]["rol"] > 1){
                $this->db->where("proy.idFraccionamiento IN (SELECT idFraccionamiento FROM fraccionamientosxusuarios WHERE idUsuario=$id)");
            }
            if($_SESSION["viv"]["rol"]==2){
                $this->db->where("pro.idPromotor=$id AND pro.idFraccionamiento IN (SELECT idFraccionamiento FROM fraccionamientosxusuarios WHERE idUsuario=$id)");
            }
            $this->db->where($arrayWhere);
            $this->db->where('fra.status',1);
            $this->db->join("prospectos pro", "pro.id=av.idProspecto");
            $this->db->join("proyectos proy", "proy.id=av.idProyecto");
            $this->db->join("gestoria ges", "ges.idAltaVenta=av.id");
            $this->db->join("fraccionamientos fra", "pro.idFraccionamiento=fra.id",'LEFT');
            $this->db->join("detalle_paquete depa", "depa.idProyecto=proy.id",'LEFT');
            $this->db->join("paquetes paq", "paq.id=depa.idPaquete",'LEFT');
            $this->db->order_by($this->alias.'.id', "desc");
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $query;
            }
            else{
                return 0;
            }
        }

        function getJoinEntregaLast(){ //obtiene los clientes que tienen status detonado (notaria) en el modulo de gestoria
            $id = $_SESSION["viv"]["id"];
            $this->db->select($this->selectDefault.",".$this->selectProspecto.",".$this->selectProyecto.",".$this->selectGestoria.",".$this->selectDetallepaquete.",".$this->selectPaquete,FALSE);
            $arrayWhere = array($this->alias.'.status' => true, $this->alias5.'.statusGestoria' => 'detonado');//notaria
            //$this->db->or_where($this->alias.'.statusValidacion = ', 4);//indica que a este registros se encuentra disponible para agregar comision
            //$this->db->or_where($this->alias.'.statusValidacion = ', 5); // indica que a este registros se le ha agregado una comision
            if($_SESSION["viv"]["rol"] > 1){
                $this->db->where("proy.idFraccionamiento IN (SELECT idFraccionamiento FROM fraccionamientosxusuarios WHERE idUsuario=$id)");
            }
            if($_SESSION["viv"]["rol"]==2){
                $this->db->where("pro.idPromotor=$id AND pro.idFraccionamiento IN (SELECT idFraccionamiento FROM fraccionamientosxusuarios WHERE idUsuario=$id)");
            }
            $this->db->where($arrayWhere);
            $this->db->where('fra.status',1);
            $this->db->join("prospectos pro", "pro.id=av.idProspecto");
            $this->db->join("proyectos proy", "proy.id=av.idProyecto");
            $this->db->join("gestoria ges", "ges.idAltaVenta=av.id");
            $this->db->join("fraccionamientos fra", "pro.idFraccionamiento=fra.id",'LEFT');
            $this->db->join("detalle_paquete depa", "depa.idProyecto=proy.id",'LEFT');
            $this->db->join("paquetes paq", "paq.id=depa.idPaquete",'LEFT');
            $this->db->order_by($this->alias.'.id', "desc");
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $query;
            }
            else{
                return 0;
            }
        }

        function getJoinEntrega2(){ //obtiene los clientes que tienen status detonado (notaria) en el modulo de gestoria
            // $id = $_SESSION["viv"]["id"];
            $this->db->select($this->selectDefault.",".$this->selectProspecto.",".$this->selectProyecto.",".$this->selectGestoria.",".$this->selectEntrega,FALSE);
            $arrayWhere = array($this->alias.'.status' => true, $this->alias5.'.statusGestoria' => 'detonado');//notaria
            //$this->db->or_where($this->alias.'.statusValidacion = ', 4);//indica que a este registros se encuentra disponible para agregar comision
            //$this->db->or_where($this->alias.'.statusValidacion = ', 5); // indica que a este registros se le ha agregado una comision
            // if($_SESSION["viv"]["rol"] > 1){
            //     $this->db->where("proy.idFraccionamiento IN (SELECT idFraccionamiento FROM fraccionamientosxusuarios WHERE idUsuario=$id)");
            // }
            $this->db->where($arrayWhere);
            $this->db->join("prospectos pro", "pro.id=av.idProspecto");
            $this->db->join("proyectos proy", "proy.id=av.idProyecto");
            $this->db->join("gestoria ges", "ges.idAltaVenta=av.id");
            $this->db->join("entrega e", "e.idAltaVenta=av.id");
            $this->db->order_by($this->alias.'.id', "desc");
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $query;
            }
            else{
                return 0;
            }
        }

        function getJoinPostventa(){ //obtiene los clientes registrados en la tabla entrega (entrega de vivienda)
            $id = $_SESSION["viv"]["id"];
            $this->db->select($this->selectDefault.",".$this->selectProspecto.",".$this->selectProyecto.",".$this->selectGestoria,FALSE);
            //$this->db->or_where($this->alias.'.statusValidacion = ', 4);//indica que a este registros se encuentra disponible para agregar comision
            //$this->db->or_where($this->alias.'.statusValidacion = ', 5); // indica que a este registros se le ha agregado una comision
            if($_SESSION["viv"]["rol"] > 1){
                $this->db->where("proy.idFraccionamiento IN (SELECT idFraccionamiento FROM fraccionamientosxusuarios WHERE idUsuario=$id)");
            }
            if($_SESSION["viv"]["rol"]==2){
                $this->db->where("pro.idPromotor=$id AND pro.idFraccionamiento IN (SELECT idFraccionamiento FROM fraccionamientosxusuarios WHERE idUsuario=$id) ");
            }
            $arrayWhere = array($this->alias.'.status' => true, $this->alias5.'.statusGestoria' => 'detonado');//notaria
            $this->db->where($arrayWhere);
            $this->db->where('fra.status',1);
            $this->db->join("prospectos pro", "pro.id=av.idProspecto");
            $this->db->join("proyectos proy", "proy.id=av.idProyecto");
            $this->db->join("gestoria ges", "ges.idAltaVenta=av.id");
            $this->db->join("entrega e", "e.idAltaVenta=av.id");
            $this->db->join("fraccionamientos fra", "pro.idFraccionamiento=fra.id",'LEFT');
            $this->db->order_by($this->alias.'.id', "desc");
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $query;
            }
            else{
                return 0;
            }
        }

        function getJoinPostventa2(){ //obtiene los clientes registrados en la tabla entrega (entrega de vivienda)
            // $id = $_SESSION["viv"]["id"];
            $this->db->select($this->selectDefault.",".$this->selectProspecto.",".$this->selectProyecto.",".$this->selectGestoria.",".$this->selectPostventa,FALSE);
            // $this->db->or_where($this->alias.'.statusValidacion = ', 4);//indica que a este registros se encuentra disponible para agregar comision
            // $this->db->or_where($this->alias.'.statusValidacion = ', 5); // indica que a este registros se le ha agregado una comision
            // if($_SESSION["viv"]["rol"] > 1){
            //     $this->db->where("proy.idFraccionamiento IN (SELECT idFraccionamiento FROM fraccionamientosxusuarios WHERE idUsuario=$id)");
            // }
            $arrayWhere = array($this->alias.'.status' => true, $this->alias5.'.statusGestoria' => 'detonado');//notaria
            $this->db->where($arrayWhere);
            $this->db->join("prospectos pro", "pro.id=av.idProspecto");
            $this->db->join("proyectos proy", "proy.id=av.idProyecto");
            $this->db->join("gestoria ges", "ges.idAltaVenta=av.id");
            $this->db->join("entrega e", "e.idAltaVenta=av.id");
            $this->db->join("postventa pv", "pv.idAltaVenta=av.id");
            $this->db->order_by($this->alias.'.id', "desc");
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $query;
            }
            else{
                return 0;
            }
        }

        function getJoinPostventaIncidencias(){ //obtiene los clientes registrados en la tabla entrega (entrega de vivienda)
            $id = $_SESSION["viv"]["id"];
            $this->db->select($this->selectDefault.",".$this->selectProspecto.",".$this->selectProyecto.",".$this->selectGestoria.",".$this->selectPostventa,FALSE);
            //$this->db->or_where($this->alias.'.statusValidacion = ', 4);//indica que a este registros se encuentra disponible para agregar comision
            //$this->db->or_where($this->alias.'.statusValidacion = ', 5); // indica que a este registros se le ha agregado una comision
            if($_SESSION["viv"]["rol"] > 1){
                $this->db->where("proy.idFraccionamiento IN (SELECT idFraccionamiento FROM fraccionamientosxusuarios WHERE idUsuario=$id)");
            }
            $arrayWhere = array($this->alias.'.status' => true, $this->alias5.'.statusGestoria' => 'detonado', $this->alias9.'.statusIncidencia' => 1);//notaria
            $this->db->where($arrayWhere);
            $this->db->join("prospectos pro", "pro.id=av.idProspecto");
            $this->db->join("proyectos proy", "proy.id=av.idProyecto");
            $this->db->join("gestoria ges", "ges.idAltaVenta=av.id");
            $this->db->join("entrega e", "e.idAltaVenta=av.id");
            $this->db->join("postventa pv", "pv.idAltaVenta=av.id");
            $this->db->order_by($this->alias.'.id', "desc");
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $query;
            }
            else{
                return 0;
            }
        }

        function getJoinPostventaIncidenciasCerradas(){ //obtiene los clientes registrados en la tabla entrega (entrega de vivienda)
            $id = $_SESSION["viv"]["id"];
            $this->db->select($this->selectDefault.",".$this->selectProspecto.",".$this->selectProyecto.",".$this->selectGestoria.",".$this->selectPostventa,FALSE);
            //$this->db->or_where($this->alias.'.statusValidacion = ', 4);//indica que a este registros se encuentra disponible para agregar comision
            //$this->db->or_where($this->alias.'.statusValidacion = ', 5); // indica que a este registros se le ha agregado una comision
            if($_SESSION["viv"]["rol"] > 1){
                $this->db->where("proy.idFraccionamiento IN (SELECT idFraccionamiento FROM fraccionamientosxusuarios WHERE idUsuario=$id)");
            }
            $arrayWhere = array($this->alias.'.status' => true, $this->alias5.'.statusGestoria' => 'detonado', $this->alias9.'.statusIncidencia' => 2);//notaria
            $this->db->where($arrayWhere);
            $this->db->join("prospectos pro", "pro.id=av.idProspecto");
            $this->db->join("proyectos proy", "proy.id=av.idProyecto");
            $this->db->join("gestoria ges", "ges.idAltaVenta=av.id");
            $this->db->join("entrega e", "e.idAltaVenta=av.id");
            $this->db->join("postventa pv", "pv.idAltaVenta=av.id");
            $this->db->order_by($this->alias.'.id', "desc");
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $query;
            }
            else{
                return 0;
            }
        }

        ////////////// INICIA FUNCIONES USADAS EN ACTA DE NACIMIENTO PROYECTO /////////
        function getStatusByIdProyecto($id){
            $this->db->select($this->alias.".statusValidacion",FALSE);
            $arrayWhere = array($this->alias.'.idProyecto' => $id);
            $this->db->where($arrayWhere);
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $query;
            }
            else{
                return 0;
            }
        }

        function getAltaVentaByIdProy($id){
            $this->db->select($this->selectDefault.",".$this->selectProspecto.",".$this->selectProyecto,FALSE);
            $arrayWhere = array($this->alias.'.idProyecto' => $id, $this->alias.'.statusValidacion' => 0);
            $this->db->where($arrayWhere);
            $this->db->join("prospectos pro", "pro.id=av.idProspecto");
            $this->db->join("proyectos proy", "proy.id=av.idProyecto");
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $this->_populateValuesAll($query);
            }
            else{
                return 0;
            }
        }

        function getValidacionVentaByIdProy($id){
            $this->db->select($this->selectDefault.",".$this->selectProspecto.",".$this->selectProyecto,FALSE);
            $arrayWhere = array($this->alias.'.idProyecto' => $id);//$this->alias.'.statusValidacion' => 1
            $this->db->where($arrayWhere);
            $condition = "(av.statusValidacion = 1 OR  av.statusValidacion=2)";
            $this->db->where($condition);
            //$this->db->or_where($this->alias.'.statusValidacion', "2");
            $this->db->join("prospectos pro", "pro.id=av.idProspecto");
            $this->db->join("proyectos proy", "proy.id=av.idProyecto");
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $this->_populateValuesAll($query);
            }else{
                return 0;
            }
        }

        function getGestoriaByIdProy($id){
            $this->db->select($this->selectDefault.",".$this->selectProspecto.",".$this->selectProyecto.",".$this->selectGestoria,FALSE);
            $this->db->where($this->alias.'.idProyecto='.$id." AND av.status=1");
            $this->db->join("prospectos pro", "pro.id=av.idProspecto");
            $this->db->join("proyectos proy", "proy.id=av.idProyecto");
            $this->db->join("gestoria ges", "ges.idAltaVenta=av.id");
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $this->_populateValuesGestoria($query);
            }
            else{
                return 0;
            }
        }
        ///////////// FIN ACTA NACIMIENTO //////////////

        function getByIdForInfonavit($id){ //el $id es de la tabla alta_venta. Esta funcíón nos sirve en editar gestoria y en listado autorizaciones
            $this->db->select($this->selectDefault.",".$this->selectProspecto.",".$this->selectProyecto.",".$this->selectGestoria,FALSE);
            $arrayWhere = array($this->alias.'.id' => $id);
            $this->db->where($arrayWhere);
            $this->db->join("prospectos pro", "pro.id=av.idProspecto");
            $this->db->join("proyectos proy", "proy.id=av.idProyecto",'left');
            $this->db->join("gestoria ges", "ges.idAltaVenta=av.id",'left');
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $this->_populateValuesGestoria($query);
            }
            else{
                return 0;
            }
        }

        function getByIdForGestoria($id){ //el $id es de la tabla alta_venta. Esta funcíón nos sirve en editar gestoria y en listado autorizaciones
            $this->db->select($this->selectDefault.",".$this->selectProspecto.",".$this->selectProyecto.",".$this->selectGestoria,FALSE);
            $arrayWhere = array($this->alias.'.id' => $id);
            $this->db->where($arrayWhere);
            $this->db->join("prospectos pro", "pro.id=av.idProspecto");
            $this->db->join("proyectos proy", "proy.id=av.idProyecto");
            $this->db->join("gestoria ges", "ges.idAltaVenta=av.id");
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $this->_populateValuesGestoria($query);
            }
            else{
                return 0;
            }
        }

        function getByIdForComisiones($id){ //esta función nos sirve en editar comision
            $this->db->select($this->selectDefault.",".$this->selectProspecto.",".$this->selectProyecto.",".$this->selectGestoria.",".$this->selectComisiones,FALSE);
            $arrayWhere = array($this->alias.'.id' => $id); //$this->alias6.'.idComision' => $idComision   Aplicaria en caso de que hayan datos redundantes, en este caso hay que cambiar el helper de acciones para mandar como aprametro el $idComision
            $this->db->where($arrayWhere);
            $this->db->join("prospectos pro", "pro.id=av.idProspecto");
            $this->db->join("proyectos proy", "proy.id=av.idProyecto");
            $this->db->join("gestoria ges", "ges.idAltaVenta=av.id");
            $this->db->join("comisiones_bonos cb", "cb.idAltaVenta=av.id");
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $this->_populateValuesGestoria($query,"getComisiones");
            }
            else{
                return 0;
            }
        }

        function getByIdForAutorizaciones($id){ //esta función nos sirve en editar autorizacion
            $this->db->select($this->selectDefault.",".$this->selectProspecto.",".$this->selectProyecto.",".$this->selectGestoria.",".$this->selectComisiones.",".$this->selectAutorizaciones,FALSE);
            $arrayWhere = array($this->alias.'.id' => $id); //$this->alias6.'.idComision' => $idComision   Aplicaria en caso de que hayan datos redundantes, en este caso hay que cambiar el helper de acciones para mandar como aprametro el $idComision
            $this->db->where($arrayWhere);
            $this->db->join("prospectos pro", "pro.id=av.idProspecto");
            $this->db->join("proyectos proy", "proy.id=av.idProyecto");
            $this->db->join("gestoria ges", "ges.idAltaVenta=av.id");
            $this->db->join("comisiones_bonos cb", "cb.idAltaVenta=av.id");
            $this->db->join("autorizaciones az", "az.idAltaVenta=av.id");
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $this->_populateValuesGestoria($query,"getAutorizaciones");
            }
            else{
                return 0;
            }
        }

        function getByIdForAutorizaciones2(){ //esta función nos sirve en editar autorizacion
            $this->db->select($this->selectDefault.",".$this->selectProspecto.",".$this->selectProyecto.",".$this->selectGestoria.",".$this->selectComisiones.",".$this->selectAutorizaciones,FALSE);
            // $arrayWhere = array($this->alias.'.id' => $id); //$this->alias6.'.idComision' => $idComision   Aplicaria en caso de que hayan datos redundantes, en este caso hay que cambiar el helper de acciones para mandar como aprametro el $idComision
            // $this->db->where($arrayWhere);
            $this->db->join("prospectos pro", "pro.id=av.idProspecto");
            $this->db->join("proyectos proy", "proy.id=av.idProyecto");
            $this->db->join("gestoria ges", "ges.idAltaVenta=av.id");
            $this->db->join("comisiones_bonos cb", "cb.idAltaVenta=av.id");
            $this->db->join("autorizaciones az", "az.idAltaVenta=av.id");
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                // return $this->_populateValuesGestoria($query,"getAutorizaciones");
                return $query;
            }
            else{
                return 0;
            }
        }

        function getByIdForDepositos($id){ //esta función nos sirve en editar autorizacion
            $this->db->select($this->selectDefault.",".$this->selectProspecto.",".$this->selectProyecto.",".$this->selectGestoria.",".$this->selectComisiones.",".$this->selectDepositos,FALSE);
            $arrayWhere = array($this->alias.'.id' => $id); //$this->alias6.'.idComision' => $idComision   Aplicaria en caso de que hayan datos redundantes, en este caso hay que cambiar el helper de acciones para mandar como aprametro el $idComision
            $this->db->where($arrayWhere);
            $this->db->join("prospectos pro", "pro.id=av.idProspecto");
            $this->db->join("proyectos proy", "proy.id=av.idProyecto");
            $this->db->join("gestoria ges", "ges.idAltaVenta=av.id");
            $this->db->join("comisiones_bonos cb", "cb.idAltaVenta=av.id");
            //$this->db->join("autorizaciones az", "az.idAltaVenta=av.id");
            $this->db->join("depositos d", "d.idAltaVenta=av.id");
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $this->_populateValuesGestoria($query,"getDepositos");
            }
            else{
                return 0;
            }
        }

        function getByIdForDepositos2(){ //esta función nos sirve en editar autorizacion
            $this->db->select($this->selectDefault.",".$this->selectProspecto.",".$this->selectProyecto.",".$this->selectGestoria.",".$this->selectComisiones.",".$this->selectDepositos,FALSE);
            // $arrayWhere = array($this->alias.'.id' => $id); //$this->alias6.'.idComision' => $idComision   Aplicaria en caso de que hayan datos redundantes, en este caso hay que cambiar el helper de acciones para mandar como aprametro el $idComision
            // $this->db->where($arrayWhere);
            $this->db->join("prospectos pro", "pro.id=av.idProspecto");
            $this->db->join("proyectos proy", "proy.id=av.idProyecto");
            $this->db->join("gestoria ges", "ges.idAltaVenta=av.id");
            $this->db->join("comisiones_bonos cb", "cb.idAltaVenta=av.id");
            //$this->db->join("autorizaciones az", "az.idAltaVenta=av.id");
            $this->db->join("depositos d", "d.idAltaVenta=av.id");
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $query;
            }
            else{
                return 0;
            }
        }

        function getByIdForPostventa($id){ //esta función nos sirve en editar postventa
            $this->db->select($this->selectDefault.",".$this->selectProspecto.",".$this->selectProyecto.",".$this->selectGestoria.",".$this->selectEntrega,FALSE);
            $arrayWhere = array($this->alias.'.id' => $id);
            $this->db->where($arrayWhere);
            $this->db->join("prospectos pro", "pro.id=av.idProspecto");
            $this->db->join("proyectos proy", "proy.id=av.idProyecto");
            $this->db->join("gestoria ges", "ges.idAltaVenta=av.id");
            //$this->db->join("comisiones_bonos cb", "cb.idAltaVenta=av.id"); //comentamos porque no lo utilizamos en módulo entrega/postventa
            //$this->db->join("autorizaciones az", "az.idAltaVenta=av.id");//comentamos porque no lo utilizamos en módulo entrega/postventa
            $this->db->join("entrega e", "e.idAltaVenta=av.id");
            //$this->db->join("postventa pv", "pv.idAltaVenta=av.id");
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $this->_populateValuesGestoria($query,"getEntrega");
            }
            else{
                return 0;
            }
        }

        function getByIdProspecto($id){ //query para obtener info de prospecto/proyecto a partir del id Prospecto
            $this->db->select($this->selectDefault.",".$this->selectProspecto.",".$this->selectProyecto,FALSE);
            $arrayWhere = array($this->alias.'.idProspecto' => $id);
            $this->db->where($arrayWhere);
            $this->db->join("prospectos pro", "pro.id=av.idProspecto");
            $this->db->join("proyectos proy", "proy.id=av.idProyecto",'left');
            $this->db->limit(1);
            $this->db->order_by($this->alias.'.id', "desc");
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $this->_populateValuesAll($query);
            }
            else{
                return 0;
            }
        }

        function getNSS(){ //select que aparecerá en select alta y edicion de modulo validacion venta
            $this->db->select("DISTINCT(pro.id), IF(pro.curp!='0',CONCAT(pro.nss,' | ',pro.curp),pro.nss) as titulo",FALSE); //pro.nss AS titulo
            $arrayWhere = array($this->alias.'.status' => true, $this->alias.'.statusValidacion' => 0);
            $this->db->where($arrayWhere);
            $id=$_SESSION["viv"]["id"];
            if($_SESSION["viv"]["rol"] > 1){
                $this->db->where("pro.idFraccionamiento IN (SELECT idFraccionamiento FROM fraccionamientosxusuarios WHERE idUsuario=$id)");
            }
            $this->db->join("prospectos pro", "pro.id=av.idProspecto");
            $this->db->order_by($this->alias.'.id', "desc");
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $query;
            }else{
                return 0;
            }
        }

        function getNSSValidVenta(){ //select que aparecerá en alta y edicion de modulo gestoria, estos nss son los que ya se encuentren validados statusValidacion = 2 pero q no se encuentren dados de alta en gestoría statusValidacion != 3
            $id=$_SESSION['viv']['id'];
            $this->db->select("DISTINCT(pro.id), IF(pro.curp!='0',CONCAT(pro.nss,' | ',pro.curp),pro.nss) as titulo",FALSE);//pro.nss AS titulo
            $arrayWhere = array($this->alias.'.status' => true, $this->alias.'.statusValidacion' => 2);
            if($_SESSION['viv']['rol'] > 1){
                $this->db->where("pro.idFraccionamiento IN (SELECT idFraccionamiento FROM fraccionamientosxusuarios WHERE idUsuario=$id)");
            }
            $this->db->where($arrayWhere);
            $this->db->where($this->alias.'.statusValidacion!=','3');
            $this->db->where($this->alias.'.idProyecto >',0);
            $this->db->join("prospectos pro", "pro.id=av.idProspecto");
            //$this->db->order_by($this->alias.'.id', "desc");//se comenta temporalemnte ya que en el server no esta jalando
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $query;
            }else{
                return 0;
            }
        }

        function existRowById($id = null,$activar=false){
            $this->db->select($this->alias.'.id',FALSE);
            $arrayWhere = array($this->alias.'.id' => $id);
            $this->db->where($arrayWhere);
            if(!$activar){
                $this->db->where($this->alias.'.status =',true);
            }
            $this->db->order_by($this->alias.'.id', "desc");
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $query->num_rows();
            }else{
                return 0;
            }
        }

        function existRowByIdForGestoria($id = null){
            $this->db->select($this->alias.'.id',FALSE);
            $arrayWhere = array($this->alias.'.id' => $id, $this->alias.'.statusValidacion' => 2, $this->alias.'.status' => true);
            $this->db->where($arrayWhere);
            $this->db->order_by($this->alias.'.id', "desc");
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $query->num_rows();
            }else{
                return 0;
            }
        }

        function getIdAltaVentaByIdProyecto($id){
            $this->db->select($this->alias.".id",FALSE);
            $arrayWhere = array($this->alias.'.idProyecto' => $id);
            $this->db->where($arrayWhere);
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $query;
            }
            else{
                return 0;
            }
        }

        function getStatusByDate($status=''){
            $query = $this->db->query("
                SELECT id FROM alta_venta WHERE statusValidacion2 = '".$status."'
                AND DATE(created) = CURDATE()
            ");
            if($query->num_rows()>0){
                return $query->num_rows();
            }
            else{
                return 0;
            }
        }

        function getCancelados(){
            $query = $this->db->query("
                SELECT id FROM alta_venta WHERE DATE(fechaCancelacionAv) = CURDATE()

            ");
            if($query->num_rows()>0){
                return $query->num_rows();
            }else{
                return 0;
            }
        }

        public function todosPendientesPago(){
            $query=$this->db->query('
                SELECT fechaVenta AS "FECHAVENTA"
                    ,(SELECT lineaCredito FROM proyectos WHERE id=idProyecto)  AS "T CRED"
                    ,(SELECT UPPER(CONCAT(nombre," ",apellidoP," ",apellidoM)) FROM usuarios WHERE id=(SELECT idPromotor FROM prospectos WHERE id=idProspecto)) AS "PROMOTOR"
                    ,(SELECT UPPER(CONCAT(nombre," ",apellidoP," ",apellidoM)) FROM prospectos WHERE id=idProspecto) AS "CLIENTE"
                    ,(SELECT UPPER(titulo) FROM fraccionamientos WHERE id = (SELECT idFraccionamiento FROM proyectos WHERE id = idProyecto)) AS "FRACCIONAMIENTO"
                    ,(SELECT manzana FROM proyectos WHERE id=idProyecto) AS "MANZANA"
                    ,(SELECT lote FROM proyectos WHERE id=idProyecto) AS "LOTE"
                    ,UPPER(tipoCredito) AS "TIPO DE CREDITO"
                    ,(SELECT precioVenta FROM proyectos WHERE id=idProyecto) AS "PVENTA"
                    ,(SELECT importeComision FROM comisiones_bonos WHERE comisiones_bonos.idAltaVenta = alta_venta.id LIMIT 1) AS "TOTAL COMISION"

                    ,"" AS "OTROS DESC"
                    ,(SELECT precioVenta FROM proyectos WHERE id=idProyecto)*((SELECT comision FROM usuarios WHERE id=(SELECT idPromotor FROM prospectos WHERE id=idProspecto))/100) * (0.03) AS "RETENCIÓN COMISIÓN"

                    , ((SELECT precioVenta FROM proyectos WHERE id=idProyecto)*((SELECT comision FROM usuarios WHERE id=(SELECT idPromotor FROM prospectos WHERE id=idProspecto))/100))
                         -
                      ((SELECT precioVenta FROM proyectos WHERE id=idProyecto)*((SELECT comision FROM usuarios WHERE id=(SELECT idPromotor FROM prospectos WHERE id=idProspecto))/100) * (0.03)) AS "COMISIÓN AL 100"


                    ,(SELECT precioVenta FROM proyectos WHERE id=idProyecto)*((SELECT comision FROM usuarios WHERE id=(SELECT idPromotor FROM prospectos WHERE id=idProspecto))/100) * (0.70) AS "PRIMER COMISIÓN"
                    ,(SELECT fechaPrimerPagoPromotor FROM autorizaciones WHERE autorizaciones.idAltaVenta = alta_venta.id ) AS "FECHA1PAGO"
                    ,(SELECT precioVenta FROM proyectos WHERE id=idProyecto)*((SELECT comision FROM usuarios WHERE id=(SELECT idPromotor FROM prospectos WHERE id=idProspecto))/100) * (0.30) AS "SEGUNDA COMISIÓN"
                    ,
                    (

                        -- VALOR CUFRISA
                        (
                            (SELECT precioVentaOci - difPropioPeculioTitulacion - ahorroVol FROM gestoria WHERE gestoria.idAltaVenta = alta_venta.id)
                            - 2000
                            - 92160
                        )

                         -
                         -- NETO
                         (
                             (
                                -- IMPORTE CUFRISA
                                (
                                    (SELECT precioVentaOci - difPropioPeculioTitulacion - ahorroVol FROM gestoria WHERE gestoria.idAltaVenta = alta_venta.id)
                                     - 2000
                                     - 92160
                                )

                                *
                                0.017
                             )

                             +

                             (
                                -- IVA
                                 (
                                    (
                                        (SELECT precioVentaOci - difPropioPeculioTitulacion - ahorroVol  FROM gestoria WHERE gestoria.idAltaVenta = alta_venta.id)
                                        - 2000
                                        - 92160
                                    )
                                    *
                                    (0.017)
                                 )
                                 *
                                 (0.16)
                             )
                         )


                         +

                         92160

                         -

                        -- COMISION SINDICAL
                         (
                             (SELECT precioVentaOci - difPropioPeculioTitulacion FROM gestoria WHERE gestoria.idAltaVenta = alta_venta.id)
                             *
                             0.04
                         )

                     )

                     -

                     (SELECT precioVenta FROM proyectos WHERE id=idProyecto)  AS "SALDO"

                     ,
                     (
                        (

                        -- VALOR CUFRISA
                        (
                            (SELECT precioVentaOci - difPropioPeculioTitulacion - ahorroVol FROM gestoria WHERE gestoria.idAltaVenta = alta_venta.id)
                            - 2000
                            - 92160
                        )

                         -
                         -- NETO
                         (
                             (
                                -- IMPORTE CUFRISA
                                (
                                    (SELECT precioVentaOci - difPropioPeculioTitulacion - ahorroVol FROM gestoria WHERE gestoria.idAltaVenta = alta_venta.id)
                                     - 2000
                                     - 92160
                                )

                                *
                                0.017
                             )

                             +

                             (
                                -- IVA
                                 (
                                    (
                                        (SELECT precioVentaOci - difPropioPeculioTitulacion - ahorroVol  FROM gestoria WHERE gestoria.idAltaVenta = alta_venta.id)
                                        - 2000
                                        - 92160
                                    )
                                    *
                                    (0.017)
                                 )
                                 *
                                 (0.16)
                             )
                         )


                         +

                         92160

                         -

                        -- COMISION SINDICAL
                         (
                             (SELECT precioVentaOci - difPropioPeculioTitulacion FROM gestoria WHERE gestoria.idAltaVenta = alta_venta.id)
                             *
                             0.04
                         )

                     )

                     -

                     (SELECT precioVenta FROM proyectos WHERE id=idProyecto)
                     )
                     -
                     (
                        (
                        (

                        -- VALOR CUFRISA
                        (
                            (SELECT precioVentaOci - difPropioPeculioTitulacion - ahorroVol FROM gestoria WHERE gestoria.idAltaVenta = alta_venta.id)
                            - 2000
                            - 92160
                        )

                         -
                         -- NETO
                         (
                             (
                                -- IMPORTE CUFRISA
                                (
                                    (SELECT precioVentaOci - difPropioPeculioTitulacion - ahorroVol FROM gestoria WHERE gestoria.idAltaVenta = alta_venta.id)
                                     - 2000
                                     - 92160
                                )

                                *
                                0.017
                             )

                             +

                             (
                                -- IVA
                                 (
                                    (
                                        (SELECT precioVentaOci - difPropioPeculioTitulacion - ahorroVol  FROM gestoria WHERE gestoria.idAltaVenta = alta_venta.id)
                                        - 2000
                                        - 92160
                                    )
                                    *
                                    (0.017)
                                 )
                                 *
                                 (0.16)
                             )
                         )


                         +

                         92160

                         -

                        -- COMISION SINDICAL
                         (
                             (SELECT precioVentaOci - difPropioPeculioTitulacion FROM gestoria WHERE gestoria.idAltaVenta = alta_venta.id)
                             *
                             0.04
                         )

                     )

                     -

                     (SELECT precioVenta FROM proyectos WHERE id=idProyecto)

                        )
                     *
                        (0.03)
                     )

                      AS "BONIFICACIÓN"
                     ,"" AS "SALDO A CONSIDERAR"
                     ,bonoEquipamiento AS "BONO EQUIPAMIENTO"
                     ,"" AS "RETENCIÓN AL 3%"
                     ,"" AS "TOTAL A PAGAR"
                    ,(SELECT fechaSegundoPagoPromotor FROM autorizaciones WHERE autorizaciones.idAltaVenta = alta_venta.id ) AS "FECHA2PAGO"
                    FROM alta_venta
                    WHERE statusValidacion >= 4
                    AND status=1
                    AND (SELECT status FROM fraccionamientos WHERE status=1 AND id= (SELECT idFraccionamiento FROM proyectos WHERE id=idProyecto))
                    AND idProyecto>0
                    -- AND (SELECT idAltaVenta FROM autorizaciones WHERE autorizaciones.idAltaVenta = alta_venta.id AND ((autorizaciones.fechaPrimerPagoPromotor ="" OR autorizaciones.fechaSegundoPagoPromotor ="") OR (autorizaciones.fechaPrimerPagoPromotor ="0000-00-00" OR autorizaciones.fechaSegundoPagoPromotor ="0000-00-00") ) )
                    AND
                    (
                        (SELECT idAltaVenta FROM entrega WHERE entrega.idAltaVenta = alta_venta.id AND statusPago2=0)
                        OR (alta_venta.id NOT IN (SELECT idAltaVenta FROM comisiones_bonos WHERE comisiones_bonos.idAltaVenta = alta_venta.id) AND statusValidacion >= 4 AND CAST(fechaVenta AS CHAR(10))!="0000-00-00" AND CAST(fechaVenta AS CHAR(1))!="")
                    )
                ');
            return $query;
        }

        /*public function todosPendientesPagoHtml($id=null){
            $and = ($id>0)?" AND alta_venta.id =".$id:"";
            $query=$this->db->query('
                SELECT fechaVenta AS "statusPago"
                    ,id
                    ,idProyecto
                    ,idProspecto
                    ,(SELECT lineaCredito FROM proyectos WHERE id=idProyecto)  AS "tCred"
                    ,(SELECT UPPER(CONCAT(nombre," ",apellidoP," ",apellidoM)) FROM usuarios WHERE id=(SELECT idPromotor FROM prospectos WHERE id=idProspecto)) AS "promotor"
                    ,(SELECT UPPER(CONCAT(nombre," ",apellidoP," ",apellidoM)) FROM prospectos WHERE id=idProspecto) AS "cliente"
                    ,(SELECT UPPER(titulo) FROM fraccionamientos WHERE id = (SELECT idFraccionamiento FROM proyectos WHERE id = idProyecto)) AS "fraccionamiento"
                    ,(SELECT manzana FROM proyectos WHERE id=idProyecto) AS "manzana"
                    ,(SELECT lote FROM proyectos WHERE id=idProyecto) AS "lote"
                    ,UPPER(tipoCredito) AS "tCred2"
                    ,(SELECT precioVenta FROM proyectos WHERE id=idProyecto) AS "pVenta"
                    ,(SELECT importeComision FROM comisiones_bonos WHERE comisiones_bonos.idAltaVenta = alta_venta.id LIMIT 1) AS "totComision"

                    ,"" AS "otrosDesc"
                    ,((SELECT precioVenta FROM proyectos WHERE id=idProyecto)*(0.02)) * (0.03) AS "retencionComision"

                    , ((SELECT precioVenta FROM proyectos WHERE id=idProyecto)*(0.02))
                         -
                    ((SELECT precioVenta FROM proyectos WHERE id=idProyecto)*(0.02) * (0.03)) AS "comisionAl100"

                    ,(SELECT precioVenta FROM proyectos WHERE id=idProyecto)*(0.02) * (0.90) AS "primerComision"
                    ,(SELECT fechaPrimerPagoPromotor FROM autorizaciones WHERE autorizaciones.idAltaVenta = alta_venta.id ) AS "fecha1Pago"
                    ,(SELECT precioVenta FROM proyectos WHERE id=idProyecto)*(0.02) * (0.10) AS "segundaComision"


                    -- ,(SELECT precioVenta FROM proyectos WHERE id=idProyecto)*((SELECT comision FROM usuarios WHERE id=(SELECT idPromotor FROM prospectos WHERE id=idProspecto))/100) * (0.03) AS "retencionComision"

                    -- , ((SELECT precioVenta FROM proyectos WHERE id=idProyecto)*((SELECT comision FROM usuarios WHERE id=(SELECT idPromotor FROM prospectos WHERE id=idProspecto))/100))
                    --     -
                    -- ((SELECT precioVenta FROM proyectos WHERE id=idProyecto)*((SELECT comision FROM usuarios WHERE id=(SELECT idPromotor FROM prospectos WHERE id=idProspecto))/100) * (0.03)) AS "comisionAl100"

                    -- ,(SELECT precioVenta FROM proyectos WHERE id=idProyecto)*((SELECT comision FROM usuarios WHERE id=(SELECT idPromotor FROM prospectos WHERE id=idProspecto))/100) * (0.70) AS "primerComision"
                    -- ,(SELECT fechaPrimerPagoPromotor FROM autorizaciones WHERE autorizaciones.idAltaVenta = alta_venta.id ) AS "fecha1Pago"
                    -- ,(SELECT precioVenta FROM proyectos WHERE id=idProyecto)*((SELECT comision FROM usuarios WHERE id=(SELECT idPromotor FROM prospectos WHERE id=idProspecto))/100) * (0.30) AS "segundaComision"
                    ,
                    (

                        -- VALOR CUFRISA
                        (
                            (SELECT precioVentaOci - difPropioPeculioTitulacion - ahorroVol FROM gestoria WHERE gestoria.idAltaVenta = alta_venta.id)
                            - 2000
                            - (SELECT valorTerreno FROM gestoria WHERE gestoria.idAltaVenta = alta_venta.id) -- 92160
                        )

                         -
                         -- NETO
                         (
                             (
                                -- IMPORTE CUFRISA
                                (
                                    (SELECT precioVentaOci - difPropioPeculioTitulacion - ahorroVol FROM gestoria WHERE gestoria.idAltaVenta = alta_venta.id)
                                     - 2000
                                     - (SELECT valorTerreno FROM gestoria WHERE gestoria.idAltaVenta = alta_venta.id) -- 92160
                                )

                                *
                                0.017
                             )

                             +

                             (
                                -- IVA
                                 (
                                    (
                                        (SELECT precioVentaOci - difPropioPeculioTitulacion - ahorroVol  FROM gestoria WHERE gestoria.idAltaVenta = alta_venta.id)
                                        - 2000
                                        - (SELECT valorTerreno FROM gestoria WHERE gestoria.idAltaVenta = alta_venta.id) -- 92160
                                    )
                                    *
                                    (0.017)
                                 )
                                 *
                                 (0.16)
                             )
                         )


                         +

                         (SELECT valorTerreno FROM gestoria WHERE gestoria.idAltaVenta = alta_venta.id) -- 92160

                         -

                        -- COMISION SINDICAL
                         (
                             (SELECT precioVentaOci - difPropioPeculioTitulacion FROM gestoria WHERE gestoria.idAltaVenta = alta_venta.id)
                             *
                             0.04
                         )

                     )

                     -

                     (SELECT precioVenta FROM proyectos WHERE id=idProyecto)  AS "saldo"

                     ,
                     (
                        (

                        -- VALOR CUFRISA
                        (
                            (SELECT precioVentaOci - difPropioPeculioTitulacion - ahorroVol FROM gestoria WHERE gestoria.idAltaVenta = alta_venta.id)
                            - 2000
                            - (SELECT valorTerreno FROM gestoria WHERE gestoria.idAltaVenta = alta_venta.id) -- 92160
                        )

                         -
                         -- NETO
                         (
                             (
                                -- IMPORTE CUFRISA
                                (
                                    (SELECT precioVentaOci - difPropioPeculioTitulacion - ahorroVol FROM gestoria WHERE gestoria.idAltaVenta = alta_venta.id)
                                     - 2000
                                     - (SELECT valorTerreno FROM gestoria WHERE gestoria.idAltaVenta = alta_venta.id) -- 92160
                                )

                                *
                                0.017
                             )

                             +

                             (
                                -- IVA
                                 (
                                    (
                                        (SELECT precioVentaOci - difPropioPeculioTitulacion - ahorroVol  FROM gestoria WHERE gestoria.idAltaVenta = alta_venta.id)
                                        - 2000
                                        - (SELECT valorTerreno FROM gestoria WHERE gestoria.idAltaVenta = alta_venta.id) -- 92160
                                    )
                                    *
                                    (0.017)
                                 )
                                 *
                                 (0.16)
                             )
                         )


                         +

                         (SELECT valorTerreno FROM gestoria WHERE gestoria.idAltaVenta = alta_venta.id) -- 92160

                         -

                        -- COMISION SINDICAL
                         (
                             (SELECT precioVentaOci - difPropioPeculioTitulacion FROM gestoria WHERE gestoria.idAltaVenta = alta_venta.id)
                             *
                             0.04
                         )

                     )

                     -

                     (SELECT precioVenta FROM proyectos WHERE id=idProyecto)
                     )
                     -
                     (
                        (
                        (

                        -- VALOR CUFRISA
                        (
                            (SELECT precioVentaOci - difPropioPeculioTitulacion - ahorroVol FROM gestoria WHERE gestoria.idAltaVenta = alta_venta.id)
                            - 2000
                            - (SELECT valorTerreno FROM gestoria WHERE gestoria.idAltaVenta = alta_venta.id) -- 92160
                        )

                         -
                         -- NETO
                         (
                             (
                                -- IMPORTE CUFRISA
                                (
                                    (SELECT precioVentaOci - difPropioPeculioTitulacion - ahorroVol FROM gestoria WHERE gestoria.idAltaVenta = alta_venta.id)
                                     - 2000
                                     - (SELECT valorTerreno FROM gestoria WHERE gestoria.idAltaVenta = alta_venta.id) -- 92160
                                )

                                *
                                0.017
                             )

                             +

                             (
                                -- IVA
                                 (
                                    (
                                        (SELECT precioVentaOci - difPropioPeculioTitulacion - ahorroVol  FROM gestoria WHERE gestoria.idAltaVenta = alta_venta.id)
                                        - 2000
                                        - (SELECT valorTerreno FROM gestoria WHERE gestoria.idAltaVenta = alta_venta.id) -- 92160
                                    )
                                    *
                                    (0.017)
                                 )
                                 *
                                 (0.16)
                             )
                         )


                         +

                         (SELECT valorTerreno FROM gestoria WHERE gestoria.idAltaVenta = alta_venta.id) -- 92160

                         -

                        -- COMISION SINDICAL
                         (
                             (SELECT precioVentaOci - difPropioPeculioTitulacion FROM gestoria WHERE gestoria.idAltaVenta = alta_venta.id)
                             *
                             0.04
                         )

                     )

                     -

                     (SELECT precioVenta FROM proyectos WHERE id=idProyecto)

                        )
                     *
                        (0.03)
                     )

                      AS "bonificacion"
                     ,"" AS "saldoConsiderar"
                     ,bonoEquipamiento
                     ,"" AS "retencion"
                     ,"" AS "totalPagar"
                    ,(SELECT fechaSegundoPagoPromotor FROM autorizaciones WHERE autorizaciones.idAltaVenta = alta_venta.id ) AS "fecha2Pago"
                    FROM alta_venta
                    WHERE statusValidacion >= 4
                    AND status=1
                    AND (SELECT status FROM fraccionamientos WHERE status=1 AND id= (SELECT idFraccionamiento FROM proyectos WHERE id=idProyecto))
                    AND idProyecto>0
                    -- AND (SELECT idAltaVenta FROM autorizaciones WHERE autorizaciones.idAltaVenta = alta_venta.id AND ((autorizaciones.fechaPrimerPagoPromotor ="" OR autorizaciones.fechaSegundoPagoPromotor ="") OR (autorizaciones.fechaPrimerPagoPromotor ="0000-00-00" OR autorizaciones.fechaSegundoPagoPromotor ="0000-00-00") ) )
                    AND
                    (
                        (SELECT idAltaVenta FROM entrega WHERE entrega.idAltaVenta = alta_venta.id AND statusPago2=0)

                        OR (alta_venta.id NOT IN (SELECT idAltaVenta FROM comisiones_bonos WHERE comisiones_bonos.idAltaVenta = alta_venta.id) AND statusValidacion >= 4 AND CAST(fechaVenta AS CHAR(10))!="0000-00-00" AND CAST(fechaVenta AS CHAR(1))!="")
                    )
                    '.$and.'

                ');
            return $query;
        }*/

        public function todosPendientesPagoHtml($id=null){
            $and = ($id>0)?" AND alta_venta.id =".$id:"";
            $query=$this->db->query('
                SELECT fechaVenta AS "statusPago"
                    ,id
                    ,idProyecto
                    ,idProspecto
                    ,(SELECT lineaCredito FROM proyectos WHERE id=idProyecto)  AS "tCred"
                    ,(SELECT UPPER(CONCAT(nombre," ",apellidoP," ",apellidoM)) FROM usuarios WHERE id=(SELECT idPromotor FROM prospectos WHERE id=idProspecto)) AS "promotor"
                    ,(SELECT UPPER(CONCAT(nombre," ",apellidoP," ",apellidoM)) FROM prospectos WHERE id=idProspecto) AS "cliente"
                    ,(SELECT UPPER(titulo) FROM fraccionamientos WHERE id = (SELECT idFraccionamiento FROM proyectos WHERE id = idProyecto)) AS "fraccionamiento"
                    ,(SELECT manzana FROM proyectos WHERE id=idProyecto) AS "manzana"
                    ,(SELECT lote FROM proyectos WHERE id=idProyecto) AS "lote"
                    ,UPPER(tipoCredito) AS "tCred2"
                    ,(SELECT precioVenta FROM proyectos WHERE id=idProyecto) AS "pVenta"
                    ,(SELECT importeComision FROM comisiones_bonos WHERE comisiones_bonos.idAltaVenta = alta_venta.id LIMIT 1) AS "totComision"

                    ,"" AS "otrosDesc"
                    ,(SELECT precioVenta FROM proyectos WHERE id=idProyecto)*((SELECT comision FROM usuarios WHERE id=(SELECT idPromotor FROM prospectos WHERE id=idProspecto))/100) * (0.03) AS "retencionComision"

                    , ((SELECT precioVenta FROM proyectos WHERE id=idProyecto)*((SELECT comision FROM usuarios WHERE id=(SELECT idPromotor FROM prospectos WHERE id=idProspecto))/100))
                         -
                      ((SELECT precioVenta FROM proyectos WHERE id=idProyecto)*((SELECT comision FROM usuarios WHERE id=(SELECT idPromotor FROM prospectos WHERE id=idProspecto))/100) * (0.03)) AS "comisionAl100"

                    ,(SELECT precioVenta FROM proyectos WHERE id=idProyecto)*((SELECT comision FROM usuarios WHERE id=(SELECT idPromotor FROM prospectos WHERE id=idProspecto))/100) * (0.70) AS "primerComision"
                    ,(SELECT fechaPrimerPagoPromotor FROM autorizaciones WHERE autorizaciones.idAltaVenta = alta_venta.id ) AS "fecha1Pago"
                    ,(SELECT precioVenta FROM proyectos WHERE id=idProyecto)*((SELECT comision FROM usuarios WHERE id=(SELECT idPromotor FROM prospectos WHERE id=idProspecto))/100) * (0.30) AS "segundaComision"
                    ,
                    (

                        -- VALOR CUFRISA
                        (
                            (SELECT precioVentaOci - difPropioPeculioTitulacion - ahorroVol FROM gestoria WHERE gestoria.idAltaVenta = alta_venta.id)
                            - 2000
                            - (SELECT valorTerreno FROM gestoria WHERE gestoria.idAltaVenta = alta_venta.id) -- 92160
                        )

                         -
                         -- NETO
                         (
                             (
                                -- IMPORTE CUFRISA
                                (
                                    (SELECT precioVentaOci - difPropioPeculioTitulacion - ahorroVol FROM gestoria WHERE gestoria.idAltaVenta = alta_venta.id)
                                     - 2000
                                     - (SELECT valorTerreno FROM gestoria WHERE gestoria.idAltaVenta = alta_venta.id) -- 92160
                                )

                                *
                                0.017
                             )

                             +

                             (
                                -- IVA
                                 (
                                    (
                                        (SELECT precioVentaOci - difPropioPeculioTitulacion - ahorroVol  FROM gestoria WHERE gestoria.idAltaVenta = alta_venta.id)
                                        - 2000
                                        - (SELECT valorTerreno FROM gestoria WHERE gestoria.idAltaVenta = alta_venta.id) -- 92160
                                    )
                                    *
                                    (0.017)
                                 )
                                 *
                                 (0.16)
                             )
                         )


                         +

                         (SELECT valorTerreno FROM gestoria WHERE gestoria.idAltaVenta = alta_venta.id) -- 92160

                         -

                        -- COMISION SINDICAL
                         (
                             (SELECT precioVentaOci - difPropioPeculioTitulacion FROM gestoria WHERE gestoria.idAltaVenta = alta_venta.id)
                             *
                             0.04
                         )

                     )

                     -

                     (SELECT precioVenta FROM proyectos WHERE id=idProyecto)  AS "saldo"

                     ,
                     (
                        (

                        -- VALOR CUFRISA
                        (
                            (SELECT precioVentaOci - difPropioPeculioTitulacion - ahorroVol FROM gestoria WHERE gestoria.idAltaVenta = alta_venta.id)
                            - 2000
                            - (SELECT valorTerreno FROM gestoria WHERE gestoria.idAltaVenta = alta_venta.id) -- 92160
                        )

                         -
                         -- NETO
                         (
                             (
                                -- IMPORTE CUFRISA
                                (
                                    (SELECT precioVentaOci - difPropioPeculioTitulacion - ahorroVol FROM gestoria WHERE gestoria.idAltaVenta = alta_venta.id)
                                     - 2000
                                     - (SELECT valorTerreno FROM gestoria WHERE gestoria.idAltaVenta = alta_venta.id) -- 92160
                                )

                                *
                                0.017
                             )

                             +

                             (
                                -- IVA
                                 (
                                    (
                                        (SELECT precioVentaOci - difPropioPeculioTitulacion - ahorroVol  FROM gestoria WHERE gestoria.idAltaVenta = alta_venta.id)
                                        - 2000
                                        - (SELECT valorTerreno FROM gestoria WHERE gestoria.idAltaVenta = alta_venta.id) -- 92160
                                    )
                                    *
                                    (0.017)
                                 )
                                 *
                                 (0.16)
                             )
                         )


                         +

                         (SELECT valorTerreno FROM gestoria WHERE gestoria.idAltaVenta = alta_venta.id) -- 92160

                         -

                        -- COMISION SINDICAL
                         (
                             (SELECT precioVentaOci - difPropioPeculioTitulacion FROM gestoria WHERE gestoria.idAltaVenta = alta_venta.id)
                             *
                             0.04
                         )

                     )

                     -

                     (SELECT precioVenta FROM proyectos WHERE id=idProyecto)
                     )
                     -
                     (
                        (
                        (

                        -- VALOR CUFRISA
                        (
                            (SELECT precioVentaOci - difPropioPeculioTitulacion - ahorroVol FROM gestoria WHERE gestoria.idAltaVenta = alta_venta.id)
                            - 2000
                            - (SELECT valorTerreno FROM gestoria WHERE gestoria.idAltaVenta = alta_venta.id) -- 92160
                        )

                         -
                         -- NETO
                         (
                             (
                                -- IMPORTE CUFRISA
                                (
                                    (SELECT precioVentaOci - difPropioPeculioTitulacion - ahorroVol FROM gestoria WHERE gestoria.idAltaVenta = alta_venta.id)
                                     - 2000
                                     - (SELECT valorTerreno FROM gestoria WHERE gestoria.idAltaVenta = alta_venta.id) -- 92160
                                )

                                *
                                0.017
                             )

                             +

                             (
                                -- IVA
                                 (
                                    (
                                        (SELECT precioVentaOci - difPropioPeculioTitulacion - ahorroVol  FROM gestoria WHERE gestoria.idAltaVenta = alta_venta.id)
                                        - 2000
                                        - (SELECT valorTerreno FROM gestoria WHERE gestoria.idAltaVenta = alta_venta.id) -- 92160
                                    )
                                    *
                                    (0.017)
                                 )
                                 *
                                 (0.16)
                             )
                         )


                         +

                         (SELECT valorTerreno FROM gestoria WHERE gestoria.idAltaVenta = alta_venta.id) -- 92160

                         -

                        -- COMISION SINDICAL
                         (
                             (SELECT precioVentaOci - difPropioPeculioTitulacion FROM gestoria WHERE gestoria.idAltaVenta = alta_venta.id)
                             *
                             0.04
                         )

                     )

                     -

                     (SELECT precioVenta FROM proyectos WHERE id=idProyecto)

                        )
                     *
                        (0.03)
                     )

                      AS "bonificacion"
                     ,"" AS "saldoConsiderar"
                     ,bonoEquipamiento
                     ,"" AS "retencion"
                     ,"" AS "totalPagar"
                    ,(SELECT fechaSegundoPagoPromotor FROM autorizaciones WHERE autorizaciones.idAltaVenta = alta_venta.id ) AS "fecha2Pago"
                    FROM alta_venta
                    WHERE statusValidacion >= 4
                    AND status=1
                    AND (SELECT status FROM fraccionamientos WHERE status=1 AND id= (SELECT idFraccionamiento FROM proyectos WHERE id=idProyecto))
                    AND idProyecto>0
                    -- AND (SELECT idAltaVenta FROM autorizaciones WHERE autorizaciones.idAltaVenta = alta_venta.id AND ((autorizaciones.fechaPrimerPagoPromotor ="" OR autorizaciones.fechaSegundoPagoPromotor ="") OR (autorizaciones.fechaPrimerPagoPromotor ="0000-00-00" OR autorizaciones.fechaSegundoPagoPromotor ="0000-00-00") ) )
                    AND
                    (
                        (SELECT idAltaVenta FROM entrega WHERE entrega.idAltaVenta = alta_venta.id AND statusPago2=0)

                        OR (alta_venta.id NOT IN (SELECT idAltaVenta FROM comisiones_bonos WHERE comisiones_bonos.idAltaVenta = alta_venta.id) AND statusValidacion >= 4 AND CAST(fechaVenta AS CHAR(10))!="0000-00-00" AND CAST(fechaVenta AS CHAR(1))!="")
                    )
                    '.$and.'

                ');
            return $query;
        }

        //PENDIENTES PRIMER PAGO COMISIÓN
        function csvPrimerComision(){
            $query = $this->db->query('
                SELECT fechaVenta AS "STATUSPAGO"
                    ,(SELECT lineaCredito FROM proyectos WHERE id=idProyecto)  AS "T CRED"
                    ,(SELECT UPPER(CONCAT(nombre," ",apellidoP," ",apellidoM)) FROM usuarios WHERE id=(SELECT idPromotor FROM prospectos WHERE id=idProspecto)) AS "PROMOTOR"
                    ,(SELECT UPPER(CONCAT(nombre," ",apellidoP," ",apellidoM)) FROM prospectos WHERE id=idProspecto) AS "CLIENTE"
                    ,(SELECT UPPER(titulo) FROM fraccionamientos WHERE id = (SELECT idFraccionamiento FROM proyectos WHERE id = idProyecto)) AS "FRACCIONAMIENTO"
                    ,(SELECT manzana FROM proyectos WHERE id=idProyecto) AS "MANZANA"
                    ,(SELECT lote FROM proyectos WHERE id=idProyecto) AS "LOTE"
                    ,UPPER(tipoCredito) AS "TIPO DE CREDITO"
                    ,(SELECT precioVenta FROM proyectos WHERE id=idProyecto) AS "PVENTA"
                    ,(SELECT precioVenta FROM proyectos WHERE id=idProyecto)*((SELECT comision FROM usuarios WHERE id=(SELECT idPromotor FROM prospectos WHERE id=idProspecto))/100) AS "TOTAL COMISIÓN"
                    ,"" AS "OTROS DESC"
                    ,(SELECT precioVenta FROM proyectos WHERE id=idProyecto)*((SELECT comision FROM usuarios WHERE id=(SELECT idPromotor FROM prospectos WHERE id=idProspecto))/100) * (0.03) AS "RETENCIÓN COMISIÓN"

                    , ((SELECT precioVenta FROM proyectos WHERE id=idProyecto)*((SELECT comision FROM usuarios WHERE id=(SELECT idPromotor FROM prospectos WHERE id=idProspecto))/100))
                         -
                      ((SELECT precioVenta FROM proyectos WHERE id=idProyecto)*((SELECT comision FROM usuarios WHERE id=(SELECT idPromotor FROM prospectos WHERE id=idProspecto))/100) * (0.03)) AS "COMISIÓN AL 100"
                    ,(SELECT precioVenta FROM proyectos WHERE id=idProyecto)*((SELECT comision FROM usuarios WHERE id=(SELECT idPromotor FROM prospectos WHERE id=idProspecto))/100) * (0.70) AS "PRIMER COMISIÓN"
                    ,(SELECT precioVenta FROM proyectos WHERE id=idProyecto)*((SELECT comision FROM usuarios WHERE id=(SELECT idPromotor FROM prospectos WHERE id=idProspecto))/100) * (0.30) AS "SEGUNDA COMISIÓN"
                    FROM alta_venta
                    WHERE statusValidacion = 4
                    AND STATUS=1
                    AND idProyecto>0
                    AND (SELECT statusVenta FROM proyectos WHERE alta_venta.idProyecto = proyectos.id AND proyectos.statusVenta)=3
                    AND alta_venta.id NOT IN (SELECT idAltaVenta FROM comisiones_bonos WHERE comisiones_bonos.idAltaVenta = alta_venta.id)
            ');

            return $query;
        }

        //PENDIENTES SEGUNDO PAGO COMISIÓN
        function csvSegundaComision(){
            $query = $this->db->query('
                SELECT fechaVenta AS "STATUSPAGO"
                    ,(SELECT lineaCredito FROM proyectos WHERE id=idProyecto)  AS "T CRED"
                    ,(SELECT UPPER(CONCAT(nombre," ",apellidoP," ",apellidoM)) FROM usuarios WHERE id=(SELECT idPromotor FROM prospectos WHERE id=idProspecto)) AS "PROMOTOR"
                    ,(SELECT UPPER(CONCAT(nombre," ",apellidoP," ",apellidoM)) FROM prospectos WHERE id=idProspecto) AS "CLIENTE"
                    ,(SELECT UPPER(titulo) FROM fraccionamientos WHERE id = (SELECT idFraccionamiento FROM proyectos WHERE id = idProyecto)) AS "FRACCIONAMIENTO"
                    ,(SELECT manzana FROM proyectos WHERE id=idProyecto) AS "MANZANA"
                    ,(SELECT lote FROM proyectos WHERE id=idProyecto) AS "LOTE"
                    ,UPPER(tipoCredito) AS "TIPO DE CREDITO"
                    ,(SELECT precioVenta FROM proyectos WHERE id=idProyecto) AS "PVENTA"
                    ,(SELECT precioVenta FROM proyectos WHERE id=idProyecto)*((SELECT comision FROM usuarios WHERE id=(SELECT idPromotor FROM prospectos WHERE id=idProspecto))/100) AS "TOTAL COMISIÓN"
                    ,"" AS "OTROS DESC"
                    ,(SELECT precioVenta FROM proyectos WHERE id=idProyecto)*((SELECT comision FROM usuarios WHERE id=(SELECT idPromotor FROM prospectos WHERE id=idProspecto))/100) * (0.03) AS "RETENCIÓN COMISIÓN"

                    , ((SELECT precioVenta FROM proyectos WHERE id=idProyecto)*((SELECT comision FROM usuarios WHERE id=(SELECT idPromotor FROM prospectos WHERE id=idProspecto))/100))
                         -
                      ((SELECT precioVenta FROM proyectos WHERE id=idProyecto)*((SELECT comision FROM usuarios WHERE id=(SELECT idPromotor FROM prospectos WHERE id=idProspecto))/100) * (0.03)) AS "COMISIÓN AL 100"
                    ,(SELECT precioVenta FROM proyectos WHERE id=idProyecto)*((SELECT comision FROM usuarios WHERE id=(SELECT idPromotor FROM prospectos WHERE id=idProspecto))/100) * (0.70) AS "PRIMER COMISIÓN"
                    ,(SELECT precioVenta FROM proyectos WHERE id=idProyecto)*((SELECT comision FROM usuarios WHERE id=(SELECT idPromotor FROM prospectos WHERE id=idProspecto))/100) * (0.30) AS "SEGUNDA COMISIÓN"
                    FROM alta_venta
                    WHERE statusValidacion = 5
                    AND STATUS=1
                    AND idProyecto>0
                    AND (SELECT statusVenta FROM proyectos WHERE alta_venta.idProyecto = proyectos.id AND proyectos.statusVenta)=3
                    AND alta_venta.id IN (SELECT idAltaVenta FROM comisiones_bonos WHERE comisiones_bonos.idAltaVenta = alta_venta.id)

            ');

            return $query;
        }

        //COMISIONES TODO EL INVENTARIO
        function csvComisiones(){
            $query = $this->db->query('
                SELECT fechaVenta AS "STATUSPAGO"
                ,(SELECT lineaCredito FROM proyectos WHERE id=idProyecto)  AS "T CRED"
                ,(SELECT UPPER(CONCAT(nombre," ",apellidoP," ",apellidoM)) FROM usuarios WHERE id=(SELECT idPromotor FROM prospectos WHERE id=idProspecto)) AS "PROMOTOR"
                ,(SELECT UPPER(CONCAT(nombre," ",apellidoP," ",apellidoM)) FROM prospectos WHERE id=idProspecto) AS "CLIENTE"
                ,(SELECT UPPER(titulo) FROM fraccionamientos WHERE id = (SELECT idFraccionamiento FROM proyectos WHERE id = idProyecto)) AS "FRACCIONAMIENTO"
                ,(SELECT manzana FROM proyectos WHERE id=idProyecto) AS "MANZANA"
                ,(SELECT lote FROM proyectos WHERE id=idProyecto) AS "LOTE"
                ,UPPER(tipoCredito) AS "TIPO DE CREDITO"
                ,(SELECT precioVenta FROM proyectos WHERE id=idProyecto) AS "PVENTA"
                ,(SELECT importeComision FROM comisiones_bonos WHERE comisiones_bonos.idAltaVenta = alta_venta.id) AS "TOTAL COMISIÓN"
                ,"" AS "OTROS DESC"
                ,(SELECT (importeComision*0.03) FROM comisiones_bonos WHERE comisiones_bonos.idAltaVenta = alta_venta.id) AS "RETENCIÓN COMISIÓN"
                ,(SELECT (importeComision) - (importeComision*0.03) FROM comisiones_bonos WHERE comisiones_bonos.idAltaVenta = alta_venta.id) AS "COMISIÓN AL 100"
                ,(SELECT primerPagoPromotor FROM autorizaciones WHERE autorizaciones.idAltaVenta = alta_venta.id) AS "PRIMER COMISIÓN"
                ,(SELECT segundoPagoPromotor FROM autorizaciones WHERE autorizaciones.idAltaVenta = alta_venta.id) AS "SEGUNDA COMISIÓN"
                FROM alta_venta
                WHERE statusValidacion >= 4
                AND status=1
                AND idProyecto>0
                AND alta_venta.id IN (SELECT idAltaVenta FROM comisiones_bonos WHERE comisiones_bonos.idAltaVenta = alta_venta.id)
                -- AND alta_venta.id IN (SELECT idAltaVenta FROM autorizaciones WHERE autorizaciones.idAltaVenta = alta_venta.id)
            ');

            return $query;
        }

        //DEPOSITOS TODO EL INVENTARIO
        function csvDepositos(){
            $query = $this->db->query('
                SELECT fechaVenta AS "STATUSPAGO"
                ,(SELECT lineaCredito FROM proyectos WHERE id=idProyecto)  AS "T CRED"
                ,(SELECT UPPER(CONCAT(nombre," ",apellidoP," ",apellidoM)) FROM prospectos WHERE id=idProspecto) AS "CLIENTE"
                ,(SELECT precioVenta FROM proyectos WHERE id=idProyecto) AS "VALOR DE VENTA"
                ,(SELECT ronda FROM gestoria WHERE gestoria.idAltaVenta = alta_venta.id) AS "RONDA"
                ,(SELECT manzana FROM proyectos WHERE id=idProyecto) AS "MANZANA"
                ,(SELECT lote FROM proyectos WHERE id=idProyecto) AS "LOTE"
                ,(SELECT UPPER(titulo) FROM fraccionamientos WHERE id = (SELECT idFraccionamiento FROM proyectos WHERE id = idProyecto)) AS "FRACCIONAMIENTO"
                ,fechaVenta AS "FECHA FIRMA"
                ,
                    (

                        -- VALOR CUFRISA
                        (
                            (SELECT precioVentaOci - difPropioPeculioTitulacion - ahorroVol FROM gestoria WHERE gestoria.idAltaVenta = alta_venta.id)
                            - 2000
                            - 92160
                        )

                         -
                         -- NETO
                         (
                             (
                                -- IMPORTE CUFRISA
                                (
                                    (SELECT precioVentaOci - difPropioPeculioTitulacion - ahorroVol FROM gestoria WHERE gestoria.idAltaVenta = alta_venta.id)
                                     - 2000
                                     - 92160
                                )

                                *
                                0.017
                             )

                             +

                             (
                                -- IVA
                                 (
                                    (
                                        (SELECT precioVentaOci - difPropioPeculioTitulacion - ahorroVol  FROM gestoria WHERE gestoria.idAltaVenta = alta_venta.id)
                                        - 2000
                                        - 92160
                                    )
                                    *
                                    (0.017)
                                 )
                                 *
                                 (0.16)
                             )
                         )


                         +

                         92160

                         -

                        -- COMISION SINDICAL
                         (
                             (SELECT precioVentaOci - difPropioPeculioTitulacion FROM gestoria WHERE gestoria.idAltaVenta = alta_venta.id)
                             *
                             0.04
                         )

                     )

                     -

                     (SELECT precioVenta FROM proyectos WHERE id=idProyecto)  AS "SALDO"

                     ,
                     (
                        (

                        -- VALOR CUFRISA
                        (
                            (SELECT precioVentaOci - difPropioPeculioTitulacion - ahorroVol FROM gestoria WHERE gestoria.idAltaVenta = alta_venta.id)
                            - 2000
                            - 92160
                        )

                         -
                         -- NETO
                         (
                             (
                                -- IMPORTE CUFRISA
                                (
                                    (SELECT precioVentaOci - difPropioPeculioTitulacion - ahorroVol FROM gestoria WHERE gestoria.idAltaVenta = alta_venta.id)
                                     - 2000
                                     - 92160
                                )

                                *
                                0.017
                             )

                             +

                             (
                                -- IVA
                                 (
                                    (
                                        (SELECT precioVentaOci - difPropioPeculioTitulacion - ahorroVol  FROM gestoria WHERE gestoria.idAltaVenta = alta_venta.id)
                                        - 2000
                                        - 92160
                                    )
                                    *
                                    (0.017)
                                 )
                                 *
                                 (0.16)
                             )
                         )


                         +

                         92160

                         -

                        -- COMISION SINDICAL
                         (
                             (SELECT precioVentaOci - difPropioPeculioTitulacion FROM gestoria WHERE gestoria.idAltaVenta = alta_venta.id)
                             *
                             0.04
                         )

                     )

                     -

                     (SELECT precioVenta FROM proyectos WHERE id=idProyecto)
                     )
                     -
                     (
                        (
                        (

                        -- VALOR CUFRISA
                        (
                            (SELECT precioVentaOci - difPropioPeculioTitulacion - ahorroVol FROM gestoria WHERE gestoria.idAltaVenta = alta_venta.id)
                            - 2000
                            - 92160
                        )

                         -
                         -- NETO
                         (
                             (
                                -- IMPORTE CUFRISA
                                (
                                    (SELECT precioVentaOci - difPropioPeculioTitulacion - ahorroVol FROM gestoria WHERE gestoria.idAltaVenta = alta_venta.id)
                                     - 2000
                                     - 92160
                                )

                                *
                                0.017
                             )

                             +

                             (
                                -- IVA
                                 (
                                    (
                                        (SELECT precioVentaOci - difPropioPeculioTitulacion - ahorroVol  FROM gestoria WHERE gestoria.idAltaVenta = alta_venta.id)
                                        - 2000
                                        - 92160
                                    )
                                    *
                                    (0.017)
                                 )
                                 *
                                 (0.16)
                             )
                         )


                         +

                         92160

                         -

                        -- COMISION SINDICAL
                         (
                             (SELECT precioVentaOci - difPropioPeculioTitulacion FROM gestoria WHERE gestoria.idAltaVenta = alta_venta.id)
                             *
                             0.04
                         )

                     )

                     -

                     (SELECT precioVenta FROM proyectos WHERE id=idProyecto)

                        )
                     *
                        (0.03)
                     )

                      AS "BONIFICACIÓN"
                     ,"" AS "SALDO A CONSIDERAR"
                     ,bonoEquipamiento AS "BONO EQUIPAMIENTO"
                     ,"" AS "RETENCIÓN AL 3%"
                     ,"" AS "TOTAL A PAGAR"
                FROM alta_venta
                WHERE statusValidacion >= 4
                AND status=1
                AND idProyecto>0
            ');

            return $query;
        }
        
        public function todosPendientesBonificacion($id=null){
            //si es id, probablemente sea para el modal de pago
            //se usa para crear o editar, así que se quita la validacion de que no exista en bonificaciones
            $and = ($id > 0 && $id != null)? " AND alta_venta.id =".$id : "AND alta_venta.id NOT IN (SELECT idAltaVenta FROM bonificaciones WHERE bonificaciones.idAltaVenta = alta_venta.id)";
            $idUsu = $_SESSION["viv"]["id"];
            //$and2 = '';
            if($_SESSION["viv"]["rol"] > 1){
                $and .= " AND idProyecto IN (SELECT id FROM proyectos proy WHERE proy.idFraccionamiento IN (SELECT idFraccionamiento FROM fraccionamientosxusuarios WHERE idUsuario = $idUsu) )";
            }
            /*if($_SESSION["viv"]["rol"]==2){
                $and2 = " AND pro.idPromotor=$idUsu AND pro.idFraccionamiento IN (SELECT idFraccionamiento FROM fraccionamientosxusuarios WHERE idUsuario=$id)";
            }*/
            $fideicomiso = 870;
            $avaluo = 2100;
            $query=$this->db->query("
                SELECT fechaVenta AS 'fechaDetona'
                    ,id
                    ,idProyecto
                    ,idProspecto
                    ,(SELECT lineaCredito FROM proyectos WHERE proyectos.id=alta_venta.idProyecto)  AS 'linea'
                    ,(SELECT UPPER(CONCAT(nombre,' ',apellidoP,' ',apellidoM)) FROM usuarios WHERE usuarios.id=(SELECT idPromotor FROM prospectos WHERE prospectos.id=alta_venta.idProspecto)) AS 'promotor'
                    ,(SELECT UPPER(CONCAT(nombre,' ',apellidoP,' ',apellidoM)) FROM prospectos WHERE prospectos.id=alta_venta.idProspecto) AS 'cliente'
                    ,(SELECT UPPER(titulo) FROM fraccionamientos WHERE fraccionamientos.id = (SELECT idFraccionamiento FROM proyectos WHERE proyectos.id = alta_venta.idProyecto)) AS 'fraccionamiento'
                    ,(SELECT manzana FROM proyectos WHERE proyectos.id=alta_venta.idProyecto) AS 'manzana'
                    ,(SELECT lote FROM proyectos WHERE proyectos.id=alta_venta.idProyecto) AS 'lote'
                    ,(SELECT precioVenta FROM proyectos WHERE proyectos.id=alta_venta.idProyecto)  AS 'precioVenta'
                    ,(SELECT ronda FROM gestoria WHERE gestoria.idAltaVenta = alta_venta.id) AS 'ronda'
                    ,(
                        (SELECT COALESCE(precioVentaOci,0) FROM gestoria WHERE gestoria.idAltaVenta = alta_venta.id)
                        - (SELECT COALESCE(difPropioPeculioTitulacion,0) FROM gestoria WHERE gestoria.idAltaVenta = alta_venta.id)
                    ) AS 'cantidadRecibir'
                    ,(
                        (SELECT COALESCE(precioVentaOci,0) FROM gestoria WHERE gestoria.idAltaVenta = alta_venta.id)
                        - (SELECT COALESCE(difPropioPeculioTitulacion,0) FROM gestoria WHERE gestoria.idAltaVenta = alta_venta.id)
                        - (SELECT COALESCE(ahorroVol,0) FROM gestoria WHERE gestoria.idAltaVenta = alta_venta.id) - $avaluo
                        - (SELECT COALESCE(valorTerreno,0) FROM gestoria WHERE gestoria.idAltaVenta = alta_venta.id)
                    ) AS 'valorCufrisa'
                    ,(
                        (
                            (SELECT COALESCE(precioVentaOci,0) FROM gestoria WHERE gestoria.idAltaVenta = alta_venta.id)
                            - (SELECT COALESCE(difPropioPeculioTitulacion,0) FROM gestoria WHERE gestoria.idAltaVenta = alta_venta.id)
                            - (SELECT COALESCE(ahorroVol,0) FROM gestoria WHERE gestoria.idAltaVenta = alta_venta.id) - $avaluo
                            - (SELECT COALESCE(valorTerreno,0) FROM gestoria WHERE gestoria.idAltaVenta = alta_venta.id)
                        ) * 0.017
                    ) as 'importeCufrisa'
                    ,(
                        (
                            (
                                (SELECT COALESCE(precioVentaOci,0) FROM gestoria WHERE gestoria.idAltaVenta = alta_venta.id)
                                - (SELECT COALESCE(difPropioPeculioTitulacion,0) FROM gestoria WHERE gestoria.idAltaVenta = alta_venta.id)
                                - (SELECT COALESCE(ahorroVol,0) FROM gestoria WHERE gestoria.idAltaVenta = alta_venta.id) - $avaluo
                                - (SELECT COALESCE(valorTerreno,0) FROM gestoria WHERE gestoria.idAltaVenta = alta_venta.id)
                            ) * 0.017
                        ) * 0.16
                    ) as 'iva'
                    ,(
                        (
                            (
                                (SELECT COALESCE(precioVentaOci,0) FROM gestoria WHERE gestoria.idAltaVenta = alta_venta.id)
                                - (SELECT COALESCE(difPropioPeculioTitulacion,0) FROM gestoria WHERE gestoria.idAltaVenta = alta_venta.id)
                                - (SELECT COALESCE(ahorroVol,0) FROM gestoria WHERE gestoria.idAltaVenta = alta_venta.id) - $avaluo
                                - (SELECT COALESCE(valorTerreno,0) FROM gestoria WHERE gestoria.idAltaVenta = alta_venta.id)
                            ) * 0.017
                        )
                        +
                        (   
                            (
                                (
                                    (SELECT COALESCE(precioVentaOci,0) FROM gestoria WHERE gestoria.idAltaVenta = alta_venta.id)
                                    - (SELECT COALESCE(difPropioPeculioTitulacion,0) FROM gestoria WHERE gestoria.idAltaVenta = alta_venta.id)
                                    - (SELECT COALESCE(ahorroVol,0) FROM gestoria WHERE gestoria.idAltaVenta = alta_venta.id) - $avaluo
                                    - (SELECT COALESCE(valorTerreno,0) FROM gestoria WHERE gestoria.idAltaVenta = alta_venta.id)
                                ) * 0.017
                            ) * 0.16
                        )
                    ) as 'neto'
                    ,(
                        (
                            (SELECT COALESCE(precioVentaOci,0) FROM gestoria WHERE gestoria.idAltaVenta = alta_venta.id)
                            - (SELECT COALESCE(difPropioPeculioTitulacion,0) FROM gestoria WHERE gestoria.idAltaVenta = alta_venta.id)
                            - (SELECT COALESCE(ahorroVol,0) FROM gestoria WHERE gestoria.idAltaVenta = alta_venta.id) - $avaluo
                            - (SELECT COALESCE(valorTerreno,0) FROM gestoria WHERE gestoria.idAltaVenta = alta_venta.id)
                        )
                        -
                        (
                            (
                                (
                                    (SELECT COALESCE(precioVentaOci,0) FROM gestoria WHERE gestoria.idAltaVenta = alta_venta.id)
                                    - (SELECT COALESCE(difPropioPeculioTitulacion,0) FROM gestoria WHERE gestoria.idAltaVenta = alta_venta.id)
                                    - (SELECT COALESCE(ahorroVol,0) FROM gestoria WHERE gestoria.idAltaVenta = alta_venta.id) - $avaluo
                                    - (SELECT COALESCE(valorTerreno,0) FROM gestoria WHERE gestoria.idAltaVenta = alta_venta.id)
                                ) * 0.017
                            )
                            +
                            (   
                                (
                                    (
                                        (SELECT COALESCE(precioVentaOci,0) FROM gestoria WHERE gestoria.idAltaVenta = alta_venta.id)
                                        - (SELECT COALESCE(difPropioPeculioTitulacion,0) FROM gestoria WHERE gestoria.idAltaVenta = alta_venta.id)
                                        - (SELECT COALESCE(ahorroVol,0) FROM gestoria WHERE gestoria.idAltaVenta = alta_venta.id) - $avaluo
                                        - (SELECT COALESCE(valorTerreno,0) FROM gestoria WHERE gestoria.idAltaVenta = alta_venta.id)
                                    ) * 0.017
                                ) * 0.16
                            )
                        )
                    ) as 'importeSinTerreno'
                    ,(
                        (
                            (
                                (SELECT COALESCE(precioVentaOci,0) FROM gestoria WHERE gestoria.idAltaVenta = alta_venta.id)
                                - (SELECT COALESCE(difPropioPeculioTitulacion,0) FROM gestoria WHERE gestoria.idAltaVenta = alta_venta.id)
                                - (SELECT COALESCE(ahorroVol,0) FROM gestoria WHERE gestoria.idAltaVenta = alta_venta.id) - $avaluo
                                - (SELECT COALESCE(valorTerreno,0) FROM gestoria WHERE gestoria.idAltaVenta = alta_venta.id)
                            )
                            -
                            (
                                (
                                    (
                                        (SELECT COALESCE(precioVentaOci,0) FROM gestoria WHERE gestoria.idAltaVenta = alta_venta.id)
                                        - (SELECT COALESCE(difPropioPeculioTitulacion,0) FROM gestoria WHERE gestoria.idAltaVenta = alta_venta.id)
                                        - (SELECT COALESCE(ahorroVol,0) FROM gestoria WHERE gestoria.idAltaVenta = alta_venta.id) - $avaluo
                                        - (SELECT COALESCE(valorTerreno,0) FROM gestoria WHERE gestoria.idAltaVenta = alta_venta.id)
                                    ) * 0.017
                                )
                                +
                                (   
                                    (
                                        (
                                            (SELECT COALESCE(precioVentaOci,0) FROM gestoria WHERE gestoria.idAltaVenta = alta_venta.id)
                                            - (SELECT COALESCE(difPropioPeculioTitulacion,0) FROM gestoria WHERE gestoria.idAltaVenta = alta_venta.id)
                                            - (SELECT COALESCE(ahorroVol,0) FROM gestoria WHERE gestoria.idAltaVenta = alta_venta.id) - $avaluo
                                            - (SELECT COALESCE(valorTerreno,0) FROM gestoria WHERE gestoria.idAltaVenta = alta_venta.id)
                                        ) * 0.017
                                    ) * 0.16
                                )
                            )
                        )
                        + (SELECT COALESCE(valorTerreno,0) FROM gestoria WHERE gestoria.idAltaVenta = alta_venta.id)
                    ) as 'valorNeto'
                    ,(
                        (
                            (SELECT COALESCE(precioVentaOci,0) FROM gestoria WHERE gestoria.idAltaVenta = alta_venta.id)
                            - (SELECT COALESCE(difPropioPeculioTitulacion,0) FROM gestoria WHERE gestoria.idAltaVenta = alta_venta.id)
                        ) * 0.04
                    ) as 'comisionSindical'
                    ,(
                        (
                            (
                                (
                                    (SELECT COALESCE(precioVentaOci,0) FROM gestoria WHERE gestoria.idAltaVenta = alta_venta.id)
                                    - (SELECT COALESCE(difPropioPeculioTitulacion,0) FROM gestoria WHERE gestoria.idAltaVenta = alta_venta.id)
                                    - (SELECT COALESCE(ahorroVol,0) FROM gestoria WHERE gestoria.idAltaVenta = alta_venta.id) - $avaluo
                                    - (SELECT COALESCE(valorTerreno,0) FROM gestoria WHERE gestoria.idAltaVenta = alta_venta.id)
                                )
                                -
                                (
                                    (
                                        (
                                            (SELECT COALESCE(precioVentaOci,0) FROM gestoria WHERE gestoria.idAltaVenta = alta_venta.id)
                                            - (SELECT COALESCE(difPropioPeculioTitulacion,0) FROM gestoria WHERE gestoria.idAltaVenta = alta_venta.id)
                                            - (SELECT COALESCE(ahorroVol,0) FROM gestoria WHERE gestoria.idAltaVenta = alta_venta.id) - $avaluo
                                            - (SELECT COALESCE(valorTerreno,0) FROM gestoria WHERE gestoria.idAltaVenta = alta_venta.id)
                                        ) * 0.017
                                    )
                                    +
                                    (   
                                        (
                                            (
                                                (SELECT COALESCE(precioVentaOci,0) FROM gestoria WHERE gestoria.idAltaVenta = alta_venta.id)
                                                - (SELECT COALESCE(difPropioPeculioTitulacion,0) FROM gestoria WHERE gestoria.idAltaVenta = alta_venta.id)
                                                - (SELECT COALESCE(ahorroVol,0) FROM gestoria WHERE gestoria.idAltaVenta = alta_venta.id) - $avaluo
                                                - (SELECT COALESCE(valorTerreno,0) FROM gestoria WHERE gestoria.idAltaVenta = alta_venta.id)
                                            ) * 0.017
                                        ) * 0.16
                                    )
                                )
                            )
                            + (SELECT COALESCE(valorTerreno,0) FROM gestoria WHERE gestoria.idAltaVenta = alta_venta.id)
                        )
                        -
                        (
                            (
                                (SELECT COALESCE(precioVentaOci,0) FROM gestoria WHERE gestoria.idAltaVenta = alta_venta.id)
                                - (SELECT COALESCE(difPropioPeculioTitulacion,0) FROM gestoria WHERE gestoria.idAltaVenta = alta_venta.id)
                            ) * 0.04
                        )
                    ) as 'valorNeto2'
                    ,(
                        (
                            (
                                (
                                    (
                                        (SELECT COALESCE(precioVentaOci,0) FROM gestoria WHERE gestoria.idAltaVenta = alta_venta.id)
                                        - (SELECT COALESCE(difPropioPeculioTitulacion,0) FROM gestoria WHERE gestoria.idAltaVenta = alta_venta.id)
                                        - (SELECT COALESCE(ahorroVol,0) FROM gestoria WHERE gestoria.idAltaVenta = alta_venta.id) - $avaluo
                                        - (SELECT COALESCE(valorTerreno,0) FROM gestoria WHERE gestoria.idAltaVenta = alta_venta.id)
                                    )
                                    -
                                    (
                                        (
                                            (
                                                (SELECT COALESCE(precioVentaOci,0) FROM gestoria WHERE gestoria.idAltaVenta = alta_venta.id)
                                                - (SELECT COALESCE(difPropioPeculioTitulacion,0) FROM gestoria WHERE gestoria.idAltaVenta = alta_venta.id)
                                                - (SELECT COALESCE(ahorroVol,0) FROM gestoria WHERE gestoria.idAltaVenta = alta_venta.id) - $avaluo
                                                - (SELECT COALESCE(valorTerreno,0) FROM gestoria WHERE gestoria.idAltaVenta = alta_venta.id)
                                            ) * 0.017
                                        )
                                        +
                                        (   
                                            (
                                                (
                                                    (SELECT COALESCE(precioVentaOci,0) FROM gestoria WHERE gestoria.idAltaVenta = alta_venta.id)
                                                    - (SELECT COALESCE(difPropioPeculioTitulacion,0) FROM gestoria WHERE gestoria.idAltaVenta = alta_venta.id)
                                                    - (SELECT COALESCE(ahorroVol,0) FROM gestoria WHERE gestoria.idAltaVenta = alta_venta.id) - $avaluo
                                                    - (SELECT COALESCE(valorTerreno,0) FROM gestoria WHERE gestoria.idAltaVenta = alta_venta.id)
                                                ) * 0.017
                                            ) * 0.16
                                        )
                                    )
                                )
                                + (SELECT COALESCE(valorTerreno,0) FROM gestoria WHERE gestoria.idAltaVenta = alta_venta.id)
                            )
                            -
                            (
                                (
                                    (SELECT COALESCE(precioVentaOci,0) FROM gestoria WHERE gestoria.idAltaVenta = alta_venta.id)
                                    - (SELECT COALESCE(difPropioPeculioTitulacion,0) FROM gestoria WHERE gestoria.idAltaVenta = alta_venta.id)
                                ) * 0.04
                            )
                        )
                        - (SELECT precioVenta FROM proyectos WHERE id=idProyecto) - $fideicomiso
                    ) as 'saldo'
                    ,(
                        (
                            (
                                (
                                    (
                                        (
                                            (SELECT COALESCE(precioVentaOci,0) FROM gestoria WHERE gestoria.idAltaVenta = alta_venta.id)
                                            - (SELECT COALESCE(difPropioPeculioTitulacion,0) FROM gestoria WHERE gestoria.idAltaVenta = alta_venta.id)
                                            - (SELECT COALESCE(ahorroVol,0) FROM gestoria WHERE gestoria.idAltaVenta = alta_venta.id) - $avaluo
                                            - (SELECT COALESCE(valorTerreno,0) FROM gestoria WHERE gestoria.idAltaVenta = alta_venta.id)
                                        )
                                        -
                                        (
                                            (
                                                (
                                                    (SELECT COALESCE(precioVentaOci,0) FROM gestoria WHERE gestoria.idAltaVenta = alta_venta.id)
                                                    - (SELECT COALESCE(difPropioPeculioTitulacion,0) FROM gestoria WHERE gestoria.idAltaVenta = alta_venta.id)
                                                    - (SELECT COALESCE(ahorroVol,0) FROM gestoria WHERE gestoria.idAltaVenta = alta_venta.id) - $avaluo
                                                    - (SELECT COALESCE(valorTerreno,0) FROM gestoria WHERE gestoria.idAltaVenta = alta_venta.id)
                                                ) * 0.017
                                            )
                                            +
                                            (   
                                                (
                                                    (
                                                        (SELECT COALESCE(precioVentaOci,0) FROM gestoria WHERE gestoria.idAltaVenta = alta_venta.id)
                                                        - (SELECT COALESCE(difPropioPeculioTitulacion,0) FROM gestoria WHERE gestoria.idAltaVenta = alta_venta.id)
                                                        - (SELECT COALESCE(ahorroVol,0) FROM gestoria WHERE gestoria.idAltaVenta = alta_venta.id) - $avaluo
                                                        - (SELECT COALESCE(valorTerreno,0) FROM gestoria WHERE gestoria.idAltaVenta = alta_venta.id)
                                                    ) * 0.017
                                                ) * 0.16
                                            )
                                        )
                                    )
                                    + (SELECT COALESCE(valorTerreno,0) FROM gestoria WHERE gestoria.idAltaVenta = alta_venta.id)
                                )
                                -
                                (
                                    (
                                        (SELECT COALESCE(precioVentaOci,0) FROM gestoria WHERE gestoria.idAltaVenta = alta_venta.id)
                                        - (SELECT COALESCE(difPropioPeculioTitulacion,0) FROM gestoria WHERE gestoria.idAltaVenta = alta_venta.id)
                                    ) * 0.04
                                )
                            )
                            - (SELECT precioVenta FROM proyectos WHERE id=idProyecto) - $fideicomiso
                        ) * 0.1
                    ) as 'porcentajeBon'
                    ,(
                        (
                            (
                                (
                                    (
                                        (
                                            (SELECT COALESCE(precioVentaOci,0) FROM gestoria WHERE gestoria.idAltaVenta = alta_venta.id)
                                            - (SELECT COALESCE(difPropioPeculioTitulacion,0) FROM gestoria WHERE gestoria.idAltaVenta = alta_venta.id)
                                            - (SELECT COALESCE(ahorroVol,0) FROM gestoria WHERE gestoria.idAltaVenta = alta_venta.id) - $avaluo
                                            - (SELECT COALESCE(valorTerreno,0) FROM gestoria WHERE gestoria.idAltaVenta = alta_venta.id)
                                        )
                                        -
                                        (
                                            (
                                                (
                                                    (SELECT COALESCE(precioVentaOci,0) FROM gestoria WHERE gestoria.idAltaVenta = alta_venta.id)
                                                    - (SELECT COALESCE(difPropioPeculioTitulacion,0) FROM gestoria WHERE gestoria.idAltaVenta = alta_venta.id)
                                                    - (SELECT COALESCE(ahorroVol,0) FROM gestoria WHERE gestoria.idAltaVenta = alta_venta.id) - $avaluo
                                                    - (SELECT COALESCE(valorTerreno,0) FROM gestoria WHERE gestoria.idAltaVenta = alta_venta.id)
                                                ) * 0.017
                                            )
                                            +
                                            (   
                                                (
                                                    (
                                                        (SELECT COALESCE(precioVentaOci,0) FROM gestoria WHERE gestoria.idAltaVenta = alta_venta.id)
                                                        - (SELECT COALESCE(difPropioPeculioTitulacion,0) FROM gestoria WHERE gestoria.idAltaVenta = alta_venta.id)
                                                        - (SELECT COALESCE(ahorroVol,0) FROM gestoria WHERE gestoria.idAltaVenta = alta_venta.id) - $avaluo
                                                        - (SELECT COALESCE(valorTerreno,0) FROM gestoria WHERE gestoria.idAltaVenta = alta_venta.id)
                                                    ) * 0.017
                                                ) * 0.16
                                            )
                                        )
                                    )
                                    + (SELECT COALESCE(valorTerreno,0) FROM gestoria WHERE gestoria.idAltaVenta = alta_venta.id)
                                )
                                -
                                (
                                    (
                                        (SELECT COALESCE(precioVentaOci,0) FROM gestoria WHERE gestoria.idAltaVenta = alta_venta.id)
                                        - (SELECT COALESCE(difPropioPeculioTitulacion,0) FROM gestoria WHERE gestoria.idAltaVenta = alta_venta.id)
                                    ) * 0.04
                                )
                            )
                            - (SELECT precioVenta FROM proyectos WHERE id=idProyecto) - $fideicomiso
                        )
                        -
                        (
                            (
                                (
                                    (
                                        (
                                            (
                                                (SELECT COALESCE(precioVentaOci,0) FROM gestoria WHERE gestoria.idAltaVenta = alta_venta.id)
                                                - (SELECT COALESCE(difPropioPeculioTitulacion,0) FROM gestoria WHERE gestoria.idAltaVenta = alta_venta.id)
                                                - (SELECT COALESCE(ahorroVol,0) FROM gestoria WHERE gestoria.idAltaVenta = alta_venta.id) - $avaluo
                                                - (SELECT COALESCE(valorTerreno,0) FROM gestoria WHERE gestoria.idAltaVenta = alta_venta.id)
                                            )
                                            -
                                            (
                                                (
                                                    (
                                                        (SELECT COALESCE(precioVentaOci,0) FROM gestoria WHERE gestoria.idAltaVenta = alta_venta.id)
                                                        - (SELECT COALESCE(difPropioPeculioTitulacion,0) FROM gestoria WHERE gestoria.idAltaVenta = alta_venta.id)
                                                        - (SELECT COALESCE(ahorroVol,0) FROM gestoria WHERE gestoria.idAltaVenta = alta_venta.id) - $avaluo
                                                        - (SELECT COALESCE(valorTerreno,0) FROM gestoria WHERE gestoria.idAltaVenta = alta_venta.id)
                                                    ) * 0.017
                                                )
                                                +
                                                (   
                                                    (
                                                        (
                                                            (SELECT COALESCE(precioVentaOci,0) FROM gestoria WHERE gestoria.idAltaVenta = alta_venta.id)
                                                            - (SELECT COALESCE(difPropioPeculioTitulacion,0) FROM gestoria WHERE gestoria.idAltaVenta = alta_venta.id)
                                                            - (SELECT COALESCE(ahorroVol,0) FROM gestoria WHERE gestoria.idAltaVenta = alta_venta.id) - $avaluo
                                                            - (SELECT COALESCE(valorTerreno,0) FROM gestoria WHERE gestoria.idAltaVenta = alta_venta.id)
                                                        ) * 0.017
                                                    ) * 0.16
                                                )
                                            )
                                        )
                                        + (SELECT COALESCE(valorTerreno,0) FROM gestoria WHERE gestoria.idAltaVenta = alta_venta.id)
                                    )
                                    -
                                    (
                                        (
                                            (SELECT COALESCE(precioVentaOci,0) FROM gestoria WHERE gestoria.idAltaVenta = alta_venta.id)
                                            - (SELECT COALESCE(difPropioPeculioTitulacion,0) FROM gestoria WHERE gestoria.idAltaVenta = alta_venta.id)
                                        ) * 0.04
                                    )
                                )
                                - (SELECT precioVenta FROM proyectos WHERE proyectos.id=alta_venta.idProyecto) - $fideicomiso
                            ) * 0.1
                        )
                    ) as 'bonificacion'
                    FROM alta_venta
                    WHERE status = 1
                    AND (SELECT status FROM fraccionamientos WHERE status=1 AND id= (SELECT idFraccionamiento FROM proyectos WHERE id=idProyecto))
                    AND idProyecto > 0
                    AND id IN (SELECT idAltaVenta FROM entrega WHERE entrega.idAltaVenta = alta_venta.id AND statusEntrega = '1')
                    -- AND statusValidacion >= 4
                    ".$and." ORDER BY id DESC 
                ");
            return $query;
        }

        public function todosPendientesComisiones($id=null){
            $info = (isset($_REQUEST['info'])) ? $_REQUEST['info'] : 0;
            $andFilter = '';
            if(!is_numeric($info)){
                $fecha_inicio = '';
                $fecha_fin = '';
                foreach ($info as $key => $val) {
                    if($val != "" AND $val != 0){
                        switch($key){
                            case 'fecha_inicio': 
                                $fecha_inicio = date_format(new DateTime($val),"Y-m-d");
                                break;
                            case 'fecha_fin': 
                                $fecha_fin = date_format(new DateTime($val),"Y-m-d");
                                if ($fecha_inicio != "" && $fecha_fin != "") {
                                    if($fecha_inicio != $fecha_fin){
                                        $andFilter .=" AND fechaVenta >= '$fecha_inicio' AND fechaVenta <= '$fecha_fin' + INTERVAL 1 DAY ";
                                    }else{
                                        $andFilter .=" AND DATE(fechaVenta) = DATE('$fecha_inicio') ";
                                    }
                                }
                                break;
                        }
                    }
                }
            }
            $and = ($id > 0) ? " AND alta_venta.id = ".$id:"";
            $query=$this->db->query('
                SELECT 
                    fechaVenta AS "statusPago",
                    id,
                    idProyecto,
                    idProspecto,
                    (SELECT lineaCredito FROM proyectos WHERE id=idProyecto)  AS "tCred",
                    (SELECT ronda FROM gestoria WHERE idAltaVenta = alta_venta.id) AS "ronda",
                    (SELECT idPromotor FROM prospectos WHERE id=idProspecto) AS "idPromotor",
                    (SELECT tipoPromotor FROM usuarios WHERE id = (SELECT idPromotor FROM prospectos WHERE id=idProspecto)) AS "tipoPromotor",
                    (SELECT UPPER(CONCAT(nombre," ",apellidoP," ",apellidoM)) FROM usuarios WHERE id=(SELECT idPromotor FROM prospectos WHERE id=idProspecto)) AS "promotor",
                    (SELECT UPPER(CONCAT(nombre," ",apellidoP," ",apellidoM)) FROM prospectos WHERE id=idProspecto) AS "cliente",
                    (SELECT UPPER(titulo) FROM fraccionamientos WHERE id = (SELECT idFraccionamiento FROM proyectos WHERE id = idProyecto)) AS "fraccionamiento",
                    (SELECT manzana FROM proyectos WHERE id=idProyecto) AS "manzana",
                    (SELECT lote FROM proyectos WHERE id=idProyecto) AS "lote",
                    UPPER(tipoCredito) AS "tCred2",
                    (SELECT precioVenta FROM proyectos WHERE id=idProyecto) AS "pVenta"
                FROM 
                    alta_venta
                WHERE 
                    statusValidacion >= 4
                    AND status=1
                    AND (SELECT status FROM fraccionamientos WHERE status=1 AND id= (SELECT idFraccionamiento FROM proyectos WHERE id=idProyecto))
                    AND idProyecto>0
                    AND ((SELECT idAltaVenta FROM entrega WHERE entrega.idAltaVenta = alta_venta.id AND statusPago2=0) OR (alta_venta.id NOT IN (SELECT idAltaVenta FROM comisiones_bonos WHERE comisiones_bonos.idAltaVenta = alta_venta.id) AND statusValidacion >= 4 AND CAST(fechaVenta AS CHAR(10))!="0000-00-00" AND CAST(fechaVenta AS CHAR(1))!=""))
                    AND id NOT IN (SELECT idAltaVenta FROM comisiones)
                    AND id NOT IN (SELECT idAltaVenta FROM entrega) 

                '.$and.'
                '.$andFilter.'
                ORDER BY 
                    fechaVenta DESC
            ');

            if($query->num_rows() > 0){
                return $query;
            }else{
                return 0;
            }
        }
        
        public function getAllExcelRowsBonPendientes(){
            $and = "";
            $idUsu = $_SESSION["viv"]["id"];
            if($_SESSION["viv"]["rol"] > 1){
                $and = " AND idProyecto IN (SELECT id FROM proyectos proy WHERE proy.idFraccionamiento IN (SELECT idFraccionamiento FROM fraccionamientosxusuarios WHERE idUsuario = $idUsu) )";
            }
            $fideicomiso = 870;
            $avaluo = 2100;
            $query=$this->db->query("SELECT 'PENDIENTE'  AS 'status'
                    ,(SELECT lineaCredito FROM proyectos WHERE proyectos.id=alta_venta.idProyecto)  AS 'linea'
                    ,(SELECT UPPER(CONCAT(nombre,' ',apellidoP,' ',apellidoM)) FROM prospectos WHERE prospectos.id=alta_venta.idProspecto) AS 'cliente'
                    ,(SELECT UPPER(titulo) FROM fraccionamientos WHERE fraccionamientos.id = (SELECT idFraccionamiento FROM proyectos WHERE proyectos.id = alta_venta.idProyecto)) AS 'fraccionamiento'
                    ,CONCAT('$', (SELECT precioVenta FROM proyectos WHERE proyectos.id=alta_venta.idProyecto) )  AS 'precio'
                    ,(SELECT ronda FROM gestoria WHERE gestoria.idAltaVenta = alta_venta.id) AS 'ronda'
                    ,(SELECT manzana FROM proyectos WHERE proyectos.id=alta_venta.idProyecto) AS 'manzana'
                    ,(SELECT lote FROM proyectos WHERE proyectos.id=alta_venta.idProyecto) AS 'lote'
                    ,CONCAT('$', (
                        (
                            (
                                (
                                    (
                                        (
                                            (SELECT COALESCE(precioVentaOci,0) FROM gestoria WHERE gestoria.idAltaVenta = alta_venta.id)
                                            - (SELECT COALESCE(difPropioPeculioTitulacion,0) FROM gestoria WHERE gestoria.idAltaVenta = alta_venta.id)
                                            - (SELECT COALESCE(ahorroVol,0) FROM gestoria WHERE gestoria.idAltaVenta = alta_venta.id) - $avaluo
                                            - (SELECT COALESCE(valorTerreno,0) FROM gestoria WHERE gestoria.idAltaVenta = alta_venta.id)
                                        )
                                        -
                                        (
                                            (
                                                (
                                                    (SELECT COALESCE(precioVentaOci,0) FROM gestoria WHERE gestoria.idAltaVenta = alta_venta.id)
                                                    - (SELECT COALESCE(difPropioPeculioTitulacion,0) FROM gestoria WHERE gestoria.idAltaVenta = alta_venta.id)
                                                    - (SELECT COALESCE(ahorroVol,0) FROM gestoria WHERE gestoria.idAltaVenta = alta_venta.id) - $avaluo
                                                    - (SELECT COALESCE(valorTerreno,0) FROM gestoria WHERE gestoria.idAltaVenta = alta_venta.id)
                                                ) * 0.017
                                            )
                                            +
                                            (   
                                                (
                                                    (
                                                        (SELECT COALESCE(precioVentaOci,0) FROM gestoria WHERE gestoria.idAltaVenta = alta_venta.id)
                                                        - (SELECT COALESCE(difPropioPeculioTitulacion,0) FROM gestoria WHERE gestoria.idAltaVenta = alta_venta.id)
                                                        - (SELECT COALESCE(ahorroVol,0) FROM gestoria WHERE gestoria.idAltaVenta = alta_venta.id) - $avaluo
                                                        - (SELECT COALESCE(valorTerreno,0) FROM gestoria WHERE gestoria.idAltaVenta = alta_venta.id)
                                                    ) * 0.017
                                                ) * 0.16
                                            )
                                        )
                                    )
                                    + (SELECT COALESCE(valorTerreno,0) FROM gestoria WHERE gestoria.idAltaVenta = alta_venta.id)
                                )
                                -
                                (
                                    (
                                        (SELECT COALESCE(precioVentaOci,0) FROM gestoria WHERE gestoria.idAltaVenta = alta_venta.id)
                                        - (SELECT COALESCE(difPropioPeculioTitulacion,0) FROM gestoria WHERE gestoria.idAltaVenta = alta_venta.id)
                                    ) * 0.04
                                )
                            )
                            - (SELECT precioVenta FROM proyectos WHERE id=idProyecto) - $fideicomiso
                        )
                        -
                        (
                            (
                                (
                                    (
                                        (
                                            (
                                                (SELECT COALESCE(precioVentaOci,0) FROM gestoria WHERE gestoria.idAltaVenta = alta_venta.id)
                                                - (SELECT COALESCE(difPropioPeculioTitulacion,0) FROM gestoria WHERE gestoria.idAltaVenta = alta_venta.id)
                                                - (SELECT COALESCE(ahorroVol,0) FROM gestoria WHERE gestoria.idAltaVenta = alta_venta.id) - $avaluo
                                                - (SELECT COALESCE(valorTerreno,0) FROM gestoria WHERE gestoria.idAltaVenta = alta_venta.id)
                                            )
                                            -
                                            (
                                                (
                                                    (
                                                        (SELECT COALESCE(precioVentaOci,0) FROM gestoria WHERE gestoria.idAltaVenta = alta_venta.id)
                                                        - (SELECT COALESCE(difPropioPeculioTitulacion,0) FROM gestoria WHERE gestoria.idAltaVenta = alta_venta.id)
                                                        - (SELECT COALESCE(ahorroVol,0) FROM gestoria WHERE gestoria.idAltaVenta = alta_venta.id) - $avaluo
                                                        - (SELECT COALESCE(valorTerreno,0) FROM gestoria WHERE gestoria.idAltaVenta = alta_venta.id)
                                                    ) * 0.017
                                                )
                                                +
                                                (   
                                                    (
                                                        (
                                                            (SELECT COALESCE(precioVentaOci,0) FROM gestoria WHERE gestoria.idAltaVenta = alta_venta.id)
                                                            - (SELECT COALESCE(difPropioPeculioTitulacion,0) FROM gestoria WHERE gestoria.idAltaVenta = alta_venta.id)
                                                            - (SELECT COALESCE(ahorroVol,0) FROM gestoria WHERE gestoria.idAltaVenta = alta_venta.id) - $avaluo
                                                            - (SELECT COALESCE(valorTerreno,0) FROM gestoria WHERE gestoria.idAltaVenta = alta_venta.id)
                                                        ) * 0.017
                                                    ) * 0.16
                                                )
                                            )
                                        )
                                        + (SELECT COALESCE(valorTerreno,0) FROM gestoria WHERE gestoria.idAltaVenta = alta_venta.id)
                                    )
                                    -
                                    (
                                        (
                                            (SELECT COALESCE(precioVentaOci,0) FROM gestoria WHERE gestoria.idAltaVenta = alta_venta.id)
                                            - (SELECT COALESCE(difPropioPeculioTitulacion,0) FROM gestoria WHERE gestoria.idAltaVenta = alta_venta.id)
                                        ) * 0.04
                                    )
                                )
                                - (SELECT precioVenta FROM proyectos WHERE proyectos.id=alta_venta.idProyecto) - $fideicomiso
                            ) * 0.1
                        )
                    ) ) as 'bonificacion'
                    FROM alta_venta
                    WHERE status = 1
                    AND (SELECT status FROM fraccionamientos WHERE status=1 AND id= (SELECT idFraccionamiento FROM proyectos WHERE id=idProyecto))
                    AND idProyecto > 0
                    AND id IN (SELECT idAltaVenta FROM entrega WHERE entrega.idAltaVenta = alta_venta.id AND statusEntrega = '1')
                    -- AND statusValidacion >= 4
                    AND alta_venta.id NOT IN (SELECT idAltaVenta FROM bonificaciones WHERE bonificaciones.idAltaVenta = alta_venta.id)
                    ".$and." ORDER BY id DESC "
            );
            
            if($query->num_rows() > 0){
                return $query;
            }else{
                return 0;
            }
        }

        public function getInfoForSendWhatsApp($idAlvaVenta)
        {
            $query = $this->db->query('
                    SELECT 
                        av.idProspecto,
                        (SELECT UPPER(CONCAT(nombre, " ", apellidoP, " ", apellidoM)) FROM prospectos WHERE id=av.idProspecto) AS cliente,
                        (SELECT UPPER(CONCAT(nombre, " ", apellidoP, " ", apellidoM)) FROM usuarios WHERE id=(SELECT idPromotor FROM prospectos WHERE id=av.idProspecto)) AS promotor,
                        (SELECT celular FROM usuarios WHERE id=(SELECT idPromotor FROM prospectos WHERE id=av.idProspecto)) AS celular,
                        (SELECT lote FROM proyectos WHERE id=(SELECT idProyecto FROM alta_venta WHERE id = av.id)) AS lote,
                        (SELECT manzana FROM proyectos WHERE id=(SELECT idProyecto FROM alta_venta WHERE id = av.id)) AS manzana,
                        (SELECT nombre FROM prototipos WHERE id=(SELECT idPrototipo FROM prospectos WHERE id=av.idProspecto)) AS prototipo
                    FROM 
                        alta_venta AS av 
                    WHERE 
                        av.id = '.$idAlvaVenta.'
                ');
            
            if($query->num_rows() > 0){
                return $query;
            }else{
                return 0;
            }
        }

        function getByIdAll2($id){//obtiene por id de la tabla alta venta
            $this->db->select($this->selectDefault.",".$this->selectProspecto,FALSE);
            $arrayWhere = array($this->alias.'.id' => $id);
            $this->db->where($arrayWhere);
            $this->db->join("prospectos pro", "pro.id=av.idProspecto");
            //$this->db->order_by($this->alias.'.id', "desc");
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $query->result_array()[0];
            }
            else{
                return 0;
            }
        }
    }