<?php
    class malmacenes extends MY_Model{

        public function __construct(){
            parent :: __construct();
            $this->table = "almacenes";
            $this->alias = 'a';

            $this->selectDefault = "".
                $this->alias.".id
            ,".$this->alias.".idEmpresa
            ,".$this->alias.".nombre
            ,".$this->alias.".nombre_abrev
            ,".$this->alias.".ciudad
            ,".$this->alias.".cp
            ,".$this->alias.".telefono1
            ,".$this->alias.".telefono2 
            ,".$this->alias.".idArranque
            ,".$this->alias.".tipoAlmacen 
            ";

            $this->selectResult = "".
                $this->alias.".id
            ,".$this->alias.".nombre AS titulo";
        }


        // Populate values
        private function _populateValues($r)
        {
            $array = array(
                'id' => '',
                'idEmpresa' => '',
                'nombre' => '',
                'nombre_abrev' => '',
                'ciudad' => '',
                'cp' => '',
                'telefono1' => '',
                'telefono2' => '',
                'idArranque' => '',
                'tipoAlmacen' => '',
                /*'status' => '',*/
            );

            if (!is_numeric($r)) {
                $array['id'] = $r->row()->id;
                $array['idEmpresa'] = $r->row()->idEmpresa;
                $array['nombre'] = $r->row()->nombre;
                $array['nombre_abrev'] = $r->row()->nombre_abrev;
                $array['ciudad'] = $r->row()->ciudad;
                $array['cp'] = $r->row()->cp;
                $array['telefono1'] = $r->row()->telefono1;
                $array['telefono2'] = $r->row()->telefono2;
                $array['idArranque'] = $r->row()->idArranque;
                $array['tipoAlmacen'] = $r->row()->tipoAlmacen;
              /*  $array['status'] = $r->row()->status;*/
            }
                $array['msg'] = '';
            return $array;
        }

        function getAll(){
            $this->db->select($this->selectDefault,FALSE);
            //    $arrayWhere = array($this->alias.'.status' => true);
            //$this->db->where($arrayWhere);
            $this->db->order_by($this->alias.'.id', "desc");
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $query;
            }else{
                return 0;
            }
        }



        function getAllExcelRows(){
            $id = $_SESSION["viv"]['idEmpresa'];
            $query=$this->db->query("
            SELECT `nombre`,`nombre_abrev`,`ciudad`,`cp`,`telefono1`,`telefono2` 
            FROM `almacenes`
            WHERE `idEmpresa`= $id ORDER BY  id  DESC
            ");
             
            if($query->num_rows()>0){
                return $query;
            }else{
                return 0;
            }
        }

         function getById($id){
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.id' => $id);
            $this->db->where($arrayWhere);
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $this->_populateValues($query);
            }
            return 0;
        }
        function getByIdUnidad($idUnidad){
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.idUnidad' => $idUnidad);
            $this->db->where($arrayWhere);
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $this->_populateValues($query);
            }
            return 0;
        }

        function getSelectResult($idEmpresa=0){
            $filter=($idEmpresa > 0) ? "AND idEmpresa=$idEmpresa" : "";
            $query=$this->db->query("SELECT *,nombre titulo FROM almacenes WHERE idPaquete $filter");
            if($query->num_rows()>0){
                return $query;
            }else{
                return 0;
            }
        }

        function getSelectResultByIdPaquete($idPaquete, $idEmpresa){
            $this->db->select($this->selectResult,FALSE);
            $arrayWhere = array($this->alias.'.idPaquete' => $idPaquete, $this->alias.'.idEmpresa' => $idEmpresa);
            $this->db->where($arrayWhere);
            $this->db->order_by($this->alias.'.id', "desc");
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $query;
            }else{
                return 0;
            }
        }

        function getByIdPaquete($idEmpresa, $idPaquete){
            $query=$this->db->query("SELECT id FROM almacenes WHERE idPaquete='$idPaquete' AND idEmpresa=$idEmpresa AND idPaquete > 0 LIMIT 1");
            if($query->num_rows()>0){
                return $query->row();
            }else{
                return 0;
            }
        }

        function getByIdEmpresa($idAlmacen, $idEmpresa){
            $query=$this->db->query("SELECT id,idPaquete,tipoAlmacen,nombre FROM almacenes WHERE id=$idAlmacen AND idEmpresa=$idEmpresa AND idPaquete > 0 LIMIT 1");
            if($query->num_rows()>0){
                return $query->row();
            }else{
                return 0;
            }
        }

        function valInsert($id, $idEmpresa){
            $query=$this->db->query("SELECT id FROM almacenes WHERE id=$id AND idEmpresa=$idEmpresa");
            return ($query->num_rows()>0) ? false : true;
        }

        function valUpdate($id,$data){
            $search="";
            foreach ($data as $key => $val) {
                switch ($key) {
                    case 'id':
                        $id=$val;
                        break;
                    default:
                        $search.=' AND '.$key.'="'.$val.'"';
                }
            }
            $query=$this->db->query("SELECT id FROM almacenes WHERE id=$id $search");
            return ($query->num_rows()>0) ? false : true;
        }


             //FUNCIONES DEL SERVERSIDE


        var $column_order = array(null, 'nombre_abrev','ciudad','cp','telefono1','telefono2'); //set column field database for datatable orderable
        var $column_search = array('nombre_abrev','ciudad','cp','telefono1','telefono2'); //set column field database for datatable searchable
        var $order = array('id' => 'desc'); // default order
        
        function get_datatables()
        {
            $this->_get_datatables_query();
            if($_POST['length'] != -1)
            $this->db->limit($_POST['length'], $_POST['start']);
            $query = $this->db->get();
            return $query->result();
        }


        private function _get_datatables_query()
        {

        $this->db->from($this->table);

        if($_SESSION["viv"]["idEmpresa"] > 0){
             $id=$_SESSION["viv"]["idEmpresa"];
             $arrayWhere = array('idEmpresa' => $id);
             $this->db->where($arrayWhere);
        }

        $i = 0;

        foreach ($this->column_search as $item) // loop column
        {
            if($_POST['search']['value']) // if datatable send POST for search
            {

                if($i===0) // first loop
                {
                    $this->db->group_start(); // open bracket. query Where with OR clause better with bracket. because maybe can combine with other WHERE with AND.
                    $this->db->like($item, $_POST['search']['value']);
                }
                else
                {
                    $this->db->or_like($item, $_POST['search']['value']);
                }

                if(count($this->column_search) - 1 == $i) //last loop
                    $this->db->group_end(); //close bracket
            }
            $i++;
        }

        if(isset($_POST['order'])) // here order processing
        {
            $this->db->order_by($this->column_order[$_POST['order']['0']['column']], $_POST['order']['0']['dir']);
        }
        else if(isset($this->order))
        {
            $order = $this->order;
            $this->db->order_by(key($order), $order[key($order)]);
        }
    }

 

    function count_filtered()
    {
        $this->_get_datatables_query();
        $query = $this->db->get();
        return $query->num_rows();
    }

    public function count_all()
    {
        $this->db->from($this->table);
        return $this->db->count_all_results();
    }

       
    }