<?php

    class Mactividadesprototipo extends MY_Model{

        public function __construct(){
            parent :: __construct();
            $this->table = "actividadesprototipo";
            $this->alias = 'ap';
            $this->selectDefault = "".
            $this->alias.".id
            ,".$this->alias.".idPrototipo
            ,".$this->alias.".idCategoria
            ,".$this->alias.".idActividad
            ,".$this->alias.".cantidad
            ,".$this->alias.".tipo
            ,".$this->alias.".semana
            ,".$this->alias.".status
            ,IF(".$this->alias.".status > 0,'Activo','Inactivo') AS txtstatus";
        }

        // Populate values
        private function _populateValues($r)
        {
            $array = array(
                'id' => '',
                'idPrototipo' => '',
                'idCategoria' => '',
                'idActividad' => '',
                'cantidad' => '',
                'tipo' => '',
                'semana' => '',
                'status' => '',
                'txtstatus' => ''
            );

            if (!is_numeric($r)) {
                $array['id'] = $r->row()->id;
                $array['idPrototipo'] = $r->row()->idPrototipo;
                $array['idCategoria'] = $r->row()->idCategoria;
                $array['idActividad'] = $r->row()->idActividad;
                $array['cantidad'] = $r->row()->cantidad;
                $array['tipo'] = $r->row()->tipo;
                $array['semana'] = $r->row()->semana;
                $array['status'] = $r->row()->status;
                $array['txtstatus'] = $r->row()->txtstatus;

            }
                $array['msg'] = '';
            return $array;
        }

        function getAll(){
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.status' => true);
            $this->db->where($arrayWhere);
            $this->db->order_by($this->alias.'.id', "desc");
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $query;
            }else{
                return 0;
            }
        }

        function getAllByPrototipoCategoria($idPrototipo=0,$idCategoria=0){
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.status' => true,$this->alias.'.idPrototipo' => $idPrototipo,$this->alias.'.idCategoria' => $idCategoria, $this->alias.'.tipo' => 1);
            $this->db->where($arrayWhere);
            $this->db->order_by($this->alias.'.id', "ASC");
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $query;
            }else{
                return 0;
            }
        }

        function getCategoriasByManoObra($idManoObra=0){
            $query="SELECT (SELECT idCategoria FROM actividadesprototipo WHERE id=idActividadPrototipo) idCategoria, (SELECT categoria FROM categorias_mo WHERE 
            id=(SELECT idCategoria FROM actividadesprototipo WHERE id=idActividadPrototipo LIMIT 1)) categoria FROM presupuesto_mo WHERE idManoObra=$idManoObra GROUP BY idCategoria ORDER BY idCategoria ASC;";

            $query=$this->db->query($query);
            if($query->num_rows()>0){
                return $query;
            }else{
                return 0;
            }
        }

        function getCategoriasByPrototipo($idPrototipo=0){
            $query="SELECT idCategoria,(SELECT categoria FROM categorias_mo WHERE id=idCategoria) categoria FROM actividadesprototipo WHERE
            idPrototipo=$idPrototipo GROUP BY idCategoria ORDER BY idCategoria ASC";

            $query=$this->db->query($query);
            if($query->num_rows()>0){
                return $query;
            }else{
                return 0;
            }
        }

        function getById($id){
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.id' => $id);
            $this->db->where($arrayWhere);
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $this->_populateValues($query);
            }
            else{
                return 0;
            }
        }

        function getByIdPrototipo($idPrototipo){
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.idPrototipo' => $idPrototipo, $this->alias.'.tipo' => 1);
            $this->db->where($arrayWhere);
            $this->db->order_by($this->alias.'.id', "asc");
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $query;
            }else{
                return 0;
            }
        }

        function getActividadByIdPrototipo($idPrototipo,$idActividad){
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.idPrototipo' => $idPrototipo, $this->alias.'.idActividad' => $idActividad, $this->alias.'.tipo' => 1);
            $this->db->where($arrayWhere);
            $this->db->order_by($this->alias.'.id', "asc");
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $query->row();
            }else{
                return 0;
            }
        }

        function getActividadesNews($idManoObra){
            $query = $this->db->query("SELECT *,
            (SELECT cantidad FROM actividadesprototipo WHERE id=idActividadPrototipo) cantidad,
            (SELECT idActividad FROM actividadesprototipo WHERE id=idActividadPrototipo) idActividad 
            FROM presupuesto_mo WHERE idManoObra=$idManoObra");

            if ($query->num_rows() > 0) {
                return $query;
            } else {
                return 0;
            }
        }

        function getActividadesByIdManoObraIdCategoria($idManoObra, $idCategoria){
            $query = $this->db->query('
                SELECT a.idCategoria, a.idActividad 
                FROM actividadesprototipo AS a INNER JOIN presupuesto_mo AS p ON a.id = p.idActividadPrototipo 
                WHERE p.idManoObra = '. $idManoObra .' AND a.idCategoria = ' .$idCategoria
            );

            if($query->num_rows() > 0){
                return $query;
            }else{
                return 0;
            }
        }

        function getByIdPrototipoManoObra($idPrototipo, $MO){
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = $this->alias . '.status = 1 AND mo.id = ' . $MO . ' AND pmo.idActividadPrototipo = ' . $this->alias.'.id';
            $this->db->join('mano_obra as mo', $this->alias . '.idPrototipo = mo.idPrototipo');
            $this->db->join('presupuesto_mo as pmo', 'mo.id = pmo.idManoObra');
            $this->db->where($arrayWhere);
            $this->db->order_by($this->alias.'.id', "asc");
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $query;
            }else{
                return 0;
            }
        }

        function getAllByManoObraCategoria($MO=0,$idCategoria=0){
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = $this->alias . '.status = 1 AND mo.id = ' . $MO . ' AND ' . $this->alias.'.idCategoria = ' . $idCategoria . ' AND pmo.idActividadPrototipo = ' . $this->alias.'.id';
            $this->db->join('mano_obra as mo', $this->alias . '.idPrototipo = mo.idPrototipo');
            $this->db->join('presupuesto_mo as pmo', 'mo.id = pmo.idManoObra');
            $this->db->where($arrayWhere);
            $this->db->order_by($this->alias.'.id', "ASC");
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $query;
            }else{
                return 0;
            }
        }
        
        function getByIdCatActMO($idCategoria, $idActividad, $MO){
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = $this->alias . '.status = 1 AND mo.id = ' . $MO . ' AND pmo.idActividadPrototipo = ' . $this->alias.'.id AND '
                . $this->alias . '.idActividad = ' . $idActividad . ' AND ' . $this->alias . '.idCategoria = ' . $idCategoria;
            $this->db->join('mano_obra as mo', $this->alias . '.idPrototipo = mo.idPrototipo');
            $this->db->join('presupuesto_mo as pmo', 'mo.id = pmo.idManoObra');
            $this->db->where($arrayWhere);
            $this->db->order_by($this->alias.'.id', "asc");
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $this->_populateValues($query);
            }else{
                return 0;
            }
        }

        function getByIdCatActMOAjustes($idCategoria, $idActividad, $idMO, $idPaquete){
            $extras="AND IF(pmo.tipo=2,pmo.id IN (SELECT aju2.idPresupuesto FROM ajustes aju2 WHERE aju2.idPaquete=$idPaquete AND aju2.tipo=2 AND aju2.tipoPPto=2),true)";
            $query=$this->db->query("SELECT act.* FROM presupuesto_mo pmo
            LEFT JOIN actividadesprototipo act ON act.id=pmo.idActividadPrototipo
            WHERE pmo.idManoObra=$idMO AND act.idActividad=$idActividad AND act.idCategoria=$idCategoria $extras");
            if($query->num_rows()>0){
                return $query;
            }else{
                return 0;
            }
        }
    }