<?php
defined('BASEPATH') OR exit('No direct script access allowed');
class Csvarray {

    public function __construct()
    {
        $this->CI =& get_instance();
    }

    //Export CSV
    function normaliza($cadena=""){
        $cadena = htmlentities($cadena, ENT_QUOTES, 'UTF-8');
        $cadena = strtolower($cadena);
        $patron = array (
            // Espacios, puntos y comas por guion
            //'/[\., ]+/' => ' ',

            // Vocales
            '/\+/' => '',
            '/&agrave;/' => 'a',
            '/&egrave;/' => 'e',
            '/&igrave;/' => 'i',
            '/&ograve;/' => 'o',
            '/&ugrave;/' => 'u',

            '/&aacute;/' => 'a',
            '/&eacute;/' => 'e',
            '/&iacute;/' => 'i',
            '/&oacute;/' => 'o',
            '/&uacute;/' => 'u',

            '/&acirc;/' => 'a',
            '/&ecirc;/' => 'e',
            '/&icirc;/' => 'i',
            '/&ocirc;/' => 'o',
            '/&ucirc;/' => 'u',

            '/&atilde;/' => 'a',
            '/&etilde;/' => 'e',
            '/&itilde;/' => 'i',
            '/&otilde;/' => 'o',
            '/&utilde;/' => 'u',

            '/&auml;/' => 'a',
            '/&euml;/' => 'e',
            '/&iuml;/' => 'i',
            '/&ouml;/' => 'o',
            '/&uuml;/' => 'u',

            // Otras letras y caracteres especiales
            '/&aring;/' => 'a',
            '/&ntilde;/' => 'n',
            // Agregar aqui mas caracteres si es necesario
        );

        $cadena = preg_replace(array_keys($patron),array_values($patron),$cadena);
        return $cadena;
    }

    function deleteColumnArray($data,$column="Default"){
        for ($i=0; $i < COUNT($data); $i++) {
            unset($data[$i][$column]);
        }
        return $data;
    }

    function deleteCharArray($data,$column="Default",$charDelete="Default",$charAdd=" "){
        for ($i=0; $i < COUNT($data); $i++) {
            $data[$i][$column]=str_replace($charDelete,$charAdd,$data[$i][$column]);
        }
        return $data;
    }

    function normalizar($data,$column="Default"){
        for ($i=0; $i < COUNT($data); $i++) {
            $data[$i][$column]=$this->normaliza($data[$i][$column]);
        }
        return $data;
    }

    function getCSV($data,$filename="Default"){
        ob_clean();
        header('Pragma: public');
        header('Expires: 0');
        header('Cache-Control: must-revalidate, post-check=0, pre-check=0');
        header('Cache-Control: private', false);
        header('Content-Type: text/csv');
        header('Content-Disposition: attachment;filename=' . $filename."-".date('d-m-Y').".csv");
        if(isset($data['0'])){
            $fp = fopen('php://output', 'w');
            fputcsv($fp, array_keys($data['0']));
            foreach($data AS $values){
                fputcsv($fp, $values);
            }
            fclose($fp);
        }
        ob_flush();
    }

}