<?php

if (! function_exists('permisos'))
{
    function permisos($module,$index="",$all=false){
       $allowed =
       array(
            "ventas"=>[
                "blackboard" => ['r' => array(1,2,6), 'w' => array(1,2,6)],
                "blackboard_edit" => ['r' => array(1,2,6), 'w' => array(1,2,6)],
                "cancelaciones_gestoria" => ['r'=>[1,3,4,10],'w'=>[1,3,4,10]],
                "fraccionamientos" => ['r'=>[1,14],'w'=>[1,14]],
                "proyectos" => ['r'=>[1,3,4,5,7,9,10,11,13,14],'w'=>[1,3,4,5,7,9,10,11,13,14]],
                "busqueda_vivienda" => ['r'=>[1,3,4,5],'w'=>[1,3,4,5]],
                "promotores" => ['r'=>[4000],'w'=>[4000]],
                "prospectos" => ['r'=>[1,2,3,4,8,10],'w'=>[1,2,3,4,8,10]],
                "prospectos_edit" => ['r'=>[1,3,4,8,10],'w'=>[1,3,4,8,10]],               
                "reasignacion" => ['r'=>[4000],'w'=>[4000]],
                "alta_venta" => ['r'=>[1,2,3,4,8,10,13],'w'=>[1,2,3,4,8,10,13]],
                "contado" => ['r'=>[1,3,7],'w'=>[1,3,7]],
                "alta_venta_edit" => ['r'=>[1,3,4,10],'w'=>[1,3,4,10]],
                "validacion_venta" => ['r'=>[1,3,4,10,13],'w'=>[1,3,4,10,13]],
                "validacion_venta_edit" => ['r'=>[1,3,4],'w'=>[1,3,4]],
                "gestoria" => ['r'=>[1,3,4,10,11,13],'w'=>[1,3,4,10,11,13]],
                "gestoria_edit" => ['r'=>[1,10],'w'=>[1,10]],
                "autorizaciones" => ['r'=>[1,4,7],'w'=>[1,4,7]],
                "depositos" => ['r'=>[1,3,7,10],'w'=>[1,3,7,10]],
                "depositos_edit" => ['r'=>[1,3,7],'w'=>[1,3,7]],
                "usuarios" => ['r'=>[1,3,4,5,14],'w'=>[1,3,4,5,14]],
                "avaluos" => ['r'=>[1,3,5,14],'w'=>[1,3,5,14]],
                "lineascredito" => ['r'=>[1,3,5,14],'w'=>[1,3,5,14]],
                "notaria" => ['r'=>[1,5,14],'w'=>[1,5,14]],
                "unidad_valuadora" => ['r'=>[1,5,14],'w'=>[1,5,14]],
                "lugares_prospeccion" => ['r'=>[1,5,14],'w'=>[1,5,14]],
                "prototipos" => ['r'=>[1,5,14],'w'=>[1,5,14]],
                "prototipos_mo" => ['r'=>[1,5,14],'w'=>[1,5,14]],
                "prototipos_mat" => ['r'=>[1,5,14],'w'=>[1,5,14]],
                "almacenes" => ['r'=>[1,5,14],'w'=>[1,5,14]],
                "unidad_valuadora" => ['r'=>[1],'w'=>[1]],
                "logs" => ['r'=>[1],'w'=>[1]],
                //permisos reportes
                "colocacion" => ['r'=>[1,4,14],'w'=>[1,4,14]],
                "rcomisiones" => ['r'=>[1],'w'=>[1]],
                "rtecnica" => ['r'=>[1,4,14],'w'=>[1,4,14]],
                "condiciones_vivienda" => ['r'=>[1],'w'=>[1]],
                "condiciones_vivienda_g" => ['r'=>[1],'w'=>[1]],
                "g_colocacion" => ['r'=>[1,14],'w'=>[1,14]],
                "g_promotores" => ['r'=>[1,14],'w'=>[1,14]],
                "g_gestoria" => ['r'=>[1,14],'w'=>[1,14]],
                "g_titulacion" => ['r'=>[1,14],'w'=>[1,14]],
                "g_viviendas" => ['r'=>[1,14],'w'=>[1,14]],
                "g_comparacion" => ['r'=>[1,14],'w'=>[1,14]],
                "g_cancelaciones" => ['r'=>[1,14],'w'=>[1,14]],
                "rcontado" => ['r'=>[1,7],'w'=>[1,7]],
                //faltantes
                "planos" => ['r'=>[1,2,3,4,5,6,7,8,9,10,11,14],'w'=>[1,2,3,4,5,6,7,8,9,10,11,14]],
            ],

            "obra"=>[
                "paquetes" => ['r'=>[1,3,4,7,8,10,13],'w'=>[1,3,4,7,8,10,13]],
                "arranque" => ['r'=>[1,3,4,7,8,10,13],'w'=>[1,3,4,7,8,10,13]],
                "estimaciones" => ['r'=>[1,3,4,7,8,10,13],'w'=>[1,3,4,7,8,10,13]],
                "pmo" => ['r'=>[1,3,4,7,8,10,13],'w'=>[1,3,4,7,8,10,13]],
                "unidades" => ['r'=>[1,5,14],'w'=>[1,5,14]],
                "actividades_mo" => ['r'=>[1,5,14],'w'=>[1,5,14]],
                "categorias_mo" => ['r'=>[1,5,14],'w'=>[1,5,14]],
                "subcategorias_mo" => ['r'=>[1,5,14],'w'=>[1,5,14]],
                "supercategorias_mo" => ['r'=>[1,5,14],'w'=>[1,5,14]],
                "supercategorias_sem" => ['r'=>[1,5,14],'w'=>[1,5,14]],
                "firma" => ['r'=>[1,5,14],'w'=>[1,5,14]],
                "estimaciones_programa" => ['r'=>[1,3,4,7,8,10,13],'w'=>[1,3,4,7,8,10,13]],
                "prototipos_mo" => ['r'=>[1,3,4,7,8,10,13],'w'=>[1,3,4,7,8,10,13]],
                "constructores" => ['r'=>[1,5,14],'w'=>[1,5,14]],
                "control" => ['r'=>[1,5,14],'w'=>[1,5,14]],
                "resumen" => ['r'=>[1,5,14],'w'=>[1,5,14]],
                "asignacion" => ['r'=>[1,5,14,18],'w'=>[1,5,14,18]],
                "cortes" => ['r'=>[1,5,14],'w'=>[1,5,14]],
                "precorte" => ['r'=>[1,5,9,14,17,18,19],'w'=>[1,5,9,14,17,18,19]],
                "estimacion" => ['r'=>[1,5,14],'w'=>[1,5,14]],
                "preorden" => ['r'=>[1,5,14],'w'=>[1,5,14]],
                "restimacion" => ['r'=>[1,5,14],'w'=>[1,5,14]],
                "ractividades" => ['r'=>[1,5,14],'w'=>[1,5,14]],
                "rordenes" => ['r'=>[1,5,14],'w'=>[1,5,14]],
                "rsync" => ['r'=>[1,5,14],'w'=>[1,5,14]],
            ],

            "materiales"=>[
                "empresas" => ['r'=>[1,5,14,21],'w'=>[1,5,14,21]],
                "rcomparativa" => ['r'=>[1,5,14,21],'w'=>[1,5,14,21]],
                "rcomparativa_oc" => ['r'=>[1,5,14,21],'w'=>[1,5,14,21]],
                "rsemana" => ['r'=>[1,5,14,21],'w'=>[1,5,14,21]],
                "control_materiales" =>[[1,5,14,21]],
                "pmat" => ['r'=>[1,5,14,21],'w'=>[1,5,14,21]],
                "orden_compra" => ['r'=>[1,5,14,21],'w'=>[1,5,14,21]],
                "categorias_mat" => ['r'=>[1,5,14,21],'w'=>[1,5,14,21]],
                "almacenes" => ['r'=>[1,5,14,21],'w'=>[1,5,14,21]],
                "rcomparativa_res" => ['r'=>[1,5,14,21],'w'=>[1,5,14,21]],
                "area_material" => ['r'=>[1,5,14,21],'w'=>[1,5,14,21]],
                "materiales" => ['r'=>[1,5,14,21],'w'=>[1,5,14,21]],
                "proveedores" => ['r'=>[1,5,14,21],'w'=>[1,5,14,21]],
                "compra" => ['r'=>[1,5,14,21],'w'=>[1,5,14,21]],
                "recepcion" => ['r'=>[1,5,14,21],'w'=>[1,5,14,21]],
                "requisicion" => ['r'=>[1,5,14,18,21],'w'=>[1,5,14,18,21]],
            ],

            "costos"=>[
                "presupuestos" => ['r' => array(1, 2), 'w' => array(1, 2)],
                "pptomo" => ['r' => array(1, 2), 'w' => array(1, 2)],
                "pptomat" => ['r' => array(1, 2), 'w' => array(1, 2)],
                "creator" => ['r' => array(1, 2), 'w' => array(1, 2)],
            ],

            "rh"=>[
                "areas" => ['r' => array(1, 2,20,21), 'w' => array(1, 2,20,21)],
                "personal" => ['r' => array(1, 2,20,21), 'w' => array(1, 2,20,21)],
                "puestos" => ['r' => array(1, 2,20,21), 'w' => array(1, 2,20,21)],
                "biotime" => ['r' => array(1, 2,20,21), 'w' => array(1, 2,20,21)],
                "postulaciones" => ['r' => array(1, 2,20,21), 'w' => array(1, 2,20,21)],
            ],

            "mercadotecnia"=>[
                "captacion" => ['r'=>[1,3,4,8,10],'w'=>[1,3,4,8,10]],
                "recopilacion" => ['r'=>[1,2,3,4,8,10],'w'=>[1,2,3,4,8,10]],
                "recopilacion_edit" => ['r'=>[1,3,4,8,10],'w'=>[1,3,4,8,10]],
                "resultado" => ['r'=>[1,2,3,4,8,10],'w'=>[1,2,3,4,8,10]],
                "resultado_edit" => ['r'=>[1,3,4,8,10],'w'=>[1,3,4,8,10]],
                "ratencion" => ['r'=>[1,3,4,7,8,10],'w'=>[1,3,4,7,8,10]],
                "prospectosfb" => ['r'=>[1,3,4,8,10],'w'=>[1,3,4,8,10]],
                "g_prospectos" => ['r'=>[1,14],'w'=>[1,14]],
                "g_ventas" => ['r'=>[1,14],'w'=>[1,14]],
            ],

            "calidad"=>[
                "entrega" => ['r'=>[1,2,3,4,5,6,7,8,9,10,11,12,14],'w'=>[1,2,3,4,5,6,7,8,9,10,11,12,14]],
                "entrega_edit" => ['r'=>[1,3,5,6,9,14],'w'=>[1,3,5,6,9,14]],
                "postventa" => ['r'=>[1,2,3,4,5,6,7,8,9,10,11,14],'w'=>[1,2,3,4,5,6,7,8,9,10,11,14]],
                "postventa_edit" => ['r'=>[1,3,4,5,6,7,8,9,10,11,14],'w'=>[1,3,4,5,6,7,8,9,10,11,14]],
                "encuesta" => ['r'=>[1,3,4,6,8,10,11,14],'w'=>[1,3,4,6,8,10,11,14]],
                "g_encuesta" => ['r'=>[1,14],'w'=>[1,14]],
                "g_incidencias" => ['r'=>[1,14],'w'=>[1,14]],
                "asignacionc" => ['r'=>[1,5,14],'w'=>[1,5,14]],
            ],

            "administracion"=>[
                "vehiculos" => ['r'=>[1,11,21],'w'=>[1,11,21]],
                "electronica" => ['r'=>[1,11,21],'w'=>[1,11,21]],
                "mobiliario" => ['r'=>[1,11,21],'w'=>[1,11,21]],
                "otros" => ['r'=>[1,11,21],'w'=>[1,11,21]],
                "categoria" => ['r'=>[1,11,21],'w'=>[1,11,21]],
                "cartas" => ['r'=>[1,7,11,13,21],'w'=>[1,7,11,13,21]],
            ],

            "contabilidad"=>[
                "comisiones_bonos" => ['r'=>[1,3,7,10],'w'=>[1,3,7,10]],
                "matriz_comisiones" => ['r'=>[1,7],'w'=>[1,7]],
                "comisiones_fraccionamientos" => ['r'=>[1,7],'w'=>[1,7]],
                "comisiones" => ['r'=>[1,3,7,10],'w'=>[1,3,7,10]],
                "comisiones_edit" => ['r'=>[1,7],'w'=>[1,7]],
                "comisiones_bonos_edit" => ['r'=>[1,3,7,10],'w'=>[1,3,7,10]],
                "bonificaciones" => ['r'=>[1,3,7],'w'=>[1,3,7]],
                "bonificaciones_edit" => ['r'=>[1,7],'w'=>[1,7]],
            ],
        );
       //$index='debug';
        if(isset($allowed[$module][$index])){
            return $allowed[$module][$index];
        }else if($all){
            return ($module!="") ? $allowed[$module] : $allowed;
        }else{
            return ['r' => [], 'w' => []];
        }
    }
}

if (! function_exists('valConcat'))
{
     function valConcat($text="",$char=", ")
    {
        if($text != ""){
            return $char;
        }
    }
}

//temporal
if (! function_exists('sessionId'))
{
     function sessionId()
    {
        $ci=& get_instance();
        $nsession = $ci->config->item('nsession');
        return $nsession;
    }
}

if (! function_exists('getSession'))
{
     function getSession($module,$index,$column='r')
    {
        $exist=false;
       //Validación de usuarios
        if(is_array($index)){
            foreach ($index as &$val){
                $permisos=permisos($module,$val);
                if(in_array($_SESSION[sessionId()]['rol'], $permisos[$column])){
                    $exist=true;
                }
            }
        }else{
            $permisos=permisos($module,$index);
            $exist=in_array($_SESSION[sessionId()]['rol'],$permisos[$column]);
        }
        return $exist;
    }
}

if (! function_exists('valSession'))
{
     function valSession($module,$index,$column='r')
    {
       //Validación de usuarios
       $permisos=permisos($module,$index);
       $exist=(in_array($_SESSION[sessionId()]['rol'],$permisos[$column])) ? "" : redirect('denegado');
       //condiciones en personalizadas
       ($_SESSION[sessionId()]['idEmpresa'] == 0 && ($module=="materiales" && $index!="requisicion")) ? redirect('denegado/empresas/'.$index) : "";

       return $exist;
    }
}

if (! function_exists('valActive'))
{
     function valActive($controller,$controllers)
    {
       return in_array($controller,$controllers);
    }
}

if (! function_exists('valModule'))
{
     function valModule($module)
    {
        $exist=false;
        $permisos=permisos($module,'',true);
        $controllers=array_keys($permisos);
        foreach($controllers as $controller){
            if(isset(permisos($module,$controller)['r'])){
                if(getSession($module,$controller)){
                    $exist=true;
                    break;
                }
            }
        }
        return $exist;
    }
}

if (! function_exists('getTipoAjuste'))
{
     function getTipoAjuste($status)
    {
        switch ($status) {
            case '1':
                 $statusArra = 'Normal';
                break;
            case '2':
                $statusArra = 'Extra';
                break;
            case '3':
                $statusArra = 'Aditiva';
                break;
            case '4':
                $statusArra = 'Deductiva';
                break;
            default:
                $statusArra= 'Normal';
                break;
        }
        return $statusArra;
    }
}

if (! function_exists(function: 'tipoLote'))
{
     function tipoLote($status)
    {
        switch ($status) {
            case '1':
                 $status = 'Edificación';
                break;
            case '2':
                $status = 'Complementaria';
                break;
            case '3':
                $status = 'Urbanización';
                break;
            case '4':
                $status = 'Plataformas';
                break;
            case '5':
                $status = 'Electrificación';
                break;
            case '6':
                $status = 'Extra';
                break;
            default:
                $status= '';
                break;
        }
        return $status;
    }
}

if (! function_exists(function: 'getTipoAlmacen'))
{
     function getTipoAlmacen($status)
    {
        switch ($status) {
            case '1':
                 $status = 'Por Paquete';
                break;
            case '2':
                $status = 'Por Arranque';
                break;
            default:
                $status= '';
                break;
        }
        return $status;
    }
}

if (! function_exists('estatusArranque'))
{
     function estatusArranque($status)
    {
        switch ($status) {
            case '1':
                 $statusArra = 'Pendiente';
                break;

            case '2':
                $statusArra = 'En Curso';
                break;
            case '3':
                $statusArra = 'Finalizado';
                break;

            default:
                $statusArra= '';
                break;
        }
        return $statusArra;
    }
}

if (! function_exists('getColor'))
{
    function getColor($idColor=1){
        if(is_numeric($idColor)){
            $n=15;
            $idColor = ($idColor > $n) ? $idColor - ($n * intval($idColor / $n)) : $idColor;
            $colores = array("","40E0D0","FF6347","00FF7F","87CEEB",
                "C0C0C0","FA8072","FFC0CB","AFEEEE","98FB98","DA70D6",
                "FF8C00","9370D8","00FF00","F5DEB3","FFFF00"
            );
            return $colores[$idColor];
        }
    }
}

if (! function_exists('getStatusRequisicion'))
{
    function getStatusRequisicion($status=0){
        $arrayStatus = array(
            0 => "Pendiente",
            1 => "Pendiente",
            2 => "Solicitada",
            3 => "Entregada"
        );
        return ($status == 0) ? $arrayStatus : $arrayStatus[$status];
    }
}

if (! function_exists('getStatusPaquete'))
{
    function getStatusPaquete($status=0){
        $arrayStatus = array(
            0 => "Pendiente",
            1 => "Pendiente",
            2 => "En curso",
            3 => "Finalizado"
        );
        return ($status == 0) ? $arrayStatus : $arrayStatus[$status];
    }
}

if (! function_exists('createLink'))
{
    function createLink($link='',$leyenda='',$name='',$clase='',$target=''){
        return '<a  href="'.$link.'" id="'.$name.'" name="'.$name.'" class="'.$clase.'" target="'.$target.'">'.$leyenda.'</a> ';
    }
}

/* forms */
/**********************************************************************************************************************/
/*************************** Inicio Helpers Solo para CACTUS  (_*-*)_  ************************************************/
/**********************************************************************************************************************/
/* inicio Helpers 06-10-2016 */
if (! function_exists('randomText'))
{
    function randomText($l=''){
        $k='';
        $p= "abcdefghijklmnopqrstuvwxyz";
        $m = strlen($p)-1;
        for($i=0;$i<$l;$i++){
            $k .= $p[rand(0,$m)];
        }
        return $k;
    }
}

if (! function_exists('randomNumber'))
{
    function randomNumber($l=''){
        $k='';
        $p= "1234567890";
        $m = strlen($p)-1;
        for($i=0;$i<$l;$i++){
            $k .= $p[rand(0,$m)];
        }
        return $k;
    }
}

if (! function_exists('createSelectResultName')) {
    function createSelectResultName($name,$values,$leyenda='',$placeholder='',$selected = NULL,$error = NULL,$clase=''){
        $classError="";
        if ( $error != null ) {
            $classError="has-error";
        }

        $html = '
        <div id="div'.$name.'" class="form-group form-md-line-input '.$classError.'">
            <div class="col-md-12" style="margin-bottom:5px;">
                <label class="control-label" for="'.$name.'">'.$leyenda.'</label>
            </div>
            <div class="col-md-12">
                <select id="'.$name.'" name="'.$name.'" class="form-control '.$clase.'">';
        if ( $placeholder == '' ) {
            $html .= '<option value="" selected="selected">Seleccione</option>';
        }
        else {
            $html .= '<option value="" selected="selected">'.$placeholder.'</option>';
        }
        if ( !is_numeric($values) ) {
            foreach($values->result() as $valor) {
                if($valor->id == $selected) {
                    $html .= '<option value="'.$valor->id.'" selected="selected">'.$valor->nombre.'</option>';
                }
                else {
                    $html .= '<option value="'.$valor->id.'">'.$valor->nombre.'</option>';
                }
            }
        }

        $html .= '</select>
                <div class="form-control-focus"> </div>
                <span class="help-block help-block-error" id="'.$name.'E">'.$error.'</span>
                <span class="help-block"></span>
            </div>
        </div>';
        return $html;
    }
}


if (! function_exists('createSelectResultMultiple')) {
    function createSelectResultMultiple($name,$values,$leyenda='',$selected = NULL,$error = NULL,$clase='', $extra = '') {
        $classError="";
        if( $error != null ) {
            $classError="has-error";
        }
        if($selected != NULL){
            $selecteds = explode("-",$selected);
        }else{
            $selecteds = array();
        }
        $html = '
        <div id="div'.$name.'" class="form-group form-md-line-input '.$classError.'">
            <div class="col-md-12" style="margin-bottom:5px;">
                <label class="control-label" for="'.$name.'" style="font-weight:normal;">'.$leyenda.'</label>
            </div>
            <div class="col-md-12">
                <select id="'.$name.'" name="'.$name.'" class="form-control '.$clase.'" '.$extra.' multiple>';
        if ( !is_numeric($values) ) {
            foreach($values->result() as $valor) {
                if( in_array($valor->id, $selecteds) ) {
                    $html .= '<option value="'.$valor->id.'" selected="selected">'.$valor->titulo.'</option>';
                }
                else {
                    $html .= '<option value="'.$valor->id.'">'.$valor->titulo.'</option>';
                }
            }
        }
        $html .= '</select>
                <div class="form-control-focus"> </div>
                <span class="help-block help-block-error">'.$error.'</span>
                <span class="help-block"></span>
            </div>
        </div>';
        return $html;
    }
}
#prueba para alerts
if (! function_exists('alertMessage')) {
    function alertMessage($dat) {
        $html = '';
        switch ($dat['tipo']) {
            case 'error':
                # code...
            $html ='<div class="alert alert-warning alert-dismissible  show" role="alert">
                        <strong>Holy guacamole!</strong> You should check in on some of those fields below.
                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>';

                break;
            case 'warning':
                # code...
                $html =  "<div class='alert alert-warning alert-dismissible fade show' role='alert'>
                                      <strong>Holy guacamole!</strong> You should check in on some of those fields below.
                                      <button type='button' class='close' data-dismiss='alert' aria-label='Close'>
                                             <span aria-hidden='true'>&times;</span>
                                      </button>
                      </div>";
                break;
            case 'success':
                # code...
                $html =  "<div class='alert alert-success alert-dismissible fade show' role='alert'>
                                      <strong>Holy guacamole!</strong> You should check in on some of those fields below.
                                      <button type='button' class='close' data-dismiss='alert' aria-label='Close'>
                                             <span aria-hidden='true'>&times;</span>
                                      </button>
                      </div>";
                break;

            default:
                # code...
                break;
        }
        return $html;
    }

}

if (! function_exists('createSelectResultMultipleName')) {
    function createSelectResultMultipleName($name,$values,$leyenda='',$selected = NULL,$error = NULL,$clase='') {
        $classError="";
        if( $error != null ) {
            $classError="has-error";
        }
        $selecteds = explode("-",$selected);
        $html = '
        <div id="div'.$name.'" class="form-group form-md-line-input '.$classError.'">
            <div class="col-md-12" style="margin-bottom:5px;">
                <label class="control-label" for="'.$name.'">'.$leyenda.'</label>
            </div>
            <div class="col-md-12">
                <select id="'.$name.'" name="'.$name.'" class="form-control '.$clase.'" multiple>';
        if ( !is_numeric($values) ) {
            foreach ($values->result() as $valor) {
                if ( in_array($valor->id, $selecteds) ) {
                    $html .= '<option value="'.$valor->id.'" selected="selected">'.$valor->nombre.'</option>';
                }
                else {
                    $html .= '<option value="'.$valor->id.'">'.$valor->nombre.' '.$valor->apellido.'</option>';
                }
            }
        }
        $html .= '</select>
                <div class="form-control-focus"> </div>
                <span class="help-block help-block-error">'.$error.'</span>
                <span class="help-block"></span>
            </div>
        </div>';
        return $html;
    }
}

if ( !function_exists('accionesProgramaObra')) {
    function accionesProgramaObra($id,$ruta,$agregarMaterial=true,$borrar = true,$rowActividadId=true, $idPrototipo=true) {
        $saccion ='
        <div class="actions">
            <div class="btn-group">
                <a class="btn btn-sm green dropdown-toggle" href="javascript:;" data-toggle="dropdown">
                    Acciones
                    <i class="fa fa-angle-down"></i>
                </a>
                <ul class="dropdown-menu pull-right">';
        if ( $agregarMaterial) {
            $saccion .= '<li><a target="_blank" href="'.$ruta.'/agregarMaterial/'.$rowActividadId.'/'.$idPrototipo.'">Agregar </a></li>';
        }
        if ( $borrar ) {
            $saccion .='<li><a onclick="modalEliminarActividad('.$rowActividadId.')"  >Eliminar </a></li>';
        }
        $saccion .= "
                </ul>
            </div>
        </div>";
        return $saccion;
    }
}

if ( !function_exists('accionesPreorden')) {
    function accionesPreorden($id,$idCorte,$ruta) {
        $saccion ='
        <div class="actions">
            <div class="btn-group">
                <a class="btn btn-sm green dropdown-toggle" href="javascript:;" data-toggle="dropdown">
                    Acciones
                    <i class="fa fa-angle-down"></i>
                </a>
                <ul class="dropdown-menu pull-right">';
                $saccion .='<li><a href="'.$ruta.'/extras/'.$id.'/'.$idCorte.'" target="_blank"><i class="fa fa-check"></i> Extras </a></li>';
                $saccion .='<li><a href="javascript:void(0);" onclick="openModal('.$id.');"><i class="fa fa-edit"></i> Editar </a></li>';
        $saccion .= "
                </ul>
            </div>
        </div>";
        return $saccion;
    }
}

if ( !function_exists('accionesRequisicion')) {
    function accionesRequisicion($id,$ruta,$editar,$borrar,$solicitar,$entregar) {
        $saccion ='
        <div class="actions">
            <div class="btn-group">
                <a class="btn btn-sm green dropdown-toggle" href="javascript:;" data-toggle="dropdown">
                    Acciones
                    <i class="fa fa-angle-down"></i>
                </a>
                <ul class="dropdown-menu pull-right">';
                if ( $solicitar ) {
                    $saccion .='<li><a href="javascript:void(0);" onclick="changeStatus('.$id.',2);"><i class="fa fa-check"></i> Solicitar </a></li>';
                }
                if ( $entregar ) {
                    $saccion .='<li><a href="javascript:void(0);" onclick="changeStatus('.$id.',3);"><i class="fa fa-check"></i> Entregar </a></li>';
                }
                if ( $editar ) {
                    $saccion .=  '<li><a class="blockui-save" href="'.$ruta.'/editar/'.$id.'" target="_blank"><i class="fa fa-pencil"></i>Editar</a></li>';
                }
                if ( $borrar ) {
                    $saccion .='<li><a href="javascript:void(0);" onclick="cambiarEstatus('.$id.','."'".$ruta."'".');"><i class="fa fa-trash-o"></i>Borrar</a></li>';
                }
        $saccion .= "
                </ul>
            </div>
        </div>";
        return $saccion;
    }
}

if ( !function_exists('accionesCorte')) {
    function accionesCorte($id,$ruta,$editar,$borrar,$confirmar) {
        $saccion ='
        <div class="actions">
            <div class="btn-group">
                <a class="btn btn-sm green dropdown-toggle" href="javascript:;" data-toggle="dropdown">
                    Acciones
                    <i class="fa fa-angle-down"></i>
                </a>
                <ul class="dropdown-menu pull-right">';
                if ( $confirmar ) {
                    $saccion .='<li><a href="javascript:void(0);" onclick="changeStatus('.$id.',3);"><i class="fa fa-check"></i> Confirmar </a></li>';
                }
                if ( $editar ) {
                    $saccion .=  '<li><a class="blockui-save" href="estimacion/index/'.$id.'" target="_blank"><i class="fa fa-pencil"></i>Editar</a></li>';
                    $saccion .=  '<li><a class="blockui-save" href="preorden/index/'.$id.'" target="_blank"><i class="fa fa-pencil"></i>Preorden</a></li>';
                }
                if ( $borrar ) {
                    $saccion .='<li><a href="javascript:void(0);" onclick="cambiarEstatus('.$id.','."'".$ruta."'".');"><i class="fa fa-trash-o"></i>Borrar</a></li>';
                }
                $saccion .= "
                </ul>
            </div>
        </div>";
        return $saccion;
    }
}


if ( !function_exists('accionesMAt')) {
    function accionesMAt($id,$ruta,$editarMat=true,$borrar=true,$idMaterial=0,$cantidad=0,$nombreMat="") {
        $saccion ='
        <div class="actions">
            <div class="btn-group">
                <a class="btn btn-sm green dropdown-toggle" href="javascript:;" data-toggle="dropdown">
                    Acciones
                    <i class="fa fa-angle-down"></i>
                </a>
                <ul class="dropdown-menu pull-right">';
        if ( $editarMat) {
            $saccion .= '<li><a  onclick="accionM('.$id.','.$idMaterial.','.$cantidad.',3,'."'$nombreMat'".');"><i class="fa fa-pencil" aria-hidden="true"></i>Editar Material</a></li>';
        }
        if ( $borrar ) {
            $saccion .='<li><a href="javascript:void(0);" onclick="accionM('.$id.',0,0,2,0);"><i class="fa fa-trash-o"></i>Borrar</a></li>';
        }
        $saccion .= "
                </ul>
            </div>
        </div>";
        return $saccion;
    }
}

if ( !function_exists('acciones')) {
    function acciones($id,$ruta,$ver = false,$editar = true,$borrar=true,$usuario='',$formato='',$cerrar=false,$idIncidente=0,$cancelar=false,$idGestoria=0,$planoPrototipo='',$idPostventa=0) {
        switch ($usuario ) {
            case 'promotores':
                $param = '/promotor';
                break;

            default:
                $param = '';
                break;
        }

        if($ruta!='postventa'){
            $blockUi = 'blockui-save';
            $tBlank = '_blank';
        }else{
            $blockUi = 'blockui-save';//'';
            $tBlank = '_blank';//'';
        }

        $saccion ='
        <div class="actions">
            <div class="btn-group">
                <a class="btn btn-sm green dropdown-toggle" href="javascript:;" data-toggle="dropdown">
                    Acciones
                    <i class="fa fa-angle-down"></i>
                </a>
                <ul class="dropdown-menu pull-right">';
        if ( $editar ) {
            $idParam = ($idPostventa>0)?$idPostventa.$param:$id.$param;
            $saccion .=  '<li><a class="'.$blockUi.'" href="'.$ruta.'/editar/'.$idParam.'" target="'.$tBlank.'"><i class="fa fa-pencil"></i>Editar</a></li>';
        }
        if ( $borrar ) {
            $saccion .='<li><a href="javascript:void(0);" onclick="modalEliminar('.intval($id).','."'".$ruta."'".');"><i class="fa fa-trash-o"></i>Borrar</a></li>';
        }
        if ( $ver ) {
            $saccion .= '<li class="divider"> </li> <li><a class="blockui-save" href="'.$ruta.'/ver/'.intval($id).'"><i class="fa fa-eye" aria-hidden="true"></i>Ver</a></li>';
        }
        if ( $planoPrototipo!='' ) {
            $saccion .= '<li class="divider"> </li> <li><a class="blockui-save" target="_blank" href="'.$planoPrototipo.'"><i class="fa fa-file" aria-hidden="true"></i>Ver Plano</a></li>';
        }
        if ( $formato ) {
            $saccion .= '<li class="divider"> </li> <li><a class="blockui-save" href="'.$ruta.'/formato/'.intval($id).'"><i class="fa fa-eye" aria-hidden="true"></i>ver formato</a></li>';
        }
        if ( $cerrar ) {
            $saccion .= '<li class="divider"> </li> <li><a href="javascript:void(0);" onclick="cerrar('.intval($id).','."'".$ruta."'".');"><i class="fa fa-eye" aria-hidden="true"></i>Cerrar</a></li>';
        }
        if ( $cancelar ) {
            $id = ($idGestoria>0)?$idGestoria:$id;
            $saccion .= '<li class="divider"> </li> <li><a href="javascript:void(0);" onclick="modalCancelarProceso('.intval($id).');"><i class="fa fa-recycle" aria-hidden="true"></i>Cancelar</a></li>';
        }
        $saccion .= "
                </ul>
            </div>
        </div>";
        return $saccion;
    }
}

if ( !function_exists('accionesProyecto')) {
    function accionesProyecto($id,$ruta,$ver = false,$editar = true,$idManoObra=0) {        
        $saccion ='
        <div class="actions">
            <div class="btn-group">
                <a class="btn btn-sm green dropdown-toggle" href="javascript:;" data-toggle="dropdown">
                    Acciones
                    <i class="fa fa-angle-down"></i>
                </a>
                <ul class="dropdown-menu pull-right">';
        if ( $editar ) {
            $saccion .=  '<li><a class="blockui-save" href="'.$ruta.'/editar/'.$id.'" target="_blank"><i class="fa fa-pencil"></i>Editar</a></li>';
        }
        if ( $idManoObra > 0 ) {
            $saccion .=  '<li><a class="blockui-save" href="pmo/resumenpmo/'.$idManoObra.'" target="_blank"><i class="fa fa-pencil"></i>PPTO. MO</a></li>';
        }
        if ( $ver ) {
            $saccion .= '<li class="divider"> </li> <li><a class="blockui-save" href="'.$ruta.'/ver/'.intval($id).'"><i class="fa fa-eye" aria-hidden="true"></i>Ver</a></li>';
        }
        $saccion .= "
                </ul>
            </div>
        </div>";
        return $saccion;
    }
}

if ( !function_exists('accionesEntrega')) {
    function accionesEntrega($id,$ruta,$ver = false,$editar = true,$retro=false,$usuario='',$formato='',$cerrar=false,$idIncidente=0,$cancelar=false,$idGestoria=0,$planoPrototipo='',$idPostventa=0) {
        switch ($usuario ) {
            case 'promotores':
                $param = '/promotor';
                break;

            default:
                $param = '';
                break;
        }

        if($ruta!='postventa'){
            $blockUi = 'blockui-save';
            $tBlank = '_blank';
        }else{
            $blockUi = 'blockui-save';//'';
            $tBlank = '_blank';//'';
        }

        $saccion ='
        <div class="actions">
            <div class="btn-group">
                <a class="btn btn-sm green dropdown-toggle" href="javascript:;" data-toggle="dropdown">
                    Acciones
                    <i class="fa fa-angle-down"></i>
                </a>
                <ul class="dropdown-menu pull-right">';
        if ( $editar ) {
            $idParam = ($idPostventa>0)?$idPostventa.$param:$id.$param;
            $saccion .=  '<li><a class="'.$blockUi.'" href="'.$ruta.'/editar/'.$idParam.'" target="'.$tBlank.'"><i class="fa fa-pencil"></i>Editar</a></li>';
        }
        if ( $ver ) {
            $saccion .= '<li class="divider"> </li> <li><a class="blockui-save" href="'.$ruta.'/ver/'.$id.'"><i class="fa fa-eye" aria-hidden="true"></i>Ver</a></li>';
        }
        if ( $retro ) {
            $saccion .= '<li class="divider"> </li> <li><a class="blockui-save" href="'.$ruta.'/retroceso/'.$id.'"><i class="fa fa-undo" aria-hidden="true"></i>Retroceso</a></li>';
        }
        $saccion .= "
                </ul>
            </div>
        </div>";
        return $saccion;
    }
}

if ( !function_exists('accionesPptos')) {
    function accionesPptos($idPmo,$idPmat) {
        $saccion ='
        <div class="actions">
            <div class="btn-group">
                <a class="btn btn-sm green dropdown-toggle" href="javascript:;" data-toggle="dropdown">
                    Acciones
                    <i class="fa fa-angle-down"></i>
                </a>
                <ul class="dropdown-menu pull-right">';
                $saccion .=  '<li><a href="'.'pptomo/detallepmo/'.$idPmo.'" target="_blank"><i class="fa fa-pencil"></i>Mano Obra</a></li>';
                $saccion .=  '<li><a href="'.'pptomat/detallepmat/'.$idPmat.'" target="_blank"><i class="fa fa-pencil"></i>Materiales</a></li>';
        $saccion .= "
                </ul>
            </div>
        </div>";
        return $saccion;
    }
}

if ( !function_exists('accionesAsignacion')) {
    function accionesAsignacion($id,$ruta) {
        $saccion ='
        <div class="actions">
            <div class="btn-group">
                <a class="btn btn-sm green dropdown-toggle" href="javascript:;" data-toggle="dropdown">
                    Acciones
                    <i class="fa fa-angle-down"></i>
                </a>
                <ul class="dropdown-menu pull-right">';
                $saccion .=  '<li><a href="'.$ruta.'/supervisores/'.$id.'" target="_blank"><i class="fa fa-pencil"></i>Supervisores</a></li>';
                $saccion .=  '<li><a href="'.$ruta.'/contratistas/'.$id.'" target="_blank"><i class="fa fa-pencil"></i>Contratistas</a></li>';
                $saccion .=  '<li><a href="'.$ruta.'/coordinadores/'.$id.'" target="_blank"><i class="fa fa-pencil"></i>Coordinadores</a></li>';
        $saccion .= "
                </ul>
            </div>
        </div>";
        return $saccion;
    }
}

if ( !function_exists('accionesAsignacionC')) {
    function accionesAsignacionC($id,$ruta) {
        $saccion ='
        <div class="actions">
            <div class="btn-group">
                <a class="btn btn-sm green dropdown-toggle" href="javascript:;" data-toggle="dropdown">
                    Acciones
                    <i class="fa fa-angle-down"></i>
                </a>
                <ul class="dropdown-menu pull-right">';
                $saccion .=  '<li><a href="'.$ruta.'/inspectores/'.$id.'" target="_blank"><i class="fa fa-pencil"></i>Inspectores</a></li>';
                $saccion .=  '<li><a href="'.$ruta.'/coordinadores/'.$id.'" target="_blank"><i class="fa fa-pencil"></i>Coordinadores</a></li>';
        $saccion .= "
                </ul>
            </div>
        </div>";
        return $saccion;
    }
}

if ( !function_exists('accionesCatalogosContObra')) {
    function accionesCatalogosContObra($id,$ruta,$ver = false,$editar = true,$borrar=true) {
        $saccion ='
        <div class="actions">
            <div class="btn-group">
                <a class="btn btn-sm green dropdown-toggle" href="javascript:;" data-toggle="dropdown">
                    Acciones
                    <i class="fa fa-angle-down"></i>
                </a>
                <ul class="dropdown-menu pull-right">';
        if ( $editar ) {
            $saccion .=  '<li><a class="blockui-save" href="'.$ruta.'/editar/'.$id.'" target="_blank"><i class="fa fa-pencil"></i>Editar</a></li>';
        }
        if ( $borrar ) {
            $saccion .='<li><a href="javascript:void(0);" onclick="cambiarEstatus('.$id.','."'".$ruta."'".');"><i class="fa fa-trash-o"></i>Borrar</a></li>';
        }

        $saccion .= "
                </ul>
            </div>
        </div>";
        return $saccion;
    }
}



if ( !function_exists('accionesUsuarios')) {
    function accionesUsuarios($id,$ruta,$editar = true,$borrar=true,$agregarFirma = true,$superAdmin=false) {
        $saccion ='
        <div class="actions">
            <div class="btn-group">
                <a class="btn btn-sm green dropdown-toggle" href="javascript:;" data-toggle="dropdown">
                    Acciones
                    <i class="fa fa-angle-down"></i>
                </a>
                <ul class="dropdown-menu pull-right">';
        if ( $editar ) {
            $saccion .=  '<li><a class="blockui-save" href="'.$ruta.'/editar/'.$id.'" target="_blank"><i class="fa fa-pencil"></i>Editar</a></li>';
        }
        if ( $borrar ) {
            $saccion .='<li><a href="javascript:void(0);" onclick="modalEliminar('.$id.','."'".$ruta."'".');"><i class="fa fa-trash-o"></i>Borrar</a></li>';
        }
        if ( $agregarFirma ) {
            $saccion .= '<li class="divider"> </li> <li><a class="blockui-save" target="_blank" href="firma/validarFirma/'.$id.'"><i class="fa fa-eye" aria-hidden="true"></i>Firma</a></li>';
        }
        $saccion .= "
                </ul>
            </div>
        </div>";
        return $saccion;
    }
}
if ( !function_exists('accionesPrototipos')){
    function accionesPrototipos($id,$ruta,$ver = false,$editar = true,$borrar=true,$programa=true)
    {
        $saccion ='
                    <div class="actions">
                        <div class="btn-group">
                            <a class="btn btn-sm green dropdown-toggle" href="javascript:;" data-toggle="dropdown"> Acciones
                                <i class="fa fa-angle-down"></i>
                            </a>
                            <ul class="dropdown-menu pull-right">

                           ';
        if ($editar) {
            $saccion .=  '<li><a href="'.$ruta.'/editar/'.$id.'"><i class="fa fa-pencil"></i>Editar</a></li>';
        }
        if ($borrar) {
            $saccion .='<li><a href="javascript:void(0);" onclick="modalEliminar('.$id.','."'".$ruta."'".');"><i class="fa fa-trash-o"></i>Borrar</a></li>';
        }
        if ($ver) {
            $saccion .= '<li class="divider"> </li>
            <li><a href="'.$ruta.'/ver/'.$id.'"><i class="fa fa-eye" aria-hidden="true"></i>Ver</a></li>';
        }
        if ($programa) {
            $saccion .= '<li class="divider"> </li>
            <li><a href="'.$ruta.'/programaObra/'.$id.'"><i class="fa fa-list" aria-hidden="true"></i>Actividades <br>del prototipo</a></li>';
        }
        $saccion .= "
                            </ul>
                        </div>
                    </div>";
        return $saccion;
    }
}

if ( !function_exists('accionesPrototiposMO')){
    function accionesPrototiposMO($id,$ruta,$ver = false,$editar = true,$borrar=true,$programa=true)
    {
        $saccion ='
                    <div class="actions">
                        <div class="btn-group">
                            <a class="btn btn-sm green dropdown-toggle" href="javascript:;" data-toggle="dropdown"> Acciones
                                <i class="fa fa-angle-down"></i>
                            </a>
                            <ul class="dropdown-menu pull-right">

                           ';
        if ($editar) {
            $saccion .=  '<li><a href="'.$ruta.'/editar/'.$id.'"><i class="fa fa-pencil"></i>Editar</a></li>';
        }
        if ($borrar) {
            $saccion .='<li><a href="javascript:void(0);" onclick="cambiarEstatus('.$id.','."'".$ruta."'".');"><i class="fa fa-trash-o"></i>Borrar</a></li>';
        }
        if ($ver) {
            $saccion .= '<li class="divider"> </li>
            <li><a href="'.$ruta.'/ver/'.$id.'"><i class="fa fa-eye" aria-hidden="true"></i>Ver</a></li>';
        }
        if ($programa) {
            $saccion .= '<li class="divider"> </li>
            <li><a href="'.$ruta.'/programaObra/'.$id.'"><i class="fa fa-list" aria-hidden="true"></i>Actividades <br>del prototipo</a></li>';
        }
        $saccion .= "
                            </ul>
                        </div>
                    </div>";
        return $saccion;
    }
}

if ( !function_exists('accionesAsignar')) {
    function accionesAsignar($id,$ruta,$reasignar = true,$editar=true,$leyenda1='Subir Carta',$descargaFile=false) {
        $saccion ='
        <div class="actions">
            <div class="btn-group">
                <a class="btn btn-sm green dropdown-toggle" href="javascript:;" data-toggle="dropdown">
                    Acciones
                    <i class="fa fa-angle-down"></i>
                </a>
                <ul class="dropdown-menu pull-right">';
        if ( $descargaFile ) {
            $saccion .=  '<li><a class="blockui-save" href="formatospdf/responsiva/'.$id.'"><i class="fa fa-file-pdf-o"></i>Generar Carta</a></li>';
        }
        if ( $editar ) {
            $saccion .=  '<li><a class="blockui-save" href="'.$ruta.'/editar/'.$id.'"><i class="fa fa-pencil"></i>'.$leyenda1.'</a></li>';
        }
        if ( $reasignar ) {
            $saccion .=  '<li><a class="blockui-save" href="'.$ruta.'/reasignar/'.$id.'"><i class="fa fa-pencil"></i>Reasignar</a></li>';
        }
        $saccion .= "
                </ul>
            </div>
        </div>";
        return $saccion;
    }
}

if ( !function_exists('accionesNoEdit')) {
    function accionesNoEdit($id,$ruta,$ver=true) {
        $saccion ='
        <div class="actions">
            <div class="btn-group">
                <a class="btn btn-sm green dropdown-toggle" href="javascript:;" data-toggle="dropdown">
                    Acciones
                    <i class="fa fa-angle-down"></i>
                </a>
                <ul class="dropdown-menu pull-right">';
        if ($ver) {
            $saccion .= '<li class="divider"> </li>
            <li><a href="'.$ruta.'/ver/'.$id.'"><i class="fa fa-eye" aria-hidden="true"></i>Ver</a></li>';
        }
        $saccion .= "
                </ul>
            </div>
        </div>";
        return $saccion;
    }
}

if ( !function_exists('accionesP')) {
    function accionesP($id,$ruta,$ver = false,$editar = true,$borrar=true,$usuario='') {
        switch ($usuario ) {
            case 'promotores':
                $param = '/promotor';
                break;

            default:
                $param = '';
                break;
        }

        $saccion ='
        <div class="actions">
            <div class="btn-group">
                <a class="btn btn-sm green dropdown-toggle" href="javascript:;" data-toggle="dropdown">
                    Acciones
                    <i class="fa fa-angle-down"></i>
                </a>
                <ul class="dropdown-menu pull-right">';
        if ( $editar ) {
            $text=($_SESSION["viv"]['rol']==4) ? "Reasignar" : "Editar";
            $saccion .=  '<li><a class="blockui-save" href="'.$ruta.'/editar/'.$id.$param.'" target="_blank"><i class="fa fa-pencil"></i>'.$text.'</a></li>';
        }
        if ( $borrar ) {
            $saccion .='<li><a href="javascript:void(0);" onclick="modalEliminar('.$id.','."'".$ruta."'".');"><i class="fa fa-trash-o"></i>Borrar</a></li>';
        }
        if ( $ver ) {
            $saccion .= '<li class="divider"> </li> <li><a class="blockui-save" href="'.$ruta.'/ver/'.$id.'"><i class="fa fa-eye" aria-hidden="true"></i>Ver</a></li>';
        }
        $saccion .= "
                </ul>
            </div>
        </div>";
        return $saccion;
    }
}


if ( !function_exists('accionesBlackboard')) {
    function accionesBlackboard($id,$ruta,$ver = false,$editar = false,$borrar=false) {
        $saccion ='
        <div class="actions">
            <div class="btn-group">
                <a class="btn btn-sm green dropdown-toggle" href="javascript:;" data-toggle="dropdown">
                    Acciones
                    <i class="fa fa-angle-down"></i>
                </a>
                <ul class="dropdown-menu pull-right">';
        if ( $editar ) {
            $saccion .=  '<li> <a href="'.$ruta.'/editar/'.$id.'"> <i class="fa fa-pencil"></i> Editar </a> </li>';
        }
        if ( $borrar ) {
            $saccion .='<li> <a href="javascript:void(0);" onclick="modalEliminar('.$id.','."'".$ruta."'".');"> <i class="fa fa-trash-o"></i> Borrar </a> </li>';
        }
        if ( $ver ) {
            $saccion .= '<li class="divider"> </li> <li> <a href="'.$ruta.'/ver/'.$id.'"> <i class="fa fa-eye" aria-hidden="true"></i> Ver </a> </li>';
        }
        $saccion .= "
                </ul>
            </div>
        </div>";
        return $saccion;
    }
}

if ( !function_exists('actionCheckedBlackboard') ) {
    function actionCheckedBlackboard( $id = null, $checked = null ) {
        $saccion = '
        <label class="mt-checkbox mt-checkbox-single mt-checkbox-outline">
            <input onclick="modalAlert('.$id.');" id="chk_'.$id.'" data-id="'.$id.'" type="checkbox" value="'.$checked.'" class="group-checkable" data-set="#sample_2 .checkboxes" '.($checked == 1 ? 'checked="true"' : '').' '.($checked == 1 ? 'disabled="disabled"' : '').'>'.($checked == 1 ? 'F' : '').'
            <span></span>
        </label>';
        return $saccion;
    }
}


if ( !function_exists('actionCheckedBlackboard') ) {
    function actionCheckedBlackboard( $id = null, $checked = null ) {
        $saccion = '
        <label class="mt-checkbox mt-checkbox-single mt-checkbox-outline">
            <input onclick="modalAlert('.$id.');" id="chk_'.$id.'" data-id="'.$id.'" type="checkbox" value="'.$checked.'" class="group-checkable" data-set="#sample_2 .checkboxes" '.($checked == 1 ? 'checked="true"' : '').' '.($checked == 1 ? 'disabled="disabled"' : '').'>'.($checked == 1 ? 'F' : '').'
            <span></span>
        </label>';
        return $saccion;
    }
}

if ( !function_exists('rhactiveCheck') ) {
    function rhactiveCheck( $id = null, $checked = null ) {
        $saccion = '
        <label class="mt-checkbox mt-checkbox-single mt-checkbox-outline">
            <input onclick="modalAlert('.$id.');" id="chk_'.$id.'" data-id="'.$id.'" type="checkbox" value="'.$checked.'" class="group-checkable" data-set="#sample_2 .checkboxes" '.($checked == 1 ? 'checked="true"' : '').' '.($checked == 1 ? '' : '').'>'.($checked == 1 ? '' : '').'
            <span></span>
        </label>';
        return $saccion;
    }
}

if ( !function_exists('actionCompleteBlackboard') ) {
    function actionCompleteBlackboard( $id = null, $complete = null ) {
        $saccion = '
        <label class="mt-checkbox mt-checkbox-single mt-checkbox-outline">
            <input onclick="modalComplete('.$id.');" id="chk2_'.$id.'" data-id="'.$id.'" type="checkbox" value="'.$complete.'" class="group-checkable" data-set="#sample_2 .checkboxes" '.($complete == 1 ? 'checked="true"' : '').' '.($complete == 1 ? 'disabled="disabled"' : '').'>'.($complete == 1 ? 'F' : '').'
            <span></span>
        </label>';
         if ($_SESSION['viv']['rol']!=1){
            $saccion = '

            ';
         }
        return $saccion;
    }
}

if ( !function_exists('accionesEncesta')) {
    function accionesEncesta( $id, $ruta, $ver = false, $responder = true, $borrar=false ) {
        $saccion ='
        <div class="actions">
            <div class="btn-group">
                <a class="btn btn-sm green dropdown-toggle" href="javascript:;" data-toggle="dropdown">
                    Acciones
                    <i class="fa fa-angle-down"></i>
                </a>
                <ul class="dropdown-menu pull-right">';
        if ( $responder ) {
            $saccion .= '<li>
                            <a class="blockui-save" href="'.$ruta.'/responder/'.$id.'"> <i class="fa fa-pencil"></i> Responder </a>
                        </li>';
        }
        if ( $borrar ) {
            $saccion .= '<li>
                            <a href="javascript:void(0);" onclick="modalEliminar('.$id.','."'".$ruta."'".');"> <i class="fa fa-trash-o"></i> Borrar </a>
                        </li>';
        }
        if ( $ver ) {
            $saccion .= '<li class="divider"> </li>
                        <li>
                            <a class="blockui-save" href="'.$ruta.'/ver/'.$id.'"> <i class="fa fa-eye" aria-hidden="true"></i> Ver </a>
                        </li>';
        }
        $saccion .= "
                </ul>
            </div>
        </div>";
        return $saccion;
    }
}

if ( !function_exists('type_qualification_selected')) {
    function type_qualification_selected( $type = '' ) {
        switch ($type) {
            case 1:
                $text = 'P&Eacute;SIMO';
                break;
            case 2:
                $text = 'MALO';
                break;
            case 3:
                $text = 'REGULAR';
                break;
            case 4:
                $text = 'BUENO';
                break;
            case 5:
                $text = 'EXCELENTE';
                break;

            default:
                $text = '';
                break;
        }
        return $text;
    }
}

if ( !function_exists('radio_info_we')) {
    function radio_info_we( $type = '' ) {
        switch ($type) {
            case 1:
                $text = 'Volante';
                break;
            case 2:
                $text = 'Radio';
                break;
            case 3:
                $text = 'Televisi&oacute;n';
                break;
            case 4:
                $text = 'De Paso';
                break;
            case 5:
                $text = 'Redes Sociales';
                break;
            case 6:
                $text = 'Recomendaci&oacute;n';
                break;
            case 7:
                $text = 'Medios Impresos';
                break;
            case 8:
                $text = 'Otros';
                break;

            default:
                $text = '';
                break;
        }
        return $text;
    }
}
/**********************************************************************************************************************/
/*************************** Inicio Helpers Solo para CACTUS _(*-*_)  *************************************************/
/**********************************************************************************************************************/

/**********************************************************************************************************************/
/*************************** Inicio Helpers 06-10-2016  (_*-*)_  ******************************************************/
/**********************************************************************************************************************/
/* inicio Helpers 06-10-2016 */
if ( !function_exists('nav_menu_item'))
{
    function nav_menu_item($link,$titulo, $seccion)
    {
        $var = ($seccion == $link) ? 'class="current"' : "" ;
        echo "<li><a $var href=\"$link\"><img src=\"images/ancla.png\" alt=\"\"> $titulo</a></li>\n";
    }
}

if (! function_exists('formCheckRadios')){
    function formCheckRadios($nomGrupo, $leyenda = null, $arrConfig = null){
        //
        $strEstructura = null;
        if(!is_null($arrConfig)){
            $strEstructura = '<div class="form-group form-group form-md-radios"><br>';
            if(!is_null($leyenda)){
                $strEstructura .= '<div class="col-md-12">
                                        <label class="form-label" for="checkboxes">'.$leyenda.'</label>
                                    </div><br>';
            }
            $strEstructura .= '<div class="md-radio-inline col-md-12">';
            foreach ($arrConfig as $key => $optConfig) {
                $valCkecked = (isset($optConfig["checked"]) && $optConfig["checked"] == true) ? 'checked="checked"': '';
                $strEstructura .= '<div class="md-radio">
                                        <input type="radio" name="'.$nomGrupo.'" id="'.$optConfig["id"].'" class="md-radiobtn" value="'.$optConfig["value"].'" '.$valCkecked.' />
                                        <label for="'.$optConfig["id"].'">
                                            <span></span>
                                            <span class="check"></span>
                                            <span class="box"></span> '.$optConfig["texto"].'
                                        </label>
                                    </div>';
            }
            $strEstructura .= '</div></div>';
        }
        return $strEstructura;
    }
}

if (! function_exists('formInput'))
    {
        function formInput($name,$leyenda = '',$placeholder='',$value=null,$error=null,$clase='', $extra='',$orientacion='inline',$readOnly = false){
            $classError="";
            if($error!=null){
                $classError="has-error";
            }
            $html = '
                <div id="div'.$name.'" class="form-group form-md-line-input '.$classError.'">
                    <div class="col-md-12" style="margin-bottom:5px;">
                        <label class="control-label" for="'.$name.'">'.$leyenda.'</label>
                    </div>
                    <div class="col-md-12">
                        <input id="'.$name.'" name="'.$name.'" value="'.$value.'" type="text" class="form-control '.$clase.'" placeholder="'.$placeholder.'" '.$extra.' '.$read = ($readOnly) ? "readonly" : "".'>
                        <div class="form-control-focus"> </div>
                        <span class="help-block help-block-error">'.$error.'</span>
                        <span class="help-block"></span>
                    </div>
                </div>
            ';
            if($orientacion!='inline' && $orientacion!=''){
            $html = '
                <div id="div'.$name.'" class="form-group form-md-line-input">
                    <input id="'.$name.'" name="'.$name.'" value="'.$value.'" type="text" class="form-control '.$clase.'" placeholder="'.$placeholder.'" '.$extra.' '.$read = ($readOnly) ? "readonly" : "".'>
                    <label for="'.$name.'">'.$leyenda.'</label>
                    <span class="help-block help-block-error">'.$error.'</span>
                    <span class="help-block"></span>
                </div>
                ';
            }

            if($orientacion=='horizontal' && $orientacion!=''){
            $html = '
                <div id="div'.$name.'" class="form-group form-md-line-input '.$classError.'">
                    <label class="col-md-4" for="'.$name.'">'.$leyenda.'</label>
                    <div class="col-md-8">
                        <input id="'.$name.'" name="'.$name.'" value="'.$value.'" type="text" class="form-control '.$clase.'" placeholder="'.$placeholder.'" '.$extra.'>
                        <div class="form-control-focus"> </div>
                        <span class="help-block help-block-error">'.$error.'</span>
                        <span class="help-block"></span>
                    </div>


                </div>
                ';
            }



            return $html;
        }
    }

if (! function_exists('formInputFile'))
    {
        function formInputFile($name,$leyenda = '',$placeholder='',$value=null,$error=null,$clase='', $extra='',$orientacion='inline'){
            $classError="";
            if($error!=null){
                $classError="has-error";
                //$error = 'SELECCIONAR UN ARCHIVO ' .strtoupper(strstr($leyenda, ':', true));
                $error = 'SELECCIONE UN ARCHIVO |.CSV|';
            }
            $html = '
                <div id="div'.$name.'" class="form-group form-md-line-input '.$classError.'">
                    <div class="col-md-12" style="margin-bottom:5px;">
                        <label class="control-label" for="'.$name.'">'.$leyenda.'</label>
                    </div>
                    <div class="col-md-12">
                        <input id="'.$name.'" name="'.$name.'" value="'.$value.'" type="file" class="form-control '.$clase.'" '.$extra.'>
                        <div class="form-control-focus"> </div>
                        <span class="help-block help-block-error">'.$error.'</span>
                        <span class="help-block"></span>
                    </div>
                </div>
            ';
            if($orientacion!='inline' && $orientacion!=''){
            $html = '
                <div id="div'.$name.'" class="form-group form-md-line-input">
                    <input id="'.$name.'" name="'.$name.'" value="'.$value.'" type="file" class="form-control '.$clase.'" placeholder="'.$placeholder.'" '.$extra.'>
                    <label for="'.$name.'">'.$leyenda.'</label>
                    <span class="help-block help-block-error">'.$error.'</span>
                    <span class="help-block"></span>
                </div>
                ';
            }

            if($orientacion=='horizontal' && $orientacion!=''){
            $html = '
                <div id="div'.$name.'" class="form-group form-md-line-input '.$classError.'">
                    <label class="col-md-4" for="'.$name.'">'.$leyenda.'</label>
                    <div class="col-md-8">
                        <input id="'.$name.'" name="'.$name.'" value="'.$value.'" type="file" class="form-control '.$clase.'" placeholder="'.$placeholder.'" '.$extra.'>
                        <div class="form-control-focus"> </div>
                        <span class="help-block help-block-error">'.$error.'</span>
                        <span class="help-block"></span>
                    </div>


                </div>
                ';
            }


            return $html;
        }
    }

if (! function_exists('formTextArea'))
    {
        function formTextArea($name,$leyenda= '',$placeholder='',$value=null,$error=null,$clase='', $extra='',$orientacion='inline'){
            $classError="";
            if($error!=null){
                $classError="has-error";
            }
            $html = '
            <div  id="div'.$name.'" class="form-group form-md-line-input '.$classError.'">
                <div class="col-md-12" style="margin-bottom:5px;">
                    <label class="control-label" for="'.$name.'">'.$leyenda.'</label>
                </div>
                <div class="col-md-12">
                    <textarea id="'.$name.'" name="'.$name.'" class="form-control '.$clase.'" placeholder="'.$placeholder.'" '.$extra.' rows="5">'.$value.'</textarea>
                    <div class="form-control-focus"> </div>
                    <span class="help-block help-block-error">'.$error.'</span>
                    <span class="help-block"></span>
                </div>
            </div>
            ';
            return $html;
        }
    }

if (! function_exists('formCheckedActivo'))
    {
        function formCheckedActivo($name,$value=1,$clase='',$leyenda = 'Estatus'){
            switch($value){
                case 1:
                    $checkedActivo ='checked="checked"';
                    $classActivo = 'class="checked"';
                    $checkedInactivo ='';
                    break;
                case 0:
                    $checkedActivo ='';
                    $classActivo = '';
                    $checkedInactivo ='checked="checked"';
                    break;
            }
            $html = '
            <div class="col-md-12">
                 <div class="form-group form-md-radios">
                    <label for="'.$name.'_radio">'.$leyenda.'</label>
                    <div class="md-radio-inline">
                        <div class="md-radio">
                            <input type="radio" name="'.$name.'" id="'.$name.'1" class="md-radiobtn" value="1" '.$checkedActivo.' >
                            <label for="'.$name.'1">
                                <span></span>
                                <span class="check"></span>
                                <span class="box"></span> Activo</label>
                        </div>
                        <div class="md-radio">
                            <input type="radio" name="'.$name.'" id="'.$name.'2" class="md-radiobtn" value="0" '.$checkedInactivo.' >
                            <label for="'.$name.'2">
                                <span></span>
                                <span class="check"></span>
                                <span class="box"></span>Inactivo</label>
                        </div>
                    </div>
                </div>
            </div>
            ';
            return $html;
        }
    }

if (! function_exists('createSelect'))
{
      function createSelect($name,$values,$leyenda='',$placeholder=true,$selected = NULL,$error = NULL,$clase='',$extra='',$seleccione=false){
        $classError="";
            if($error!=null){
                $classError="has-error";
            }
        $html = '
        <div id="div'.$name.'" class="form-group form-md-line-input '.$classError.'">
            <div class="col-md-12" style="margin-bottom:5px;">
                <label class="control-label" for="'.$name.'">'.$leyenda.'</label>
            </div>
            <div class="col-md-12">
                <select id="'.$name.'" name="'.$name.'" class="form-control '.$clase.'" '.$extra.'>';
        if($seleccione==true){
          if ($placeholder==''){
              $html .= '<option value="0" selected="selected">Seleccione</option>';
          } else {
              $html .= '<option value="0" selected="selected">'.$placeholder.'</option>';
          }
        }
        foreach($values as $k=>$v){
            if($k == $selected){
                $html .= '<option value="'.$k.'" selected="selected">'.$v.'</option>';
            } else {
                $html .= '<option value="'.$k.'">'.$v.'</option>';
            }
        }
        $html .='</select>
                    <div class="form-control-focus"> </div>
                    <span class="help-block help-block-error">'.$error.'</span>
                <span class="help-block"></span>
            </div>
        </div>
        ';
        return $html;
        }
}

if (! function_exists('createSelect2'))//value del option seleccione = '';
{
      function createSelect2($name,$values,$leyenda='',$placeholder='',$selected = NULL,$error = NULL,$clase='',$extra='',$other=''){
        $classError="";
            if($error!=null){
                $classError="has-error";
            }
        $html = '
        <div id="div'.$name.'" class="form-group form-md-line-input '.$classError.'">
            <div class="col-md-12 '.$other.'" style="margin-bottom:5px;">
                <label class="control-label" for="'.$name.'">'.$leyenda.'</label>
            </div>
            <div class="col-md-12 '.$other.'">
                <select id="'.$name.'" name="'.$name.'" class="form-control '.$clase.'" '.$extra.'>';
          if ($placeholder==''){
              $html .= '<option value="" selected="selected">Seleccione</option>';
          } else {
              $html .= '<option value="" selected="selected">'.$placeholder.'</option>';
          }
        foreach($values as $k=>$v){
            if($k == $selected){
                $html .= '<option value="'.$k.'" selected="selected">'.$v.'</option>';
            } else {
                $html .= '<option value="'.$k.'">'.$v.'</option>';
            }
        }
        $html .='</select>
                    <div class="form-control-focus"> </div>
                    <span class="help-block help-block-error">'.$error.'</span>
                <span class="help-block"></span>
            </div>
        </div>
        ';
        return $html;
        }
}


if (! function_exists('createSelectRColocacion'))
{
      function createSelectRColocacion($name,$values,$leyenda='',$placeholder='',$selected = NULL,$error = NULL,$clase='',$extra=''){
        $classError="";
            if($error!=null){
                $classError="has-error";
            }
        $html = '
        <div id="div'.$name.'" class="form-group form-md-line-input '.$classError.'">
            <div class="col-md-12" style="margin-bottom:5px;">
                <label class="control-label" for="'.$name.'">'.$leyenda.'</label>
            </div>
            <div class="col-md-12">
                <select id="'.$name.'" name="'.$name.'" class="form-control '.$clase.'" '.$extra.'>';
          if ($placeholder==''){
              $html .= '<option value="" selected="selected">Seleccione</option>';
          } else {
              $html .= '<option value="" selected="selected">'.$placeholder.'</option>';
          }
        foreach($values as $k=>$v){
            if($k == $selected){
                $html .= '<option value="'.$k.'" selected="selected">'.$v.'</option>';
            } else {
                $html .= '<option value="'.$k.'">'.$v.'</option>';
            }
        }
        $html .='</select>
                    <div class="form-control-focus"> </div>
                    <span class="help-block help-block-error">'.$error.'</span>
                <span class="help-block"></span>
            </div>
        </div>
        ';
        return $html;
        }
}

if (! function_exists('createSelectColor'))
{
      function createSelectColor($name,$values,$leyenda='',$placeholder='',$selected = NULL,$error = NULL,$clase=''){
        $classError="";
            if($error!=null){
                $classError="has-error";
            }
        $html = '
        <div id="div'.$name.'" class="form-group form-md-line-input '.$classError.'">
            <div class="col-md-12" style="margin-bottom:5px;">
                <label class="control-label" for="'.$name.'">'.$leyenda.'</label>
            </div>
            <div class="col-md-12">
                <select id="'.$name.'" name="'.$name.'" class="form-control '.$clase.'">';
          if ($placeholder==''){
              $html .= '<option value="" selected="selected">Seleccione</option>';
          } else {
              $html .= '<option value="" selected="selected">'.$placeholder.'</option>';
          }
        foreach($values as $k=>$v){
            if($k == $selected){
                $html .= '<option style="background:'.$k.'" value="'.$k.'" selected="selected">'.$v.'</option>';
            }else{
                $html .= '<option style="background:'.$k.'" value="'.$k.'">'.$v.'</option>';
            }
        }
        $html .='</select>
                    <div class="form-control-focus"> </div>
                    <span class="help-block help-block-error">'.$error.'</span>
                <span class="help-block"></span>
            </div>
        </div>
        ';
        return $html;
        }
}

if (! function_exists('createSelectResultBlackboard')) {
    function createSelectResultBlackboard($name,$values,$leyenda='',$placeholder='',$selected = NULL,$error = NULL,$clase='') {
        $classError="";
        if($error!=null){
            $classError="has-error";
        }

        $html = '
        <div id="div'.$name.'" class="form-group form-md-line-input '.$classError.'">';
        if ( $leyenda != '' ) {
            $html.= '<div class="col-md-12" style="margin-bottom:5px;">
                    <label class="control-label" for="'.$name.'">'.$leyenda.'</label>
            </div>';
        }

        $html.='<div class="col-md-12">
                    <select id="'.$name.'" name="'.$name.'" class="form-control '.$clase.'">';

        if ( $placeholder == '' ) {
            $html .= '<option value="" selected="selected">Seleccione</option>';
        }
        else {
            $html .= '<option value="" selected="selected">'.$placeholder.'</option>';
        }
        if ( !is_numeric($values) ) {
            foreach( $values->result() as $valor ) {
                // if( $valor->id == $selected ) {
                if( $valor->titulo == $selected ) {
                    $html .= '<option value="'.$valor->id.'" dta-email="'.$valor->email.'" selected="selected">'.$valor->titulo.'</option>';
                }
                else {
                    $html .= '<option value="'.$valor->id.'" dta-email="'.$valor->email.'">'.$valor->titulo.'</option>';
                }
            }
        }

        $html .= '<option value="other">Otro</option>';
        $html .='</select>
                    <div class="form-control-focus"> </div>
                    <span class="help-block help-block-error">'.$error.'</span>
                <span class="help-block"></span>
            </div>
        </div>
        ';
        return $html;
        }
}

if (! function_exists('createSelectResult'))
{
      function createSelectResult($name,$values,$leyenda='',$placeholder='',$selected = NULL,$error = NULL,$clase='',$extra=''){
        $classError="";
            if($error!=null){
                $classError="has-error";
            }
        $html = '
        <div id="div'.$name.'" class="form-group form-md-line-input '.$classError.'">';
        if ($leyenda!=''){

           $html.= '<div class="col-md-12" style="margin-bottom:5px;">
                    <label class="control-label" for="'.$name.'">'.$leyenda.'</label>
            </div>';
        }
            $html.='<div class="col-md-12">
                <select id="'.$name.'" name="'.$name.'" class="form-control '.$clase.'" '.$extra.'>';
          if ($placeholder==''){
              $html .= '<option value="0" selected="selected">Seleccione</option>';
          } else {
              $html .= '<option value="0" selected="selected">'.$placeholder.'</option>';
          }
          if (!is_numeric($values)) {
            foreach($values->result() as $valor){
                if($valor->id == $selected){
                    $html .= '<option value="'.$valor->id.'" selected="selected">'.$valor->titulo.'</option>';
                } else {
                    $html .= '<option value="'.$valor->id.'">'.$valor->titulo.'</option>';
                }
            }
          }

        $html .='</select>
                    <div class="form-control-focus"> </div>
                    <span class="help-block help-block-error">'.$error.'</span>
                <span class="help-block"></span>
            </div>
        </div>
        ';
        return $html;
        }
}

if (! function_exists('createSelectResult2'))
{
      function createSelectResult2($name,$values,$leyenda='',$placeholder='',$selected = NULL,$error = NULL,$clase='',$extra=''){
        $classError="";
            if($error!=null){
                $classError="has-error";
            }
        $html = '
        <div id="div'.$name.'" class="form-group form-md-line-input '.$classError.'">';
        if ($leyenda!=''){

           $html.= '<div class="col-md-12" style="margin-bottom:5px;">
                    <label class="control-label" for="'.$name.'">'.$leyenda.'</label>
            </div>';
        }
            $html.='<div class="col-md-12">
                <select id="'.$name.'" name="'.$name.'" class="form-control '.$clase.'" '.$extra.'>';
          if ($placeholder==''){
              $html .= '<option value="" selected="selected">Seleccione</option>';
          } else {
              $html .= '<option value="" selected="selected">'.$placeholder.'</option>';
          }
          if (!is_numeric($values)) {
            foreach($values->result() as $valor){
                if($valor->id == $selected){
                    $html .= '<option value="'.$valor->id.'" selected="selected">'.$valor->titulo.'</option>';
                } else {
                    $html .= '<option value="'.$valor->id.'">'.$valor->titulo.'</option>';
                }
            }
          }

        $html .='</select>
                    <div class="form-control-focus"> </div>
                    <span class="help-block help-block-error">'.$error.'</span>
                <span class="help-block"></span>
            </div>
        </div>
        ';
        return $html;
        }
}

if (! function_exists('createSelectResultGroup'))
{
    function createSelectResultGroup($name,$values,$leyenda='',$placeholder='',$selected = NULL,$error = NULL,$clase='',$extra=''){
        $classError="";
            if($error!=null){
                $classError="has-error";
            }
        $html = '
        <div id="div'.$name.'" class="form-group '.$classError. '">
            <div class="input-group">';
        if ($leyenda!=''){

           $html.= '<span class="input-group-addon">'.$leyenda.'</span>';
        }
            $html.='<select id="'.$name.'" name="'.$name.'" class="form-control '.$clase.'" '.$extra.'>';
          if ($placeholder==''){
              $html .= '<option value="" selected="selected">Seleccione</option>';
          } else {
              $html .= '<option value="" selected="selected">'.$placeholder.'</option>';
          }
          if (!is_numeric($values)) {
            foreach($values->result() as $valor){
                if($valor->id == $selected){
                    $html .= '<option value="'.$valor->id.'" selected="selected">'.$valor->titulo.'</option>';
                } else {
                    $html .= '<option value="'.$valor->id.'">'.$valor->titulo.'</option>';
                }
            }
          }

        $html .= '</select>
            </div>
            <div class="form-control-focus"> </div>
            <span class="help-block help-block-error">' . $error . '</span>
            <span class="help-block"></span>
        </div>
        ';
        return $html;
    }
}

if (!function_exists('formInputGroup')) {
    function formInputGroup($name, $leyenda = '', $placeholder = '', $value = null, $error = null, $clase = '', $extra = '', $orientacion = 'inline')
    {
        $classError = "";
        if ($error != null) {
            $classError = "has-error";
        }
        $html = '
                <div id="div' . $name . '" class="form-group ' . $classError . '">
                    <div class="form-group">
                        <div class="input-group">
                            <span class="input-group-addon">'. $leyenda .'</span>
                            <input id="' . $name . '" name="' . $name . '" value="' . $value . '" type="text" class="form-control ' . $clase . '" placeholder="' . $placeholder . '" ' . $extra . '>
                        </div>
                    </div>
                    <div class="form-control-focus"> </div>
                    <span class="help-block help-block-error">' . $error . '</span>
                    <span class="help-block"></span>
                </div>
            ';

        return $html;
    }
}

if ( !function_exists('fotoTable'))
{
    function fotoTable($foto,$thum,$ruta,$width=45)
    {
        $saccion ='
                    <a class="magnificPopup" href="'.$ruta.'/'.$foto.'">
                        <img width="'.$width.'" src="'.$ruta.'/'.$thum.'">
                    </a>';

        return $saccion;
    }
}


/**********************************************************************************************************************/
/*************************** Fin Helpers 06-10-2016  _(*-*_)  *********************************************************/
/**********************************************************************************************************************/
/* Old Helpers*/

if (! function_exists('formInputShort')) {
    function formInputShort($id,$name,$value=null,$clase='',$leyenda = ''){
        $html = '
        <div class="form-group">
            <div class="col-md-12">
                <label class="form-label col-md-4" for="'.$id.'">'.$leyenda.'</label>
                <div class="col-md-8">
                    <input class="form-control '.$clase.'" id="'.$id.'" type="text" name="'.$name.'" value="'.$value.'" />
                </div>
            </div>
        </div>
        ';
        return $html;
    }
}

if (! function_exists('datePicker'))
{
    function datePicker($id,$name,$value=null,$clase='',$leyenda = ''){
        $html = '
                <div class="form-group">
                    <div class="col-lg-12">
                        <label class="form-label col-lg-4" for="'.$id.'">'.$leyenda.'</label>
                        <div class="col-lg-8">
                            <input class="form-control datepicker '.$clase.'" id="'.$id.'" type="text" name="'.$name.'" value="'.$value.'" />
                        </div>
                    </div>
                </div>
                ';
        return $html;
    }
}

if (! function_exists('html2text'))
{
    function html2text($html){
        $text = $html;
        static $search = array(
            '@<script.+?</script>@usi',  // Strip out javascript content
            '@<style.+?</style>@usi',    // Strip style content
            '@<!--.+?-->@us',            // Strip multi-line comments including CDATA
            '@</?[a-z].*?\>@usi',         // Strip out HTML tags
        );
        $text = preg_replace($search, ' ', $text);
        // normalize common entities
        $text = normalizeEntities($text);
        // decode other entities
        $text = html_entity_decode($text, ENT_QUOTES, 'utf-8');
        // normalize possibly repeated newlines, tabs, spaces to spaces
        $text = preg_replace('/\s+/u', ' ', $text);
        $text = trim($text);
        // we must still run htmlentities on anything that comes out!
        // for instance:
        // <<a>script>alert('XSS')//<<a>/script>
        // will become
        // <script>alert('XSS')//</script>
        return $text;
    }
}

if (! function_exists('normalizeEntities'))
{
    function normalizeEntities($text) {
        static $find = array();
        static $repl = array();
        if (!count($find)) {
            // build $find and $replace from map one time
            $map = array(
                array('\'', 'apos', 39, 'x27'), // Apostrophe
                array('\'', '‘', 'lsquo', 8216, 'x2018'), // Open single quote
                array('\'', '’', 'rsquo', 8217, 'x2019'), // Close single quote
                array('"', '“', 'ldquo', 8220, 'x201C'), // Open double quotes
                array('"', '”', 'rdquo', 8221, 'x201D'), // Close double quotes
                array('\'', '‚', 'sbquo', 8218, 'x201A'), // Single low-9 quote
                array('"', '„', 'bdquo', 8222, 'x201E'), // Double low-9 quote
                array('\'', '′', 'prime', 8242, 'x2032'), // Prime/minutes/feet
                array('"', '″', 'Prime', 8243, 'x2033'), // Double prime/seconds/inches
                array(' ', 'nbsp', 160, 'xA0'), // Non-breaking space
                array('-', '‐', 8208, 'x2010'), // Hyphen
                array('-', '–', 'ndash', 8211, 150, 'x2013'), // En dash
                array('--', '—', 'mdash', 8212, 151, 'x2014'), // Em dash
                array(' ', ' ', 'ensp', 8194, 'x2002'), // En space
                array(' ', ' ', 'emsp', 8195, 'x2003'), // Em space
                array(' ', ' ', 'thinsp', 8201, 'x2009'), // Thin space
                array('*', '•', 'bull', 8226, 'x2022'), // Bullet
                array('*', '‣', 8227, 'x2023'), // Triangular bullet
                array('...', '…', 'hellip', 8230, 'x2026'), // Horizontal ellipsis
                array('°', 'deg', 176, 'xB0'), // Degree
                array('€', 'euro', 8364, 'x20AC'), // Euro
                array('¥', 'yen', 165, 'xA5'), // Yen
                array('£', 'pound', 163, 'xA3'), // British Pound
                array('©', 'copy', 169, 'xA9'), // Copyright Sign
                array('®', 'reg', 174, 'xAE'), // Registered Sign
                array('™', 'trade', 8482, 'x2122') // TM Sign
            );
            foreach ($map as $e) {
                for ($i = 1; $i < count($e); ++$i) {
                    $code = $e[$i];
                    if (is_int($code)) {
                        // numeric entity
                        $regex = "/&(amp;)?#0*$code;/";
                    }
                    elseif (preg_match('/^.$/u', $code)/* one unicode char*/) {
                        // single character
                        $regex = "/$code/u";
                    }
                    elseif (preg_match('/^x([0-9A-F]{2}){1,2}$/i', $code)) {
                        // hex entity
                        $regex = "/&(amp;)?#x0*" . substr($code, 1) . ";/i";
                    }
                    else {
                        // named entity
                        $regex = "/&(amp;)?$code;/";
                    }
                    $find[] = $regex;
                    $repl[] = $e[0];
                }
            }
        } // end first time build
        return preg_replace($find, $repl, $text);
    }
}

if ( !function_exists('string_fecha'))
{
    function string_fecha()
    {
        $today = getdate();
        $tomorrow = getdate(strtotime("+12 days"));
        return $fecha = $today['mday'].' de '.convertirmes($today['mon']).' de '.$today['year'];
    }
}


if (! function_exists('createChecks'))
{
	function createChecks($values,$key,$value,$checked =array(),$clase=""){
		$html ="";
		foreach($values->result() as $evento)
		{
			if(in_array($evento->$key,$checked))
			{

				$html.= '<input type="checkbox" name="evento[]" value="'.$evento->$key.'" checked="checked" class="'.$clase.'"/>'.$evento->$value.'<br />';
			}else{
				$html.= '<input type="checkbox" name="evento[]" value="'.$evento->$key.'" class="'.$clase.'"/>'.$evento->$value.'<br />';
			}
		}
	return $html;
	}
}

if (! function_exists('getThumb'))
{

	function getThumb($imagen)
	{
		$thumb='';
		if($imagen!=''){
			$nimagen = explode(".", $imagen);
			$imagenname = $nimagen[0];
			$imagenext = $nimagen[1];
			$imagenname = $imagenname.'_thumb';
			$thumb   	= $imagenname.'.'.$imagenext;
		}
		return $thumb;
	}
}

if (! function_exists('createRadios'))
{
    function createRadios($name,$values,$selected ="",$clase=""){
        $html = '';
        foreach($values as $k=>$v){
            if($v == $selected){
                $html .= '<input type="radio" name="'.$name.'" value="'.$v.'" checked="checked" />'.$v.'<br/>';
            }else{
                $html .= '<input type="radio" name="'.$name.'" value="'.$v.'"  />'.$v.'<br/>';
            }
        }
        return $html;
    }
}

if (! function_exists('createRadiosLabel'))
{
    function createRadiosLabel($name,$values,$selected = "",$clase=""){
        $html = '';
        $count = 0;
        foreach($values as $k=>$v){
            $count++;
            if($k == $selected){
                $html .= '<input type="radio" name="'.$name.'" value="'.$k.'" id="'.$name.'-'.$count.'" checked="checked" /> <label for="'.$name.'-'.$count.'">'.$v.'</label>';
            }else{
                $html .= '<input type="radio" name="'.$name.'" value="'.$k.'"  id="'.$name.'-'.$count.'" /><label for="'.$name.'-'.$count.'">'.$v.'</label>';
            }
        }
        return $html;
    }
}

if (! function_exists('convertirMes'))
{
	function convertirMes($mes){
		switch($mes){
				case 1:$mes='Enero';break;case 2:$mes='Febrero';break;case 3:$mes='Marzo';break;case 4:$mes='Abril';break;case 5:$mes='Mayo';break;case 6:$mes='Junio';break;case 7:$mes='Julio';break;case 8:$mes='Agosto';break;case 9:$mes='Septiembre';break;case 10:$mes='Octubre';break;case 11:$mes='Noviembre';break;case 12:$mes='Diciembre';break;
		}
		return $mes;
	}

}
if (! function_exists('convertMes'))
{
	function convertMes($fecha)
	{
		if($fecha!="")
		{
			$f_array = explode('-',$fecha);
			switch($f_array[1]){
				case '01':
					$f_return = $f_array[2].'-Ene-'.$f_array[0];
				break;
				case '02':
					$f_return = $f_array[2].'-Feb-'.$f_array[0];
				break;
				case '03':
					$f_return = $f_array[2].'-Mar-'.$f_array[0];
				break;
				case '04':
					$f_return = $f_array[2].'-Abr-'.$f_array[0];
				break;
				case '05':
					$f_return = $f_array[2].'-May-'.$f_array[0];
				break;
				case '06':
					$f_return = $f_array[2].'-Jun-'.$f_array[0];
				break;
				case '07':
					$f_return = $f_array[2].'-Jul-'.$f_array[0];
				break;
				case '08':
					$f_return = $f_array[2].'-Ago-'.$f_array[0];
				break;
				case '09':
					$f_return = $f_array[2].'-Sep-'.$f_array[0];
				break;
				case '10':
					$f_return = $f_array[2].'-Oct-'.$f_array[0];
				break;
				case '11':
					$f_return = $f_array[2].'-Nov-'.$f_array[0];
				break;
				case '12':
					$f_return = $f_array[2].'-Dic-'.$f_array[0];
				break;
			}
			return $f_return;
		}
	}
}
if (! function_exists('h_money_format'))
{
	function h_money_format($format, $number)
{
    $regex  = '/%((?:[\^!\-]|\+|\(|\=.)*)([0-9]+)?'.
              '(?:#([0-9]+))?(?:\.([0-9]+))?([in%])/';
    if (setlocale(LC_MONETARY, 0) == 'C') {
        setlocale(LC_MONETARY, '');
    }
    $locale = localeconv();
    preg_match_all($regex, $format, $matches, PREG_SET_ORDER);
    foreach ($matches as $fmatch) {
        $value = floatval($number);
        $flags = array(
            'fillchar'  => preg_match('/\=(.)/', $fmatch[1], $match) ?
                           $match[1] : ' ',
            'nogroup'   => preg_match('/\^/', $fmatch[1]) > 0,
            'usesignal' => preg_match('/\+|\(/', $fmatch[1], $match) ?
                           $match[0] : '+',
            'nosimbol'  => preg_match('/\!/', $fmatch[1]) > 0,
            'isleft'    => preg_match('/\-/', $fmatch[1]) > 0
        );
        $width      = trim($fmatch[2]) ? (int)$fmatch[2] : 0;
        $left       = trim($fmatch[3]) ? (int)$fmatch[3] : 0;
        $right      = trim($fmatch[4]) ? (int)$fmatch[4] : $locale['int_frac_digits'];
        $conversion = $fmatch[5];

        $positive = true;
        if ($value < 0) {
            $positive = false;
            $value  *= -1;
        }
        $letter = $positive ? 'p' : 'n';

        $prefix = $suffix = $cprefix = $csuffix = $signal = '';

        $signal = $positive ? $locale['positive_sign'] : $locale['negative_sign'];
        switch (true) {
            case $locale["{$letter}_sign_posn"] == 1 && $flags['usesignal'] == '+':
                $prefix = $signal;
                break;
            case $locale["{$letter}_sign_posn"] == 2 && $flags['usesignal'] == '+':
                $suffix = $signal;
                break;
            case $locale["{$letter}_sign_posn"] == 3 && $flags['usesignal'] == '+':
                $cprefix = $signal;
                break;
            case $locale["{$letter}_sign_posn"] == 4 && $flags['usesignal'] == '+':
                $csuffix = $signal;
                break;
            case $flags['usesignal'] == '(':
            case $locale["{$letter}_sign_posn"] == 0:
                $prefix = '(';
                $suffix = ')';
                break;
        }
        if (!$flags['nosimbol']) {
            $currency = $cprefix .
                        ($conversion == 'i' ? $locale['int_curr_symbol'] : $locale['currency_symbol']) .
                        $csuffix;
        } else {
            $currency = '';
        }
        $space  = $locale["{$letter}_sep_by_space"] ? ' ' : '';

        $value = number_format($value, $right, $locale['mon_decimal_point'],
                 $flags['nogroup'] ? '' : $locale['mon_thousands_sep']);
        $value = @explode($locale['mon_decimal_point'], $value);

        $n = strlen($prefix) + strlen($currency) + strlen($value[0]);
        if ($left > 0 && $left > $n) {
            $value[0] = str_repeat($flags['fillchar'], $left - $n) . $value[0];
        }
        $value = implode($locale['mon_decimal_point'], $value);
        if ($locale["{$letter}_cs_precedes"]) {
            $value = $prefix . $currency . $space . $value . $suffix;
        } else {
            $value = $prefix . $value . $space . $currency . $suffix;
        }
        if ($width > 0) {
            $value = str_pad($value, $width, $flags['fillchar'], $flags['isleft'] ?
                     STR_PAD_RIGHT : STR_PAD_LEFT);
        }

        $format = str_replace($fmatch[0], $value, $format);
    }
    return $format;
	}
}


if ( !function_exists('editar_foto'))
{
    function editar_foto($id,$ruta)
    {
        echo "
            <a href=\"$ruta/editar/$id\">
                <span class=\"icon-pencil\"></span>
                Editar
            </a>
            ";
    }
}

if ( !function_exists('titulo_seccion'))
{
    function titulo_seccion($name)
    {
        $name=  ucfirst ( $name);
        echo "<div class=\"title\">
                <h4>
                    <img src=\"images/section-icon.png\" width=\"20px\" >
                    <span>$name</span>
                </h4>
            </div>";
    }
}

if ( !function_exists('getSexo'))
{
    function getSexo($value = null){
        if ($value!= null){

            switch($value){

                case 0:
                    $seccion ='Masculino';

                    break;
                case 1:
                    $seccion ='Femenino';
                    break;

                default:
                    $seccion ='';
            }
        }else{
            $seccion = '';
        }
        return $seccion;
    }
}

if ( !function_exists('addhttp'))
{
    function addhttp($url) {
        if (!preg_match("~^(?:f|ht)tps?://~i", $url)) {
            $url = "http://" . $url;
        }
        return $url;
    }
}

if (! function_exists('getMes'))
{
    function getMes($fecha)
    {
        if($fecha!="")
        {
            $mes = '';
            switch($fecha){
                case 1:
                    $mes = 'Enero';
                break;
                case 2:
                    $mes = 'Febrero';
                break;
                case 3:
                    $mes = 'Marzo';
                break;
                case 4:
                    $mes = 'Abril';
                break;
                case 5:
                    $mes = 'Mayo';
                break;
                case 6:
                    $mes = 'Junio';
                break;
                case 7:
                    $mes = 'Julio';
                break;
                case 8:
                    $mes = 'Agosto';
                break;
                case 9:
                    $mes = 'Septiembre';
                break;
                case 10:
                    $mes = 'Octubre';
                break;
                case 11:
                    $mes = 'Noviembre';
                break;
                case 12:
                    $mes = 'Diciembre';
                break;
            }
            return $mes;
        }
    }
}

if (! function_exists('getRol'))
{
    function getRol($rol)
    {
        $ci=& get_instance();
        $query=$ci->db->query("SELECT nombre FROM roles WHERE status=1 AND id=$rol");
        return ($query->num_rows() > 0) ? $query->row()->nombre : false;
    }
}
/*Calificación del Asesor*/
if (! function_exists('respEnc'))
{
    function respEnc($respuesta)
    {
        $tituloResp = '';
        if($respuesta > 0)
        {
            switch($respuesta){
                case 1:
                    $tituloResp = 'Pésimo';
                    break;

                case 2:
                    $tituloResp = 'Malo';
                    break;

                case 3:
                    $tituloResp = 'Regular';
                    break;

                case 4:
                    $tituloResp = 'Bueno';
                    break;
                case 5:
                    $tituloResp = 'Excelente';
                    break;



                default:
                   $tituloResp = '';
                break;
            }
        }
            return $tituloResp;
    }
}

if (! function_exists('respEnc2'))
{
    function respEnc2($respuesta2)
    {
        $tituloResp2 = '';
        if($respuesta2 > 0)
        {
            switch($respuesta2){
                    case 1:
                    $tituloResp2 = 'Volante';
                    break;

                case 2:
                    $tituloResp2 = 'Radio';
                    break;

                case 3:
                    $tituloResp2 = 'Televisión';
                    break;

                case 4:
                    $tituloResp2 = 'De Paso';
                    break;
                case 5:
                    $tituloResp2 = 'Redes Sociales';
                    break;
                case 6:
                    $tituloResp2 = 'Recomendación';
                    break;
                case 7:
                    $tituloResp2 = 'Medios';
                    break;
                case 8:
                    $tituloResp2 = 'Otros';
                    break;

                default:
                   $tituloResp2 = '';
                break;
            }
        }
            return $tituloResp2;
    }
}
if (! function_exists('respEnc3'))
{
    function    respEnc3($respuesta3)
    {
        $tituloResp3 = '';
        if($respuesta3 > 0)
        {
            switch($respuesta3){
                    case 1:
                    $tituloResp3 = 'Sí';
                    break;

                case 2:
                    $tituloResp3 = 'No';
                    break;
                default:
                   $tituloResp3 = '';
                break;
            }
        }
            return $tituloResp3;
    }
}

if (!function_exists('get_fecha'))
{
    function get_fecha($fecha)
    {
        $long = strlen($fecha);
         if ($long > 4){ $fecha = str_replace('/','-',$fecha);
             $time = date("l j \of F \of Y", strtotime("$fecha"));
             $time = str_replace('of','de',$time);
             $search = array('January','February','March','April','May','June','July','August', 'September', 'October', 'November', 'December');
             $replace = array('Enero','Febrero','Marzo','Abril','Mayo','Junio','Julio','Agosto', 'Septiembre', 'Octubre', 'Noviembre', 'Diciembre');
             $search2 = array('Monday','Tuesday','Wednesday','Thursday','Friday','Saturday','Sunday');
             //$replace2 = array('Lunes','Martes','Miércoles','Jueves','Viernes','Sábado','Domingo');
             $replace2 = array('','','','','','','');
             $time = str_replace($search, $replace, $time);
             $time = str_replace($search2, $replace2, $time);

             return $time;

         }else{
            return $fecha;
         }
     }
 }


if (!function_exists('estatus_proyecto'))
{
    function estatus_proyecto($estatus)
    {
        switch ($estatus) {
            case 0:
                $valor = 'Borrado';
                break;
            case 1:
                $valor = 'Cotizado';
                break;
            case 2:
                $valor = 'Confirmado';
                break;
            case 3:
                $valor = 'En Producción';
                break;
            case 4:
                $valor = 'Finalizado';
                break;
            case 5:
                $valor = 'Cancelado';
                break;

            default:
                $valor = '';
                break;
        }
        return $valor;
     }
 }

//convertir a numerico
if (! function_exists('toInt')) //cnvertir de moneda a entero
{
    function toInt($str)
    {
        return preg_replace("/([^-0-9\\.])/i", "", $str);
    }
}

//validar si es numérico
if (! function_exists('validateInt'))
{
    function validateInt($str)
    {
        $value = preg_replace("/([^-0-9\\.])/i", "", $str);
        if (is_numeric($value)){
            return true;
        }
        return false;
    }
}
//validar si es alfanumerico
if (! function_exists('alpha_dash_space'))
{
    function alpha_dash_space($str)
    {
        if (preg_match('#[0-9]#', $str) && preg_match('#[a-zA-Z]#', $str)) {
            return TRUE;
        }
            return FALSE;
    }
}
if (! function_exists('addDaysToDate')) //cnvertir de moneda a entero
{
    function addDaysToDate($date, $numDays)
    {
        //return preg_replace("/([^-0-9\\.])/i", "", $str);
        $endDate = date('d/m/Y', strtotime("+".$numDays." day", strtotime($date))); //date(strtotime($startdate) . "+".$numDays." day");

        return $endDate;
    }
}

if ( !function_exists('tiempoTranscurridoFechas') )
{
    function tiempoTranscurridoFechas($fechaInicio,$fechaFin)
    {
        $fecha1 = new DateTime($fechaInicio);
        $fecha2 = new DateTime($fechaFin);
        $fecha = $fecha1->diff($fecha2);
        $tiempo = "";
        /*
        //años
        if($fecha->y > 0)
        {
            $tiempo .= $fecha->y;

            if($fecha->y == 1)
                $tiempo .= " año, ";
            else
                $tiempo .= " años, ";
        }*/

        //meses
        if($fecha->m > 0)
        {
            $tiempo .= $fecha->m;

            if($fecha->m == 1)
                $tiempo .= " mes ";
            else
                $tiempo .= " meses ";
        }

        //dias
        if($fecha->d > 0)
        {
            $tiempo .= $fecha->d;

            if($fecha->d == 1)
                $tiempo .= " día ";
            else
                $tiempo .= " días ";
        }

        //horas
        if($fecha->h > 0)
        {
            if($fecha->h < 10)
                $tiempo .= "0".$fecha->h.":";
            else
                $tiempo .= $fecha->h.":";
        }

        //minutos
        if($fecha->i > 0)
        {
            if($fecha->i < 10)
                $tiempo .= "0".$fecha->i.":";
            else
                $tiempo .= $fecha->i.":";
        }

        //minutos
        if($fecha->s > 0)
        {
            if($fecha->s < 10)
                $tiempo .= "0".$fecha->s;
            else
                $tiempo .= $fecha->s;
        }

        if ( $fechaInicio == $fechaFin ) {
            $tiempo = 'Finalizar hoy';
        }

        if ( $fechaInicio > $fechaFin ) {
            $tiempo = 'Vencido';
        }

        return $tiempo;
    }
}


if ( !function_exists('estatus_proyecto_reporte') )
{
    function estatus_proyecto_reporte($estatus) {
        switch ($estatus) {
            case 0:
                $valor = 'Disponible';
                break;
            case 1:
                $valor = 'Apartado';
                break;
            case 2:
                $valor = 'Proceso';
                break;
            case 3:
                $valor = 'Vendido';
                break;
            case 4:
                $valor = 'Inscrito';
                break;
            case 5:
                $valor = 'Firmado';
                break;
            default:
                $valor = '';
                break;
        }
        return $valor;
    }
}

if ( !function_exists('name_file_valid_sale') )
{
    function name_file_valid_sale($file) {
        if($file->statusPdf_1 == 1 || $file->pdf_1 != ''){
            $valor = '
                <label style="width: 100%;text-align: center;"><i class="fa fa-check" style="font-size: 20px;"></i>OK</label>
            ';
        }else{
            $valor = '
                <label style="width: 100%;text-align: center;"><i class="fa fa-close" style="font-size: 20px;"></i>NO</label>
            ';
        /*$valor = '
        <ul style="list-style-type: none;padding: 0px;font-size: 10.5px;width: 120px;">
            <li>Acta '.($file->statusPdf_1 == 1 ? '<i class="fa fa-check"></i>' : '<i class="fa fa-close"></i>').'</li>
            <li>INE '.($file->statusPdf_1 == 1 ? '<i class="fa fa-check"></i>' : '<i class="fa fa-close"></i>').'</li>
            <li>CURP '.($file->statusPdf_1 == 1 ? '<i class="fa fa-check"></i>' : '<i class="fa fa-close"></i>').'</li>
            <li>Bansefi'.($file->statusPdf_1 == 1 ? '<i class="fa fa-check"></i>' : '<i class="fa fa-close"></i>').'</li>
            <li>Precalificación'.($file->statusPdf_1 == 1 ? '<i class="fa fa-check"></i>' : '<i class="fa fa-close"></i>').'</li>
            <li>Curso'.($file->statusPdf_1 == 1 ? '<i class="fa fa-check"></i>' : '<i class="fa fa-close"></i>').'</li>
            <li>Solicitud '.($file->statusPdf_1 == 1 ? '<i class="fa fa-check"></i>' : '<i class="fa fa-close"></i>').'</li>
            <li>C. Domicilio '.($file->statusPdf_1 == 1 ? '<i class="fa fa-check"></i>' : '<i class="fa fa-close"></i>').'</li>
        </ul>';*/
        }


        return $valor;
    }
}

if (! function_exists('formCheckRadios2')){
    function formCheckRadios2($nomGrupo, $leyenda = null, $arrConfig = null, $value = null, $error = null){
        $classError="";
        if($error!=null){
            $classError="has-error";
        }
        $checked1 = '';
        $checked2 = '';
        if ( !is_null($value) ) {
            $checked1 = ($value == 'LOTE' ? 'checked="checked"' : '');
            $checked2 = ($value != 'LOTE' && is_numeric($value) ? 'checked="checked"' : '');
        }

        $strEstructura = null;
        if(!is_null($arrConfig)){
            $strEstructura = '<div class="form-group form-group form-md-radios '.$classError.'"><br>';
            if(!is_null($leyenda)){
                $strEstructura .= '<div class="col-md-12">
                                        <label class="form-label" for="checkboxes">'.$leyenda.'</label>
                                    </div><br>';
            }
            $strEstructura .= '<div class="md-radio-inline col-md-12">
                                    <div class="md-radio">
                                        <input type="radio" name="'.$nomGrupo.'" id="'.$nomGrupo.$arrConfig[0]["id"].'" class="md-radiobtn" value="'.$arrConfig[0]["value"].'" '.$checked1.'/>
                                        <label for="'.$nomGrupo.$arrConfig[0]["id"].'" class="ev_lote" data-input="'.$nomGrupo.'">
                                            <span></span>
                                            <span class="check"></span>
                                            <span class="box"></span> '.$arrConfig[0]["texto"].'
                                        </label>
                                    </div>
                                    <div class="md-radio">
                                        <input type="radio" name="'.$nomGrupo.'" id="'.$nomGrupo.$arrConfig[1]["id"].'" class="md-radiobtn" value="'.$arrConfig[1]["value"].'" '.$checked2.'/>
                                        <label for="'.$nomGrupo.$arrConfig[1]["id"].'" class="ev_cant" data-input="'.$nomGrupo.'">
                                            <span></span>
                                            <span class="check"></span>
                                            <span class="box"></span> '.$arrConfig[1]["texto"].'
                                        </label>
                                        <input id="v_'.$nomGrupo.'" name="v_'.$nomGrupo.'" type="text" value="'.$value.'" style="width: 50px;background:0 0;border:0;border-bottom:1px solid #c2cad8;-webkit-border-radius:0;-moz-border-radius:0;-ms-border-radius:0;-o-border-radius:0;border-radius:0;color:#555;box-shadow:none;padding-left:0;padding-right:0;font-size:14px;text-align: center;'.($checked1 != '' || $value == null ? 'display: none;' : '').'">
                                    </div>
                                </div>
                                <div class="form-control-focus"> </div>
                                <span class="help-block help-block-error">'.$error.'</span>
                                <span class="help-block"></span>
                            </div>
            ';

            // foreach ($arrConfig as $key => $optConfig) {
            //     $valCkecked = (isset($optConfig["checked"]) && $optConfig["checked"] == true) ? 'checked="checked"': '';
                // $strEstructura .= '<div class="md-radio">
                //                         <input type="radio" name="'.$nomGrupo.'" id="'.$optConfig["id"].'" class="md-radiobtn" value="'.$optConfig["value"].'" '.$valCkecked.' />
                //                         <label for="'.$optConfig["id"].'">
                //                             <span></span>
                //                             <span class="check"></span>
                //                             <span class="box"></span> '.$optConfig["texto"].'
                //                         </label>
                //                     </div>';
            // }
            // $strEstructura .= '<input id="input_'.$nomGrupo.'" name="input_'.$nomGrupo.'" type="text" class="form-control removeDisabled" placeholder="placeholder">';
            // $strEstructura .= '</div></div>';
        }
        return $strEstructura;
    }
}

if (! function_exists('formCheckbox2')){
    function formCheckbox2($nomGrupo, $leyenda = null, $arrConfig = null, $value = null, $error = null){
        $classError="";
        if($error!=null){
            $classError="has-error";
        }
        $checked = '';
        if ( !is_null($value) && $value != '' ) {
            $checked = ($value != '' ? 'checked="checked"' : '');
        }

        $strEstructura = null;
        if(!is_null($arrConfig)){
            $strEstructura = '<div class="form-group form-group form-md-radios '.$classError.'"><br>';
            if(!is_null($leyenda)){
                $strEstructura .= '<div class="col-md-12">
                                        <label class="form-label" for="checkboxes">'.$leyenda.'</label>
                                    </div><br>';
            }
            $strEstructura .= '<div class="md-checkbox-inline col-md-12">
                                    <div class="md-checkbox">
                                        <input type="checkbox" name="'.$nomGrupo.'" id="'.$nomGrupo.'" class="md-radiobtn ec_cant" value="'.$arrConfig[0]["value"].'" '.$checked.'/>
                                        <label for="'.$nomGrupo.'" class="" data-input="'.$nomGrupo.'">
                                            <span></span>
                                            <span class="check"></span>
                                            <span class="box"></span> '.$arrConfig[0]["texto"].'
                                        </label>
                                        <input id="v_'.$nomGrupo.'" name="v_'.$nomGrupo.'" type="number" value="'.$value.'" style="width: 50px;background:0 0;border:0;border-bottom:1px solid #c2cad8;-webkit-border-radius:0;-moz-border-radius:0;-ms-border-radius:0;-o-border-radius:0;border-radius:0;color:#555;box-shadow:none;padding-left:0;padding-right:0;font-size:14px;text-align: center;'.($checked == '' || $value == null ? 'display: none;' : '').'">
                                    </div>
                                </div>
                                <div class="form-control-focus"> </div>
                                <span class="help-block help-block-error">'.$error.'</span>
                                <span class="help-block"></span>
                            </div>
            ';
        }
        return $strEstructura;
    }
}


if (! function_exists('formInput2'))
    {
        function formInput2($name,$leyenda = '',$placeholder='',$checked=null,$value=null,$error=null,$clase='', $extra='',$descripcion=''){
            $classError="";
            if($error!=null){
                $classError="has-error";
            }
            $html = '
                <div id="div'.$name.'" class="form-group form-md-line-input '.$classError.'">
                    <div class="col-md-12" style="margin-bottom:5px;">
                        <!-- <label class="control-label" for="'.$name.'">'.$leyenda.'</label> -->
                        <div class="md-checkbox">
                            <input type="checkbox" name="cb_'.$name.'" id="cb_'.$name.'" class="md-radiobtn cl_incidencia" value="'.($checked==1?1:0).'" '.($checked==1?'checked="checked"':'').'>
                            <label for="cb_'.$name.'" class="" data-input="'.$name.'">
                                <span class="inc"></span>
                                <span class="check"></span>
                                <span class="box"></span> '.$leyenda.'
                            </label>
                        </div>
                    </div>
                    <div class="col-md-12">
                        <input id="desc_'.$name.'" name="desc_'.$name.'" value="'.$descripcion.'" type="text" class="form-control '.$clase.'" placeholder="Descripción">
                        <div class="form-control-focus"> </div>
                        <span class="help-block help-block-error">'.$error.'</span>
                        <span class="help-block"></span>
                    </div>
                    <div class="col-md-12">
                        <input id="'.$name.'" name="'.$name.'" value="'.$value.'" type="text" class="form-control '.$clase.'" placeholder="'.$placeholder.'" '.$extra.'>
                        <div class="form-control-focus"> </div>
                        <span class="help-block help-block-error">'.$error.'</span>
                        <span class="help-block"></span>
                    </div>
                </div>
            ';

            return $html;
        }
    }

if (! function_exists('getMotivo'))
{
    function getMotivo($idMotivo) {
        switch ($idMotivo) {
            case '0':
                $valor = '';
                break;
            case '1':
                $valor = 'Bajo monto';
                break;
            case '2':
                $valor = 'Cliente c/diferencia';
                break;
            case '3':
                $valor = 'Sin Afore';
                break;
            case '4':
                $valor = 'Sin aportaciones patronales';
                break;
            case '5':
                $valor = 'Compra a terceros';
                break;
            case '6':
                $valor = 'Error de fortalecimiento';
                break;
            case '7':
                $valor = 'Proceso tardado';
                break;
            case '8':
                $valor = 'Sin relación laboral';
                break;
            case '9':
                $valor = 'Cliente ya no quiere la vivienda';
                break;
            case '10':
                $valor = 'Cambio de ciudad';
                break;
            case '11':
                $valor = 'No quiso pagar el ahorro voluntario';
                break;
            case '12':
                $valor = 'Error en subsidio';
                break;
            default:
                $valor = '';
                break;
        }
        return $valor;
    }
}

if ( !function_exists('tipoConstructor'))
{
    function tipoConstructor($idTipoConstructor = null){
        if ($idTipoConstructor == 1){
            $tc ='Contratista';
        }else{
            $tc = 'Destajista';
        }
        return  $tc;
    }
}

if ( !function_exists('contarLotes'))
{
    function contarLotes($campoLotes = null){
        $lotes = explode(",", $campoLotes);
        $porPaquete = 0;
        foreach ($lotes as $lt) {
            if(strripos($lt, '-')){
                $resta = explode('-', $lt);
                $porPaquete = $porPaquete + ($resta[1] - $resta[0]) + 1;
            }
            else{
                $porPaquete = (!empty($lt))? $porPaquete + 1 : $porPaquete;
            }
        }
        return $porPaquete;
    }
}

if ( !function_exists('accionesPresupuestoMO')){
    function accionesPresupuestoMO($id,$ruta,$ver = false,$editar = true,$borrar=true,$detallepmo=false,$resumenpmo=false, $exportarE=false, $exportar=false, $programaObra=false)
    {
        $saccion ='
                    <div class="actions">
                        <div class="btn-group">
                            <a class="btn btn-sm green dropdown-toggle" href="javascript:;" data-toggle="dropdown"> Acciones
                                <i class="fa fa-angle-down"></i>
                            </a>
                            <ul class="dropdown-menu pull-right">

                           ';
        if ($editar) {
            $saccion .=  '<li><a href="'.$ruta.'/editar/'.$id.'"><i class="fa fa-pencil"></i>Editar</a></li>';
        }
        if ($borrar) {
            $saccion .='<li><a href="javascript:void(0);" onclick="modalEliminar('.$id.','."'".$ruta."'".');"><i class="fa fa-trash-o"></i>Borrar</a></li>';
        }
        if ($ver) {
            $saccion .= '<li class="divider"> </li>
            <li><a href="'.$ruta.'/ver/'.$id.'"><i class="fa fa-eye" aria-hidden="true"></i>Ver</a></li>';
        }
        if ($detallepmo) {
            $saccion .= '<li class="divider"> </li>
            <li><a href="'.$ruta.'/detallepmo/'.$id.'"><i class="fa fa-list" aria-hidden="true"></i>Detalle PMO</a></li>';
        }
        if ($resumenpmo) {
            $saccion .= '<li class="divider"> </li>
            <li><a href="'.$ruta.'/resumenpmo/'.$id.'"><i class="fa fa-check" aria-hidden="true"></i>Resumen PMO</a></li>';
        }
        if ( $exportarE ) {
            $saccion .= '<li class="divider"> </li> <li><a class="blockui-save" href="'.$ruta.'/exportarExample/'.$id.'"><i class="fa fa-download" aria-hidden="true"></i>Exportar Ejemplo</a></li>';
        }
        if ($exportar) {
            $saccion .= '<li class="divider"> </li> <li><a class="blockui-save" href="' . $ruta . '/exportarPpto/' . $id . '"><i class="fa fa-download" aria-hidden="true"></i>Exportar Ppto</a></li>';
        }
        if ($programaObra) {
            $saccion .= '<li class="divider"> </li> <li><a class="blockui-save" href="' . $ruta . '/programaObra/' . $id . '"><i class="fa fa-pencil-square-o" aria-hidden="true"></i>Prog. Obra</a></li>';
        }
        $saccion .= "
                            </ul>
                        </div>
                    </div>";
        return $saccion;
    }
}

if (!function_exists('accionesPresupuestoMat')) {
    function accionesPresupuestoMat($id, $ruta, $ver = false, $editar = true, $borrar = true, $detallepmo = false, $resumenpmo = false, $exportar = false)
    {
        $saccion = '
                    <div class="actions">
                        <div class="btn-group">
                            <a class="btn btn-sm green dropdown-toggle" href="javascript:;" data-toggle="dropdown"> Acciones
                                <i class="fa fa-angle-down"></i>
                            </a>
                            <ul class="dropdown-menu pull-right">

                           ';
        if ($editar) {
            $saccion .=  '<li><a href="' . $ruta . '/editar/' . $id . '"><i class="fa fa-pencil"></i>Editar</a></li>';
        }
        if ($borrar) {
            $saccion .= '<li><a href="javascript:void(0);" onclick="modalEliminar(' . $id . ',' . "'" . $ruta . "'" . ');"><i class="fa fa-trash-o"></i>Borrar</a></li>';
        }
        if ($ver) {
            $saccion .= '<li class="divider"> </li>
            <li><a href="' . $ruta . '/ver/' . $id . '"><i class="fa fa-eye" aria-hidden="true"></i>Ver</a></li>';
        }
        if ($detallepmo) {
            $saccion .= '<li class="divider"> </li>
            <li><a href="' . $ruta . '/detallepmat/' . $id . '"><i class="fa fa-list" aria-hidden="true"></i>Detalle PMAT</a></li>';
        }
        if ($resumenpmo) {
            $saccion .= '<li class="divider"> </li>
            <li><a href="' . $ruta . '/resumenpmat/' . $id . '"><i class="fa fa-check" aria-hidden="true"></i>Resumen PMAT</a></li>';
        }
        if ( $exportar ) {
            $saccion .= '<li class="divider"> </li> <li><a class="blockui-save" href="'.$ruta.'/exportarPpto/'.$id.'"><i class="fa fa-download" aria-hidden="true"></i>Exportar Ppto</a></li>';
        }
        $saccion .= "
                            </ul>
                        </div>
                    </div>";
        return $saccion;
    }
}



if (!function_exists('accionesProveedores')) {
    function accionesProveedores($id, $ruta, $ver = false, $editar = true, $borrar = true, $detallepmo = false, $resumenpmo = false, $exportar = false)
    {
        $saccion = '
                    <div class="actions">
                        <div class="btn-group">
                            <a class="btn btn-sm green dropdown-toggle" href="javascript:;" data-toggle="dropdown"> Acciones
                                <i class="fa fa-angle-down"></i>
                            </a>
                            <ul class="dropdown-menu pull-right">

                           ';
        if ($editar) {
            $saccion .=  '<li><a href="' . $ruta . '/editar/' . $id . '"><i class="fa fa-pencil"></i>Editar</a></li>';
        }
        if ($borrar) {
            $saccion .= '<li><a href="javascript:void(0);" onclick="modalEliminar(' . $id . ',' . "'" . $ruta . "'" . ');"><i class="fa fa-trash-o"></i>Borrar</a></li>';
        }
        if ($ver) {
            $saccion .= '<li class="divider"> </li>
            <li><a href="' . $ruta . '/ver/' . $id . '"><i class="fa fa-eye" aria-hidden="true"></i>Ver</a></li>';
        }
        if ($detallepmo) {
            $saccion .= '<li class="divider"> </li>
            <li><a href="' . $ruta . '/detallepmat/' . $id . '"><i class="fa fa-list" aria-hidden="true"></i>Detalle PMAT</a></li>';
        }
        if ($resumenpmo) {
            $saccion .= '<li class="divider"> </li>
            <li><a href="' . $ruta . '/resumenpmat/' . $id . '"><i class="fa fa-check" aria-hidden="true"></i>Resumen PMAT</a></li>';
        }
        if ( $exportar ) {
            $saccion .= '<li class="divider"> </li> <li><a class="blockui-save" href="'.$ruta.'/exportarPpto/'.$id.'"><i class="fa fa-download" aria-hidden="true"></i>Exportar PROV</a></li>';
        }
        $saccion .= "
                            </ul>
                        </div>
                    </div>";
        return $saccion;
    }
}

if ( !function_exists('accionesEstimaciones')) {
    function accionesEstimaciones($data,$ruta,$ver = false,$editar = true,$borrar=true, $detalle=true,$resumen=true, $verOP=false, $exportarPE = false) {
        $saccion ='
        <div class="actions">
            <div class="btn-group">
                <a class="btn btn-sm green dropdown-toggle" href="javascript:;" data-toggle="dropdown">
                    Acciones
                    <i class="fa fa-angle-down"></i>
                </a>
                <ul class="dropdown-menu pull-right">';
        if ( $editar ) {
            $saccion .=  '<li><a href="'.$ruta.'/editar/'.$data['id'].'"><i class="fa fa-pencil"></i>Editar</a></li>';
        }

        if ( $ver ) {
            $saccion .= '<li class="divider"> </li> <li><a class="blockui-save" href="'.$ruta.'/ver/'.$data['id'].'"><i class="fa fa-eye" aria-hidden="true"></i>Ver</a></li>';
        }
        if ( $detalle ) {
            $saccion .= '<li class="divider"> </li> <li><a class="blockui-save" target="_blank" href="'.$ruta.'/detalleEstDia/'.$data['id'].'/'.$data['id_prototipo'].'"><i class="fa fa-eye" aria-hidden="true"></i>Detalle</a></li>';
        }
        if ( $resumen ) {
            $saccion .= '<li class="divider"> </li> <li><a class="blockui-save" target="_blank" href="'.$ruta.'/detalle/'.$data['id'].'"><i class="fa fa-eye" aria-hidden="true"></i>Detalle</a></li>';
        }
        if ( $verOP ) {
            $saccion .='<li><a href="javascript:void(0);" onclick="verOrdenesPago('.$data['id'].');"><i class="fa fa-money"></i>Estimaciones</a></li>';
        }
        if ($exportarPE) {
            $saccion .= '<li class="divider"> </li> <li><a class="blockui-save" href="' . $ruta . '/exportarPE/' . $data['id'] . '"><i class="fa fa-download" aria-hidden="true"></i>Exp. Pagos Est.</a></li>';
        }
        if ( $borrar ) {
            $saccion .='<li><a href="javascript:void(0);" onclick="modalEliminar('.$data['id'].','."'".$ruta."'".');"><i class="fa fa-trash-o"></i>Borrar</a></li>';
        }
        $saccion .= "
                </ul>
            </div>
        </div>";
        return $saccion;
    }
}

if ( !function_exists('accionesArranque')) {
    function accionesArranque($id,$ruta,$ver = false,$editar = true,$borrar=true, $formatos=false, $encurso=false, $finalizado=false) {
        $saccion = '
        <div class="actions">
            <div class="btn-group">
                <a class="btn btn-sm green dropdown-toggle" href="javascript:;" data-toggle="dropdown">
                    Acciones
                    <i class="fa fa-angle-down"></i>
                </a>
                <ul class="dropdown-menu pull-right" style="min-width: 200px;">';
        if ( $editar ) {
            $saccion .=  '<li><a href="'.$ruta.'/editar/'.$id.'" target="_blank"><i class="fa fa-pencil"></i>Editar</a></li>';
        }
        if ( $borrar ) {
            $saccion .='<li><a href="javascript:void(0);" onclick="modalEliminar('.$id.','."'".$ruta."'".');"><i class="fa fa-trash-o"></i>Borrar</a></li>';
        }
        if ( $ver ) {
            $saccion .= '<li class="divider"> </li> <li><a class="blockui-save" href="'.$ruta.'/ver/'.$id.'"><i class="fa fa-eye" aria-hidden="true"></i>Ver</a></li>';
        }
    /*    if ( $ordenP ) {
            $saccion .='<li><a href="javascript:void(0);" onclick="modalOrdenPago('.$id.');"><i class="fa fa-dollar"></i>Orden de pago</a></li>';
        }
        if ( $verOP ) {
            $saccion .='<li><a href="javascript:void(0);" onclick="verOrdenesPago('.$id.');"><i class="fa fa-money"></i>Ver órdenes P.</a></li>';
        }
        if ( $descargaFile ) {
            $saccion .=  '<li><a class="blockui-save" href="formatospdf/aceptacion/'.$id.'"><i class="fa fa-file-pdf-o"></i>Generar Carta</a></li>';
        }
        if ($exportar) {
            $saccion .= '<li class="divider"> </li> <li><a class="blockui-save" href="' . $ruta . '/exportar/' . $id . '"><i class="fa fa-download" aria-hidden="true"></i>Exportar Ppto Paq.</a></li>';
        }
        if ($exportarPrograma) {
            $saccion .= '<li class="divider"> </li> <li><a class="blockui-save" href="' . $ruta . '/exportarPrograma/' . $id . '"><i class="fa fa-download" aria-hidden="true"></i>Exportar Prog Obra</a></li>';
        }*/
        if ( $formatos ) {
            $saccion .=  '<li><a class="blockui-save" href="arranque/formatos/'.$id.'"><i class="fa fa-file-pdf-o"></i>Formatos</a></li>';
        }
        if ( $encurso ) {
            $saccion .=  '<li><a href="javascript:void(0);" onclick="cambioEstatus('.$id.', 2);"><i class="fa fa-exchange"></i>En Curso</a></li>';
        }
        if ( $finalizado ) {
            $saccion .=  '<li><a href="javascript:void(0);" onclick="cambioEstatus('.$id.', 3);"><i class="fa fa-exchange"></i>Finalizado</a></li>';
        }
        $saccion .= "
                </ul>
            </div>
        </div>";
        return $saccion;
    }
}


if ( !function_exists('accionesPaquetes')) {
    function accionesPaquetes($id,$ruta,$ver = false,$editar = true,$borrar=true, $ordenP=false,$verOP=false,$descargaFile=false, $exportar = false, $exportarPrograma = false, $formatos=false, $programaObra=false,$ajustes=false) {
        $saccion = '
        <div class="actions">
            <div class="btn-group">
                <a class="btn btn-sm green dropdown-toggle" href="javascript:;" data-toggle="dropdown">
                    Acciones
                    <i class="fa fa-angle-down"></i>
                </a>
                <ul class="dropdown-menu pull-right" style="min-width: 200px;">';
        if ( $editar ) {
            $saccion .=  '<li><a href="'.$ruta.'/editar/'.$id.'" target="_blank"><i class="fa fa-pencil"></i>Editar</a></li>';
        }
        if ( $borrar ) {
            $saccion .='<li><a href="javascript:void(0);" onclick="modalEliminar('.$id.','."'".$ruta."'".');"><i class="fa fa-trash-o"></i>Borrar</a></li>';
        }
        if ( $ver ) {
            $saccion .= '<li class="divider"> </li> <li><a class="blockui-save" href="'.$ruta.'/ver/'.$id.'"><i class="fa fa-eye" aria-hidden="true"></i>Ver</a></li>';
        }
        if ( $ordenP ) {
            $saccion .='<li><a href="javascript:void(0);" onclick="modalOrdenPago('.$id.');"><i class="fa fa-dollar"></i>Orden de pago</a></li>';
        }
        if ( $verOP ) {
            $saccion .='<li><a href="javascript:void(0);" onclick="verOrdenesPago('.$id.');"><i class="fa fa-money"></i>Ver órdenes P.</a></li>';
        }
        if ( $descargaFile ) {
            $saccion .=  '<li><a class="blockui-save" href="formatospdf/aceptacion/'.$id.'"><i class="fa fa-file-pdf-o"></i>Generar Carta</a></li>';
        }
        if ($exportar) {
            $saccion .= '<li class="divider"> </li> <li><a class="blockui-save" href="' . $ruta . '/exportar/' . $id . '"><i class="fa fa-download" aria-hidden="true"></i>Exportar Ppto Paq.</a></li>';
        }
        if ($exportarPrograma) {
            $saccion .= '<li class="divider"> </li> <li><a class="blockui-save" href="' . $ruta . '/exportarPrograma/' . $id . '"><i class="fa fa-download" aria-hidden="true"></i>Exportar Prog Obra</a></li>';
        }
        if ( $formatos ) {
            $saccion .=  '<li><a class="blockui-save" href="paquetes/formatos/'.$id.'"><i class="fa fa-file-pdf-o"></i>Formatos</a></li>';
        }
        if ($programaObra) {
            $saccion .= '<li class="divider"> </li> <li><a class="blockui-save" href="' . $ruta . '/programaObra/' . $id . '" target="_blank"><i class="fa fa-pencil-square-o" aria-hidden="true"></i>Prog. Obra</a></li>';
        }
        if ($ajustes) {
            $saccion .= '<li class="divider"> </li> <li><a class="blockui-save" href="' . $ruta . '/detallepmo/' . $id . '" target="_blank"><i class="fa fa-pencil-square-o" aria-hidden="true"></i>Ajustes</a></li>';
        }
        $saccion .= "
                </ul>
            </div>
        </div>";
        return $saccion;
    }
}

if ( !function_exists('accionesOrdenes')) {
    function accionesOrdenes($id,$ruta,$ver = false,$editar = true,$borrar=true,$pagar=false) {
        $saccion ='
        <div class="actions">
            <div class="btn-group">
                <a class="btn btn-sm green dropdown-toggle" href="javascript:;" data-toggle="dropdown">
                    Acciones
                    <i class="fa fa-angle-down"></i>
                </a>
                <ul class="dropdown-menu pull-right">';
        if ( $editar ) {
            $saccion .=  '<li><a href="'.$ruta.'/editar/'.$id.'"><i class="fa fa-pencil"></i>Editar</a></li>';
        }
        if ( $pagar ) {
            $saccion .='<li><a href="javascript:void(0);" onclick="cambiarPagado('.$id.');"><i class="fa fa-money"></i>Pagar</a></li>';
        }
        if ( $borrar ) {
            $saccion .='<li><a href="javascript:void(0);" onclick="cancelarOrden('.$id.');"><i class="fa fa-trash-o"></i>Cancelar </a></li>';
        }
        if ( $ver ) {
            $saccion .= '<li class="divider"> </li> <li><a class="blockui-save" href="'.$ruta.'/verOrden/'.$id.'"><i class="fa fa-eye" aria-hidden="true"></i>Ver</a></li>';
        }
        $saccion .= "
                </ul>
            </div>
        </div>";
        return $saccion;
    }
}

if ( !function_exists('lotesEstimados'))
{
    function lotesEstimados($campoLotes = null){
        //Mon_0 Tue_0 Wed_0 Thu_0 Fri_0 Sat_0
        $diasXlot = explode(" ", $campoLotes);
        $lotes = 0;
        foreach ($diasXlot as $dias) {
            $dLT = explode('_', $dias);
            if(!is_numeric($dLT[0]) && !empty($dLT[0]) ) {
                $lotes = $lotes + $dLT[1];
            }
        }
        return $lotes;
    }
}


if ( !function_exists('contarLotesManzanas'))
{
    function contarLotesManzanas($campoLotes = null){
        $lotesManz = explode(" ", $campoLotes);
        $porPaquete = 0;
        $lotesT = '';
        $totalText = '';
        foreach ($lotesManz as $ltsM) {
            $ltM = explode("_", $ltsM);
            $lotes = explode(",", $ltM[0]);
            if(is_numeric($ltM[1])){
                foreach ($lotes as $lt) {
                    if(strripos($lt, '-')){
                        $resta = explode('-', $lt);
                        $porPaquete = $porPaquete + ($resta[1] - $resta[0]) + 1;
                        $lotesT = $lotesT . 'De ' . $resta[0] . ' al ' . $resta[1] . ', ';
                        for ($a = $resta[0]; $a <= $resta[1]; $a++) {
                            $arLts[] = $a;
                        }
                    }
                    else{
                        if(is_numeric($lt)){
                            $lotesT = $lotesT . $lt . ', ';
                            $porPaquete = $porPaquete + 1;
                            $arLts[] = $lt;
                        }
                    }
                }
                $text[$ltM[1]] = substr($lotesT, 0, -2) . ' (' . $ltM[1] . ') ';
                sort($arLts);
                $arrMz[$ltM[1]] = $arLts;
                $arrRng[$ltM[1]] = $ltsM;
                $lotesT = '';
                unset($arLts);
            }
        }
        $keys = array_keys($arrMz);
        sort($keys);
        foreach($keys as $k){
            $totalText = $totalText . $text[$k];
            $tempAr[$k] = $arrMz[$k];
        }
        $arrMz = $tempAr;
        $completo = array('lotes' => substr($totalText, 0, -1), 'total' => $porPaquete, "arrayMzs" => $arrMz, 'arrayRangos' => $arrRng);
        return $completo;
    }
}

if ( !function_exists('pctjeProductividad'))
{
    function pctjeProductividad($numLotes = null){
        switch ($numLotes) {
            case '1':
                $pctjeProductividad = 2;
                break;

            case '2':
                $pctjeProductividad = 3;
                break;

            case ($numLotes>=3):
                $pctjeProductividad = 4;
                break;

            default:
                $pctjeProductividad = 0;
                break;
        }
        return $pctjeProductividad;
    }
}

if (! function_exists('bgStatus'))
{
     function bgStatus($status)
    {
        switch ($status) {
            case '1':
                 $statusArra = '<div class="label label-sm pendiente">pendiente</div>';
                break;

            case '2':
                $statusArra = '<div class="label label-sm encurso">encurso</div>';
                break;
            case '3':
                $statusArra = '<div class="label label-sm finalizado">finalizado</div>';
                break;

            default:
                $statusArra= '';
                break;
        }
        return $statusArra;
    }
}



if (! function_exists('correo'))
{
    function correosNotificaciones($index){
    $subject =
       array(
        "arranque" => array(
                            'from' => 'notificaciones@viviend.mx',
                            'to' =>'angel@navegantes.mx',
                            'subject' => 'Solicitud de autorización de orden de pago.'
                            ),
        'excedentes' => array('from' => 'notificaciones@viviend.mx',
                              'to' =>'angel@navegantes.mx',
                              'subject' => 'Autorización de orden de pago.'
                            )
        );
       return $subject[$index];
    }
}

if (! function_exists('rfcAEdad'))
{
    function rfcAEdad($rfc=""){
        if(strlen($rfc) == 13){
            // calcular fecha de nacimiento en base a RFC
            $fecha_nac=rfcANacimiento($rfc);
            // calcular la edad a paritr de su fecha de nacimiento
            $edad=getAge($fecha_nac);
            if($edad < 100){
                return $edad;
            }else{
                return "RFC ERRÓNEO";
            }
        }else{
            return "RFC ERRÓNEO";
        }
    }
}

if (! function_exists('rfcANacimiento'))
{
    function rfcANacimiento($rfc) {
        // se toma la posision 4 y se obtienen 6 caracteres
        $rfc = substr($rfc,4,6); //910822

        // se divide en pares de 2 y lo convierte a un array con la funcion str_split()
        // $rfc [0] es igual a 91
        // $rfc [1] es igual a 08
        // $rfc [2] es igual a 22
        $rfc = str_split($rfc,2);

        //crear fecha con formato correcto 22-08-1991
        $halfYear=$rfc[0] > 45 ? 19 : 20;
        $fecha_nac =  $rfc[2].'-'.$rfc[1].'-'.$halfYear.$rfc[0];

        return $fecha_nac;
    }
}

if (! function_exists('getAge'))
{
    function getAge($birthday) {
        $birth = strtotime($birthday);
        $now = strtotime('now');
        $age = ($now - $birth) / 31536000; //el numero son la cantidad de segunds que trae un año
        return floor($age);
    }
}

if (! function_exists('crearExcel'))
{
    function crearExcel($data,$nombre,$columnas=array(),$tipo='query'){
        //$CI = &get_instance();
        //$CI->load->library('excel');

        $exportar = false;
        $objPHPExcel = new PhpOffice\PhpSpreadsheet\Spreadsheet();
        $objPHPExcel->getActiveSheet()->setTitle("Libro1");
        $objPHPExcel->setActiveSheetIndex(0);
        $letra = 'A';
        for ($i=0; $i < count($columnas) ; $i++) {
            $objPHPExcel->getActiveSheet()->SetCellValue($letra.'1', $columnas[$i]);
            $letra++;
        }
        if($tipo=='query'){
            if(!is_numeric($data)){
                $i=0;
                $cuerpo=array();
                $rowCount = 2;
                foreach ($data->result_array() as $k => $v) {
                    $i2 =0;
                    $letra = "A";
                    //Armamos el array para el cuerpo del excel
                    foreach ($v as $k2 => $v2) {
                        $objPHPExcel->getActiveSheet()->SetCellValue($letra.$rowCount, $v2);
                        $letra++;
                    }
                    $rowCount++;
                    $i++;
                }
            }
        }else if($tipo="array"){
            if(!is_numeric($data)){
                $i=0;
                $cuerpo=array();
                $rowCount = 2;
                foreach ($data as $k => $v) {
                    $i2 =0;
                    $letra = "A";
                    //Armamos el array para el cuerpo del excel
                    foreach ($v as $k2 => $v2) {
                        $objPHPExcel->getActiveSheet()->SetCellValue($letra.$rowCount, $v2);
                        $letra++;
                    }
                    $rowCount++;
                    $i++;
                }
            }
        }else{
            if(count($data) > 0){
                $i=0;
                $cuerpo=array();
                $rowCount = 2;
                foreach ($data as $k => $v) {
                    $i2 =0;
                    $letra = "A";
                    //Armamos el array para el cuerpo del excel
                    foreach ($v as $k2 => $v2) {
                        $objPHPExcel->getActiveSheet()->SetCellValue($letra.$rowCount, $v2);
                        $letra++;
                    }
                    $rowCount++;
                    $i++;
                }
            }
        }

        $name = $nombre;
        header('Content-Type: application/vnd.ms-excel');
        header('Content-Disposition: attachment;filename="' . $name . '_' . date('Ymd') . '.xlsx"');
        header('Cache-Control: max-age=0'); //no cache
        $objWriter = PhpOffice\PhpSpreadsheet\IOFactory::createWriter($objPHPExcel, 'Xlsx');
        // Forzamos a la descarga
        $objWriter->save('php://output');
    }
}

if (! function_exists('crearExcel2'))
{
    function crearExcel2($data,$nombre,$columnas=array(),$tipo='query'){
        //$CI = &get_instance();
        //$CI->load->library('excel');

        $exportar = false;
        $objPHPExcel = new PhpOffice\PhpSpreadsheet\Spreadsheet();
        $objPHPExcel->getActiveSheet()->setTitle("Libro1");
        $objPHPExcel->setActiveSheetIndex(0);
        $letra = 'A';
        for ($i=0; $i < count($columnas) ; $i++) {
            $objPHPExcel->getActiveSheet()->SetCellValue($letra.'1', $columnas[$i]);
            $letra++;
        }
        if($tipo=='query'){
            if(!is_numeric($data)){
                $i=0;
                $cuerpo=array();
                $rowCount = 2;
                foreach ($data->result_array() as $k => $v) {
                    $i2 =0;
                    $letra = "A";
                    //Armamos el array para el cuerpo del excel
                    foreach ($v as $k2 => $v2) {
                        $objPHPExcel->getActiveSheet()->SetCellValue($letra.$rowCount, $v2);
                        $letra++;
                    }
                    $rowCount++;
                    $i++;
                }
            }
        }else if($tipo="array"){
            if(!is_numeric($data)){
                $i=0;
                $cuerpo=array();
                $rowCount = 2;
                foreach ($data as $k => $v) {
                    $i2 =0;
                    $letra = "A";
                    //Armamos el array para el cuerpo del excel
                    foreach ($v as $k2 => $v2) {
                        $objPHPExcel->getActiveSheet()->SetCellValue($letra.$rowCount, $v2);
                        $letra++;
                    }
                    $rowCount++;
                    $i++;
                }
            }
        }else{
            if(count($data) > 0){
                $i=0;
                $cuerpo=array();
                $rowCount = 2;
                foreach ($data as $k => $v) {
                    $i2 =0;
                    $letra = "A";
                    //Armamos el array para el cuerpo del excel
                    foreach ($v as $k2 => $v2) {
                        $objPHPExcel->getActiveSheet()->SetCellValue($letra.$rowCount, $v2);
                        $letra++;
                    }
                    $rowCount++;
                    $i++;
                }
            }
        }

        $name = $nombre;
        header('Content-Type: application/vnd.ms-excel');
        header('Content-Disposition: attachment;filename="' . $name . '_' . date('Ymd') . '.xls"');
        header('Cache-Control: max-age=0'); //no cache
        $objWriter = PhpOffice\PhpSpreadsheet\IOFactory::createWriter($objPHPExcel, 'Xls');
        // Forzamos a la descarga
        $objWriter->save('php://output');
    }
}

if (! function_exists('crearCsv'))
{
    function crearCsv($data,$nombre,$columnas=array(),$tipo='query'){
        $objPHPExcel = new PhpOffice\PhpSpreadsheet\Spreadsheet();
        $objPHPExcel->getActiveSheet()->setTitle("Libro1");
        $objPHPExcel->setActiveSheetIndex(0);
        $letra = 'A';
        for ($i=0; $i < count($columnas) ; $i++) {
            $objPHPExcel->getActiveSheet()->SetCellValue($letra.'1', $columnas[$i]);
            $letra++;
        }
        if($tipo=='query'){
            if(!is_numeric($data)){
                $i=0;
                $cuerpo=array();
                $rowCount = 2;
                foreach ($data->result_array() as $k => $v) {
                    $i2 =0;
                    $letra = "A";
                    //Armamos el array para el cuerpo del excel
                    foreach ($v as $k2 => $v2) {
                        $objPHPExcel->getActiveSheet()->SetCellValue($letra.$rowCount, $v2);
                        $letra++;
                    }
                    $rowCount++;
                    $i++;
                }
            }
        }else if($tipo="array"){
            if(!is_numeric($data)){
                $i=0;
                $cuerpo=array();
                $rowCount = 2;
                foreach ($data as $k => $v) {
                    $i2 =0;
                    $letra = "A";
                    //Armamos el array para el cuerpo del excel
                    foreach ($v as $k2 => $v2) {
                        $objPHPExcel->getActiveSheet()->SetCellValue($letra.$rowCount, $v2);
                        $letra++;
                    }
                    $rowCount++;
                    $i++;
                }
            }
        }else{
            if(count($data) > 0){
                $i=0;
                $cuerpo=array();
                $rowCount = 2;
                foreach ($data as $k => $v) {
                    $i2 =0;
                    $letra = "A";
                    //Armamos el array para el cuerpo del excel
                    foreach ($v as $k2 => $v2) {
                        $objPHPExcel->getActiveSheet()->SetCellValue($letra.$rowCount, $v2);
                        $letra++;
                    }
                    $rowCount++;
                    $i++;
                }
            }
        }

        $name = $nombre;
        header('Content-Type: application/csv');
        header('Content-Disposition: attachment;filename="' . $name . '_' . date('Ymd') . '.csv"');
        header('Cache-Control: max-age=0'); //no cache
        $objWriter = new \PhpOffice\PhpSpreadsheet\Writer\Csv($objPHPExcel);
        // Forzamos a la descarga
        $objWriter->save('php://output');
    }
}

if (! function_exists('saveCsv'))
{
    function saveCsv($data,$nombre,$columnas=array(),$tipo='query'){
        $objPHPExcel = new PhpOffice\PhpSpreadsheet\Spreadsheet();
        $objPHPExcel->getActiveSheet()->setTitle("Libro1");
        $objPHPExcel->setActiveSheetIndex(0);
        $letra = 'A';
        for ($i=0; $i < count($columnas) ; $i++) {
            $objPHPExcel->getActiveSheet()->SetCellValue($letra.'1', $columnas[$i]);
            $letra++;
        }
        if($tipo=='query'){
            if(!is_numeric($data)){
                $i=0;
                $cuerpo=array();
                $rowCount = 2;
                foreach ($data->result_array() as $k => $v) {
                    $i2 =0;
                    $letra = "A";
                    //Armamos el array para el cuerpo del excel
                    foreach ($v as $k2 => $v2) {
                        $objPHPExcel->getActiveSheet()->SetCellValue($letra.$rowCount, $v2);
                        $letra++;
                    }
                    $rowCount++;
                    $i++;
                }
            }
        }else if($tipo="array"){
            if(!is_numeric($data)){
                $i=0;
                $cuerpo=array();
                $rowCount = 2;
                foreach ($data as $k => $v) {
                    $i2 =0;
                    $letra = "A";
                    //Armamos el array para el cuerpo del excel
                    foreach ($v as $k2 => $v2) {
                        $objPHPExcel->getActiveSheet()->SetCellValue($letra.$rowCount, $v2);
                        $letra++;
                    }
                    $rowCount++;
                    $i++;
                }
            }
        }else{
            if(count($data) > 0){
                $i=0;
                $cuerpo=array();
                $rowCount = 2;
                foreach ($data as $k => $v) {
                    $i2 =0;
                    $letra = "A";
                    //Armamos el array para el cuerpo del excel
                    foreach ($v as $k2 => $v2) {
                        $objPHPExcel->getActiveSheet()->SetCellValue($letra.$rowCount, $v2);
                        $letra++;
                    }
                    $rowCount++;
                    $i++;
                }
            }
        }

        $writer = new \PhpOffice\PhpSpreadsheet\Writer\Csv($objPHPExcel);
        $writer->save("$nombre.csv");
    }
}

if (! function_exists('leyendaNotif'))
{
     function leyendaNotif($status, $sendWhatsapp = false)
    {
        $ci=& get_instance();
        $baseLink = $ci->config->item('baseLink');
        $numWhatsapp = $ci->config->item('numWhatsapp');
        $linkavance =  '<a class="blue" href="'.$baseLink.'avance'.'">Haz click aquí:</a>';


        switch ($status) {
            case '1':
                if(!$sendWhatsapp){
                    $leyendaNotif = '<div class="">
                                    ¡Felicidades! <br> Hemos iniciado la construcción de su vivienda. <br>
                                    Le notificaremos por Whatsapp los avances que se tendrán con la finalidad de informarle
                                    de manera clara y oportuna.
                                    </div>';



                }else{
                    $leyendaNotif = '<div class="">
                                    ¡Felicidades! <br> Hemos iniciado la construcción de su vivienda. <br>
                                    Le notificaremos por Whatsapp los avances que se tendrán con la finalidad de informarle
                                    de manera clara y oportuna.
                                    </div>';
                }
                break;
            case '2':
                if(!$sendWhatsapp){
                    $leyendaNotif = '<div class="">
                                    Le notificamos que ha terminado la etapa de Obra Negra de su vivienda,
                                    </div>';
                }else{
                    $leyendaNotif = '<div class="">
                                        Le notificamos que ha terminado la etapa de Obra Negra de su vivienda.
                                    </div>';
                }
                break;
            case '3':
                if(!$sendWhatsapp){
                    $leyendaNotif = '<div class="">
                                Le notificamos que ha finalizado la etapa de Acabados de su vivienda,
                                Le invitamos a acceder a la página de avance de Vivienda preparada para usted. ¡Ya falta poco!
                                </div>';
                }else{
                    $leyendaNotif = '<div class="">
                                Le notificamos que ha finalizado la etapa de Acabados de su vivienda. ¡Ya falta poco!
                                </div>';
                }
                break;
             case '4':
                if(!$sendWhatsapp){
                    $leyendaNotif = '<div class="">
                                ¡Felicidades! Le informamos que ha finalizado la construcción de su vivienda.
                                En unos días un asesor se comunicará usted para programar su entrega.
                                </div>';
                }else{
                    $leyendaNotif = '<div class="">
                                ¡Felicidades! Te informamos que ha finalizado la construcción de tu vivienda.
                                En unos días un Asesor se comunicará usted para programar su entrega.
                                </div>';
                }
                break;
            case '5':
                if(!$sendWhatsapp){
                    $leyendaNotif = '<div class="">
                                        Agradecemos su confianza en adquirir su vivienda con nosotros. En caso de presentarse algún
                                        inconveniente falta o desperfecto le recomendamos levantar su incidencia a la brevedad en la
                                        siguiente liga  <br><br>
                                        <a target="_blank" href="https://wa.me/'.$numWhatsapp.'?text=Quiero%20reportar%20una%20incidencia" class="btn green waves-effect waves-light left" type="button" name="action">
                                        <img width="50%" src="img/autorespuesta/chatbox-viviend.png" alt="Chatbox-viviend" ></a>.
                                     </div>';

                }else{
                    $leyendaNotif = '<div class="">
                                Agradecemos su confianza en  adquirir su vivienda con nosotros. </div>';
                }
                break;
            case '6':
                if(!$sendWhatsapp){
                    $leyendaNotif = '<div class="">
                                        ¡Felicidades! Agradecemos tu preferencia y te informamos que se ingresó tu expediente para la compra de vivienda, te mantendremos al tanto por este medio sobre los avances en tu proceso.
                                        </div>';
                }else{
                    $leyendaNotif = '<div class="">
                                ¡Felicidades! Agradecemos tu preferencia y te informamos que se ingresó tu expediente para la compra de vivienda, te mantendremos al tanto por este medio sobre los avances en tu proceso.
                                </div>';
                }
                break;

            case '7':
                if(!$sendWhatsapp){
                    $leyendaNotif = '
                    <div class="">
                    Buen día, nos place comunicarte que tu proceso se encuentra en:
                    INSCRIPCIÓN ANTE INFONAVIT, <br>
                    Pronto tendremos mas información valiosa sobre tu trámite.
                    </div>';
                }else{
                    $leyendaNotif = '<div class="">
                    Buen día, nos place comunicarte que tu proceso se encuentra en:
                    INSCRIPCIÓN ANTE INFONAVIT, <br>
                    Pronto tendremos mas información valiosa sobre tu trámite.
                    </div>';
                }
                break;
            case '8':
                if(!$sendWhatsapp){
                    $leyendaNotif = '<div class="">
                                        En horabuena! está por contactarte tu ASESOR con el fin de programar horario para la firma de tus ESCRITURAS.
                                        </div>';
                }else{
                    $leyendaNotif = '<div class="">
                                        En horabuena! está por contactarte tu ASESOR con el fin de programar horario para la firma de tus ESCRITURAS.
                                    </div>';
                }
                break;

            case '9':
                if(!$sendWhatsapp){
                    $leyendaNotif = '<div class="">
                                        Nuestro proceso ha caminado y finalizado en forma óptima, por lo que es un gusto darte la bienvenida a la FAMILIA VIVIEND, te aseguramos que mantendremos nuestro compromiso de crear hogares de calidad.

                                        </div>';
                }else{
                    $leyendaNotif = '<div class="">
                                        Nuestro proceso ha caminado y finalizado en forma óptima, por lo que es un gusto darte la bienvenida a la FAMILIA VIVIEND, te aseguramos que mantendremos nuestro compromiso de crear hogares de calidad.

                                    </div>';
                }
                break;
            case '10':
                if(!$sendWhatsapp){
                    $leyendaNotif = '
                    <div class="">
                    Buen día, nos place comunicarte que tu proceso se encuentra en:
                    INSCRIPCIÓN ANTE INFONAVIT, <br>
                    Pronto tendremos mas información valiosa sobre tu trámite.
                    </div>';
                }else{
                    $leyendaNotif = '<div class="">
                    Buen día, nos place comunicarte que tu proceso se encuentra en:
                    INSCRIPCIÓN ANTE INFONAVIT, <br>
                    Pronto tendremos mas información valiosa sobre tu trámite.
                    </div>';
                }
                break;
            default:
                $leyendaNotif= '';
                break;
        }
        return $leyendaNotif;
    }
}

if (! function_exists('leyendaNotifWhatsapp'))
{
     function leyendaNotifWhatsapp($status)
    {
        $ci=& get_instance();
        $baseLink = $ci->config->item('baseLink');
        $numWhatsapp = $ci->config->item('numWhatsapp');
        $linkavance = $baseLink.'avance';

        switch ($status) {
            case '1':
                 $leyendaNotif = 'Etapa: Arranque'. "\r\n";
                 /*$leyendaNotif .= 'Mientras tanto te invitamos a acceder a la página de avance de Vivienda preparada para ti.'."\r\n";
                 $leyendaNotif .= $linkavance. "\r\n";*/
                 $leyendaNotif .= 'Este es un mensaje informativo. No es necesario responder.';

                break;
            case '2':
                $leyendaNotif = 'Etapa: Obra Negra'. "\r\n";
                /*$leyendaNotif .= 'Mientras tanto te invitamos a acceder a la página de avance de Vivienda preparada para ti.'. "\r\n";
                $leyendaNotif .= $linkavance . "\r\n";*/
                $leyendaNotif .= 'Este es un mensaje informativo. No es necesario responder.';

                break;
            case '3':
                $leyendaNotif = 'Etapa: Acabados' . "\r\n";
                /*$leyendaNotif .= 'Mientras tanto te invitamos a acceder a la página de avance de Vivienda preparada para ti.' . "\r\n";
                $leyendaNotif .= $linkavance . "\r\n";*/
                $leyendaNotif .= 'Este es un mensaje informativo. No es necesario responder.';

                break;
             case '4':
                $leyendaNotif = 'Etapa: Entrega'. "\r\n";
                $leyendaNotif .= 'Tu asesor se pondrá en contacto contigo para confirmar la fecha de entrega'. "\r\n";
                /*$leyendaNotif .= $linkavance . "\r\n";*/
                $leyendaNotif .= 'Este es un mensaje informativo. No es necesario responder.';

                break;
            case '5':
                $leyendaNotif = 'Etapa: Entregado'. "\r\n";
                $leyendaNotif .= 'De presentarse alguna falla o desperfecto te recomendamos levantar tu incidencia enviando a este número la palabra "Quiero reportar una incidencia" o haciendo click en la siguiente liga:'. "\r\n";
                $leyendaNotif .= 'https://wa.me/'.$numWhatsapp.'?text=Quiero%20reportar%20una%20incidencia';

                break;
            case '6':
                $leyendaNotif = 'Etapa: Alta de Venta'. "\r\n";
                $leyendaNotif .= 'Este es un mensaje informativo. No es necesario responder.';
                break;
            case '7':
                $leyendaNotif = 'Etapa: Inscripción de Crédito'. "\r\n";
                $leyendaNotif .= 'Este es un mensaje informativo. No es necesario responder.';
                break;
            case '8':
                $leyendaNotif = 'Etapa: Programación de firma de escrituras'. "\r\n";
                $leyendaNotif .= 'Este es un mensaje informativo. No es necesario responder.';
                break;
            case '9':
                $leyendaNotif = 'Etapa: Formalización de la venta'. "\r\n";
                $leyendaNotif .= 'Este es un mensaje informativo. No es necesario responder.';
                break;
            case '10':
                $leyendaNotif = 'Etapa: Inscripción de Crédito'. "\r\n";
                $leyendaNotif .= 'Este es un mensaje informativo. No es necesario responder.';
                break;
            default:
                $leyendaNotif= '';
                break;
        }
        return $leyendaNotif;
    }
}


if (! function_exists('statusNotif'))
{
     function statusNotif($status)
    {
        switch ($status) {
            case '1':
                 $statusNotif = '<div class="label label-sm arranque">Arranque</div>';
                break;
            case '2':
                $statusNotif = '<div class="label label-sm o-negra">Obra Negra</div>';
                break;
            case '3':
                $statusNotif = '<div class="label label-sm acabados">Acabados</div>';
                break;
            case '4':
                $statusNotif = '<div class="label label-sm entrega">Entrega</div>';
                break;
            case '5':
                $statusNotif = '<div class="label label-sm cita">Entregado</div>';
                break;
            case '6':
                $statusNotif = '<div class="label label-sm status-notif">Alta de venta</div>';
                break;
            case '7':
                $statusNotif = '<div class="label label-sm status-notif">Inscripción de Crédito</div>';
                break;
            case '8':
                $statusNotif = '<div class="label label-sm status-notif">Programación de firma de escrituras</div>';
                break;
            case '9':
                $statusNotif = '<div class="label label-sm status-notif">Formalización de la venta</div>';
                break;
            case '10':
                $statusNotif = '<div class="label label-sm status-notif">Inscripción de Crédito</div>';
                break;
            default:
                $statusNotif= '';
                break;
        }
        return $statusNotif;
    }
}

if (! function_exists('leyendaConstruyendo'))
{
     function leyendaConstruyendo($status)
    {
         $ci=& get_instance();
        $baseLink = $ci->config->item('baseLink').'sistema/';
        switch ($status) {
            case '1':
                 $statusNotif = 'En Viviend es muy importante que su proceso sea
                 a su entera satisfacción por lo cual si llegara a presentar alguna duda le invitamos a que nos contacte
                 vía Whatsapp al Número: +52 1 871-132-4950, donde con gusto uno de nuestros asesores le atenderán.';
                break;
            case '2':
                $statusNotif = 'Para poder programar visita de obra, le invitamos a comunicarse al +52 1 871-132-4950, donde podrá agendar
                su visita en los siguientes horarios de Lunes-Viernes 9:00 am a 5:00 pm  Sábado 9:00 am a 12:00 pm.
                Le comentamos que tiene dos días hábiles a partir de hoy para agendar su visita.
                De lo contrario se continuará con el proceso y por seguridad no se permitirá el acceso.
                ';
                break;
            case '3':
                $statusNotif = 'En Viviend es muy importante que su proceso sea
                 a su entera satisfacción por lo cual si se llegara a presentar alguna duda le invitamos a que nos contacte
                 vía Whatsapp al Número: +52 1 871-132-4950, donde con gusto uno de nuestros asesores le atenderán.';
                break;
             case '4':
                $statusNotif = 'En Viviend es muy importante que su proceso sea
                 a su entera satisfacción por lo cual si llegara a presentar alguna duda le invitamos a que nos contacte
                 vía Whatsapp al Número: +52 1 871-132-4950, donde con gusto uno de nuestros asesores le atenderá.';
                break;
             case '5':
                $statusNotif = 'En la entrega de su vivienda le han sido entregadas las garantías con las que cuenta. En caso de
                de requerir alguno de ellos el proceso es el siguiente:
                <br>
                1. Comunícate al 871-1324-950 donde le pedimos proporcione Nombre del cliente, dirección y detalle que presenta.<br>
                2. Nuestro departamento de postventa le asignará un # de folio.<br>
                3. Se programará una fecha y hora en la que nuestro personal encargado acudirá a su hogar.<br>
                4. Recuerda, para hacer válida su garantía debe estar dentro del plazo de vigencia estipulado
                en la póliza de garantía.'.

                '<table style="padding-top:30px;" width="100%" border="0" cellspacing="0" cellpadding="0">
                    <tr>
                        <td style="color:#fff;" align="left" class="footercopy">
                            <img src="'.$baseLink.'img/garantias_1.png" alt="viviend" width="200" height="80">
                        </td>
                        <td style="color:#fff;" align="right" class="footercopy">
                              <img src="'.$baseLink.'img/con_viviend_si_se_puede.png" alt="viviend" width="200" height="65">
                        </td>
                    </tr>
                </table>
                   '



                ;
                break;

            default:
                $statusNotif= '';
                break;
        }
        return $statusNotif;
    }
}



if (! function_exists('logoConstruyendo'))
{
    function logoConstruyendo($status)

    {
        $ci=& get_instance();
        $baseLink = $ci->config->item('baseLink').'sistema/';

        switch ($status) {
            case '1':
                 $imgStatus = '  <table width="100%" border="0" cellspacing="0" cellpadding="0">
                                    <tr>
                                        <td style="color:#fff;" align="center" class="footercopy">
                                             <img src="img/construyendo_de_tu_mano.png" alt="viviend" width="80" height="70">
                                        </td>
                                        <td style="color:#fff;" align="right" class="footercopy">
                                             <img src="'.$baseLink.'img/con_viviend_si_se_puede.png" alt="viviend" width="200" height="65">
                                        </td>
                                    </tr>
                                </table>';
                break;
            case '2':
                $imgStatus = '  <table width="100%" border="0" cellspacing="0" cellpadding="0">
                                    <tr>
                                        <td style="color:#fff;" align="center" class="footercopy">
                                             <img src="img/construyendo_de_tu_mano.png" alt="viviend" width="80" height="70">
                                        </td>
                                        <td style="color:#fff;" align="right" class="footercopy">
                                             <img src="'.$baseLink.'img/con_viviend_si_se_puede.png" alt="viviend" width="200" height="65">
                                        </td>
                                    </tr>
                                </table>';
                break;
            case '3':
                $imgStatus = '  <table width="100%" border="0" cellspacing="0" cellpadding="0">
                                    <tr>
                                        <td style="color:#fff;" align="center" class="footercopy">
                                             <img src="img/construyendo_de_tu_mano.png" alt="viviend" width="80" height="70">
                                        </td>
                                        <td style="color:#fff;" align="right" class="footercopy">
                                             <img src="'.$baseLink.'img/con_viviend_si_se_puede.png" alt="viviend" width="200" height="65">
                                        </td>
                                    </tr>
                                </table>';
                break;
             case '4':
                $imgStatus = '  <table width="100%" border="0" cellspacing="0" cellpadding="0">
                                    <tr>
                                        <td style="color:#fff;" align="center" class="footercopy">
                                             <img src="img/construyendo_de_tu_mano.png" alt="viviend" width="80" height="70">
                                        </td>
                                        <td style="color:#fff;" align="right" class="footercopy">
                                             <img src="'.$baseLink.'img/con_viviend_si_se_puede.png" alt="viviend" width="200" height="65">
                                        </td>
                                    </tr>
                                </table>';
                break;
               case '5':
                $imgStatus = ' <table width="100%" border="0" cellspacing="0" cellpadding="0">
                                    <tr>
                                        <td style="color:#fff;" align="center" class="footercopy">
                                            <br>  <br>
                                        </td>
                                        <td style="color:#fff;" align="right" class="footercopy">
                                              <br>  <br>
                                        </td>
                                    </tr>
                                </table>';
                break;
            case '6':
            case '7':
            case '8':
            case '9':
            case '10':
                $imgStatus = ' <table width="100%" border="0" cellspacing="0" cellpadding="0">
                                    <tr>
                                        <td style="color:#fff;" align="center" class="footercopy">
                                             <img src="img/garantias_1.png" alt="viviend" width="80" height="70">
                                        </td>
                                        <td style="color:#fff;" align="right" class="footercopy">
                                             <img src="'.$baseLink.'img/con_viviend_si_se_puede.png" alt="viviend" width="200" height="65">
                                        </td>
                                    </tr>
                                </table>';
                break;

            default:
                $imgStatus= '';
                break;
        }
        return $imgStatus;
    }
}


if (! function_exists('imgStatus'))
{
    function imgStatus($status)

    {
        $ci=& get_instance();
        $baseLink = $ci->config->item('baseLink').'sistema/';

        switch ($status) {
            case '1':
                 $imgStatus = '<img src="'.$baseLink.'img/autorespuesta/status-arranque.png" width="100" height="100"> ';
                break;
            case '2':
                $imgStatus = '<img src="'.$baseLink.'img/autorespuesta/status-obra-negra.png" width="100" height="100"> ';
                break;
            case '3':
                $imgStatus = '<img src="'.$baseLink.'img/autorespuesta/status-acabados.png" width="100" height="100"> ';
                break;
            case '4':
                $imgStatus = '<img src="'.$baseLink.'img/autorespuesta/status-entrega.png" width="100" height="100"> ';
                break;
            case '5':
                $imgStatus = '<img src="'.$baseLink.'img/autorespuesta/status-cita.png" width="100" height="100"> ';
                break;
            case '6':
                $imgStatus = '<img src="'.$baseLink.'img/autorespuesta/status-cita.png" width="100" height="100"> ';
                break;
            case '7':
                $imgStatus = '<img src="'.$baseLink.'img/autorespuesta/status-cita.png" width="100" height="100"> ';
                break;
            case '8':
                $imgStatus = '<img src="'.$baseLink.'img/autorespuesta/status-cita.png" width="100" height="100"> ';
                break;
            case '9':
                $imgStatus = '<img src="'.$baseLink.'img/autorespuesta/status-cita.png" width="100" height="100"> ';
                break;
            case '10':
                $imgStatus = '<img src="'.$baseLink.'img/autorespuesta/status-cita.png" width="100" height="100"> ';
                break;
            default:
                $imgStatus= '';
                break;
        }
        return $imgStatus;
    }
}



if (! function_exists('email_notificaciones'))
{
     function email_notificaciones($htmlArra, $subject,$destMail,$logoConstruyendo) {

     $ci=& get_instance();
     $baseLink = $ci->config->item('baseLink');
     $liga = $baseLink."sistema/img/";

     $html = '
            <style type="text/css">

            .header {padding: 0px 30px 0px 30px;}
            .col425 {width: 425px!important;}
            .subhead {font-size: 15px; color: #ffffff; font-family: sans-serif; letter-spacing: 10px;}
            .h1 {font-size: 33px; line-height: 38px; font-weight: bold;}
            .h1, .h2, .bodycopy {color: #153643; font-family: sans-serif;}
            .innerpadding {padding: 0px 30px 30px 30px;}
            .borderbottom {
                border-bottom: 1px solid #f2eeed;
            }
            .h2 {padding: 0 0 15px 0; font-size: 24px; line-height: 28px; font-weight: bold;}
            .bodycopy {font-size: 16px; line-height: 22px;}
            .button {text-align: center; font-size: 18px; font-family: sans-serif; font-weight: bold; padding: 0 30px 0 30px;}
            .button {text-align: center; font-size: 18px; font-family: sans-serif; font-weight: bold; padding: 0 30px 0 30px;}
            .button a {color: #ffffff; text-decoration: none;}
            .footer {padding: 20px 30px 15px 30px;}
            .footercopy {font-family: sans-serif; font-size: 14px; color: #ffffff;}
            .footercopy a {color: #ffffff; text-decoration: underline;}
            body[yahoo] .unsubscribe {display: block; margin-top: 20px; padding: 10px 50px; background: #2f3942; border-radius: 5px; text-decoration: none!important; font-weight: bold;}
            body[yahoo] .hide {display: none!important;}
            .paddinginfo{
                padding:10px;

            }
            .blue{
                color: blue;
            }
            .arranque{
                background-color:#fff;
                width:112px;
                text-align:left;
                text-transform: uppercase;
            }
            .o-negra{
                background-color:#FFF;
                width:112px;
                text-align:left;
                text-transform: uppercase;
            }
            .acabados{
                background-color:#FFF;
                width:112px;
                text-align:left;
                text-transform: uppercase;
            }
            .entrega{
                background-color:#FFF;
                width:112px;
                text-align:left;
                text-transform: uppercase;
            }
            .status-notif{
                background-color:#FFF;
                width:112px;
                text-align:left;
                text-transform: uppercase;
            }
            .greentitle{
                color:#248d3b;
                font-weight:bold;
            }
            .fs-notif{
                font-size: 15px;
            }
            .paddingencabezados{
                padding:5px;
            }
            .borderyellow{
                border: 1px solid #f2a930;
            }
            .encbold{
                font-weight:bold;
            }
            @media only screen and (min-device-width: 601px) {
            .content {width: 600px !important;}
            }

            @media only screen and (min-device-width: 601px) {
            .content {width: 600px !important;}
            .col425 {width: 425px!important;}
            .col380 {width: 100% !important;}
            }
            @media only screen and (max-width: 550px), screen and (max-device-width: 550px) {
            body[yahoo] .buttonwrapper {background-color: transparent!important;}
            body[yahoo] .button a {background-color: #e05443; padding: 15px 15px 13px!important; display: block!important;}
            }

        </style>


      <!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "https://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
        <html xmlns="http://www.w3.org/1999/xhtml">
            <head>
                <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
                <title></title>
                <base href="'.base_url().'" />
                <link href="assets/css/bootstrap.min.css" rel="stylesheet" type="text/css">
                <link href="assets/css/responsive.css" rel="stylesheet">
                <script type="text/javascript" src="assets/js/bootstrap.min.js"></script>

                <style type="text/css">
                body {margin: 0; padding: 0; min-width: 100%!important;}
                .content {width: 100%; max-width: 600px;}
                </style>
            </head>
            <body yahoo bgcolor="#f6f8f1">

                <table id="testdiv" width="100%" bgcolor="#f6f8f1" border="0" cellpadding="0" cellspacing="0">
                    <tr>
                        <td>
                            <table class="content" align="center" cellpadding="0" cellspacing="0" border="0">
                                <tr>
                                    <td class="header" bgcolor="#ffffff" align="center">
                                        <img src="'.$liga.'logo-300.png" width="115" height="115" border="0" alt="" />
                                    </td>
                                </tr>
                               <!-- inicia el cuerpo-->
                                 <tr>
                                    <td class="header" bgcolor="#ffffff" align="center">
                                        <p>'.$htmlArra.'</p>
                                    </td>
                                </tr>
                               <!-- inicia el footer-->

                                <tr>
                                    <td class="footer" bgcolor="#fff" style="padding-top:10px;">

                                        <table width="100%" border="0" cellspacing="0" cellpadding="0">
                                            <tr >
                                                <td style="color:#248d3b;font-weight:bold;" align="center" class="footercopy">
                                                    VIVIEND INMOBILIARIA<br/>

                                                </td>
                                            </tr>
                                            <tr >
                                                <td style="color:#fff;" align="center" class="footercopy">
                                                    <br/>
                                                </td>
                                            </tr>
                                        </table>
                                        '.$logoConstruyendo.'
                                    </td>
                                </tr>
                            </table>
                        </td>
                    </tr>
                </table>
             </body>
        </html>

     ';

    $cabeceras  = 'MIME-Version: 1.0' . "\r\n";
    $cabeceras .= "Content-type:text/html;charset=utf-8" . "\n";
    $cabeceras .= 'From: Viviend Notificaciones <notificaciones@viviend.mx>' . "\r\n";
    $para = $destMail;

    if ($para !=null){
            $response = @mail($para, $subject, $html, $cabeceras);
    }

    return $html;

    }// termina email_notificaciones
}

if (! function_exists('json_output')) //no se si realmente se necesita para las autorespuestas de ¿l controlador Auth
{
    function json_output($statusHeader,$response)
    {
        $ci =& get_instance();
        $ci->output->set_content_type('application/json');
        $ci->output->set_status_header($statusHeader);
        $ci->output->set_output(json_encode($response));
    }
}

if (! function_exists('validSesionAdmin')) //Validar Rol = 1 o por Id
{
    function validSesionAdmin($arrayAdmin = array())
    {
        $valid = false;
        if(count($arrayAdmin) > 0){
            if($_SESSION["viv"]['rol']==1){
                foreach($arrayAdmin as $key => $val){
                    if($_SESSION["viv"]['id']==$val){
                        $valid = true;
                    }
                }
            }
        }else{
            if($_SESSION["viv"]['rol']==1){
                $valid = true;
            }
        }
        return $valid;
    }
}

if ( !function_exists('calcularAmortizacion'))
{
    function calcularAmortizacion( $datitos = array() ){
        if( count($datitos) == 4 ){
            $fechaP = new DateTime($datitos['fecha']);
            $amortizacion[] = array(
                "id" => "Préstamo",
                "fecha" => $fechaP->format('d/m/Y'),
                "pago" => 0.00,
                "interes" =>  $datitos['interes'],
                "saldo" => $datitos['monto']
            );
            $pagos = round( ($datitos['monto'] / $datitos['plazos']) , 2);
            $saldo = $datitos['monto'];
            for( $i = 1; $i <= $datitos['plazos']; $i++){
                $tempSaldo = $saldo - $pagos;
                if( $tempSaldo > 0 && $i < $datitos['plazos'] ){
                    $saldo = $tempSaldo;
                }
                else{
                    $pagos = $saldo;
                    $saldo = 0.00;
                }
                $fechaP->add( new DateInterval('P1M') );
                $amortizacion[] = array(
                    "id" => $i,
                    "fecha" => $fechaP->format('d/m/Y'),
                    "pago" => $pagos,
                    "interes" =>  $datitos['interes'],
                    "saldo" => $saldo
                );
            }
        }else{
            $amortizacion[] = array(
                "id" => "Sin cacular",
                "fecha" => "Sin cacular",
                "pago" => "Sin cacular",
                "interes" => "Sin cacular",
                "saldo" => "Sin cacular"
            );
        }
        return $amortizacion;
    }
}

if (! function_exists('statusCuenta'))
{
     function statusCuenta($status)
    {
        switch ($status) {
            case '0':
                 $status = 'por liquidar';
                break;
            case '1':
                $status = 'liquidada';
                break;
            case '2':
                $status = 'cancelada';
                break;
            case '3':
                $status = 'cancelada/por liquidar';
                break;
            default:
                $status= '';
                break;
        }
        return $status;
    }
}

if (! function_exists('statusDetalle'))
{
     function statusDetalle($status)
    {
        switch ($status) {
            case '1':
                 $status = 'en tiempo';
                break;
            case '2':
                $status = 'vencido';
                break;


            default:
                $status= '';
                break;
        }
        return $status;
    }
}

if (! function_exists('tipostatusDetalle'))
{
     function tipostatusDetalle($status)
    {
        switch ($status) {
            case '1':
                 $status = 'deposito';
                break;
            case '2':
                $status = 'retiro';
                break;


            default:
                $status= '';
                break;
        }
        return $status;
    }
}

if ( !function_exists('accionesContado')) {
    function accionesContado($id,$idAltaVenta,$ruta,$deposito=false,$retiro = false,$cancelar=false,$contrato=false,$detalle=false) {
        $saccion ='
        <div class="actions">
            <div class="btn-group">
                <a class="btn btn-sm green dropdown-toggle" href="javascript:;" data-toggle="dropdown">
                    Acciones
                    <i class="fa fa-angle-down"></i>
                </a>
                <ul class="dropdown-menu pull-right">';

        if ( $deposito ) {
            $saccion .='<li><a onclick="modalPago('.$id.',1)"  >Depósito </a></li>';
        }
        if ( $contrato ) {
            $saccion .='<li><a href="formatospdf/contratoCompraVenta/'.$idAltaVenta.'"   >Contrato PDF</a></li>';
        }
        if ( $detalle ) {
            $saccion .='<li><a target="_blank" href="contado/detalle/'.$id.'/'.$idAltaVenta.'   "  >Detalle </a></li>';
        }
        if ( $retiro ) {
            $saccion .='<li><a onclick="modalPago('.$id.',2)"  >Retiro </a></li>';
        }
        if ( $cancelar ) {
            $saccion .='<li><a onclick="modalPago('.$id.',3)"  >Cancelar </a></li>';
        }
        $saccion .= "
                </ul>
            </div>
        </div>";
        return $saccion;
    }
}

if (! function_exists('statusObra'))
{
     function statusObra($status)
    {
        switch ($status) {
            case '1':
                 $status = 'pendiente';
                break;
            case '2':
                $status = 'construccion';
                break;


            default:
                $status= '';
                break;
        }
        return $status;
    }
}

if (! function_exists('createExcelComparative'))
{
    function createExcelComparative($data,$name_excel,$columns=array(),$type='query',$name_company=''){
        $tipo_lote = $indent_1 = $indent_2 = $indent_3 = 0;
        $name_level_1 = $name_level_2 = $name_level_3 = '';
        $total_rows = array(
            "total" => array(
                'C' => 0,
                'D' => 0,
                'E' => 0,
                'F' => 0,
                'G' => 0,
                'H' => 0,
            ),
            "tipo_lote" => array(
                'C' => 0,
                'D' => 0,
                'E' => 0,
                'F' => 0,
                'G' => 0,
                'H' => 0,
            ),
            "fracc" => array(
                'C' => 0,
                'D' => 0,
                'E' => 0,
                'F' => 0,
                'G' => 0,
                'H' => 0,
            ),
            "almacen" => array(
                'C' => 0,
                'D' => 0,
                'E' => 0,
                'F' => 0,
                'G' => 0,
                'H' => 0,
            ),
            "product" => array(
                'C' => 0,
                'D' => 0,
                'E' => 0,
                'F' => 0,
                'G' => 0,
                'H' => 0,
            ),
        );
        $row_level_1 = $row_level_2 = $row_level_3 = '';
        $row_init_data = 10;
        $column_init_data = 'B';

        $objPHPExcel = new PhpOffice\PhpSpreadsheet\Spreadsheet();
        $objPHPExcel->getActiveSheet()->setTitle("Libro1");
        $objPHPExcel->setActiveSheetIndex(0);

        $objPHPExcel->getActiveSheet()->SetCellValue('B2', $name_company);
        $objPHPExcel->getActiveSheet()->getStyle('B2')->getFont()->setBold(true)->setSize(20);

        $objPHPExcel->getActiveSheet()->SetCellValue('B3', 'PRESUPUESTO VS COMPRAS');
        $objPHPExcel->getActiveSheet()->getStyle('B3')->getFont()->setBold(true)->setSize(11);

        for ($i=1; $i <= count($columns) ; $i++) {
            $objPHPExcel->getActiveSheet()->SetCellValue($column_init_data.'9', $columns[$i-1]);
            $column_init_data++;
        }
        $objPHPExcel->getActiveSheet()->getStyle('B9')->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID);
        $objPHPExcel->getActiveSheet()->getStyle('B9')->getFill()->getStartColor()->setARGB('00000000');
        $objPHPExcel->getActiveSheet()->getStyle('B9')->getFont()->getColor()->setARGB(\PhpOffice\PhpSpreadsheet\Style\Color::COLOR_WHITE);

        if ($type=='query') {
            if (!is_numeric($data)) {
                $cuerpo=array();
                $rowCount = $row_init_data;
                foreach ($data->result_array() as $k => $v) {
                    if (empty($v['articulo']) || is_null($v['articulo'])) continue;
                    if (empty($name_level_1) || $tipo_lote!==intval($v['tipoLote'])) {
                        if (!empty($row_level_1)) {
                            $objPHPExcel->getActiveSheet()->SetCellValue('C'.$row_level_1, number_format($total_rows['fracc']['C'],2,'.',','));
                            $objPHPExcel->getActiveSheet()->getStyle('C'.$row_level_1)->getAlignment()->setHorizontal(PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT);

                            $objPHPExcel->getActiveSheet()->SetCellValue('D'.$row_level_1, number_format($total_rows['fracc']['D'],2,'.',','));
                            $objPHPExcel->getActiveSheet()->getStyle('D'.$row_level_1)->getAlignment()->setHorizontal(PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT);

                            $objPHPExcel->getActiveSheet()->SetCellValue('E'.$row_level_1, number_format($total_rows['fracc']['E'],2,'.',','));
                            $objPHPExcel->getActiveSheet()->getStyle('E'.$row_level_1)->getAlignment()->setHorizontal(PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT);

                            $objPHPExcel->getActiveSheet()->SetCellValue('F'.$row_level_1, number_format($total_rows['fracc']['F'],2,'.',','));
                            $objPHPExcel->getActiveSheet()->getStyle('F'.$row_level_1)->getAlignment()->setHorizontal(PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT);

                            $objPHPExcel->getActiveSheet()->SetCellValue('G'.$row_level_1, number_format($total_rows['fracc']['G'],2,'.',','));
                            $objPHPExcel->getActiveSheet()->getStyle('G'.$row_level_1)->getAlignment()->setHorizontal(PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT);

                            $objPHPExcel->getActiveSheet()->SetCellValue('H'.$row_level_1, number_format($total_rows['fracc']['H'],2,'.',','));
                            $objPHPExcel->getActiveSheet()->getStyle('H'.$row_level_1)->getAlignment()->setHorizontal(PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT);

                            $total_rows['fracc']['C'] = 0;
                            $total_rows['fracc']['D'] = 0;
                            $total_rows['fracc']['E'] = 0;
                            $total_rows['fracc']['F'] = 0;
                            $total_rows['fracc']['G'] = 0;
                            $total_rows['fracc']['H'] = 0;
                        }
                        $tipo_lote = intval($v['tipoLote']);
                        $name_level_1 = (intval($v['tipoLote'])===1?'EDIFICACION':'O. COMPLEMENTARIA');
                        $objPHPExcel->getActiveSheet()->SetCellValue('B'.$rowCount, $name_level_1);
                        $row_level_1 = intval($rowCount);
                        $rowCount++;
                    }
                    if (empty($name_level_2) || $name_level_2!==$v['fraccionamiento']) {
                        if (!empty($row_level_2)) {
                            $objPHPExcel->getActiveSheet()->SetCellValue('C'.$row_level_2, number_format($total_rows['almacen']['C'],2,'.',','));
                            $objPHPExcel->getActiveSheet()->getStyle('C'.$row_level_2)->getAlignment()->setHorizontal(PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT);

                            $objPHPExcel->getActiveSheet()->SetCellValue('D'.$row_level_2, number_format($total_rows['almacen']['D'],2,'.',','));
                            $objPHPExcel->getActiveSheet()->getStyle('D'.$row_level_2)->getAlignment()->setHorizontal(PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT);

                            $objPHPExcel->getActiveSheet()->SetCellValue('E'.$row_level_2, number_format($total_rows['almacen']['E'],2,'.',','));
                            $objPHPExcel->getActiveSheet()->getStyle('E'.$row_level_2)->getAlignment()->setHorizontal(PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT);

                            $objPHPExcel->getActiveSheet()->SetCellValue('F'.$row_level_2, number_format($total_rows['almacen']['F'],2,'.',','));
                            $objPHPExcel->getActiveSheet()->getStyle('F'.$row_level_2)->getAlignment()->setHorizontal(PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT);

                            $objPHPExcel->getActiveSheet()->SetCellValue('G'.$row_level_2, number_format($total_rows['almacen']['G'],2,'.',','));
                            $objPHPExcel->getActiveSheet()->getStyle('G'.$row_level_2)->getAlignment()->setHorizontal(PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT);

                            $objPHPExcel->getActiveSheet()->SetCellValue('H'.$row_level_2, number_format($total_rows['almacen']['H'],2,'.',','));
                            $objPHPExcel->getActiveSheet()->getStyle('H'.$row_level_2)->getAlignment()->setHorizontal(PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT);

                            $total_rows['almacen']['C'] = 0;
                            $total_rows['almacen']['D'] = 0;
                            $total_rows['almacen']['E'] = 0;
                            $total_rows['almacen']['F'] = 0;
                            $total_rows['almacen']['G'] = 0;
                            $total_rows['almacen']['H'] = 0;
                        }
                        $name_level_2 = trim($v['fraccionamiento']);
                        $objPHPExcel->getActiveSheet()->SetCellValue('B'.$rowCount, $name_level_2);
                        $objPHPExcel->getActiveSheet()->getStyle('B'.$rowCount)->getAlignment()->setHorizontal(PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_LEFT)->setIndent(1);
                        $row_level_2 = intval($rowCount);
                        $rowCount++;
                    }
                    if (empty($name_level_3) || $name_level_3!==$v['nombre_almacen']) {
                        if (!empty($row_level_3)) {
                            $objPHPExcel->getActiveSheet()->SetCellValue('C'.$row_level_3, number_format($total_rows['product']['C'],2,'.',','));
                            $objPHPExcel->getActiveSheet()->getStyle('C'.$row_level_3)->getAlignment()->setHorizontal(PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT);

                            $objPHPExcel->getActiveSheet()->SetCellValue('D'.$row_level_3, number_format($total_rows['product']['D'],2,'.',','));
                            $objPHPExcel->getActiveSheet()->getStyle('D'.$row_level_3)->getAlignment()->setHorizontal(PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT);

                            $objPHPExcel->getActiveSheet()->SetCellValue('E'.$row_level_3, number_format($total_rows['product']['E'],2,'.',','));
                            $objPHPExcel->getActiveSheet()->getStyle('E'.$row_level_3)->getAlignment()->setHorizontal(PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT);

                            $objPHPExcel->getActiveSheet()->SetCellValue('F'.$row_level_3, number_format($total_rows['product']['F'],2,'.',','));
                            $objPHPExcel->getActiveSheet()->getStyle('F'.$row_level_3)->getAlignment()->setHorizontal(PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT);

                            $objPHPExcel->getActiveSheet()->SetCellValue('G'.$row_level_3, number_format($total_rows['product']['G'],2,'.',','));
                            $objPHPExcel->getActiveSheet()->getStyle('G'.$row_level_3)->getAlignment()->setHorizontal(PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT);

                            $objPHPExcel->getActiveSheet()->SetCellValue('H'.$row_level_3, number_format($total_rows['product']['H'],2,'.',','));
                            $objPHPExcel->getActiveSheet()->getStyle('H'.$row_level_3)->getAlignment()->setHorizontal(PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT);

                            $total_rows['product']['C'] = 0;
                            $total_rows['product']['D'] = 0;
                            $total_rows['product']['E'] = 0;
                            $total_rows['product']['F'] = 0;
                            $total_rows['product']['G'] = 0;
                            $total_rows['product']['H'] = 0;
                        }
                        $name_level_3 = trim($v['nombre_almacen']);
                        $objPHPExcel->getActiveSheet()->SetCellValue('B'.$rowCount, $name_level_3);
                        $objPHPExcel->getActiveSheet()->getStyle('B'.$rowCount)->getAlignment()->setHorizontal(PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_LEFT)->setIndent(2);
                        $row_level_3 = intval($rowCount);
                        $rowCount++;

                    }
                    // $objPHPExcel->getActiveSheet()->SetCellValue('B'.$rowCount, $v['id_articulo'] . ' - ' . $v['articulo']);
                    $objPHPExcel->getActiveSheet()->SetCellValue('B'.$rowCount, $v['articulo']);
                    $objPHPExcel->getActiveSheet()->getStyle('B'.$rowCount)->getAlignment()->setHorizontal(PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_LEFT)->setIndent(3);

                    $objPHPExcel->getActiveSheet()->SetCellValue('C'.$rowCount, $v['unidades_ppto']??0);
                    $objPHPExcel->getActiveSheet()->getStyle('C'.$rowCount)->getAlignment()->setHorizontal(PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT);
                    $total_rows['product']['C'] += floatval( $v['unidades_ppto'] );
                    $total_rows['almacen']['C'] += floatval( $v['unidades_ppto'] );
                    $total_rows['fracc']['C'] += floatval( $v['unidades_ppto'] );
                    $total_rows['tipo_lote']['C'] += floatval( $v['unidades_ppto'] );
                    $total_rows['total']['C'] += floatval( $v['unidades_ppto'] );

                    $objPHPExcel->getActiveSheet()->SetCellValue('D'.$rowCount, $v['unidades_drc']??0);
                    $objPHPExcel->getActiveSheet()->getStyle('D'.$rowCount)->getAlignment()->setHorizontal(PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT);
                    $total_rows['product']['D'] += floatval( $v['unidades_drc']??0 );
                    $total_rows['almacen']['D'] += floatval( $v['unidades_drc']??0 );
                    $total_rows['fracc']['D'] += floatval( $v['unidades_drc']??0 );
                    $total_rows['tipo_lote']['D'] += floatval( $v['unidades_drc']??0 );
                    $total_rows['total']['D'] += floatval( $v['unidades_drc']??0 );

                    $objPHPExcel->getActiveSheet()->SetCellValue('E'.$rowCount, ($v['unidades_ppto'] - $v['unidades_drc']));
                    $objPHPExcel->getActiveSheet()->getStyle('E'.$rowCount)->getAlignment()->setHorizontal(PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT);
                    $total_rows['product']['E'] += floatval( ($v['unidades_ppto'] - $v['unidades_drc']) );
                    $total_rows['almacen']['E'] += floatval( ($v['unidades_ppto'] - $v['unidades_drc']) );
                    $total_rows['fracc']['E'] += floatval( ($v['unidades_ppto'] - $v['unidades_drc']) );
                    $total_rows['tipo_lote']['E'] += floatval( ($v['unidades_ppto'] - $v['unidades_drc']) );
                    $total_rows['total']['E'] += floatval( ($v['unidades_ppto'] - $v['unidades_drc']) );

                    $objPHPExcel->getActiveSheet()->SetCellValue('F'.$rowCount, number_format($v['importe_ppto'],2,'.',','));
                    $objPHPExcel->getActiveSheet()->getStyle('F'.$rowCount)->getAlignment()->setHorizontal(PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT);
                    $total_rows['product']['F'] += floatval( $v['importe_ppto'] );
                    $total_rows['almacen']['F'] += floatval( $v['importe_ppto'] );
                    $total_rows['fracc']['F'] += floatval( $v['importe_ppto'] );
                    $total_rows['tipo_lote']['F'] += floatval( $v['importe_ppto'] );
                    $total_rows['total']['F'] += floatval( $v['importe_ppto'] );

                    $objPHPExcel->getActiveSheet()->SetCellValue('G'.$rowCount, $v['importe_drc']??'-');
                    $objPHPExcel->getActiveSheet()->getStyle('G'.$rowCount)->getAlignment()->setHorizontal(PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT);
                    $total_rows['product']['G'] += floatval( ($v['importe_drc']??0) );
                    $total_rows['almacen']['G'] += floatval( ($v['importe_drc']??0) );
                    $total_rows['fracc']['G'] += floatval( ($v['importe_drc']??0) );
                    $total_rows['tipo_lote']['G'] += floatval( ($v['importe_drc']??0) );
                    $total_rows['total']['G'] += floatval( ($v['importe_drc']??0) );

                    $objPHPExcel->getActiveSheet()->SetCellValue('H'.$rowCount, number_format($v['importe_ppto'] - ($v['importe_drc']??0),2,'.',','));
                    $objPHPExcel->getActiveSheet()->getStyle('H'.$rowCount)->getAlignment()->setHorizontal(PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT);
                    $total_rows['product']['H'] += floatval( ($v['importe_ppto'] - ($v['importe_drc']??0)) );
                    $total_rows['almacen']['H'] += floatval( ($v['importe_ppto'] - ($v['importe_drc']??0)) );
                    $total_rows['fracc']['H'] += floatval( ($v['importe_ppto'] - ($v['importe_drc']??0)) );
                    $total_rows['tipo_lote']['H'] += floatval( ($v['importe_ppto'] - ($v['importe_drc']??0)) );
                    $total_rows['total']['H'] += floatval( ($v['importe_ppto'] - ($v['importe_drc']??0)) );

                    $rowCount++;
                }

                $objPHPExcel->getActiveSheet()->SetCellValue('C'.$row_level_2, number_format($total_rows['almacen']['C'],2,'.',','));
                $objPHPExcel->getActiveSheet()->getStyle('C'.$row_level_2)->getAlignment()->setHorizontal(PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT);
                $objPHPExcel->getActiveSheet()->SetCellValue('D'.$row_level_2, number_format($total_rows['almacen']['D'],2,'.',','));
                $objPHPExcel->getActiveSheet()->getStyle('D'.$row_level_2)->getAlignment()->setHorizontal(PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT);
                $objPHPExcel->getActiveSheet()->SetCellValue('E'.$row_level_2, number_format($total_rows['almacen']['E'],2,'.',','));
                $objPHPExcel->getActiveSheet()->getStyle('E'.$row_level_2)->getAlignment()->setHorizontal(PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT);
                $objPHPExcel->getActiveSheet()->SetCellValue('F'.$row_level_2, number_format($total_rows['almacen']['F'],2,'.',','));
                $objPHPExcel->getActiveSheet()->getStyle('F'.$row_level_2)->getAlignment()->setHorizontal(PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT);
                $objPHPExcel->getActiveSheet()->SetCellValue('G'.$row_level_2, number_format($total_rows['almacen']['G'],2,'.',','));
                $objPHPExcel->getActiveSheet()->getStyle('G'.$row_level_2)->getAlignment()->setHorizontal(PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT);
                $objPHPExcel->getActiveSheet()->SetCellValue('H'.$row_level_2, number_format($total_rows['almacen']['H'],2,'.',','));
                $objPHPExcel->getActiveSheet()->getStyle('H'.$row_level_2)->getAlignment()->setHorizontal(PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT);

                $objPHPExcel->getActiveSheet()->SetCellValue('C'.$row_level_3, number_format($total_rows['product']['C'],2,'.',','));
                $objPHPExcel->getActiveSheet()->getStyle('C'.$row_level_3)->getAlignment()->setHorizontal(PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT);
                $objPHPExcel->getActiveSheet()->SetCellValue('D'.$row_level_3, number_format($total_rows['product']['D'],2,'.',','));
                $objPHPExcel->getActiveSheet()->getStyle('D'.$row_level_3)->getAlignment()->setHorizontal(PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT);
                $objPHPExcel->getActiveSheet()->SetCellValue('E'.$row_level_3, number_format($total_rows['product']['E'],2,'.',','));
                $objPHPExcel->getActiveSheet()->getStyle('E'.$row_level_3)->getAlignment()->setHorizontal(PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT);
                $objPHPExcel->getActiveSheet()->SetCellValue('F'.$row_level_3, number_format($total_rows['product']['F'],2,'.',','));
                $objPHPExcel->getActiveSheet()->getStyle('F'.$row_level_3)->getAlignment()->setHorizontal(PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT);
                $objPHPExcel->getActiveSheet()->SetCellValue('G'.$row_level_3, number_format($total_rows['product']['G'],2,'.',','));
                $objPHPExcel->getActiveSheet()->getStyle('G'.$row_level_3)->getAlignment()->setHorizontal(PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT);
                $objPHPExcel->getActiveSheet()->SetCellValue('H'.$row_level_3, number_format($total_rows['product']['H'],2,'.',','));
                $objPHPExcel->getActiveSheet()->getStyle('H'.$row_level_3)->getAlignment()->setHorizontal(PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT);


                $objPHPExcel->getActiveSheet()->SetCellValue('C'.$rowCount, number_format($total_rows['total']['C'],2,'.',','));
                $objPHPExcel->getActiveSheet()->getStyle('C'.$rowCount)->getAlignment()->setHorizontal(PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT);
                $objPHPExcel->getActiveSheet()->getStyle('C'.$rowCount)->getFont()->setBold(true);

                $objPHPExcel->getActiveSheet()->SetCellValue('D'.$rowCount, number_format($total_rows['total']['D'],2,'.',','));
                $objPHPExcel->getActiveSheet()->getStyle('D'.$rowCount)->getAlignment()->setHorizontal(PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT);
                $objPHPExcel->getActiveSheet()->getStyle('D'.$rowCount)->getFont()->setBold(true);

                $objPHPExcel->getActiveSheet()->SetCellValue('E'.$rowCount, number_format($total_rows['total']['E'],2,'.',','));
                $objPHPExcel->getActiveSheet()->getStyle('E'.$rowCount)->getAlignment()->setHorizontal(PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT);
                $objPHPExcel->getActiveSheet()->getStyle('E'.$rowCount)->getFont()->setBold(true);

                $objPHPExcel->getActiveSheet()->SetCellValue('F'.$rowCount, number_format($total_rows['total']['F'],2,'.',','));
                $objPHPExcel->getActiveSheet()->getStyle('F'.$rowCount)->getAlignment()->setHorizontal(PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT);
                $objPHPExcel->getActiveSheet()->getStyle('F'.$rowCount)->getFont()->setBold(true);

                $objPHPExcel->getActiveSheet()->SetCellValue('G'.$rowCount, number_format($total_rows['total']['G'],2,'.',','));
                $objPHPExcel->getActiveSheet()->getStyle('G'.$rowCount)->getAlignment()->setHorizontal(PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT);
                $objPHPExcel->getActiveSheet()->getStyle('G'.$rowCount)->getFont()->setBold(true);

                $objPHPExcel->getActiveSheet()->SetCellValue('H'.$rowCount, number_format($total_rows['total']['H'],2,'.',','));
                $objPHPExcel->getActiveSheet()->getStyle('H'.$rowCount)->getAlignment()->setHorizontal(PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT);
                $objPHPExcel->getActiveSheet()->getStyle('H'.$rowCount)->getFont()->setBold(true);

                $objPHPExcel->getActiveSheet()->SetCellValue('B'.$rowCount, 'Total Result');#setBold
                $objPHPExcel->getActiveSheet()->getStyle('B'.$rowCount)->getFont()->setBold(true);

                $objPHPExcel->getActiveSheet()->getStyle('B9:H'.$rowCount)->getBorders()->getTop()->setBorderStyle(\PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN);
                $objPHPExcel->getActiveSheet()->getStyle('B9:H'.$rowCount)->getBorders()->getBottom()->setBorderStyle(\PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN);
                $objPHPExcel->getActiveSheet()->getStyle('B9:H'.$rowCount)->getBorders()->getLeft()->setBorderStyle(\PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN);
                $objPHPExcel->getActiveSheet()->getStyle('B9:H'.$rowCount)->getBorders()->getRight()->setBorderStyle(\PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN);

                foreach ($objPHPExcel->getActiveSheet()->getColumnIterator() as $column) {
                    $objPHPExcel->getActiveSheet()->getColumnDimension($column->getColumnIndex())->setAutoSize(true);
                }
                $objPHPExcel->getActiveSheet()->getColumnDimension('B')->setWidth(15);
            }
        }

        header('Content-Type: application/vnd.ms-excel');
        header('Content-Disposition: attachment;filename="' . $name_excel . '_' . date('Ymd') . '.xlsx"');
        header('Cache-Control: max-age=0'); //no cache
        $objWriter = PhpOffice\PhpSpreadsheet\IOFactory::createWriter($objPHPExcel, 'Xlsx');
        // Forzamos a la descarga
        $objWriter->save('php://output');
    }
}

if ( !function_exists('toNumber')) {
    function toNumber($number,$moneda=true){
        $result=0;
        if(is_numeric($number)){   
            $result=number_format($number,2);
        }else{
            $result=number_format(0,2);
        }
        $result=($moneda) ? "$".$result : $result;
        return $result;
    }
}

if ( !function_exists('getApiColumns')) {
    function getApiColumns($table,$alias){
        $tables=[
            "actividadesprototipo" => 
            ["id",
            "idPrototipo",
            "idCategoria",
            "idActividad",
            "cantidad",
            "tipo",
            "semana",
            "status",
            "created",
            "updated",
            "created_by",
            "updated_by",
            ],
            "actividades_mo" => 
            ["id",
            "idUnidad",
            "idCategoria",
            "idSubCategoria",
            "clave",
            "programa",
            "descripcion",
            "precioUnitario",
            "precioUnitarioContratista",
            "precioUnitarioDestajista",
            "status",
            "created",
            "updated",
            "created_by",
            "updated_by",
            ],
            "ajustes" => 
            ["id",
            "idProyecto",
            "idPaquete",
            "idPresupuesto",
            "cantidad",
            "precioUnitario",
            "tipo",
            "tipoPpto",
            "status",
            "created",
            "updated",
            "created_by",
            "updated_by",
            ],
            "arranque" => 
            ["id",
            "titulo",
            "fecha_fin",
            "fechaFirma",
            "idSupervisor",
            "retencionfg",
            "fecha_inicio",
            "numeroContrato",
            "idPaquetes",
            "estatus_arranque",
            "ronda",
            "status",
            "created",
            "updated",
            "created_by",
            "updated_by",
            ],
            "avanceobra" => 
            ["id",
            "idEstimado",
            "lotes",
            "avanceC",
            "dia_lotes",
            "iniciado",
            "calidad",
            "assets",
            "status",
            "created",
            "updated",
            "created_by",
            "updated_by",
            ],
            "categorias_mo" => 
            ["id",
            "clave",
            "categoria",
            "status",
            "created",
            "updated",
            "created_by",
            "updated_by",
            ],
            "constructores" => 
            ["id",
            "tipoConstructor",
            "nombre",
            "apellidoP",
            "apellidoM",
            "retencion",
            "rfc",
            "domicilioFiscal",
            "status",
            "created",
            "updated",
            "created_by",
            "updated_by",
            ],
            "detalle_paquete" => 
            ["id",
            "idPaquete",
            "idProyecto",
            "idResidente",
            "idInspector",
            "idCoordinador",
            "idCoordinadorC",
            "rango_lotes",
            "statusAsignado",
            "status",
            "created",
            "updated",
            "created_by",
            "updated_by",
            ],
            "estimaciones_programa" => 
            ["id",
            "idEstimacion",
            "nEstimacion",
            "fecha",
            "tipo",
            "status",
            "created",
            "updated",
            "created_by",
            "updated_by",
            ],
            "estimacion_programa" => 
            ["id",
            "idFraccionamiento",
            "idPrototipo",
            "idPaquete",
            "status",
            "created",
            "updated",
            "created_by",
            "updated_by",
            ],
            "estimados_programa" => 
            ["id",
            "idPresupuesto",
            "idEstimaciones",
            "estimacion",
            "estimados_dia",
            "estimacionC",
            "status",
            "created",
            "updated",
            "created_by",
            "updated_by",
            ],
            "fraccionamientos" => 
            ["id",
            "titulo",
            "estado",
            "municipio",
            "colonia",
            "cp",
            "foto",
            "thumbnail",
            "status",
            "created",
            "updated",
            "created_by",
            "updated_by",
            ],
            "mano_obra" => 
            ["id",
            "idFraccionamiento",
            "idPrototipo",
            "idPaquete",
            "titulo",
            "status",
            "created",
            "updated",
            "created_by",
            "updated_by",
            ],
            "paquetes" => 
            ["id",
            "idFraccionamiento",
            "idPrototipo",
            "idManoObra",
            "idConstructor",
            "idResidentes",
            "titulo",
            "fecha_inicio",
            "fecha_fin",
            "nLotes",
            "rango_lotes",
            "manzana",
            "porcentaje_retencion",
            "anticipo",
            "porcentaje_rvicios",
            "ronda",
            "carta",
            "statusPaquete",
            "fecha_inicio_real",
            "tipo",
            "tipoEstimacion",
            "tipoLote",
            "pdf",
            "pdf_1",
            "pdf_2",
            "status",
            "created",
            "updated",
            "created_by",
            "updated_by",
            ],
            "paquete_presupuesto" => 
            ["id",
            "idPaquete",
            "idPresupuestoMO",
            "lotesCompletados",
            "lotes",
            "acumulado",
            "lotesI",
            "status",
            "created",
            "updated",
            "created_by",
            "updated_by",
            ],
            "presupuesto_mo" => 
            ["id",
            "idManoObra",
            "idActividadPrototipo",
            "precioUnitario",
            "importe",
            "pctjeActividad",
            "lotesCompletados",
            "tipo",
            "status",
            "created",
            "updated",
            "created_by",
            "updated_by",
            ],
            "programa_obra" => 
            ["id",
            "idPaquete",
            "idPresupuesto",
            "idProyecto",
            "semana",
            "lote",
            "manzana",
            "status",
            "created",
            "updated",
            "created_by",
            "updated_by",
            ],
            "prototipos" => 
            ["id",
            "nombre",
            "estimaciones",
            "superficieM2",
            "costoCimentacion",
            "avanceCimentacion",
            "costoAlbPlantaBaja",
            "avanceAlbPlantaBaja",
            "costoLosaEntrepiso",
            "avanceLosaEntrepiso",
            "costoAlbPrimerNivel",
            "avanceAlbPrimerNivel",
            "costoLosaPrimerNivel",
            "avanceLosaPrimerNivel",
            "costoAzotea",
            "avanceAzotea",
            "costoFachada",
            "avanceFachada",
            "costoAcabados",
            "avanceAcabados",
            "costoPisos",
            "avancePisos",
            "costoInstHidroGas",
            "avanceInstHidroGas",
            "costoCanceleria",
            "avanceCanceleria",
            "costoElectrica",
            "avanceElectrica",
            "costoObraExterior",
            "avanceObraExterior",
            "costoBardas",
            "avanceBardas",
            "costoLimpieza",
            "avanceLimpieza",
            "costoExtra",
            "avanceExtra",
            "costoImpermeabilizacion",
            "avanceImpermeabilizacion",
            "costoEcotecnologias",
            "avanceEcotecnologias",
            "pdf_1",
            "status",
            "created",
            "updated",
            "created_by",
            "updated_by",
            ],
            "proyectos" => 
            ["id",
            "idFraccionamiento",
            "idPrototipo",
            "folioAvaluo",
            "numPaquete",
            "lote",
            "manzana",
            "calle",
            "nOficial",
            "numeroInterior",
            "cuv",
            "claveCatastral",
            "supTerreno",
            "supConstruccion",
            "precioVenta",
            "statusProyecto",
            "puntaje",
            "porcentajeAvance",
            "costoAvance",
            "checkAvance",
            "contratista",
            "avaluo",
            "unidadVerificadora",
            "fechaVencimiento",
            "fechaDtu",
            "statusAlertDTU",
            "lineaCredito",
            "tipoVialidad",
            "nombreVialidad",
            "nivel",
            "estacionamiento",
            "tipoPrimeraVialidad",
            "primeraEntreVialidad",
            "tipoSegundaVialidad",
            "segundaEntreVialidad",
            "tipoVialidadPosterior",
            "nombreVialidadPosterior",
            "metrosFrente",
            "orientacion",
            "statusVenta",
            "statusObra",
            "tipoLote",
            "status",
            "created",
            "updated",
            "created_by",
            "updated_by",
            ],
            "unidades" => 
            ["id",
            "unidad",
            "abreviatura",
            "status",
            "created",
            "updated",
            "created_by",
            "updated_by",
            ],
            "usuarios" => 
            ["id",
            "rol",
            "usuario",
            "password",
            "nombre",
            "apellidoP",
            "apellidoM",
            "email",
            "rfc",
            "curp",
            "calle",
            "colonia",
            "ciudad",
            "telFijo",
            "celular",
            "tipoPromotor",
            "comision",
            "fechaIngreso",
            "motivoBaja",
            "statusBaja",
            "status",
            "created",
            "updated",
            "created_by",
            "updated_by",
            ]
        ];
        if(isset($tables[$table])){
            return "$alias.".implode(",$alias.", $tables[$table]);
        }else{
            return 0;
        }
    }
}