<?php
if ( ! defined('BASEPATH')) exit('No direct script access allowed');
date_default_timezone_set('America/Mexico_City');
class Webapi extends MX_Controller {
    public $data,$vParameters,$mainView,$fv,$ret;

    public function __construct() {
        // Modelos
        $this->port=$this->config->item('dnsmicro');
        $this->load->library("curl");
        ini_set('max_execution_time', 0);
        $this->un=2;
    }

    public function index($id = null) {
        $data["msg"]="test";
        $this->data['contenido'] = $this->load->view($this->mainView.'/index_view',$data,true);
        $this->load->view('templates/main_template',$this->data);
    }
    
    public function getAlmacenes(){
        $curl = curl_init();
        //INFORMACION A ENVIAR POR POST EN FORMATO JSON
        $datos = json_encode(array("un" => $this->un));
        curl_setopt_array($curl, array(
            CURLOPT_PORT => $this->port,
            CURLOPT_URL => $this->config->item('dnsmicro')."GetAlmacenes",
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => "",
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 30000,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => "POST",
            CURLOPT_SSL_VERIFYPEER => false,
            CURLOPT_FOLLOWLOCATION => 1,
            CURLOPT_POSTFIELDS => $datos,
            CURLOPT_HTTPHEADER => array(
                "cache-control: no-cache",
                "postman-token: ab5bf890-47c6-d504-ba8f-82667b58bebd",
                'Content-Type:application/json'
            ),
        ));
        $response = curl_exec($curl);
        $err = curl_error($curl);

        $json = [];
        if ($err) {
            echo "cURL Error #:" . $err;
        }else{
            $json = $response;
            // Comprueba el código de estado HTTP
            if (!curl_errno($curl)) {
              switch ($http_code = curl_getinfo($curl, CURLINFO_HTTP_CODE)) {
                case 200:
                    $json = json_decode($json);
                    echo "<pre>";
                    print_r($json);
                    echo "</pre>";
                    break;
                case 404:
                    echo "Not found";
                    break;
                default:
                    echo 'Unexpected HTTP code: ', $http_code, "\n";
              }
            }
        }
        curl_close($curl);
    }

    public function getProveedores(){
        $curl = curl_init();
        //INFORMACION A ENVIAR POR POST EN FORMATO JSON
        $datos = json_encode(array("un" => $this->un));
        curl_setopt_array($curl, array(
            CURLOPT_PORT => $this->port,
            CURLOPT_URL => $this->config->item('dnsmicro')."GetProveedores",
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => "",
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 30000,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => "POST",
            CURLOPT_SSL_VERIFYPEER => false,
            CURLOPT_FOLLOWLOCATION => 1,
            CURLOPT_POSTFIELDS => $datos,
            CURLOPT_HTTPHEADER => array(
                "cache-control: no-cache",
                "postman-token: ab5bf890-47c6-d504-ba8f-82667b58bebd",
                'Content-Type:application/json'
            ),
        ));
        $response = curl_exec($curl);
        $err = curl_error($curl);

        $json = [];
        if ($err) {
            echo "cURL Error #:" . $err;
        }else{
            $json = $response;
            // Comprueba el código de estado HTTP
            if (!curl_errno($curl)) {
              switch ($http_code = curl_getinfo($curl, CURLINFO_HTTP_CODE)) {
                case 200:
                    $json = json_decode($json);
                    echo "<pre>";
                    print_r($json);
                    echo "</pre>";
                    break;
                case 404:
                    echo "Not found";
                    break;
                default:
                    echo 'Unexpected HTTP code: ', $http_code, "\n";
              }
            }
        }
        curl_close($curl);
    }

    public function getArticulos(){
        $curl = curl_init();
        //INFORMACION A ENVIAR POR POST EN FORMATO JSON
        $datos=array('un' => $this->un);
        $datos = json_encode($datos);

        curl_setopt_array($curl, array(
            CURLOPT_PORT => $this->port,
            CURLOPT_URL => $this->config->item('dnsmicro')."GetArticulos",
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => "",
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 30000,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => "POST",
            CURLOPT_SSL_VERIFYPEER => false,
            CURLOPT_FOLLOWLOCATION => 1,
            CURLOPT_POSTFIELDS => $datos,
            CURLOPT_HTTPHEADER => array(
                "cache-control: no-cache",
                "postman-token: ab5bf890-47c6-d504-ba8f-82667b58bebd",
                'Content-Type:application/json'
            ),
        ));
        $response = curl_exec($curl);
        $err = curl_error($curl);

        $json = [];
        if ($err) {
            echo "cURL Error #:" . $err;
        }else{
            $json = $response;
            // Comprueba el código de estado HTTP
            if (!curl_errno($curl)) {
              switch ($http_code = curl_getinfo($curl, CURLINFO_HTTP_CODE)) {
                case 200:
                    $json = json_decode($json);
                    echo "<pre>";
                    print_r($json);
                    echo "</pre>";
                    break;
                case 404:
                    echo "Not found";
                    break;
                default:
                    echo 'Unexpected HTTP code: ', $http_code, "\n";
              }
            }
        }
        curl_close($curl);
    }    

    public function getOrdenesCompra(){
        $curl = curl_init();
        //INFORMACION A ENVIAR POR POST EN FORMATO JSON
        $datos=array('un' => $this->un, 'bundle' => array('estatus' => 0));
        $datos = json_encode($datos);

        curl_setopt_array($curl, array(
            CURLOPT_PORT => $this->port,
            CURLOPT_URL => $this->config->item('dnsmicro')."GetOrdenesCompra",
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => "",
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 30000,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => "POST",
            CURLOPT_SSL_VERIFYPEER => false,
            CURLOPT_FOLLOWLOCATION => 1,
            CURLOPT_POSTFIELDS => $datos,
            CURLOPT_HTTPHEADER => array(
                "cache-control: no-cache",
                "postman-token: ab5bf890-47c6-d504-ba8f-82667b58bebd",
                'Content-Type:application/json'
            ),
        ));
        $response = curl_exec($curl);
        $err = curl_error($curl);

        $json = [];
        if ($err) {
            echo "cURL Error #:" . $err;
        }else{
            $json = $response;
            // Comprueba el código de estado HTTP
            if (!curl_errno($curl)) {
              switch ($http_code = curl_getinfo($curl, CURLINFO_HTTP_CODE)) {
                case 200:
                    $json = json_decode($json);
                    echo "<pre>";
                    print_r($json);
                    echo "</pre>";
                    break;
                case 404:
                    echo "Not found";
                    break;
                default:
                    echo 'Unexpected HTTP code: ', $http_code, "\n";
              }
            }
        }
        curl_close($curl);
    } 

    public function getOrdenCompra(){
        $curl = curl_init();
        //INFORMACION A ENVIAR POR POST EN FORMATO JSON
        $datos=array($this->un, 'id_orden_compra' => 350809);
        $datos = json_encode($datos);

        curl_setopt_array($curl, array(
            CURLOPT_PORT => $this->port,
            CURLOPT_URL => $this->config->item('dnsmicro')."GetOrdenCompra",
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => "",
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 30000,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => "POST",
            CURLOPT_SSL_VERIFYPEER => false,
            CURLOPT_FOLLOWLOCATION => 1,
            CURLOPT_POSTFIELDS => $datos,
            CURLOPT_HTTPHEADER => array(
                "cache-control: no-cache",
                "postman-token: ab5bf890-47c6-d504-ba8f-82667b58bebd",
                'Content-Type:application/json'
            ),
        ));
        $response = curl_exec($curl);
        $err = curl_error($curl);

        $json = [];
        if ($err) {
            echo "cURL Error #:" . $err;
        }else{
            $json = $response;
            // Comprueba el código de estado HTTP
            if (!curl_errno($curl)) {
              switch ($http_code = curl_getinfo($curl, CURLINFO_HTTP_CODE)) {
                case 200:
                    $json = json_decode($json);
                    echo "<pre>";
                    print_r($json);
                    echo "</pre>";
                    break;
                case 404:
                    echo "Not found";
                    break;
                default:
                    echo 'Unexpected HTTP code: ', $http_code, "\n";
              }
            }
        }
        curl_close($curl);
    }

}