<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Vehiculos extends MX_Controller {
    public $data,$vParameters,$mainView,$fv,$allowed;
    public function __construct(){
    $this->nsession = $this->config->item('nsession');
    if (!isset($_SESSION[$this->nsession]) || (($_SESSION[$this->nsession]['usuario'] == ""))) redirect('login');
            $this->fv = 'vehiculos'; // form validation variable
            $this->mainView = 'vehiculos';
            $this->data['fjs'] = '';
            $this->data['js'] = '';
            $this->data['css'] = '';
            // Tools
            $this->load->helper(array('tools','url','form','date','text','security'));
            // Modelos
            $this->load->model(array('mactivos','musuario','mmantenimientovehiculo','mcartaasignacion'));
            // Vehiculos
            $this->data['fotos_www'] = $this->config->item('base_www').'/vehiculos/';
            // Lbrerias
            // $this->load->library(array('email','session'));
            //$this->data['fotos_www'] = $this->config->item('base_www').'/inicio/';
           // $this->data['fotos_www'] = '/home/puntapro/www/uploads/inicio/';
           $this->allowed=permisos("administracion",$this->fv);
           //Validación de usuarios
	        valSession("administracion",$this->fv);
    }

    public function index(){
        $this->data['js'] .= ' <script src="assets/js/vehiculos/listado.js" type="text/javascript"></script>';
        $data['allowed'] = $this->allowed;
        $data['q'] = '';
        $this->data['contenido'] = $this->load->view($this->mainView.'/index_view',$data,true);
        $this->load->view('templates/main_template',$this->data);
    }

    public function listado(){
        $q = $this->mactivos->getAll(4);

        if (!is_numeric($q)){
            $diasFaltantes = '';
            $proximoM = '';
            //$txtStatus = "";
            foreach ($q->result() as $row){
                $txtStatus = '';
                $rmVehiculo = $this->mmantenimientovehiculo->getByIdV($row->id);//ultimo registro agregado en mantenimeinto_vehiculo (el estatus puede ser 0,1,2,3)
                $ultimoMHecho = $this->mmantenimientovehiculo->getByIdV($row->id,1); // ultimo registro en mantxvehiculo con ststusMant = 1
                $fechaM = (!is_numeric($ultimoMHecho))?$ultimoMHecho['fecha']:'';
                $statusMantenimiento = (!is_numeric($rmVehiculo))?$rmVehiculo['statusMantenimiento']:'';
                if (!is_numeric($ultimoMHecho)){
                    $inicio = strtotime(date('Y-m-d'));
                    //$fin = strtotime($ultimoMHecho['fecha']);
                    $fin = date('Y-m-d',strtotime($ultimoMHecho['fecha'] . " +$row->diasMantenimiento day"));
                    $fin = strtotime($fin);
                    $dif = $fin - $inicio;
                    $diasFalt = (( ( $dif / 60 ) / 60 ) / 24);
                    $diasFaltantes = ceil($diasFalt);

                    $proximoM = date('d/m/Y',strtotime($ultimoMHecho['fecha'] . " +$row->diasMantenimiento day"));
                }
                if($statusMantenimiento!=''){
                    $disabled = ($statusMantenimiento==1)?'disabled="disabled"':'';
                    $checkedM = ($statusMantenimiento==1)?'checked="checked"':'';
                    $txtCheck = ($statusMantenimiento==1)?'SI':'NO';
                    $valorChk = ($statusMantenimiento==1)?1:0;
                    $checkM = '<div style="text-align:center;">
                                        <label class="mt-checkbox mt-checkbox-outline">'.$txtCheck.'
                                            <input onclick="modalFinalizar('.$rmVehiculo['id'].')" type="checkbox" data-idM="'.$rmVehiculo['id'].'" id="chk_'.$rmVehiculo['id'].'" value="'.$valorChk.'" name="mantenimiento" '.$disabled.' '.$checkedM.' />
                                            <span></span>
                                        </label>
                                    </div>
                                    ';
                }else{
                    $checkM = '';
                }
                //Mostramos los estatus de cada vehiculo
                if($statusMantenimiento==1){ // sin retraso, en tiempo
                    $txtStatus = '<div class="label label-sm bg-ok">Ok</div>';
                }elseif($statusMantenimiento==2){ // con retraso
                    $txtStatus = '<div class="label label-sm bg-ft">Fuera de tiempo</div>';
                }elseif(is_numeric($diasFaltantes) && $diasFaltantes!=0 && $diasFaltantes<=31){ // se aproxima la fecha
                    $txtStatus = '<div class="label label-sm bg-prox">Próximo</div>';
                }elseif(is_numeric($diasFaltantes) && $diasFaltantes==0){ // se aproxima la fecha
                    $txtStatus = '<div class="label label-sm bg-prox">Hoy es el día</div>';
                }

                $array['aaData'][] = array(
                    'marca' => "<a href='vehiculos/historial/$row->id/$diasFaltantes'>".$row->marca."</a>",
                    'serie' => strtoupper($row->serie),
                    'modelo' => strtoupper($row->modelo),
                    'inventarioInterno' => $row->inventarioInterno,
                    'anio' => $row->anio,
                    'placas' => strtoupper($row->placas),
                    'vigenciaPoliza' => date_format(new DateTime($row->vigenciaPoliza),"d-m-Y"),
                    'diasMantenimiento' => $row->diasMantenimiento." dias",
                    'fechaUM' => ($fechaM!='' && $fechaM!='0000-00-00')?date('d/m/Y',strtotime($fechaM)):'',
                    'proximoM' => $proximoM,
                    'diasFaltantes' => $diasFaltantes,
                    'realizado' => $checkM,
                    'txtstatus' => strtoupper($txtStatus),
                    'acciones' => acciones($row->id,$this->router->class,false,true,false),

                    );
            }
        }else{
            $array['aaData'][] = array(
                'marca' => 'No hay registros',
                'serie' => 'No hay registros',
                'modelo' => 'No hay registros',
                'inventarioInterno' => 'No hay registros',
                'anio' => 'No hay registros',
                'placas' => 'No hay registros',
                'vigenciaPoliza' => 'No hay registros',
                'diasMantenimiento' => 'No hay registros',
                'diasFaltantes' => 'No hay registros',
                'fechaUM' => 'No hay registros',
                'proximoM' => 'No hay registros',
                'realizado' => 'No hay registros',
                'txtstatus' => 'No hay registros',
                'acciones' => 'No hay registros'
                );
        }

        echo json_encode($array);
    }

    public function listado2(){
        $id = $_GET['idVehiculo'];
        $diasF = $_GET['diasF'];
        $q = $this->mmantenimientovehiculo->getAllByIdV($id);
        
        $diasFaltantes = $diasF; //para el mantenimeinto proximo obtenemos los días faltantes
        if (!is_numeric($q)){
            foreach ($q->result() as $row){
                $txtStatus = '';
                //Mostramos los estatus de cada vehiculo
                if($row->statusMantenimiento==1){ // sin retraso, en tiempo
                    $txtStatus = '<div class="label label-sm bg-ok">Ok</div>';
                }elseif($row->statusMantenimiento==2){ // con retraso
                    $txtStatus = '<div class="label label-sm bg-ft">Fuera de tiempo</div>';
                }elseif(is_numeric($diasFaltantes) && $diasFaltantes!=0 && $diasFaltantes<=31){ // se aproxima la fecha
                    $txtStatus = '<div class="label label-sm bg-prox">Próximo</div>';
                }elseif(is_numeric($diasFaltantes) && $diasFaltantes==0){ // se aproxima la fecha
                    $txtStatus = '<div class="label label-sm bg-prox">Hoy es el día</div>';
                }else{
                    //$txtStatus = $diasFaltantes;
                }
                $array['aaData'][] = array(
                    'nombre' => $this->mactivos->getCampo('marca',$id),
                    'descripcion' => $row->descripcion,
                    'fecha' => ($row->fecha!='' && $row->fecha!='0000-00-00')?date('d/m/Y',strtotime($row->fecha)):'',
                    'txtstatus' => $txtStatus,//($row->statusMantenimiento==1)?'Realizado':'No se ha realizado',
                    'acciones' => (in_array($this->config->item('rol'), $this->allowed['r'])) ?  acciones($row->id,$this->router->class) : ""
                    );
            }
        }else{
            $array['aaData'][] = array(
                'nombre' => 'No hay registros',
                'descripcion' => 'No hay registros',
                'fecha' => 'No hay registros',
                'txtstatus' => 'No hay registros',
                'acciones' => 'No hay registros'
                );
        }
        echo json_encode($array);
    }

    public function historial($id=null){
        $this->data['js'] .= ' <script src="assets/js/vehiculos/historial.js" type="text/javascript"></script>';
        $data['msg'] = '';
        $data['historial'] = $this->mmantenimientovehiculo->getAllByIdV($id);
        //print_r($data['historial']->result());
        //exit();

        $this->data['contenido'] = $this->load->view($this->mainView . '/historial_view', $data, true);
        $this->load->view('templates/main_template', $this->data);
    }

    public function nuevo()
    {
        // Mensajes
        $data['msg'] = '';

        $this->load->library('form_validation');
        if ($this->form_validation->run($this->fv) == FALSE) {
            $data['msg'] = validation_errors();

            $this->data['contenido'] = $this->load->view($this->mainView . '/nuevo_view', $data, true);
            $this->load->view('templates/main_template', $this->data);
        }else{
            // Subida de pdf
            $config = array();
            $this->load->library('upload', $config);

            if (isset($_FILES)){
                $imagenes = array();
                foreach($_FILES as $key=>$value){
                    if ($_FILES[$key]['size'] > 0){
                        $_FILES[$key]['name'] = strtolower($_FILES[$key]['name']);
                        $imagenes[] = $key;
                    }
                }
                $totalImagenes = count($imagenes);

                for($i=0; $i< $totalImagenes; $i++){
                    $ext = pathinfo($_FILES[$imagenes[$i]]['name'],PATHINFO_EXTENSION);
                    //Configuracion del thumbnail
                    if($imagenes[$i]!='pdf'){
                        $nCampoC = explode("_",$imagenes[$i]);
                        $tipo = $nCampoC[0];
                        $v = $nCampoC[1];

                    } else {
                        $v = 0;
                        $tipo = 'pdf';
                    }
                    if ($tipo == 'pdf' || $tipo == 'jpg' || $tipo == 'png'){
                        //echo 'es tipo foto<br>';
                        $uploaddir = $this->data['fotos_www'];
                        //$configT['upload_path'] = $uploaddir;
                        //$configT['image_library'] = 'gd2';
                        //$configT['create_thumb'] = TRUE;
                        //$configT['maintain_ratio'] = FALSE;
                        //$configT['width'] = 150;
                        //$configT['height'] = 150;
                        //Configuracion de la libreria upload
                        $nextId = $this->mactivos->nextId();
                        $config['file_name'] =  $nextId."_".$v;
                        $config['overwrite'] = TRUE;
                        $config['upload_path'] = $uploaddir;
                        $config['max_size'] = '8000';
                        $config['allowed_types'] = 'pdf|jpg|jpeg|png|gif';
                        $this->upload->initialize($config);
                        if ( ! $this->upload->do_upload($imagenes[$i]) )
                        {
                            $redirect = 1;
                            $data['error'] = $this->upload->display_errors();
                        }
                        else
                        {
                            $contadorArchivos++;
                            $dataFile = $this->upload->data($imagenes[$i]);
                            $fotoI = 'pdf_'.$v;
                            //$thumbI = 'thumbnail_'.$v;
                            if ($v == 0){
                                //Foto default
                                $pData['pdf'] = $nextId.'_'.$v.'.'.$ext;//
                            } else {
                                $pData[$fotoI] = $nextId.'_'.$v.'.'.$ext;
                            }
                        }
                    }

                }
            }
            $pData['idActivo'] = 4;
            $pData['marca'] = $this->input->post('marca', TRUE);
            $pData['serie'] = $this->input->post('serie', TRUE);
            $pData['anio'] = $this->input->post('anio', TRUE);
            $pData['vigenciaPoliza'] = date_format(new DateTime($this->input->post('vigenciaPoliza', TRUE)),'Y-m-d');
            $pData['modelo'] = $this->input->post('modelo', TRUE);
            $pData['inventarioInterno'] = $this->input->post('inventarioInterno', TRUE);
            $pData['placas'] = $this->input->post('placas', TRUE);
            $pData['diasMantenimiento'] = $this->input->post('diasMantenimiento', TRUE);
            $pData['status'] = 1;
            $id = $this->mactivos->insertar($pData);
            $mvData['idVehiculo'] = $id;
            $mvData['descripcion'] = '';
            $mvData['fecha'] = date("Y-m-d");
            $mvData['statusMantenimiento'] = 1;
            $idMV = $this->mmantenimientovehiculo->insertar($mvData);
            redirect($this->router->class);
        }

    }

    public function editar($id)
    {
        // Mensajes
        $msg = '';
        /* VALIDAR FORMULARIO*/
        $this->load->library('form_validation');

        if (isset($_POST['marca'])) {
            if ($this->form_validation->run($this->fv) == FALSE) {
                $msg = validation_errors();
            } else {
                // Subida de pdf
                $config = array();
                $this->load->library('upload', $config);

                if (isset($_FILES)){
                    $imagenes = array();
                    foreach($_FILES as $key=>$value){
                        if ($_FILES[$key]['size'] > 0){
                            $_FILES[$key]['name'] = strtolower($_FILES[$key]['name']);
                            $imagenes[] = $key;
                        }
                    }
                    $totalImagenes = count($imagenes);

                    for($i=0; $i< $totalImagenes; $i++){
                        $ext = pathinfo($_FILES[$imagenes[$i]]['name'],PATHINFO_EXTENSION);
                        //Configuracion del thumbnail
                        if($imagenes[$i]!='pdf'){
                            $nCampoC = explode("_",$imagenes[$i]);
                            $tipo = $nCampoC[0];
                            $v = $nCampoC[1];

                        } else {
                            $v = 0;
                            $tipo = 'pdf';
                        }
                        if ($tipo == 'pdf' || $tipo == 'jpg' || $tipo == 'png'){
                            //echo 'es tipo foto<br>';
                            $uploaddir = $this->data['fotos_www'];
                            $nextId = $id;
                            $config['file_name'] =  $nextId."_".$v;
                            $config['overwrite'] = TRUE;
                            $config['upload_path'] = $uploaddir;
                            $config['max_size'] = '8000';
                            $config['allowed_types'] = 'pdf|jpg|jpeg|png|gif';
                            $this->upload->initialize($config);
                            if ( ! $this->upload->do_upload($imagenes[$i]) )
                            {
                                $redirect = 1;
                                $data['error'] = $this->upload->display_errors();
                            }
                            else
                            {
                                $contadorArchivos++;
                                $dataFile = $this->upload->data($imagenes[$i]);
                                $fotoI = 'pdf_'.$v;
                                //$thumbI = 'thumbnail_'.$v;
                                if ($v == 0){
                                    //Foto default
                                    $pData['pdf'] = $nextId.'_'.$v.'.'.$ext;//
                                } else {
                                    $pData[$fotoI] = $nextId.'_'.$v.'.'.$ext;
                                }
                            }
                        }

                    }
                }

                $pData['marca'] = $this->input->post('marca', TRUE);
                $pData['serie'] = $this->input->post('serie', TRUE);
                $pData['anio'] = $this->input->post('anio', TRUE);
                $pData['vigenciaPoliza'] = date_format(new DateTime($this->input->post('vigenciaPoliza', TRUE)),'Y-m-d');
                $pData['modelo'] = $this->input->post('modelo', TRUE);
                $pData['inventarioInterno'] = $this->input->post('inventarioInterno', TRUE);
                $pData['placas'] = $this->input->post('placas', TRUE);
                $pData['diasMantenimiento'] = $this->input->post('diasMantenimiento', TRUE);
                $pData['status'] =$this->input->post('status',TRUE);
                if ($pData['status'] == 0){
                    $validaAsignacion = $this->mcartaasignacion->getByIdActivo($id);
                    if(!is_numeric($validaAsignacion)){
                        $this->mcartaasignacion->actualizar(
                            array(
                                'fechaDesasignacion' => date_format(new DateTime(),"Y-m-d"),
                                'statusCarta' => 0
                            )
                        ,$validaAsignacion['id']);
                    }
                }
                $this->mactivos->actualizar($pData, $id);
                redirect($this->router->class.'?close');
            }
        }
        // Obteniendo la información
        $info = $this->mactivos->getById($id);

        $data = $info;
        $data['msg']=$msg;
        $this->data['contenido'] = $this->load->view($this->mainView . '/editar_view', $data, true);
        $this->load->view('templates/main_template', $this->data);
    }

    public function confirmarMantenimiento(){
        $id = $this->input->post('id', TRUE);
        $checked = $this->input->post('checked', TRUE);
        if ( $id > 0 && !is_null($id) ) {
            //$pData['checked'] = $checked;
            $pData['fecha'] = date("Y-m-d");
            $pData['statusMantenimiento'] = 1;
            $this->mmantenimientovehiculo->actualizar($pData,$id);

            $data['success'] = 1;
        }else{
            $data['success'] = 0;
        }
        $data['id'] = $id;
        echo json_encode($data);
        //return $data;
    }

    public function eliminar(){
        $id = $this->input->post('elid');
        $q = $this->mactivos->getById($id);
        $cValor = "true";
        $this->mactivos->borrar($id);
        $data = json_encode(array("valor" => $cValor));
        echo $data;
    }

    public function eliminar_archivo()
    {

        if (isset($_POST['elid'])){
            $id = $this->input->post('elid');
            $campo = $this->input->post('elcampo'); //Obteniendo el nombre de la foto y thumbnail
            if($campo !="0"){
                $archivo = $this->mactivos->getCampo('pdf_'.$campo,$id);
                if(unlink($this->data['fotos_www'].$archivo)){// Haciendo update a la tabla
                    $c_data['pdf_'.$campo] ='';
                    $this->mactivos->actualizar($c_data,$id);
                    $c_valor = "true";
                    //$this->msomos->borrar($id);
                }else{ $c_valor = "false";}
            }else{
                $archivo = $this->mactivos->getCampo('pdf',$id);
                if(unlink($this->data['fotos_www'].$archivo)){// Haciendo update a la tabla
                    $c_data['pdf'] ='';
                    $this->mactivos->actualizar($c_data,$id);
                    $c_valor = "true";
                    //$this->msomos->borrar($id);
                }else{ $c_valor = "false";}
            }
            $data = json_encode(array("valor"=>$c_valor));
            echo $data;

        }
    }


}


