<?php
	defined('BASEPATH') OR exit('No direct script access allowed');

	class Validacion_venta extends MX_Controller {
		public $data,$vParameters,$mainView,$fv,$appProduction,$idFraccionamiento,$urlLogo;
		public function __construct() {
			$this->nsession = $this->config->item('nsession');
			if (!isset($_SESSION[$this->nsession]) || (($_SESSION[$this->nsession]['usuario'] == ""))) redirect('login');
			$this->fv = 'validacion_venta'; // form validation variable
			$this->mainView = 'validacion_venta';
			$this->data['fjs'] = '';
			$this->data['js'] = '<script src="assets/js/validacion_venta/listado.js" type="text/javascript"></script>';
			$this->data['css'] = '';
			// Tools
			$this->load->helper(array('tools','numeros','url','form','date','text','security'));
			// Modelos
			$this->load->model(array('mgestoria2','maltaventa','mprospecto','mfraccionamiento','musuario','mprototipoxfraccionamiento','mnotaria','mproyecto','mfraccionamientoxusuario','mprototipos','mgestoria','mfoliosavaluo','munidad_valuadora','mavaluoproyecto','mareastatus','Mdiferenciapromotor','mcontadocuentas', 'mcontadodetalle'));
			$this->appProduction = $this->config->item('appProduction');
			// Lbrerias
			// $this->load->library(array('email','session'));
			$this->data['fotos_www'] = $this->config->item('base_www').'/alta_venta/';

			// Debugging
			$this->output->enable_profiler(false);

           //Validación de usuarios
			valSession("ventas",$this->fv);
           $this->idFraccionamiento = 0;
            $this->urlLogo = '';
		}

	    public function setLogo()
	    {
	        $logoFraccionamiento = $this->mfraccionamiento->getCampo('foto',$this->idFraccionamiento);
	        $nomFracc = $this->mfraccionamiento->getCampo('titulo',$this->idFraccionamiento);
	        $this->urlLogo = ($logoFraccionamiento!='')?"<img height='80' src='uploads/fraccionamientos/".$logoFraccionamiento."' />":$nomFracc;
	    }

		public function index() {
			$data['q'] = '';
			$this->data['contenido'] = $this->load->view($this->mainView.'/index_view',$data,true);
			$this->load->view('templates/main_template',$this->data);
		}

		public function enviarSolicitud(){
			//print_r($_FILES);
			$data['success'] = true;
			echo json_encode($data);
		}

	    public function listado(){
	        $q = $this->mgestoria2->get_datatables();
	        // print_r($q->result()); exit();
	        if (!is_numeric($q)){
	            foreach ($q->result() as $row){
	            	$statusGestoria = $this->mgestoria->getByIdAV($row->id);
	            	$calcelarProceso = ($row->statusValidacion<3)?true:false;

	            	$correccionRfc = $this->mareastatus->getByIdAreaAv(1,$row->id,'correccion de rfc');
	            	$solAvaluo = $this->mareastatus->getByIdAreaAv(1,$row->id,'solicitud de avaluo');
	            	$correccionAvaluo = $this->mareastatus->getByIdAreaAv(1,$row->id,'correccion de avaluo');
	            	$complementoExpediente = $this->mareastatus->getByIdAreaAv(1,$row->id,'complemento de expediente');
	            	$revCondiciones = $this->mareastatus->getByIdAreaAv(1,$row->id,'revision de condiciones');
	            	$esperaUbicacion = $this->mareastatus->getByIdAreaAv(1,$row->id,'espera de ubicacion');
	            	$autorizado = $this->mareastatus->getByIdAreaAv(1,$row->id,'autorizado');

	            	//damos formato de fecha a cada estatus, si existe
	            	$fechaCorreccionRfc = (!is_numeric($correccionRfc))?$correccionRfc['fecha']:'';
	            	$fechaCorreccionRfc = ($fechaCorreccionRfc!='' && $fechaCorreccionRfc!='0000-00-00')?date('d/m/Y',strtotime($fechaCorreccionRfc)):'';
	            	$fechaSolAvaluo = (!is_numeric($solAvaluo))?$solAvaluo['fecha']:'';
	            	$fechaSolAvaluo = ($fechaSolAvaluo!='' && $fechaSolAvaluo!='0000-00-00')?date('d/m/Y',strtotime($fechaSolAvaluo)):'';
	            	$fechaCorreccionAvaluo = (!is_numeric($correccionAvaluo))?$correccionAvaluo['fecha']:'';
	            	$fechaCorreccionAvaluo = ($fechaCorreccionAvaluo!='' && $fechaCorreccionAvaluo!='0000-00-00')?date('d/m/Y',strtotime($fechaCorreccionAvaluo)):'';
	            	$fechaComplementoExpediente = (!is_numeric($complementoExpediente))?$complementoExpediente['fecha']:'';
	            	$fechaComplementoExpediente = ($fechaComplementoExpediente!='' && $fechaComplementoExpediente!='0000-00-00')?date('d/m/Y',strtotime($fechaComplementoExpediente)):'';
	            	$fechaRevCondiciones = (!is_numeric($revCondiciones))?$revCondiciones['fecha']:'';
	            	$fechaRevCondiciones = ($fechaRevCondiciones!='' && $fechaRevCondiciones!='0000-00-00')?date('d/m/Y',strtotime($fechaRevCondiciones)):'';
	            	$fechaEsperaUbicacion = (!is_numeric($esperaUbicacion))?$esperaUbicacion['fecha']:'';
	            	$fechaEsperaUbicacion = ($fechaEsperaUbicacion!='' && $fechaEsperaUbicacion!='0000-00-00')?date('d/m/Y',strtotime($fechaEsperaUbicacion)):'';
	            	$fechaAutorizado = (!is_numeric($autorizado))?$autorizado['fecha']:'';
	            	$fechaAutorizado = ($fechaAutorizado!='' && $fechaAutorizado!='0000-00-00')?date('d/m/Y',strtotime($fechaAutorizado)):'';

	            	$fechaProspeccion = $this->mprospecto->getCampo('created',$row->idProspecto);
	                $array[] = array(
	                	'id' => $row->id,
	                	'fraccionamiento' => $this->mfraccionamiento->getCampo('titulo',$this->mproyecto->getCampo('idFraccionamiento',$row->idProyecto)),
	                    'nombre' => strtoupper($row->nombre.' '.$row->apellidoP.' '.$row->apellidoM),
	                    'nss' => $row->nss,
	                    'promotor' => strtoupper($this->musuario->getCampo('nombre',$row->idPromotor)." ".$this->musuario->getCampo('apellidoP',$row->idPromotor)." ".$this->musuario->getCampo('apellidoM',$row->idPromotor)),
	                    'lote' => $row->lote,
	                    'manzana' => $row->manzana,
	                    'nOficial' => $row->nOficial,
	                    'calle' => $row->calle,
	                    'cuv' => $row->cuv,
	                    'monto' => precio_format($row->monto),
	                    'subCuenta' => precio_format($row->subCuenta),
	                    'gastosOperacion' => precio_format($row->gastosOperacion),
	                    'total' => precio_format($row->total),
	                    'fechaPreca' => ($row->fechaPreca!='0000-00-00')?date_format(new DateTime($row->fechaPreca),'d/m/Y'):'',
	                    'fechaVenta' => ($row->fechaVenta!='0000-00-00' && $row->fechaVenta!='')?date_format(new DateTime($row->fechaVenta),'d/m/Y'):'',
	                    'fechaProspeccion' => ($fechaProspeccion!='' && $fechaProspeccion!='000-00-00')?date('d/m/Y',strtotime($fechaProspeccion)):'',
	                    'fecha' => ($row->created!='' && $row->created!='000-00-00')?date('d/m/Y',strtotime($row->created)):'',//fecha alta
	                    'fechaApartado' => ($row->fechaApartado!='' && $row->fechaApartado!='000-00-00')?date('d/m/Y',strtotime($row->fechaApartado)):'',//fecha apartado
	                    'fechaCorreccionRfc' => $fechaCorreccionRfc,
	                    'fechaSolAvaluo' => $fechaSolAvaluo,
	                    'fechaCorreccionAvaluo' => $fechaCorreccionAvaluo,
	                    'fechaComplementoExpediente' => $fechaComplementoExpediente,
	                    'fechaRevCondiciones' => $fechaRevCondiciones,
	                    'fechaEsperaUbicacion' => $fechaEsperaUbicacion,
	                    'fechaAutorizado' => $fechaAutorizado,
	                    'fechaProceso' => ($row->fechaProceso!='' && $row->fechaProceso!='000-00-00')?date('d/m/Y',strtotime($row->fechaProceso)):'',//fecha proceso
	                    'fechaCambio' => date('d/m/Y',strtotime($row->fechaCambio)),
	                    'tipoCredito' => strtoupper($row->tipoCredito),
	                    'tipoCredito2' => strtoupper($row->tipoCredito2),
	                    'diferencia' => (!is_numeric($statusGestoria))?precio_format($statusGestoria['difPropioPeculioTitulacion']):'',//precio_format($row->diferencia),
	                    'bonoEquipamiento' => precio_format($row->bonoEquipamiento),
	                    'precioVenta' => precio_format($row->precioVenta),
	                    'avaluo' => precio_format($row->avaluo),
	                    'statusVivienda' => strtoupper(estatus_proyecto_reporte($row->statusVenta)),
	                    'statusValidacion' => strtoupper($row->statusValidacion2),
	                    'statusGestoria' => (!is_numeric($statusGestoria))?strtoupper($statusGestoria['statusGestoria']):'',
	                    'lineaCredito' => $row->lineaCredito,
	                    'archivos' => name_file_valid_sale($row),
	                    'acciones' => (in_array($_SESSION["viv"]["rol"], permisos("ventas","validacion_venta_edit")['r']))?acciones($row->id,$this->router->class, true, true, false,'','',false,0,$calcelarProceso):accionesNoEdit($row->id,$this->router->class)
	                    );
	            }
	        } else{
	            $array[] = array(
	            	'id' => 'No hay registros',
	            	'fraccionamiento' => 'No hay registros',
	                'nombre' => 'No hay registros',
	                'nss' => 'No hay registros',
	                'promotor' => 'No hay registros',
	                'lote' => 'No hay registros',
	                'manzana' => 'No hay registros',
	                'nOficial' => 'No hay registros',
	                'calle' => 'No hay registros',
	                'cuv' => 'No hay registros',
	                'monto' => 'No hay registros',
	                'subCuenta' => 'No hay registros',
	                'gastosOperacion' => 'No hay registros',
	                'total' => 'No hay registros',
	                'fechaPreca' => 'No hay registros',
	                'fechaVenta' => 'No hay registros',
	                'fechaProspeccion' => 'No hay registros',
	                'fecha' => 'No hay registros',
	                'fechaApartado' => 'No hay registros',
	                'fechaCorreccionRfc' => 'No hay registros',
                    'fechaSolAvaluo' => 'No hay registros',
                    'fechaCorreccionAvaluo' => 'No hay registros',
                    'fechaComplementoExpediente' => 'No hay registros',
                    'fechaRevCondiciones' => 'No hay registros',
                    'fechaEsperaUbicacion' => 'No hay registros',
                    'fechaAutorizado' => 'No hay registros',
	                'fechaProceso' => 'No hay registros',
	                'fechaCambio' => 'No hay registros',
	                'tipoCredito' => 'No hay registros',
	                'tipoCredito2' => 'No hay registros',
	                'diferencia' => 'No hay registros',
	                'bonoEquipamiento' => 'No hay registros',
	                'precioVenta' => 'No hay registros',
	                'avaluo' => 'No hay registros',
	                'statusVivienda' => 'No hay registros',
	                'statusValidacion' => 'No hay registros',
	                'statusGestoria' => 'No hay registros',
	                'lineaCredito' => 'No hay registros',
	                'archivos' => 'No hay registros',
	                'acciones' => 'No hay registros'
	                );

	        }
	        $output = array(
	                        "draw" => $_POST['draw'],
	                        "recordsTotal" => $this->mgestoria2->count_all(),
	                        "recordsFiltered" => $this->mgestoria2->count_filtered(),
	                        "data" => $array,
	                );
	        //output to json format
	        echo json_encode($output);
	    }

	    public function listado2(){
	        $q = $this->maltaventa->getPendientesGestoria();
	        if (!is_numeric($q)){
	            foreach ($q->result() as $row){
	            	$fechaProspeccion = $this->mprospecto->getCampo('created',$row->idProspecto);
	                $array['aaData'][] = array(
	                	'id' => $row->id,
	                	'fraccionamiento' => $this->mfraccionamiento->getCampo('titulo',$row->idFraccionamiento),
	                    'nombre' => strtoupper($row->nombre.' '.$row->apellidoP.' '.$row->apellidoM),
	                    'nss' => $row->nss,
	                    'promotor' => strtoupper($this->musuario->getCampo('nombre',$row->idPromotor)." ".$this->musuario->getCampo('apellidoP',$row->idPromotor)." ".$this->musuario->getCampo('apellidoM',$row->idPromotor)),
	                    'lote' => '',//$row->lote,
	                    'manzana' => '',//$row->manzana,
	                    'nOficial' => '',//$row->nOficial,
	                    'calle' => '',//$row->calle,
	                    'cuv' => '',//$row->cuv,
	                    'monto' => precio_format($row->monto),
	                    'subCuenta' => precio_format($row->subCuenta),
	                    'gastosOperacion' => precio_format($row->gastosOperacion),
	                    'total' => precio_format($row->total),
	                    'fechaPreca' => ($row->fechaPreca!='0000-00-00')?date_format(new DateTime($row->fechaPreca),'d/m/Y'):'',
	                    'fechaVenta' => ($row->fechaVenta!='0000-00-00' && $row->fechaVenta!='')?date_format(new DateTime($row->fechaVenta),'d/m/Y'):'',
	                    'fechaProspeccion' => ($fechaProspeccion!='' && $fechaProspeccion!='000-00-00')?date('d/m/Y',strtotime($fechaProspeccion)):'',
	                    'fecha' => ($row->created!='' && $row->created!='000-00-00')?date('d/m/Y',strtotime($row->created)):'',//fecha alta
	                    'tipoCredito' => $row->tipoCredito,
	                    'diferencia' => precio_format($row->diferencia),
	                    'bonoEquipamiento' => precio_format($row->bonoEquipamiento),
	                    'precioVenta' => '',//precio_format($row->precioVenta),
	                    'avaluo' => '',//precio_format($row->avaluo),
	                    'statusVivienda' => '',//estatus_proyecto_reporte($row->statusVenta),
	                    'statusValidacion' => '',//estatus_proyecto_reporte($row->statusVenta),
	                    'lineaCredito' => '',//$row->lineaCredito,
	                    'archivos' => name_file_valid_sale($row),
	                    'acciones' => (in_array($_SESSION["viv"]["rol"], permisos("ventas","validacion_venta_edit")['r']))?'<a class="btn blue" href="'.$this->router->class.'/nuevo/'.$row->idProspecto.'">Validar</a>':'',//acciones($row->id,$this->router->class, true, true, false)
	                    );
	            }
	        } else{
	            $array['aaData'][] = array(
	            	'fraccionamiento' => 'No hay registros',
	                'nombre' => 'No hay registros',
	                'nss' => 'No hay registros',
	                'promotor' => 'No hay registros',
	                'lote' => 'No hay registros',
	                'manzana' => 'No hay registros',
	                'nOficial' => 'No hay registros',
	                'calle' => 'No hay registros',
	                'cuv' => 'No hay registros',
	                'monto' => 'No hay registros',
	                'subCuenta' => 'No hay registros',
	                'gastosOperacion' => 'No hay registros',
	                'total' => 'No hay registros',
	                'fechaPreca' => 'No hay registros',
	                'fechaVenta' => 'No hay registros',
	                'fechaProspeccion' => 'No hay registros',
	                'fecha' => 'No hay registros',
	                'tipoCredito' => 'No hay registros',
	                'diferencia' => 'No hay registros',
	                'bonoEquipamiento' => 'No hay registros',
	                'precioVenta' => 'No hay registros',
	                'avaluo' => 'No hay registros',
	                'statusVivienda' => 'No hay registros',
	                'statusValidacion' => 'No hay registros',
	                'lineaCredito' => 'No hay registros',
	                'archivos' => 'No hay registros',
	                'acciones' => 'No hay registros'
	                );

	        }

	        echo json_encode($array);
	    }

		public function cancelProcess()
	    {
	    	$idAltaVenta = $this->input->post('idAltaVenta', TRUE);
	    	$idMotivo = $this->input->post('idMotivo', TRUE);
	    	$motivoCancelacion = $this->input->post('motivoCancelacion', TRUE);
	    	if ( $idAltaVenta != null && $idAltaVenta != '' && $idAltaVenta > 0) {
	    		//$idAltaVenta = $this->mgestoria->getCampo("idAltaVenta",$idGestoria);
		    	$idProyecto = $this->maltaventa->getCampo("idProyecto",$idAltaVenta);
		    	$idProspecto = $this->maltaventa->getCampo("idProspecto",$idAltaVenta);
		    	// $alta_venta = $this->maltaventa->getById($idAltaVenta);
		    	$dateCancel = date('Y-m-d');

		    	$rowAvaluoProyecto = $this->mavaluoproyecto->getByIdProyectoProspecto($idProyecto,$idProspecto);
		    	//echo $rowAvaluoProyecto['id'];exit();
		    	//pendiente un update status 0 en prospectos

		    	//$autores = $this->autoRespuestaCancel($idGestoria);
		    	// exit();

		    	//$r['gestoria'] = $this->db->query("UPDATE gestoria SET status = 0, motivoCancelacion = '".$motivoCancelacion."', fechaCancelacion = '".$dateCancel."' WHERE id=".$idGestoria);
		    	$this->db->trans_start();
		    	$r['alta_venta'] = $this->db->query("UPDATE alta_venta SET status=0, statusValidacion=0, statusValidacion2='', motivoCancelacionAv = '".$motivoCancelacion."', idMotivo = '".$idMotivo."', fechaCancelacionAv = '".$dateCancel."' WHERE id=".$idAltaVenta);
		    	$this->db->query("UPDATE alta_venta SET idProyecto=NULL WHERE id=".$idAltaVenta);
		    	$r['proyecto'] = $this->db->query("UPDATE proyectos SET statusVenta=0, folioAvaluo='' WHERE id=".$idProyecto);
		    	$r['prospecto'] = $this->db->query("UPDATE prospectos SET status=0 WHERE id=".$idProspecto);
		    	$r['area_status'] = $this->db->query("DELETE FROM area_status WHERE idAltaVenta=".$idAltaVenta);

		    	if (!is_numeric($rowAvaluoProyecto)){
		    		$ap['statusAsignacion'] = 0;
		    		$ap['fechaDesAsignacion'] = date('Y-m-d');
		    		$this->mavaluoproyecto->actualizar($ap,$rowAvaluoProyecto['id']);
		    		$idFolioAvaluo = $rowAvaluoProyecto['idAvaluo'];
		    		$rowAvaluoProyecto = $this->mavaluoproyecto->getByIdAvaluo($idFolioAvaluo);
		    		if($rowAvaluoProyecto->num_rows()<3){
		    			$fa['disponible'] = 1;
		    			$this->mfoliosavaluo->actualizar($fa,$idFolioAvaluo);
		    		}
		    	}

				$existContado = $this->mcontadocuentas->getByIdAV($idAltaVenta);
				if(!is_numeric($existContado)){
					$contadoDetalle = $this->mcontadodetalle->getByIdContado($existContado['id']);
					if(!is_numeric($contadoDetalle)){
						$this->db->query("DELETE FROM contado_detalle WHERE idCuenta = ".$existContado['id']);
					}
					$this->db->query("DELETE FROM contado_cuentas WHERE id = ".$existContado['id']);
				}

		    	$this->db->trans_complete();

		    	$response = array(
		    		'success' => TRUE,
		    		//'idGestoria' => $idGestoria,
		    		'idAltaVenta' => $idAltaVenta,
		    		'idProyecto' => $idProyecto,
		    		'responseUpd' => $r,
		    		//'responseMail' =>$autores
		    	);
	    	}
	    	else {
	    		$response = array(
	    			'success' => FALSE,
	    			'msg' => 'Id alta venta con valor null'
	    		);
	    	}
	    	echo json_encode( $response );
	    }

	    public function nuevo($idProspecto=null,$activar=false){

	        $data['msg'] = '';
	    	$data['disabled'] = true;
	    	$bloquedSelectNss = ($idProspecto!=null)?true:false;
	    	$data['idProspecto'] = '';
	    	$data['id'] = '';
	    	$data['msgInvalid'] = '';
	    	$data['proyectos'] = 0;
	    	$data['idProyecto'] = NULL;
	    	$data['projectSelected'] = 0;
	        if (isset($_POST['idProspecto']) || $idProspecto!=null){
	        	$idProspecto = ($idProspecto!=null)?$idProspecto:$this->input->post('idProspecto', TRUE);
	        	$fraccionamientoProspecto = $this->mprospecto->getCampo('idFraccionamiento',$idProspecto);
	        	$info = $this->maltaventa->getByIdProspecto($idProspecto);
	        	$data = (!is_numeric($info))?$info:'';
	        	//echo $data['idProyecto'];exit();
	        	$data['proyectos'] = ($fraccionamientoProspecto>0)?$this->mproyecto->getBySelectResult2($fraccionamientoProspecto):0;
	        	$data['projectSelected'] = $this->mproyecto->getById(($data!='')?$data['idProyecto']:0);
	        	$data['fraccionamiento'] = $this->mfraccionamiento->getCampo('titulo',$fraccionamientoProspecto);
	        	//print_r($data);exit();
	        	$data['disabled'] = (!is_numeric($info))?false:true;
	        	$data['idProspecto'] = $idProspecto;
	        	$data['msg'] = '';

	        	if(is_numeric($info)){
	        		$data['id']='';
	        		$data['msgInvalid'] = 'El NSS elegido no está asociado a un prospecto';
	        	}else{
	        		$data['msgInvalid'] = '';
	        	}

	        }
	        if (isset($_POST['revisionMontos'])){
	        	$data['idProspecto'] = $this->input->post('idProspecto', TRUE);
		        //print_r($data['altas']->result());exit();
		        $this->load->library('form_validation');
		        if ($this->form_validation->run($this->fv) == FALSE) {
		            $data['msg'] = validation_errors();
		        } else {
		        	$id = $this->input->post('idAltaVenta', TRUE);

		        	$checkSolicitud = $this->input->post('check_solicitud', TRUE);

                	// Subida de pdf
		            $config = array();
		            $this->load->library('upload', $config);
		            //if($checkSolicitud==1){
			            if (isset($_FILES)){
			                $imagenes = array();
			                foreach($_FILES as $key=>$value){
			                    if ($_FILES[$key]['size'] > 0){
			                        $_FILES[$key]['name'] = strtolower($_FILES[$key]['name']);
			                        $imagenes[] = $key;
			                    }
			                }
			                $totalImagenes = count($imagenes);

			                for($i=0; $i< $totalImagenes; $i++){
								if($imagenes[$i] != 'comprobante'){
									$ext = pathinfo($_FILES[$imagenes[$i]]['name'],PATHINFO_EXTENSION);
									//Configuracion del thumbnail
									if($imagenes[$i]!='pdf'){
										$nCampoC = explode("_",$imagenes[$i]);
										$tipo = $nCampoC[0];
										$v = $nCampoC[1];

									} else {
										$v = 0;
										$tipo = 'pdf';
									}
									if ($tipo == 'pdf' || $tipo == 'jpg' || $tipo == 'png' || $tipo == 'jpeg'){
										//echo 'es tipo foto<br>';
										$uploaddir = $this->data['fotos_www'];
										$nextId = $id;
										$config['file_name'] =  $nextId."_".$v;
										$config['overwrite'] = TRUE;
										$config['upload_path'] = $uploaddir;
										$config['max_size'] = '8000';
										$config['allowed_types'] = 'pdf|jpg|jpeg|png|gif';
										$this->upload->initialize($config);
										if ( ! $this->upload->do_upload($imagenes[$i]) )
										{
											$redirect = 1;
											$data['error'] = $this->upload->display_errors();
										}
										else
										{
											//$contadorArchivos++;
											$dataFile = $this->upload->data($imagenes[$i]);
											$fotoI = 'pdf_'.$v;
											//$thumbI = 'thumbnail_'.$v;
											if ($v == 0){
												//Foto default
												$pData['pdf'] = $nextId.'_'.$v.'.'.$ext;//
											} else {
												$pData[$fotoI] = $nextId.'_'.$v.'.'.$ext;
											}
										}
									}
								}

			                }
			            }
			        //}

		        	if (!is_numeric($info)){
		        		$statusValidacion_old = $this->maltaventa->getCampo('statusValidacion',$info['id']);
		        	}else{
		        		$statusValidacion_old = 0;
		        	}

		        	$pData['idProyecto'] = $this->input->post('idProyecto', TRUE);
		        	$pData['revisionMontos'] = $this->input->post('revisionMontos', TRUE);
		        	$pData['motivo'] = $this->input->post('motivo', TRUE);
		        	$pData['tipoCredito'] = $this->input->post('tipoCredito', TRUE);
		        	$pData['tipoCredito2'] = $this->input->post('tipoCredito2', TRUE);
		        	$pData['otroTCredito'] = $this->input->post('otroTCredito', TRUE);

		        	$diferencia_cliente = $this->input->post('diferencia_cliente', TRUE);
		        	$pData['diferenciaCliente'] = ($diferencia_cliente!='')?toInt($diferencia_cliente):0.00;
		        	$diferencia_asesor = $this->input->post('diferencia_asesor', TRUE);
		        	$pData['diferenciaAsesor'] = ($diferencia_asesor!='')?toInt($diferencia_asesor):0.00;
		        	$diferencia_empresa = $this->input->post('diferencia_empresa', TRUE);
		        	$pData['diferenciaEmpresa'] = ($diferencia_empresa!='')?toInt($diferencia_empresa):0.00;

		        	$diferencia = $this->input->post('diferencia', TRUE);
		        	$pData['diferencia'] = ($diferencia!='')?toInt($diferencia):0.00;
		        	$bonoEquipamiento = $this->input->post('bonoEquipamiento', TRUE);
		        	$pData['bonoEquipamiento'] = ($bonoEquipamiento!='')?toInt($bonoEquipamiento):0.00;
		        	$pData['numPagare'] = $this->input->post('numPagare', TRUE);
		        	$montoPagare = $this->input->post('montoPagare', TRUE);
		        	$pData['montoPagare'] = ($montoPagare!='')?toInt($montoPagare):0.00;
		        	$fechaPagoPagare = $this->input->post('fechaPagoPagare', TRUE);
		        	$fechaPagoPagare = str_replace('/', '-', $fechaPagoPagare);
		        	$pData['fechaPagoPagare'] = ($fechaPagoPagare == '')?'0000-00-00':date('Y-m-d', strtotime($fechaPagoPagare));
		        	$pData['numSeriePagare'] = $this->input->post('numSeriePagare', TRUE);
		        	$pData['interesPagare'] = $this->input->post('interesPagare', TRUE);
		        	$pData['idUnidadValuadora'] = $this->input->post('idUnidadValuadora', TRUE);
		        	$pData['idNotaria'] = ($this->input->post('idNotaria', TRUE) == 0)?NULL:$this->input->post('idNotaria', TRUE);
		        	$pData['statusValidacion2'] = $this->input->post('statusValidacion2', TRUE);
		        	$pData['numNotaria'] = $this->input->post('numNotaria', TRUE);

		        	$pData['statusPdf_1'] = ($this->input->post('check_pdf1', TRUE) != 1)?0:1;
		        	$pData['fechaCambio'] = date("Y-m-d H:i:s");
		        	// validamos, si esta checkiado asignamos el valor 1 indica que el archivo ya esta validado
		        	$pData['statusPdf_2'] = ($this->input->post('check_pdf2', TRUE) != 1)?0:1;
		        	$pData['statusPdf_3'] = ($this->input->post('check_pdf3', TRUE) != 1)?0:1;
		        	$pData['statusPdf_4'] = ($this->input->post('check_pdf4', TRUE) != 1)?0:1;
		        	$pData['statusPdf_5'] = ($this->input->post('check_pdf5', TRUE) != 1)?0:1;
		        	$pData['statusPdf_6'] = ($this->input->post('check_pdf6', TRUE) != 1)?0:1;
		        	$pData['statusPdf_7'] = ($this->input->post('check_pdf7', TRUE) != 1)?0:1;
		        	$pData['statusPdf_16'] = ($this->input->post('check_pdf16', TRUE) != 1)?0:1;

		            //print_r($pData);exit();

		        	//$pData['statusPdf_1']==1 && $pData['statusPdf_2']==1 && $pData['statusPdf_3']==1 && $pData['statusPdf_4']==1 && $pData['statusPdf_5'] && $pData['statusPdf_6']==1 && $pData['statusPdf_7']==1 &&

		        	if ($pData['statusValidacion2']=='autorizado'){ //si es autorizado mandamos el registro a pendiente en titulación
		        		// $pData['statusValidacion'] = 2;
		        		$pData['fechaValidacion'] = date('Y-m-d');
	        			$pData['statusPdf_1'] = 1;
		        		if ( $statusValidacion_old < 2 ) {
		        			$pData['statusValidacion'] = 2;
		        		}else {
		        			$pData['statusValidacion'] = $statusValidacion_old;
		        		}
						$lineaCredito = $this->mproyecto->getCampo("lineaCredito",$pData['idProyecto']);
						if( $lineaCredito == 3 ){
							$proyData['statusObra'] = 1;
						}
		        		//$autores = $this->autoRespuesta( $this->input->post('idAltaVenta', TRUE) );
		        	}else{
		        		// $pData['statusValidacion'] = 1;
		        		if ( $statusValidacion_old <= 1 ) {
		        			$pData['statusValidacion'] = 1;
		        		}
		        		else {
		        			$pData['statusValidacion'] = $statusValidacion_old;
		        		}
		        		//$autores = $this->autoRespuesta2( $pData, $this->input->post('idAltaVenta', TRUE) );
		        	}

		        	//$pData['pdf_3']

		        	$validId = $this->maltaventa->existRowById($id,$activar);
		        	if ($validId > 0){	        		

			        	$this->maltaventa->actualizar($pData, $id);	        	

			        	$ae['idArea'] = 3;
		        		$ae['idAltaVenta'] = $id;
		        		$ae['idStatus'] = 'apartado';
		        		$ae['fecha'] = date('Y-m-d H:i:s');
		        		$this->mareastatus->insertar($ae);

			        	//validamos inserción del estatus en la tabla relacion area estatus
			        	if($pData['statusValidacion2']!=''){
			        		$ae['idArea'] = 1;
			        		$ae['idAltaVenta'] = $id;
			        		$ae['idStatus'] = $pData['statusValidacion2'];
			        		$ae['fecha'] = date('Y-m-d H:i:s');
			        		$this->mareastatus->insertar($ae);
			        	}

		        		//obtenemos el id AV a partir del prospecto
			        	$idProyecto = $this->maltaventa->getCampo('idProyecto',$id);//id del proyecto antiguo
			        	if($idProyecto > 0){
			        		$statusVentaOld = ($idProyecto>0)?$this->mproyecto->getCampo('statusVenta',$idProyecto):0;//obtenemos el status de venta del antiguo lote
                			$dProyecto_old['statusVenta'] = 0;
                			if ($idProyecto != $pData['idProyecto']){ //Validamos si se hizo cambio de lote
                    			$this->mproyecto->actualizar($dProyecto_old,$idProyecto);
                			}
                			$proyData['statusVenta'] = ($statusVentaOld>0)?$statusVentaOld:1;
                			if($proyData['statusVenta']==1){
                				$fechaApartado['fechaApartado'] = date('Y-m-d');
                				$this->maltaventa->actualizar($fechaApartado,$id);
                			}
			        		$avaluo = $this->input->post('avaluo', TRUE);
			        		$proyData['avaluo'] = ($avaluo!='')?toInt($avaluo):0.00;
			        		//$proyData['numAvaluo'] = $this->input->post('numAvaluo', TRUE);
			        		$proyData['folioAvaluo'] = $this->input->post('folioAvaluo', TRUE);
			        		$this->mproyecto->actualizar($proyData, $pData['idProyecto']);//actualizamos datos del nuevo lote

			        		//validamos insersión a la tabla avaluo proyecto
			        		if($proyData['folioAvaluo']>0){
			        			$ap['idAvaluo'] = $proyData['folioAvaluo'];
			        			$ap['idProyecto'] = $pData['idProyecto'];
			        			$ap['idProspecto'] = $data['idProspecto'];
			        			$ap['fechaAsignacion'] = date('Y-m-d');
			        			$ap['fechaDesAsignacion'] = '';
			        			$ap['statusAsignacion'] = 1;
			        			$this->mavaluoproyecto->insertar($ap);
			        			$fa['disponible'] = 0;
			        			$this->mfoliosavaluo->actualizar($fa,$ap['idAvaluo']);
			        		}

			        	}
			        	//checamos si vino del módulo cancelaciones
			        	if($activar){
			        		$rGestoria = $this->mgestoria->getByIdAV($id);
			        		if (!is_numeric($rGestoria)){
			        			$this->db->query("UPDATE gestoria SET status = 1, idMotivo=0 WHERE id=".$rGestoria['id']);
			        		}
		    				$this->db->query("UPDATE alta_venta SET status=1, idMotivo=0 WHERE id=".$id);
		    	 			$this->db->query("UPDATE prospectos SET status=1,fecha=CURDATE() WHERE id=".$idProspecto);
			        	}
			        	//si es solicitud de avalúo enviamos la solicitud y los archivos
			        	$archivoSolicitud = $this->maltaventa->getCampo('pdf_17',$id);
			        	if ($pData['statusValidacion2']=='solicitud de avaluo' && $checkSolicitud==1){
			        		$this->autoRespuesta3($id);
			        	}
			        	if ($pData['statusValidacion2']=='correccion de avaluo' && $checkSolicitud==1){
			        		$this->autoRespuesta3($id,'correccion');
			        	}
						
						// para ver el tipo de credito es de contado
						$existContado = $this->mcontadocuentas->getByIdAV($id);
						if( $pData['tipoCredito'] == 'contado' ){
							$ccData['idAltaVenta'] = $id;
							$fechaContado = $this->input->post('fechaContado', true);
							$fechaContado =  str_replace('/', '-', $fechaContado);
							$ccData['fecha'] = ($fechaContado != '')? date('Y-m-d', strtotime($fechaContado)) : NULL;
							$montoContado = $this->input->post('montoContado', TRUE);
							$ccData['monto'] = toInt($montoContado); //$this->mproyecto->getCampo('precioVenta',$idProyecto);
							$ccData['monto'] = ( empty($ccData['monto']) )? 0.00 : $ccData['monto'];
							//$ccData['saldo'] = $ccData['monto'];
							$saldoContado = $this->input->post('saldoContado', TRUE);
							$ccData['saldo'] = toInt($saldoContado);
							$interes = $this->input->post('interesContado', TRUE);
							$ccData['interes'] = toInt($interes);
							$ccData['plazos'] = $this->input->post('plazosContado', TRUE);
							$pagos = $this->input->post('anticipoContado', TRUE);
							$ccData['pagos'] = toInt($pagos);
							$ccData['statusCuenta'] = 0;
							//$ccData['pagos'] = 0;
							$ccData['statusObra'] = 0;
							$ccData['status'] = 1;
							
							if( !is_numeric($existContado) && $activar ){
								$this->mcontadocuentas->actualizar($ccData, $existContado['id']);
							} else if( is_numeric($existContado) ){
								//$lineaCredito = $this->mproyecto->getCampo("lineaCredito",$pData['idProyecto']);
								//if( $lineaCredito == 1 ){
									$proyData['statusObra'] = 2;
									$this->mproyecto->actualizar($proyData,$pData['idProyecto']);
								//}
								$idContadoCuentas = $this->mcontadocuentas->insertar($ccData);
								if(is_numeric($idContadoCuentas)){
									$this->data['fotos_www'] = $this->config->item('base_www').'/contado_detalle/';

									//Subida de Imagen
									$configT = array();
									$this->load->library('upload', $configT);
									$this->load->library('image_lib');
									if (isset($_FILES)){
										$imagenes = array();
										foreach($_FILES as $key=>$value){
											if ($_FILES[$key]['size'] > 0){
												$_FILES[$key]['name'] = strtolower($_FILES[$key]['name']);
												$imagenes[] = $key;
											}
										}
										$totalImagenes = count($imagenes);
										for($i=0; $i< $totalImagenes; $i++){
											if($imagenes[$i] == 'comprobante'){
												$ext = pathinfo($_FILES[$imagenes[$i]]['name'], PATHINFO_EXTENSION);
												//Configuracion del thumbnail
												if ($imagenes[$i] != 'comprobante') {
													$nCampoC = explode("_", $imagenes[$i]);
													$tipo = $nCampoC[0];
													$v = $nCampoC[1];
												} else {
													$v = 0;
													$tipo = 'foto';
												}
							
												if ($tipo == 'foto'){
													$uploaddir = $this->data['fotos_www'];
													$configT['upload_path'] = $uploaddir;
													$configT['image_library'] = 'gd2';
													$configT['create_thumb'] = FALSE;
													$configT['maintain_ratio'] = FALSE;
													//$configT['width'] = 150;
													//$configT['height'] = 150;
													//Configuracion de la libreria upload
													$nextId = $this->mcontadodetalle->nextId();
													$configT['file_name'] =  $nextId."_".$v;
													$configT['overwrite'] = TRUE;
													$configT['upload_path'] = $uploaddir;
													$configT['max_size'] = '3072';
													$configT['allowed_types'] = 'gif|jpg|png|jpeg|pdf';
													$this->upload->initialize($configT);
							
													if ( ! $this->upload->do_upload($imagenes[$i]))
													{
														$redirect = 1;
														$data['msg'] = $this->upload->display_errors();
													}
													else
													{
														$dataFile = $this->upload->data($imagenes[$i]);
														$fotoI = 'comprobante';
														if ($v == 0){
															//Foto default
															$cdData['comprobante'] = $nextId.'_'.$v.'.'.$ext;
															$configT['source_image'] = $uploaddir.$cdData['comprobante'];
															if($ext != 'pdf'){
																$this->image_lib->clear();
																$this->image_lib->initialize($configT);
																$this->image_lib->resize();
															}
														} else {
															$cdData[$fotoI] = $nextId.'_'.$v.'.'.$ext;
															$configT['source_image'] = $uploaddir.$cdData[$fotoI];
															if($ext != 'pdf'){
																$this->image_lib->clear();
																$this->image_lib->initialize($configT);
																$this->image_lib->resize();
															}
														}
													}
												}
											}
										}
									}

									$cdData['idCuenta'] = $idContadoCuentas;
									$fechaPago = $_POST['fechaPagoPagare'];
                					$fechaPago =  str_replace('/', '-', $fechaPago);
									$cdData['fecha'] = ($fechaPago != '')? date('Y-m-d', strtotime($fechaPago)) : NULL;
									$cdData['formaPago'] = $_POST['tipoPago'];
									$cdData['tipo'] = 1;
									$cdData['descripcion'] = "DEPOSITO DE ANTICIPO";
            						$cdData['importe'] = toInt($_POST['anticipoContado']);
									$cdData['saldo'] = toInt($_POST['saldoContado']);
									$cdData['statusDetalle'] = 1;
									$cdData['movimiento'] = $_POST['movimiento'];
									$cdData['cuenta'] = "0330679992";
									$cdData['status'] = 1;
									$id = $this->mcontadodetalle->insertar($cdData);
								}
							}
						}
						// fin del tipo credito para contado

		            	redirect($this->router->class);
		        	}else{
		        		$data['msgInvalid'] = 'Verifique que la información este correcta';
		        	}

		        }
	        }

	        $data['altas'] = $this->maltaventa->getNSS();
	        $data['mpromotor'] = $this->musuario;
	        $data['notarias'] = $this->mnotaria->getSelectResult();
	        $data['idUnidadValuadora'] = $this->munidad_valuadora->getSelectResult();
	        $data['bloquedSelectNss'] = $bloquedSelectNss;//asign valor true si el idProspecto vino de la url
	        $data['activar'] = $activar;
	        $data['foliosAvaluo'] = $this->mfoliosavaluo->getAll();
 	        $this->data['contenido'] = $this->load->view($this->mainView . '/nuevo_view', $data, true);
	        $this->load->view('templates/main_template', $this->data);

	    }

	    public function editar($id){

	    	$data['disabled'] = true;

	    	$data['id'] = '';
	    	$data['msgInvalid'] = '';
	    	$idFolioAvaluo = 0;
	    	$idProyecto_old = $this->maltaventa->getCampo('idProyecto',$id);
	        if (isset($_POST['revisionMontos'])){

		        $this->load->library('form_validation');
		        if ($this->form_validation->run($this->fv) == FALSE) {
		            $data['msg'] = validation_errors();
		            //print_r($data['msg']);
		        } else {

		        	$checkSolicitud = $this->input->post('check_solicitud', TRUE);

                	// Subida de pdf
		            $config = array();
		            $this->load->library('upload', $config);
		            //if($checkSolicitud==1){
			            if (isset($_FILES)){
			                $imagenes = array();
			                foreach($_FILES as $key=>$value){
			                    if ($_FILES[$key]['size'] > 0){
			                        $_FILES[$key]['name'] = strtolower($_FILES[$key]['name']);
			                        $imagenes[] = $key;
			                    }
			                }
			                $totalImagenes = count($imagenes);

			                for($i=0; $i< $totalImagenes; $i++){
								if($imagenes[$i] != 'comprobante'){
									$ext = pathinfo($_FILES[$imagenes[$i]]['name'],PATHINFO_EXTENSION);
									//Configuracion del thumbnail
									if($imagenes[$i]!='pdf'){
										$nCampoC = explode("_",$imagenes[$i]);
										$tipo = $nCampoC[0];
										$v = $nCampoC[1];

									} else {
										$v = 0;
										$tipo = 'pdf';
									}
									if ($tipo == 'pdf' || $tipo == 'jpg' || $tipo == 'png' || $tipo == 'jpeg'){
										//echo 'es tipo foto<br>';
										$uploaddir = $this->data['fotos_www'];
										$nextId = $id;
										$config['file_name'] =  $nextId."_".$v;
										$config['overwrite'] = TRUE;
										$config['upload_path'] = $uploaddir;
										$config['max_size'] = '8000';
										$config['allowed_types'] = 'pdf|jpg|jpeg|png|gif';
										$this->upload->initialize($config);
										if ( ! $this->upload->do_upload($imagenes[$i]) )
										{
											$redirect = 1;
											$data['error'] = $this->upload->display_errors();
										}
										else
										{
											//$contadorArchivos++;
											$dataFile = $this->upload->data($imagenes[$i]);
											$fotoI = 'pdf_'.$v;
											//$thumbI = 'thumbnail_'.$v;
											if ($v == 0){
												//Foto default
												$pData['pdf'] = $nextId.'_'.$v.'.'.$ext;//
											} else {
												$pData[$fotoI] = $nextId.'_'.$v.'.'.$ext;
											}
										}
									}
								}

			                }
			            }
		            //}

		        	$statusValidacion_old = $this->maltaventa->getCampo('statusValidacion',$id);

                    $pData['idProyecto'] = $this->input->post('idProyecto', TRUE);

		        	$pData['revisionMontos'] = $this->input->post('revisionMontos', TRUE);
		        	$pData['motivo'] = $this->input->post('motivo', TRUE);
		        	$pData['tipoCredito'] = $this->input->post('tipoCredito', TRUE);
		        	$pData['tipoCredito2'] = $this->input->post('tipoCredito2', TRUE);
		        	$pData['otroTCredito'] = $this->input->post('otroTCredito', TRUE);
		        	$diferencia_cliente = $this->input->post('diferencia_cliente', TRUE);
		        	$pData['diferenciaCliente'] = ($diferencia_cliente!='')?toInt($diferencia_cliente):0.00;
		        	$diferencia_asesor = $this->input->post('diferencia_asesor', TRUE);
		        	$pData['diferenciaAsesor'] = ($diferencia_asesor!='')?toInt($diferencia_asesor):0.00;
		        	$diferencia_empresa = $this->input->post('diferencia_empresa', TRUE);
		        	$pData['diferenciaEmpresa'] = ($diferencia_empresa!='')?toInt($diferencia_empresa):0.00;
		        	$diferencia = $this->input->post('diferencia', TRUE);
		        	$pData['diferencia'] = ($diferencia!='')?toInt($diferencia):0.00;
		        	$bonoEquipamiento = $this->input->post('bonoEquipamiento', TRUE);
		        	$pData['bonoEquipamiento'] = ($bonoEquipamiento!='')?toInt($bonoEquipamiento):0.00;
		        	$pData['numPagare'] = $this->input->post('numPagare', TRUE);
		        	$montoPagare = $this->input->post('montoPagare', TRUE);
		        	$pData['montoPagare'] = toInt($montoPagare);
		        	$fechaPagoPagare = $this->input->post('fechaPagoPagare', TRUE);
		        	$fechaPagoPagare = str_replace('/', '-', $fechaPagoPagare);
		        	$pData['fechaPagoPagare'] = ($fechaPagoPagare == '')?'0000-00-00':date('Y-m-d', strtotime($fechaPagoPagare));
		        	$pData['numSeriePagare'] = $this->input->post('numSeriePagare', TRUE);
		        	$pData['interesPagare'] = $this->input->post('interesPagare', TRUE);
		        	$pData['idUnidadValuadora'] = $this->input->post('idUnidadValuadora', TRUE);
		        	$pData['idNotaria'] = ($this->input->post('idNotaria', TRUE) == 0)?NULL:$this->input->post('idNotaria', TRUE);
		        	$pData['statusValidacion2'] = $this->input->post('statusValidacion2', TRUE);
		        	$pData['numNotaria'] = $this->input->post('numNotaria', TRUE);

		        	$pData['statusPdf_1'] = ($this->input->post('check_pdf1', TRUE) != 1)?0:1; // validamos, si esta checkiado asignamos el valor 1 indica que el archivo ya esta validado
		        	$pData['statusPdf_2'] = ($this->input->post('check_pdf2', TRUE) != 1)?0:1;
		        	$pData['statusPdf_3'] = ($this->input->post('check_pdf3', TRUE) != 1)?0:1;
		        	$pData['statusPdf_4'] = ($this->input->post('check_pdf4', TRUE) != 1)?0:1;
		        	$pData['statusPdf_5'] = ($this->input->post('check_pdf5', TRUE) != 1)?0:1;
		        	$pData['statusPdf_6'] = ($this->input->post('check_pdf6', TRUE) != 1)?0:1;
		        	$pData['statusPdf_7'] = ($this->input->post('check_pdf7', TRUE) != 1)?0:1;
		        	$pData['statusPdf_16'] = ($this->input->post('check_pdf16', TRUE) != 1)?0:1;
		        	//acualiza la fecha en la que se hizo la validaión de venta
		        	$statusValidacion2_old = $this->maltaventa->getCampo('statusValidacion2', $id);
                	if ($statusValidacion2_old != $pData['statusValidacion2']){ //validamos si hubo cambio 	en el status
                    	$pData['fechaCambio'] = date("Y-m-d H:i:s");
                	}

		        	//$pData['statusPdf_1']==1 && $pData['statusPdf_2']==1 && $pData['statusPdf_3']==1 && $pData['statusPdf_4']==1 && $pData['statusPdf_5'] && $pData['statusPdf_6']==1 && $pData['statusPdf_7']==1 &&

		        	if ($pData['statusValidacion2']=='autorizado') { //si es autorizado mandamos el registro a pendiente en titulación

		        		$fechaValidacion = $this->maltaventa->getCampo("fechaValidacion",$id);
		        		if($fechaValidacion=='0000-00-00' || $fechaValidacion==''){
		        			$pData['fechaValidacion'] = date('Y-m-d');
		        		}
		        		$pData['statusPdf_1'] = 1;
		        		if ( $statusValidacion_old < 2 ) {
		        			$pData['statusValidacion'] = 2;
		        		}
		        		else {
		        			$pData['statusValidacion'] = $statusValidacion_old;
		        		}

		        		// $statusValidacion = $this->maltaventa->getCampo('statusValidacion', $id);
		        		if ( $statusValidacion_old == 1 ) {
		        			//$autores = $this->autoRespuesta($id);
		        		}

						$lineaCredito = $this->mproyecto->getCampo("lineaCredito",$pData['idProyecto']);
						if( $lineaCredito == 3 ){
							$proyData['statusObra'] = 1;
						}

		        	}else{
		        		//$pData['statusValidacion'] = 1;

		        		if ( $statusValidacion_old <= 1 ) {
		        			$pData['statusValidacion'] = 1;
		        		}
		        		else {
		        			$pData['statusValidacion'] = $statusValidacion_old;
		        		}

		        		//$autores = $this->autoRespuesta2( $pData, $id );
		        	}

		        	//$pData['pdf_3']
		        	//$id = $this->input->post('idAltaVenta', TRUE);
		        	$validId = $this->maltaventa->existRowById($id);
		        	if ($validId > 0){

			        	$this->maltaventa->actualizar($pData, $id);

			        	$rowEstatus = $this->mareastatus->getByIdAreaAv(1,$id);
			        	$estatusOld = '';
			        	if(!is_numeric($rowEstatus)){
			        		$estatusOld = $rowEstatus['idStatus'];
			        	}
			        	//validamos inserción del estatus en la tabla relacion area estatus
			        	if($estatusOld != $pData['statusValidacion2'] && $pData['statusValidacion2']!=''){
			        		$ae['idArea'] = 1;
			        		$ae['idAltaVenta'] = $id;
			        		$ae['idStatus'] = $pData['statusValidacion2'];
			        		$ae['fecha'] = date('Y-m-d H:i:s');
			        		$this->mareastatus->insertar($ae);
			        	}

			        	//Funcionalidad cambio de lote al editar desde gestoria
			        	$statusVentaOld = ($idProyecto_old>0)?$this->mproyecto->getCampo('statusVenta',$idProyecto_old):0;
			        	$dProyecto_old['statusVenta'] = 0;
			        	if ($idProyecto_old != $pData['idProyecto']){ //Validamos si se hizo cambio de lote
		                    $this->mproyecto->actualizar($dProyecto_old,$idProyecto_old);
		                    //Quitamos vida de avaluo a proyecto old
		                    $proyOldData['folioAvaluo'] = '';
			        		//$this->mproyecto->actualizar($proyOldData, $idProyecto_old);
			        		$idProspecto = $this->maltaventa->getCampo('idProspecto',$id);
			        		$rowAvaluoProyectoOld = $this->mavaluoproyecto->getByIdProyectoProspecto($idProyecto_old,$idProspecto);
			        		if (!is_numeric($rowAvaluoProyectoOld)){
					    		$apOld['statusAsignacion'] = 0;
					    		$apOld['fechaDesAsignacion'] = date('Y-m-d');
					    		//$this->mavaluoproyecto->actualizar($apOld,$rowAvaluoProyectoOld['id']);
					    		$idFolioAvaluoOld = $rowAvaluoProyectoOld['idAvaluo'];
					    		$rowAvaluoProyectoOld = $this->mavaluoproyecto->getByIdAvaluo($idFolioAvaluoOld);
					    		if($rowAvaluoProyectoOld->num_rows()<3){
					    			$faOld['disponible'] = 1;
					    			//$this->mfoliosavaluo->actualizar($faOld,$idFolioAvaluoOld);
					    		}
					    	}
				    		$pyData['statusVenta'] = ($statusVentaOld>0)?$statusVentaOld:1;
	                		$this->mproyecto->actualizar($pyData, $pData['idProyecto']);
		                }


			        	//obtenemos el id AV a partir del prospecto
			        	$idProyecto = $this->maltaventa->getCampo('idProyecto',$id);
			        	$idProspecto = $this->maltaventa->getCampo('idProspecto',$id);
			        	$idFolioAvaluo = $this->mproyecto->getCampo('folioAvaluo',$idProyecto);

			        	if($idProyecto > 0){
			        		$avaluo = $this->input->post('avaluo', TRUE);
			        		$proyData['avaluo'] = ($avaluo!='')?toInt($avaluo):0.00;
			        		//$proyData['numAvaluo'] = $this->input->post('numAvaluo', TRUE);
			        		$proyData['folioAvaluo'] = $this->input->post('folioAvaluo', TRUE);
			        		$this->mproyecto->actualizar($proyData, $idProyecto);
			        	}

			        	//si es solicitud de avalúo enviamos la solicitud y los archivos
			        	$archivoSolicitud = $this->maltaventa->getCampo('pdf_17',$id);
			        	if ($pData['statusValidacion2']=='solicitud de avaluo' && $checkSolicitud==1){
			        		$this->autoRespuesta3($id);
			        	}
			        	//validamos si se eligio correccion de avaluo
			        	if ($pData['statusValidacion2']=='correccion de avaluo' || $pData['statusValidacion2']=='solicitud de avaluo'){
			        		$proyData2['folioAvaluo'] = '';
			        		$this->mproyecto->actualizar($proyData2, $idProyecto);

			        		$rowAvaluoProyecto = $this->mavaluoproyecto->getByIdProyectoProspecto($idProyecto,$idProspecto);
			        		if (!is_numeric($rowAvaluoProyecto)){
					    		$ap['statusAsignacion'] = 0;
					    		$ap['fechaDesAsignacion'] = date('Y-m-d');
					    		$this->mavaluoproyecto->actualizar($ap,$rowAvaluoProyecto['id']);
					    		$idFolioAvaluo = $rowAvaluoProyecto['idAvaluo'];
					    		$rowAvaluoProyecto = $this->mavaluoproyecto->getByIdAvaluo($idFolioAvaluo);
					    		if($rowAvaluoProyecto->num_rows()<3){
					    			$fa['disponible'] = 1;
					    			$this->mfoliosavaluo->actualizar($fa,$idFolioAvaluo);
					    		}
					    	}

			        	}
			        	//checamos si viene otro folioAvaluo nuevo
			        	if ($idFolioAvaluo != $this->input->post('folioAvaluo', TRUE)){
			        		if($this->input->post('folioAvaluo', TRUE)>0){
			        			$ap['idAvaluo'] = $this->input->post('folioAvaluo', TRUE);
			        			$ap['idProyecto'] = $idProyecto;
			        			$ap['idProspecto'] = $idProspecto;
			        			$ap['fechaAsignacion'] = date('Y-m-d');
			        			$ap['fechaDesAsignacion'] = '';
			        			$ap['statusAsignacion'] = 1;
			        			$this->mavaluoproyecto->insertar($ap);
			        			$fa['disponible'] = 0;
			        			$this->mfoliosavaluo->actualizar($fa,$ap['idAvaluo']);
			        		}
			        	}

			        	if ($pData['statusValidacion2']=='correccion de avaluo' && $checkSolicitud==1){
			        		$this->autoRespuesta3($id,'correccion');
			        	}

						// para ver el tipo de credito es de contado
						$existContado = $this->mcontadocuentas->getByIdAV($id);
						if( $pData['tipoCredito'] == 'contado' && is_numeric($existContado) ){
							$ccData['idAltaVenta'] = $id;
							$fechaContado = $this->input->post('fechaContado', true);
							$fechaContado =  str_replace('/', '-', $fechaContado);
							$ccData['fecha'] = ($fechaContado != '')? date('Y-m-d', strtotime($fechaContado)) : NULL;
							$montoContado = $this->input->post('montoContado', TRUE);
							$ccData['monto'] = toInt($montoContado); //$this->mproyecto->getCampo('precioVenta',$idProyecto);
							$ccData['monto'] = ( empty($ccData['monto']) )? 0.00 : $ccData['monto'];
							//$ccData['saldo'] = $ccData['monto'];
							$saldoContado = $this->input->post('saldoContado', TRUE);
							$ccData['saldo'] = toInt($saldoContado);
							$interes = $this->input->post('interesContado', TRUE);
							$ccData['interes'] = toInt($interes);
							$ccData['plazos'] = $this->input->post('plazosContado', TRUE);
							$pagos = $this->input->post('anticipoContado', TRUE);
							$ccData['pagos'] = toInt($pagos);
							$ccData['statusCuenta'] = 0;
							//$ccData['pagos'] = 0;
							$ccData['statusObra'] = 0;
							$ccData['status'] = 1;

							//$lineaCredito = $this->mproyecto->getCampo("lineaCredito",$pData['idProyecto']);
							//if( $lineaCredito == 1 ){
								$proyData['statusObra'] = 2;
								$this->mproyecto->actualizar($proyData,$pData['idProyecto']);
							//}
							$idContadoCuentas = $this->mcontadocuentas->insertar($ccData);
							if(is_numeric($idContadoCuentas)){
								$this->data['fotos_www'] = $this->config->item('base_www').'/contado_detalle/';

								//Subida de Imagen
								$configT = array();
								$this->load->library('upload', $configT);
								$this->load->library('image_lib');
								if (isset($_FILES)){
									$imagenes = array();
									foreach($_FILES as $key=>$value){
										if ($_FILES[$key]['size'] > 0){
											$_FILES[$key]['name'] = strtolower($_FILES[$key]['name']);
											$imagenes[] = $key;
										}
									}
									$totalImagenes = count($imagenes);
									for($i=0; $i< $totalImagenes; $i++){
										if($imagenes[$i] == 'comprobante'){
											$ext = pathinfo($_FILES[$imagenes[$i]]['name'], PATHINFO_EXTENSION);
											//Configuracion del thumbnail
											if ($imagenes[$i] != 'comprobante') {
												$nCampoC = explode("_", $imagenes[$i]);
												$tipo = $nCampoC[0];
												$v = $nCampoC[1];
											} else {
												$v = 0;
												$tipo = 'foto';
											}
						
											if ($tipo == 'foto'){
												$uploaddir = $this->data['fotos_www'];
												$configT['upload_path'] = $uploaddir;
												$configT['image_library'] = 'gd2';
												$configT['create_thumb'] = FALSE;
												$configT['maintain_ratio'] = FALSE;
												//$configT['width'] = 150;
												//$configT['height'] = 150;
												//Configuracion de la libreria upload
												$nextId = $this->mcontadodetalle->nextId();
												$configT['file_name'] =  $nextId."_".$v;
												$configT['overwrite'] = TRUE;
												$configT['upload_path'] = $uploaddir;
												$configT['max_size'] = '3072';
												$configT['allowed_types'] = 'gif|jpg|png|jpeg';
												$this->upload->initialize($configT);
						
												if ( ! $this->upload->do_upload($imagenes[$i]))
												{
													$redirect = 1;
													$data['msg'] = $this->upload->display_errors();
												}
												else
												{
													$dataFile = $this->upload->data($imagenes[$i]);
													$fotoI = 'comprobante';
													if ($v == 0){
														//Foto default
														$cdData['comprobante'] = $nextId.'_'.$v.'.'.$ext;
														$configT['source_image'] = $uploaddir.$cdData['comprobante'];
														if($ext != 'pdf'){
															$this->image_lib->clear();
															$this->image_lib->initialize($configT);
															$this->image_lib->resize();
														}
													} else {
														$cdData[$fotoI] = $nextId.'_'.$v.'.'.$ext;
														$configT['source_image'] = $uploaddir.$cdData[$fotoI];
														if($ext != 'pdf'){
															$this->image_lib->clear();
															$this->image_lib->initialize($configT);
															$this->image_lib->resize();
														}
													}
												}
											}
										}
									}
								}

								$cdData['idCuenta'] = $idContadoCuentas;
								$fechaPago = $_POST['fechaPagoPagare'];
								$fechaPago =  str_replace('/', '-', $fechaPago);
								$cdData['fecha'] = ($fechaPago != '')? date('Y-m-d', strtotime($fechaPago)) : NULL;
								$cdData['formaPago'] = $_POST['tipoPago'];
								$cdData['tipo'] = 1;
								$cdData['descripcion'] = "DEPOSITO DE ANTICIPO";
								$cdData['importe'] = toInt($_POST['anticipoContado']);
								$cdData['saldo'] = toInt($_POST['saldoContado']);
								$cdData['statusDetalle'] = 1;
								$cdData['movimiento'] = $_POST['movimiento'];
								$cdData['cuenta'] = "0330679992";
								$cdData['status'] = 1;
								$id = $this->mcontadodetalle->insertar($cdData);
							}
						}else if($pData['tipoCredito'] == 'contado' && !is_numeric($existContado)){
							$ccData['idAltaVenta'] = $id;
							$fechaContado = $this->input->post('fechaContado', true);
							$fechaContado =  str_replace('/', '-', $fechaContado);
							$ccData['fecha'] = ($fechaContado != '')? date('Y-m-d', strtotime($fechaContado)) : NULL;
							$montoContado = $this->input->post('montoContado', TRUE);
							$ccData['monto'] = toInt($montoContado); //$this->mproyecto->getCampo('precioVenta',$idProyecto);
							$ccData['monto'] = ( empty($ccData['monto']) )? 0.00 : $ccData['monto'];
							//$ccData['saldo'] = $ccData['monto'];
							$saldoContado = $this->input->post('saldoContado', TRUE);
							$ccData['saldo'] = toInt($saldoContado);
							$interes = $this->input->post('interesContado', TRUE);
							$ccData['interes'] = toInt($interes);
							$ccData['plazos'] = $this->input->post('plazosContado', TRUE);
							$pagos = $this->input->post('anticipoContado', TRUE);
							$ccData['pagos'] = toInt($pagos);
							//$ccData['statusCuenta'] = 0;
							//$ccData['pagos'] = 0;
							$ccData['statusObra'] = 0;
							$ccData['status'] = 1;

							$proyData['statusObra'] = 2;
							$this->mproyecto->actualizar($proyData,$pData['idProyecto']);

							$this->mcontadocuentas->actualizar($ccData, $existContado['id']);

							$qContadoDet = $this->mcontadodetalle->getByIdContadoAnticipo($existContado['id']);
							$insertar = true;
							$idContadoDetalle = 0;
							if(!is_numeric($qContadoDet)){
								$insertar = false;
								$idContadoDetalle = $qContadoDet['id'];
								if($qContadoDet['comprobante'] == ''){
									$this->data['fotos_www'] = $this->config->item('base_www').'/contado_detalle/';

									//Subida de Imagen
									$configT = array();
									$this->load->library('upload', $configT);
									$this->load->library('image_lib');
									if (isset($_FILES)){
										$imagenes = array();
										foreach($_FILES as $key=>$value){
											if ($_FILES[$key]['size'] > 0){
												$_FILES[$key]['name'] = strtolower($_FILES[$key]['name']);
												$imagenes[] = $key;
											}
										}
										$totalImagenes = count($imagenes);
										for($i=0; $i< $totalImagenes; $i++){
											if($imagenes[$i] == 'comprobante'){
												$ext = pathinfo($_FILES[$imagenes[$i]]['name'], PATHINFO_EXTENSION);
												//Configuracion del thumbnail
												if ($imagenes[$i] != 'comprobante') {
													$nCampoC = explode("_", $imagenes[$i]);
													$tipo = $nCampoC[0];
													$v = $nCampoC[1];
												} else {
													$v = 0;
													$tipo = 'foto';
												}
							
												if ($tipo == 'foto'){
													$uploaddir = $this->data['fotos_www'];
													$configT['upload_path'] = $uploaddir;
													$configT['image_library'] = 'gd2';
													$configT['create_thumb'] = FALSE;
													$configT['maintain_ratio'] = FALSE;
													//$configT['width'] = 150;
													//$configT['height'] = 150;
													//Configuracion de la libreria upload
													$nextId = $this->mcontadodetalle->nextId();
													$configT['file_name'] =  $nextId."_".$v;
													$configT['overwrite'] = TRUE;
													$configT['upload_path'] = $uploaddir;
													$configT['max_size'] = '3072';
													$configT['allowed_types'] = 'gif|jpg|png|jpeg';
													$this->upload->initialize($configT);
							
													if ( ! $this->upload->do_upload($imagenes[$i]))
													{
														$redirect = 1;
														$data['msg'] = $this->upload->display_errors();
													}
													else
													{
														$dataFile = $this->upload->data($imagenes[$i]);
														$fotoI = 'comprobante';
														if ($v == 0){
															//Foto default
															$cdData['comprobante'] = $nextId.'_'.$v.'.'.$ext;
															$configT['source_image'] = $uploaddir.$cdData['comprobante'];
															if($ext != 'pdf'){
																$this->image_lib->clear();
																$this->image_lib->initialize($configT);
																$this->image_lib->resize();
															}
														} else {
															$cdData[$fotoI] = $nextId.'_'.$v.'.'.$ext;
															$configT['source_image'] = $uploaddir.$cdData[$fotoI];
															if($ext != 'pdf'){
																$this->image_lib->clear();
																$this->image_lib->initialize($configT);
																$this->image_lib->resize();
															}
														}
													}
												}
											}
										}
									}
								}
							}

							$cdData['idCuenta'] = $existContado['id'];
							$fechaPago = $_POST['fechaPagoPagare'];
							$fechaPago =  str_replace('/', '-', $fechaPago);
							$cdData['fecha'] = ($fechaPago != '')? date('Y-m-d', strtotime($fechaPago)) : NULL;
							$cdData['formaPago'] = $_POST['tipoPago'];
							$cdData['tipo'] = 1;
							$cdData['descripcion'] = "DEPOSITO DE ANTICIPO";
							$cdData['importe'] = toInt($_POST['anticipoContado']);
							$cdData['saldo'] = toInt($_POST['saldoContado']);
							$cdData['statusDetalle'] = 1;
							$cdData['movimiento'] = $_POST['movimiento'];
							$cdData['cuenta'] = "0330679992";
							$cdData['status'] = 1;

							$idDetalle = ($insertar) ? $this->mcontadodetalle->insertar($cdData) : $this->mcontadodetalle->actualizar($cdData, $idContadoDetalle);
						}
						// fin del tipo credito para contado
		            	redirect($this->router->class."?close");

		        	}else{
		        		$data['msgInvalid'] = 'Verifique que la información este correcta';
		        	}

		        }
	        }

	        // Mensajes
	        $data['msg'] = '';
			$info = $this->maltaventa->getByIdAll($id);
			//print_r($info);exit(););

        	$data = (!is_numeric($info))?$info:'';
        	$data['disabled'] = (!is_numeric($info))?false:true;

        	if(is_numeric($info)){
        		$data['id']='';
        		$data['msgInvalid'] = 'El NSS elegido no está asociado a un prospecto';
        	}else{
        		$data['msgInvalid'] = '';
        		$idProyecto = $info['idProyecto'];
        		$idFolioAvaluo = $this->mproyecto->getCampo('folioAvaluo',$idProyecto);
        	}
        	//$data['proyectos'] = 0;
        	//$data['idProyecto'] = NULL;
	    	//$data['projectSelected'] = 0;
	        $data['altas'] = $this->maltaventa->getNSS();
	        $data['mpromotor'] = $this->musuario;
	        $data['notarias'] = $this->mnotaria->getSelectResult();
	        $data['unidad'] = $this->munidad_valuadora->getSelectResult();
	        $data['proyectos'] = $this->mproyecto->getBySelectResult2($info['idFraccionamiento']);
	        $data['projectSelected'] = $this->mproyecto->getById(($data!='')?$data['idProyecto']:0);
	        $data['fraccionamiento'] = (!is_numeric($info))?$this->mfraccionamiento->getCampo('titulo',$info['idFraccionamiento']):'';
	        $data['foliosAvaluo'] = $this->mfoliosavaluo->getAll($idFolioAvaluo);
			$qContado = $this->mcontadocuentas->getByIdAV($id);
			$formaPago = '';
			$movimiento = '';
			$fechaPago = '';
			$comprobante = '';
			if( !is_numeric($qContado) ){
				$qContadoDetalle = $this->mcontadodetalle->getByIdContadoAnticipo($qContado['id']);
				$formaPago = (!is_numeric($qContadoDetalle)) ? $qContadoDetalle['formaPago'] : '';
				$movimiento = (!is_numeric($qContadoDetalle)) ? $qContadoDetalle['movimiento'] : '';
				$fechaPago = (!is_numeric($qContadoDetalle)) ? $qContadoDetalle['fecha'] : '';
				$fechaPago = ($fechaPago != '') ? date('d/m/Y', strtotime($fechaPago)) : '';
				$comprobante = (!is_numeric($qContadoDetalle)) ? $qContadoDetalle['comprobante'] : '';
				$data['idContado'] = $qContado['id'];
				$data['statusCuenta'] = $qContado['statusCuenta'];
				$data['fechaContado'] = date('d/m/Y', strtotime($qContado['fecha']) );
				$data['plazosContado'] = $qContado['plazos'];
				$data['montoContado'] = $qContado['monto'];
				$data['saldoContado'] = $qContado['saldo'];
				$data['interesContado'] = $qContado['interes'];
			}else{
				$data['fechaContado'] = '';
				$data['statusCuenta'] = 0;
				$data['plazosContado'] = 6;
				$data['montoContado'] = ( !is_numeric($info) )? $info['precioVenta'] : '0.00';
				$data['saldoContado'] = ( !is_numeric($info) )? $info['precioVenta'] : '0.00';
				$data['interesContado'] = '0.00';
			}
			$data['formaPago'] = $formaPago;
			$data['movimiento'] = $movimiento;
			$data['fechaPago'] = $fechaPago;
			$data['comprobante'] = $comprobante;
	        //echo $idFolioAvaluo; exit();
	        $this->data['contenido'] = $this->load->view($this->mainView . '/editar_view', $data, true);
	        $this->load->view('templates/main_template', $this->data);

	    }

		public function ver($id = null)
	    {
	        //Obtenemos el id del Proyecto a aprtir de id alta venta
	        $id = $this->maltaventa->getCampo("idProyecto",$id);
	        $info = $this->mproyecto->getById($id);
	        $data = $info;
	        $data['etapa_alta_venta'] = false;
	        $data['etapa_validacion_venta'] = false;
	        $data['etapa_gestoria'] = false;
	        $data['etapa_comisionbono'] = false;
	        $data['etapa_autorizaciones'] = false;
	        $data['etapa_deposito'] = false;
	        $data['etapa_entrega'] = false;
	        $data['etapa_encuesta'] = false;
	        $data['etapa_postventa'] = false;

	        $altaVenta = $this->maltaventa->getStatusByIdProyecto($id);
	        $idAltaVenta = $this->maltaventa->getIdAltaVentaByIdProyecto($id);
	        $statusProyecto = (!is_numeric($altaVenta))?$altaVenta->row()->statusValidacion:'';

			/*switch ($statusProyecto) {
	            case '0':
	                $data['etapa_alta_venta'] = true;
	                $data['detalle_venta'] = $this->maltaventa->getAltaVentaByIdProy($id);
	                break;
	            case '1':
	                $data['etapa_alta_venta'] = true;
	                $data['etapa_validacion_venta'] = true;
	                $data['detalle_venta'] = $this->maltaventa->getValidacionVentaByIdProy($id);
	                break;
	            case '2':
	                $data['etapa_alta_venta'] = true;
	                $data['etapa_validacion_venta'] = true;
	                $data['detalle_venta'] = $this->maltaventa->getValidacionVentaByIdProy($id);
	                break;
	            case '3':
	            case '4':
	            case '5':
	                $data['etapa_alta_venta'] = true;
	                $data['etapa_validacion_venta'] = true;
	                $data['etapa_gestoria'] = true;
	                $data['detalle_venta'] = $this->maltaventa->getGestoriaByIdProy($id);

	                $comisiones = $this->mcomisionbono->getByIdAV($data['detalle_venta']['id']);//($idAltaVenta->row()->id);
	                if ( !is_numeric($comisiones) ) {
	                    $data['etapa_comisionbono'] = true;
	                    $data['detalle_comisionbono'] = $comisiones;

	                }

	                $autorizaciones = $this->mautorizacion->getByIdAV($data['detalle_venta']['id']);
	                if ( !is_numeric($autorizaciones) ) {
	                    $data['etapa_autorizaciones'] = true;
	                    $data['detalle_autorizaciones'] = $autorizaciones;
	                }

	                $deposito = $this->mdeposito->getByIdAV($data['detalle_venta']['id']);
	                if ( !is_numeric($deposito) ) {
	                    $data['etapa_deposito'] = true;
	                    $data['detalle_deposito'] = $deposito;
	                }

	                $entrega = $this->mentrega->getByIdAV($data['detalle_venta']['id']);
	                if ( !is_numeric($entrega) ) {
	                    $data['etapa_entrega'] = true;
	                    $data['detalle_entrega'] = $entrega;
	                }

	                $encuesta = $this->mencuestavivienda->getByIdAV($data['detalle_venta']['id']);
	                if ( !is_numeric($entrega) ) {
	                    $data['etapa_encuesta'] = true;
	                    $data['detalle_encuesta'] = $encuesta;
	                }

	                $postventa = $this->mpostventa->getByIdAV($data['detalle_venta']['id']);
	                if ( !is_numeric($postventa) ) {
	                    $data['etapa_postventa'] = true;
	                    $data['detalle_postventa'] = $postventa;
	                }
	                break;
	            default:
	                break;
	        }*/

	        $data['etapa_alta_venta'] = true;
            $data['etapa_validacion_venta'] = true;
            $data['detalle_venta'] = $this->maltaventa->getValidacionVentaByIdProy($id);

	        $data['module'] = 0;//( !is_null($module) ? 'busqueda_vivienda' : 0);
	        $data['mpromotor'] = $this->musuario;
	        $data['mprototipoxfraccionamiento'] = $this->mprototipoxfraccionamiento;
	        $data['mprototipos'] = $this->mprototipos;
	        $this->data['contenido'] = $this->load->view($this->mainView . '/ver_view', $data, true);
	        $this->load->view('templates/main_template', $this->data);
	    }

	    public function eliminar_archivo()
	    {
	        if (isset($_POST['elid'])){
	            $id = $this->input->post('elid');
	            $campo = $this->input->post('elcampo'); //Obteniendo el nombre de la foto y thumbnail
	            if($campo !="0"){
	                $archivo = $this->maltaventa->getCampo('pdf_'.$campo,$id);
	                if(unlink($this->data['fotos_www'].$archivo)){// Haciendo update a la tabla
	                    $c_data['pdf_'.$campo] ='';
	                    $this->maltaventa->actualizar($c_data,$id);
	                    $c_valor = "true";
	                    //$this->msomos->borrar($id);
	                }else{ $c_valor = "false";}
	            }else{
	                $archivo = $this->maltaventa->getCampo('pdf',$id);
	                if(unlink($this->data['fotos_www'].$archivo)){// Haciendo update a la tabla
	                    $c_data['pdf'] ='';
	                    $this->maltaventa->actualizar($c_data,$id);
	                    $c_valor = "true";
	                    //$this->msomos->borrar($id);
	                }else{ $c_valor = "false";}
	            }
	            $data = json_encode(array("valor"=>$c_valor));
	            echo $data;

	        }
	    }

	    //formato pagaré
	    public function pagare($id){
	    	$this->load->library("mpdf_lib");
	        $data = '';
	        $info = $this->maltaventa->getByIdAll($id);
	        $data = $info;
	        $data['mfraccionamiento'] = $this->mfraccionamiento;

	        $this->idFraccionamiento = $info['idFraccionamiento'];
        	$this->setLogo();
	        $html = $this->load->view('formatospdf/pagare_view.php',$data,true);
	        /*echo $html;
	        exit();*/
	        $this->mpdf_lib->downloadPDF($html,"pagare",0,'footer','header',$this->urlLogo);
	    }

	    public function guardarDatosPagare(){


	     	$fechaPagoPagare = $this->input->post('fechaPagoPagare', TRUE);
		    $fechaPagoPagare = str_replace('/', '-', $fechaPagoPagare);
		    $pData['fechaPagoPagare'] = ($fechaPagoPagare == '')?'0000-00-00':date('Y-m-d', strtotime($fechaPagoPagare));
            $pData['idProyecto'] = $this->input->post('idProyecto', TRUE);
	     	$montoPagare = $this->input->post('montoPagare', TRUE);
		    $pData['montoPagare'] = toInt($montoPagare);
	     	$pData['numSeriePagare'] = $this->input->post('numSeriePagare', TRUE);
	     	$pData['interesPagare'] = $this->input->post('interesPagare', TRUE);
	     	$id = $this->input->post('altaVenta', TRUE);
	    	/*print_r($pData);
	     	echo $id;
	     	exit();*/
            $data['success'] =  $this->maltaventa->actualizar($pData, $id);
            echo  json_encode($data);
	    }

	    function autoRespuesta( $idAltaventa = null ) {
	        // $copias = "ruben@navegantes.mx";
	        $copiasNV = 'sistemas@viviend.mx,';
	        $copiasNV .= 'ruben@navegantes.mx';


	        /*$copiasNV = 'hsalinas@viviend.mx'. ', ';
	        $copiasNV .= 'esalinas@viviend.mx';*/


	        // $para = $emailCliente; // Comprador

	        $subject = 'Validación de venta'; // titulo

	        $liga="http://viviend.mx/sistema/emailresources/";
	        $liga2="http://viviend.mx/sistema/img/";
	        $liga3="http://viviend.mx/sistema/";

	        $tp = '';

	        $data = array();

	        $altaventa = $this->maltaventa->getById($idAltaventa);
	        // Datos de prospecto
	        $prospecto = $this->mprospecto->getById($altaventa['idProspecto']);
	        // Datos de proyecto
	        $proyecto = $this->mproyecto->getById($altaventa['idProyecto']);
	        // Datos de fraccionamiento
	        $fraccionamiento = $this->mfraccionamiento->getById($proyecto['idFraccionamiento']);
	        // Datos de promotor
	        $promotor = $this->musuario->getById($prospecto['idPromotor']);
	        $nomPromotor = $promotor["nombre"]." ".$promotor["apellidoP"]." ".$promotor["apellidoM"];
	        $emailPromotor = $promotor["email"];
	        // $idFraccionamiento = $_SESSION['viv']['idFraccionamiento'];
	        $idFraccionamiento = $proyecto['idFraccionamiento'];
	        $fotoFracc = $this->mfraccionamiento->getCampo('foto',$idFraccionamiento);
	        $urlLogoFracc = ($fotoFracc!=false)?'http://viviend.mx/sistema/uploads/fraccionamientos/'.$fotoFracc:'http://viviend.mx/sistema/img/logo-300.png';


	        $cuerpo = '<table id="table-validacion-venta" style="width: 80%;margin: 0 auto;border: 3px solid #EAC633;border-spacing: 0px;text-transform: uppercase;">
	        				<tbody>
	        					<tr>
	        						<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> Fecha de prospecci&oacute;n: </td>
	        						<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.date_format(new DateTime($prospecto['fecha']), 'd/m/Y').' </td>
	        					</tr>
	        					<tr>
	        						<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> Nombre de prospecto: </td>
	        						<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$prospecto['nombre'].' '.$prospecto['apellidoP'].' '.$prospecto['apellidoM'].' </td>
	        					</tr>
	        					<tr>
	        						<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> RFC: </td>
	        						<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$prospecto['rfc'].' </td>
	        					</tr>
	        					<tr>
	        						<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> Tel&eacute;fono: </td>
	        						<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$prospecto['telefono'].' </td>
	        					</tr>
	        					<!--<tr>
	        						<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> Nombre promotor: </td>
	        						<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$nomPromotor.' </td>
	        					</tr>-->
	        					<tr>
	        						<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> Fraccionamiento: </td>
	        						<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$fraccionamiento['titulo'].' </td>
	        					</tr>
	        					<tr>
	        						<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> Estado: </td>
	        						<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$fraccionamiento['estado'].' </td>
	        					</tr>
	        					<tr>
	        						<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> Municipio: </td>
	        						<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$fraccionamiento['municipio'].' </td>
	        					</tr>
	        					<tr>
	        						<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> Lote: </td>
	        						<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$proyecto['lote'].' </td>
	        					</tr>
	        					<tr>
	        						<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> Manzana: </td>
	        						<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$proyecto['manzana'].' </td>
	        					</tr>
	        					<tr>
	        						<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> Calle: </td>
	        						<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$proyecto['calle'].' </td>
	        					</tr>
	        					<tr>
	        						<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> N&uacute;mero oficial: </td>
	        						<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$proyecto['nOficial'].' </td>
	        					</tr>
	        					<tr>
	        						<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> Clave catastral: </td>
	        						<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$proyecto['claveCatastral'].' </td>
	        					</tr>
	        					<tr>
	        						<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> Superficie de terreno: </td>
	        						<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$proyecto['supTerreno'].' </td>
	        					</tr>
	        					<tr>
	        						<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> Superficie de construcci&oacute;n: </td>
	        						<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$proyecto['supConstruccion'].' </td>
	        					</tr>
	        					<tr>
	        						<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> Precio de venta: </td>
	        						<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$proyecto['precioVenta'].' </td>
	        					</tr>
	        					<tr>
	        						<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> Revisión de montos: </td>
	        						<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$altaventa['revisionMontos'].' </td>
	        					</tr>
	        					<tr>
	        						<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> Tipo de crédito: </td>
	        						<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$altaventa['tipoCredito'].' </td>
	        					</tr>
	        					<tr>
	        						<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> Diferencia: </td>
	        						<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$altaventa['diferencia'].' </td>
	        					</tr>
	        					<tr>
	        						<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> Bono de equipamiento: </td>
	        						<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$altaventa['bonoEquipamiento'].' </td>
	        					</tr>
	        					<tr>
	        						<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> Id Notaría: </td>
	        						<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$altaventa['idNotaria'].' </td>
	        					</tr>
	        				</tbody>
	        			</table>';

	        $mensaje = '
	        <!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 3.2 Final//EN">
	        <html xmlns="http://www.w3.org/1999/xhtml">
	        <head>
	            <title>Email</title>
	            <meta http-equiv="Content-Type" content="text/html; charset=utf-8">
	            <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=yes" />
	            <link href="https://fonts.googleapis.com/css?family=Lato:300,700" rel="stylesheet" type="text/css">
	            <style>
	                body, tr, td, span, div, p, a, li {
	                    -moz-text-size-adjust:none !important;
	                    -webkit-text-size-adjust:none !important;
	                    margin:0px !important;
	                    -ms-text-size-adjust:none !important;
	                    white-space: wrap;
	                }
	                .lato-light{
	                    font-family: "lato" sans-serif !important;
	                    font-weight: 300;
	                }
	                .lato-bold{
	                    font-family: "lato" sans-serif !important;
	                    font-weight: 700;
	                }
	                td img {
	                    display: block;
	                }
	                .ReadMsgBody {
	                    width: 100%;
	                }
	                .ExternalClass * {
	                    line-height: 100%;
	                }
	                @media only screen and (max-width:480px) {
	                    #logosim{
	                        padding:0!important;
	                    }
	                    *[class="code4email_wrapper"] {
	                        width: 100% !important;
	                    }
	                    *[class="code4email_main_table"] {
	                        width: 320px !important;
	                    }
	                    *[class="code4email_hide"] {
	                        display: none !important;
	                    }
	                    *[class="code4email_hide"] {
	                        display: none !important;
	                    }
	                    *[class="code4email_center"] {
	                        text-align: center !important;
	                        padding:10px !important;
	                        height:20px !important;
	                    }
	                    *[class="code4email_clear"] {
	                        width: 100% !important;
	                        clear: both !important;
	                        float: left !important;
	                    }
	                    *[class="code4email_br"] {
	                        display:block !important;
	                        width: 1px !important;
	                        height:6px !important;
	                        clear: both !important;
	                    }
	                    *[class="code4email_text_p10"] {
	                        padding: 0px 10px 10px 10px !important;
	                        height:20px !important;
	                    }
	                    *[class="code4email_w20"] {
	                        width: 20px !important;
	                    }
	                    *[class="code4email_h20"] {
	                        height: 20px !important;
	                    }
	                    *[class="code4email_h20_center"] {
	                        height: 20px !important;
	                        text-align: center !important;
	                    }
	                }
	                @media only screen and (min-width:480px) and (max-width:599px) {
	                    *[class="code4email_wrapper"] {
	                        width: 100% !important;
	                    }
	                    *[class="code4email_main_table"] {
	                        width: 480px !important;
	                    }
	                    *[class="code4email_hide"] {
	                        display: none !important;
	                    }
	                    *[class="code4email_hide"] {
	                        display: none !important;
	                    }
	                    *[class="code4email_center"] {
	                        text-align: center !important;
	                        padding:10px !important;
	                        height:20px !important;
	                    }
	                    *[class="code4email_clear"] {
	                        width: 100% !important;
	                        clear: both !important;
	                        float: left !important;
	                    }
	                    *[class="code4email_br"] {
	                        display:block !important;
	                        width: 1px !important;
	                        height:6px !important;
	                        clear: both !important;
	                    }
	                    *[class="code4email_text_p10"] {
	                        padding: 0px 10px 10px 10px !important;
	                        height:20px !important;
	                    }
	                    *[class="code4email_w20"] {
	                        width: 20px !important;
	                    }
	                    *[class="code4email_h20"] {
	                        height: 20px !important;
	                    }
	                    *[class="code4email_h20_center"] {
	                        height: 20px !important;
	                        text-align: center !important;
	                    }
	                }
	            </style>
	        </head>
	        <body marginheight="0" marginwidth="0" leftmargin="0" topmargin="0" bgcolor="#FFFFFE" style="-moz-text-size-adjust:none !important; padding:0px !important; -webkit-text-size-adjust:none !important; margin:0px ! important; -ms-text-size-adjust:none !important; white-space: wrap;">
	            <table class="code4email_wrapper" width="650px" border="0" cellspacing="0" cellpadding="0" align="center">
	                <tr> <td colspan="" style="text-align: right !important;"> Fecha: '.date('d/m/Y').' </td> </tr>
	                <tr>
	                    <td align="center" valign="top" bgcolor="#FFFFFE"><table class="code4email_wrapper" align="center" border="0" cellpadding="0" cellspacing="0" width="650px" style="width:650px;">
	                        <tr>
	                            <td>
	                                <a href="'.$liga3.'" target="_blank">
	                                    <table   height="135px" background="" class="code4email_wrapper"  width="650px" border="0" cellspacing="0" cellpadding="0" align="center">
	                                        <tr>
	                                            <td  valign="middle" width="200" height="109" style="margin:0px; padding:10px 225px 10px 225px; height:109px; width: 200px;">
	                                                <img width="280" src="'.$urlLogoFracc.'" />
	                                            </td>
	                                        </tr>
	                                    </table>
	                                </a>
	                            </td>
	                        </tr>
	                        <tr>
	                            <td align="left" valign="top" style="line-height:12px; padding:0px; margin:0px; font-size:12px; width:650px;">
	                                <table class="code4email_wrapper" align="center" border="0" cellpadding="0" cellspacing="0" width="650" style="width:650px;">
	                                    <tr>
	                                        <td align="left" valign="middle" width="600" height="91" bgcolor="#FFFFFE" style="width:630px; margin:0px; height:91px; padding-bottom:15px; padding-top:25px; font-family: Arial, Helvetica, sans-serif; color: #333333; font-size: 14px; mso-line-height-rule:exactly; white-space: wrap; line-height:20px;" class="code4email_center"><span style="color: #5b5b5f; font-size: 14px; text-decoration: none;" class="lato-light">
	                                            <!--<h1 style="color: #57BA47;font-weight: bold;text-align: center;text-transform: uppercase;"> Validación de venta </h1>-->
	                                            <h3 style="color: #57BA47;font-weight: bold;text-align: center;text-transform: uppercase;font-size:24px;margin-bottom: 0px;"> Validación de venta </h3>
	                                            <h4 style="color: #57BA47;font-weight: bold;text-align: center;text-transform: uppercase;font-size:16px;margin-top: 10px;"> De '.$nomPromotor.' </h4>
	                                            <br><br>
	                                            '.$cuerpo.'
	                                        </td>
	                                    </tr>

	                                </table>
	                                <div style="background: #548C43; width: 100%; border: 1px solid #548C43; height: 25px; margin-top: 75px !important;"></div>
	                            </td>
	                        </tr>
	                    </td>
	                </tr>
	            </table>
	        </body>
	        </html>';

	        // para el gerente de ventas -------------------------------------------------
	        // Para enviar un correo HTML, debe establecerse la cabecera Content-type
	        $cabeceras  = 'MIME-Version: 1.0' . "\r\n";
	        $cabeceras .= "Content-type:text/html;charset=utf-8" . "\n";
	        // Cabeceras adicionales
	        $cabeceras .= 'From: Viviend <contacto@viviend.mx>' . "\r\n";

	        //mail para gerente
	        //$para = $this->musuario->getCampo("email", $this->musuario->getGerente2($proyecto['idFraccionamiento']));
	        if($this->appProduction){
				$qGerentes = $this->musuario->getGerentes2($proyecto['idFraccionamiento']);
				if( !is_numeric($qGerentes) ){
					foreach($qGerentes->result() as $gteV){
						$para = $this->musuario->getCampo("email", $gteV->id);
						if ($para){
							mail($para, $subject, $mensaje, $cabeceras);
						}
					}
				}

		        $dGestores = $this->mfraccionamientoxusuario->getGestoriaSelectResultByIdFracc($proyecto['idFraccionamiento']);
	            if ( !is_numeric($dGestores) ) {
	                foreach ($dGestores->result() as $row) {
	                	mail($this->musuario->getCampo('email',$row->id), $subject, $mensaje, $cabeceras);
	                }
	            }
	            if ($emailPromotor != '')
	            {
	            	mail($emailPromotor, $subject, $mensaje, $cabeceras);
	            }

	            $subject2 = $subject;

		        // para el gerente  -------------------------------------------------
		        $cabecerasAdmin  = 'MIME-Version: 1.0' . "\r\n";
		        $cabecerasAdmin .= "Content-type:text/html;charset=utf-8" . "\n";

		        // Cabeceras adicionales
		        $cabecerasAdmin .= 'From: Viviend <contacto@viviend.mx>' . "\r\n";

		        // para el administrador
		        mail($copiasNV, $subject2, $mensaje, $cabecerasAdmin);
		     } else{
	     		mail('sistemas@viviend.mx', $subject, $mensaje, $cabeceras);
             	mail('sistemas@viviend.mx', $subject, $mensaje, $cabeceras);
             	mail('alfredo@navegantes.mx', $subject, $mensaje, $cabeceras);
             	mail('alvaro@navegantes.mx', $subject, $mensaje, $cabeceras);
		    }
            return true;
	    }

	    function autoRespuesta2( $object = null, $idAltaventa = null ) {
	        /*$copiasNV = 'sistemas@viviend.mx, ';
	        $copiasNV .= 'ruben@navegantes.mx';*/

	        $copiasNV = 'hsalinas@viviend.mx'. ', ';
	        $copiasNV .= 'esalinas@viviend.mx';

	        $altaventa = $this->maltaventa->getById($idAltaventa);
	        $prospecto = $this->mprospecto->getById($altaventa['idProspecto']);
	        $promotor = $this->musuario->getById($prospecto['idPromotor']);
	        // $gte = $this->musuario->getCampo('email',$promotor['created_by']);
	        // $gte = $this->musuario->getCampo("email", $this->musuario->getGerente());
	        $gte = $this->musuario->getCampo("email", $this->musuario->getGerente2($prospecto['idFraccionamiento']));

	        $subject = 'Documentación incompleta'; // titulo

	        $liga="http://viviend.mx/sistema/emailresources/";
	        $liga2="http://viviend.mx/sistema/img/";
	        $liga3="http://viviend.mx/sistema/";


	        $cuerpo = '<span class="lato-light" style="color: #7b7a7a; font-size: 18px; text-decoration: none; width: 100%;">
	                        Documentación incompleta o errónea, envia tus cambios o correciones a: '.$gte.'
	                    </span><br><br>
	                    <span class="lato-light" style="color: #7b7a7a; font-size: 18px; text-decoration: none; width: 100%;">
	                        Posibles Documentos faltantes:
	                    </span><br>';

	        if ( $object['statusPdf_1'] == 0 ) { $cuerpo .= '<span> -> Acta </span><br>'; }
	        if ( $object['statusPdf_2'] == 0 ) { $cuerpo .= '<span> -> IFE </span><br>'; }
	        if ( $object['statusPdf_3'] == 0 ) { $cuerpo .= '<span> -> CURP </span><br>'; }
	        if ( $object['statusPdf_4'] == 0 ) { $cuerpo .= '<span> -> Bansefi </span><br>'; }
	        if ( $object['statusPdf_5'] == 0 ) { $cuerpo .= '<span> -> Pre-Calificación </span><br>'; }
	        if ( $object['statusPdf_6'] == 0 ) { $cuerpo .= '<span> -> Curso </span><br>'; }
	        if ( $object['statusPdf_7'] == 0 ) { $cuerpo .= '<span> -> Solicitud de crédito </span><br>'; }

	        $mensaje = '
	        <!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 3.2 Final//EN">
	        <html xmlns="http://www.w3.org/1999/xhtml">
	        <head>
	            <title>Email</title>
	            <meta http-equiv="Content-Type" content="text/html; charset=utf-8">
	            <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=yes" />
	            <link href="https://fonts.googleapis.com/css?family=Lato:300,700" rel="stylesheet" type="text/css">
	            <style>
	                body, tr, td, span, div, p, a, li {
	                    -moz-text-size-adjust:none !important;
	                    -webkit-text-size-adjust:none !important;
	                    margin:0px !important;
	                    -ms-text-size-adjust:none !important;
	                    white-space: wrap;
	                }
	                .lato-light{
	                    font-family: "lato" sans-serif !important;
	                    font-weight: 300;
	                }
	                .lato-bold{
	                    font-family: "lato" sans-serif !important;
	                    font-weight: 700;
	                }
	                td img {
	                    display: block;
	                }
	                .ReadMsgBody {
	                    width: 100%;
	                }
	                .ExternalClass * {
	                    line-height: 100%;
	                }
	                @media only screen and (max-width:480px) {
	                    #logosim{
	                        padding:0!important;
	                    }
	                    *[class="code4email_wrapper"] {
	                        width: 100% !important;
	                    }
	                    *[class="code4email_main_table"] {
	                        width: 320px !important;
	                    }
	                    *[class="code4email_hide"] {
	                        display: none !important;
	                    }
	                    *[class="code4email_hide"] {
	                        display: none !important;
	                    }
	                    *[class="code4email_center"] {
	                        text-align: center !important;
	                        padding:10px !important;
	                        height:20px !important;
	                    }
	                    *[class="code4email_clear"] {
	                        width: 100% !important;
	                        clear: both !important;
	                        float: left !important;
	                    }
	                    *[class="code4email_br"] {
	                        display:block !important;
	                        width: 1px !important;
	                        height:6px !important;
	                        clear: both !important;
	                    }
	                    *[class="code4email_text_p10"] {
	                        padding: 0px 10px 10px 10px !important;
	                        height:20px !important;
	                    }
	                    *[class="code4email_w20"] {
	                        width: 20px !important;
	                    }
	                    *[class="code4email_h20"] {
	                        height: 20px !important;
	                    }
	                    *[class="code4email_h20_center"] {
	                        height: 20px !important;
	                        text-align: center !important;
	                    }
	                }
	                @media only screen and (min-width:480px) and (max-width:599px) {
	                    *[class="code4email_wrapper"] {
	                        width: 100% !important;
	                    }
	                    *[class="code4email_main_table"] {
	                        width: 480px !important;
	                    }
	                    *[class="code4email_hide"] {
	                        display: none !important;
	                    }
	                    *[class="code4email_hide"] {
	                        display: none !important;
	                    }
	                    *[class="code4email_center"] {
	                        text-align: center !important;
	                        padding:10px !important;
	                        height:20px !important;
	                    }
	                    *[class="code4email_clear"] {
	                        width: 100% !important;
	                        clear: both !important;
	                        float: left !important;
	                    }
	                    *[class="code4email_br"] {
	                        display:block !important;
	                        width: 1px !important;
	                        height:6px !important;
	                        clear: both !important;
	                    }
	                    *[class="code4email_text_p10"] {
	                        padding: 0px 10px 10px 10px !important;
	                        height:20px !important;
	                    }
	                    *[class="code4email_w20"] {
	                        width: 20px !important;
	                    }
	                    *[class="code4email_h20"] {
	                        height: 20px !important;
	                    }
	                    *[class="code4email_h20_center"] {
	                        height: 20px !important;
	                        text-align: center !important;
	                    }
	                }
	            </style>
	        </head>
	        <body marginheight="0" marginwidth="0" leftmargin="0" topmargin="0" bgcolor="#FFFFFE" style="-moz-text-size-adjust:none !important; padding:0px !important; -webkit-text-size-adjust:none !important; margin:0px ! important; -ms-text-size-adjust:none !important; white-space: wrap;">
	            <table class="code4email_wrapper" width="650px" border="0" cellspacing="0" cellpadding="0" align="center">
	                <tr> <td colspan="" style="text-align: right !important;"> Fecha: '.date('d/m/Y').' </td> </tr>
	                <tr>
	                    <td align="center" valign="top" bgcolor="#FFFFFE"><table class="code4email_wrapper" align="center" border="0" cellpadding="0" cellspacing="0" width="650px" style="width:650px;">
	                        <tr>
	                            <td>
	                                <a href="'.$liga3.'" target="_blank">
	                                    <table   height="135px" background="" class="code4email_wrapper"  width="650px" border="0" cellspacing="0" cellpadding="0" align="center">
	                                        <tr>
	                                            <td  valign="middle" width="200" height="109" style="margin:0px; padding:10px 225px 10px 225px; height:109px; width: 200px;">
	                                                <img src="'.$liga2.'logo-300.png" />
	                                            </td>
	                                        </tr>
	                                    </table>
	                                </a>
	                            </td>
	                        </tr>
	                        <tr>
	                            <td align="left" valign="top" style="line-height:12px; padding:0px; margin:0px; font-size:12px; width:650px;">
	                                <table class="code4email_wrapper" align="center" border="0" cellpadding="0" cellspacing="0" width="650" style="width:650px;">
	                                    <tr>
	                                        <td align="left" valign="middle" width="600" height="91" bgcolor="#FFFFFE" style="width:630px; margin:0px; height:91px; padding-bottom:15px; padding-top:25px; font-family: Arial, Helvetica, sans-serif; color: #333333; font-size: 14px; mso-line-height-rule:exactly; white-space: wrap; line-height:20px;" class="code4email_center"><span style="color: #5b5b5f; font-size: 14px; text-decoration: none;" class="lato-light">
	                                            <h1 style="color: #57BA47;font-weight: bold;text-align: center;text-transform: uppercase;">
	                                            	Documentación incompleta o errónea
	                                            </h1>
	                                            <br><br>
	                                            '.$cuerpo.'
	                                        </td>
	                                    </tr>
	                                </table>
	                                <div style="background: #548C43; width: 100%; border: 1px solid #548C43; height: 25px; margin-top: 75px !important;"></div>
	                            </td>
	                        </tr>
	                    </td>
	                </tr>
	            </table>
	        </body>
	        </html>';

	        // para el gerente de ventas -------------------------------------------------
	        // Para enviar un correo HTML, debe establecerse la cabecera Content-type
	        $cabeceras  = 'MIME-Version: 1.0' . "\r\n";
	        $cabeceras .= "Content-type:text/html;charset=utf-8" . "\n";

	        $para = $gte;

	        // Cabeceras adicionales
	        if($this->appProduction){
		        $cabeceras .= 'From: Viviend <contacto@viviend.mx>' . "\r\n";
		        if ($para){
		            mail($para, $subject, $mensaje, $cabeceras);
		        }

		        $subject2 = $subject;

		        // para el gerente  -------------------------------------------------
		        $cabecerasAdmin  = 'MIME-Version: 1.0' . "\r\n";
		        $cabecerasAdmin .= "Content-type:text/html;charset=utf-8" . "\n";

		        // Cabeceras adicionales
		        $cabecerasAdmin .= 'From: Viviend <contacto@viviend.mx>' . "\r\n";

		        // para el administrador
		        mail($copiasNV, $subject2, $mensaje, $cabecerasAdmin);
		     } else{
	            mail('sistemas@viviend.mx', $subject, $mensaje, $cabeceras);    
	            mail('sistemas@viviend.mx', $subject, $mensaje, $cabeceras);    
	            mail('alfredo@navegantes.mx', $subject, $mensaje, $cabeceras);    
	            mail('alvaro@navegantes.mx', $subject, $mensaje, $cabeceras);    
	        }
        
	        return true;
	    }

	    //autorespuesta de solicitud de avalúo
	    function autoRespuesta3($idAltaVenta=null, $tipo='solicitud'){

	    	$liga="http://viviend.mx/sistema/emailresources/";
	        $liga2="http://viviend.mx/sistema/img/";
	        $liga3="http://viviend.mx/sistema/";
	    	$rowAV = $this->maltaventa->getById($idAltaVenta);
	    	$cliente = (!is_numeric($rowAV))?$this->mprospecto->getCampo('nombre',$rowAV['idProspecto'])." ".$this->mprospecto->getCampo('apellidoP',$rowAV['idProspecto'])." ".$this->mprospecto->getCampo('apellidoM',$rowAV['idProspecto']):'';
	    	$idUnidadValuadora=(!is_numeric($rowAV))?$rowAV['idUnidadValuadora']:0;
	    	if($idUnidadValuadora > 0){
	    		$email=$this->munidad_valuadora->getCampo('email',$idUnidadValuadora);
	    	}else{
	    		$email='';
	    	}
	    	$nss = (!is_numeric($rowAV))?$this->mprospecto->getCampo('nss',$rowAV['idProspecto']):'';
	    	$manzana = (!is_numeric($rowAV))?$this->mproyecto->getCampo('manzana',$rowAV['idProyecto']):'';
	    	$lote = (!is_numeric($rowAV))?$this->mproyecto->getCampo('lote',$rowAV['idProyecto']):'';
	    	$folioAvaluo = (!is_numeric($rowAV))?$this->mproyecto->getCampo('folioAvaluo',$rowAV['idProyecto']):'';
	    	$idProspecto = (!is_numeric($rowAV))?$rowAV['idProspecto']:0;
	        $idFraccionamiento = ($idProspecto>0)?$this->mprospecto->getCampo('idFraccionamiento',$idProspecto):0;
	    	$fraccionamiento = $this->mfraccionamiento->getCampo('titulo',$idFraccionamiento);
	    	$documentos = '';//'Archivos:<br>';
	    	$trComplemento = '';
	    	if ($tipo == 'solicitud'){
	    		$subjectCuerpo = 'Solicitud de Avalúo';
	    		$documentos .= (!is_numeric($rowAV))?'<a href="http://ww.viviend.mx/sistema/uploads/alta_venta/'.$rowAV['pdf_17'].'">Solicitud de Avalúo</a><br>':'';
	    		//$documentos .= (!is_numeric($rowAV))?'<a href="http://ww.viviend.mx/sistema/uploads/alta_venta/'.$rowAV['pdf_1'].'">Documentos</a>':'';
	    		$trComplemento = '
	    					<tr>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> Archivos: </td>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$documentos.' </td>
                            </tr>
	    		';
	    	}
	    	if ($tipo == 'correccion'){
	    		$subjectCuerpo = 'Corrección de Avalúo';
	    		$trComplemento = '
	    					<tr>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> Folio Avalúo: </td>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$folioAvaluo.' </td>
                            </tr>
	    		';
	    	}

	    	$cuerpo = '
	    	<table id="table-prospecto" style="width: 80%;margin: 0 auto;border: 3px solid #EAC633;border-spacing: 0px;text-transform: uppercase;">
                        <tbody>

                            <tr>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> CLIENTE: </td>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$cliente.' </td>
                            </tr>
                            <tr>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> FRACCIONAMIENTO: </td>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$fraccionamiento.' </td>
                            </tr>
                            <tr>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> MANZANA: </td>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$manzana.' </td>
                            </tr>
                            <tr>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> LOTE: </td>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$lote.' </td>
                            </tr>
                            <tr>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> NSS: </td>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$nss.' </td>
                            </tr>
                            '.$trComplemento.'

                        </tbody>
                    </table>
	    	';

	    	$mensaje = '
	        <!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 3.2 Final//EN">
	        <html xmlns="http://www.w3.org/1999/xhtml">
	        <head>
	            <title>Email</title>
	            <meta http-equiv="Content-Type" content="text/html; charset=utf-8">
	            <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=yes" />
	            <link href="https://fonts.googleapis.com/css?family=Lato:300,700" rel="stylesheet" type="text/css">
	            <style>
	                body, tr, td, span, div, p, a, li {
	                    -moz-text-size-adjust:none !important;
	                    -webkit-text-size-adjust:none !important;
	                    margin:0px !important;
	                    -ms-text-size-adjust:none !important;
	                    white-space: wrap;
	                }
	                .lato-light{
	                    font-family: "lato" sans-serif !important;
	                    font-weight: 300;
	                }
	                .lato-bold{
	                    font-family: "lato" sans-serif !important;
	                    font-weight: 700;
	                }
	                td img {
	                    display: block;
	                }
	                .ReadMsgBody {
	                    width: 100%;
	                }
	                .ExternalClass * {
	                    line-height: 100%;
	                }
	                @media only screen and (max-width:480px) {
	                    #logosim{
	                        padding:0!important;
	                    }
	                    *[class="code4email_wrapper"] {
	                        width: 100% !important;
	                    }
	                    *[class="code4email_main_table"] {
	                        width: 320px !important;
	                    }
	                    *[class="code4email_hide"] {
	                        display: none !important;
	                    }
	                    *[class="code4email_hide"] {
	                        display: none !important;
	                    }
	                    *[class="code4email_center"] {
	                        text-align: center !important;
	                        padding:10px !important;
	                        height:20px !important;
	                    }
	                    *[class="code4email_clear"] {
	                        width: 100% !important;
	                        clear: both !important;
	                        float: left !important;
	                    }
	                    *[class="code4email_br"] {
	                        display:block !important;
	                        width: 1px !important;
	                        height:6px !important;
	                        clear: both !important;
	                    }
	                    *[class="code4email_text_p10"] {
	                        padding: 0px 10px 10px 10px !important;
	                        height:20px !important;
	                    }
	                    *[class="code4email_w20"] {
	                        width: 20px !important;
	                    }
	                    *[class="code4email_h20"] {
	                        height: 20px !important;
	                    }
	                    *[class="code4email_h20_center"] {
	                        height: 20px !important;
	                        text-align: center !important;
	                    }
	                }
	                @media only screen and (min-width:480px) and (max-width:599px) {
	                    *[class="code4email_wrapper"] {
	                        width: 100% !important;
	                    }
	                    *[class="code4email_main_table"] {
	                        width: 480px !important;
	                    }
	                    *[class="code4email_hide"] {
	                        display: none !important;
	                    }
	                    *[class="code4email_hide"] {
	                        display: none !important;
	                    }
	                    *[class="code4email_center"] {
	                        text-align: center !important;
	                        padding:10px !important;
	                        height:20px !important;
	                    }
	                    *[class="code4email_clear"] {
	                        width: 100% !important;
	                        clear: both !important;
	                        float: left !important;
	                    }
	                    *[class="code4email_br"] {
	                        display:block !important;
	                        width: 1px !important;
	                        height:6px !important;
	                        clear: both !important;
	                    }
	                    *[class="code4email_text_p10"] {
	                        padding: 0px 10px 10px 10px !important;
	                        height:20px !important;
	                    }
	                    *[class="code4email_w20"] {
	                        width: 20px !important;
	                    }
	                    *[class="code4email_h20"] {
	                        height: 20px !important;
	                    }
	                    *[class="code4email_h20_center"] {
	                        height: 20px !important;
	                        text-align: center !important;
	                    }
	                }
	            </style>
	        </head>
	        <body marginheight="0" marginwidth="0" leftmargin="0" topmargin="0" bgcolor="#FFFFFE" style="-moz-text-size-adjust:none !important; padding:0px !important; -webkit-text-size-adjust:none !important; margin:0px ! important; -ms-text-size-adjust:none !important; white-space: wrap;">
	            <table class="code4email_wrapper" width="650px" border="0" cellspacing="0" cellpadding="0" align="center">
	                <tr> <td colspan="" style="text-align: right !important;"> Fecha: '.date('d/m/Y').' </td> </tr>
	                <tr>
	                    <td align="center" valign="top" bgcolor="#FFFFFE"><table class="code4email_wrapper" align="center" border="0" cellpadding="0" cellspacing="0" width="650px" style="width:650px;">
	                        <tr>
	                            <td>
	                                <a href="'.$liga3.'" target="_blank">
	                                    <table   height="135px" background="" class="code4email_wrapper"  width="650px" border="0" cellspacing="0" cellpadding="0" align="center">
	                                        <tr>
	                                            <td  valign="middle" width="200" height="109" style="margin:0px; padding:10px 225px 10px 225px; height:109px; width: 200px;">
	                                                <img src="'.$liga2.'logo-300.png" />
	                                            </td>
	                                        </tr>
	                                    </table>
	                                </a>
	                            </td>
	                        </tr>
	                        <tr>
	                            <td align="left" valign="top" style="line-height:12px; padding:0px; margin:0px; font-size:12px; width:650px;">
	                                <table class="code4email_wrapper" align="center" border="0" cellpadding="0" cellspacing="0" width="650" style="width:650px;">
	                                    <tr>
	                                        <td align="left" valign="middle" width="600" height="91" bgcolor="#FFFFFE" style="width:630px; margin:0px; height:91px; padding-bottom:15px; padding-top:25px; font-family: Arial, Helvetica, sans-serif; color: #333333; font-size: 14px; mso-line-height-rule:exactly; white-space: wrap; line-height:20px;" class="code4email_center"><span style="color: #5b5b5f; font-size: 14px; text-decoration: none;" class="lato-light">
	                                            <h1 style="color: #57BA47;font-weight: bold;text-align: center;text-transform: uppercase;">
	                                            	'.$subjectCuerpo.'
	                                            </h1>
	                                            <br><br>
	                                            '.$cuerpo.'
	                                        </td>
	                                    </tr>
	                                </table>
	                                <div style="background: #548C43; width: 100%; border: 1px solid #548C43; height: 25px; margin-top: 75px !important;"></div>
	                            </td>
	                        </tr>
	                    </td>
	                </tr>
	            </table>
	        </body>
	        </html>';

	        $subject = $subjectCuerpo;//'Solicitud de avalúo'; // titulo
	        $cabeceras  = 'MIME-Version: 1.0' . "\r\n";
	        $cabeceras .= "Content-type:text/html;charset=utf-8" . "\n";
	        $cabeceras .= 'From: Viviend <contacto@viviend.mx>' . "\r\n";

	        if($this->appProduction){
		        $dGestores = $this->mfraccionamientoxusuario->getGestoriaSelectResultByIdFracc($idFraccionamiento);
		        if ( !is_numeric($dGestores) ) {
		            foreach ($dGestores->result() as $row) {
		                mail($this->musuario->getCampo('email',$row->id), $subject, $mensaje, $cabeceras);
		            }
		        }	        	
		        mail('compras@viviend.mx', $subject, $mensaje, $cabeceras);
		        if ($tipo=='solicitud'){
			        if($email!=''){
			        	mail( $email, $subject, $mensaje, $cabeceras);
			        }
		        	/*mail('cristy_amu2901@hotmail.com', $subject, $mensaje, $cabeceras);*/
		        }
		        $copiasNV = 'hsalinas@viviend.mx'. ', ';
		        $copiasNV .= 'esalinas@viviend.mx'. ', ';
		        $copiasNV .= 'mejora@viviend.mx'. ', ';
		        $copiasNV .= 'sistemas@viviend.mx';
	         	mail($copiasNV, $subject, $mensaje, $cabeceras);
	        } else{
	            mail('sistemas@viviend.mx', $subject, $mensaje, $cabeceras);    
	            mail('sistemas@viviend.mx', $subject, $mensaje, $cabeceras);    
	            mail('alfredo@navegantes.mx', $subject, $mensaje, $cabeceras);    
	            mail('alvaro@navegantes.mx', $subject, $mensaje, $cabeceras);    
	        }
	        /*echo $mensaje;
	        exit();*/
         	return true;
	    }

	    public function tablaAmortizacion(){
			$datitos = array();
			if(count($_POST) == 4 ){
				$fechaContado = $_POST['fechaContado'];
				$fechaContado =  str_replace('/', '-', $fechaContado);
				$datitos['fecha'] = ($fechaContado != '')? date('Y-m-d', strtotime($fechaContado)) : NULL;
				$datitos['plazos'] = $_POST['plazos'];
				$datitos['monto'] = toInt( ($_POST['monto'] != '')? $_POST['monto'] : 0.00 );
				$datitos['interes'] = toInt( ($_POST['interes'] != '')? $_POST['interes'] : 0.00 );
			}
            $q = calcularAmortizacion($datitos);
	        foreach ($q as $row){
				$array['aaData'][] = array(
					'id' => $row['id'],
					'fecha' => $row['fecha'],
					'pago' => precio_format($row['pago']),
					'interes' => precio_format($row['interes']),
					'saldo' => precio_format($row['saldo'])
				);
	        }

	        echo json_encode($array);
	    }

		function getPrecioVenta(){
			$precio = ( isset($_POST['idProyecto']) && !empty($_POST['idProyecto']) )? $this->mproyecto->getCampo('precioVenta', $_POST['idProyecto']) : 0.00;
			$lineaCredito = ( isset($_POST['idProyecto']) && !empty($_POST['idProyecto']) )? $this->mproyecto->getCampo('lineaCredito', $_POST['idProyecto']) : 0;
			echo json_encode( array('precioVenta' => precio_format($precio), 'lineaCredito' => $lineaCredito ) );
		}
	}