<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Unidades extends MX_Controller {
	public $data,$vParameters,$mainView,$fv;
	public function __construct(){
	$this->nsession = $this->config->item('nsession');
    if (!isset($_SESSION[$this->nsession]) || (($_SESSION[$this->nsession]['usuario'] == ""))) redirect('login');
            $this->fv = 'unidades'; // form validation variable
            $this->mainView = 'unidades';
            $this->data['fjs'] = '';
            $this->data['js'] = ' <script src="assets/js/unidades/listado.js" type="text/javascript"></script>';
            $this->data['css'] = '';
            // Tools
            $this->load->helper(array('tools','numeros','url','form','date','text','security'));
            // Modelos
            $this->load->model(array('munidades','musuario'));
            valSession("obra",$this->fv);
    }

	public function index(){
		$data['q'] = '';
        $this->data['contenido'] = $this->load->view($this->mainView.'/index_view',$data,true);
        $this->load->view('templates/main_template',$this->data);
	}

    public function listado(){
        $q = $this->munidades->getAll();

        if (!is_numeric($q)){
            foreach ($q->result() as $row){
                $array['aaData'][] = array(
                    'unidad' => $row->unidad,
                    'abreviatura' => $row->abreviatura,
                    'acciones' => (in_array($_SESSION[$this->nsession]['rol'], permisos("obra","unidades")['w']))? accionesCatalogosContObra($row->id,$this->router->class,false, true, true) : ''
                );
            }
        } else{
            $array['aaData'][] = array(
                'unidad' => 'No hay registros',
                'abreviatura' => 'No hay registros',
                'acciones' => 'No hay registros'
                );

        }

        echo json_encode($array);
    }

    public function nuevo()
    {
        // Mensajes
        $data['msg'] = '';


        $this->load->library('form_validation');
        if ($this->form_validation->run($this->fv) == FALSE) {
            $data['msg'] = validation_errors();

            $this->data['contenido'] = $this->load->view($this->mainView . '/nuevo_view', $data, true);
            $this->load->view('templates/main_template', $this->data);
        } else {
            $pData['unidad'] = $this->input->post('unidad', TRUE);
            $pData['abreviatura'] = strtoupper($this->input->post('abreviatura', TRUE));
            $pData['status'] = 1;
            $id = $this->munidades->insertar($pData);
            redirect($this->router->class);
        }

    }

    public function editar($id)
    {
        // Mensajes
        $msg = '';
        /* VALIDAR FORMULARIO*/
        $this->load->library('form_validation');

        if (isset($_POST['unidad'])) {
            if ($this->form_validation->run($this->fv) == FALSE) {
                $msg = validation_errors();
            } else {
                $pData['unidad'] = $this->input->post('unidad', TRUE);
                $pData['abreviatura'] = strtoupper($this->input->post('abreviatura', TRUE));
                $pData['status'] =$this->input->post('status',TRUE);
                $this->munidades->actualizar($pData, $id);
                redirect($this->router->class."?close");
            }
        }
        // Obteniendo la información
        $info = $this->munidades->getById($id);

        $data = $info;
        $data['msg']=$msg;

        $this->data['contenido'] = $this->load->view($this->mainView . '/editar_view', $data, true);
        $this->load->view('templates/main_template', $this->data);
    }


    public function ver($id = null){
        $info = $this->munidades->getById($id);
        $data = $info;
        $this->data['contenido'] = $this->load->view($this->mainView . '/ver_view', $data, true);
        $this->load->view('templates/main_template', $this->data);
    }

    public function eliminar(){
        $id = $this->input->post('elid');
        $q = $this->munidades->getById($id);
        $cValor = "true";
        $valorBorrar = $this->munidades->borrar($id);
        $data = json_encode(array("valor" => $cValor));
        echo $data;
    }  

    public function cambiaStatus(){
        $id = $this->input->post('elid');
        $pData['status'] = 0;
        $q = $this->munidades->getById($id);
        $cValor = "true";
        $this->munidades->actualizar($pData, $id);
        //$valorBorrar = $this->munidades->borrar($id);
        $data = json_encode(array("valor" => $cValor));
        echo $data;
    }


}


