<?php
defined('BASEPATH') OR exit('No direct script access allowed');
date_default_timezone_set('America/Mexico_City');
class Test extends MX_Controller {
	public $data,$vParameters,$mainView,$fv,$cronjob,$port,$db2;
	public function __construct(){
        $this->nsession = $this->config->item('nsession');
        if (!isset($_SESSION[$this->nsession]) || (($_SESSION[$this->nsession]['usuario'] == ""))) redirect('login');
            $this->fv = 'test'; // form validation variable
            $this->mainView = 'test';
            $this->data['fjs'] = '';
            $this->data['js'] = '';
            $this->data['css'] = '';
            // Tools
            $this->load->helper(array('tools','numeros','url','form','date','text','security','download'));
            // Modelos
            $this->load->model(array('mproyecto','mfraccionamiento','mprototipoxfraccionamiento',
            'maltaventa','musuario','mfraccionamientoxusuario','mautorizacion','mcomisionbono','mpaquete',
            'mentrega','mdeposito','mencuestavivienda','mpostventa','mprototipos','mordencompra','mproveedor',
            'mpresupuestomat','mactividadmo','mmanoobra','mactividadesprototipo','mpresupuestomo','mestimadosprograma',
            'mavanceobra','mempresas','mdetallepaquete','mestimacionesprograma','mestimacionprograma','mpaquetepresupuesto',
            'mmaterialesactividadprototipo'));
            $this->config->set_item('rol', $_SESSION[$this->nsession]['rol']);
            // Lbrerias
            $this->load->library('csvimport');
           	$this->data['fotos_www'] = $this->config->item('base_www')."/csv/";
           // $this->data['fotos_www'] = '/home/puntapro/www/uploads/inicio/';
           // Debugging
           $this->output->enable_profiler(false);
           $this->port=$this->config->item('portmicro');

           ini_set('memory_limit', '-1');
           ini_set('max_execution_time', 0);
           require('Presupuestos.php');
           require('Pptomat.php');
           require('Pptomo.php');
           require('Cronjob.php');
           require('Estimacion.php');
           $this->cronjob = new Cronjob();
           //$this->db2 = $this->load->database('pruebas', true);
    }

    public function deleteDoc(){
        $clave="MAB-095";
        $data=[
            //empresa 1
            [
                "idEmpresa"=>1,
                "folio"=>"C00167630",
            ],
            [
                "idEmpresa"=>1,
                "folio"=>"C00167631",
            ],
            [
                "idEmpresa"=>1,
                "folio"=>"C00167632",
            ],
            [
                "idEmpresa"=>1,
                "folio"=>"C00167638",
            ],
            [
                "idEmpresa"=>1,
                "folio"=>"C00167639",
            ],
            [
                "idEmpresa"=>1,
                "folio"=>"C00167641",
            ],
            [
                "idEmpresa"=>1,
                "folio"=>"C00168670",
            ],
            //empresa 2
            [
                "idEmpresa"=>2,
                "folio"=>"C00007202",
            ],
            [
                "idEmpresa"=>2,
                "folio"=>"C00007448",
            ],
            [
                "idEmpresa"=>2,
                "folio"=>"C00007449",
            ],
            [
                "idEmpresa"=>2,
                "folio"=>"C00007451",
            ],
            //empresa 5
            [
                "idEmpresa"=>5,
                "folio"=>"C00006457",
            ],
        ];
        foreach ($data as $row) {
            $row=(Object) $row;
            $co=$this->db->query("SELECT * FROM compra WHERE idEmpresa=$row->idEmpresa AND folio='$row->folio'");
            if($co->num_rows()>0){
                $co=$co->row();
                $alm=$this->db->query("SELECT * FROM almacenes WHERE idEmpresa=$row->idEmpresa AND id=$co->id_almacen");
                $empresa=$this->db->query("SELECT * FROM empresas WHERE id=$row->idEmpresa");
                $this->db->query("DELETE FROM detalle_orden WHERE idEmpresa=$row->idEmpresa AND clave_articulo='$clave' AND id_orden_compra=$co->id_orden_compra");
                echo $empresa->row()->titulo." | ".$clave." | ".$co->folio." | ".$alm->row()->nombre."<br>";
            }else{
                echo $row->folio." No existe<br>";
            }
        }
    }

    public function checkRepeatsMat(){
        $paqs=$this->db->query("SELECT paq.id FROM paquetes paq LEFT JOIN arranque arr ON FIND_IN_SET(paq.id,arr.idPaquetes) WHERE arr.estatus_arranque=2");
        foreach ($paqs->result() as $row) {
            $repeats=$this->db->query("SELECT pmat.idMaterial,paq.titulo,paq.id,pmat.created FROM presupuesto_mat pmat
            LEFT JOIN material mat ON mat.id=pmat.idMaterial
            LEFT JOIN paquetes paq ON paq.id=mat.idPaquete
            WHERE mat.id=$row->id
            GROUP BY pmat.clave HAVING COUNT(pmat.id)>1");
            if($repeats->num_rows()>0){
                $repeats=$repeats->row();
                echo $repeats->idMaterial." | ".$repeats->titulo." | ".$repeats->id." | ".$repeats->created."<br>";
            }
        }
    }

    public function checkAsignIds(){
        $query=$this->db->query("SELECT * FROM materiales2 WHERE nombre LIKE '%|%'");
        if($query->num_rows()>0){
            foreach ($query->result() as $row) {
                $compra=$this->db->query("SELECT id,id_compra FROM detalle_compra WHERE id_articulo=$row->id AND idEmpresa=$row->idEmpresa");
                if($compra->num_rows()>0){
                    echo $row->idEmpresa.' | '.$row->id.' | '.$row->clave."<br>";
                }
            }
        }
    }
    public function updateIdArticulo($idEmpresa,$idPaquete){
        $query=$this->db->query("SELECT mact.id,mate.idEmpresa,pmat.clave FROM presupuesto_mat pmat
        LEFT JOIN materialesactividadprototipo mact ON mact.id=pmat.idMateriales
        LEFT JOIN material mate ON mate.id=pmat.idMaterial
        LEFT JOIN paquetes paq ON paq.id=mate.idPaquete
        LEFT JOIN arranque arr ON FIND_IN_SET(paq.id,arr.idPaquetes)
        WHERE mate.idEmpresa=$idEmpresa AND paq.id=$idPaquete");
        if($query->num_rows()>0){
            foreach ($query->result() as $row) {
                if(isset($row->clave)){
                    if($row->clave!=''){
                        if($row->idEmpresa!=''){
                            $pri=$this->db->query("SELECT id FROM materiales WHERE clave='$row->clave' AND idEmpresa=$row->idEmpresa");
                            $sec=$this->db->query("SELECT idArticulo id FROM claves_articulos WHERE clave='$row->clave' AND idEmpresa=$row->idEmpresa ");
                            $priVal=false;
                            $secVal=false;
                            if($pri->num_rows()>0){
                                $priVal=true;
                            }
                            if($sec->num_rows()>0){
                                $secVal=true;
                            }
                            if($priVal && $secVal){
                                echo $row->clave." | se repite en primaria y secundaria | ".$row->idEmpresa."<br>";
                            }else{
                                if($priVal){
                                    $this->mmaterialesactividadprototipo->actualizar(["idMaterial"=>$pri->row()->id],$row->id);
                                }else if($secVal){
                                    $this->mmaterialesactividadprototipo->actualizar(["idMaterial"=>$sec->row()->id],$row->id);
                                }else{
                                    echo $row->clave." | clave no encontrada | ".$row->idEmpresa."<br>";
                                }
                            }
                        }else{
                            echo $row->clave." | idEmpresa no encontrada | ".$row->idEmpresa."<br>";
                        }
                    }
                }
            }
        }
    }

    public function updatePptoMat($idEmpresa,$idPaquete){
        $query=$this->db->query("SELECT pmat.id,mate.idEmpresa,mat.clave, mact.idMaterial FROM presupuesto_mat pmat
        LEFT JOIN materialesactividadprototipo mact ON mact.id=pmat.idMateriales
        LEFT JOIN material mate ON mate.id=pmat.idMaterial
        LEFT JOIN paquetes paq ON paq.id=mate.idPaquete
        LEFT JOIN arranque arr ON FIND_IN_SET(paq.id,arr.idPaquetes)
        LEFT OUTER JOIN materiales2 mat ON mat.id=mact.idMaterial AND mat.idEmpresa=mate.idEmpresa
        WHERE mate.idEmpresa=$idEmpresa AND paq.id=$idPaquete GROUP BY pmat.id");
        if($query->num_rows()>0){
            foreach ($query->result() as $row) {
                if(isset($row->clave)){
                    if($row->clave!=''){
                        $this->mpresupuestomat->actualizar(["clave"=>$row->clave],$row->id);
                    }else{
                        echo "No se encontró el articulo | $row->idMaterial | en la empresa | ".$row->idEmpresa."<br>";
                    }
                }
            }
        }
        $this->updateIdArticulo($idEmpresa,$idPaquete);
    }

    /*public function updatePptoMat0($idEmpresa){
        $query=$this->db2->query("SELECT pmat.id,mate.idEmpresa,mat.clave, mact.idMaterial FROM presupuesto_mat pmat
        LEFT JOIN materialesactividadprototipo mact ON mact.id=pmat.idMateriales
        LEFT JOIN material mate ON mate.id=pmat.idMaterial
        LEFT JOIN paquetes paq ON paq.id=mate.idPaquete
        LEFT JOIN arranque arr ON FIND_IN_SET(paq.id,arr.idPaquetes)
        LEFT OUTER JOIN materiales mat ON mat.id=mact.idMaterial AND mat.idEmpresa=mate.idEmpresa
        WHERE mate.idEmpresa=$idEmpresa GROUP BY pmat.id");
        if($query->num_rows()>0){
            foreach ($query->result() as $row) {
                if(isset($row->clave)){
                    if($row->clave!=''){
                        $this->mpresupuestomat->actualizar(["clave"=>$row->clave],$row->id);
                    }else{
                        echo "No se encontró el articulo | $row->idMaterial | en la empresa | ".$row->idEmpresa."<br>";
                    }
                }
            }
        }
    }*/
    
    public function regeneratePaqP($idPaquete){
        $this->db->query("DELETE FROM paquete_presupuesto WHERE idPaquete=$idPaquete");
        $idManoObra=$this->mpaquete->getCampo("idManoObra",$idPaquete);
        $qPresupuestos = $this->mpresupuestomo->getByIdManoObra($idManoObra);
        if(!is_numeric($qPresupuestos)){
            foreach($qPresupuestos->result() as $pmo){
                $ppData['idPaquete'] = $idPaquete;
                $ppData['idPresupuestoMO'] = $pmo->id;
                $ppData['lotesCompletados'] = 0;
                $idPackPresu = $this->mpaquetepresupuesto->insertar($ppData); 
            }
        }
    }

    public function cleanLotes(){
        $array = array(
            array("val0"=>"23", "val1"=>"2", "val2"=>"17", "val3"=>"ALB-001.11"),
            array("val0"=>"23", "val1"=>"2", "val2"=>"18", "val3"=>"ALB-001.11"),
            array("val0"=>"24", "val1"=>"7", "val2"=>"22", "val3"=>"L2NIV-001.01"),
            array("val0"=>"24", "val1"=>"7", "val2"=>"22", "val3"=>"L2NIV-001.09"),
            array("val0"=>"24", "val1"=>"7", "val2"=>"22", "val3"=>"L2NIV-001.02"),
            array("val0"=>"24", "val1"=>"7", "val2"=>"22", "val3"=>"L2NIV-001.03"),
            array("val0"=>"24", "val1"=>"7", "val2"=>"22", "val3"=>"L2NIV-001.05"),
            array("val0"=>"24", "val1"=>"7", "val2"=>"22", "val3"=>"L2NIV-001.06"),
            array("val0"=>"24", "val1"=>"7", "val2"=>"22", "val3"=>"L2NIV-001.10"),
            array("val0"=>"23", "val1"=>"2", "val2"=>"16", "val3"=>"CIM-001.10"),
            array("val0"=>"23", "val1"=>"2", "val2"=>"16", "val3"=>"ELE-001.06")
        );
        echo "Total: ".COUNT($array);
        foreach ($array as $row) {
            $this->cleanActByIdClave($row["val0"],$row["val1"],$row["val2"],$row["val3"]);
        }
    }

    public function cleanActByIdClave($idFraccionamiento,$mza,$lote,$clave){
        $estimacion=new Estimacion();
        $query=$this->db->query("SELECT pmo.id idPresupuesto,dp.idPaquete,paqp.id idPaqP,paqp.lotes FROM proyectos pro
        LEFT JOIN detalle_paquete dp ON dp.idProyecto=pro.id
        LEFT JOIN paquetes paq ON paq.id=dp.idPaquete
        LEFT JOIN mano_obra mo ON mo.id=paq.idManoObra
        LEFT JOIN presupuesto_mo pmo ON pmo.idManoObra=mo.id
        LEFT JOIN actividadesprototipo act ON act.id=pmo.idActividadPrototipo
        LEFT JOIN actividades_mo actmo ON actmo.id=act.idActividad
        LEFT JOIN paquete_presupuesto paqp ON paqp.idPaquete=paq.id AND paqp.idPresupuestoMO=pmo.id
        WHERE pro.manzana='$mza' AND pro.lote='$lote' AND pro.idFraccionamiento='$idFraccionamiento' AND actmo.clave='$clave'");
        if($query->num_rows() > 0){
            echo "<pre>";
            print_r($query->result());
            $query=$query->row();
            if($query->idPaqP){
                $estimacion->checkLote([
                    "estado"=>false,
                    "lote" => $lote,
                    "manzana" => $mza,
                    "lotes" => $query->lotes,
                    "tabla" => "paquete_presupuesto",
                    "column" => "lotes",
                    "id" => $query->idPaqP,
                ],true);
            }
        }else{
            echo "No encontrado $clave <br>";
        }
    }

    public function sendMail($asunto='subject test', $mensaje = 'mensaje test') {
        $correo='a.e.e.c@hotmail.es';
        $this->load->library('email');

        $this->email->clear();
        $this->email->set_mailtype("html");
        $this->email->from('notificaciones@viviend.mx', 'Viviend Notificaciones');
        $this->email->to($correo);
        $this->email->subject($asunto);
        $this->email->message($mensaje);

        if ( $this->email->send() ) {
            $respuesta = "verdadero";
        }
        else {
            $respuesta = "falso";
        }
        echo $respuesta;
    }

    public function fixPptos(){
        $pptos=[
            "PALMARES_R20C_1V_ALBOR 3R EQ S/PAS_JOEL SILOS",
            "PALMARES_R20C_1V_ALBOR 2R EQ S/PAS_JOEL SILOS",
            "PALMARES_R2H_1V_ALBOR 2R SE S/PASILLO_JOEL SILOS",
        ];
        sort($pptos);
        $claves=[];
        foreach ($pptos as $row) {
            $paq=$this->db->query("SELECT mat.id,paq.id idPaquete,mat.idEmpresa,arr.titulo FROM material mat 
            LEFT JOIN paquetes paq ON mat.idPaquete=paq.id
            LEFT JOIN arranque arr ON FIND_IN_SET(paq.id,arr.idPaquetes)
            WHERE paq.titulo='$row'");
            $paq=$paq->row();
            echo "<pre>";
            echo "-- ".$row." - ".$paq->id." - ".$paq->titulo."<br>";
            $mat=$this->db->query("SELECT * FROM (SELECT mate.clave,mate.nombre, mact.idMaterial,mate.idEmpresa,COUNT(mact.id) n,
            GROUP_CONCAT(mact.id) ids, COUNT(DISTINCT pmat.clave_cat) nClaves, COUNT(DISTINCT pmat.semana) nSemanas, COUNT(DISTINCT pmat.id) nPptos  FROM presupuesto_mat pmat 
            INNER JOIN materialesactividadprototipo mact ON mact.id=pmat.idMateriales LEFT JOIN material mat ON mat.id=pmat.idMaterial 
            LEFT JOIN materiales mate ON mate.id=mact.idMaterial AND mate.idEmpresa=mat.idEmpresa WHERE mat.id=$paq->id
            GROUP BY mact.idMaterial HAVING COUNT(mact.id) > 1 ORDER BY COUNT(mact.id) DESC) tbl WHERE (tbl.nClaves > 1 OR tbl.nSemanas>1 OR nPptos>1)");
            foreach ($mat->result() as $row) {
                (!in_array($row->clave,$claves)) ? array_push($claves,$row->clave) : "";
                echo $row->clave." - ".$row->nombre." - ".$row->idMaterial." - ".$row->n." - ".$row->ids."<br>";
                $art=$this->db->query("SELECT cmat.categoria,pmat.semana,COUNT(DISTINCT pmat.id) n FROM materialesactividadprototipo mact 
                LEFT JOIN presupuesto_mat pmat ON pmat.idMateriales=mact.id
                LEFT JOIN material mat ON mat.id=pmat.idMaterial 
                LEFT JOIN materiales mate ON mate.id=mact.idMaterial AND mate.idEmpresa=mat.idEmpresa 
                LEFT JOIN categorias_mat cmat ON CONVERT(cmat.clave USING utf8) = CONVERT(pmat.clave_cat USING utf8)
                WHERE FIND_IN_SET(mact.id,'$row->ids') GROUP BY pmat.clave_cat,pmat.semana ORDER BY pmat.semana");
                print_r($art->result());
            }
        }
        print_r($claves);
    }

    public function createPptos(){
        //CLAVE	CLAVE_CAT PROVEEDOR	SEMANA DESCRIPCION CANTIDAD	PRECIO UNITARIO
        $dir=$this->data['fotos_www']."palmares/";
        $pptos=[
            "PALMARES_R12,14,17_4V_ALBOR 3R SE S/PASILLO_LEMUS",
            "PALMARES_R12,13,14,20_4V_ALBOR 3R EQ S/PAS_LEMUS",
            "PALMARES_R14_1V_LUMEN SE_PARADA",
            "PALMARES_R9,11,12_9V_ALBOR 3R EQ S/PASILLO_GERMAN",
            "PALMARES_R9_1V_ALBOR 3R EQ C/PASILLO_GERMAN",
            "PALMARES_R11,14_3V_ALBOR 2R EQ S/PASILLO_GERMAN ",
            "PALMARES_R13_1V_ALBOR 2R EQ C/PASILLO_GERMAN",
            "PALMARES_R11,17,18_4V_ALBOR 2R SE S/PASILLO_GERMA",
            "PALMARES_R8,10,11,12_5V_ALBOR 2R EQ S/PAS_REYES",
            "PALMARES_R8,12,18_4V_ALBOR 2R SE S/PASILLO_REYES",
            "PALMARES_R15,16,19,20_8V_LUMEN EQ_LEMUS",
            "PALMARES_16C_1V_LUMEN SE_LEMUS",
        ];
        foreach ($pptos as $row) {
            //reinicializacion de claves
            $acumulado=[];
            $claves=[];
            $claves["ACE-003"]=[
                "ACE-003-APA",
                "ACE-003-LE",
                "ACE-003AZ",
                "ACE-003PA",
                "ACE-003PB",
            ];
            
            $claves["ACE-001"]=[
                "ACE-001AZ",
                "ACE-001PA",
                "ACE-001PB",
                "ACE-001-APA",
                "ACE-001-LE",
            ];
    
            $claves["ACE-009"]=[
                "ACE-009AZ",
                "ACE-009PA",
                "ACE-009PB",
                "ACE-009-APB",
                "ACE-009-LE",
            ];
    
            $claves["ACE-100"]=[
                "ACE-100AZ",
                "ACE-100PA",
                "ACE-100PB",
                "ACE-100-APB",
                "ACE-100-LE",
            ];
    
            $claves["ACE-006"]=[
                "ACE-006AZ",
                "ACE-006PA",
                "ACE-006PB",
                "ACE-006-APB",
                "ACE-006-LC",
            ];

            $paq=$this->db->query("SELECT mat.id,paq.id idPaquete,mat.idEmpresa,arr.titulo FROM material mat 
            LEFT JOIN paquetes paq ON mat.idPaquete=paq.id
            LEFT JOIN arranque arr ON FIND_IN_SET(paq.id,arr.idPaquetes)
            WHERE paq.titulo='$row'");
            $paq=$paq->row();
            $precioUnitario="AVG(DISTINCT pmat.precioUnitario)";
            $cantidad="(SUM(DISTINCT mact.cantidad + mact.id) - SUM(DISTINCT mact.id) )";
            $importe="(SUM(DISTINCT pmat.importe + mact.id) - SUM(DISTINCT mact.id) )";
            //array de articulos
            $mat=$this->db->query("SELECT mate.clave,pmat.clave_cat,prov.nombre,pmat.semana,mate.nombre descripcion,
            $cantidad cantidad,
            ($importe / $cantidad),
            $importe
            FROM presupuesto_mat pmat 
            LEFT JOIN materialesactividadprototipo mact ON mact.id=pmat.idMateriales 
            LEFT JOIN material mat ON mat.id=pmat.idMaterial 
            LEFT JOIN materiales mate ON mate.id=mact.idMaterial AND mate.idEmpresa=mat.idEmpresa 
            LEFT JOIN proveedores prov ON prov.id=pmat.idProveedor AND prov.idEmpresa=mat.idEmpresa
            WHERE mat.id=$paq->id
            GROUP BY mact.idMaterial,pmat.semana ORDER BY pmat.semana ASC");

            if($mat->num_rows() > 0){
                $data=[];
                foreach ($mat->result_array() as $art) {
                    if(!in_array($art["clave"],$acumulado)){
                        array_push($acumulado,$art["clave"]);
                        array_push($data,$art);
                    }else{
                        $firstKey=array_key_first($claves[$art["clave"]]);
                        $claveNueva=$claves[$art["clave"]][$firstKey];
                        $art["clave"]=$claveNueva;
                        unset($claves[$art["clave"]][$firstKey]);
                        array_push($data,$art);
                    }
                }
                //creacion de archivo
                $columnas = array(
                    0 =>'CLAVE',
                    1 =>'CLAVE_CAT',
                    2 =>'PROVEEDOR',
                    3 =>'SEMANA',
                    4 =>'DESCRIPCION',
                    5 =>'CANTIDAD',
                    6 =>'PRECIO UNITARIO',
                    7 =>'TOTAL',
                );
                $name=str_replace("/","-",$row);
                saveCsv($data,$dir.$name,$columnas,"array");
            }
        }
    }

    public function insertPptos(){
        $pptomat=new Pptomat();
        $dir=$this->data['fotos_www']."palmares/";
        $pptos = scandir($dir);
        foreach ($pptos as $row) {
            if($row != "." && $row != ".."){
                $name=str_replace("-","/",$row);
                $name=explode(".",$name)[0];
                $paq=$this->db->query("SELECT mat.id,paq.id idPaquete,mat.idEmpresa,arr.titulo FROM material mat 
                LEFT JOIN paquetes paq ON mat.idPaquete=paq.id
                LEFT JOIN arranque arr ON FIND_IN_SET(paq.id,arr.idPaquetes)
                WHERE paq.titulo='$name'");
                $paq=$paq->row();
                echo $row."<br>";
                //borrado
                $pmat=$this->db->query("SELECT id,idMateriales FROM presupuesto_mat WHERE idMaterial=$paq->id");
                foreach ($pmat->result() as $row2) {
                    $this->db->query("DELETE FROM presupuesto_mat WHERE id=$row2->id");
                    $this->db->query("DELETE FROM materialesactividadprototipo WHERE id=$row2->idMateriales");
                }
                $pptomat->uploadFile($dir.$row,[
                    "idEmpresa"=>$paq->idEmpresa,
                    "idMaterial"=>$paq->id
                ]);
            }
        }
    }

    public function insertPpto($idEmpresa=5,$folder="PALMARES",$idFraccionamiento=24){
        $presupuestos=new Presupuestos();
        $pptomo=new Pptomo();
        $pptomat=new Pptomat();
        $dir=$this->data['fotos_www']."pptos/".$folder."/";
        $mo = scandir($dir."MO");
        $mat = scandir($dir."MAT");
        //echo "<pre>";
        //print_r($mo);
        //print_r($mat);
        //exit();
        for ($i=0; $i < COUNT($mo); $i++) {
            if($mo[$i] != "." && $mo[$i] != ".."){
                $fileMo=$mo[$i];
                $fileMo=explode("_",$fileMo);
                unset($fileMo[COUNT($fileMo)-1]);
                $fileMat=$mat[$i];
                $fileMat=explode("_",$fileMat);
                unset($fileMat[COUNT($fileMat)-1]);
                //echo implode("_",$fileMo)."<br>";
                //echo implode("_",$fileMat)."<br>";
                if(implode("_",$fileMo) == implode("_",$fileMat)){
                    $titleMo=$this->getTitulo($mo[$i]);
                    $titleMat=$this->getTitulo($mat[$i]);
                    $prototipo=explode(" ",$titleMo);
                    unset($prototipo[COUNT($prototipo)-1]);
                    unset($prototipo[COUNT($prototipo)-1]);
                    $titulo=implode(" ",$prototipo);
                    $prototipo=implode(" ",$prototipo);
                    $prototipo=$this->db->query("SELECT id FROM prototipos WHERE nombre='$prototipo'");
                    if($prototipo->num_rows()>0){
                        $idPrototipo=$prototipo->row()->id;
                        //insercion -------------------------------
                        $data=$presupuestos->insertPptos([
                            "idFraccionamiento"=>$idFraccionamiento,
                            "idPrototipo"=>$idPrototipo,
                            "titulo"=>$titulo,
                            "idEmpresa"=>$idEmpresa,
                        ],true);
                        $pptomo->uploadFile($dir."MO/".$mo[$i],[
                            "idPrototipo"=>$idPrototipo,
                            "idManoObra"=>$data["idPmo"]
                        ]);
                        $pptomat->uploadFile($dir."MAT/".$mat[$i],[
                            "idEmpresa"=>$idEmpresa,
                            "idMaterial"=>$data["idPmat"]
                        ]);
                    }else{
                        echo " - No se encontró el prototipo";
                    }
                    echo "<br>";
                }else{
                    echo "No coinciden los nombres de los pptos.<br>";
                }
            }
        }
    }

    public function getClaves(){
        $claves=[
            "ACE-003",
            "ACE-001",
            "ACE-006",
            "ACE-009",
            "ACE-100",
            "ACE-002",
            "ACE-007",
            "R-001",
            "ACE-084",
            "ACE-007PB",
            "ACE-007",
        ];
        foreach ($claves as $row) {
            $variant=$this->db->query("SELECT clave FROM materiales WHERE clave LIKE '$row%' AND clave !='$row' AND idEmpresa=5");
            echo $row.'<br>';
            foreach ($variant->result() as $row2) {
                echo $row2->clave."<br>";
            }
            echo "<br>";
        }
    }

    public function getTitulo($row){
        $prototipo=explode(".",$row);
        $prototipo=explode("_", $prototipo[0]);
        $titulo=implode(" ",$prototipo);
        return $titulo;
    }

    public function getArticulosPorEmpresa($idEmpresa){
        $array = [];
        foreach ($array as $row) { 
            $exist=$this->db->query("SELECT id FROM materiales WHERE idEmpresa=$idEmpresa AND clave='".$row['val0']."'");
            if($exist->num_rows()==0){
                echo strtoupper($row["val0"])."$".strtoupper($row["val1"])." | ".$row["val0"]."$".$row["val2"]."$".strtoupper($row["val3"])."$".strtoupper($row["val4"])."<br>";
            }
        }

    }

    public function addRonda(){
        //file uploaded
        $file_path = $this->data['fotos_www']."rondas.csv";
        $arranques=[];
        if ($this->csvimport->get_array($file_path,'',TRUE)) {
            $csv_array = $this->csvimport->get_array($file_path);
            if (isset($csv_array[0])) {
                foreach ($csv_array as $value) { //recorremos el csv
                    if (isset($value['RONDA']) && isset($value['IMPORTE'])) {
                        $importe=$value["IMPORTE"];
                        $arranque=$this->db->query("SELECT titulo,ronda,'$importe' importe FROM arranque WHERE titulo LIKE '%".$value['RONDA']."%'");
                        if($arranque->num_rows()>0){
                            $arranque=$arranque->row();
                            echo $arranque->titulo." | ".$arranque->ronda." | ".$arranque->importe."<br>";
                        }
                    }
                }
            }
        }
    }

    public function getUnidades(){
        $query=$this->db->query("SELECT mate.clave,mate.nombre,GROUP_CONCAT(DISTINCT mate.unidad_venta) unidad_venta,GROUP_CONCAT(DISTINCT mate.unidad_compra) unidad_compra FROM detalle_paquete dp 
        LEFT JOIN paquetes paq ON paq.id=dp.idPaquete 
        LEFT JOIN arranque arr ON FIND_IN_SET(paq.id,arr.idPaquetes) 
        LEFT JOIN material mat ON mat.idPaquete=paq.id 
        LEFT JOIN presupuesto_mat pmat ON pmat.idMaterial=mat.id 
        LEFT JOIN materialesactividadprototipo mact ON mact.id=pmat.idMateriales 
        LEFT JOIN materiales mate ON mate.id=mact.idMaterial AND mate.idEmpresa=mat.idEmpresa WHERE arr.estatus_arranque=2 AND clave != '' GROUP BY clave");
        if($query->num_rows()>0){
            //ordenamiento
            $columnas = array(
                0 =>'CLAVE',
                1 =>'ARTICULO',
                2 =>'UNIDAD SISTEMA',
                3 =>'UNIDAD MICROSIP',
            );
            crearExcel($query,"Comparativa Unidades",$columnas);
        }
    }

    public function getPptosMatCat(){
        $query="SELECT COUNT(pmat.id) n,mat.id,paq.titulo,mat.idEmpresa FROM presupuesto_mat pmat
        LEFT JOIN material mat ON mat.id=pmat.idMaterial
        LEFT JOIN paquetes paq ON paq.id=mat.idPaquete
        LEFT JOIN arranque arr ON FIND_IN_SET(paq.id,arr.idPaquetes)
        WHERE pmat.clave_cat='' AND arr.estatus_arranque=2 
        GROUP BY mat.id";   
        $query=$this->db->query($query);
        if($query->num_rows() > 0){
            foreach ($query->result() as $row) {
                $nPmat=$this->db->query("SELECT COUNT(id) n FROM presupuesto_mat WHERE idMaterial=$row->id");
                $nPmat=($nPmat->num_rows()>0) ? $nPmat->row()->n : 0;
                if($row->n == $nPmat){
                    echo $row->id." - ".$row->titulo." | idEmpresa:".$row->idEmpresa."<br>";
                }
            }
        }
    }

    public function valFechasPaquetes2(){
        $query=$this->db->query("SELECT paq.id,paq.titulo,paq.rango_lotes,ion.id idEstimacion,(DATE_SUB(CURDATE(), INTERVAL WEEKDAY(CURDATE()) DAY)) fecha FROM paquetes paq
		LEFT JOIN arranque arr ON FIND_IN_SET(paq.id,arr.idPaquetes)
        LEFT JOIN estimacion_programa ion ON ion.idPaquete=paq.id
        WHERE arr.estatus_arranque=2");
        $i=1;
        foreach ($query->result() as $row) {
            $estimaciones=$this->db->query("SELECT ones.id FROM estimacion_programa ion
                                            LEFT JOIN estimaciones_programa ones ON ones.idEstimacion=ion.id
                                            WHERE ion.idPaquete=$row->id AND ones.fecha = '2025-10-12'
                                            GROUP BY ones.id");
            if($estimaciones->num_rows() == 0){
                echo $i++.": ".$row->titulo." - ".$row->idEstimacion." - ".$row->fecha."<br>";
                $this->nuevaEstimacionAtrasada($row->idEstimacion,'2025-10-12');
            }
        }
    }

    public function valFechasPaquetes(){
        $query=$this->db->query("SELECT paq.id,paq.titulo,paq.rango_lotes,ion.id idEstimacion,(DATE_SUB(CURDATE(), INTERVAL WEEKDAY(CURDATE()) DAY)) fecha FROM paquetes paq
		LEFT JOIN arranque arr ON FIND_IN_SET(paq.id,arr.idPaquetes)
        LEFT JOIN estimacion_programa ion ON ion.idPaquete=paq.id
        WHERE arr.estatus_arranque=2");
        $i=1;
        foreach ($query->result() as $row) {
            $estimaciones=$this->db->query("SELECT ones.id FROM estimacion_programa ion
                                            LEFT JOIN estimaciones_programa ones ON ones.idEstimacion=ion.id
                                            WHERE ion.idPaquete=$row->id AND (DATE_SUB(CURDATE(), INTERVAL WEEKDAY(CURDATE()) DAY)) <= ones.fecha 
                                            GROUP BY ones.id");
            if($estimaciones->num_rows() == 0){
                echo $i++.": ".$row->titulo." - ".$row->idEstimacion." - ".$row->fecha."<br>";
                $this->nuevaEstimacionAtrasada($row->idEstimacion,$row->fecha);
            }
        }
    }

    public function nuevaEstimacionAtrasada($idEstimacion,$fecha){
        $lastWeek = $this->mestimacionesprograma->getLastWeekByIdEstimacion($idEstimacion);
        if(!is_numeric($lastWeek)){
            $dEstis['idEstimacion'] = $idEstimacion;
            $dEstis['fecha'] = $fecha;
            $dEstis['nEstimacion'] = $lastWeek["nEstimacion"];
            $dEstis['tipo'] = 2;
            $idEstimaciones = $this->mestimacionesprograma->insertar($dEstis);
            if(is_numeric($idEstimaciones)){
                $idPaquete = $this->mestimacionprograma->getCampo('idPaquete', $idEstimacion);
                $idManoObra = $this->mpaquete->getCampo('idManoObra', $idPaquete);
                $idPrototipo = $this->mmanoobra->getCampo('idPrototipo', $idManoObra);
                //Aqui empieza el guardado de estimados por estimaciones (Estimacion 1, estimacion 2, etc.)
                $qCatProt = $this->mactividadesprototipo->getCategoriasByManoObra($idManoObra);
                if(!is_numeric($qCatProt)){
                    foreach ($qCatProt->result() as $CategoriaProt) {
                        $qActProt = $this->mactividadesprototipo->getAllByManoObraCategoria($idManoObra, $CategoriaProt->idCategoria);
                        if(!is_numeric($qActProt)){
                            foreach ($qActProt->result() as $ActividadProt) {
                                $qPresupuesto = $this->mpresupuestomo->getByidManoObraIdActividadPrototipo($idManoObra, $ActividadProt->id);
                                if(!is_numeric($qPresupuesto)){
                                    $esData['idEstimaciones'] = $idEstimaciones;
                                    $esData['idPresupuesto'] = $qPresupuesto['id'];
                                    $esData['estimacion'] = 0;
                                    $idE2 = $this->mestimadosprograma->insertar($esData);
                                    $avData['idEstimado'] = $idE2;
                                    $idA = $this->mavanceobra->insertar($avData);
                                }
                            }
                        }
                    }
                }
            }
        }else{
            
        }
    }
    public function testColumns(){
        echo getApiColumns("actividadesprototipo","act");
    }

    public function getColumnsApi(){
        $tables=[
            "actividadesprototipo",
            "actividades_mo",
            "ajustes",
            "arranque",
            "avanceobra",
            "categorias_mo",
            "constructores",
            "detalle_paquete",
            "estimaciones_programa",
            "estimacion_programa",
            "estimados_programa",
            "fraccionamientos",
            "mano_obra",
            "paquetes",
            "paquete_presupuesto",
            "presupuesto_mo",
            "programa_obra",
            "prototipos",
            "proyectos",
            "unidades",
            "usuarios",
        ];
        echo "<pre>";
        echo "[";
        //-------------------------------------------------
        foreach ($tables as $table) {
            echo '<br>"'.$table.'" => <br>[';
            $columns=$this->db->list_fields($table);
            foreach ($columns as $column) {
                echo '"'.$column.'",<br>';
            }
            echo "],";
        }
        echo "]";
    }
    public function getFechasEstimaciones(){
        $query=$this->db->query("SELECT iones.id,SUBDATE(iones.fecha, weekday(iones.fecha)) fechaOk, iones.fecha, iones.nEstimacion FROM detalle_paquete dp
		LEFT JOIN paquetes paq ON paq.id=dp.idPaquete 
		LEFT JOIN arranque arr ON paq.id IN (arr.idPaquetes) 	
        LEFT JOIN estimacion_programa ion ON ion.idPaquete=paq.id
        LEFT JOIN estimaciones_programa iones ON iones.idEstimacion=ion.id
        WHERE arr.estatus_arranque=2 AND WEEKDAY(iones.fecha) > 0 AND iones.fecha >= NOW()
        GROUP BY iones.id ORDER BY iones.id DESC");
        echo "<pre>";
        //print_r($query->result());
        foreach ($query->result() as $row) {
            echo $row->id." | ".$row->fecha."<br>";
            $this->mestimacionesprograma->actualizar(["fecha"=>$row->fechaOk],$row->id);
        }
    }

    public function actas(){
        $query=$this->db->query("SELECT ent.id,ent.idAltaVenta,CONCAT(pros.nombre,' ',pros.apellidoP,' ',pros.apellidoM) nombre,fra.titulo,ent.fechaEntrega FROM entrega ent
        LEFT JOIN alta_venta av ON av.id=ent.idAltaVenta AND av.status=1 
        LEFT JOIN prospectos pros ON pros.id=av.idProspecto 
        LEFT JOIN proyectos pro ON pro.id=av.idProyecto 
        LEFT JOIN fraccionamientos fra ON fra.id=pro.idFraccionamiento 
        WHERE ent.statusEntrega=1");
        if($query->num_rows() > 0){
            foreach ($query->result() as $row) {
                $dir=$this->config->item('base_www').'/actas/'.$row->titulo."/";
                if (file_exists($dir)) { 
                    $this->saveActa($row->idAltaVenta,$dir.$row->idAltaVenta.". ".str_replace ( "/", '', $row->nombre).".pdf",$row->fechaEntrega);
                }else{ 
                    mkdir($dir, 0777);
                    $this->saveActa($row->idAltaVenta,$dir.$row->idAltaVenta.". ".str_replace ( "/", '', $row->nombre).".pdf",$row->fechaEntrega);
                }
            }
        }
    }
    
    public function saveActa($id,$dir,$fecha){
        $this->load->library("mpdf_lib");
        $data = '';
        $info = $this->maltaventa->getByIdAll($id);
        $data = $info; 
        $data['mfraccionamiento'] = $this->mfraccionamiento;
        $this->idFraccionamiento = $info['idFraccionamiento'];
        $data['fechaEntrega']=$fecha;
        $this->setLogo();

        $html = $this->load->view('formatospdf/actapoliza2_view.php',$data,true);
        $this->mpdf_lib->savePDF($html,"actapoliza",0,'','',$this->urlLogo,'','',true,false,0,$dir);
    }
    public function setLogo(){
        $logoFraccionamiento = $this->mfraccionamiento->getCampo('foto',$this->idFraccionamiento);
        $nomFracc = $this->mfraccionamiento->getCampo('titulo',$this->idFraccionamiento);
        $this->urlLogo = ($logoFraccionamiento!='')?"<img height='80' src='uploads/fraccionamientos/".$logoFraccionamiento."' />":$nomFracc;
    }

    public function fixPmat(){
        $fecha='2024-09-02';
        $query=$this->db->query("SELECT idMaterial,paq.titulo,pmat.created FROM presupuesto_mat pmat
        LEFT JOIN material mat ON mat.id=pmat.idMaterial
        LEFT JOIN paquetes paq ON paq.id=mat.idPaquete
        WHERE pmat.created = '$fecha' AND pmat.tipo=0 GROUP BY pmat.idMaterial ORDER BY pmat.created ASC");
        echo "<pre>";
        print_r($query->result());

        $dir=$this->config->item('base_www')."/pmat/";
        $contents = scandir($dir);
        foreach ($contents as $filename) {
            if (file_exists($dir.$filename)) {
                if(date ("Y-m-d H:i:s.", filemtime($dir.$filename)) > $fecha){
                    echo "$filename was last modified: " . date ("Y-m-d H:i:s.", filemtime($dir.$filename))."<br>";
                }
            }
        }
    }

    public function checkPrograma(){
        $paquetes=$this->db->query("SELECT paq.id,paq.idManoObra,paq.nLotes,paq.titulo FROM paquetes paq
        LEFT JOIN arranque arr ON FIND_IN_SET(paq.id,arr.idPaquetes) WHERE estatus_arranque=2");

        foreach ($paquetes->result() as $row){
            $pmo=$this->db->query("SELECT id FROM presupuesto_mo WHERE tipo=1 AND idManoObra=".$row->idManoObra);
            $programa=$this->db->query("SELECT id FROM programa_obra WHERE idPaquete=". $row->id);
            if(($pmo->num_rows()*$row->nLotes) == $programa->num_rows()){
                $row->titulo." | Correcto | ".($pmo->num_rows()*$row->nLotes)." - ".$programa->num_rows()."<br>";
            }else{
                echo $row->titulo." | Incorrecto | ".($pmo->num_rows()*$row->nLotes)." - ".$programa->num_rows()."<br>";
            }
        }
    }

    public function cleanDataBase(){
        $idResidente=533;
        //--------------------------------mano de obra----------------------------------------
        $mano_obra=$this->db->query("SELECT paq.idManoObra id FROM paquetes paq 
        LEFT JOIN detalle_paquete dp ON dp.idPaquete=paq.id 
        LEFT JOIN arranque arr ON FIND_IN_SET(paq.id,arr.idPaquetes) 
        WHERE (arr.estatus_arranque = 3 OR dp.idResidente != $idResidente) AND paq.idManoObra NOT IN 
        (SELECT paq.idManoObra FROM paquetes paq LEFT JOIN arranque arr ON FIND_IN_SET(paq.id,arr.idPaquetes) WHERE arr.estatus_arranque < 3) 
        GROUP BY paq.idManoObra");
        //mano_obra
        $mano_obra=array_column($mano_obra->result_array(), 'id');
        $idsMano_obra=implode(",",$mano_obra);
        $this->db->query("DELETE FROM mano_obra WHERE id IN ($idsMano_obra)");
        echo "mano_obra: <br> rows: ".COUNT($mano_obra)." | afectados: ". $this->db->affected_rows()."<br><br>";
        //presupuesto_mo
        $presupuesto_mo=$this->db->query("SELECT id FROM presupuesto_mo WHERE idManoObra IN ($idsMano_obra)");
        $presupuesto_mo=array_column($presupuesto_mo->result_array(), 'id');
        $idsPresupuesto_mo=implode(",",$presupuesto_mo);
        $this->db->query("DELETE FROM presupuesto_mo WHERE id IN ($idsPresupuesto_mo)");
        echo "presupuesto_mo: <br> rows: ".COUNT($presupuesto_mo)." | afectados: ". $this->db->affected_rows()."<br><br>";
        //actividadesprototipo
        $actividadesprototipo=$this->db->query("DELETE FROM actividadesprototipo WHERE id NOT IN (SELECT idActividadPrototipo FROM presupuesto_mo)");
        echo "actividadesprototipo: ".$this->db->affected_rows()."<br><br>";

        //--------------------------------paquetes-----------------------------------------
        $paquetes=$this->db->query("SELECT paq.id FROM paquetes paq 
        LEFT JOIN detalle_paquete dp ON dp.idPaquete=paq.id 
        LEFT JOIN arranque arr ON FIND_IN_SET(paq.id,arr.idPaquetes) 
        WHERE (arr.estatus_arranque = 3 OR dp.idResidente != $idResidente) GROUP BY paq.id");

        //paquetes
        $paquetes=array_column($paquetes->result_array(), 'id');
        $idsPaquetes=implode(",",$paquetes);
        $this->db->query("DELETE FROM paquetes WHERE id IN ($idsPaquetes)");
        echo "paquetes: <br> rows: ".COUNT($paquetes)." | afectados: ". $this->db->affected_rows()."<br><br>";
        //proyectos
        $proyectos=$this->db->query("SELECT idProyecto id FROM detalle_paquete WHERE idPaquete IN ($idsPaquetes)");
        $proyectos=array_column($proyectos->result_array(), 'id');
        $idsProyecto=implode(",",$proyectos);
        $this->db->query("DELETE FROM proyectos WHERE id IN ($idsProyecto)");
        echo "proyectos: <br> rows: ".COUNT($proyectos)." | afectados: ". $this->db->affected_rows()."<br><br>";
        //detalle_paquete
        $detalle_paquete=$this->db->query("SELECT id FROM detalle_paquete WHERE idPaquete IN ($idsPaquetes)");
        $detalle_paquete=array_column($detalle_paquete->result_array(), 'id');
        $idsDetalle_paquete=implode(",",$detalle_paquete);
        $this->db->query("DELETE FROM detalle_paquete WHERE id IN ($idsDetalle_paquete)");
        echo "detalle_paquete: <br> rows: ".COUNT($detalle_paquete)." | afectados: ". $this->db->affected_rows()."<br><br>";
        //paquete_presupuesto
        $paquete_presupuesto=$this->db->query("SELECT id FROM paquete_presupuesto WHERE idPaquete IN ($idsPaquetes)");
        $paquete_presupuesto=array_column($paquete_presupuesto->result_array(), 'id');
        $idsPaquete_presupuesto=implode(",",$paquete_presupuesto);
        $this->db->query("DELETE FROM paquete_presupuesto WHERE id IN ($idsPaquete_presupuesto)");
        echo "paquete_presupuesto: <br> rows: ".COUNT($paquete_presupuesto)." | afectados: ". $this->db->affected_rows()."<br><br>";
        //estimacion
        $estimacion=$this->db->query("SELECT id FROM estimacion_programa WHERE idPaquete IN ($idsPaquetes)");
        $estimacion=array_column($estimacion->result_array(), 'id');
        $idsEstimacion=implode(",",$estimacion);
        $this->db->query("DELETE FROM estimacion_programa WHERE id IN ($idsEstimacion)");
        echo "estimacion: <br> rows: ".COUNT($estimacion)." | afectados: ". $this->db->affected_rows()."<br><br>";
        //estimaciones
        $estimaciones=$this->db->query("SELECT id FROM estimaciones_programa WHERE idEstimacion IN ($idsEstimacion)");
        $estimaciones=array_column($estimaciones->result_array(), 'id');
        $idsEstimaciones=implode(",",$estimaciones);
        $this->db->query("DELETE FROM estimaciones_programa WHERE id IN ($idsEstimaciones)");
        echo "estimaciones: <br> rows: ".COUNT($estimaciones)." | afectados: ". $this->db->affected_rows()."<br><br>";
        //estimados
        $estimados=$this->db->query("SELECT id FROM estimados_programa WHERE idEstimaciones IN ($idsEstimaciones)");
        $estimados=array_column($estimados->result_array(), 'id');
        $idsEstimados=implode(",",$estimados);
        $this->db->query("DELETE FROM estimados_programa WHERE id IN ($idsEstimados)");
        echo "estimados: <br> rows: ".COUNT($estimados)." | afectados: ". $this->db->affected_rows()."<br><br>";
        //avance
        $avance=$this->db->query("SELECT id FROM avanceobra WHERE idEstimado IN ($idsEstimados)");
        $avance=array_column($avance->result_array(), 'id');
        $idsAvance=implode(",",$avance);
        $this->db->query("DELETE FROM avanceobra WHERE id IN ($idsAvance)");
        echo "avance: <br> rows: ".COUNT($avance)." | afectados: ". $this->db->affected_rows()."<br><br>";
        //usuarios
        $this->db->query("DELETE FROM usuarios WHERE rol != 9");

        $paquetesActivos="SELECT idPaquete FROM detalle_paquete dp LEFT JOIN arranque arr ON FIND_IN_SET(dp.idPaquete,arr.idPaquetes) 
        WHERE arr.estatus_arranque < 3 AND dp.idResidente=$idResidente GROUP BY idPaquete";
    }

    public function layoutPrograma($idPaquete=0){
        $ppto=$this->db->query("SELECT pmo.id idPresupuesto,actmo.clave,cmo.categoria,CONCAT(SUBSTRING(actmo.descripcion,1,40),'...') descripcion FROM presupuesto_mo pmo 
        LEFT JOIN actividadesprototipo act ON act.id=pmo.idActividadPrototipo 
        LEFT JOIN mano_obra mo ON mo.id=pmo.idManoObra 
        LEFT JOIN paquetes paq ON paq.idManoObra=mo.id 
        LEFT JOIN categorias_mo cmo ON cmo.id=act.idCategoria 
        LEFT JOIN actividades_mo actmo ON actmo.id=act.idActividad 
        WHERE paq.id=$idPaquete");
        $lotes=$this->mdetallepaquete->getProyectosByPaquete($idPaquete);
        //echo "<pre>";
        //print_r($lotes->result());
        //exit();
        $columnas = array(
            'ID',
            'CLAVE',
            'CATEGORIA',
            'DESCRIPCION',
        );
        foreach ($lotes->result() as $row) {
            array_push($columnas,"LTE".$row->lote."-MZA".$row->manzana);
        }
        crearExcel($ppto,'Layout - Programa Obra',$columnas);
    }

    public function deletest(){
        $this->db->query("DELETE FROM compra WHERE idEmpresa=2");
        echo "Afectados: ".$this->db->affected_rows();
    }

    public function updateActividades(){
        //file uploaded
        $file_path = $this->data['fotos_www']."actividades.csv";
        if ($this->csvimport->get_array($file_path,'',TRUE)) {
            $csv_array = $this->csvimport->get_array($file_path);
            if (isset($csv_array[0])) {
                foreach ($csv_array as $value) { //recorremos el csv
                    if (isset($value['CLAVE']) && isset($value['DESCRIPCION']) && isset($value['DESCRIPCION']) ) {
                        if($value['CLAVE'] != ""){
                            $clave=$value['CLAVE'];
                            $actividad=$this->db->query("SELECT id FROM actividades_mo WHERE clave = '$clave'");
                            if($actividad->num_rows() == 1){
                                $abrevUnidad=$value["UNIDAD"];
                                $unidad=$this->db->query("SELECT id FROM unidades WHERE abreviatura LIKE '%$abrevUnidad%' OR unidad LIKE '%$abrevUnidad%'");
                                if($unidad->num_rows() > 0){
                                    $data=[
                                        "descripcion"=>utf8_encode($value['DESCRIPCION']),
                                        "precioUnitario"=>$value['P.U.'],
                                        "idUnidad"=>$unidad->row()->id
                                    ];
                                    $this->mactividadmo->actualizar($data,$actividad->row()->id);
                                }else{
                                    echo "La unidad ".$value["UNIDAD"]." no existe<br>";
                                }
                            }else if($actividad->num_rows() > 1){
                                echo "La clave ".$clave." está repetida ".$actividad->num_rows()." veces<br>";
                            }else if($actividad->num_rows() == 0){
                                echo "La clave ".$clave." no existe<br>";
                            }
                        }
                    }
                }
            }
        }
    }

    public function updateLineas(){
        //file uploaded
        $file_path = $this->data['fotos_www']."inventario.csv";
        if ($this->csvimport->get_array($file_path,'',TRUE)) {
            $csv_array = $this->csvimport->get_array($file_path);
            if (isset($csv_array[0])) {
                foreach ($csv_array as $value) { //recorremos el csv
                    if (isset($value['id']) && isset($value['lineaCredito'])) {
                        if($value['lineaCredito'] != ""){
                            echo $value['id']." - ".$value["lineaCredito"]."<br>";
                            $data=[
                                "lineaCredito" => $value['lineaCredito']
                            ];
                            $this->mproyecto->actualizar($data,$value['id']);
                        }
                    }
                }
            }
        }
    }

    public function index(){
        $qEmpresa = $this->mempresas->getAll();
        if( !is_numeric($qEmpresa) ){
            foreach($qEmpresa->result() as $row){
                $ordenes=$this->db->query("SELECT * FROM orden_compra WHERE idEmpresa=".$row->id);
                if($ordenes->num_rows() > 0){
                    foreach ($ordenes->result() as $orden) {
                        $this->db->query("UPDATE orden_compra SET folio=(SELECT semana FROM orden_compra_viv ocv WHERE ocv.folio=oc.folio AND oc.idPaquete=ocv.idPaquete LIMIT 1) WHERE id=$orden->id AND idEmpresa=".$row->id);
                    }
                }
            }
        }
    }

    public function comparativaArticulos(){
        $idEmpresa=1;
        $query="SELECT mate.id,mate.clave,mate.nombre FROM presupuesto_mat pmat 
        LEFT JOIN materialesactividadprototipo mact ON mact.id=pmat.idMateriales 
        LEFT JOIN material mat ON mat.id=pmat.idMaterial AND mat.idEmpresa=1
        LEFT JOIN materiales mate ON mate.id=mact.idMaterial WHERE mat.idEmpresa=1 GROUP BY mact.idMaterial";
        
        $query2="SELECT mate.id,mate.clave,GROUP_CONCAT(mate.nombre) nombres,GROUP_CONCAT(DISTINCT mate.idEmpresa) empresas FROM presupuesto_mat pmat 
        LEFT JOIN materialesactividadprototipo mact ON mact.id=pmat.idMateriales 
        LEFT JOIN material mat ON mat.id=pmat.idMaterial 
        LEFT JOIN materiales mate ON mate.id=mact.idMaterial GROUP BY mate.clave";

        $query="SELECT * FROM (SELECT mate.id,COUNT(DISTINCT mate.nombre) n,mate.clave,GROUP_CONCAT(DISTINCT mate.nombre) nombres,GROUP_CONCAT(DISTINCT mate.idEmpresa) empresas FROM presupuesto_mat pmat 
        LEFT JOIN materialesactividadprototipo mact ON mact.id=pmat.idMateriales 
        LEFT JOIN material mat ON mat.id=pmat.idMaterial 
        LEFT JOIN materiales mate ON mate.id=mact.idMaterial GROUP BY mate.clave) as tbl WHERE tbl.n > 1";
        $query=$this->db->query($query);
        $this->csvarray->getCSV($query->result_array(),"diferencias de descripcion");
    }

    public function comparativaClaves(){
        $query="SELECT * FROM (SELECT mate.id,COUNT(DISTINCT mate.clave) n,mate.nombre,GROUP_CONCAT(DISTINCT mate.clave) claves,GROUP_CONCAT(DISTINCT mate.idEmpresa) empresas FROM presupuesto_mat pmat 
        LEFT JOIN materialesactividadprototipo mact ON mact.id=pmat.idMateriales 
        LEFT JOIN material mat ON mat.id=pmat.idMaterial 
        LEFT JOIN materiales mate ON mate.id=mact.idMaterial GROUP BY mate.nombre) AS tbl WHERE tbl.n > 1";
        $query=$this->db->query($query);
        $this->csvarray->getCSV($query->result_array(),"diferencias de claves");
    }

    public function comparativaClavesProv(){
        $query="SELECT * FROM (SELECT prov.id,COUNT(DISTINCT prov.nombre) n,prov.clave,GROUP_CONCAT(DISTINCT prov.nombre) nombres,GROUP_CONCAT(DISTINCT prov.idEmpresa) empresas FROM proveedores prov GROUP BY prov.nombre  
        ORDER BY `n`  DESC) AS tbl WHERE tbl.n > 1";
        $query=$this->db->query($query);
        $this->csvarray->getCSV($query->result_array(),"diferencias de claves provedores");
    }
    
    public function updateAlmacenes(){
        $query=$this->db->query("SELECT idPaquete, idEmpresa FROM almacenes WHERE idPaquete > 0 AND idEmpresa > 0");
        if($query->num_rows() > 0){
            foreach ($query->result() as $row) {
                echo $row->idEmpresa." - ".$row->idPaquete."<br>";
                $this->updateByAlmacenSemana($row->idEmpresa,$row->idPaquete);
            }
        }
    }

    public function updateByAlmacenSemana($idPaquete,$semana=""){
        $filter="";
        if($semana != ""){
            $filter.=" AND semana=".$semana;
        }
        $ordenes=$this->db->query("SELECT id, idEmpresa, idPaquete FROM orden_compra WHERE idPaquete=$idPaquete $filter");
        if($ordenes->num_rows() > 0){
            foreach ($ordenes->result() as $row) {
                $this->cronjob->GetOrdenCompra($row->idEmpresa,$row->id,$row->idPaquete);
            }
        }else{
            echo "No hay nada que sincronizar";
        }
    }

    public function getDuplicadosMat(){
        $material=$this->db->query("SELECT * FROM material");
        foreach ($material->result() as $row) {
            $repeats="SELECT * FROM (SELECT mact.idMaterial,COUNT(pmat.id) n FROM presupuesto_mat pmat 
            LEFT JOIN materialesactividadprototipo mact ON mact.id=pmat.idMateriales WHERE pmat.idMaterial=$row->id 
            GROUP BY mact.idMaterial) tbl LEFT JOIN materiales mats ON mats.id=tbl.idMaterial WHERE tbl.n > 1";
            $repeats=$this->db->query($repeats);
            if($repeats->num_rows() > 0){
                echo "idPaquete: ".$row->idPaquete."<br>";
                echo "<pre>";
                print_r($repeats->result());
            }
        }
    }

    public function cleanByIdPaquete($idPaquete=0){
        if($idPaquete > 0){
            $paq=$this->mpaquete->getById($idPaquete);
            $ordenesPago=$this->db->query("SELECT id,monto FROM orden_pago WHERE idPaquete=$idPaquete");
            //Limpieza de op, estimados, avance y paquete presupuesto
            $this->db->query("UPDATE paquete_presupuesto SET lotesCompletados=0 WHERE idPaquete=$idPaquete");
            //ids a limpiar
            $ids=$this->db->query("SELECT ao.id FROM avanceobra ao INNER JOIN estimados_programa dos ON dos.id=ao.idEstimado INNER JOIN estimaciones_programa ones ON ones.id=dos.idEstimaciones 
            INNER JOIN estimacion_programa ion ON ion.id=ones.idEstimacion WHERE ao.id=dos.id AND ao.lotes AND ion.idPaquete=$idPaquete");
            if($ids->num_rows() > 0){
                foreach ($ids->result() as $row) {
                    $this->db->query("UPDATE avanceobra SET lotes='' WHERE id=$row->id");
                    $this->db->query("UPDATE estimados_programa SET estimacion=0 WHERE id=$row->id");
                }
            }
            //limpieza de ordenes de pago
            if($ordenesPago->num_rows() > 0){
                foreach ($ordenesPago->result() as $op) {
                    $this->db->query("DELETE FROM detalle_op WHERE idOrdenPago=$op->id");
                    $this->db->query("DELETE FROM orden_pago WHERE id=$op->id");
                }
            }
            echo "Se eliminaron ".$ordenesPago->num_rows()." ordenes de pago del paq: ".$paq["id"].".-".$paq["titulo"]."<br>";
        }else{
            echo "Debe ingresar un ID de Paquete";
        }
    }

    public function cleanPaquetesByPptos(){
        //$idPptos=[51,38,61,55];
        $idPptos=[88,56,63];
        if(COUNT($idPptos) > 0){
            foreach($idPptos as $val){
                $paq=$this->db->query("SELECT id,titulo FROM paquetes WHERE idManoObra=$val");
                if($paq->num_rows() > 0){
                    echo "ppto: ".$this->mmanoobra->getCampo("id",$val).".- ".$this->mmanoobra->getCampo("titulo",$val)."<br>";
                    foreach ($paq->result() as $paq) {
                        $ordenesPago=$this->db->query("SELECT id,monto FROM orden_pago WHERE idPaquete=$paq->id");
                        //Limpieza de op, estimados, avance y paquete presupuesto
                        $this->db->query("UPDATE paquete_presupuesto SET lotesCompletados=0 WHERE idPaquete=$paq->id");
                        //ids a limpiar
                        $ids=$this->db->query("SELECT ao.id FROM avanceobra ao INNER JOIN estimados_programa dos ON dos.id=ao.idEstimado INNER JOIN estimaciones_programa ones ON ones.id=dos.idEstimaciones 
                        INNER JOIN estimacion_programa ion ON ion.id=ones.idEstimacion WHERE ao.id=dos.id AND ao.lotes AND ion.idPaquete=$paq->id");
                        if($ids->num_rows() > 0){
                            foreach ($ids->result() as $row2) {
                                $this->db->query("UPDATE avanceobra SET lotes='' WHERE id=$row2->id");
                                $this->db->query("UPDATE estimados_programa SET estimacion=0 WHERE id=$row2->id");
                            }
                        }
                        //limpieza de ordenes de pago
                        if($ordenesPago->num_rows() > 0){
                            foreach ($ordenesPago->result() as $op) {
                                $this->db->query("DELETE FROM detalle_op WHERE idOrdenPago=$op->id");
                                $this->db->query("DELETE FROM orden_pago WHERE id=$op->id");
                            }
                        }
                        echo "Se eliminaron ".$ordenesPago->num_rows()." ordenes de pago del paq: $paq->id.- $paq->titulo<br>";
                    }
                }
            }
        }
    }

    public function addExtraPmo(){
        //Presupuestos
        $pptos=$this->db->query("SELECT id,titulo FROM mano_obra WHERE status=1");
        if($pptos->num_rows() > 0){
            foreach($pptos->result() as $row){
                //paquetes por presupuesto
                $paq=$this->db->query("SELECT id,titulo FROM paquetes WHERE idManoObra=$row->id");
                //Deteccion de duplicados
                $duplicados=$this->db->query("SELECT id,(SELECT idActividad FROM actividadesprototipo ap WHERE ap.id=pmo.idActividadPrototipo) idActividad,idActividadPrototipo,precioUnitario,importe  FROM presupuesto_mo pmo WHERE (SELECT idActividad FROM actividadesprototipo ap WHERE ap.id=pmo.idActividadPrototipo) IN 
                (SELECT tbl.idActividad FROM (SELECT ap.id,ap.idActividad,COUNT(ap.idActividad) n FROM presupuesto_mo pmo LEFT JOIN 
                actividadesprototipo ap ON pmo.idActividadPrototipo=ap.id WHERE pmo.idManoObra=$row->id  AND ap.tipo=2 GROUP BY ap.idActividad ORDER BY COUNT(ap.idActividad) DESC) tbl WHERE tbl.n > 1) 
                AND pmo.idManoObra=$row->id");
                //si no existen duplicados
                if($duplicados->num_rows() == 0){
                    if($paq->num_rows() > 0){
                        foreach ($paq->result() as $row2) {
                            //idPresupuestos faltantes en estimados
                            $pptoByPaq=$this->db->query("SELECT id FROM presupuesto_mo WHERE idManoObra=$row->id AND id NOT IN (SELECT dos.idPresupuesto FROM estimados_programa dos 
                            INNER JOIN estimaciones_programa ones ON ones.id=dos.idEstimaciones INNER JOIN estimacion_programa ion ON ion.id=ones.idEstimacion 
                            WHERE ion.idPaquete=$row2->id GROUP BY dos.idPresupuesto)");
                            //se valida si existen conceptos faltantes
                            if($pptoByPaq->num_rows() > 0){
                                //Total de estimaciones
                                $estiByPaq=$this->db->query("SELECT id, nEstimacion FROM estimaciones_programa WHERE idEstimacion=(SELECT id FROM estimacion_programa WHERE idPaquete=$row2->id)");
                                $nConceptos=$estiByPaq->num_rows();
                                if($nConceptos > 0){
                                    foreach ($estiByPaq->result() as $row3) {
                                        //insercion de estimados por estimaciones y avance de obra
                                        foreach ($pptoByPaq->result() as $row4) {
                                            $esData['idEstimaciones'] = $row3->id;
                                            $esData['idPresupuesto'] = $row4->id;
                                            $esData['estimacion'] = 0;
                                            $idE2 = $this->mestimadosprograma->insertar($esData);
                                            $avData['idEstimado'] = $idE2;
                                            $idA = $this->mavanceobra->insertar($avData);
                                        }
                                    }
                                    echo "Se añadieron $nConceptos conceptos en el paquete $row2->id.- $row2->titulo del ppto. $row->id.- $row->titulo <br>";
                                }else{
                                    echo "No existen estimaciones para este paquete";
                                }
                            }
                        }
                    }
                }else{
                    echo "Existen conceptos duplicados en el presupuesto $row->id.- $row->titulo <br>";
                }
            }
        }
    }

    public function getPaquetesByPptos(){
        $pptos=$this->db->query("SELECT * FROM mano_obra WHERE status=1");
        if($pptos->num_rows() > 0){
            foreach($pptos->result() as $row){
                $paq=$this->db->query("SELECT * FROM paquetes WHERE idManoObra=$row->id");
                if($paq->num_rows() > 0){
                    echo "ppto: ".$row->id.".- ".$row->titulo."<br>";
                    foreach ($paq->result() as $row2) {
                        echo "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;paq: ".$row2->id.".- ".$row2->titulo."<br>";
                    }
                }
            }
        }
    }

    public function fixDuplicadosMo(){
        $idMo=496;
        $helper="SELECT (SELECT act.clave FROM actividades_mo act WHERE id=ap.idActividad) clave,ap.idActividad,COUNT(ap.idActividad) n FROM presupuesto_mo pmo LEFT JOIN 
        actividadesprototipo ap ON pmo.idActividadPrototipo=ap.id WHERE pmo.idManoObra=$idMo GROUP BY ap.idActividad ORDER BY COUNT(ap.idActividad) DESC";
        //lo anterior es temporal
        $directorio=$this->config->item('base_www')."/pmo/cuadre/";
        $pptos=scandir($directorio, 1);
        if(COUNT($pptos) > 0){
            //echo "<pre>";
            //print_r($pptos);
            //exit();
            foreach ($pptos as $key => $val) {
                if(!in_array($val,['.','..'])){
                    $idMo=explode(".", $val)[0];
                    $manoobra=$this->mmanoobra->getById($idMo);
                    if(is_numeric($idMo) && !is_numeric($manoobra)){
                        $pmo=$this->db->query("SELECT id,(SELECT idActividad FROM actividadesprototipo ap WHERE ap.id=pmo.idActividadPrototipo) idActividad,idActividadPrototipo,precioUnitario,importe  FROM presupuesto_mo pmo WHERE (SELECT idActividad FROM actividadesprototipo ap WHERE ap.id=pmo.idActividadPrototipo) IN 
                        (SELECT tbl.idActividad FROM (SELECT ap.id,ap.idActividad,COUNT(ap.idActividad) n FROM presupuesto_mo pmo LEFT JOIN 
                        actividadesprototipo ap ON pmo.idActividadPrototipo=ap.id WHERE pmo.idManoObra=$idMo GROUP BY ap.idActividad ORDER BY COUNT(ap.idActividad) DESC) tbl WHERE tbl.n > 1) 
                        AND pmo.idManoObra=$idMo");
                        if($pmo->num_rows()>0){
                            $pmo=$pmo->result_array();
                            if ($this->csvimport->get_array($directorio.$val,'',TRUE)) {
                                $csv_array = $this->csvimport->get_array($directorio.$val);
                                if (isset($csv_array[0]['CLAVE']) && isset($csv_array[0]['PRECIO UNITARIO']) && isset($csv_array[0]['CANTIDAD'])) {
                                    echo $idMo."--------------:".COUNT($pmo)." - ".COUNT($csv_array)."<br>";
                                    $nExist=0;
                                    //revision de importe iguales
                                    foreach ($csv_array as $k => $v) {
                                        $actividad=$this->mactividadmo->getByClave($v["CLAVE"]);
                                        if(!is_numeric($actividad)){
                                            $existe=$this->db->query("SELECT ($actividad->id  IN (SELECT tbl.idActividad FROM (SELECT ap.idActividad,COUNT(ap.idActividad) n FROM presupuesto_mo pmo LEFT JOIN actividadesprototipo ap ON 
                                            pmo.idActividadPrototipo=ap.id WHERE pmo.idManoObra=$idMo GROUP BY ap.idActividad ORDER BY COUNT(ap.idActividad) DESC) tbl WHERE tbl.n > 1) OR $actividad->id 
                                            NOT IN (SELECT idActividad FROM actividadesprototipo act WHERE act.id IN (SELECT idActividadPrototipo FROM presupuesto_mo WHERE idManoObra=$idMo))) insertar");
                                            if($existe->row()->insertar){
                                                $importe=(number_format($v["PRECIO UNITARIO"]*$v["CANTIDAD"],2));

                                                $obj = array_filter($pmo, function ($obj) use ($importe) {
                                                    return $obj["importe"] == $importe;
                                                });
                                                if(COUNT($obj)>0){
                                                    $myKey=implode(" ",array_keys($obj));
                                                    $myKey=explode(" ",$myKey)[0];
                                                    //echo "1 - ".$importe." | ".$obj[$myKey]["importe"]." | ".$existe->row()->insertar."<br>";
                                                    $datActProt['idPrototipo'] = $manoobra["idPrototipo"];
                                                    $datActProt['idCategoria'] = $actividad->idCategoria;
                                                    $datActProt['idActividad'] = $actividad->id;
                                                    $datActProt['cantidad'] = $v["CANTIDAD"];
                                                    $datActProt['tipo'] = 2;
                                                    $idActProt = $this->mactividadesprototipo->insertar($datActProt);
                                                    $pData['idActividadPrototipo'] = $idActProt;
                                                    $pData['precioUnitario'] = round ($v['PRECIO UNITARIO'], 2);
                                                    $pData['importe'] = round($v['CANTIDAD'] * $v['PRECIO UNITARIO'], 2);
                                                    $this->mpresupuestomo->actualizar($pData,$obj[$myKey]["id"]);
                                                    $nExist++;
                                                    unset($pmo[$myKey]);
                                                    unset($csv_array[$k]);
                                                }
                                            }
                                        }
                                    }
                                    if(COUNT($pmo) > 0){
                                        //Revision de importes cercanos en 1.99
                                        foreach ($csv_array as $k => $v) {
                                            $error=0.99;
                                            $importe=round($v["PRECIO UNITARIO"]*$v["CANTIDAD"]);
                                            foreach ($pmo as $k2 => $v2) { 
                                                $actividad=$this->mactividadmo->getByClave($v["CLAVE"]);
                                                if(!is_numeric($actividad)){
                                                    $existe=$this->db->query("SELECT ($actividad->id  IN (SELECT tbl.idActividad FROM (SELECT ap.idActividad,COUNT(ap.idActividad) n FROM presupuesto_mo pmo LEFT JOIN actividadesprototipo ap ON 
                                                    pmo.idActividadPrototipo=ap.id WHERE pmo.idManoObra=$idMo GROUP BY ap.idActividad ORDER BY COUNT(ap.idActividad) DESC) tbl WHERE tbl.n > 1) OR $actividad->id 
                                                    NOT IN (SELECT idActividad FROM actividadesprototipo act WHERE act.id IN (SELECT idActividadPrototipo FROM presupuesto_mo WHERE idManoObra=$idMo))) insertar");
                                                    if($existe->row()->insertar){
                                                        if(($importe - $error) <= $v2["importe"] && ($importe + $error) >= $v2["importe"]){
                                                            //echo "2 - ".$importe." | ".$v2["importe"]." | ".$existe->row()->insertar."<br>";
                                                            $datActProt['idPrototipo'] = $manoobra["idPrototipo"];
                                                            $datActProt['idCategoria'] = $actividad->idCategoria;
                                                            $datActProt['idActividad'] = $actividad->id;
                                                            $datActProt['cantidad'] = $v["CANTIDAD"];
                                                            $datActProt['tipo'] = 2;
                                                            $idActProt = $this->mactividadesprototipo->insertar($datActProt);
                                                            $pData['idActividadPrototipo'] = $idActProt;
                                                            $pData['precioUnitario'] = round ($v['PRECIO UNITARIO'], 2);
                                                            $pData['importe'] = round($v['CANTIDAD'] * $v['PRECIO UNITARIO'], 2);
                                                            $this->mpresupuestomo->actualizar($pData,$v2["id"]);
                                                            $nExist++;
                                                            unset($pmo[$k2]);
                                                            unset($csv_array[$k]);
                                                        }   
                                                    }
                                                }
                                            }
                                        }
                                    }  
                                    echo $idMo."--------------:".$nExist." - ".COUNT($pmo)."<br>";
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    public function getDuplicadosMo(){
        $mo=$this->db->query("SELECT id, titulo FROM mano_obra WHERE status=1");
        $mo=($mo->num_rows() > 0) ? $mo->result() : 0;
        if(!is_numeric($mo)){
            foreach ($mo as $row) {
                $pmo=$this->db->query("SELECT tbl.idActividad FROM 
                (SELECT ap.idActividad,COUNT(ap.idActividad) n FROM presupuesto_mo pmo LEFT JOIN actividadesprototipo ap ON pmo.idActividadPrototipo=ap.id 
                WHERE pmo.idManoObra=$row->id GROUP BY ap.idActividad ORDER BY COUNT(ap.idActividad) DESC) tbl WHERE tbl.n > 1");
                if($pmo->num_rows() > 0){
                    $paquetes=$this->db->query("SELECT CONCAT(id,':',titulo) title FROM paquetes WHERE idManoObra=$row->id");
                    if($paquetes->num_rows() > 0){
                        foreach ($paquetes->result_array() as $key => $val) {
                            echo $row->id." - ".$row->titulo." | ".implode("",$val)."<br>";
                        }
                    }
                }
            }
        }
    }

    public function fixEstimados($idPaquete){
        $estimaciones=$this->db->query("SELECT nEstimacion FROM estimaciones_programa WHERE idEstimacion=(SELECT id FROM estimacion_programa WHERE idPaquete=$idPaquete)");
        $presupuesto="SELECT pmo.id FROM presupuesto_mo pmo WHERE pmo.idManoObra=(SELECT idManoObra FROM paquetes paq WHERE paq.id=$idPaquete) AND pmo.id NOT IN 
        (SELECT dos.idPresupuesto FROM avanceobra ao INNER JOIN estimados_programa dos ON dos.id=ao.idEstimado INNER JOIN estimaciones_programa ones ON 
        ones.id=dos.idEstimaciones INNER JOIN estimacion_programa ion ON ion.id=ones.idEstimacion WHERE ion.idPaquete=$idPaquete GROUP BY dos.idPresupuesto) ORDER BY pmo.id";
        $presupuesto=$this->db->query($presupuesto);
        if($estimaciones->num_rows() > 0){     
            echo "Numero de Estimaciones ".$estimaciones->num_rows().'<br>';       
            foreach ($estimaciones->result() as $row) {
                $estimados="SELECT dos.id,dos.idPresupuesto,ao.lotes FROM avanceobra ao INNER JOIN estimados_programa dos ON dos.id=ao.idEstimado 
                INNER JOIN estimaciones_programa ones ON ones.id=dos.idEstimaciones 
                INNER JOIN estimacion_programa ion ON ion.id=ones.idEstimacion WHERE ion.idPaquete=$idPaquete AND ones.nEstimacion=$row->nEstimacion AND dos.idPresupuesto IN
                 (SELECT tbl.idPresupuesto FROM (SELECT dos.idPresupuesto,COUNT(dos.id) n FROM avanceobra ao INNER JOIN estimados_programa dos ON dos.id=ao.idEstimado 
                 INNER JOIN estimaciones_programa ones ON ones.id=dos.idEstimaciones INNER JOIN estimacion_programa ion ON ion.id=ones.idEstimacion WHERE 
                 ion.idPaquete=$idPaquete GROUP BY dos.idPresupuesto ORDER BY COUNT(dos.id) DESC) tbl WHERE tbl.n <> (SELECT COUNT(id) FROM estimaciones_programa WHERE
                  idEstimacion=(SELECT id FROM estimacion_programa WHERE idPaquete=$idPaquete))) ORDER BY dos.id";
                $estimados=$this->db->query($estimados);
                //echo "<pre>";
                //print_r($presupuesto->num_rows());
                //echo "<br>";
                //print_r($estimados->num_rows());
                //exit();
                if($presupuesto->num_rows() > 0){
                    $i=0;
                    $tempPpto=$presupuesto->result_array();
                    foreach ($estimados->result() as $est) {
                        if($est->lotes == ''){
                            if(isset($tempPpto[$i]['id'])){
                                $this->mestimadosprograma->actualizar([
                                    'idPresupuesto' => $tempPpto[$i]['id']
                                ], $est->id);
                                $i++;
                            }
                        }
                    }
                    echo $i." Registros Actualizados, en la semana".$row->nEstimacion."<br>";
                }else{
                    echo "No hay repetidos";
                    break;
                }
            }
        }
    }

    public function getReporteMat($idEmpresa=1){
        $prueba="SELECT (SELECT clave FROM materiales WHERE id=(SELECT idMaterial FROM materialesactividadprototipo map WHERE map.id=pmat.idMateriales) AND idEmpresa=1 LIMIT 1) clave FROM presupuesto_mat pmat ORDER BY `id` DESC";
        //$prueba2="(SELECT SUM(importe) FROM presupuesto_mat pmat WHERE $valClave AND $valIdAlmacen GROUP BY $id_almacen) importe_ppto";
        //Inicia armado de columnas
        $id_almacen="(SELECT id_almacen FROM compra c WHERE c.id=dc.id_compra AND idEmpresa=$idEmpresa)";
        $valIdAlmacen="(SELECT id FROM almacenes WHERE idEmpresa=$idEmpresa AND idPaquete=(SELECT idPaquete FROM material m WHERE m.id=pmat.idMaterial) LIMIT 1)=$id_almacen";
        $id_articulo="(SELECT idMaterial FROM materialesactividadprototipo map WHERE map.id=pmat.idMateriales)";
        $valArticulo="$id_articulo = dc.id_articulo";
        $query="SELECT
        id,
        $id_almacen id_almacen,
        COUNT(id) cant_oc,
        clave_articulo,
        (SELECT fecha FROM compra WHERE id=id_compra AND idEmpresa=$idEmpresa) fecha,
        (SELECT abrev FROM empresas WHERE id=$idEmpresa) empresa,
        SUM(unidades * precio_unitario) importe_comprado,
        GROUP_CONCAT((SELECT folio FROM compra WHERE id=id_compra AND idEmpresa=$idEmpresa) SEPARATOR ',') folios,
        (SELECT SUM(importe) FROM presupuesto_mat pmat WHERE $valIdAlmacen AND $valArticulo GROUP BY $id_articulo) importe_ppto
        FROM detalle_compra dc
        WHERE (SELECT id_almacen FROM compra WHERE id=id_compra AND idEmpresa=$idEmpresa) <> ''
        GROUP BY clave_articulo, (SELECT id_almacen FROM compra WHERE id=id_compra AND idEmpresa=$idEmpresa)
        ORDER BY (SELECT id_almacen FROM compra WHERE id=id_compra AND idEmpresa=$idEmpresa), (SELECT idEmpresa FROM compra WHERE id=id_compra AND idEmpresa=$idEmpresa) ASC
        LIMIT 10";
        $query=$this->db->query($query);
        echo "<pre>";
        print_r($query->result());
    }

    public function getReporteMat2($idEmpresa=1){
        //Inicia armado de columnas
        $id_almacen="(SELECT id_almacen FROM compra c WHERE c.id=dc.id_compra AND idEmpresa=$idEmpresa)";
        $valIdAlmacen="dc.idPaquete=(SELECT idPaquete FROM material m WHERE m.id=pmat.idMaterial)";
        $id_articulo="(SELECT idMaterial FROM materialesactividadprototipo map WHERE map.id=pmat.idMateriales)";
        $valArticulo="$id_articulo = dc.id_articulo";
        
        $query="SELECT
        id,
        $id_almacen id_almacen,
        (SELECT nombre FROM almacenes WHERE idPaquete=dc.idPaquete AND idEmpresa=$idEmpresa) nombre_almacen,
        COUNT(id) cant_oc,
        clave_articulo,
        (SELECT nombre FROM materiales m WHERE m.id=dc.id_articulo AND m.idEmpresa=$idEmpresa LIMIT 1) articulo,
        (SELECT abrev FROM empresas WHERE id=$idEmpresa) empresa,
        (SELECT SUM(importe / precioUnitario) FROM presupuesto_mat pmat WHERE $valIdAlmacen AND $valArticulo) cantidad_ppto,
        (SELECT SUM(importe) FROM presupuesto_mat pmat WHERE $valIdAlmacen AND $valArticulo) importe_ppto,
        (SELECT SUM(unidades) FROM detalle_orden doc WHERE doc.idPaquete=dc.idPaquete AND dc.id_articulo=doc.id_articulo AND doc.idEmpresa=$idEmpresa) unidades_oc,
        (SELECT SUM(unidades * precio_unitario) FROM detalle_orden doc WHERE doc.idPaquete=dc.idPaquete AND dc.id_articulo=doc.id_articulo AND doc.idEmpresa=$idEmpresa) importe_oc,
        SUM(unidades) unidades_comprado,
        SUM(unidades * precio_unitario) importe_comprado,
        GROUP_CONCAT((SELECT folio FROM compra WHERE id=id_compra AND idEmpresa=$idEmpresa) SEPARATOR ',') folios_compras
        FROM detalle_compra dc
        WHERE idPaquete > 0 AND dc.idEmpresa=$idEmpresa
        GROUP BY clave_articulo, dc.idPaquete
        ORDER BY dc.idPaquete, dc.idEmpresa";
        $query=$this->db->query($query);
        $columnas = array(
            0 => 'ID',
            1 => 'ID ALMACEN',
            2 => 'NOMBRE ALMACEN',
            3 => '# FOLIOS',
            4 => 'CLAVE',
            5 => 'ARTICULO',
            6 => 'EMPRESA',
            7 => 'CANT. PPTO.',
            8 => 'IMPORTE PPTO.',
            9 => 'CANT. OC.',
            10 => 'IMPORTE OC.',
            11 => 'CANT. COMPRAS',
            12 => 'IMPORTE COMPRAS',
            13 => 'FOLIOS COMPRAS',
        );
        crearExcel($query,'Totales Almacenes vs Ppto.',$columnas);
    }   

    public function getReporteJoin($idEmpresa=1){
        $this->benchmark->mark('code_start');

        $id_almacen="(SELECT id_almacen FROM compra c WHERE c.id=dc.id_compra AND idEmpresa=$idEmpresa LIMIT 1)";
        $valIdAlmacen="dc.idPaquete=(SELECT idPaquete FROM material m WHERE m.id=pmat.idMaterial)";
        $id_articulo="(SELECT idMaterial FROM materialesactividadprototipo map WHERE map.id=pmat.idMateriales)";
        $valArticulo="$id_articulo = dc.id_articulo";
        
        $query=$this->db->query("
        SELECT 
        dc.id, 
        al.id id_almacen, 
        al.nombre nombre_almacen,
        mat.nombre articulo,
        em.abrev,
        (SELECT SUM((importe * (SELECT nLotes FROM paquetes p WHERE p.id=dc.idPaquete)) / precioUnitario) FROM presupuesto_mat pmat WHERE $valIdAlmacen AND $valArticulo) cantidad_ppto,
        (SELECT SUM(importe * (SELECT nLotes FROM paquetes p WHERE p.id=dc.idPaquete)) FROM presupuesto_mat pmat WHERE $valIdAlmacen AND $valArticulo) importe_ppto
        FROM detalle_compra dc
        LEFT JOIN compra c ON dc.id
        LEFT JOIN almacenes al ON al.id=c.id_almacen
        LEFT JOIN materiales mat ON mat.id=dc.id_articulo
        LEFT JOIN empresas em ON em.id=$idEmpresa
        LEFT JOIN paquetes paq ON paq.id=al.idEmpresa
        WHERE 
        c.idEmpresa=$idEmpresa AND mat.idEmpresa=$idEmpresa
        AND dc.idPaquete > 0 
        GROUP BY dc.clave_articulo, dc.idPaquete
        LIMIT 1000
        ");
        $this->benchmark->mark('code_end');
        echo $this->benchmark->elapsed_time('code_start', 'code_end');
        echo "<pre>";
        print_r($query->result());
    }

    public function updateIdPaquete($idEmpresa=1){
        $valIdEmpresa="idEmpresa=$idEmpresa";
        $valIdAlmacen="AND (SELECT idPaquete FROM almacenes al WHERE al.id=id_almacen AND $valIdEmpresa) > 0";
        $query="
            UPDATE orden_compra oc SET idPaquete=(SELECT idPaquete FROM almacenes al WHERE al.id=oc.id_almacen AND $valIdEmpresa) WHERE $valIdEmpresa $valIdAlmacen; <br>
            UPDATE detalle_orden doc SET idPaquete=(SELECT idPaquete FROM almacenes al WHERE al.id=(SELECT oc.id_almacen FROM orden_compra oc WHERE oc.id=doc.id_orden_compra AND $valIdEmpresa) AND $valIdEmpresa) 
            WHERE $valIdEmpresa AND (SELECT idPaquete FROM almacenes al WHERE al.id=(SELECT oc.id_almacen FROM orden_compra oc WHERE oc.id=doc.id_orden_compra AND $valIdEmpresa)) > 0; <br>
            UPDATE compra c SET idPaquete=(SELECT idPaquete FROM almacenes al WHERE al.id=c.id_almacen AND $valIdEmpresa) WHERE $valIdEmpresa $valIdAlmacen; <br>
            UPDATE detalle_compra dc SET idPaquete=(SELECT idPaquete FROM almacenes al WHERE al.id=(SELECT c.id_almacen FROM compra c WHERE c.id=dc.id_compra AND $valIdEmpresa) AND $valIdEmpresa)
            AND (SELECT idPaquete FROM almacenes al WHERE al.id=(SELECT c.id_almacen FROM compra c WHERE c.id=dc.id_compra AND $valIdEmpresa) AND $valIdEmpresa) > 0; <br>
            UPDATE recepcion r SET idPaquete=(SELECT idPaquete FROM almacenes al WHERE al.id=r.id_almacen AND $valIdEmpresa) WHERE $valIdEmpresa $valIdAlmacen; <br>
            UPDATE detalle_recepcion dr SET idPaquete=(SELECT idPaquete FROM almacenes al WHERE al.id=(SELECT r.id_almacen FROM recepcion r WHERE r.id=dr.id_recepcion AND $valIdEmpresa) AND $valIdEmpresa) 
            WHERE $valIdEmpresa AND (SELECT idPaquete FROM almacenes al WHERE al.id=(SELECT r.id_almacen FROM recepcion r WHERE r.id=dr.id_recepcion AND $valIdEmpresa)) > 0; <br>
        ";
        echo $query;
        //$this->db->query($query);
    }

    public function getPermisos(){
        //echo "<pre>";
        //print_r(permisos('',true));
        $permisos=permisos('',true);
        $i=0;
        foreach($permisos as $key => $val){
            if(!in_array($key,["debug","rtest","firma"])){
                $i++;
                echo "<strong>".$i.".-".$key."</strong><br>";
                if(COUNT($val[0]) > 0){
                    foreach($val[0] as $_key => $_val){
                        echo "-".getRol($_val)."<br>";
                    }
                }
            }
        }
    }

    public function arreglarEstimacion($idPaquete=0){
        if($idPaquete > 0 && is_numeric($idPaquete)){
            $this->db->trans_begin();
            $lastEstimaciones=$this->db->query("SELECT id, nEstimacion,(SELECT COUNT(id) FROM avanceobra ao WHERE lotes <> '' AND ao.idEstimado IN 
            (SELECT id FROM estimados_programa estimado WHERE estimado.idEstimaciones=sem.id)) suma FROM estimaciones_programa sem WHERE
            (SELECT idPaquete FROM estimacion_programa WHERE id=idEstimacion)=$idPaquete ORDER BY (SELECT COUNT(id) FROM avanceobra ao WHERE lotes <> '' AND ao.idEstimado IN 
            (SELECT id FROM estimados_programa estimado WHERE estimado.idEstimaciones=sem.id)) DESC LIMIT 1");
            $actualWeek=$lastEstimaciones->row()->nEstimacion;
            $idEstimacionesActual=$lastEstimaciones->row()->id;
            $beforeWeek=$actualWeek - 1;
            //la anterior osea la correcta
            $beforeEstimaciones=$this->db->query("SELECT id, nEstimacion FROM estimaciones_programa estimaciones WHERE nEstimacion=$beforeWeek AND 
            (SELECT idPaquete FROM estimacion_programa estimacion WHERE estimaciones.idEstimacion=estimacion.id)=$idPaquete");
            $idEstimacionesBefore=$beforeEstimaciones->row()->id;
            //avance de obra actual
            $lastAvanceObra=$this->db->query("SELECT id idAvanceObra, lotes, (SELECT idPresupuesto FROM estimados_programa WHERE id=idEstimado) idPresupuesto FROM avanceobra ao WHERE lotes <> '' 
            AND ao.idEstimado IN (SELECT id FROM estimados_programa estimado WHERE estimado.idEstimaciones=$idEstimacionesActual) ORDER BY (SELECT idPresupuesto FROM estimados_programa WHERE id=idEstimado) ASC");
            //avance de obra anterior
            $beforeAvanceObra=$this->db->query("SELECT id idAvanceObra, (SELECT idPresupuesto FROM estimados_programa WHERE id=idEstimado) idPresupuesto FROM avanceobra ao WHERE ao.idEstimado IN 
            (SELECT id FROM estimados_programa estimado WHERE estimado.idEstimaciones=$idEstimacionesBefore) AND (SELECT idPresupuesto FROM estimados_programa WHERE id=idEstimado) IN 
            (SELECT (SELECT idPresupuesto FROM estimados_programa WHERE id=idEstimado) idPresupuesto FROM avanceobra ao WHERE lotes <> '' AND ao.idEstimado IN (SELECT id FROM estimados_programa estimado WHERE estimado.idEstimaciones=$idEstimacionesActual))
            ORDER BY (SELECT idPresupuesto FROM estimados_programa WHERE id=idEstimado) ASC");
            //Estimados
            $lastEstimados=$this->db->query("SELECT id idEstimado, estimacion FROM estimados_programa WHERE idEstimaciones=$idEstimacionesActual AND estimacion <> '' ORDER BY idPresupuesto");
            $beforeEstimados=$this->db->query("SELECT id idEstimado, estimacion FROM estimados_programa WHERE idEstimaciones=$idEstimacionesBefore AND idPresupuesto IN 
            (SELECT idPresupuesto FROM estimados_programa WHERE idEstimaciones=$idEstimacionesActual AND estimacion <> '') ORDER BY idPresupuesto");
            //Salidas de prueba
            //echo "<pre>";
            //print_r($lastEstimaciones->row());
            //print_r($beforeEstimaciones->row());
            //print_r($lastAvanceObra->result());
            //print_r($beforeAvanceObra->result());
            //print_r($ordenPago->result());
            //echo $idEstimacionesBefore->row()->idEstimaciones;
            //OPERACIONES DE REASIGNACION
            if($lastAvanceObra->num_rows()>0 && $beforeAvanceObra->num_rows()>0){
                $lastAvanceObra=$lastAvanceObra->result_array();
                $beforeAvanceObra=$beforeAvanceObra->result_array();
                //Avance de obra
                foreach ($lastAvanceObra as $key => $val) {
                    $lotes=$val["lotes"];
                    $lastIdAvanceObra=$val["idAvanceObra"];
                    $beforeIdAvanceObra=$beforeAvanceObra[$key]["idAvanceObra"];
                    //echo $lotes." ".$lastIdAvanceObra." ".$beforeIdAvanceObra;
                    $this->db->query("UPDATE avanceobra SET lotes='$lotes' WHERE id=$beforeIdAvanceObra");
                    $this->db->query("UPDATE avanceobra SET lotes='' WHERE id=$lastIdAvanceObra");
                }
                //Estimados
                if($lastEstimados->num_rows()>0 && $beforeEstimados->num_rows()>0){
                    $lastEstimados=$lastEstimados->result_array();
                    $beforeEstimados=$beforeEstimados->result_array();
                    foreach ($lastEstimados as $key => $val) {
                        $estimacion=$val["estimacion"];
                        $lastIdEstimado=$val["idEstimado"];
                        $beforeIdEstimado=$beforeEstimados[$key]["idEstimado"];
                        //echo $lotes." ".$lastIdAvanceObra." ".$beforeIdAvanceObra;
                        $this->db->query("UPDATE estimados_programa SET estimacion=$estimacion WHERE id=$beforeIdEstimado");
                        $this->db->query("UPDATE estimados_programa SET estimacion=0 WHERE id=$lastIdEstimado");
                    }
                }
                //Orden Pago
                $ordenPago=$this->db->query("SELECT id idOrdenPago,idEstimaciones FROM `orden_pago` WHERE idPaquete=$idPaquete AND idEstimaciones LIKE '%$idEstimacionesActual%'");
                if($ordenPago->num_rows()>0){
                    $idEstimacionesLast=$ordenPago->row()->idEstimaciones;
                    $idEstimacionesBefore=$this->db->query("SELECT REPLACE('$idEstimacionesLast',',$idEstimacionesActual','') idEstimaciones");
                    $idEstimacionesBefore=$idEstimacionesBefore->row()->idEstimaciones;
                    $ordenPago=$ordenPago->row();
                    $this->db->query("UPDATE orden_pago SET idEstimaciones='$idEstimacionesBefore' WHERE id=$ordenPago->idOrdenPago");
                }

            }
            if ($this->db->trans_status() === FALSE){
                    $this->db->trans_rollback();
            }else{
                    $this->db->trans_commit();
            }
            echo "Se ha pasado el pago y sus estimados de la estimacion $actualWeek a la $beforeWeek";
        }
    }

    public function getRolesUsers(){
        //echo "<pre>";
        //print_r(permisos('',true));
        $usuarios=$this->musuario->getAll();
        if(!is_numeric($usuarios)){
            foreach ($usuarios->result() as $row) {
                echo getRol($row->rol)." | ".$row->nombre." ".$row->apellidoP." ".$row->apellidoM."<br>";
                //echo getRol($row->rol)."<br>";
                //echo $row->txtstatus."<br>";
            }
        }
    }

    public function fixProveedores(){
        $query=$this->db->query("SELECT *,(SELECT nombre FROM proveedores p WHERE p.id=idProveedor LIMIT 1) proveedor,
        (SELECT idEmpresa FROM material m WHERE m.id=pm.idMaterial) idEmpresa FROM
        presupuesto_mat pm WHERE (SELECT idEmpresa FROM material m WHERE m.id=pm.idMaterial) > 1");
        $updates=0;
        if($query->num_rows() > 0){
            //print_r($query->result());
            //exit();
            foreach($query->result() as $row){
                $proveedor=$this->mproveedor->getByNombre($row->proveedor,$row->idEmpresa);
                $this->mpresupuestomat->actualizar(["idProveedor"=>$proveedor["id"]],$row->id);
                $updates++;
            }
        }
        echo "$updates Registros Actualizados";
    }

    public function getOrdenesCompra($idEmpresa=0){
        $curl = curl_init();
        //INFORMACION A ENVIAR POR POST EN FORMATO JSON
        $datos=array('un' => $idEmpresa, 'bundle' => array('estatus' => 0));
        $datos = json_encode($datos);
        $time_start = microtime(true);

        curl_setopt_array($curl, array(
            CURLOPT_PORT => $this->port,
            CURLOPT_URL => $this->config->item('dnsmicro')."GetOrdenesCompra",
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => "",
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 3600,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => "POST",
            CURLOPT_SSL_VERIFYPEER => false,
            CURLOPT_FOLLOWLOCATION => 1,
            CURLOPT_POSTFIELDS => $datos,
            CURLOPT_HTTPHEADER => array(
                "cache-control: no-cache",
                "postman-token: ab5bf890-47c6-d504-ba8f-82667b58bebd",
                'Content-Type:application/json'
            ),
        ));
        $response = curl_exec($curl);
        $err = curl_error($curl);

        $json = [];
        if ($err) {
            echo "CURL Error #:" . $err;
        }else{
            $json = $response;
            // Comprueba el código de estado HTTP
            if (!curl_errno($curl)) {
                switch ($http_code = curl_getinfo($curl, CURLINFO_HTTP_CODE)) {
                    case 200:
                        $actualizados=0;
                        //Objeto de respuesta
                        $json = json_decode($json);
                        //Recorre objeto stdClass
                        foreach ($json->object_result as $row) {
                            $id_after=$row->id;
                            $folio=$row->folio;
                            $oc=$this->db->query("SELECT * FROM orden_compra WHERE folio LIKE '%$folio%' AND id != $id_after");
                            if($oc->num_rows() > 0){
                                $oc=$oc->row();
                                $id_before=$oc->id;
                                $this->db->query("UPDATE orden_compra SET id=$id_after WHERE id=$id_before");
                                $this->db->query("UPDATE detalle_orden SET id_orden_compra=$id_after WHERE id_orden_compra=$id_before");
                                $actualizados++;
                            }
                        }
                        echo $actualizados;
                        curl_close($curl);
                        break;
                    default:
                        break;
                }
            }
        }
    }


    public function importarcsv(){
        //file uploaded
        $file_path = $this->data['fotos_www']."proyectos.csv";
        if ($this->csvimport->get_array($file_path,'',TRUE)) {
            $csv_array = $this->csvimport->get_array($file_path);
            if (isset($csv_array[0])) {
                foreach ($csv_array as $value) { //recorremos el csv
                    if (isset($value['id']) && isset($value['contratista'])) {
                        if($value['contratista'] != ""){
                            echo $value['id']." - ".$value["contratista"]."<br>";
                            $data=[
                                "contratista" => $value['contratista']
                            ];
                            $this->mproyecto->actualizar($data,$value['id']);
                        }
                    }
                }
            }
        }
    }


public function estimaciones(){
        $idManoObra=1;
        $idPrototipo=6;
        $nEstimaciones=$this->mprototipos->getCampo("estimaciones",$idPrototipo);
        $estimaciones="";
        for ($i=1; $i <= $nEstimaciones; $i++) {
            if($i == 1){
                $estimaciones.=" (SELECT SUM(estimacion) FROM estimados WHERE idEstimaciones=$i AND idPresupuesto=ppto.id) estimacion".$i;
            }else{
                $estimaciones.=" ,(SELECT SUM(estimacion) FROM estimados WHERE idEstimaciones=$i AND idPresupuesto=ppto.id) estimacion".$i;
            }
        }
        $query='SELECT (SELECT descripcion FROM actividades_mo WHERE id=(SELECT idActividad FROM actividadesprototipo WHERE id=idActividadPrototipo)) descripcion,'.$estimaciones.'
        FROM presupuesto_mo ppto WHERE idManoObra='.$idManoObra;
        print($query);
    }

    public function _upload(){
        $config['upload_path'] = $this->data['fotos_www'];
        $config['allowed_types'] = 'csv';
        $config['max_size'] = '2000';

        $this->load->library('upload', $config);
        $file_data = $this->upload->data();
        $file_path = $this->data['fotos_www'].$file_data['file_name'];

        if ($this->csvimport->get_array($file_path,'',TRUE)) {
            $csv_array = $this->csvimport->get_array($file_path);

            $registros = array();
            if (isset($csv_array[0]['LOTE'])){
                foreach ($csv_array as $row) {
                    $costo=$row["COSTO"];
                    $lote=$row["LOTE"];
                    $manzana=$row["MANZANA"];
                    $nombreVialidad=$row["NOMBRE DE VIALIDAD"];
                    $this->db->query("UPDATE proyectos SET precioVenta=$costo WHERE lote=$lote AND manzana=$manzana AND idFraccionaimento=7;");
                }
            }
        }
        @unlink($file_path);

	}

    public function upload($id=0,$idFraccionamiento=null){
        $this->load->dbutil();
        $this->load->helper('download');
        $data['error']="";
        $data["fraccionamientos"]=$this->musuario->getFraccionamientos();
        $data['idFraccionamiento'] =($this->input->post('fraccionamiento', TRUE)=='')? $idFraccionamiento: $this->input->post('fraccionamiento', TRUE);

        if($id==1){
            $query = $this->mproyecto->getCSV($data['idFraccionamiento']);
            if (!is_numeric($query)){
                $csv = mb_convert_encoding($this->dbutil->csv_from_result($query, ",", "\n"), "ISO-8859-1", "UTF-8");
                $date=new DateTime();
                $name = "Inventario-".$date->format("d-m-Y").".csv";
                force_download($name, $csv);
            }else{
                //redirect('proyectos');
                $data['msgInvalid'] = "No existen registros para exportar";
            }
        }else if(isset($_FILES["foto"]) && $_SERVER['REQUEST_METHOD'] == 'POST'){
            $config['upload_path'] = $this->data['fotos_www'];
            $config['allowed_types'] = 'csv';
            $config['max_size'] = '2000';

            $this->load->library('upload', $config);
            // If upload failed, display error
            if (!$this->upload->do_upload("foto")) {
                $data['error'] = $this->upload->display_errors();
            }else {
                $file_data = $this->upload->data();
                $file_path = $this->data['fotos_www'].$file_data['file_name'];

                if ($this->csvimport->get_array($file_path,'',TRUE)) {
                    $csv_array = $this->csvimport->get_array($file_path);

                    $registros = array();
                    //if (isset($csv_array[0]['ID'])){
                    if (isset($csv_array[0]['LOTE'])){
                        foreach ($csv_array as $row) {
                            if($row["LOTE"] != ""){
                                $costo=$row["COSTO"];
                                $lote=$row["LOTE"];
                                $manzana=$row["MANZANA"];
                                $nombreVialidad=$row["NOMBRE DE VIALIDAD"];
                                $this->db->query("UPDATE proyectos SET precioVenta=$costo WHERE lote=$lote AND manzana=$manzana AND idFraccionamiento=7;");
                            }else{
                                $data['error'].="El registro con no se pudo insertar, debido a que no existe el nombre de asentamiento:".$row['NOMBRE DE ASENTAMIENTO']."<br>";
                            }
                        }
                    }
                    @unlink($file_path);
                } else{
                    $data['error'] = "Ocurrió un error";

                }
            }
        }
        $data['q'] = '';
        $this->data['contenido'] = $this->load->view($this->mainView.'/index_view',$data,true);
        $this->load->view('templates/main_template',$this->data);
    }

}