<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Rtecnica extends MX_Controller {
	public $data,$vParameters,$mainView,$fv;
	public function __construct(){
    $this->nsession = $this->config->item('nsession');
	if (!isset($_SESSION[$this->nsession]) || (($_SESSION[$this->nsession]['usuario'] == ""))) redirect('login');
            $this->fv = 'rtecnica'; // form validation variable
            $this->mainView = 'rtecnica';
            $this->data['fjs'] = '';
            $this->data['js'] = '
                    <script type="text/javascript" src="https://cdn.datatables.net/fixedheader/3.1.3/js/dataTables.fixedHeader.min.js"></script>
                    <script src="assets/js/rtecnica/listado.js" type="text/javascript"></script>';
            $this->data['css'] = '<link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/1.10.16/css/jquery.dataTables.min.css">
                                  <link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/fixedheader/3.1.3/css/fixedHeader.dataTables.min.css">';
            // Tools
            $this->load->helper(array('tools','numeros','url','form','date','text','security'));
            // Modelos
            $this->load->model(array('mproyecto','mfraccionamiento','mprototipoxfraccionamiento','maltaventa','musuario','mfraccionamientoxusuario','mprototipos'));

            // Lbrerias
            $this->load->library('csvimport');
            // $this->load->library(array('email','session'));
            // $this->data['fotos_www'] = $this->config->item('base_www').'/inicio/';

           // Debugging
            $this->output->enable_profiler(false);

           //Validación de usuarios
	        valSession("ventas",$this->fv);
    }

	public function index()
	{
		$data['q'] = '';
        $data["fraccionamientos"]=$this->musuario->getFraccionamientos();
        $data['prototipos'] = $this->mprototipoxfraccionamiento->getAll();
        $data['prototipos_'] = $this->mprototipos->getAll();
        $this->data['contenido'] = $this->load->view($this->mainView.'/index_view',$data,true);
        $this->load->view('templates/main_template',$this->data);
	}

    public function getTotal($info){
        $info=explode("_", $info);
        $r['idPrototipo'] = $info[0];
        $r['statusProyecto'] = $info[1];
        $r['fecha_inicio'] = $info[2];
        $r['fecha_fin'] = $info[3];
        $r['lineaCredito'] = $info[4];
        $r['fraccionamiento'] = $info[5];

        $total = $this->mproyecto->inventarioTecnica($r,"",true);
        echo json_encode($total);
    }

    public function listado(){

        $r['idPrototipo'] = $_REQUEST['idPrototipo'];
        $r['statusProyecto'] = $_REQUEST['statusProyecto'];
        $r['fecha_inicio'] = $_REQUEST['fecha_inicio'];
        $r['fecha_fin'] = $_REQUEST['fecha_fin'];
        $r['lineaCredito'] = $_REQUEST['lineaCredito'];
        $r['fraccionamiento'] = $_REQUEST['fraccionamiento'];

        //$q = $this->mproyecto->getAll();
        $q = $this->mproyecto->inventarioTecnica($r);

        if (!is_numeric($q)){
            foreach ($q->result() as $row){
                $array['aaData'][] = array(
                    'fracc' => $this->mfraccionamiento->getCampo('titulo',$row->idFraccionamiento),//$row->FRACCIONAMIENTO,
                    'titulo' => '<a href="proyectos/ver/'.$row->id.'">'.$row->lote.'</a>',
                    'manzana' => $row->manzana,
                    'nOficial' => $row->nOficial,
                    'calle' => $row->calle,
                    'numPaquete' => $row->numPaquete,
                    'cuv' => $row->cuv,
                    'claveCatastral' => $row->claveCatastral,
                    'supTerreno' => $row->supTerreno,
                    'supConstruccion' => $row->supConstruccion,
                    // 'prototipo' => $this->mprototipoxfraccionamiento->getCampo("titulo",$row->idPrototipo),
                    'prototipo' => $this->mprototipos->getCampo("nombre",$row->idPrototipo),
                    'precioVenta' => ($row->precioVenta != "") ? "<div style='text-align:right;margin-right:9px;'>$".number_format($row->precioVenta,2)."</div>" : "",
                    'puntaje' => $row->puntaje,
                    'statusProyecto' => $row->statusProyecto,
                    'porcentajeAvance' => $row->porcentajeAvance,
                    'fechaDtu' => $row->fechaDtu,
                    'fechaVencimiento' => $row->fechaVencimiento,
                    'contratista' => $row->contratista,
                    'avaluo' => precio_format($row->avaluo),
                    'unidadVerificadora' => $row->unidadVerificadora,
                    'lineaCredito' => $row->lineaCredito
                    );
            }
        } else{
            $array['aaData'][] = array(
                'fracc' => 'No hay registros',
                'titulo' => 'No hay registros',
                'manzana' => 'No hay registros',
                'nOficial' => 'No hay registros',
                'calle' => 'No hay registros',
                'numPaquete' => 'No hay registros',
                'cuv' => 'No hay registros',
                'claveCatastral' => 'No hay registros',
                'supTerreno' => 'No hay registros',
                'supConstruccion' => 'No hay registros',
                'prototipo' => 'No hay registros',
                'precioVenta' => 'No hay registros',
                'puntaje' => 'No hay registros',
                'statusProyecto' => 'No hay registros',
                'porcentajeAvance' => 'No hay registros',
                'fechaDtu' => 'No hay registros',
                'fechaVencimiento' => 'No hay registros',
                'contratista' => 'No hay registros',
                'avaluo' => 'No hay registros',
                'unidadVerificadora' => 'No hay registros',
                'lineaCredito' => 'No hay registros'
                );

        }

        echo json_encode($array);
    }


    function formatoCSV($info){
        $this->load->dbutil();
        $this->load->helper('download');

        $info=explode("_", $info);

        $r['idPrototipo'] = $info[0];
        $r['statusProyecto'] = $info[1];
        $r['fecha_inicio'] = $info[2];
        $r['fecha_fin'] = $info[3];
        $r['lineaCredito'] = $info[4];
        $r['fraccionamiento'] = $info[5];

        //print_r($r);exit();

        $q = $this->mproyecto->inventarioTecnica($r,'csv');
        if(!is_numeric($q)){
            $csv = mb_convert_encoding($this->dbutil->csv_from_result($q, ",", "\n"), "ISO-8859-1", "UTF-8");
            $date=new DateTime();
            $name = "reporte ".$date->format("d-m-Y").".csv";
            force_download($name, $csv);
        }
    }


}
