<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class rsemana extends MX_Controller {
    public $data,$vParameters,$mainView,$fv;
	public function __construct(){
    $this->nsession = $this->config->item('nsession');
	if (!isset($_SESSION[$this->nsession]) || (($_SESSION[$this->nsession]['usuario'] == ""))) redirect('login');
            $this->fv = 'rsemana'; // form validation variable
            $this->mainView = 'rsemana';
            $this->data['fjs'] = '';
            $this->data['js'] = '';
            $this->data['css'] = '';
            // Tools
            $this->load->helper(array('tools','numeros','url','form','date','text','security'));
            // Modelos
            $this->load->model(array('mpaquete', 'musuario', 'mfraccionamiento','mprototipos','mconstructores', 'mmanoobra', 'mmaterial', 'mpresupuestomat', 
            'mmaterialesactividadprototipo', 'mmateriales', 'mproveedor', 'mdetallepaquete', 'mempresas', 'marranque','mordencompra'));

            // Lbrerias
            $this->load->library('csvimport');

           // Debugging
            $this->output->enable_profiler(false);

           //Validación de usuarios
           $this->config->set_item('rol',$_SESSION[$this->nsession]['rol']);
            valSession("materiales",$this->fv);
    }

	public function index()
	{
        $texto = '';
        if( isset($_SESSION['mensaje'])){
            $texto = $_SESSION['mensaje'];
            unset($_SESSION['mensaje']);
        }
        $data['texto'] = $texto;
        $ids = array();
        $qArranque = $this->marranque->getAllByEstatusNoPendiente();
        if( !is_numeric($qArranque) ){
            foreach($qArranque->result() as $arranque){
                $temp = explode(',', $arranque->idPaquetes);
                if( !empty($temp[0]) ){
                    foreach($temp as $v){
                        if( !in_array($v, $ids, true) && is_numeric($v)){
                            $ids[] = $v;
                        }
                    }
                }
            }
        }
        $data['paquetes'] = ( empty($ids) )? 0 : $this->mpaquete->getSelectResultInIds($ids);
        $this->data['contenido'] = $this->load->view($this->mainView.'/index_view',$data,true);
        $this->load->view('templates/main_template',$this->data);
	}

    public function exportar($idPaquete = 0)
    {
        $letras = array('A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z');
        $this->load->library('excel');
        $objPHPExcel = new PhpOffice\PhpSpreadsheet\Spreadsheet();
        $objPHPExcel->getActiveSheet()->setTitle('Por semana');
        $objPHPExcel->setActiveSheetIndex(0);

        $objPHPExcel->getActiveSheet()->mergeCells('A1:B7');

        $gdImage = imagecreatefromjpeg(base_url() . '/img/bg1.jpg');
        // Add a drawing to the worksheetecho date('H:i:s') . " Add a drawing to the worksheet\n";
        $objDrawing = new PhpOffice\PhpSpreadsheet\Worksheet\MemoryDrawing();
        $objDrawing->setName('Logo Vviend');
        $objDrawing->setDescription('Logo Viviend');
        $objDrawing->setImageResource($gdImage);
        $objDrawing->setRenderingFunction(PhpOffice\PhpSpreadsheet\Worksheet\MemoryDrawing::RENDERING_JPEG);
        $objDrawing->setMimeType(PhpOffice\PhpSpreadsheet\Worksheet\MemoryDrawing::MIMETYPE_DEFAULT);
        $objDrawing->setOffsetX(150);
        $objDrawing->setOffsetY(0);
        $objDrawing->setWidth(900);
        $objDrawing->setHeight(140);
        $objDrawing->setCoordinates('A1');
        $objDrawing->setWorksheet($objPHPExcel->getActiveSheet());

        $objPHPExcel->getActiveSheet()->SetCellValue('C2', 'FRACCIONAMIENTO:');
        $objPHPExcel->getActiveSheet()->SetCellValue('C3', 'PROTOTIPO:');
        $objPHPExcel->getActiveSheet()->SetCellValue('C4', 'PRESUPUESTO:');
        $objPHPExcel->getActiveSheet()->SetCellValue('C5', 'PPTO. UNITARIO:');
        // DATOS TRAIDOS DEL PAQUETE INICIO
        $objPHPExcel->getActiveSheet()->SetCellValue('D2', 'VARIABLE');
        $objPHPExcel->getActiveSheet()->SetCellValue('D3', 'VARIABLE');
        $objPHPExcel->getActiveSheet()->SetCellValue('D4', 'VARIABLE');
        $objPHPExcel->getActiveSheet()->SetCellValue('D5', 'VARIABLE');
        // DATOS TRAIDOS DEL PAQUETE FIN
        
        $objPHPExcel->getActiveSheet()->SetCellValue('A10', 'clave');
        $objPHPExcel->getActiveSheet()->SetCellValue('B10', 'área');
        $objPHPExcel->getActiveSheet()->SetCellValue('C10', 'proveedor');
        $objPHPExcel->getActiveSheet()->SetCellValue('D10', 'descripción');
        $objPHPExcel->getActiveSheet()->SetCellValue('E10', 'unidad');
        $objPHPExcel->getActiveSheet()->SetCellValue('F10', 'cant_total');

        $nletra = 6; //posicion de la letra en el array de letras 6 = G
        $base = ''; // por si llegara a pasarse de las 1as 26 columnas (A - Z)
        //Este for es solo para simular las semanas que serían dinamicas, cuando ya usen los registros se borra
        for ($i = 1; $i <= 5; $i++) { 
            $registro[] = $i;
        }
        // para revisar los registros de las semanas
        foreach($registro as $reg){
            //Si esta entre A a Z  en la letra actual
            if( $nletra < 26){
                $campo[$reg] = $base.$letras[$nletra];
                $objPHPExcel->getActiveSheet()->SetCellValue($campo[$reg].'10', 'sem'.$reg);
                $nletra++;
            }
            else{
                //Si ya llego a Z, se debe reiniciar y agregar la 1a letra (para llegar a AA, BA, CE, si llegara a pasarse)
                // nbase para saber que campo del array ocupa la 1a letra
                $nbase = (strlen($base) == 0 || array_search($base.'10',$letras,true) === false )? 0 : array_search($base,$letras,true) + 1;
                $base = $letras[$nbase];
                $nletra = 1; 
                $campo[$reg] = $base.$letras[0];
                $objPHPExcel->getActiveSheet()->SetCellValue($campo[$reg].'10', 'sem'.$reg);
            }
        }

        // Campo despues de semana [si es que hay]
        if( $nletra < 26){
            $c_total = $base.$letras[$nletra];
            $objPHPExcel->getActiveSheet()->SetCellValue($c_total.'10', 'ultimo :V');
        }
        else{
            $nbase = (strlen($base) == 0 || array_search($base,$letras,true) === false )? 0 : array_search($base,$letras,true) + 1;
            $base = $letras[$nbase];
            $c_total = $base.$letras[0];
            $objPHPExcel->getActiveSheet()->SetCellValue($c_total.'10', 'ultimo :V');
        }
        
        //A partir de que row empieza a escribir
        $rowCount = 11;

        //Aqui iria codigo dinamico, cuando haya

        // Formatos
        $objPHPExcel->getActiveSheet()->getStyle('A1:X'.$rowCount)->getFont()->setName('Arial')->setSize(10);
        
        $objPHPExcel->getActiveSheet()->getStyle('D2:D5')->applyFromArray(
            array('fill' => array(
                'fillType' => PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID,
                'color' => array('rgb' => 'FFE699')
            ))
        );

        //Tamaño de la columnas
        $objPHPExcel->getActiveSheet()->getColumnDimension('C')->setWidth(30);
        $objPHPExcel->getActiveSheet()->getColumnDimension('D')->setWidth(30);

        $name = 'nombre paquete ';
        header('Content-Type: application/vnd.ms-excel');
        header('Content-Disposition: attachment;filename="' . $name . '(' . date('d-m-Y') . ').xls"');
        header('Cache-Control: max-age=0'); //no cache
        $objWriter = PhpOffice\PhpSpreadsheet\IOFactory::createWriter($objPHPExcel, 'Xls');
        // Forzamos a la descarga
        $objWriter->save('php://output');
    }
    
    public function exportarMateriale3($idPaquete = 0)
    {
        $this->load->library('excel');
        if($idPaquete == 0){
            $idPaquete = $_POST['idPaquete'];
        }
        $paquete = $this->mpaquete->getById($idPaquete);
        if(!is_numeric($paquete)){
            $getInfo = $this->getInfoVer($paquete['id']);
            $material = $this->mmaterial->getByIdPaquete($paquete['id']);
            //
            $manoObra = $this->mmanoobra->getById($paquete['idManoObra']);
            $fraccionamiento = (!is_numeric($manoObra)) ? $this->mfraccionamiento->getCampo2('titulo', $manoObra['idFraccionamiento']) : '';
            $prototipo = (!is_numeric($manoObra)) ? $this->mprototipos->getCampo2('nombre', $manoObra['idPrototipo']) : '';
            $paqueteLotes = 0;
            $paqueteLotes = contarLotesManzanas($paquete['rango_lotes']);
            $lotes = $paqueteLotes['lotes'];
            $manzanas=implode(", ",array_keys($paqueteLotes["arrayMzs"]));
            $paqueteLotes = $paqueteLotes['total'];
            $constructorNombre = $this->mconstructores->getCampo2('nombre', $paquete['idConstructor']);
            $constructorApellidoP = $this->mconstructores->getCampo2('apellidoP', $paquete['idConstructor']);
            $constructorApellidoM = $this->mconstructores->getCampo2('apellidoM', $paquete['idConstructor']);
            $constructor = $constructorNombre . ' ' . $constructorApellidoP . ' ' . $constructorApellidoM;
            $totalViviendas = $paqueteLotes;
            $qTotalPresupuestoMO = $this->db->query("SELECT SUM(importe) as totalImporte FROM presupuesto_mo WHERE idManoObra = ".$manoObra['id']);
            $presupuestoUnit = ($qTotalPresupuestoMO->row()->totalImporte != '') ? $qTotalPresupuestoMO->row()->totalImporte : 0;
            $totalContrato = $presupuestoUnit * $paqueteLotes;
            $fechaInicio = date_format(date_create($paquete['fecha_inicio']), 'd-m-Y');
            $fechaFin = date_format(date_create($paquete['fecha_fin']), 'd-m-Y');
            $empty = true;
            $arrayPresupuestoMAT = array();
            $countArray = 0;

            if(!is_numeric($material)){
                $semanas = $this->db->query('SELECT p.semana AS id, p.semana AS titulo FROM material AS m INNER JOIN presupuesto_mat AS p ON m.id = p.idMaterial
                        INNER JOIN paquetes pa ON m.idPaquete = pa.id INNER JOIN mano_obra AS mo ON pa.idManoObra = mo.id WHERE pa.id = '. $idPaquete . '
                        GROUP BY p.semana ORDER BY p.semana ASC;');

                if($semanas->num_rows() > 0){
                    foreach($semanas->result() as $r){
                        $presupuestoMat = $this->mpresupuestomat->getByIdMaterial($material['id'], $r->id);
                        if(!is_numeric($presupuestoMat)){
                            $empty = false;
                            foreach($presupuestoMat->result() as $row){
                                $materialActividadPrototipo = $this->mmaterialesactividadprototipo->getById($row->idMateriales);
                                $materiales = $this->mmateriales->getById2($materialActividadPrototipo['idMaterial']);
                                $proveedores = $this->mproveedor->getById($row->idProveedor);

                                if(!array_key_exists($row->semana, $arrayPresupuestoMAT)){
                                    $arrayPresupuestoMAT[$row->semana][0] = array(
                                                                            'clave' => $materiales['clave'],
                                                                            'area' => $materiales['linea_art'],
                                                                            'proveedor' => (!is_numeric($proveedores)) ? $proveedores['nombre'] : '',
                                                                            'semana' => $row->semana,
                                                                            'descripcion' => $materiales['nombre'],
                                                                            'unidadMedida' => $materiales['unidad_compra'],
                                                                            'cantidadViv' => $materialActividadPrototipo['cantidad'],
                                                                            'cantidadTotal' => $materialActividadPrototipo['cantidad'] * $totalViviendas,
                                                                            'precioSinIva' => $row->precioUnitario - ($row->precioUnitario * 0.16),
                                                                            'precioNeto' => $row->precioUnitario,
                                                                            'totalPorViv' => $materialActividadPrototipo['cantidad'] * $row->precioUnitario,
                                                                            'total' => ($materialActividadPrototipo['cantidad'] * $totalViviendas) * $row->precioUnitario,
                                                                        );
                                }else{
                                    $array = array(
                                                'clave' => $materiales['clave'],
                                                'area' => $materiales['linea_art'],
                                                'proveedor' => (!is_numeric($proveedores)) ? $proveedores['nombre'] : '',
                                                'semana' => $row->semana,
                                                'descripcion' => $materiales['nombre'],
                                                'unidadMedida' => $materiales['unidad_compra'],
                                                'cantidadViv' => $materialActividadPrototipo['cantidad'],
                                                'cantidadTotal' => $materialActividadPrototipo['cantidad'] * $totalViviendas,
                                                'precioSinIva' => $row->precioUnitario - ($row->precioUnitario * 0.16),
                                                'precioNeto' => $row->precioUnitario,
                                                'totalPorViv' => $materialActividadPrototipo['cantidad'] * $row->precioUnitario,
                                                'total' => ($materialActividadPrototipo['cantidad'] * $totalViviendas) * $row->precioUnitario,
                                            );
                                    array_push($arrayPresupuestoMAT[$row->semana], $array);
                                }
                            }
                        }
                    }
                }
            }

            if(!$empty){
                if(count($arrayPresupuestoMAT) > 0){
                    $objPHPExcel = new PhpOffice\PhpSpreadsheet\Spreadsheet();
                    $objPHPExcel->getActiveSheet()->setTitle('PRESUPUESTO MATERIALES PAQUETE');
                    $objPHPExcel->setActiveSheetIndex(0);

                    $objPHPExcel->getActiveSheet()->mergeCells('A1:B7');

                    $gdImage = imagecreatefromjpeg(base_url() . '/img/bg1.jpg');
                    // Add a drawing to the worksheetecho date('H:i:s') . " Add a drawing to the worksheet\n";
                    $objDrawing = new PhpOffice\PhpSpreadsheet\Worksheet\MemoryDrawing();
                    $objDrawing->setName('Logo Vviend');
                    $objDrawing->setDescription('Logo Viviend');
                    $objDrawing->setImageResource($gdImage);
                    $objDrawing->setRenderingFunction(PhpOffice\PhpSpreadsheet\Worksheet\MemoryDrawing::RENDERING_JPEG);
                    $objDrawing->setMimeType(PhpOffice\PhpSpreadsheet\Worksheet\MemoryDrawing::MIMETYPE_DEFAULT);
                    $objDrawing->setOffsetX(150);
                    $objDrawing->setOffsetY(0);
                    $objDrawing->setWidth(900);
                    $objDrawing->setHeight(140);
                    $objDrawing->setCoordinates('A1');
                    $objDrawing->setWorksheet($objPHPExcel->getActiveSheet());

                    $objPHPExcel->getActiveSheet()->getStyle('B9:B12')->applyFromArray(
                        array('fill' => array(
                            'fillType' => PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID,
                            'color' => array('rgb' => 'FFE699')
                        ))
                    );

                    $objPHPExcel->getActiveSheet()->getStyle('D9:D12')->applyFromArray(
                        array('fill' => array(
                            'fillType' => PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID,
                            'color' => array('rgb' => 'FFE699')
                        ))
                    );

                    $objPHPExcel->getActiveSheet()->getStyle('G9:G12')->applyFromArray(
                        array('fill' => array(
                            'fillType' => PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID,
                            'color' => array('rgb' => 'FFE699')
                        ))
                    );

                    $objPHPExcel->getActiveSheet()->getStyle('J9:J12')->applyFromArray(
                        array('fill' => array(
                            'fillType' => PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID,
                            'color' => array('rgb' => 'FFE699')
                        ))
                    );

                    $objPHPExcel->getActiveSheet()->SetCellValue('A9', 'FRACCIONAMIENTO:');
                    $objPHPExcel->getActiveSheet()->SetCellValue('B9', $fraccionamiento);

                    $objPHPExcel->getActiveSheet()->SetCellValue('A10', 'PROTOTIPO:');
                    $objPHPExcel->getActiveSheet()->SetCellValue('B10', $prototipo);

                    $objPHPExcel->getActiveSheet()->SetCellValue('A11', 'CONTRATISTA:');
                    $objPHPExcel->getActiveSheet()->SetCellValue('B11', $constructor);

                    $objPHPExcel->getActiveSheet()->SetCellValue('A12', 'NO. DE VIV:');
                    $objPHPExcel->getActiveSheet()->SetCellValue('B12', $totalViviendas);
                    $objPHPExcel->getActiveSheet()->getStyle('B12')->getAlignment()->setHorizontal(PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_LEFT);
                    //

                    $objPHPExcel->getActiveSheet()->SetCellValue('C9', 'MANZANAS');
                    $objPHPExcel->getActiveSheet()->SetCellValue('D9', $manzanas);

                    $objPHPExcel->getActiveSheet()->SetCellValue('C10', 'LOTES:');
                    $objPHPExcel->getActiveSheet()->SetCellValue('D10', $lotes);

                    $objPHPExcel->getActiveSheet()->SetCellValue('C11', 'PRESUPUESTO UNIT.:');
                    $objPHPExcel->getActiveSheet()->SetCellValue('D11', precio_format($presupuestoUnit));

                    $objPHPExcel->getActiveSheet()->SetCellValue('C12', 'TOTAL CONTRATO:');
                    $objPHPExcel->getActiveSheet()->SetCellValue('D12', precio_format($totalContrato));

                    //

                    $objPHPExcel->getActiveSheet()->mergeCells('E9:F9');
                    $objPHPExcel->getActiveSheet()->SetCellValue('E9', 'INICIO PROGRAMADO:');
                    $objPHPExcel->getActiveSheet()->SetCellValue('G9', $fechaInicio);

                    $objPHPExcel->getActiveSheet()->mergeCells('E10:F10');
                    $objPHPExcel->getActiveSheet()->SetCellValue('E10', 'TERMINO PROGRAMADO:');
                    $objPHPExcel->getActiveSheet()->SetCellValue('G10', $fechaFin);

                    $objPHPExcel->getActiveSheet()->mergeCells('E11:F11');
                    $objPHPExcel->getActiveSheet()->SetCellValue('E11', 'INICIO REAL:');
                    $objPHPExcel->getActiveSheet()->SetCellValue('G11', '');

                    $objPHPExcel->getActiveSheet()->mergeCells('E12:F12');
                    $objPHPExcel->getActiveSheet()->SetCellValue('E12', 'TERMINO REAL:');
                    $objPHPExcel->getActiveSheet()->SetCellValue('G12', '');

                    $objPHPExcel->getActiveSheet()->mergeCells('H9:I9');
                    $objPHPExcel->getActiveSheet()->SetCellValue('H9', 'ALMACEN:');
                    $objPHPExcel->getActiveSheet()->SetCellValue('J9', $paquete['titulo']);

                    $objPHPExcel->getActiveSheet()->mergeCells('H10:I10');
                    $objPHPExcel->getActiveSheet()->SetCellValue('H10', 'COSTO X M2:');
                    $objPHPExcel->getActiveSheet()->SetCellValue('J10', (!is_numeric($getInfo)) ? $getInfo['costoM2'] : '');

                    $objPHPExcel->getActiveSheet()->mergeCells('H11:I11');
                    $objPHPExcel->getActiveSheet()->SetCellValue('H11', 'M2 X VIVIENDA:');
                    $objPHPExcel->getActiveSheet()->SetCellValue('J11', (!is_numeric($getInfo)) ? $getInfo['m2Viv'] : '');

                    $objPHPExcel->getActiveSheet()->SetCellValue('A13', 'CLAVE');
                    $objPHPExcel->getActiveSheet()->SetCellValue('B13', 'AREA');
                    $objPHPExcel->getActiveSheet()->SetCellValue('C13', 'PROVEEDOR');
                    $objPHPExcel->getActiveSheet()->SetCellValue('D13', 'SEM');
                    $objPHPExcel->getActiveSheet()->SetCellValue('E13', 'DESCRIPCION');
                    $objPHPExcel->getActiveSheet()->SetCellValue('F13', 'U.M');
                    $objPHPExcel->getActiveSheet()->SetCellValue('G13', 'CANTIDAD POR VIV');
                    $objPHPExcel->getActiveSheet()->SetCellValue('H13', 'TOTAL');
                    $objPHPExcel->getActiveSheet()->SetCellValue('I13', 'PRECIO SIN IVA');
                    $objPHPExcel->getActiveSheet()->SetCellValue('J13', 'PRECIO NETO');
                    $objPHPExcel->getActiveSheet()->SetCellValue('K13', 'TOTAL POR VIV');
                    $objPHPExcel->getActiveSheet()->SetCellValue('L13', 'TOTAL');

                    $rowCount = 14;
                    $rowCountInicial = 14;
                    $rowCountFinal = 0;
                    $letraSemana = "N";
                    $arrayTotales = array(); 
                    $arrayTotal = array();
                    $totalSemana = 0; 
                    foreach($arrayPresupuestoMAT as $k=>$v){

                        $objPHPExcel->getActiveSheet()->SetCellValue($letraSemana.'13', 'SEMANA '.$k);

                        $objPHPExcel->getActiveSheet()->getColumnDimension($letraSemana)->setWidth(15);

                        $rowInicial = $rowCount;

                        foreach($arrayPresupuestoMAT[$k] as $row){
                            $objPHPExcel->getActiveSheet()->SetCellValue('A'.$rowCount, $row['clave']);
                            $objPHPExcel->getActiveSheet()->SetCellValue('B'.$rowCount, $row['area']);
                            $objPHPExcel->getActiveSheet()->SetCellValue('C'.$rowCount, $row['proveedor']);
                            $objPHPExcel->getActiveSheet()->SetCellValue('D'.$rowCount, $row['semana']);
                            $objPHPExcel->getActiveSheet()->SetCellValue('E'.$rowCount, $row['descripcion']);
                            $objPHPExcel->getActiveSheet()->SetCellValue('F'.$rowCount, $row['unidadMedida']);
                            $objPHPExcel->getActiveSheet()->SetCellValue('G'.$rowCount, $row['cantidadViv']);
                            $objPHPExcel->getActiveSheet()->SetCellValue('H'.$rowCount, $row['cantidadTotal']);
                            $objPHPExcel->getActiveSheet()->SetCellValue('I'.$rowCount, precio_format($row['precioSinIva']));
                            $objPHPExcel->getActiveSheet()->SetCellValue('J'.$rowCount, precio_format($row['precioNeto']));
                            $objPHPExcel->getActiveSheet()->SetCellValue('K'.$rowCount, precio_format($row['totalPorViv']));
                            $objPHPExcel->getActiveSheet()->SetCellValue('L'.$rowCount, precio_format($row['total']));

                            $objPHPExcel->getActiveSheet()->SetCellValue($letraSemana.$rowCount, precio_format($row['total']));

                            $totalSemana = $totalSemana + $row['total'];

                            $arrayTotal[$rowCount] = array('total' => $row['total']);
                            $arrayTotales[$k] = array('letra' => $letraSemana, 'rowInicial' => $rowInicial, 'rowFinal' => $rowCount, 'total' => $totalSemana);

                            $rowCount++;
                        }

                        $letraSemana++;
                    }

                    $objPHPExcel->getActiveSheet()->SetCellValue($letraSemana.'13', 'TOTAL');
                    $objPHPExcel->getActiveSheet()->getColumnDimension($letraSemana)->setWidth(15);

                    $rowC = 0;
                    $totalC = 0;
                    foreach($arrayTotal as $k=>$v){
                        $rowC = $k;
                        $tot = $v['total'];
                        $totalC = $totalC + $tot;
                        $objPHPExcel->getActiveSheet()->SetCellValue($letraSemana.$k, precio_format($tot));

                        $styleArray = array(
                            'borders' => array(
                                'allBorders' => array(
                                    'borderStyle' => PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN
                                )
                            )
                        );

                        $objPHPExcel->getActiveSheet()->getStyle(
                            $letraSemana.$k.':'.$letraSemana.$k
                        )->applyFromArray($styleArray);
                    }

                    $rowC++;

                    $objPHPExcel->getActiveSheet()->SetCellValue($letraSemana.$rowC, precio_format($totalC));

                    $styleArray = array(
                        'borders' => array(
                            'allBorders' => array(
                                'borderStyle' => PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN
                            )
                        )
                    );

                    $objPHPExcel->getActiveSheet()->getStyle(
                        $letraSemana.'13:'.$letraSemana.$rowC
                    )->applyFromArray($styleArray);

                    //

                    $rowCount = $rowCount - 1;

                    $rowCountFinal = $rowCount;

                    foreach($arrayPresupuestoMAT as $key=>$val){
                        $rInicio = $rowCountInicial;
                        $rFinal = $rowCountFinal;
                        $letra = $arrayTotales[$key]['letra'];
                        $inicio = $arrayTotales[$key]['rowInicial'];
                        $final = $arrayTotales[$key]['rowFinal'];
                        $total = $arrayTotales[$key]['total'];

                        for ($rInicio; $rInicio <= $rFinal; $rInicio++) { 
                            if($rInicio >= $inicio && $rInicio <= $final){

                            }else{
                                $objPHPExcel->getActiveSheet()->SetCellValue($letra.$rInicio, precio_format(0));
                            }

                        }

                        
                        $objPHPExcel->getActiveSheet()->SetCellValue($letra.$rInicio, precio_format($total));

                        $rInicio++;

                        $objPHPExcel->getActiveSheet()->SetCellValue($letra.$rInicio, $total / $totalC);

                        $objPHPExcel->getActiveSheet()->getStyle($letra.$rInicio)
                            ->getNumberFormat()->applyFromArray( 
                            array( 
                                'code' => PhpOffice\PhpSpreadsheet\Style\NumberFormat::FORMAT_PERCENTAGE_00
                            )
                        );
                        
                        $styleArray = array(
                            'borders' => array(
                                'allBorders' => array(
                                    'borderStyle' => PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN
                                )
                            )
                        );

                        $objPHPExcel->getActiveSheet()->getStyle(
                            $letra.'13:'.$letra.$rInicio
                        )->applyFromArray($styleArray);
                    }

                    //

                    $styleArray = array(
                        'borders' => array(
                            'allBorders' => array(
                                'borderStyle' => PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN
                            )
                        )
                    );

                    $objPHPExcel->getActiveSheet()->getStyle(
                        'A13:L' . $rowCount
                    )->applyFromArray($styleArray);
                    

                    $objPHPExcel->getActiveSheet()->getColumnDimension('A')->setWidth(15);
                    $objPHPExcel->getActiveSheet()->getColumnDimension('B')->setWidth(25);
                    $objPHPExcel->getActiveSheet()->getColumnDimension('C')->setWidth(30);
                    $objPHPExcel->getActiveSheet()->getColumnDimension('D')->setWidth(35);
                    $objPHPExcel->getActiveSheet()->getColumnDimension('E')->setWidth(40);
                    $objPHPExcel->getActiveSheet()->getColumnDimension('F')->setWidth(10);
                    $objPHPExcel->getActiveSheet()->getColumnDimension('G')->setWidth(15);
                    $objPHPExcel->getActiveSheet()->getColumnDimension('H')->setWidth(15);
                    $objPHPExcel->getActiveSheet()->getColumnDimension('I')->setWidth(15);
                    $objPHPExcel->getActiveSheet()->getColumnDimension('J')->setWidth(15);
                    $objPHPExcel->getActiveSheet()->getColumnDimension('K')->setWidth(15);
                    $objPHPExcel->getActiveSheet()->getColumnDimension('L')->setWidth(15);

                    $name = $paquete["id"].".".$paquete["titulo"];
                    header('Content-Type: application/vnd.ms-excel');
                    header('Content-Disposition: attachment;filename="' . $name . '(' . date('d-m-Y') . ').xls"');
                    header('Cache-Control: max-age=0'); //no cache
                    $objWriter = PhpOffice\PhpSpreadsheet\IOFactory::createWriter($objPHPExcel, 'Xls');
                    // Forzamos a la descarga
                    $objWriter->save('php://output');
                }
            }
            else{
                $_SESSION['mensaje'] = 'Este paquete no tiene ningún presupuesto asociado.';
            }
        }
        else{
            $_SESSION['mensaje'] = 'No se encontro el paquete.';
        }
        redirect('rsemana');
    }

    public function exportarMateriales2($idPaquete = 0)
    {
        $this->load->library('excel');
        if($idPaquete == 0){
            $idPaquete = $_POST['idPaquete'];
        }
        $paquete = $this->mpaquete->getById($idPaquete);
        if(!is_numeric($paquete)){
            $getInfo = $this->getInfoVer($paquete['id']);
            $material = $this->mmaterial->getByIdPaquete($paquete['id']);
            //
            $manoObra = $this->mmanoobra->getById($paquete['idManoObra']);
            $fraccionamiento = (!is_numeric($manoObra)) ? $this->mfraccionamiento->getCampo2('titulo', $manoObra['idFraccionamiento']) : '';
            $prototipo = (!is_numeric($manoObra)) ? $this->mprototipos->getCampo2('nombre', $manoObra['idPrototipo']) : '';
            $paqueteLotes = 0;
            $paqueteLotes = contarLotesManzanas($paquete['rango_lotes']);
            $lotes = $paqueteLotes['lotes'];
            $manzanas=implode(", ",array_keys($paqueteLotes["arrayMzs"]));
            $paqueteLotes = $paqueteLotes['total'];
            $constructorNombre = $this->mconstructores->getCampo2('nombre', $paquete['idConstructor']);
            $constructorApellidoP = $this->mconstructores->getCampo2('apellidoP', $paquete['idConstructor']);
            $constructorApellidoM = $this->mconstructores->getCampo2('apellidoM', $paquete['idConstructor']);
            $constructor = $constructorNombre . ' ' . $constructorApellidoP . ' ' . $constructorApellidoM;
            $totalViviendas = $paqueteLotes;
            $qTotalPresupuestoMO = $this->db->query("SELECT SUM(importe) as totalImporte FROM presupuesto_mo WHERE idManoObra = ".$manoObra['id']);
            $presupuestoUnit = ($qTotalPresupuestoMO->row()->totalImporte != '') ? $qTotalPresupuestoMO->row()->totalImporte : 0;
            $totalContrato = $presupuestoUnit * $paqueteLotes;
            $fechaInicio = date_format(date_create($paquete['fecha_inicio']), 'd-m-Y');
            $fechaFin = date_format(date_create($paquete['fecha_fin']), 'd-m-Y');
            $empty = true;
            $arrayPresupuestoMAT = array();
            $countArray = 0;

            if(!is_numeric($material)){
                $semanas = $this->db->query('SELECT o.semana AS id, o.semana AS titulo FROM orden_compra AS o 
                                            INNER JOIN recepcion AS r ON r.id_orden_compra = o.id 
                                            INNER JOIN paquetes pa ON o.idPaquete = pa.id 
                                            WHERE pa.id = '. $idPaquete . ' GROUP BY o.semana ORDER BY o.semana ASC;');

                if($semanas->num_rows() > 0){
                    foreach($semanas->result() as $r){
                        //$presupuestoMat = $this->mpresupuestomat->getByIdMaterial($material['id'], $r->id);
                        $presupuestoMat = $this->db->query('SELECT dr.*, r.id_proveedor, r.id_almacen, o.semana FROM orden_compra AS o 
                                                            INNER JOIN recepcion AS r ON o.id = r.id_orden_compra 
                                                            INNER JOIN detalle_recepcion AS dr ON r.id = dr.id_recepcion 
                                                            WHERE o.idMaterial = '.$material['id'].' AND o.semana = '.$r->id.';');
                        if($presupuestoMat->num_rows() > 0){
                            $empty = false;
                            foreach($presupuestoMat->result() as $row){
                                $materiales = $this->mmateriales->getById2($row->id_articulo);
                                $proveedores = $this->mproveedor->getById($row->id_proveedor);

                                if(!array_key_exists($row->semana, $arrayPresupuestoMAT)){
                                    $arrayPresupuestoMAT[$row->semana][0] = array(
                                                                            'clave' => $materiales['clave'],
                                                                            'area' => $materiales['linea_art'],
                                                                            'proveedor' => (!is_numeric($proveedores)) ? $proveedores['nombre'] : '',
                                                                            'semana' => $row->semana,
                                                                            'descripcion' => $materiales['nombre'],
                                                                            'unidadMedida' => $materiales['unidad_compra'],
                                                                            'cantidadViv' => $row->unidades / $totalViviendas,
                                                                            'cantidadTotal' => $row->unidades,
                                                                            'precioSinIva' => $row->precio_unitario - ($row->precio_unitario * 0.16),
                                                                            'precioNeto' => $row->precio_unitario,
                                                                            'totalPorViv' => ($row->unidades / $totalViviendas) * $row->precio_unitario,
                                                                            'total' => ($row->unidades) * $row->precio_unitario,
                                                                        );
                                }else{
                                    $array = array(
                                                'clave' => $materiales['clave'],
                                                'area' => $materiales['linea_art'],
                                                'proveedor' => (!is_numeric($proveedores)) ? $proveedores['nombre'] : '',
                                                'semana' => $row->semana,
                                                'descripcion' => $materiales['nombre'],
                                                'unidadMedida' => $materiales['unidad_compra'],
                                                'cantidadViv' => $row->unidades / $totalViviendas,
                                                'cantidadTotal' => $row->unidades,
                                                'precioSinIva' => $row->precio_unitario - ($row->precio_unitario * 0.16),
                                                'precioNeto' => $row->precio_unitario,
                                                'totalPorViv' => ($row->unidades / $totalViviendas) * $row->precio_unitario,
                                                'total' => ($row->unidades) * $row->precio_unitario,
                                            );
                                    array_push($arrayPresupuestoMAT[$row->semana], $array);
                                }
                            }
                        }
                    }
                }
            }

            if(!$empty){
                if(count($arrayPresupuestoMAT) > 0){
                    $objPHPExcel = new PhpOffice\PhpSpreadsheet\Spreadsheet();
                    $objPHPExcel->getActiveSheet()->setTitle('PRESUPUESTO MATERIALES PAQUETE');
                    $objPHPExcel->setActiveSheetIndex(0);

                    $objPHPExcel->getActiveSheet()->mergeCells('A1:B7');

                    $gdImage = imagecreatefromjpeg(base_url() . '/img/bg1.jpg');
                    // Add a drawing to the worksheetecho date('H:i:s') . " Add a drawing to the worksheet\n";
                    $objDrawing = new PhpOffice\PhpSpreadsheet\Worksheet\MemoryDrawing();
                    $objDrawing->setName('Logo Vviend');
                    $objDrawing->setDescription('Logo Viviend');
                    $objDrawing->setImageResource($gdImage);
                    $objDrawing->setRenderingFunction(PhpOffice\PhpSpreadsheet\Worksheet\MemoryDrawing::RENDERING_JPEG);
                    $objDrawing->setMimeType(PhpOffice\PhpSpreadsheet\Worksheet\MemoryDrawing::MIMETYPE_DEFAULT);
                    $objDrawing->setOffsetX(150);
                    $objDrawing->setOffsetY(0);
                    $objDrawing->setWidth(900);
                    $objDrawing->setHeight(140);
                    $objDrawing->setCoordinates('A1');
                    $objDrawing->setWorksheet($objPHPExcel->getActiveSheet());

                    $objPHPExcel->getActiveSheet()->getStyle('B9:B12')->applyFromArray(
                        array('fill' => array(
                            'fillType' => PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID,
                            'color' => array('rgb' => 'FFE699')
                        ))
                    );

                    $objPHPExcel->getActiveSheet()->getStyle('D9:D12')->applyFromArray(
                        array('fill' => array(
                            'fillType' => PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID,
                            'color' => array('rgb' => 'FFE699')
                        ))
                    );

                    $objPHPExcel->getActiveSheet()->getStyle('G9:G12')->applyFromArray(
                        array('fill' => array(
                            'fillType' => PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID,
                            'color' => array('rgb' => 'FFE699')
                        ))
                    );

                    $objPHPExcel->getActiveSheet()->getStyle('J9:J12')->applyFromArray(
                        array('fill' => array(
                            'fillType' => PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID,
                            'color' => array('rgb' => 'FFE699')
                        ))
                    );

                    $objPHPExcel->getActiveSheet()->SetCellValue('A9', 'FRACCIONAMIENTO:');
                    $objPHPExcel->getActiveSheet()->SetCellValue('B9', $fraccionamiento);

                    $objPHPExcel->getActiveSheet()->SetCellValue('A10', 'PROTOTIPO:');
                    $objPHPExcel->getActiveSheet()->SetCellValue('B10', $prototipo);

                    $objPHPExcel->getActiveSheet()->SetCellValue('A11', 'CONTRATISTA:');
                    $objPHPExcel->getActiveSheet()->SetCellValue('B11', $constructor);

                    $objPHPExcel->getActiveSheet()->SetCellValue('A12', 'NO. DE VIV:');
                    $objPHPExcel->getActiveSheet()->SetCellValue('B12', $totalViviendas);
                    $objPHPExcel->getActiveSheet()->getStyle('B12')->getAlignment()->setHorizontal(PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_LEFT);
                    //

                    $objPHPExcel->getActiveSheet()->SetCellValue('C9', 'MANZANAS');
                    $objPHPExcel->getActiveSheet()->SetCellValue('D9', $manzanas);

                    $objPHPExcel->getActiveSheet()->SetCellValue('C10', 'LOTES:');
                    $objPHPExcel->getActiveSheet()->SetCellValue('D10', $lotes);

                    $objPHPExcel->getActiveSheet()->SetCellValue('C11', 'PRESUPUESTO UNIT.:');
                    $objPHPExcel->getActiveSheet()->SetCellValue('D11', precio_format($presupuestoUnit));

                    $objPHPExcel->getActiveSheet()->SetCellValue('C12', 'TOTAL CONTRATO:');
                    $objPHPExcel->getActiveSheet()->SetCellValue('D12', precio_format($totalContrato));

                    //

                    $objPHPExcel->getActiveSheet()->mergeCells('E9:F9');
                    $objPHPExcel->getActiveSheet()->SetCellValue('E9', 'INICIO PROGRAMADO:');
                    $objPHPExcel->getActiveSheet()->SetCellValue('G9', $fechaInicio);

                    $objPHPExcel->getActiveSheet()->mergeCells('E10:F10');
                    $objPHPExcel->getActiveSheet()->SetCellValue('E10', 'TERMINO PROGRAMADO:');
                    $objPHPExcel->getActiveSheet()->SetCellValue('G10', $fechaFin);

                    $objPHPExcel->getActiveSheet()->mergeCells('E11:F11');
                    $objPHPExcel->getActiveSheet()->SetCellValue('E11', 'INICIO REAL:');
                    $objPHPExcel->getActiveSheet()->SetCellValue('G11', '');

                    $objPHPExcel->getActiveSheet()->mergeCells('E12:F12');
                    $objPHPExcel->getActiveSheet()->SetCellValue('E12', 'TERMINO REAL:');
                    $objPHPExcel->getActiveSheet()->SetCellValue('G12', '');

                    $objPHPExcel->getActiveSheet()->mergeCells('H9:I9');
                    $objPHPExcel->getActiveSheet()->SetCellValue('H9', 'ALMACEN:');
                    $objPHPExcel->getActiveSheet()->SetCellValue('J9', $paquete['titulo']);

                    $objPHPExcel->getActiveSheet()->mergeCells('H10:I10');
                    $objPHPExcel->getActiveSheet()->SetCellValue('H10', 'COSTO X M2:');
                    $objPHPExcel->getActiveSheet()->SetCellValue('J10', (!is_numeric($getInfo)) ? $getInfo['costoM2'] : '');

                    $objPHPExcel->getActiveSheet()->mergeCells('H11:I11');
                    $objPHPExcel->getActiveSheet()->SetCellValue('H11', 'M2 X VIVIENDA:');
                    $objPHPExcel->getActiveSheet()->SetCellValue('J11', (!is_numeric($getInfo)) ? $getInfo['m2Viv'] : '');

                    $objPHPExcel->getActiveSheet()->SetCellValue('A13', 'CLAVE');
                    $objPHPExcel->getActiveSheet()->SetCellValue('B13', 'AREA');
                    $objPHPExcel->getActiveSheet()->SetCellValue('C13', 'PROVEEDOR');
                    $objPHPExcel->getActiveSheet()->SetCellValue('D13', 'SEM');
                    $objPHPExcel->getActiveSheet()->SetCellValue('E13', 'DESCRIPCION');
                    $objPHPExcel->getActiveSheet()->SetCellValue('F13', 'U.M');
                    $objPHPExcel->getActiveSheet()->SetCellValue('G13', 'CANTIDAD POR VIV');
                    $objPHPExcel->getActiveSheet()->SetCellValue('H13', 'TOTAL');
                    $objPHPExcel->getActiveSheet()->SetCellValue('I13', 'PRECIO SIN IVA');
                    $objPHPExcel->getActiveSheet()->SetCellValue('J13', 'PRECIO NETO');
                    $objPHPExcel->getActiveSheet()->SetCellValue('K13', 'TOTAL POR VIV');
                    $objPHPExcel->getActiveSheet()->SetCellValue('L13', 'TOTAL');

                    $rowCount = 14;
                    $rowCountInicial = 14;
                    $rowCountFinal = 0;
                    $letraSemana = "N";
                    $arrayTotales = array(); 
                    $arrayTotal = array();
                    $totalSemana = 0; 
                    foreach($arrayPresupuestoMAT as $k=>$v){

                        $objPHPExcel->getActiveSheet()->SetCellValue($letraSemana.'13', 'SEMANA '.$k);

                        $objPHPExcel->getActiveSheet()->getColumnDimension($letraSemana)->setWidth(15);

                        $rowInicial = $rowCount;

                        foreach($arrayPresupuestoMAT[$k] as $row){
                            $objPHPExcel->getActiveSheet()->SetCellValue('A'.$rowCount, $row['clave']);
                            $objPHPExcel->getActiveSheet()->SetCellValue('B'.$rowCount, $row['area']);
                            $objPHPExcel->getActiveSheet()->SetCellValue('C'.$rowCount, $row['proveedor']);
                            $objPHPExcel->getActiveSheet()->SetCellValue('D'.$rowCount, $row['semana']);
                            $objPHPExcel->getActiveSheet()->SetCellValue('E'.$rowCount, $row['descripcion']);
                            $objPHPExcel->getActiveSheet()->SetCellValue('F'.$rowCount, $row['unidadMedida']);
                            $objPHPExcel->getActiveSheet()->SetCellValue('G'.$rowCount, $row['cantidadViv']);
                            $objPHPExcel->getActiveSheet()->SetCellValue('H'.$rowCount, $row['cantidadTotal']);
                            $objPHPExcel->getActiveSheet()->SetCellValue('I'.$rowCount, precio_format($row['precioSinIva']));
                            $objPHPExcel->getActiveSheet()->SetCellValue('J'.$rowCount, precio_format($row['precioNeto']));
                            $objPHPExcel->getActiveSheet()->SetCellValue('K'.$rowCount, precio_format($row['totalPorViv']));
                            $objPHPExcel->getActiveSheet()->SetCellValue('L'.$rowCount, precio_format($row['total']));

                            $objPHPExcel->getActiveSheet()->SetCellValue($letraSemana.$rowCount, precio_format($row['total']));

                            $totalSemana = $totalSemana + $row['total'];

                            $arrayTotal[$rowCount] = array('total' => $row['total']);
                            $arrayTotales[$k] = array('letra' => $letraSemana, 'rowInicial' => $rowInicial, 'rowFinal' => $rowCount, 'total' => $totalSemana);

                            $rowCount++;
                        }

                        $letraSemana++;
                    }

                    $objPHPExcel->getActiveSheet()->SetCellValue($letraSemana.'13', 'TOTAL');
                    $objPHPExcel->getActiveSheet()->getColumnDimension($letraSemana)->setWidth(15);

                    $rowC = 0;
                    $totalC = 0;
                    foreach($arrayTotal as $k=>$v){
                        $rowC = $k;
                        $tot = $v['total'];
                        $totalC = $totalC + $tot;
                        $objPHPExcel->getActiveSheet()->SetCellValue($letraSemana.$k, precio_format($tot));

                        $styleArray = array(
                            'borders' => array(
                                'allBorders' => array(
                                    'borderStyle' => PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN
                                )
                            )
                        );

                        $objPHPExcel->getActiveSheet()->getStyle(
                            $letraSemana.$k.':'.$letraSemana.$k
                        )->applyFromArray($styleArray);
                    }

                    $rowC++;

                    $objPHPExcel->getActiveSheet()->SetCellValue($letraSemana.$rowC, precio_format($totalC));

                    $styleArray = array(
                        'borders' => array(
                            'allBorders' => array(
                                'borderStyle' => PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN
                            )
                        )
                    );

                    $objPHPExcel->getActiveSheet()->getStyle(
                        $letraSemana.'13:'.$letraSemana.$rowC
                    )->applyFromArray($styleArray);

                    //

                    $rowCount = $rowCount - 1;

                    $rowCountFinal = $rowCount;

                    foreach($arrayPresupuestoMAT as $key=>$val){
                        $rInicio = $rowCountInicial;
                        $rFinal = $rowCountFinal;
                        $letra = $arrayTotales[$key]['letra'];
                        $inicio = $arrayTotales[$key]['rowInicial'];
                        $final = $arrayTotales[$key]['rowFinal'];
                        $total = $arrayTotales[$key]['total'];

                        for ($rInicio; $rInicio <= $rFinal; $rInicio++) { 
                            if($rInicio >= $inicio && $rInicio <= $final){

                            }else{
                                $objPHPExcel->getActiveSheet()->SetCellValue($letra.$rInicio, precio_format(0));
                            }

                        }

                        
                        $objPHPExcel->getActiveSheet()->SetCellValue($letra.$rInicio, precio_format($total));

                        $rInicio++;

                        $objPHPExcel->getActiveSheet()->SetCellValue($letra.$rInicio, $total / $totalC);

                        $objPHPExcel->getActiveSheet()->getStyle($letra.$rInicio)
                            ->getNumberFormat()->applyFromArray( 
                            array( 
                                'code' => PhpOffice\PhpSpreadsheet\Style\NumberFormat::FORMAT_PERCENTAGE_00
                            )
                        );
                        
                        $styleArray = array(
                            'borders' => array(
                                'allBorders' => array(
                                    'borderStyle' => PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN
                                )
                            )
                        );

                        $objPHPExcel->getActiveSheet()->getStyle(
                            $letra.'13:'.$letra.$rInicio
                        )->applyFromArray($styleArray);
                    }

                    //

                    $styleArray = array(
                        'borders' => array(
                            'allBorders' => array(
                                'borderStyle' => PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN
                            )
                        )
                    );

                    $objPHPExcel->getActiveSheet()->getStyle(
                        'A13:L' . $rowCount
                    )->applyFromArray($styleArray);
                    

                    $objPHPExcel->getActiveSheet()->getColumnDimension('A')->setWidth(15);
                    $objPHPExcel->getActiveSheet()->getColumnDimension('B')->setWidth(25);
                    $objPHPExcel->getActiveSheet()->getColumnDimension('C')->setWidth(30);
                    $objPHPExcel->getActiveSheet()->getColumnDimension('D')->setWidth(35);
                    $objPHPExcel->getActiveSheet()->getColumnDimension('E')->setWidth(40);
                    $objPHPExcel->getActiveSheet()->getColumnDimension('F')->setWidth(10);
                    $objPHPExcel->getActiveSheet()->getColumnDimension('G')->setWidth(15);
                    $objPHPExcel->getActiveSheet()->getColumnDimension('H')->setWidth(15);
                    $objPHPExcel->getActiveSheet()->getColumnDimension('I')->setWidth(15);
                    $objPHPExcel->getActiveSheet()->getColumnDimension('J')->setWidth(15);
                    $objPHPExcel->getActiveSheet()->getColumnDimension('K')->setWidth(15);
                    $objPHPExcel->getActiveSheet()->getColumnDimension('L')->setWidth(15);

                    $name = $paquete["id"].".".$paquete["titulo"];
                    header('Content-Type: application/vnd.ms-excel');
                    header('Content-Disposition: attachment;filename="' . $name . '(' . date('d-m-Y') . ').xls"');
                    header('Cache-Control: max-age=0'); //no cache
                    $objWriter = PhpOffice\PhpSpreadsheet\IOFactory::createWriter($objPHPExcel, 'Xls');
                    // Forzamos a la descarga
                    $objWriter->save('php://output');
                }
            }else{
                $_SESSION['mensaje'] = 'Este paquete no tiene ningún presupuesto asociado.';
            }

        }else{
            $_SESSION['mensaje'] = 'No se encontro el paquete.';
        }

        redirect('rsemana');
    }

    public function exportarMateriales($idPaquete = 0)
    {
        //Inicia sincronización previa
        require('Cronjob.php');
        $cronjob = new Cronjob();
        $ordenesCompra=$this->mordencompra->getAllByIdPaquete($idPaquete);
        if(!is_numeric($ordenesCompra)){
            foreach ($ordenesCompra->result() as $row) {
                $cronjob->GetOrdenCompra($row->idEmpresa,$row->id,$idPaquete,false);
            }
        }
        //Inicia armado
        $this->load->library('excel');
        if($idPaquete == 0){
            $idPaquete = $_POST['idPaquete'];
        }
        $paquete = $this->mpaquete->getById($idPaquete);
        if(!is_numeric($paquete)){
            $getInfo = $this->getInfoVer($paquete['id']);
            $material = $this->mmaterial->getByIdPaquete($paquete['id']);
            //
            $manoObra = $this->mmanoobra->getById($paquete['idManoObra']);
            $fraccionamiento = (!is_numeric($manoObra)) ? $this->mfraccionamiento->getCampo2('titulo', $manoObra['idFraccionamiento']) : '';
            $prototipo = (!is_numeric($manoObra)) ? $this->mprototipos->getCampo2('nombre', $manoObra['idPrototipo']) : '';
            $paqueteLotes = 0;
            $paqueteLotes = contarLotesManzanas($paquete['rango_lotes']);
            $lotes = $paqueteLotes['lotes'];
            $manzanas=implode(", ",array_keys($paqueteLotes["arrayMzs"]));
            $paqueteLotes = $paqueteLotes['total'];
            $constructorNombre = $this->mconstructores->getCampo2('nombre', $paquete['idConstructor']);
            $constructorApellidoP = $this->mconstructores->getCampo2('apellidoP', $paquete['idConstructor']);
            $constructorApellidoM = $this->mconstructores->getCampo2('apellidoM', $paquete['idConstructor']);
            $constructor = $constructorNombre . ' ' . $constructorApellidoP . ' ' . $constructorApellidoM;
            $totalViviendas = $paqueteLotes;
            $qTotalPresupuestoMO = $this->db->query("SELECT SUM(importe) as totalImporte FROM presupuesto_mo WHERE idManoObra = ".$manoObra['id']);
            $presupuestoUnit = ($qTotalPresupuestoMO->row()->totalImporte != '') ? $qTotalPresupuestoMO->row()->totalImporte : 0;
            $totalContrato = $presupuestoUnit * $paqueteLotes;
            $fechaInicio = date_format(date_create($paquete['fecha_inicio']), 'd-m-Y');
            $fechaFin = date_format(date_create($paquete['fecha_fin']), 'd-m-Y');
            $empty = true;
            $arrayPresupuestoMAT = array();
            $countArray = 0;
            //Total pmat
            $totalUnitarioMat = $this->mpresupuestomat->getSumTotalUnitario($material["id"]);
            $totalPresupuestoMat = $totalUnitarioMat * $paqueteLotes;

            if(!is_numeric($material)){
                $semanas = $this->db->query('SELECT p.semana AS id, p.semana AS titulo FROM material AS m INNER JOIN presupuesto_mat AS p ON m.id = p.idMaterial
                        INNER JOIN paquetes pa ON m.idPaquete = pa.id INNER JOIN mano_obra AS mo ON pa.idManoObra = mo.id WHERE pa.id = '. $idPaquete . '
                        GROUP BY p.semana ORDER BY p.semana ASC;');

                if($semanas->num_rows() > 0){
                    foreach($semanas->result() as $r){
                        $presupuestoMat = $this->mpresupuestomat->getByIdMaterial($material['id'], $r->id);
                        if(!is_numeric($presupuestoMat)){
                            $empty = false;
                            foreach($presupuestoMat->result() as $row){
                                $materialActividadPrototipo = $this->mmaterialesactividadprototipo->getById($row->idMateriales);
                                $materiales = $this->mmateriales->getById2($materialActividadPrototipo['idMaterial']);
                                $proveedores = $this->mproveedor->getById($row->idProveedor);

                                if(!array_key_exists($row->semana, $arrayPresupuestoMAT)){
                                    $arrayPresupuestoMAT[$row->semana][0] = array(
                                                                            'clave' => $materiales['clave'],
                                                                            'idArticulo' => $materiales['id'],
                                                                            'area' => $materiales['linea_art'],
                                                                            'proveedor' => (!is_numeric($proveedores)) ? $proveedores['nombre'] : '',
                                                                            'idProveedor' => (!is_numeric($proveedores)) ? $proveedores['id'] : 0,
                                                                            'semana' => $row->semana,
                                                                            'descripcion' => $materiales['nombre'],
                                                                            'unidadMedida' => $materiales['unidad_compra'],
                                                                            'cantidadViv' => $materialActividadPrototipo['cantidad'],
                                                                            'cantidadTotal' => $materialActividadPrototipo['cantidad'] * $totalViviendas,
                                                                            'precioSinIva' => $row->precioUnitario - ($row->precioUnitario * 0.16),
                                                                            'precioNeto' => $row->precioUnitario,
                                                                            'totalPorViv' => $materialActividadPrototipo['cantidad'] * $row->precioUnitario,
                                                                            'total' => ($materialActividadPrototipo['cantidad'] * $totalViviendas) * $row->precioUnitario,
                                                                        );
                                }else{
                                    $array = array(
                                                'clave' => $materiales['clave'],
                                                'idArticulo' => $materiales['id'],
                                                'area' => $materiales['linea_art'],
                                                'proveedor' => (!is_numeric($proveedores)) ? $proveedores['nombre'] : '',
                                                'idProveedor' => (!is_numeric($proveedores)) ? $proveedores['id'] : 0,
                                                'semana' => $row->semana,
                                                'descripcion' => $materiales['nombre'],
                                                'unidadMedida' => $materiales['unidad_compra'],
                                                'cantidadViv' => $materialActividadPrototipo['cantidad'],
                                                'cantidadTotal' => $materialActividadPrototipo['cantidad'] * $totalViviendas,
                                                'precioSinIva' => $row->precioUnitario - ($row->precioUnitario * 0.16),
                                                'precioNeto' => $row->precioUnitario,
                                                'totalPorViv' => $materialActividadPrototipo['cantidad'] * $row->precioUnitario,
                                                'total' => ($materialActividadPrototipo['cantidad'] * $totalViviendas) * $row->precioUnitario,
                                            );
                                    array_push($arrayPresupuestoMAT[$row->semana], $array);
                                }
                            }
                        }
                    }
                }
            }

            if(!$empty){
                if(count($arrayPresupuestoMAT) > 0){
                    $objPHPExcel = new PhpOffice\PhpSpreadsheet\Spreadsheet();
                    $objPHPExcel->getActiveSheet()->setTitle('REPORTE POR SEMANA');
                    $objPHPExcel->setActiveSheetIndex(0);

                    $objPHPExcel->getActiveSheet()->mergeCells('A1:B7');

                    $gdImage = imagecreatefromjpeg(base_url() . '/img/bg1.jpg');
                    // Add a drawing to the worksheetecho date('H:i:s') . " Add a drawing to the worksheet\n";
                    $objDrawing = new PhpOffice\PhpSpreadsheet\Worksheet\MemoryDrawing();
                    $objDrawing->setName('Logo Vviend');
                    $objDrawing->setDescription('Logo Viviend');
                    $objDrawing->setImageResource($gdImage);
                    $objDrawing->setRenderingFunction(PhpOffice\PhpSpreadsheet\Worksheet\MemoryDrawing::RENDERING_JPEG);
                    $objDrawing->setMimeType(PhpOffice\PhpSpreadsheet\Worksheet\MemoryDrawing::MIMETYPE_DEFAULT);
                    $objDrawing->setOffsetX(150);
                    $objDrawing->setOffsetY(0);
                    $objDrawing->setWidth(900);
                    $objDrawing->setHeight(140);
                    $objDrawing->setCoordinates('A1');
                    $objDrawing->setWorksheet($objPHPExcel->getActiveSheet());

                    $objPHPExcel->getActiveSheet()->getStyle('B9:B12')->applyFromArray(
                        array('fill' => array(
                            'fillType' => PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID,
                            'color' => array('rgb' => 'FFE699')
                        ))
                    );

                    $objPHPExcel->getActiveSheet()->getStyle('D9:D12')->applyFromArray(
                        array('fill' => array(
                            'fillType' => PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID,
                            'color' => array('rgb' => 'FFE699')
                        ))
                    );

                    $objPHPExcel->getActiveSheet()->getStyle('G9:G12')->applyFromArray(
                        array('fill' => array(
                            'fillType' => PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID,
                            'color' => array('rgb' => 'FFE699')
                        ))
                    );

                    $objPHPExcel->getActiveSheet()->getStyle('J9:J12')->applyFromArray(
                        array('fill' => array(
                            'fillType' => PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID,
                            'color' => array('rgb' => 'FFE699')
                        ))
                    );

                    $objPHPExcel->getActiveSheet()->SetCellValue('A9', 'FRACCIONAMIENTO:');
                    $objPHPExcel->getActiveSheet()->SetCellValue('B9', $fraccionamiento);

                    $objPHPExcel->getActiveSheet()->SetCellValue('A10', 'PROTOTIPO:');
                    $objPHPExcel->getActiveSheet()->SetCellValue('B10', $prototipo);

                    $objPHPExcel->getActiveSheet()->SetCellValue('A11', 'CONTRATISTA:');
                    $objPHPExcel->getActiveSheet()->SetCellValue('B11', $constructor);

                    $objPHPExcel->getActiveSheet()->SetCellValue('A12', 'NO. DE VIV:');
                    $objPHPExcel->getActiveSheet()->SetCellValue('B12', $totalViviendas);
                    $objPHPExcel->getActiveSheet()->getStyle('B12')->getAlignment()->setHorizontal(PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_LEFT);
                    //

                    $objPHPExcel->getActiveSheet()->SetCellValue('C9', 'MANZANAS');
                    $objPHPExcel->getActiveSheet()->SetCellValue('D9', $manzanas);

                    $objPHPExcel->getActiveSheet()->SetCellValue('C10', 'LOTES:');
                    $objPHPExcel->getActiveSheet()->SetCellValue('D10', $lotes);

                    $objPHPExcel->getActiveSheet()->SetCellValue('C11', 'PRESUPUESTO UNIT.:');
                    $objPHPExcel->getActiveSheet()->SetCellValue('D11', precio_format($presupuestoUnit));

                    $objPHPExcel->getActiveSheet()->SetCellValue('C12', 'TOTAL CONTRATO:');
                    $objPHPExcel->getActiveSheet()->SetCellValue('D12', precio_format($totalContrato));

                    $objPHPExcel->getActiveSheet()->mergeCells('E9:F9');
                    $objPHPExcel->getActiveSheet()->SetCellValue('E9', 'INICIO PROGRAMADO:');
                    $objPHPExcel->getActiveSheet()->SetCellValue('G9', $fechaInicio);

                    $objPHPExcel->getActiveSheet()->mergeCells('E10:F10');
                    $objPHPExcel->getActiveSheet()->SetCellValue('E10', 'TERMINO PROGRAMADO:');
                    $objPHPExcel->getActiveSheet()->SetCellValue('G10', $fechaFin);

                    $objPHPExcel->getActiveSheet()->mergeCells('E11:F11');
                    $objPHPExcel->getActiveSheet()->SetCellValue('E11', 'INICIO REAL:');
                    $objPHPExcel->getActiveSheet()->SetCellValue('G11', '');

                    $objPHPExcel->getActiveSheet()->mergeCells('E12:F12');
                    $objPHPExcel->getActiveSheet()->SetCellValue('E12', 'TERMINO REAL:');
                    $objPHPExcel->getActiveSheet()->SetCellValue('G12', '');

                    $objPHPExcel->getActiveSheet()->mergeCells('H9:I9');
                    $objPHPExcel->getActiveSheet()->SetCellValue('H9', 'ALMACEN:');
                    $objPHPExcel->getActiveSheet()->SetCellValue('J9', $paquete['titulo']);

                    $objPHPExcel->getActiveSheet()->mergeCells('H10:I10');
                    $objPHPExcel->getActiveSheet()->SetCellValue('H10', 'COSTO X M2:');
                    $objPHPExcel->getActiveSheet()->SetCellValue('J10', (!is_numeric($getInfo)) ? $getInfo['costoM2'] : '');

                    $objPHPExcel->getActiveSheet()->mergeCells('H11:I11');
                    $objPHPExcel->getActiveSheet()->SetCellValue('H11', 'M2 X VIVIENDA:');
                    $objPHPExcel->getActiveSheet()->SetCellValue('J11', (!is_numeric($getInfo)) ? $getInfo['m2Viv'] : '');

                    $objPHPExcel->getActiveSheet()->SetCellValue('A13', 'CLAVE');
                    $objPHPExcel->getActiveSheet()->SetCellValue('B13', 'AREA');
                    $objPHPExcel->getActiveSheet()->SetCellValue('C13', 'PROVEEDOR');
                    $objPHPExcel->getActiveSheet()->SetCellValue('D13', 'SEM');
                    $objPHPExcel->getActiveSheet()->SetCellValue('E13', 'DESCRIPCION');
                    $objPHPExcel->getActiveSheet()->SetCellValue('F13', 'U.M');
                    $objPHPExcel->getActiveSheet()->SetCellValue('G13', 'CANTIDAD POR VIV');
                    $objPHPExcel->getActiveSheet()->SetCellValue('H13', 'TOTAL');
                    $objPHPExcel->getActiveSheet()->SetCellValue('I13', 'PRECIO SIN IVA');
                    $objPHPExcel->getActiveSheet()->SetCellValue('J13', 'PRECIO NETO');
                    $objPHPExcel->getActiveSheet()->SetCellValue('K13', 'TOTAL POR VIV');
                    $objPHPExcel->getActiveSheet()->SetCellValue('L13', 'TOTAL');

                    $rowCount = 14;
                    $rowCountInicial = 14;
                    $rowCountFinal = 0;
                    $letraSemana = "N";
                    $arrayTotales = array(); 
                    $arrayTotal = array();
                    $totalSemana = 0; 
                    foreach($arrayPresupuestoMAT as $k=>$v){

                        $totalSemana = 0;

                        $objPHPExcel->getActiveSheet()->SetCellValue($letraSemana.'13', 'SEMANA '.$k);

                        $objPHPExcel->getActiveSheet()->getColumnDimension($letraSemana)->setWidth(15);

                        $rowInicial = $rowCount;
                        //echo "<pre>";
                        $ordenSemana = $this->db->query('SELECT dc.*, c.id_proveedor, c.id_almacen, o.semana FROM orden_compra AS o 
                                                        INNER JOIN compra AS c ON o.id = c.id_orden_compra 
                                                        INNER JOIN detalle_compra AS dc ON c.id = dc.id_compra 
                                                        WHERE o.idMaterial = '.$material['id'].' AND o.semana = '.$k.'');
                    
                        $ordenSemana=($ordenSemana->num_rows() > 0) ? $ordenSemana->result_array() : 0;
                        //print_r($ordenSemana->result());
                        //exit();

                        foreach($arrayPresupuestoMAT[$k] as $row){
                            $rTotal = 0;
                            $objPHPExcel->getActiveSheet()->SetCellValue('A'.$rowCount, $row['clave']);
                            $objPHPExcel->getActiveSheet()->SetCellValue('B'.$rowCount, $row['area']);
                            $objPHPExcel->getActiveSheet()->SetCellValue('C'.$rowCount, $row['proveedor']);
                            $objPHPExcel->getActiveSheet()->SetCellValue('D'.$rowCount, $row['semana']);
                            $objPHPExcel->getActiveSheet()->SetCellValue('E'.$rowCount, $row['descripcion']);
                            $objPHPExcel->getActiveSheet()->SetCellValue('F'.$rowCount, $row['unidadMedida']);
                            $objPHPExcel->getActiveSheet()->SetCellValue('G'.$rowCount, $row['cantidadViv']);
                            $objPHPExcel->getActiveSheet()->SetCellValue('H'.$rowCount, $row['cantidadTotal']);
                            $objPHPExcel->getActiveSheet()->SetCellValue('I'.$rowCount, precio_format($row['precioSinIva']));
                            $objPHPExcel->getActiveSheet()->SetCellValue('J'.$rowCount, precio_format($row['precioNeto']));
                            $objPHPExcel->getActiveSheet()->SetCellValue('K'.$rowCount, precio_format($row['totalPorViv']));
                            $objPHPExcel->getActiveSheet()->SetCellValue('L'.$rowCount, precio_format($row['total']));

                            /*$qRecepcion = $this->db->query('SELECT dc.*, c.id_proveedor, c.id_almacen, o.semana FROM orden_compra AS o 
                                                            INNER JOIN compra AS c ON o.id = c.id_orden_compra 
                                                            INNER JOIN detalle_compra AS dc ON c.id = dc.id_compra 
                                                            WHERE o.idMaterial = '.$material['id'].' AND o.semana = '.$row['semana'].' AND dc.id_articulo = '.$row['idArticulo'].' AND c.id_proveedor = '.$row['idProveedor'].';');*/
                            //echo "<pre>";
                            //print_r($row);
                            //exit();
                            if(!is_numeric($ordenSemana)){
                                if(COUNT($ordenSemana) > 0){
                                    $existClave=false;
                                    foreach ($ordenSemana as $_key => $_val) {
                                        //echo "<pre>";
                                        //print_r($_val);
                                        //exit();
                                        if($_val["clave_articulo"] == $row["clave"]){
                                            $rTotal = ($_val['unidades']) * $_val['precio_unitario'];
                                            $objPHPExcel->getActiveSheet()->SetCellValue($letraSemana.$rowCount, precio_format($rTotal));
                                            unset($ordenSemana[$_key]);
                                            $existClave=true;
                                            break;
                                        }
                                    }
                                    if(!$existClave){
                                        $rTotal = 0;
                                        $objPHPExcel->getActiveSheet()->SetCellValue($letraSemana.$rowCount, precio_format(0));
                                    }
                                }else{
                                    $rTotal = 0;
                                    $objPHPExcel->getActiveSheet()->SetCellValue($letraSemana.$rowCount, precio_format(0));
                                }
                            }else{
                                $rTotal = 0;
                                $objPHPExcel->getActiveSheet()->SetCellValue($letraSemana.$rowCount, precio_format(0));
                            }

                            $totalSemana = $totalSemana + $rTotal;

                            $arrayTotal[$rowCount] = array('total' => $rTotal);
                            $arrayTotales[$k] = array('letra' => $letraSemana, 'rowInicial' => $rowInicial, 'rowFinal' => $rowCount, 'total' => $totalSemana);

                            $rowCount++;
                        }
                        $letraSemana++;
                    }

                    $objPHPExcel->getActiveSheet()->SetCellValue($letraSemana.'13', 'TOTAL');
                    $objPHPExcel->getActiveSheet()->getColumnDimension($letraSemana)->setWidth(15);

                    $rowC = 0;
                    $totalC = 0;
                    foreach($arrayTotal as $k=>$v){
                        $rowC = $k;
                        $tot = $v['total'];
                        $totalC = $totalC + $tot;
                        $objPHPExcel->getActiveSheet()->SetCellValue($letraSemana.$k, precio_format($tot));

                        $styleArray = array(
                            'borders' => array(
                                'allBorders' => array(
                                    'borderStyle' => PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN
                                )
                            )
                        );

                        $objPHPExcel->getActiveSheet()->getStyle(
                            $letraSemana.$k.':'.$letraSemana.$k
                        )->applyFromArray($styleArray);
                    }

                    $rowC++;

                    $objPHPExcel->getActiveSheet()->SetCellValue($letraSemana.$rowC, precio_format($totalC));

                    $styleArray = array(
                        'borders' => array(
                            'allBorders' => array(
                                'borderStyle' => PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN
                            )
                        )
                    );

                    $objPHPExcel->getActiveSheet()->getStyle(
                        $letraSemana.'13:'.$letraSemana.$rowC
                    )->applyFromArray($styleArray);

                    //

                    $rowCount = $rowCount - 1;

                    $rowCountFinal = $rowCount;

                    foreach($arrayPresupuestoMAT as $key=>$val){
                        $rInicio = $rowCountInicial;
                        $rFinal = $rowCountFinal;
                        $letra = $arrayTotales[$key]['letra'];
                        $inicio = $arrayTotales[$key]['rowInicial'];
                        $final = $arrayTotales[$key]['rowFinal'];
                        $total = $arrayTotales[$key]['total'];

                        for ($rInicio; $rInicio <= $rFinal; $rInicio++) { 
                            if($rInicio >= $inicio && $rInicio <= $final){

                            }else{
                                $objPHPExcel->getActiveSheet()->SetCellValue($letra.$rInicio, precio_format(0));
                            }

                        }

                        
                        $objPHPExcel->getActiveSheet()->SetCellValue($letra.$rInicio, precio_format($total));

                        $rInicio++;

                        if($total > 0){
                            $objPHPExcel->getActiveSheet()->SetCellValue($letra.$rInicio, number_format(($total / $totalPresupuestoMat) * 100,2)."%");
                        }else{
                            $objPHPExcel->getActiveSheet()->SetCellValue($letra.$rInicio, 0);
                        }

                        $objPHPExcel->getActiveSheet()->getStyle($letra.$rInicio)
                            ->getNumberFormat()->applyFromArray( 
                            array( 
                                'code' => PhpOffice\PhpSpreadsheet\Style\NumberFormat::FORMAT_PERCENTAGE_00
                            )
                        );
                        
                        $styleArray = array(
                            'borders' => array(
                                'allBorders' => array(
                                    'borderStyle' => PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN
                                )
                            )
                        );

                        $objPHPExcel->getActiveSheet()->getStyle(
                            $letra.'13:'.$letra.$rInicio
                        )->applyFromArray($styleArray);
                    }

                    //

                    $styleArray = array(
                        'borders' => array(
                            'allBorders' => array(
                                'borderStyle' => PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN
                            )
                        )
                    );

                    $objPHPExcel->getActiveSheet()->getStyle(
                        'A13:L' . $rowCount
                    )->applyFromArray($styleArray);
                    

                    $objPHPExcel->getActiveSheet()->getColumnDimension('A')->setWidth(15);
                    $objPHPExcel->getActiveSheet()->getColumnDimension('B')->setWidth(25);
                    $objPHPExcel->getActiveSheet()->getColumnDimension('C')->setWidth(30);
                    $objPHPExcel->getActiveSheet()->getColumnDimension('D')->setWidth(35);
                    $objPHPExcel->getActiveSheet()->getColumnDimension('E')->setWidth(40);
                    $objPHPExcel->getActiveSheet()->getColumnDimension('F')->setWidth(10);
                    $objPHPExcel->getActiveSheet()->getColumnDimension('G')->setWidth(15);
                    $objPHPExcel->getActiveSheet()->getColumnDimension('H')->setWidth(15);
                    $objPHPExcel->getActiveSheet()->getColumnDimension('I')->setWidth(15);
                    $objPHPExcel->getActiveSheet()->getColumnDimension('J')->setWidth(15);
                    $objPHPExcel->getActiveSheet()->getColumnDimension('K')->setWidth(15);
                    $objPHPExcel->getActiveSheet()->getColumnDimension('L')->setWidth(15);

                    $name = $paquete["id"].".".$paquete["titulo"];
                    header('Content-Type: application/vnd.ms-excel');
                    header('Content-Disposition: attachment;filename="' . $name . '(' . date('d-m-Y') . ').xls"');
                    header('Cache-Control: max-age=0'); //no cache
                    $objWriter = PhpOffice\PhpSpreadsheet\IOFactory::createWriter($objPHPExcel, 'Xls');
                    // Forzamos a la descarga
                    $objWriter->save('php://output');
                }
            }
            else{
                $_SESSION['mensaje'] = 'Este paquete no tiene ningún presupuesto asociado.';
            }
        }
        else{
            $_SESSION['mensaje'] = 'No se encontro el paquete.';
        }
        redirect('rsemana');
    }

    public function getInfoVer($idPaquete)
    {
        $paquete = $this->mpaquete->getById($idPaquete);
        $qManoObra = $this->mmanoobra->getById($paquete['idManoObra']);
        $superficieM2 = $this->mprototipos->getCampo('superficieM2',$qManoObra['idPrototipo']);
        $prototipo = $this->mprototipos->getById($qManoObra['idPrototipo']);

        $material = $this->mmaterial->getByIdFraccIdProtIdMO($qManoObra['idFraccionamiento'], $qManoObra['idPrototipo'], $idPaquete);
        
        $detalle = $this->mdetallepaquete->getByIdPaquete($idPaquete);
        if (!is_numeric($paquete) && !is_numeric($prototipo) && !is_numeric($material)) {
            $presupuestoViv = $this->mpresupuestomat->getSumTotalImporte($material['id']);
            $lotes = (!is_numeric($detalle)) ? $detalle->num_rows() : 0;
            $presupuestoPaq = $presupuestoViv * $lotes;
            $costoM2 = $presupuestoViv / $superficieM2;
            $response = array('prototipo' => $prototipo['titulo'],
                'fraccionamiento' => $this->mfraccionamiento->getCampo('titulo', $qManoObra['idFraccionamiento']),
                'rangoLotes' => (!is_numeric($detalle))? $detalle->num_rows() : 0,
                'presupuestoViv' => precio_format($presupuestoViv),
                'presupuestoPaq' => precio_format($presupuestoPaq),
                'costoM2' => precio_format($costoM2),
                'm2Viv' => $prototipo['superficieM2']
            );
        } else {
            $response = 0;
        }
        return $response;
    }
}