<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Rordenes extends MX_Controller {
	public $data,$vParameters,$mainView,$fv;
	public function __construct(){
	$this->nsession = $this->config->item('nsession');
    if (!isset($_SESSION[$this->nsession]) || (($_SESSION[$this->nsession]['usuario'] == ""))) redirect('login');
            $this->fv = 'rordenes'; // form validation variable
            $this->mainView = 'rordenes';
            $this->data['fjs'] = '';
            $this->data['js'] = ' <script src="assets/js/rordenes/listado.js" type="text/javascript"></script>';
            $this->data['css'] = '';
            // Tools
            $this->load->helper(array('tools','numeros','url','form','date','text','security'));
            // Modelos
            $this->load->model(array('musuario','mop_detalle','mfraccionamiento','mconstructores','mprototipos','mpaquete','mcortes'));
            valSession("obra",$this->fv);
    }

    public function index(){
		$data['q'] = '';
		$data['corteActual']=$this->mcortes->getCorteActual();
		$data['fraccionamientos']=$this->mfraccionamiento->getAllFiltro();
		$data['constructores']=$this->mconstructores->getSelectResult();
		$data['prototipos']=$this->mprototipos->getAll();
		$data['supervisores']=$this->musuario->getResidenteObraBySelectResult();
		$data['paquetes']=$this->mpaquete->getAll();
        $this->data['contenido'] = $this->load->view($this->mainView.'/index_view',$data,true);
        $this->load->view('templates/main_template',$this->data);
	}

	public function listado(){
        if(isset($_POST["info"])){
			$info=$_POST["info"];
            $filter="";
			if($info["ano"] > 0){
                $filter.=" AND YEAR(op.fecha)=".$info["ano"];
            }
			if($info["semana"] > 0){
                $filter.=" AND WEEK(op.fecha,7)=".$info["semana"];
            }
            if($info["constructor"] > 0){
                $filter.=" AND op.idConstructor=".$info["constructor"];
            }
            if ($info['fecha_inicio'] != "" && $info['fecha_fin']  != "") {
                $fecha_inicio = date_format(new DateTime($info['fecha_inicio']),"Y-m-d");
                $fecha_fin = date_format(new DateTime($info['fecha_fin']),"Y-m-d");
                if($fecha_inicio != $fecha_fin){
                    $filter.=" AND DATE(op.fecha) >= DATE('$fecha_inicio') AND DATE(op.fecha) <= DATE('$fecha_fin') + INTERVAL 1 DAY ";
                }else{
                    $filter.=" AND DATE(op.fecha) = DATE('$fecha_inicio') ";
                }
            }
		}
		$constructor="CONCAT_WS(' ',cons.nombre,cons.apellidoP,cons.apellidoM) constructor";
		$q=$this->db->query("SELECT op.*,$constructor FROM ordenes_pago op 
		LEFT JOIN constructores cons ON cons.id=op.idConstructor
		WHERE op.status AND op.statusPago>0 $filter");

		if ($q->num_rows()>0){
			$importe=0;
			$extras=0;
			$total_prestamos=0;
			$total_amortizaciones=0;
			$total_retenciones=0;
			$fg=0;
			$sum_total=0;
			foreach ($q->result() as $row){
				$extra=$this->db->query("SELECT SUM(opd.importe) importe FROM op_detalle opd WHERE 
				idOrdenPago=$row->id AND opd.tipoActividad=2 AND opd.idConstructor=$row->idConstructor");
				$retenciones=$this->db->query("SELECT SUM(monto) monto FROM movimientos WHERE idOrdenPago=$row->id AND (tipo=4 OR tipo=6 OR tipo=7)");
				$retenciones=($retenciones->num_rows()>0) ? $retenciones->row()->monto : 0;
				$prestamos=$this->db->query("SELECT SUM(monto) monto FROM movimientos WHERE idOrdenPago=$row->id AND tipo=1");
				$prestamos=($prestamos->num_rows()>0) ? $prestamos->row()->monto : 0;
				$comision=$this->db->query("SELECT SUM(monto) monto FROM movimientos WHERE idOrdenPago=$row->id AND tipo=8");
				$comision=($comision->num_rows()>0) ? $comision->row()->monto : 0;
				$comision=(($comision/100)*$row->importe);
				$amortizaciones=$this->db->query("SELECT SUM(monto) monto FROM movimientos WHERE idOrdenPago=$row->id AND tipo=3");
				$amortizaciones=($amortizaciones->num_rows()>0) ? $amortizaciones->row()->monto : 0;
				$total=($row->monto - ($amortizaciones+$retenciones+$comision) + $prestamos);
				$extra=($extra->num_rows()>0) ? $extra->row()->importe : 0;
				//sumatorias
				$importe+=$row->importe;
				$extras+=$extra; 
				$total_prestamos+=$prestamos;
				$total_amortizaciones+=$amortizaciones;
				$total_retenciones+=$retenciones;
				$fg+=$row->fg;
				$sum_total+=$total;
					$array['aaData'][] = array(
						'constructor' => $row->constructor,
						'nActividades' => $row->nActividades,
						'nLotes' => $row->nLotes,
						'nPaquetes' => $row->nPaquetes,
						'importe' => toNumber($row->importe - $extra),
						'extras' => toNumber($extra),
						'prestamos' => toNumber($prestamos),
						'amortizaciones' => toNumber($amortizaciones),
						'retenciones' => toNumber($retenciones + $comision),
						'fg' => toNumber($row->fg),
						'total' => toNumber($total),
					);
				}
				$array['aaData'][] = array(
					'tipo' => 'footer',
					'constructor' => "",
					'nActividades' => "",
					'nLotes' => "",
					'nPaquetes' => "",
					'importe' => toNumber($importe - $extras),
					'extras' => toNumber($extras),
					'prestamos' => toNumber($total_prestamos),
					'amortizaciones' => toNumber($total_amortizaciones),
					'retenciones' => toNumber($total_retenciones),
					'fg' => toNumber($fg),
					'total' => toNumber($sum_total),
				);
		}else{
			$array['aaData']=[];
		}
		echo json_encode($array);
	}

}


