<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Requisicion extends MX_Controller {
	public $data,$vParameters,$mainView,$fv;
	public function __construct(){
        $this->nsession = $this->config->item('nsession');
        if (!isset($_SESSION[$this->nsession]) || (($_SESSION[$this->nsession]['usuario'] == ""))) redirect('login');
            $this->fv = 'requisicion'; // form validation variable
            $this->mainView = 'requisicion';
            $this->data['fjs'] = '';
            $this->data['js'] = '';
            $this->data['css'] = '';
            // Tools
            $this->load->helper(array('tools','url','form','date','text','security'));
            // Modelos
            $this->load->model(array('musuario','mdetallepaquete','mproyecto','mprototipos','mfraccionamiento','mrequisiciones',
			'mrequisiciones_detalle','mpresupuestomat','mmateriales','mmaterialesactividadprototipo'));
            // Lbrerias
           	$this->data['fotos_www'] = $this->config->item('base_www').'/requisicion/';
            //Validación de usuarios
            valSession("materiales",$this->fv);
    }

	public function index(){
		$data['q'] = '';
		$this->data['js'] = ' <script src="assets/js/requisicion/listado.js" type="text/javascript"></script>';
        $this->data['contenido'] = $this->load->view($this->mainView.'/index_view',$data,true);
        $this->load->view('templates/main_template',$this->data);
	}

    public function listado(){
        $q = $this->mrequisiciones->getAll();
        if (!is_numeric($q)){
            foreach ($q->result() as $row){
				switch ($row->estatus) {
					case 1:
						$editar=true;
						$borrar=true;
						$solicitar=true;
						$entregar=false;
						break;
					case 2:
						$editar=false;
						$borrar=false;
						$solicitar=false;
						$entregar=true;
						break;
					case 3:
						$editar=false;
						$borrar=false;
						$solicitar=false;
						$entregar=false;
						break;
					default:
						break;
				}
				$art=$this->db->query("SELECT SUM(cantidad) n FROM requisiciones_detalle WHERE idRequisicion=$row->id");	
                $array['aaData'][] = array(
                    'id' => $row->id,
					'fraccionamiento' => $this->mfraccionamiento->getCampo('titulo',$row->idFraccionamiento),
					'titulo' => $row->titulo,
					'nArticulo' => ($art->num_rows() > 0) ? $art->row()->n : 0,
					'fecha' => $this->mrequisiciones->getCampo('created',$row->id),
					'solicita' => $this->musuario->getCampo("CONCAT_WS(' ',nombre,apellidoP,apellidoM)",$this->mrequisiciones->getCampo('created_by',$row->id)),
					'estatus' => getStatusRequisicion($row->estatus),
                    'acciones' => accionesRequisicion($row->id,$this->router->class,$editar,$borrar,$solicitar,$entregar)
                    );
            }
        } else{
            $array['aaData']=[];
        }
        echo json_encode($array);
    }

	public function changeStatus(){
		if(isset($_POST["id"]) && isset($_POST["estatus"])){
			$id=$_POST["id"];
			$estatus=$_POST["estatus"];
			$this->mrequisiciones->actualizar(["estatus"=>$estatus],$id);
			echo json_encode("ok");
		}
	}

	public function listadoArticulos(){
        $q = $this->mrequisiciones_detalle->getByIdRequisicion($_POST["idRequisicion"]);
        if (!is_numeric($q)){
            foreach ($q->result() as $row){
				$articulo=$this->mmateriales->getById2($row->idArticulo,$row->idEmpresa);
				$idMateriales=$this->mpresupuestomat->getCampo("idMateriales",$row->idPresupuesto);
				$cantidad=$this->mmaterialesactividadprototipo->getCampo("cantidad",$idMateriales);
				$solicitado=$this->getSolicitado((array) $row,"<>");
				$pendiente=$cantidad-$solicitado;
                $array['aaData'][] = array(
					"manzana"=>$this->mproyecto->getCampo("manzana",$row->idProyecto),
					"lote"=>$this->mproyecto->getCampo("lote",$row->idProyecto),
					"prototipo"=>$this->mprototipos->getCampo("nombre",$this->mproyecto->getCampo("idPrototipo",$row->idProyecto)),
					"categoria"=>$this->mpresupuestomat->getCampo("clave_cat",$row->idPresupuesto),
					"articulo"=>$articulo["nombre"],
					"total"=>$cantidad,
					"solicitado"=>$solicitado,
					"pendiente"=>$pendiente,
					"cantidad"=>'<input id="'.$row->id.'" type="text" class="form-control cantidad" value="'.$row->cantidad.'" style="width: 80px;">',
					'acciones' => '<a href="javascript:void(0);" id="'.$row->id.'" class="borrar"><i class="fa fa-trash" aria-hidden="true"></i></a>',
				);
            }
        } else{
            $array['aaData']=[];
        }
        echo json_encode($array);
    }

	public function getSolicitado($data,$operator=""){
		$filter=(isset($data["idRequisicion"])) ? " AND idRequisicion $operator ".$data['idRequisicion'] : "";
		$solicitado=$this->db->query("SELECT SUM(cantidad) n FROM requisiciones_detalle WHERE idProyecto=".$data['idProyecto']."
		AND idPaquete=".$data['idPaquete']." AND idPresupuesto=".$data['idPresupuesto'].$filter);
		$solicitado=($solicitado->num_rows() > 0) ? $solicitado->row()->n : 0;
		$solicitado=($solicitado != "") ? $solicitado : 0;
		return $solicitado;
	}

    public function nuevo(){
        // Mensajes
        $data['msg'] = '';

        $this->load->library('form_validation');
        if ($this->form_validation->run($this->fv) == FALSE) {
            $data['msg'] = validation_errors();
			$data["fraccionamientos"]=$this->getAllFraccionamientos(1);

            $this->data['contenido'] = $this->load->view($this->mainView . '/nuevo_view', $data, true);
            $this->load->view('templates/main_template', $this->data);
        } else {
			$pData['idFraccionamiento'] = $this->input->post('idFraccionamiento', TRUE);
            $pData['titulo'] = $this->input->post('titulo', TRUE);
            $pData['status'] = 1;
            $id = $this->mrequisiciones->insertar($pData);
            redirect($this->router->class."/agregar/".$id);
        }
    }

    public function editar($id){
        // Mensajes
        $msg = '';
        /* VALIDAR FORMULARIO*/
        $this->load->library('form_validation');

        if (isset($_POST['titulo'])) {
            if ($this->form_validation->run($this->fv) == FALSE) {
                $msg = validation_errors();
            } else {
                $pData['idFraccionamiento'] = $this->input->post('idFraccionamiento', TRUE);
                $pData['titulo'] = $this->input->post('titulo', TRUE);
                $pData['status'] =$this->input->post('status',TRUE);

                $this->mrequisiciones->actualizar($pData, $id);
				redirect($this->router->class."/agregar/".$id);
            }
        }
        // Obteniendo la información
        $info = $this->mrequisiciones->getById($id);

        $data = $info;
        $data['msg']=$msg;
		$data["fraccionamientos"]=$this->getAllFraccionamientos(1);
        $this->data['contenido'] = $this->load->view($this->mainView . '/editar_view', $data, true);
        $this->load->view('templates/main_template', $this->data);
    }

	public function agregar($id){
        // Mensajes
		$data['msg']="";
		$this->data['js'] = ' 
		<script src="assets/js/requisicion/articulos.js" type="text/javascript"></script>
		<script src="assets/js/requisicion/agregar.js" type="text/javascript"></script>';
		$data=$this->mrequisiciones->getById($id);
		$data["manzanas"]=$this->getManzanas($data["idFraccionamiento"]);
		$this->data['contenido'] = $this->load->view($this->mainView . '/agregar_view', $data, true);
		$this->load->view('templates/main_template', $this->data);
    }

	public function addArticulo(){
		$data=[];
		$error=[];
		if( isset($_POST["idRequisicion"]) && isset($_POST["cantidad"]) && isset($_POST["articulo"]) && isset($_POST["ltemza"])){
			$idRequisicion=$_POST["idRequisicion"];
			$cantidad=$_POST["cantidad"];
			$articulo=$_POST["articulo"];
			$ltemza=$_POST["ltemza"];
			$solicitado=$this->getSolicitado([
				"idProyecto"=>$ltemza["idProyecto"],
				"idPaquete"=>$ltemza["idPaquete"],
				"idPresupuesto"=>$articulo["idPresupuesto"],
				"idRequisicion"=> $idRequisicion,
			],"=");
			$idMateriales=$this->mpresupuestomat->getCampo("idMateriales",$articulo["idPresupuesto"]);
			$cantidadPpto=$this->mmaterialesactividadprototipo->getCampo("cantidad",$idMateriales);
			if(floatval($solicitado) == 0){
				$acumulado=$this->getSolicitado([
					"idProyecto"=>$ltemza["idProyecto"],
					"idPaquete"=>$ltemza["idPaquete"],
					"idPresupuesto"=>$articulo["idPresupuesto"],
				]);
				if(($cantidadPpto-$acumulado) >= $cantidad){
					$data["idRequisicion"]=$idRequisicion;
					$data["idEmpresa"]=$ltemza["idEmpresa"];
					$data["idAlmacen"]=$ltemza["idAlmacen"];
					$data["idPaquete"]=$ltemza["idPaquete"];
					$data["idMaterial"]=$ltemza["idMaterial"];
					$data["idProyecto"]=$ltemza["idProyecto"];
					$data["idArticulo"]=$articulo["idArticulo"];
					$data["idPresupuesto"]=$articulo["idPresupuesto"];
					$data["cantidad"]=$cantidad;
					$id=$this->mrequisiciones_detalle->insertar($data);
				}else{
					$error="La cantidad excede el límite del presupuesto";
				}
			}else{
				$error="Ya existe el artículo en la requisición";
			}
		}
		echo json_encode(["data"=>$data,"error"=>$error]);
	}

	public function actualizarPpto(){
		$error="";
		if(isset($_POST["idRequisicionDet"]) && isset($_POST["cantidad"])){
			$idRequisicionDet=$_POST["idRequisicionDet"];
			$cantidad=$_POST["cantidad"];
			$data=$this->mrequisiciones_detalle->getById($idRequisicionDet);
			$idMateriales=$this->mpresupuestomat->getCampo("idMateriales",$data["idPresupuesto"]);
			$cantidadPpto=$this->mmaterialesactividadprototipo->getCampo("cantidad",$idMateriales);
			$acumulado=$this->getSolicitado([
				"idProyecto"=>$data["idProyecto"],
				"idPaquete"=>$data["idPaquete"],
				"idPresupuesto"=>$data["idPresupuesto"],
				"idRequisicion"=> $data["idRequisicion"],
			],"<>");
			if(($cantidadPpto-$acumulado) >= $cantidad){
				$this->mrequisiciones_detalle->actualizar(["cantidad"=>$cantidad],$idRequisicionDet);
			}else{
				$error="La cantidad excede el límite del presupuesto";
			}
			echo json_encode(["error"=>$error]);
		}
	}
    public function eliminarDetalle(){
        $id = $this->input->post('idRequisicionDet');
        $this->mrequisiciones_detalle->borrar($id);
		echo json_encode(["error"=>"ok"]);
    }

    public function eliminar(){
        $id = $this->input->post('elid');
        $q = $this->mrequisiciones->getById($id);
        $cValor = "true";
        $this->mrequisiciones->borrar($id);
        $data = json_encode(array("valor" => $cValor));
        echo $data;
    }

	//FUNCIONES ------
	public function getAllFraccionamientos($estatus=0){
		$rol=$_SESSION[$this->nsession]["rol"];
		$filter="";
		if($rol==18){
			$filter=" AND dp.idCoordinador=".$_SESSION[$this->nsession]["id"];
		}
		$query=$this->db->query("
		SELECT fr.id, fr.titulo FROM detalle_paquete dp
		LEFT JOIN paquetes paq ON paq.id=dp.idPaquete 
		LEFT JOIN arranque arr ON FIND_IN_SET(paq.id,arr.idPaquetes) 						
		LEFT JOIN proyectos pro ON pro.id=dp.idProyecto 
		LEFT JOIN fraccionamientos fr ON fr.id=pro.idFraccionamiento
		WHERE fr.status=$estatus AND arr.estatus_arranque=2 $filter
		GROUP BY fr.id ORDER BY fr.id DESC");
		return $query;
	}

	public function getManzanas($idFraccionamiento=0,$estatus=1){
		$rol=$_SESSION[$this->nsession]["rol"];
		$filter="";
		if($rol==18){
			$filter=" AND dp.idCoordinador=".$_SESSION[$this->nsession]["id"];
		}
		$query=$this->db->query("
		SELECT pro.manzana id, pro.manzana titulo FROM detalle_paquete dp
		LEFT JOIN paquetes paq ON paq.id=dp.idPaquete 
		LEFT JOIN arranque arr ON FIND_IN_SET(paq.id,arr.idPaquetes) 						
		LEFT JOIN proyectos pro ON pro.id=dp.idProyecto 
		LEFT JOIN fraccionamientos fr ON fr.id=pro.idFraccionamiento
		WHERE fr.status=$estatus AND arr.estatus_arranque=2 AND fr.id=$idFraccionamiento $filter
		GROUP BY pro.manzana ORDER BY pro.manzana+1 ASC");
		return $query;
	}

	public function getLotes($estatus=0){
		$rol=$_SESSION[$this->nsession]["rol"];
		$filter="";
		$query=0;
		if($rol==18){
			$filter=" AND dp.idCoordinador=".$_SESSION[$this->nsession]["id"];
		}
		if(isset($_POST["manzana"])){
			$manzana=$_POST["manzana"];
			$query="
			SELECT pro.id, pro.lote FROM detalle_paquete dp
			LEFT JOIN paquetes paq ON paq.id=dp.idPaquete 
			LEFT JOIN arranque arr ON FIND_IN_SET(paq.id,arr.idPaquetes) 						
			LEFT JOIN proyectos pro ON pro.id=dp.idProyecto 
			LEFT JOIN fraccionamientos fr ON fr.id=pro.idFraccionamiento
			WHERE fr.status=$estatus AND pro.manzana='$manzana' AND arr.estatus_arranque=2 $filter
			GROUP BY pro.lote ORDER BY pro.lote+1 ASC";
		}
		if(!is_numeric($query)){
			$query=$this->db->query($query);
			if($query->num_rows()>0){
				$query=$query->result();
			}
		}
		echo json_encode($query);
	}

	public function getLteMza(){
		$query=0;
		if(isset($_POST["idFraccionamiento"]) && isset($_POST["lote"]) && isset($_POST["manzana"])){
			$idFraccionamiento=$_POST["idFraccionamiento"];
			$lote=$_POST["lote"];
			$manzana=$_POST["manzana"];
			$query="SELECT dp.idProyecto,mat.idEmpresa,alm.id idAlmacen,dp.idPaquete,paq.titulo tituloPaquete,mat.id idMaterial FROM detalle_paquete dp
									LEFT JOIN paquetes paq ON paq.id=dp.idPaquete
									LEFT JOIN proyectos pro ON pro.id=dp.idProyecto 
									LEFT JOIN material mat ON mat.idPaquete=dp.idPaquete
									LEFT JOIN almacenes alm ON FIND_IN_SET(dp.idPaquete,alm.idPaquete) AND alm.idEmpresa=mat.idEmpresa
									WHERE pro.lote='$lote' AND pro.manzana='$manzana' AND pro.idFraccionamiento=$idFraccionamiento";
		}
		if(!is_numeric($query)){
			$query=$this->db->query($query);
			if($query->num_rows()>0){
				$query=$query->row();
			}
		}
		echo json_encode($query);
	}

	public function getCategorias(){
		$query=0;
		if(isset($_POST["idMaterial"])){
			$idMaterial=$_POST["idMaterial"];
			$query="SELECT pmat.clave_cat clave,cmat.categoria FROM presupuesto_mat pmat 
			LEFT JOIN categorias_mat cmat ON CONVERT(cmat.clave USING utf8) = CONVERT(pmat.clave_cat USING utf8)
			WHERE pmat.idMaterial=$idMaterial GROUP BY pmat.clave_cat";
		}
		if(!is_numeric($query)){
			$query=$this->db->query($query);
			if($query->num_rows()>0){
				$query=$query->result();
			}
		}
		echo json_encode($query);
	}

	public function getCantPptoByClaveCategoria(){
		$query=0;
		if(isset($_POST["idEmpresa"]) && isset($_POST["idPaquete"]) && isset($_POST["claveCategoria"])){
			$idEmpresa=$_POST["idEmpresa"];
			$idPaquete=$_POST["idPaquete"];
			$claveCategoria=$_POST["claveCategoria"];
			$cantidad="SUM(DISTINCT (mact.cantidad) + mact.id) - SUM(DISTINCT mact.id) cantidad";
			$query="SELECT mact.idMaterial idArticulo, mate.nombre, $cantidad, pmat.id idPresupuesto FROM presupuesto_mat pmat
									LEFT JOIN material mat ON mat.id=pmat.idMaterial
									LEFT JOIN materialesactividadprototipo mact ON mact.id=pmat.idMateriales
									LEFT JOIN materiales mate ON mate.id=mact.idMaterial AND mate.idEmpresa=$idEmpresa
									WHERE mat.idPaquete=$idPaquete AND mat.idEmpresa=$idEmpresa AND pmat.clave_cat='$claveCategoria'
									GROUP BY mact.idMaterial";
		}
		if(!is_numeric($query)){
			$query=$this->db->query($query);
			if($query->num_rows()>0){
				$query=$query->result();
			}
		}
		echo json_encode($query);
	}

}