<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Rejecutivo extends MX_Controller {
    public $data,$vParameters,$mainView,$fv;
    public function __construct(){
    $this->nsession = $this->config->item('nsession');
    if (!isset($_SESSION[$this->nsession]) || (($_SESSION[$this->nsession]['usuario'] == ""))) redirect('login');
            $this->fv = 'paquetes'; // form validation variable
            $this->mainView = 'paquetes';
            $this->data['fjs'] = '';
            $this->data['js'] = '';
            $this->data['css'] = '';
            // Tools
            $this->load->helper(array('tools','numeros','url','form','date','text','security'));
            // Modelos
            $this->load->model(array('mpaquete','musuario','mfraccionamiento','mprototipoxfraccionamiento','mprototipos','mconstructores', 'mestimacionprograma', 'mestimacionesprograma', 'mestimadosprograma', 'mmanoobra','mpresupuestomo', 'mmaterial', 'mpresupuestomat', 'mactividadesprototipo', 'mactividadmo', 'mavanceobra', 'mordenpago', 'mdetalleop', 'mcategoriamo', 'mproyecto', 'mdetallepaquete', 'mpaquetepresupuesto', 'munidades', 'msubcategoriamo', 'mmaterialesactividadprototipo', 'mmateriales', 'mproveedor', 'mroles', 'marranque'));

            $this->load->library('csvimport');
			$this->load->library('excel');

            $this->config->set_item('rol', $_SESSION[$this->nsession]['rol']);
            // Lbrerias
            // $this->load->library(array('email','session'));

           //Validación de usuarios
           $this->data['fotos_www'] = $this->config->item('base_www').'/paquetes/';
            valSession("obra",$this->fv);
    }

    public function index(){
        //COLOR DDEBF7
        $paquetes = $this->mpaquete->getAllByTipo();
        $paquetesExtra = $this->mpaquete->getAllByTipo(2);
        if(!is_numeric($paquetes)){
            $objPHPExcel = new PhpOffice\PhpSpreadsheet\Spreadsheet();
            $objPHPExcel->getActiveSheet()->setTitle('RESUMEN');
            $objPHPExcel->setActiveSheetIndex(0);
    
            //TITULOS PRINCIPALES
            $objPHPExcel->getActiveSheet()->SetCellValue("B4","Sali Edificaciones, S.A. de C.V.");
            $objPHPExcel->getActiveSheet()->SetCellValue("B5","Avance de Obra FRACC. MISIONES MIRAVALLE");
            //FONDO DE DE ENCABEZADOS
            $styleArray = array(
                'font' => array(
                    'size' => 13
                )
            );
            $objPHPExcel->getActiveSheet()->getStyle("B4")->applyFromArray($styleArray);
    
            //ENCABEADO DE LA TABLA DE RESUMEN
            $fInicioHeader=7;
            $fInicio=8;
            $cInicio="A";
            $cFinal="U";
            $objPHPExcel->getActiveSheet()->SetCellValue('I'.$fInicioHeader,"REAL");
            $objPHPExcel->getActiveSheet()->mergeCells('I'.$fInicioHeader.":J".$fInicioHeader);
            $objPHPExcel->getActiveSheet()->SetCellValue('L'.$fInicioHeader, 'CONTRATO');
            $objPHPExcel->getActiveSheet()->SetCellValue('M'.$fInicioHeader,"PAGO");
            $objPHPExcel->getActiveSheet()->mergeCells('M'.$fInicioHeader.":O".$fInicioHeader);
            $objPHPExcel->getActiveSheet()->SetCellValue('P'.$fInicioHeader,"POR EJECUTAR");
            $objPHPExcel->getActiveSheet()->mergeCells('P'.$fInicioHeader.":Q".$fInicioHeader);
            $objPHPExcel->getActiveSheet()->SetCellValue('R'.$fInicioHeader,"RETENCIONES");
            $objPHPExcel->getActiveSheet()->mergeCells('R'.$fInicioHeader.":U".$fInicioHeader);
            $objPHPExcel->getActiveSheet()->getColumnDimension('A')->setWidth(18);
            $objPHPExcel->getActiveSheet()->SetCellValue('A'.$fInicio, 'Fraccionamiento');
            $objPHPExcel->getActiveSheet()->getColumnDimension('B')->setWidth(15);
            $objPHPExcel->getActiveSheet()->SetCellValue('B'.$fInicio, 'Contratista');
            $objPHPExcel->getActiveSheet()->getColumnDimension('C')->setWidth(9);
            $objPHPExcel->getActiveSheet()->SetCellValue('C'.$fInicio, 'No. Viviendas');
            $objPHPExcel->getActiveSheet()->getColumnDimension('D')->setWidth(10);
            $objPHPExcel->getActiveSheet()->SetCellValue('D'.$fInicio, 'Manzanas');
            $objPHPExcel->getActiveSheet()->getColumnDimension('E')->setWidth(9);
            $objPHPExcel->getActiveSheet()->SetCellValue('E'.$fInicio, 'Lotes');
            $objPHPExcel->getActiveSheet()->getColumnDimension('F')->setWidth(12);
            $objPHPExcel->getActiveSheet()->SetCellValue('F'.$fInicio, 'Prototipo');
            $objPHPExcel->getActiveSheet()->getColumnDimension('G')->setWidth(7);
            $objPHPExcel->getActiveSheet()->SetCellValue('G'.$fInicio, 'No. Sistema');
            $objPHPExcel->getActiveSheet()->getColumnDimension('H')->setWidth(7);
            $objPHPExcel->getActiveSheet()->SetCellValue('H'.$fInicio, 'Ronda');
            $objPHPExcel->getActiveSheet()->getColumnDimension('I')->setWidth(9);
            $objPHPExcel->getActiveSheet()->SetCellValue('I'.$fInicio, 'Fecha Inicio');
            $objPHPExcel->getActiveSheet()->getColumnDimension('J')->setWidth(9);
            $objPHPExcel->getActiveSheet()->SetCellValue('J'.$fInicio, 'Fecha Final');
            $objPHPExcel->getActiveSheet()->getColumnDimension('K')->setWidth(9);
            $objPHPExcel->getActiveSheet()->SetCellValue('K'.$fInicio, 'Duracion');
            $objPHPExcel->getActiveSheet()->getColumnDimension('L')->setWidth(11);
            $objPHPExcel->getActiveSheet()->SetCellValue('L'.$fInicio, 'Contrato');
            $objPHPExcel->getActiveSheet()->getColumnDimension('M')->setWidth(7);
            $objPHPExcel->getActiveSheet()->SetCellValue('M'.$fInicio, 'No. Estim.');
            $objPHPExcel->getActiveSheet()->getColumnDimension('N')->setWidth(15);
            $objPHPExcel->getActiveSheet()->SetCellValue('N'.$fInicio, 'Pago Acumulado');
            $objPHPExcel->getActiveSheet()->getColumnDimension('O')->setWidth(5);
            $objPHPExcel->getActiveSheet()->SetCellValue('O'.$fInicio, '%');
            $objPHPExcel->getActiveSheet()->getColumnDimension('P')->setWidth(9);
            $objPHPExcel->getActiveSheet()->SetCellValue('P'.$fInicio, 'Pdte. por Ejecutar');
            $objPHPExcel->getActiveSheet()->getColumnDimension('Q')->setWidth(5);
            $objPHPExcel->getActiveSheet()->SetCellValue('Q'.$fInicio, '%');
            $objPHPExcel->getActiveSheet()->getColumnDimension('R')->setWidth(11);
            $objPHPExcel->getActiveSheet()->SetCellValue('R'.$fInicio, 'Retencion FG');
            $objPHPExcel->getActiveSheet()->getColumnDimension('S')->setWidth(5);
            $objPHPExcel->getActiveSheet()->SetCellValue('S'.$fInicio, '%');
            $objPHPExcel->getActiveSheet()->getColumnDimension('T')->setWidth(11);
            $objPHPExcel->getActiveSheet()->SetCellValue('T'.$fInicio, 'Retencion Otras');
            $objPHPExcel->getActiveSheet()->getColumnDimension('U')->setWidth(5);
            $objPHPExcel->getActiveSheet()->SetCellValue('U'.$fInicio, '%');
    
            //FONDO DE DE ENCABEZADOS
            $styleArray = array(
                'font' => array(
                    'size' => 9
                ),
                'borders' => array(
                    'allBorders' => array(
                        'borderStyle' => PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
                        'color' => array('rgb' => 'DDDDFF')
                    )
                ),
                'fill' => array(
                    'fillType' => PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID,
                    'color' => array('rgb' => 'DDEBF7')
                )
            );
            $objPHPExcel->getActiveSheet()->getStyle('I'.$fInicioHeader.":J".$fInicioHeader)->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->getStyle('I'.$fInicioHeader.":J".$fInicioHeader)->getAlignment()->applyFromArray(
                array(
                    'horizontal' => PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER,
                    'vertical' => PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER,
                )
            );
    
            $objPHPExcel->getActiveSheet()->getStyle('L'.$fInicioHeader.":U".$fInicioHeader)->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->getStyle('L'.$fInicioHeader.":U".$fInicioHeader)->getAlignment()->applyFromArray(
                array(
                    'horizontal' => PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER,
                    'vertical' => PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER,
                )
            );
    
            //FONDO DE TITULOS
            $styleArray = array(
                'font' => array(
                    'size' => 9
                ),
                'borders' => array(
                    'allBorders' => array(
                        'borderStyle' => PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
                        'color' => array('rgb' => 'DDEBF7')
                    )
                ),
                'fill' => array(
                    'fillType' => PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID,
                    'color' => array('rgb' => 'DDEBF7')
                )
            );
            $objPHPExcel->getActiveSheet()->getStyle($cInicio.$fInicio.":".$cFinal.$fInicio)->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->getStyle($cInicio.$fInicio.":".$cFinal.$fInicio)->getAlignment()->applyFromArray(
                array(
                    'horizontal' => PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER,
                    'vertical' => PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER,
                )
            );
            $objPHPExcel->getActiveSheet()->getStyle($cInicio.$fInicio.":".$cFinal.$fInicio)->getAlignment()->setWrapText(true);
    
            //ARMADO DEL CUERPO DE LA TABLA RESUMEN
            //VARIABLES GLOBALES
            $total=0;
            $totalViviendas=0;
            $totalContrato=0;
            $totalEstimaciones=0;
            $totalAcumulado=0;
            $totalPctjeAcumulado=0;
            $totalPdteEjecutar=0;
            $totalPctjePdteEjecutar=0;
            $totalRetencion=0;
            $totalPctjeRetencion=0;
            $totalOtros=0;
            $totalPctjeOtros=0;
            $fFinalBody=9;
            $fInicioBody=9;
            if(!is_numeric($paquetes)){
                foreach ($paquetes->result() as $row) {
                    $manoObra = $this->mmanoobra->getById($row->idManoObra);
                    $arranque = $this->marranque->getByIdPaquete($row->id);
                    $fraccionamiento=$this->mfraccionamiento->getCampo("titulo",$manoObra['idFraccionamiento']);
                    $contratista=$this->mconstructores->getCampo("CONCAT(nombre,' ',apellidoP,' ',apellidoM)", $row->idConstructor);
                    $prototipo=$this->mprototipos->getCampo("nombre",$this->mmanoobra->getCampo("idPrototipo",$row->idManoObra));
                    $nEs=$this->mprototipos->getCampo("nombre",$this->mmanoobra->getCampo("idPrototipo",$row->idManoObra));
                    $lotesManzanas=contarLotesManzanas($row->rango_lotes);
                    $manzanas=implode(", ",array_keys($lotesManzanas["arrayMzs"]));
                    $lotes = $lotesManzanas['lotes'];
                    $duracion=$this->mprototipos->getCampo("estimaciones",$this->mmanoobra->getCampo("idPrototipo",$row->idManoObra));
                    $estimP=$this->mordenpago->getEstimacionesByPaquete($row->id);
                    $totalUnitarioMO = $this->mpresupuestomo->getSumTotalUnitario($row->idManoObra);
                    $contrato="$".number_format($totalUnitarioMO * $lotesManzanas["total"],2);
                    $pdteEjecutar=($totalUnitarioMO * $lotesManzanas["total"]) - $estimP->acumulado;
                    $PctjeAcumulado=($estimP->acumulado > 0) ? ($estimP->acumulado * 100) / ($totalUnitarioMO * $lotesManzanas["total"]) : 0;
                    $PctjeEjecutar=($pdteEjecutar > 0) ? ($pdteEjecutar * 100) / ($totalUnitarioMO * $lotesManzanas["total"]) : 0;
                    $PctjeRetencion=($estimP->retencion > 0) ? ($estimP->retencion * 100) / ($totalUnitarioMO * $lotesManzanas["total"]) : 0;
                    $PctjeOtros=($estimP->otros > 0) ? ($estimP->otros * 100) / ($totalUnitarioMO * $lotesManzanas["total"]) : 0;
                    //TOTALES GLOBALES
                    $total++;
                    $totalViviendas+=$lotesManzanas["total"];
                    $totalContrato+=$totalUnitarioMO * $lotesManzanas["total"];
                    $totalEstimaciones+=$estimP->n;
                    $totalAcumulado+=$estimP->acumulado;
                    $totalPctjeAcumulado+=$PctjeAcumulado;
                    $totalPdteEjecutar+=$pdteEjecutar;
                    $totalPctjePdteEjecutar+=$PctjeEjecutar;
                    $totalRetencion+=$estimP->retencion;
                    $totalPctjeRetencion+=$PctjeRetencion;
                    $totalOtros+=$estimP->otros;
                    $totalPctjeOtros+=$PctjeOtros;
                    
                    $objPHPExcel->getActiveSheet()->SetCellValue('A'.$fFinalBody, $fraccionamiento);
                    $objPHPExcel->getActiveSheet()->SetCellValue('B'.$fFinalBody, $contratista);
                    $objPHPExcel->getActiveSheet()->SetCellValue('C'.$fFinalBody, $lotesManzanas["total"]);
                    $objPHPExcel->getActiveSheet()->SetCellValue('D'.$fFinalBody, $manzanas);
                    $objPHPExcel->getActiveSheet()->SetCellValue('E'.$fFinalBody, $lotes);
                    $objPHPExcel->getActiveSheet()->SetCellValue('F'.$fFinalBody, $prototipo);
                    $objPHPExcel->getActiveSheet()->SetCellValue('G'.$fFinalBody, $row->id);
                    $objPHPExcel->getActiveSheet()->SetCellValue('H'.$fFinalBody, (!is_numeric($arranque)) ? $arranque['ronda'] : '');
                    $objPHPExcel->getActiveSheet()->SetCellValue('I'.$fFinalBody, $row->fecha_inicio);
                    $objPHPExcel->getActiveSheet()->SetCellValue('J'.$fFinalBody, $row->fecha_fin);
                    $objPHPExcel->getActiveSheet()->SetCellValue('K'.$fFinalBody, $duracion." SEM.");
                    $objPHPExcel->getActiveSheet()->SetCellValue('L'.$fFinalBody, $contrato);
                    $objPHPExcel->getActiveSheet()->SetCellValue('M'.$fFinalBody, $estimP->n);
                    $objPHPExcel->getActiveSheet()->SetCellValue('N'.$fFinalBody, "$".number_format($estimP->acumulado,2));
                    $objPHPExcel->getActiveSheet()->SetCellValue('O'.$fFinalBody, round($PctjeAcumulado).'%');
                    $objPHPExcel->getActiveSheet()->SetCellValue('P'.$fFinalBody, "$".number_format($pdteEjecutar,2));
                    $objPHPExcel->getActiveSheet()->SetCellValue('Q'.$fFinalBody, round($PctjeEjecutar).'%');
                    $objPHPExcel->getActiveSheet()->SetCellValue('R'.$fFinalBody, "$".number_format($estimP->retencion,2));
                    $objPHPExcel->getActiveSheet()->SetCellValue('S'.$fFinalBody, round($PctjeRetencion).'%');
                    $objPHPExcel->getActiveSheet()->SetCellValue('T'.$fFinalBody, "$".number_format($estimP->otros,2));
                    $objPHPExcel->getActiveSheet()->SetCellValue('U'.$fFinalBody, round($PctjeOtros).'%');
                    $fFinalBody++;
                }
    
                $styleArray = array(
                    'font' => array(
                        'size' => 9
                    ),
                    'borders' => array(
                        'allBorders' => array(
                            'borderStyle' => PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
                            'color' => array('rgb' => 'DDEBF7')
                        )
                    )
                );
                $objPHPExcel->getActiveSheet()->getStyle($cInicio.$fInicioBody.":".$cFinal.$fFinalBody)->applyFromArray($styleArray);
                $objPHPExcel->getActiveSheet()->getStyle($cInicio.$fInicioBody.":".$cFinal.$fFinalBody)->getAlignment()->applyFromArray(
                    array(
                        'horizontal' => PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER,
                        'vertical' => PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER,
                    )
                );
                $objPHPExcel->getActiveSheet()->getStyle($cInicio.$fInicioBody.":".$cFinal.$fFinalBody)->getAlignment()->setWrapText(true);
            }
    
            //FOOTER DE LA TABLA DE RESUMEN
            $fInicioFooter=$fFinalBody;
            $objPHPExcel->getActiveSheet()->getColumnDimension('B')->setWidth(15);
            $objPHPExcel->getActiveSheet()->SetCellValue('B'.$fFinalBody, 'Total');
            $objPHPExcel->getActiveSheet()->getColumnDimension('C')->setWidth(9);
            $objPHPExcel->getActiveSheet()->SetCellValue('C'.$fFinalBody, $totalViviendas);
            $objPHPExcel->getActiveSheet()->getColumnDimension('D')->setWidth(10);
            $objPHPExcel->getActiveSheet()->SetCellValue('D'.$fFinalBody, '');
            $objPHPExcel->getActiveSheet()->getColumnDimension('E')->setWidth(9);
            $objPHPExcel->getActiveSheet()->SetCellValue('E'.$fFinalBody, '');
            $objPHPExcel->getActiveSheet()->getColumnDimension('F')->setWidth(12);
            $objPHPExcel->getActiveSheet()->SetCellValue('F'.$fFinalBody, '');
            $objPHPExcel->getActiveSheet()->getColumnDimension('G')->setWidth(7);
            $objPHPExcel->getActiveSheet()->SetCellValue('G'.$fFinalBody, '');
            $objPHPExcel->getActiveSheet()->getColumnDimension('H')->setWidth(7);
            $objPHPExcel->getActiveSheet()->SetCellValue('H'.$fFinalBody, '');
            $objPHPExcel->getActiveSheet()->getColumnDimension('I')->setWidth(9);
            $objPHPExcel->getActiveSheet()->SetCellValue('I'.$fFinalBody, '');
            $objPHPExcel->getActiveSheet()->getColumnDimension('J')->setWidth(9);
            $objPHPExcel->getActiveSheet()->SetCellValue('J'.$fFinalBody, '');
            $objPHPExcel->getActiveSheet()->getColumnDimension('K')->setWidth(9);
            $objPHPExcel->getActiveSheet()->SetCellValue('K'.$fFinalBody, '');
            $objPHPExcel->getActiveSheet()->getColumnDimension('L')->setWidth(9);
            $objPHPExcel->getActiveSheet()->SetCellValue('L'.$fFinalBody, "$".number_format($totalContrato,2));
            $objPHPExcel->getActiveSheet()->getColumnDimension('M')->setWidth(7);
            $objPHPExcel->getActiveSheet()->SetCellValue('M'.$fFinalBody, $totalEstimaciones);
            $objPHPExcel->getActiveSheet()->getColumnDimension('N')->setWidth(15);
            $objPHPExcel->getActiveSheet()->SetCellValue('N'.$fFinalBody, "$".number_format($totalAcumulado,2));
            $objPHPExcel->getActiveSheet()->getColumnDimension('O')->setWidth(5);
            $objPHPExcel->getActiveSheet()->SetCellValue('O'.$fFinalBody, round($totalPctjeAcumulado / $total)."%");
            $objPHPExcel->getActiveSheet()->getColumnDimension('P')->setWidth(9);
            $objPHPExcel->getActiveSheet()->SetCellValue('P'.$fFinalBody, "$".number_format($totalPdteEjecutar,2));
            $objPHPExcel->getActiveSheet()->getColumnDimension('Q')->setWidth(5);
            $objPHPExcel->getActiveSheet()->SetCellValue('Q'.$fFinalBody, round($totalPctjePdteEjecutar / $total)."%");
            $objPHPExcel->getActiveSheet()->getColumnDimension('R')->setWidth(11);
            $objPHPExcel->getActiveSheet()->SetCellValue('R'.$fFinalBody, "$".number_format($totalRetencion,2));
            $objPHPExcel->getActiveSheet()->getColumnDimension('S')->setWidth(5);
            $objPHPExcel->getActiveSheet()->SetCellValue('S'.$fFinalBody, round($totalPctjeRetencion / $total)."%");
            $objPHPExcel->getActiveSheet()->getColumnDimension('T')->setWidth(11);
            $objPHPExcel->getActiveSheet()->SetCellValue('T'.$fFinalBody, "$".number_format($totalOtros,2));
            $objPHPExcel->getActiveSheet()->getColumnDimension('U')->setWidth(5);
            $objPHPExcel->getActiveSheet()->SetCellValue('U'.$fFinalBody, round($totalPctjeOtros / $total)."%");
    
            $styleArray = array(
                'font' => array(
                    'size' => 9
                ),
                'borders' => array(
                    'allBorders' => array(
                        'borderStyle' => PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
                        'color' => array('rgb' => 'DDEBF7')
                    )
                ),
                'fill' => array(
                    'fillType' => PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID,
                    'color' => array('rgb' => 'DDEBF7')
                )
            );
            $objPHPExcel->getActiveSheet()->getStyle($cInicio.$fInicioFooter.":".$cFinal.$fFinalBody)->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->getStyle($cInicio.$fInicioFooter.":".$cFinal.$fFinalBody)->getAlignment()->applyFromArray(
                array(
                    'horizontal' => PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER,
                    'vertical' => PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER,
                )
            );
            $objPHPExcel->getActiveSheet()->getStyle($cInicio.$fInicioFooter.":".$cFinal.$fFinalBody)->getAlignment()->setWrapText(true);
    
            //ENCABEZADO DE LA TABLA EXTRAS------------------------
            $fInicioHeader2=$fFinalBody + 4;
            $fInicio2=$fInicioHeader2 + 1;
            $objPHPExcel->getActiveSheet()->SetCellValue('B'.$fInicioHeader2,"EXTRAS");
            $objPHPExcel->getActiveSheet()->SetCellValue('I'.$fInicioHeader2,"REAL");
            $objPHPExcel->getActiveSheet()->mergeCells('I'.$fInicioHeader2.":J".$fInicioHeader2);
            $objPHPExcel->getActiveSheet()->SetCellValue('L'.$fInicioHeader2, 'CONTRATO');
            $objPHPExcel->getActiveSheet()->SetCellValue('M'.$fInicioHeader2,"AVANCE");
            $objPHPExcel->getActiveSheet()->mergeCells('M'.$fInicioHeader2.":O".$fInicioHeader2);
            $objPHPExcel->getActiveSheet()->SetCellValue('P'.$fInicioHeader2,"POR EJECUTAR");
            $objPHPExcel->getActiveSheet()->mergeCells('P'.$fInicioHeader2.":Q".$fInicioHeader2);
            $objPHPExcel->getActiveSheet()->SetCellValue('R'.$fInicioHeader2,"RETENCIONES");
            $objPHPExcel->getActiveSheet()->mergeCells('R'.$fInicioHeader2.":U".$fInicioHeader2);
            $objPHPExcel->getActiveSheet()->getColumnDimension('A')->setWidth(18);
            $objPHPExcel->getActiveSheet()->SetCellValue('A'.$fInicio2, 'Fraccionamiento');
            $objPHPExcel->getActiveSheet()->getColumnDimension('B')->setWidth(15);
            $objPHPExcel->getActiveSheet()->SetCellValue('B'.$fInicio2, 'Contratista');
            $objPHPExcel->getActiveSheet()->getColumnDimension('C')->setWidth(9);
            $objPHPExcel->getActiveSheet()->SetCellValue('C'.$fInicio2, 'No. Viviendas');
            $objPHPExcel->getActiveSheet()->getColumnDimension('D')->setWidth(10);
            $objPHPExcel->getActiveSheet()->SetCellValue('D'.$fInicio2, 'Manzanas');
            $objPHPExcel->getActiveSheet()->getColumnDimension('E')->setWidth(9);
            $objPHPExcel->getActiveSheet()->SetCellValue('E'.$fInicio2, 'Lotes');
            $objPHPExcel->getActiveSheet()->getColumnDimension('F')->setWidth(12);
            $objPHPExcel->getActiveSheet()->SetCellValue('F'.$fInicio2, 'Prototipo');
            $objPHPExcel->getActiveSheet()->getColumnDimension('G')->setWidth(7);
            $objPHPExcel->getActiveSheet()->SetCellValue('G'.$fInicio2, 'No. Sistema');
            $objPHPExcel->getActiveSheet()->getColumnDimension('H')->setWidth(7);
            $objPHPExcel->getActiveSheet()->SetCellValue('H'.$fInicio2, 'Ronda');
            $objPHPExcel->getActiveSheet()->getColumnDimension('I')->setWidth(9);
            $objPHPExcel->getActiveSheet()->SetCellValue('I'.$fInicio2, 'Fecha Inicio');
            $objPHPExcel->getActiveSheet()->getColumnDimension('J')->setWidth(9);
            $objPHPExcel->getActiveSheet()->SetCellValue('J'.$fInicio2, 'Fecha Final');
            $objPHPExcel->getActiveSheet()->getColumnDimension('K')->setWidth(9);
            $objPHPExcel->getActiveSheet()->SetCellValue('K'.$fInicio2, 'Duracion');
            $objPHPExcel->getActiveSheet()->getColumnDimension('L')->setWidth(11);
            $objPHPExcel->getActiveSheet()->SetCellValue('L'.$fInicio2, 'Contrato');
            $objPHPExcel->getActiveSheet()->getColumnDimension('M')->setWidth(7);
            $objPHPExcel->getActiveSheet()->SetCellValue('M'.$fInicio2, 'No. Estim.');
            $objPHPExcel->getActiveSheet()->getColumnDimension('N')->setWidth(15);
            $objPHPExcel->getActiveSheet()->SetCellValue('N'.$fInicio2, 'Avance Acumulado');
            $objPHPExcel->getActiveSheet()->getColumnDimension('O')->setWidth(5);
            $objPHPExcel->getActiveSheet()->SetCellValue('O'.$fInicio2, '%');
            $objPHPExcel->getActiveSheet()->getColumnDimension('P')->setWidth(9);
            $objPHPExcel->getActiveSheet()->SetCellValue('P'.$fInicio2, 'Pdte. por Ejecutar');
            $objPHPExcel->getActiveSheet()->getColumnDimension('Q')->setWidth(5);
            $objPHPExcel->getActiveSheet()->SetCellValue('Q'.$fInicio2, '%');
            $objPHPExcel->getActiveSheet()->getColumnDimension('R')->setWidth(11);
            $objPHPExcel->getActiveSheet()->SetCellValue('R'.$fInicio2, 'Retencion FG');
            $objPHPExcel->getActiveSheet()->getColumnDimension('S')->setWidth(5);
            $objPHPExcel->getActiveSheet()->SetCellValue('S'.$fInicio2, '%');
            $objPHPExcel->getActiveSheet()->getColumnDimension('T')->setWidth(11);
            $objPHPExcel->getActiveSheet()->SetCellValue('T'.$fInicio2, 'Retencion Otras');
            $objPHPExcel->getActiveSheet()->getColumnDimension('U')->setWidth(5);
            $objPHPExcel->getActiveSheet()->SetCellValue('U'.$fInicio2, '%');
    
            //FONDO DE DE ENCABEZADOS
            $styleArray = array(
                'font' => array(
                    'size' => 9
                ),
                'borders' => array(
                    'allBorders' => array(
                        'borderStyle' => PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
                        'color' => array('rgb' => 'DDDDFF')
                    )
                ),
                'fill' => array(
                    'fillType' => PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID,
                    'color' => array('rgb' => 'DDEBF7')
                )
            );
    
            $styleAlignment=array(
                    'horizontal' => PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER,
                    'vertical' => PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER,
            );
    
            $objPHPExcel->getActiveSheet()->getStyle('B'.$fInicioHeader2)->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->getStyle('B'.$fInicioHeader2)->getAlignment()->applyFromArray($styleAlignment);
    
            $objPHPExcel->getActiveSheet()->getStyle('I'.$fInicioHeader2.":J".$fInicioHeader2)->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->getStyle('I'.$fInicioHeader2.":J".$fInicioHeader2)->getAlignment()->applyFromArray($styleAlignment);
    
            $objPHPExcel->getActiveSheet()->getStyle('L'.$fInicioHeader2.":U".$fInicioHeader2)->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->getStyle('L'.$fInicioHeader2.":U".$fInicioHeader2)->getAlignment()->applyFromArray($styleAlignment);
    
            //FONDO DE TITULOS
            $styleArray = array(
                'font' => array(
                    'size' => 9
                ),
                'borders' => array(
                    'allBorders' => array(
                        'borderStyle' => PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
                        'color' => array('rgb' => 'DDEBF7')
                    )
                ),
                'fill' => array(
                    'fillType' => PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID,
                    'color' => array('rgb' => 'DDEBF7')
                )
            );
            $objPHPExcel->getActiveSheet()->getStyle($cInicio.$fInicio2.":".$cFinal.$fInicio2)->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->getStyle($cInicio.$fInicio2.":".$cFinal.$fInicio2)->getAlignment()->applyFromArray(
                array(
                    'horizontal' => PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER,
                    'vertical' => PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER,
                )
            );
            $objPHPExcel->getActiveSheet()->getStyle($cInicio.$fInicio2.":".$cFinal.$fInicio2)->getAlignment()->setWrapText(true);
    
            //ARMADO DEL CUERPO DE LA TABLA EXTRAS
            //VARIABLES GLOBALES
            $total=0;
            $totalViviendas=0;
            $totalContrato=0;
            $totalEstimaciones=0;
            $totalAcumulado=0;
            $totalPctjeAcumulado=0;
            $totalPdteEjecutar=0;
            $totalPctjePdteEjecutar=0;
            $totalRetencion=0;
            $totalPctjeRetencion=0;
            $totalOtros=0;
            $totalPctjeOtros=0;
            $fFinalBody=$fInicio2 + 1;
            $fInicioBody=$fInicio2 + 1;
            if(!is_numeric($paquetesExtra)){
                foreach ($paquetesExtra->result() as $row) {
                    $manoObra = $this->mmanoobra->getById($row->idManoObra);
                    $fraccionamiento=$this->mfraccionamiento->getCampo("titulo",$manoObra['idFraccionamiento']);
                    $arranque2 = $this->marranque->getByIdPaquete($row->id);
                    $contratista=$this->mconstructores->getCampo("CONCAT(nombre,' ',apellidoP,' ',apellidoM)", $row->idConstructor);
                    $prototipo=$this->mprototipos->getCampo("nombre",$this->mmanoobra->getCampo("idPrototipo",$row->idManoObra));
                    $nEs=$this->mprototipos->getCampo("nombre",$this->mmanoobra->getCampo("idPrototipo",$row->idManoObra));
                    $lotesManzanas=contarLotesManzanas($row->rango_lotes);
                    $manzanas=implode(", ",array_keys($lotesManzanas["arrayMzs"]));
                    $lotes = $lotesManzanas['lotes'];
                    $duracion=$this->mprototipos->getCampo("estimaciones",$this->mmanoobra->getCampo("idPrototipo",$row->idManoObra));
                    $estimP=$this->mordenpago->getEstimacionesByPaquete($row->id);
                    $totalUnitarioMO = $this->mpresupuestomo->getSumTotalUnitario($row->idManoObra);
                    $contrato="$".number_format($totalUnitarioMO * $lotesManzanas["total"],2);
                    $pdteEjecutar=($totalUnitarioMO * $lotesManzanas["total"]) - $estimP->acumulado;
                    $PctjeAcumulado=($estimP->acumulado * 100) / ($totalUnitarioMO * $lotesManzanas["total"]);
                    $PctjeEjecutar=($pdteEjecutar * 100) / ($totalUnitarioMO * $lotesManzanas["total"]);
                    $PctjeRetencion=($estimP->retencion * 100) / ($totalUnitarioMO * $lotesManzanas["total"]);
                    $PctjeOtros=($estimP->otros * 100) / ($totalUnitarioMO * $lotesManzanas["total"]);
                    //TOTALES GLOBALES
                    $total++;
                    $totalViviendas+=$lotesManzanas["total"];
                    $totalContrato+=$totalUnitarioMO * $lotesManzanas["total"];
                    $totalEstimaciones+=$estimP->n;
                    $totalAcumulado+=$estimP->acumulado;
                    $totalPctjeAcumulado+=$PctjeAcumulado;
                    $totalPdteEjecutar+=$pdteEjecutar;
                    $totalPctjePdteEjecutar+=$PctjeEjecutar;
                    $totalRetencion+=$estimP->retencion;
                    $totalPctjeRetencion+=$PctjeRetencion;
                    $totalOtros+=$estimP->otros;
                    $totalPctjeOtros+=$PctjeOtros;
    
                    $objPHPExcel->getActiveSheet()->SetCellValue('A'.$fFinalBody, $fraccionamiento);
                    $objPHPExcel->getActiveSheet()->SetCellValue('B'.$fFinalBody, $contratista);
                    $objPHPExcel->getActiveSheet()->SetCellValue('C'.$fFinalBody, $lotesManzanas["total"]);
                    $objPHPExcel->getActiveSheet()->SetCellValue('D'.$fFinalBody, $manzanas);
                    $objPHPExcel->getActiveSheet()->SetCellValue('E'.$fFinalBody, $lotes);
                    $objPHPExcel->getActiveSheet()->SetCellValue('F'.$fFinalBody, $prototipo);
                    $objPHPExcel->getActiveSheet()->SetCellValue('G'.$fFinalBody, $row->id);
                    $objPHPExcel->getActiveSheet()->SetCellValue('H'.$fFinalBody, (!is_numeric($arranque2)) ? $arranque2['ronda'] : '');
                    $objPHPExcel->getActiveSheet()->SetCellValue('I'.$fFinalBody, $row->fecha_inicio);
                    $objPHPExcel->getActiveSheet()->SetCellValue('J'.$fFinalBody, $row->fecha_fin);
                    $objPHPExcel->getActiveSheet()->SetCellValue('K'.$fFinalBody, $duracion." SEM.");
                    $objPHPExcel->getActiveSheet()->SetCellValue('L'.$fFinalBody, $contrato);
                    $objPHPExcel->getActiveSheet()->SetCellValue('M'.$fFinalBody, $estimP->n);
                    $objPHPExcel->getActiveSheet()->SetCellValue('N'.$fFinalBody, "$".number_format($estimP->acumulado,2));
                    $objPHPExcel->getActiveSheet()->SetCellValue('O'.$fFinalBody, round($PctjeAcumulado).'%');
                    $objPHPExcel->getActiveSheet()->SetCellValue('P'.$fFinalBody, "$".number_format($pdteEjecutar,2));
                    $objPHPExcel->getActiveSheet()->SetCellValue('Q'.$fFinalBody, round($PctjeEjecutar).'%');
                    $objPHPExcel->getActiveSheet()->SetCellValue('R'.$fFinalBody, "$".number_format($estimP->retencion,2));
                    $objPHPExcel->getActiveSheet()->SetCellValue('S'.$fFinalBody, round($PctjeRetencion).'%');
                    $objPHPExcel->getActiveSheet()->SetCellValue('T'.$fFinalBody, "$".number_format($estimP->otros,2));
                    $objPHPExcel->getActiveSheet()->SetCellValue('U'.$fFinalBody, round($PctjeOtros).'%');
                    $fFinalBody++;
                }
    
                $styleArray = array(
                    'font' => array(
                        'size' => 9
                    ),
                    'borders' => array(
                        'allBorders' => array(
                            'borderStyle' => PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
                            'color' => array('rgb' => 'DDEBF7')
                        )
                    )
                );
                $objPHPExcel->getActiveSheet()->getStyle($cInicio.$fInicioBody.":".$cFinal.$fFinalBody)->applyFromArray($styleArray);
                $objPHPExcel->getActiveSheet()->getStyle($cInicio.$fInicioBody.":".$cFinal.$fFinalBody)->getAlignment()->applyFromArray(
                    array(
                        'horizontal' => PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER,
                        'vertical' => PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER,
                    )
                );
                $objPHPExcel->getActiveSheet()->getStyle($cInicio.$fInicioBody.":".$cFinal.$fFinalBody)->getAlignment()->setWrapText(true);
            }
    
            //FOOTER DE LA TABLA DE EXTRAS
            $fInicioFooter=$fFinalBody;
            $objPHPExcel->getActiveSheet()->getColumnDimension('B')->setWidth(15);
            $objPHPExcel->getActiveSheet()->SetCellValue('B'.$fFinalBody, 'Total');
            $objPHPExcel->getActiveSheet()->getColumnDimension('C')->setWidth(9);
            $objPHPExcel->getActiveSheet()->SetCellValue('C'.$fFinalBody, $totalViviendas);
            $objPHPExcel->getActiveSheet()->getColumnDimension('D')->setWidth(10);
            $objPHPExcel->getActiveSheet()->SetCellValue('D'.$fFinalBody, '');
            $objPHPExcel->getActiveSheet()->getColumnDimension('E')->setWidth(9);
            $objPHPExcel->getActiveSheet()->SetCellValue('E'.$fFinalBody, '');
            $objPHPExcel->getActiveSheet()->getColumnDimension('F')->setWidth(12);
            $objPHPExcel->getActiveSheet()->SetCellValue('F'.$fFinalBody, '');
            $objPHPExcel->getActiveSheet()->getColumnDimension('G')->setWidth(7);
            $objPHPExcel->getActiveSheet()->SetCellValue('G'.$fFinalBody, '');
            $objPHPExcel->getActiveSheet()->getColumnDimension('H')->setWidth(7);
            $objPHPExcel->getActiveSheet()->SetCellValue('H'.$fFinalBody, '');
            $objPHPExcel->getActiveSheet()->getColumnDimension('I')->setWidth(9);
            $objPHPExcel->getActiveSheet()->SetCellValue('I'.$fFinalBody, '');
            $objPHPExcel->getActiveSheet()->getColumnDimension('J')->setWidth(9);
            $objPHPExcel->getActiveSheet()->SetCellValue('J'.$fFinalBody, '');
            $objPHPExcel->getActiveSheet()->getColumnDimension('K')->setWidth(9);
            $objPHPExcel->getActiveSheet()->SetCellValue('K'.$fFinalBody, '');
            $objPHPExcel->getActiveSheet()->getColumnDimension('L')->setWidth(9);
            $objPHPExcel->getActiveSheet()->SetCellValue('L'.$fFinalBody, "$".number_format($totalContrato,2));
            $objPHPExcel->getActiveSheet()->getColumnDimension('M')->setWidth(7);
            $objPHPExcel->getActiveSheet()->SetCellValue('M'.$fFinalBody, $totalEstimaciones);
            $objPHPExcel->getActiveSheet()->getColumnDimension('N')->setWidth(15);
            $objPHPExcel->getActiveSheet()->SetCellValue('N'.$fFinalBody, "$".number_format($totalAcumulado,2));
            $objPHPExcel->getActiveSheet()->getColumnDimension('O')->setWidth(5);
            $objPHPExcel->getActiveSheet()->SetCellValue('O'.$fFinalBody, ($total > 0)  ? round($totalPctjeAcumulado / $total)."%" : '0%');
            $objPHPExcel->getActiveSheet()->getColumnDimension('P')->setWidth(9);
            $objPHPExcel->getActiveSheet()->SetCellValue('P'.$fFinalBody, "$".number_format($totalPdteEjecutar,2));
            $objPHPExcel->getActiveSheet()->getColumnDimension('Q')->setWidth(5);
            $objPHPExcel->getActiveSheet()->SetCellValue('Q'.$fFinalBody, ($total > 0)  ?  round($totalPctjePdteEjecutar / $total)."%" : '0%');
            $objPHPExcel->getActiveSheet()->getColumnDimension('R')->setWidth(11);
            $objPHPExcel->getActiveSheet()->SetCellValue('R'.$fFinalBody, "$".number_format($totalRetencion,2));
            $objPHPExcel->getActiveSheet()->getColumnDimension('S')->setWidth(5);
            $objPHPExcel->getActiveSheet()->SetCellValue('S'.$fFinalBody, ($total > 0)  ? round($totalPctjeRetencion / $total)."%" : '0%');
            $objPHPExcel->getActiveSheet()->getColumnDimension('T')->setWidth(11);
            $objPHPExcel->getActiveSheet()->SetCellValue('T'.$fFinalBody, "$".number_format($totalOtros,2));
            $objPHPExcel->getActiveSheet()->getColumnDimension('U')->setWidth(5);
            $objPHPExcel->getActiveSheet()->SetCellValue('U'.$fFinalBody, ($total > 0)  ? round($totalPctjeOtros / $total)."%" : '0%');
    
            $styleArray = array(
                'font' => array(
                    'size' => 9
                ),
                'borders' => array(
                    'allBorders' => array(
                        'borderStyle' => PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
                        'color' => array('rgb' => 'DDEBF7')
                    )
                ),
                'fill' => array(
                    'fillType' => PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID,
                    'color' => array('rgb' => 'DDEBF7')
                )
            );
            $objPHPExcel->getActiveSheet()->getStyle($cInicio.$fInicioFooter.":".$cFinal.$fFinalBody)->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->getStyle($cInicio.$fInicioFooter.":".$cFinal.$fFinalBody)->getAlignment()->applyFromArray(
                array(
                    'horizontal' => PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER,
                    'vertical' => PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER,
                )
            );
            $objPHPExcel->getActiveSheet()->getStyle($cInicio.$fInicioFooter.":".$cFinal.$fFinalBody)->getAlignment()->setWrapText(true);
    
            //ENCABEZADO DE LA TABLA ESTIMACIONES
            $fInicioHeader=7;
            $fInicio=8;
            $cInicio="W";
            $cFinal="Z";
            $objPHPExcel->getActiveSheet()->mergeCells('X'.$fInicioHeader.':Z'.$fInicioHeader);
            $objPHPExcel->getActiveSheet()->SetCellValue('X'.$fInicioHeader, 'Estimación');
            $objPHPExcel->getActiveSheet()->getColumnDimension('W')->setWidth(15);
            $objPHPExcel->getActiveSheet()->SetCellValue('W'.$fInicio, 'Contratista');
            $objPHPExcel->getActiveSheet()->getColumnDimension('X')->setWidth(9);
            $objPHPExcel->getActiveSheet()->SetCellValue('X'.$fInicio, 'Estimacion');
            $objPHPExcel->getActiveSheet()->getColumnDimension('Y')->setWidth(9);
            $objPHPExcel->getActiveSheet()->SetCellValue('Y'.$fInicio, 'Retencion');
            $objPHPExcel->getActiveSheet()->getColumnDimension('Z')->setWidth(9);
            $objPHPExcel->getActiveSheet()->SetCellValue('Z'.$fInicio, 'Neto');
            
            //FONDO DE DE ENCABEZADOS
            $styleArray = array(
                'font' => array(
                    'size' => 9
                ),
                'borders' => array(
                    'allBorders' => array(
                        'borderStyle' => PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
                        'color' => array('rgb' => 'DDDDFF')
                    )
                ),
                'fill' => array(
                    'fillType' => PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID,
                    'color' => array('rgb' => 'DDEBF7')
                )
            );
            $objPHPExcel->getActiveSheet()->getStyle('X'.$fInicioHeader.":Z".$fInicioHeader)->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->getStyle('X'.$fInicioHeader.":Z".$fInicioHeader)->getAlignment()->applyFromArray(
                array(
                    'horizontal' => PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER,
                    'vertical' => PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER,
                )
            );
    
            $objPHPExcel->getActiveSheet()->getStyle('L'.$fInicioHeader.":U".$fInicioHeader)->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->getStyle('L'.$fInicioHeader.":U".$fInicioHeader)->getAlignment()->applyFromArray(
                array(
                    'horizontal' => PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER,
                    'vertical' => PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER,
                )
            );
    
            //FONDO DE TITULOS
            $styleArray = array(
                'font' => array(
                    'size' => 9
                ),
                'borders' => array(
                    'allBorders' => array(
                        'borderStyle' => PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
                        'color' => array('rgb' => 'DDEBF7')
                    )
                ),
                'fill' => array(
                    'fillType' => PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID,
                    'color' => array('rgb' => 'DDEBF7')
                )
            );
            $objPHPExcel->getActiveSheet()->getStyle($cInicio.$fInicio.":".$cFinal.$fInicio)->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->getStyle($cInicio.$fInicio.":".$cFinal.$fInicio)->getAlignment()->applyFromArray(
                array(
                    'horizontal' => PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER,
                    'vertical' => PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER,
                )
            );
            $objPHPExcel->getActiveSheet()->getStyle($cInicio.$fInicio.":".$cFinal.$fInicio)->getAlignment()->setWrapText(true);
    
            //ARMADO DEL CUERPO DE LA TABLA ESTIMACIONES-------------------------------------
            //VARIABLES GLOBALES
            $total=0;
            $totalEstimacion=0;
            $totalRetencion=0;
            $totalNeto=0;
            $fFinalBody=9;
            $fInicioBody=9;
            if(!is_numeric($paquetes)){
                foreach ($paquetes->result() as $row) {
                    //$estim=$this->mordenpago->getResumenEstimacionesByPaquete($row->id);
                    $estim=$this->mordenpago->getActualOrdenPago($row->id);
                    $contratista=$this->mconstructores->getCampo("CONCAT(nombre,' ',apellidoP,' ',apellidoM)", $row->idConstructor);
    
                    $totalEstimacion+=$estim->estimacion;
                    $totalRetencion+=$estim->retencion;
                    $totalNeto+=$estim->estimacion - $estim->retencion;
    
                    $objPHPExcel->getActiveSheet()->SetCellValue('W'.$fFinalBody, $contratista);
                    $objPHPExcel->getActiveSheet()->SetCellValue('X'.$fFinalBody, "$".number_format($estim->estimacion,2));
                    $objPHPExcel->getActiveSheet()->SetCellValue('Y'.$fFinalBody, "$".number_format($estim->retencion,2));
                    $objPHPExcel->getActiveSheet()->SetCellValue('Z'.$fFinalBody, "$".number_format($estim->estimacion - $estim->retencion,2));
                    $fFinalBody++;
                }
    
                $styleArray = array(
                    'font' => array(
                        'size' => 9
                    ),
                    'borders' => array(
                        'allBorders' => array(
                            'borderStyle' => PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
                            'color' => array('rgb' => 'DDEBF7')
                        )
                    )
                );
                $objPHPExcel->getActiveSheet()->getStyle($cInicio.$fInicioBody.":".$cFinal.$fFinalBody)->applyFromArray($styleArray);
                $objPHPExcel->getActiveSheet()->getStyle($cInicio.$fInicioBody.":".$cFinal.$fFinalBody)->getAlignment()->applyFromArray(
                    array(
                        'horizontal' => PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER,
                        'vertical' => PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER,
                    )
                );
                $objPHPExcel->getActiveSheet()->getStyle($cInicio.$fInicioBody.":".$cFinal.$fFinalBody)->getAlignment()->setWrapText(true);
            }
    
            //FOOTER DE LA TABLA DE ESTIMACIONES
            $fInicioFooter=$fFinalBody;
            $objPHPExcel->getActiveSheet()->getColumnDimension('W')->setWidth(15);
            $objPHPExcel->getActiveSheet()->SetCellValue('W'.$fFinalBody, 'Total');
            $objPHPExcel->getActiveSheet()->getColumnDimension('X')->setWidth(10);
            $objPHPExcel->getActiveSheet()->SetCellValue('X'.$fFinalBody, "$".number_format($totalEstimacion,2));
            $objPHPExcel->getActiveSheet()->getColumnDimension('Y')->setWidth(11);
            $objPHPExcel->getActiveSheet()->SetCellValue('Y'.$fFinalBody, "$".number_format($totalRetencion,2));
            $objPHPExcel->getActiveSheet()->getColumnDimension('Z')->setWidth(10);
            $objPHPExcel->getActiveSheet()->SetCellValue('Z'.$fFinalBody, "$".number_format($totalNeto,2));
            $styleArray = array(
                'font' => array(
                    'size' => 9
                ),
                'borders' => array(
                    'allBorders' => array(
                        'borderStyle' => PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
                        'color' => array('rgb' => 'DDEBF7')
                    )
                ),
                'fill' => array(
                    'fillType' => PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID,
                    'color' => array('rgb' => 'DDEBF7')
                )
            );
            $objPHPExcel->getActiveSheet()->getStyle($cInicio.$fInicioFooter.":".$cFinal.$fFinalBody)->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->getStyle($cInicio.$fInicioFooter.":".$cFinal.$fFinalBody)->getAlignment()->applyFromArray(
                array(
                    'horizontal' => PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER,
                    'vertical' => PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER,
                )
            );
            $objPHPExcel->getActiveSheet()->getStyle($cInicio.$fInicioFooter.":".$cFinal.$fFinalBody)->getAlignment()->setWrapText(true);
    
            //ENCABEZADO DE LA TABLA ESTIMACIONES EXTRA
            $fInicioHeader=$fFinalBody+4;
            $fInicio=$fInicioHeader+1;
            $cInicio="W";
            $cFinal="Z";
            $objPHPExcel->getActiveSheet()->mergeCells('X'.$fInicioHeader.':Z'.$fInicioHeader);
            $objPHPExcel->getActiveSheet()->SetCellValue('X'.$fInicioHeader, 'Estimación');
            $objPHPExcel->getActiveSheet()->getColumnDimension('W')->setWidth(15);
            $objPHPExcel->getActiveSheet()->SetCellValue('W'.$fInicio, 'Contratista');
            $objPHPExcel->getActiveSheet()->getColumnDimension('X')->setWidth(9);
            $objPHPExcel->getActiveSheet()->SetCellValue('X'.$fInicio, 'Estimacion');
            $objPHPExcel->getActiveSheet()->getColumnDimension('Y')->setWidth(9);
            $objPHPExcel->getActiveSheet()->SetCellValue('Y'.$fInicio, 'Retencion');
            $objPHPExcel->getActiveSheet()->getColumnDimension('Z')->setWidth(9);
            $objPHPExcel->getActiveSheet()->SetCellValue('Z'.$fInicio, 'Neto');
    
            //FONDO DE DE ENCABEZADOS
            $styleArray = array(
                'font' => array(
                    'size' => 9
                ),
                'borders' => array(
                    'allBorders' => array(
                        'borderStyle' => PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
                        'color' => array('rgb' => 'DDDDFF')
                    )
                ),
                'fill' => array(
                    'fillType' => PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID,
                    'color' => array('rgb' => 'DDEBF7')
                )
            );
            $objPHPExcel->getActiveSheet()->getStyle('X'.$fInicioHeader.":Z".$fInicioHeader)->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->getStyle('X'.$fInicioHeader.":Z".$fInicioHeader)->getAlignment()->applyFromArray(
                array(
                    'horizontal' => PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER,
                    'vertical' => PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER,
                )
            );
    
            $objPHPExcel->getActiveSheet()->getStyle('L'.$fInicioHeader.":U".$fInicioHeader)->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->getStyle('L'.$fInicioHeader.":U".$fInicioHeader)->getAlignment()->applyFromArray(
                array(
                    'horizontal' => PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER,
                    'vertical' => PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER,
                )
            );
    
            //FONDO DE TITULOS
            $styleArray = array(
                'font' => array(
                    'size' => 9
                ),
                'borders' => array(
                    'allBorders' => array(
                        'borderStyle' => PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
                        'color' => array('rgb' => 'DDEBF7')
                    )
                ),
                'fill' => array(
                    'fillType' => PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID,
                    'color' => array('rgb' => 'DDEBF7')
                )
            );
            $objPHPExcel->getActiveSheet()->getStyle($cInicio.$fInicio.":".$cFinal.$fInicio)->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->getStyle($cInicio.$fInicio.":".$cFinal.$fInicio)->getAlignment()->applyFromArray(
                array(
                    'horizontal' => PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER,
                    'vertical' => PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER,
                )
            );
            $objPHPExcel->getActiveSheet()->getStyle($cInicio.$fInicio.":".$cFinal.$fInicio)->getAlignment()->setWrapText(true);
    
            //ARMADO DEL CUERPO DE LA TABLA ESTIMACIONES EXTRA-------------------------------------
            //VARIABLES GLOBALES
            $total=0;
            $totalEstimacion=0;
            $totalRetencion=0;
            $totalNeto=0;
            $fFinalBody=$fInicio+1;
            $fInicioBody=$fInicio+1;
            if(!is_numeric($paquetesExtra)){
                foreach ($paquetesExtra->result() as $row) {
                    //$estim=$this->mordenpago->getResumenEstimacionesByPaquete($row->id);
                    $estim=$this->mordenpago->getActualOrdenPago($row->id);
                    $contratista=$this->mconstructores->getCampo("CONCAT(nombre,' ',apellidoP,' ',apellidoM)", $row->idConstructor);
    
                    $totalEstimacion+=$estim->estimacion;
                    $totalRetencion+=$estim->retencion;
                    $totalNeto+=$estim->estimacion - $estim->retencion;
    
                    $objPHPExcel->getActiveSheet()->SetCellValue('W'.$fFinalBody, $contratista);
                    $objPHPExcel->getActiveSheet()->SetCellValue('X'.$fFinalBody, "$".number_format($estim->estimacion,2));
                    $objPHPExcel->getActiveSheet()->SetCellValue('Y'.$fFinalBody, "$".number_format($estim->retencion,2));
                    $objPHPExcel->getActiveSheet()->SetCellValue('Z'.$fFinalBody, "$".number_format($estim->estimacion - $estim->retencion,2));
                    $fFinalBody++;
                }
    
                $styleArray = array(
                    'font' => array(
                        'size' => 9
                    ),
                    'borders' => array(
                        'allBorders' => array(
                            'borderStyle' => PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
                            'color' => array('rgb' => 'DDEBF7')
                        )
                    )
                );
                $objPHPExcel->getActiveSheet()->getStyle($cInicio.$fInicioBody.":".$cFinal.$fFinalBody)->applyFromArray($styleArray);
                $objPHPExcel->getActiveSheet()->getStyle($cInicio.$fInicioBody.":".$cFinal.$fFinalBody)->getAlignment()->applyFromArray(
                    array(
                        'horizontal' => PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER,
                        'vertical' => PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER,
                    )
                );
                $objPHPExcel->getActiveSheet()->getStyle($cInicio.$fInicioBody.":".$cFinal.$fFinalBody)->getAlignment()->setWrapText(true);
            }
    
            //FOOTER DE LA TABLA DE ESTIMACIONES EXTRA
            $fInicioFooter=$fFinalBody;
            $objPHPExcel->getActiveSheet()->getColumnDimension('W')->setWidth(15);
            $objPHPExcel->getActiveSheet()->SetCellValue('W'.$fFinalBody, 'Total');
            $objPHPExcel->getActiveSheet()->getColumnDimension('X')->setWidth(10);
            $objPHPExcel->getActiveSheet()->SetCellValue('X'.$fFinalBody, "$".number_format($totalEstimacion,2));
            $objPHPExcel->getActiveSheet()->getColumnDimension('Y')->setWidth(11);
            $objPHPExcel->getActiveSheet()->SetCellValue('Y'.$fFinalBody, "$".number_format($totalRetencion,2));
            $objPHPExcel->getActiveSheet()->getColumnDimension('Z')->setWidth(10);
            $objPHPExcel->getActiveSheet()->SetCellValue('Z'.$fFinalBody, "$".number_format($totalNeto,2));
            $styleArray = array(
                'font' => array(
                    'size' => 9
                ),
                'borders' => array(
                    'allBorders' => array(
                        'borderStyle' => PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
                        'color' => array('rgb' => 'DDEBF7')
                    )
                ),
                'fill' => array(
                    'fillType' => PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID,
                    'color' => array('rgb' => 'DDEBF7')
                )
            );
            $objPHPExcel->getActiveSheet()->getStyle($cInicio.$fInicioFooter.":".$cFinal.$fFinalBody)->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->getStyle($cInicio.$fInicioFooter.":".$cFinal.$fFinalBody)->getAlignment()->applyFromArray(
                array(
                    'horizontal' => PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER,
                    'vertical' => PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER,
                )
            );
            $objPHPExcel->getActiveSheet()->getStyle($cInicio.$fInicioFooter.":".$cFinal.$fFinalBody)->getAlignment()->setWrapText(true);
    
    
            //ENCABEZADO DE LA TABLA ESTIMACIONES TOTALES
            $fInicioHeader=$fFinalBody+4;
            $fInicio=$fInicioHeader+1;
            $cInicio="W";
            $cFinal="Z";
            $objPHPExcel->getActiveSheet()->SetCellValue('T'.$fInicio, 'Retencion FG');
            $objPHPExcel->getActiveSheet()->mergeCells('X'.$fInicioHeader.':Z'.$fInicioHeader);
            $objPHPExcel->getActiveSheet()->SetCellValue('X'.$fInicioHeader, 'Estimacion--');
            $objPHPExcel->getActiveSheet()->getColumnDimension('W')->setWidth(15);
            $objPHPExcel->getActiveSheet()->SetCellValue('W'.$fInicio, 'Contratista');
            $objPHPExcel->getActiveSheet()->getColumnDimension('X')->setWidth(9);
            $objPHPExcel->getActiveSheet()->SetCellValue('X'.$fInicio, 'Estimacion');
            $objPHPExcel->getActiveSheet()->getColumnDimension('Y')->setWidth(9);
            $objPHPExcel->getActiveSheet()->SetCellValue('Y'.$fInicio, 'Retencion');
            $objPHPExcel->getActiveSheet()->getColumnDimension('Z')->setWidth(9);
            $objPHPExcel->getActiveSheet()->SetCellValue('Z'.$fInicio, 'Neto');
    
            //FONDO DE DE ENCABEZADOS
            $styleArray = array(
                'font' => array(
                    'size' => 9
                ),
                'borders' => array(
                    'allBorders' => array(
                        'borderStyle' => PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
                        'color' => array('rgb' => 'DDDDFF')
                    )
                ),
                'fill' => array(
                    'fillType' => PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID,
                    'color' => array('rgb' => 'DDEBF7')
                )
            );
            //PINTANDO FONDO
            $objPHPExcel->getActiveSheet()->getStyle('T'.$fInicio)->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->getStyle('T'.$fInicio)->getAlignment()->applyFromArray(
                array(
                    'horizontal' => PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER,
                    'vertical' => PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER,
                )
            );
    
            $objPHPExcel->getActiveSheet()->getStyle('X'.$fInicioHeader.":Z".$fInicioHeader)->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->getStyle('X'.$fInicioHeader.":Z".$fInicioHeader)->getAlignment()->applyFromArray(
                array(
                    'horizontal' => PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER,
                    'vertical' => PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER,
                )
            );
    
            //FONDO DE TITULOS
            $styleArray = array(
                'font' => array(
                    'size' => 9
                ),
                'borders' => array(
                    'allBorders' => array(
                        'borderStyle' => PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
                        'color' => array('rgb' => 'DDEBF7')
                    )
                ),
                'fill' => array(
                    'fillType' => PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID,
                    'color' => array('rgb' => 'DDEBF7')
                )
            );
            $objPHPExcel->getActiveSheet()->getStyle($cInicio.$fInicio.":".$cFinal.$fInicio)->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->getStyle($cInicio.$fInicio.":".$cFinal.$fInicio)->getAlignment()->applyFromArray(
                array(
                    'horizontal' => PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER,
                    'vertical' => PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER,
                )
            );
            $objPHPExcel->getActiveSheet()->getStyle($cInicio.$fInicio.":".$cFinal.$fInicio)->getAlignment()->setWrapText(true);
    
            //ARMADO DEL CUERPO DE LA TABLA ESTIMACIONES TOTALES-------------------------------------
            //VARIABLES GLOBALES
            $total=0;
            $totalRetencionFG=0;
            $totalEstimacion=0;
            $totalRetencion=0;
            $totalNeto=0;
            $fFinalBody=$fInicio+1;
            $fInicioBody=$fInicio+1;
            $contratistas=$this->mordenpago->getResumenEstimacionesByContratista();
            if(!is_numeric($contratistas)){
                foreach ($contratistas->result() as $row) {
                    $contratista=$this->mconstructores->getCampo("CONCAT(nombre,' ',apellidoP,' ',apellidoM)", $row->idConstructor);
                    $retencionFG=$this->mpaquete->getCampo("porcentaje_retencion",$row->idPaquete);
                    $totalRetencionFG+=$row->estimacion * ($retencionFG / 100);
                    $totalEstimacion+=$row->estimacion;
                    $totalRetencion+=$row->retencion;
                    $totalNeto+=$row->estimacion - $row->retencion;
    
                    $objPHPExcel->getActiveSheet()->SetCellValue('T'.$fFinalBody, "$".number_format($row->estimacion * ($retencionFG / 100),2));
                    $objPHPExcel->getActiveSheet()->SetCellValue('W'.$fFinalBody, $contratista);
                    $objPHPExcel->getActiveSheet()->SetCellValue('X'.$fFinalBody, "$".number_format($row->estimacion,2));
                    $objPHPExcel->getActiveSheet()->SetCellValue('Y'.$fFinalBody, "$".number_format($row->retencion,2));
                    $objPHPExcel->getActiveSheet()->SetCellValue('Z'.$fFinalBody, "$".number_format($row->estimacion - $row->retencion,2));
                    $fFinalBody++;
                }
    
                $styleArray = array(
                    'font' => array(
                        'size' => 9
                    ),
                    'borders' => array(
                        'allBorders' => array(
                            'borderStyle' => PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
                            'color' => array('rgb' => 'DDEBF7')
                        )
                    )
                );
                $objPHPExcel->getActiveSheet()->getStyle($cInicio.$fInicioBody.":".$cFinal.$fFinalBody)->applyFromArray($styleArray);
                $objPHPExcel->getActiveSheet()->getStyle($cInicio.$fInicioBody.":".$cFinal.$fFinalBody)->getAlignment()->applyFromArray(
                    array(
                        'horizontal' => PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER,
                        'vertical' => PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER,
                    )
                );
                $objPHPExcel->getActiveSheet()->getStyle($cInicio.$fInicioBody.":".$cFinal.$fFinalBody)->getAlignment()->setWrapText(true);
            }
    
            //FOOTER DE LA TABLA DE ESTIMACIONES TOTALES
            $fInicioFooter=$fFinalBody;
            $objPHPExcel->getActiveSheet()->SetCellValue('T'.$fFinalBody, "$".number_format($totalRetencionFG,2));
            $objPHPExcel->getActiveSheet()->getColumnDimension('W')->setWidth(15);
            $objPHPExcel->getActiveSheet()->SetCellValue('W'.$fFinalBody, 'Total');
            $objPHPExcel->getActiveSheet()->getColumnDimension('X')->setWidth(10);
            $objPHPExcel->getActiveSheet()->SetCellValue('X'.$fFinalBody, "$".number_format($totalEstimacion,2));
            $objPHPExcel->getActiveSheet()->getColumnDimension('Y')->setWidth(11);
            $objPHPExcel->getActiveSheet()->SetCellValue('Y'.$fFinalBody, "$".number_format($totalRetencion,2));
            $objPHPExcel->getActiveSheet()->getColumnDimension('Z')->setWidth(10);
            $objPHPExcel->getActiveSheet()->SetCellValue('Z'.$fFinalBody, "$".number_format($totalNeto,2));
            $styleArray = array(
                'font' => array(
                    'size' => 9
                ),
                'borders' => array(
                    'allBorders' => array(
                        'borderStyle' => PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
                        'color' => array('rgb' => 'DDEBF7')
                    )
                ),
                'fill' => array(
                    'fillType' => PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID,
                    'color' => array('rgb' => 'DDEBF7')
                )
            );
            $objPHPExcel->getActiveSheet()->getStyle("T".$fInicioFooter)->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->getStyle("T".$fInicioFooter)->getAlignment()->applyFromArray(
                array(
                    'horizontal' => PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER,
                    'vertical' => PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER,
                )
            );
    
            $objPHPExcel->getActiveSheet()->getStyle($cInicio.$fInicioFooter.":".$cFinal.$fFinalBody)->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->getStyle($cInicio.$fInicioFooter.":".$cFinal.$fFinalBody)->getAlignment()->applyFromArray(
                array(
                    'horizontal' => PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER,
                    'vertical' => PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER,
                )
            );
            $objPHPExcel->getActiveSheet()->getStyle($cInicio.$fInicioFooter.":".$cFinal.$fFinalBody)->getAlignment()->setWrapText(true);
    
            $name = 'RESUMEN';
            header('Content-Type: application/vnd.ms-excel');
            header('Content-Disposition: attachment;filename="' . $name . '_' . date('Ymd') . '.xls"');
            header('Cache-Control: max-age=0'); //no cache
            $objWriter = PhpOffice\PhpSpreadsheet\IOFactory::createWriter($objPHPExcel, 'Xls');
            // Forzamos a la descarga
            $objWriter->save('php://output');
        }
    }

}