<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class rcomparativa_oc extends MX_Controller {
    public $data,$vParameters,$mainView,$fv;
	public function __construct(){
    $this->nsession = $this->config->item('nsession');
	if (!isset($_SESSION[$this->nsession]) || (($_SESSION[$this->nsession]['usuario'] == ""))) redirect('login');
            $this->fv = 'rcomparativa_oc'; // form validation variable
            $this->mainView = 'rcomparativa_oc';
            $this->data['fjs'] = '';
            $this->data['js'] = '<script src="assets/js/rcomparativa_oc/listado.js?v=0.1" type="text/javascript"></script>';
            $this->data['css'] = '';
            ini_set('memory_limit', '-1');
            ini_set('max_execution_time', 0);
            // Tools
            $this->load->helper(array('tools','numeros','url','form','date','text','security'));
            // Modelos
            $this->load->model(array('mfraccionamiento', 'mprototipos', 'mpaquete', 'mdetallepaquete', 'mmaterialesactividadprototipo', 'mmaterial',
             'mpresupuestomat', 'mordencompra', 'mmanoobra', 'mmateriales', 'mproveedor', 'mareamaterial', 'musuario', 'mempresas', 'mconstructores', 
             'mrecepcion', 'mcompra', 'marranque'));

            // Lbrerias
            $this->load->library('csvimport');

           // Debugging
            $this->output->enable_profiler(false);

           //Validación de usuarios
           $this->config->set_item('rol',$_SESSION[$this->nsession]['rol']);
            valSession("materiales",$this->fv);
    }

	public function index()
	{
        $texto = '';
        if( isset($_SESSION['mensaje'])){
            $texto = $_SESSION['mensaje'];
            unset($_SESSION['mensaje']);
        }
        $data["empresa"]=$this->mempresas->getCampo("titulo",$_SESSION[$this->nsession]["idEmpresa"]);
        $data['texto'] = $texto;
        $ids = array();
        $qArranque = $this->marranque->getAllByEstatusNoPendiente();
        if( !is_numeric($qArranque) ){
            foreach($qArranque->result() as $arranque){
                $temp = explode(',', $arranque->idPaquetes);
                if( !empty($temp[0]) ){
                    foreach($temp as $v){
                        if( !in_array($v, $ids, true) && is_numeric($v)){
                            $ids[] = $v;
                        }
                    }
                }
            }
        }
        $data['fraccionamientos']=$this->mfraccionamiento->getAllFiltro();
        $data['almacenes'] = ( empty($ids) )? 0 : $this->mpaquete->getSelectResultInIds($ids);
        $data['articulos']=$this->mmateriales->getAllFiltro($_SESSION[$this->nsession]["idEmpresa"]);
        $data['proveedores']=$this->mproveedor->getAllFiltro($_SESSION[$this->nsession]["idEmpresa"]);
        $this->data['contenido'] = $this->load->view($this->mainView.'/index_view',$data,true);
        $this->load->view('templates/main_template',$this->data);
	}

    //---------
    public function exportar(){
        $info=$_POST;
        if(isset($info)){
            $idEmpresa=$_SESSION[$this->nsession]["idEmpresa"];
            $filter=$filter2="";
            if($info["fraccionamiento"] > 0){
                $filter.=" AND mate.idFraccionamiento=".$info["fraccionamiento"];
                $filter2.=" AND mate.idFraccionamiento=".$info["fraccionamiento"];
            }
            if($info["almacen"] > 0){
                $filter.=" AND dc.idPaquete=".$info["almacen"];
                $filter2.=" AND mate.idPaquete=".$info["almacen"];
            }
            if($info["articulo"] > 0){
                $filter.=" AND dc.id_articulo=".$info["articulo"];
                $filter2.=" AND mact.idMaterial=".$info["articulo"];
            }
            if($info["statusArranque"] > 0 && $info["statusArranque"] != ""){
                $filter.=" AND arr.estatus_arranque=".$info["statusArranque"];
                $filter2.=" AND arr.estatus_arranque=".$info["statusArranque"];
            }
            if($info["proveedor"] > 0){
                $filter.=" AND c.id_proveedor=".$info["proveedor"];
                $filter2.=" AND pmat.idProveedor=".$info["proveedor"];
            }
            if ($info['fecha_inicio'] != "" && $info['fecha_fin']  != "") {
                $fecha_inicio = date_format(new DateTime($info['fecha_inicio']),"Y-m-d");
                $fecha_fin = date_format(new DateTime($info['fecha_fin']),"Y-m-d");
                if($fecha_inicio != $fecha_fin){
                    $filter.=" AND DATE(c.fecha) >= DATE('$fecha_inicio') AND DATE(c.fecha) <= DATE('$fecha_fin') + INTERVAL 1 DAY ";
                    $filter2.=" AND DATE(c.fecha) >= DATE('$fecha_inicio') AND DATE(c.fecha) <= DATE('$fecha_fin') + INTERVAL 1 DAY ";
                }else{
                    $filter.=" AND DATE(c.fecha) = DATE('$fecha_inicio') ";
                    $filter2.=" AND DATE(c.fecha) = DATE('$fecha_inicio') ";
                }
            }

            //Inicia armado de columnas
            $precio_doc="ROUND(AVG(doc.precio_unitario),2)";
            $importe_doc="ROUND(SUM(DISTINCT ROUND(doc.precio_unitario * doc.unidades,2) + doc.id) - SUM(DISTINCT doc.id),2)";
            $unidades_doc="ROUND($importe_doc / $precio_doc,2)";

            $precio_dc="ROUND(AVG(dc.precio_unitario),2)";
            $importe_dc="ROUND(SUM(DISTINCT ROUND(dc.precio_unitario * dc.unidades,2) + dc.id) - SUM(DISTINCT dc.id),2)";
            $unidades_dc="ROUND($importe_dc / $precio_dc,2)";

            $precio_drc="ROUND(AVG(drc.precio_unitario),2)";
            $importe_drc="ROUND(SUM(DISTINCT ROUND(drc.precio_unitario * drc.unidades,2) + drc.id) - SUM(DISTINCT drc.id),2)";
            $unidades_drc="ROUND($importe_drc / $precio_drc,2)";

            $precio_ppto="AVG((pmat.precioUnitario / 1.16))";
            $importe_ppto="( (SUM(DISTINCT (mact.cantidad*pmat.precioUnitario) * paq.nLotes + pmat.id) - SUM(DISTINCT pmat.id)) / 1.16 )";
            $unidades_ppto="ROUND(($importe_ppto / $precio_ppto),2)";
            //Inicia query customizada
            $query="            
            (SELECT
            fr.titulo fraccionamiento,
            al.nombre nombre_almacen,
            paq.nLotes,
            mat.clave clave,
            mat.nombre articulo,
            mat.unidad_venta,
            prov.nombre proveedor,
            
            $unidades_ppto unidades_ppto,
            $precio_ppto precio_ppto,
            $importe_ppto importe_ppto,

            GROUP_CONCAT(DISTINCT oc.folio  SEPARATOR ' ') folios_oc,
            $unidades_doc unidades_doc,
            $precio_doc precio_doc,
            $importe_doc importe_doc,

            GROUP_CONCAT(DISTINCT c.folio  SEPARATOR ' ') folios_c,
            $unidades_dc unidades_dc,
            $precio_dc precio_dc,
            $importe_dc importe_dc,

            GROUP_CONCAT(DISTINCT rc.folio  SEPARATOR ' ') folios_rc,
            $unidades_drc unidades_drc,
            $precio_drc precio_drc,
            $importe_drc importe_drc,

            (IF($unidades_ppto,$unidades_ppto,0) - IF($unidades_doc,$unidades_doc,0)) cantidad_ppto,
            (IF($precio_ppto,$precio_ppto,0) - IF($precio_doc,$precio_doc,0)) precio_unitario,
            (IF($importe_ppto,$importe_ppto,0) - IF($importe_doc,$importe_doc,0)) importe,

            (IF($unidades_ppto,$unidades_ppto,0) - IF($unidades_dc,$unidades_dc,0)) cantidad_ppto2,
            (IF($precio_ppto,$precio_ppto,0) - IF($precio_dc,$precio_dc,0)) precio_unitario2,
            (IF($importe_ppto,$importe_ppto,0) - IF($importe_dc,$importe_dc,0)) importe2

            FROM detalle_compra dc
            LEFT JOIN compra c ON dc.id_compra=c.id AND c.idPaquete=dc.idPaquete AND c.idEmpresa=$idEmpresa
            LEFT JOIN almacenes al ON al.idPaquete=dc.idPaquete AND al.idEmpresa=$idEmpresa
            LEFT JOIN materiales mat ON mat.id=dc.id_articulo AND mat.idEmpresa=$idEmpresa
            LEFT JOIN paquetes paq ON paq.id=al.idPaquete

            LEFT JOIN detalle_orden doc ON doc.id_articulo=dc.id_articulo AND doc.idPaquete=dc.idPaquete AND doc.idEmpresa=$idEmpresa
            LEFT JOIN orden_compra oc ON oc.id=doc.id_orden_compra AND oc.idEmpresa=$idEmpresa AND oc.estatus != 'CANCELADA'

            LEFT JOIN detalle_recepcion drc ON drc.id_articulo=dc.id_articulo AND drc.idPaquete=dc.idPaquete AND drc.idEmpresa=$idEmpresa
            LEFT JOIN recepcion rc ON rc.id=drc.id_recepcion AND drc.idEmpresa=$idEmpresa AND rc.estatus != 'CANCELADA'

            LEFT JOIN material mate ON mate.idPaquete=paq.id AND mate.idEmpresa=$idEmpresa
            LEFT JOIN presupuesto_mat pmat ON pmat.idMaterial=mate.id AND (SELECT act.idMaterial FROM materialesactividadprototipo act WHERE act.id=pmat.idMateriales)=dc.id_articulo
            LEFT JOIN materialesactividadprototipo mact ON mact.id=pmat.idMateriales
            LEFT JOIN proveedores prov ON prov.id=c.id_proveedor AND prov.idEmpresa=$idEmpresa
            LEFT JOIN fraccionamientos fr ON fr.id=mate.idFraccionamiento
            LEFT JOIN arranque arr ON FIND_IN_SET(paq.id,arr.idPaquetes)

            WHERE
            dc.idEmpresa=$idEmpresa AND c.estatus != 'CANCELADA' $filter
            AND dc.idPaquete > 0
            GROUP BY dc.idPaquete, dc.id_articulo)";

            //segunda query
            $precio_ppto="AVG(DISTINCT (pmat.precioUnitario / 1.16))";
            $importe_ppto="((SUM(DISTINCT (mact.cantidad*pmat.precioUnitario) * paq.nLotes + pmat.id) - SUM(DISTINCT pmat.id)) / 1.16)";
            $query.="
            UNION ALL
            (SELECT 
            fr.titulo fraccionamiento,
            al.nombre nombre_almacen,
            paq.nLotes,
            mat.clave clave,
            mat.nombre articulo,
            mat.unidad_venta,
            prov.nombre proveedor,

            ROUND(($importe_ppto / $precio_ppto),2) unidades_ppto,
            $precio_ppto precio_ppto,
            $importe_ppto importe_ppto,

            '' folios_oc,
            0 unidades_doc,
            0 precio_doc,
            0 importe_doc,

            '' folios_c,
            0 unidades_dc,
            0 precio_dc,
            0 importe_dc,

            '' folios_rc,
            0 unidades_drc,
            0 precio_drc,
            0 importe_drc,

            ROUND(($importe_ppto / $precio_ppto),2) cantidad_ppto,
            $precio_ppto precio_unitario,
            $importe_ppto importe,

            ROUND(($importe_ppto / $precio_ppto),2) cantidad_ppto2,
            $precio_ppto precio_unitario2,
            $importe_ppto importe2

            FROM presupuesto_mat pmat 
            LEFT JOIN materialesactividadprototipo mact ON mact.id=pmat.idMateriales
            LEFT JOIN material mate ON mate.id=pmat.idMaterial AND mate.idEmpresa=$idEmpresa
            LEFT JOIN paquetes paq ON paq.id=mate.idPaquete
            LEFT JOIN almacenes al ON al.idPaquete=mate.idPaquete AND al.idEmpresa=$idEmpresa
            LEFT JOIN materiales mat ON mat.id=mact.idMaterial AND mat.idEmpresa=$idEmpresa
            LEFT JOIN proveedores prov ON prov.id=pmat.idProveedor AND prov.idEmpresa=$idEmpresa
            LEFT JOIN fraccionamientos fr ON fr.id=mate.idFraccionamiento
            LEFT JOIN arranque arr ON FIND_IN_SET(paq.id,arr.idPaquetes)
            LEFT OUTER JOIN detalle_compra dc ON dc.id_articulo=mact.idMaterial AND dc.idEmpresa=$idEmpresa AND dc.idPaquete=paq.id
            LEFT OUTER JOIN compra c ON dc.id_compra=c.id AND c.idPaquete=dc.idPaquete AND c.idEmpresa=$idEmpresa
            WHERE dc.id IS NULL AND al.id $filter2
            GROUP BY mate.idPaquete, mact.idMaterial)
            ";
            //ordenamiento
            $columnas = array(
                0 =>'FRACCIONAMIENTO',
                1 =>'ALMACEN',
                2 =>'# LOTES',
                3 =>'CLAVE',
                4 =>'ARTICULO',
                5 =>'UNIDAD',
                6 =>'PROVEEDOR',
                7 =>'CANTIDAD PPTO.',
                8 =>'PRECIO UNIT. PPTO.',
                9 =>'IMPORTE TOTAL PPTO.',
                10 =>'FOLIOS ORDEN',
                11 =>'CANTIDAD ORDEN',
                12 =>'PRECIO UNIT. ORDEN',
                13 =>'IMPORTE TOTAL ORDEN',
                14 =>'FOLIOS COMPRA',
                15 =>'CANTIDAD COMPRA',
                16 =>'PRECIO UNIT. COMPRA',
                17 =>'IMPORTE TOTAL COMPRA',
                18 =>'FOLIOS RECEPCION',
                19 =>'CANTIDAD RECEPCION',
                20 =>'PRECIO UNIT. RECEPCION',
                21 =>'IMPORTE TOTAL RECEPCION',
                22 =>'CANTIDAD - PPTO VS OC',
                23 =>'PRECIO UNIT. - PPTO VS OC',
                24 =>'IMPORTE TOTAL - PPTO VS OC',
                25 =>'CANTIDAD - PPTO VS COMPRA',
                26 =>'PRECIO UNIT. - PPTO VS COMPRA',
                27 =>'IMPORTE TOTAL - PPTO VS COMPRA',
            );
            $query=$this->db->query($query);
            crearExcel($query,"Comparativa BD",$columnas);
        }else{
            echo "Debemos tener un id de empresa para poder exportar el reporte";
        }
    }

    public function _exportar($idPaquete = 0)
    {
        //Inicia sincronización previa
        require('Cronjob.php');
        $cronjob = new Cronjob();
        $ordenesCompra=$this->mordencompra->getAllByIdPaquete($idPaquete);
        if(!is_numeric($ordenesCompra)){
            foreach ($ordenesCompra->result() as $row) {
                $cronjob->GetOrdenCompra($row->idEmpresa,$row->id,$idPaquete,false);
            }
        }
        //inicia armado de reporte
        if($idPaquete == 0){
            $idPaquete = $_POST['idPaquete'];
        }
        $qPaquete = $this->mpaquete->getById($idPaquete);
        if( !is_numeric($qPaquete) ){
            $qMaterial = $this->mmaterial->getByIdPaquete($idPaquete);
            if( !is_numeric($qMaterial) ){
                $getInfo = $this->getInfoVer($idPaquete);
                if($getInfo != 0){
                    $fraccionamiento = $getInfo['fraccionamiento'];
                    $prototipo = $getInfo['prototipo'];
                    $noCasas = $getInfo['noCasas'];
                    $presupuestoViv = $getInfo['presupuestoViv'];
                    $presupuestoPaq = $getInfo['presupuestoPaq'];
                    $costoM2 = $getInfo['costoM2'];
                    $m2Viv = $getInfo['m2Viv'];
                }else{
                    $fraccionamiento = '';
                    $prototipo = '';
                    $noCasas = '';
                    $presupuestoViv = '';
                    $presupuestoPaq = '';
                    $costoM2 = '';
                    $m2Viv = '';
                }
                    
                $manoObra = $this->mmanoobra->getById($qPaquete['idManoObra']);
                $prototipo = (!is_numeric($manoObra)) ? $this->mprototipos->getCampo2('nombre', $manoObra['idPrototipo']) : '';
                $paqueteLotes = 0;
                $paqueteLotes = contarLotesManzanas($qPaquete['rango_lotes']);
                $lotes = $paqueteLotes['lotes'];
                $manzanas=implode(", ",array_keys($paqueteLotes["arrayMzs"]));
                $paqueteLotes = $paqueteLotes['total'];
                $constructorNombre = $this->mconstructores->getCampo2('nombre', $qPaquete['idConstructor']);
                $constructorApellidoP = $this->mconstructores->getCampo2('apellidoP', $qPaquete['idConstructor']);
                $constructorApellidoM = $this->mconstructores->getCampo2('apellidoM', $qPaquete['idConstructor']);
                $constructor = $constructorNombre . ' ' . $constructorApellidoP . ' ' . $constructorApellidoM;
                $totalViviendas = $paqueteLotes;
                $qTotalPresupuestoMO = $this->db->query("SELECT SUM(importe) as totalImporte FROM presupuesto_mo WHERE idManoObra = ".$manoObra['id']);
                $presupuestoUnit = ($qTotalPresupuestoMO->row()->totalImporte != '') ? $qTotalPresupuestoMO->row()->totalImporte : 0;
                $totalContrato = $presupuestoUnit * $paqueteLotes;
                $fechaInicio = date_format(date_create($qPaquete['fecha_inicio']), 'd-m-Y');
                $fechaFin = date_format(date_create($qPaquete['fecha_fin']), 'd-m-Y');
                
                $this->load->library('excel');
                $objPHPExcel = new PhpOffice\PhpSpreadsheet\Spreadsheet();
                $objPHPExcel->getActiveSheet()->setTitle("Comparativa");
                $objPHPExcel->setActiveSheetIndex(0);
        
                $objPHPExcel->getActiveSheet()->mergeCells('A1:B7');
        
                $gdImage = imagecreatefromjpeg(base_url() . '/img/bg1.jpg');
                // Add a drawing to the worksheetecho date('H:i:s') . " Add a drawing to the worksheet\n";
                $objDrawing = new PhpOffice\PhpSpreadsheet\Worksheet\MemoryDrawing();
                $objDrawing->setName('Logo Vviend');
                $objDrawing->setDescription('Logo Viviend');
                $objDrawing->setImageResource($gdImage);
                $objDrawing->setRenderingFunction(PhpOffice\PhpSpreadsheet\Worksheet\MemoryDrawing::RENDERING_JPEG);
                $objDrawing->setMimeType(PhpOffice\PhpSpreadsheet\Worksheet\MemoryDrawing::MIMETYPE_DEFAULT);
                $objDrawing->setOffsetX(150);
                $objDrawing->setOffsetY(0);
                $objDrawing->setWidth(900);
                $objDrawing->setHeight(140);
                $objDrawing->setCoordinates('A1');
                $objDrawing->setWorksheet($objPHPExcel->getActiveSheet());
        
                $qSemanas = $this->mpresupuestomat->getSemanasByIdMaterial($qMaterial['id']);
                

                $objPHPExcel->getActiveSheet()->SetCellValue('A9', 'FRACCIONAMIENTO:');
                $objPHPExcel->getActiveSheet()->SetCellValue('B9', $fraccionamiento);

                $objPHPExcel->getActiveSheet()->SetCellValue('A10', 'PROTOTIPO:');
                $objPHPExcel->getActiveSheet()->SetCellValue('B10', $prototipo);

                $objPHPExcel->getActiveSheet()->SetCellValue('A11', 'CONTRATISTA:');
                $objPHPExcel->getActiveSheet()->SetCellValue('B11', $constructor);

                $objPHPExcel->getActiveSheet()->SetCellValue('A12', 'NO. DE VIV:');
                $objPHPExcel->getActiveSheet()->SetCellValue('B12', $totalViviendas);
                $objPHPExcel->getActiveSheet()->getStyle('B12')->getAlignment()->setHorizontal(PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_LEFT);
                //

                $objPHPExcel->getActiveSheet()->SetCellValue('C9', 'MANZANAS');
                $objPHPExcel->getActiveSheet()->SetCellValue('D9', $manzanas);

                $objPHPExcel->getActiveSheet()->SetCellValue('C10', 'LOTES:');
                $objPHPExcel->getActiveSheet()->SetCellValue('D10', $lotes);

                $objPHPExcel->getActiveSheet()->SetCellValue('C11', 'PRESUPUESTO UNIT.:');
                $objPHPExcel->getActiveSheet()->SetCellValue('D11', precio_format($presupuestoUnit));

                $objPHPExcel->getActiveSheet()->SetCellValue('C12', 'TOTAL CONTRATO:');
                $objPHPExcel->getActiveSheet()->SetCellValue('D12', precio_format($totalContrato));

                //

                $objPHPExcel->getActiveSheet()->mergeCells('E9:E9');
                $objPHPExcel->getActiveSheet()->SetCellValue('E9', 'INICIO PROGRAMADO:');
                $objPHPExcel->getActiveSheet()->SetCellValue('F9', $fechaInicio);

                $objPHPExcel->getActiveSheet()->mergeCells('E10:E10');
                $objPHPExcel->getActiveSheet()->SetCellValue('E10', 'TERMINO PROGRAMADO:');
                $objPHPExcel->getActiveSheet()->SetCellValue('F10', $fechaFin);

                $objPHPExcel->getActiveSheet()->mergeCells('E11:E11');
                $objPHPExcel->getActiveSheet()->SetCellValue('E11', 'INICIO REAL:');
                $objPHPExcel->getActiveSheet()->SetCellValue('F11', '');

                $objPHPExcel->getActiveSheet()->mergeCells('E12:E12');
                $objPHPExcel->getActiveSheet()->SetCellValue('E12', 'TERMINO REAL:');
                $objPHPExcel->getActiveSheet()->SetCellValue('F12', '');

                $objPHPExcel->getActiveSheet()->mergeCells('G9:H9');
                $objPHPExcel->getActiveSheet()->SetCellValue('G9', 'ALMACEN:');
                $objPHPExcel->getActiveSheet()->SetCellValue('I9', $qPaquete['titulo']);

                $objPHPExcel->getActiveSheet()->mergeCells('G10:H10');
                $objPHPExcel->getActiveSheet()->SetCellValue('G10', 'COSTO X M2:');
                $objPHPExcel->getActiveSheet()->SetCellValue('I10', $costoM2);

                $objPHPExcel->getActiveSheet()->mergeCells('G11:H11');
                $objPHPExcel->getActiveSheet()->SetCellValue('G11', 'M2 X VIVIENDA:');
                $objPHPExcel->getActiveSheet()->SetCellValue('I11', $m2Viv);
                
                $objPHPExcel->getActiveSheet()->SetCellValue('M12', 'MICROSIP');
                $objPHPExcel->getActiveSheet()->mergeCells('M12:U12');
                $objPHPExcel->getActiveSheet()->SetCellValue('E13', 'PRESUPUESTO');
                $objPHPExcel->getActiveSheet()->mergeCells('E13:L13');
                $objPHPExcel->getActiveSheet()->SetCellValue('M13', 'ORDEN DE COMPRA');
                $objPHPExcel->getActiveSheet()->mergeCells('M13:O13');
                $objPHPExcel->getActiveSheet()->SetCellValue('P13', 'COMPRA');
                $objPHPExcel->getActiveSheet()->mergeCells('P13:R13');
                $objPHPExcel->getActiveSheet()->SetCellValue('S13', 'RECIBIDO');
                $objPHPExcel->getActiveSheet()->mergeCells('S13:U13');
                
                //$objPHPExcel->getActiveSheet()->SetCellValue('A14', 'etapa');
                $objPHPExcel->getActiveSheet()->SetCellValue('A14', 'semana');
                $objPHPExcel->getActiveSheet()->SetCellValue('B14', 'clave');
                $objPHPExcel->getActiveSheet()->SetCellValue('C14', 'área');
                $objPHPExcel->getActiveSheet()->SetCellValue('D14', 'proveedor');
                $objPHPExcel->getActiveSheet()->SetCellValue('E14', 'descripción');
                $objPHPExcel->getActiveSheet()->SetCellValue('F14', 'unidad');
                $objPHPExcel->getActiveSheet()->SetCellValue('G14', 'pr_cant');
                $objPHPExcel->getActiveSheet()->SetCellValue('H14', 'pr_cantot');
                $objPHPExcel->getActiveSheet()->SetCellValue('I14', 'preciosiva');
                $objPHPExcel->getActiveSheet()->SetCellValue('J14', 'precioneto');
                $objPHPExcel->getActiveSheet()->SetCellValue('K14', 'total');
                $objPHPExcel->getActiveSheet()->SetCellValue('L14', 'imp_total');
                $objPHPExcel->getActiveSheet()->SetCellValue('M14', 'oc_folio');
                $objPHPExcel->getActiveSheet()->SetCellValue('N14', 'oc_cant');
                $objPHPExcel->getActiveSheet()->SetCellValue('O14', 'oc_imp');
                $objPHPExcel->getActiveSheet()->SetCellValue('P14', 'fol_comp');
                $objPHPExcel->getActiveSheet()->SetCellValue('Q14', 'cant_comp');
                $objPHPExcel->getActiveSheet()->SetCellValue('R14', 'imp_comp');
                $objPHPExcel->getActiveSheet()->SetCellValue('S14', 'rec_folio');
                $objPHPExcel->getActiveSheet()->SetCellValue('T14', 'rec_cant');
                $objPHPExcel->getActiveSheet()->SetCellValue('U14', 'rec_imp');
                $objPHPExcel->getActiveSheet()->SetCellValue('V14', 'dif_cant');
                $objPHPExcel->getActiveSheet()->SetCellValue('W14', 'impxcomprar');

                //A partir de que row empieza a escribir
                $rowCount = 15;

                //Aqui iria codigo dinamico, cuando haya
                if( !is_numeric($qSemanas) ){
                    foreach($qSemanas->result() as $sem){
                        $qMatPpto = $this->mpresupuestomat->getByIdMaterial($qMaterial['id'], $sem->semana);
                        //Queries de armado
                        $ordenSemanaOC = $this->db->query('SELECT do.*, o.folio, o.id_proveedor, o.id_almacen, o.semana FROM orden_compra AS o 
                        INNER JOIN detalle_orden AS do ON o.id = do.id_orden_compra 
                        WHERE o.idMaterial = '.$qMaterial['id'].' AND o.semana = '.$sem->semana.'');
                        $ordenSemanaOC=($ordenSemanaOC->num_rows() > 0) ? $ordenSemanaOC->result() : 0; 

                        $ordenSemanaC = $this->db->query('SELECT dc.*, c.folio, c.id_proveedor, c.id_almacen, o.semana FROM orden_compra AS o 
                        INNER JOIN compra AS c ON o.id = c.id_orden_compra 
                        INNER JOIN detalle_compra AS dc ON c.id = dc.id_compra 
                        WHERE o.idMaterial = '.$qMaterial['id'].' AND o.semana = '.$sem->semana.'');
                        $ordenSemanaC=($ordenSemanaC->num_rows() > 0) ? $ordenSemanaC->result() : 0;

                        $ordenSemanaR = $this->db->query('SELECT dr.*, r.folio, r.id_proveedor, r.id_almacen, o.semana FROM orden_compra AS o 
                        INNER JOIN recepcion AS r ON o.id = r.id_orden_compra 
                        INNER JOIN detalle_recepcion AS dr ON r.id = dr.id_recepcion
                        WHERE o.idMaterial = '.$qMaterial['id'].' AND o.semana = '.$sem->semana.'');
                        $ordenSemanaR=($ordenSemanaR->num_rows() > 0) ? $ordenSemanaR->result() : 0;

                        if( !is_numeric($qMatPpto) ){
                            foreach($qMatPpto->result() as $matPpto){
                                $matActProt = $this->mmaterialesactividadprototipo->getById($matPpto->idMateriales);
                                if(!is_numeric($matActProt)){ 
                                    $material = $this->mmateriales->getByIdEmpresa($matActProt['idMaterial'],$qMaterial["idEmpresa"]);
                                    if(!is_numeric($material)){
                                        $proveedor = $this->mproveedor->getCampo2('nombre', $matPpto->idProveedor);
                                        $matTot = $matActProt['cantidad'] * $noCasas;
                                        $preciosiva = $matPpto->precioUnitario / 1.16;
                                        $total = $matActProt['cantidad'] * $matPpto->precioUnitario;
                                        $impTotal = $matTot * $matPpto->precioUnitario;
                                        $objPHPExcel->getActiveSheet()->SetCellValue('A' . $rowCount, $matPpto->semana);
                                        $objPHPExcel->getActiveSheet()->SetCellValue('B' . $rowCount, $material['clave']);
                                        $objPHPExcel->getActiveSheet()->SetCellValue('C' . $rowCount, $material['linea_art']);
                                        $objPHPExcel->getActiveSheet()->SetCellValue('D' . $rowCount, $proveedor);
                                        $objPHPExcel->getActiveSheet()->SetCellValue('E'. $rowCount, $material['nombre']);
                                        $objPHPExcel->getActiveSheet()->SetCellValue('F' . $rowCount,  $material['unidad_compra']);
                                        $objPHPExcel->getActiveSheet()->SetCellValue('G' . $rowCount, $matActProt['cantidad']);
                                        $objPHPExcel->getActiveSheet()->SetCellValue('H' . $rowCount, $matTot);
                                        $objPHPExcel->getActiveSheet()->SetCellValue('I' . $rowCount, $preciosiva);
                                        $objPHPExcel->getActiveSheet()->SetCellValue('J' . $rowCount, $matPpto->precioUnitario);
                                        $objPHPExcel->getActiveSheet()->SetCellValue('K' . $rowCount, $total);
                                        $objPHPExcel->getActiveSheet()->SetCellValue('L' . $rowCount, $impTotal);
                                        //Inicia Armado de Orden Compra
                                        //$qOrdenCompra = $this->mordencompra->getByIdPaqIdMatSemIdProv($idPaquete, $qMaterial['id'], $matPpto->semana, $matPpto->idProveedor);
                                        if(!is_numeric($ordenSemanaOC) || !is_numeric($ordenSemanaC) || !is_numeric($ordenSemanaR)){
                                            //Llenado de orden compra
                                            if(!is_numeric($ordenSemanaOC)){
                                                if(COUNT($ordenSemanaOC) > 0){
                                                    $existClave=false;
                                                    foreach ($ordenSemanaOC as $_key => $_val) {
                                                        if($_val->clave_articulo == $material["clave"]){
                                                            $objPHPExcel->getActiveSheet()->SetCellValue('M' . $rowCount, $_val->folio);
                                                            $objPHPExcel->getActiveSheet()->SetCellValue('N' . $rowCount, $_val->unidades);
                                                            $objPHPExcel->getActiveSheet()->SetCellValue('O' . $rowCount, $_val->unidades * $_val->precio_unitario);
                                                            unset($ordenSemanaOC[$_key]);
                                                            $existClave=true;
                                                            break;
                                                        }
                                                    }
                                                }
                                            }

                                            //Llenado de compra
                                            $existClaveC=false;
                                            if(!is_numeric($ordenSemanaC)){
                                                if(COUNT($ordenSemanaC) > 0){
                                                    foreach ($ordenSemanaC as $_key => $_val) {
                                                        if($_val->clave_articulo == $material["clave"]){
                                                            $objPHPExcel->getActiveSheet()->SetCellValue('P' . $rowCount, $_val->folio);
                                                            $objPHPExcel->getActiveSheet()->SetCellValue('Q' . $rowCount, $_val->unidades);
                                                            $objPHPExcel->getActiveSheet()->SetCellValue('R' . $rowCount, $_val->unidades * $_val->precio_unitario);
                                                            $objPHPExcel->getActiveSheet()->SetCellValue('V' . $rowCount, $matTot - $_val->unidades);
                                                            $objPHPExcel->getActiveSheet()->SetCellValue('W' . $rowCount, ($matTot - $_val->unidades) * $matPpto->precioUnitario);
                                                            unset($ordenSemanaC[$_key]);
                                                            $existClaveC=true;
                                                            break;
                                                        }
                                                    }
                                                }
                                            }

                                            if(!$existClaveC){
                                                $objPHPExcel->getActiveSheet()->SetCellValue('V' . $rowCount, $matTot);
                                                $objPHPExcel->getActiveSheet()->SetCellValue('W' . $rowCount, $impTotal);
                                            }

                                            //Llenado de recepcion
                                            if(!is_numeric($ordenSemanaR)){
                                                if(COUNT($ordenSemanaR) > 0){
                                                    $existClave=false;
                                                    foreach ($ordenSemanaR as $_key => $_val) {
                                                        if($_val->clave_articulo == $material["clave"]){
                                                            $objPHPExcel->getActiveSheet()->SetCellValue('S' . $rowCount, $_val->folio);
                                                            $objPHPExcel->getActiveSheet()->SetCellValue('T' . $rowCount, $_val->unidades);
                                                            $objPHPExcel->getActiveSheet()->SetCellValue('U' . $rowCount, $_val->unidades * $_val->precio_unitario);
                                                            unset($ordenSemanaR[$_key]);
                                                            $existClave=true;
                                                            break;
                                                        }
                                                    }
                                                }
                                            }
                                        }else{
                                            $objPHPExcel->getActiveSheet()->SetCellValue('M' . $rowCount, 0);
                                            $objPHPExcel->getActiveSheet()->SetCellValue('N' . $rowCount, 0);
                                            $objPHPExcel->getActiveSheet()->SetCellValue('O' . $rowCount, 0);
                                            $objPHPExcel->getActiveSheet()->SetCellValue('P' . $rowCount, 0);
                                            $objPHPExcel->getActiveSheet()->SetCellValue('Q' . $rowCount, 0);
                                            $objPHPExcel->getActiveSheet()->SetCellValue('R' . $rowCount, 0);
                                            $objPHPExcel->getActiveSheet()->SetCellValue('S' . $rowCount, 0);
                                            $objPHPExcel->getActiveSheet()->SetCellValue('T' . $rowCount, 0);
                                            $objPHPExcel->getActiveSheet()->SetCellValue('U' . $rowCount, 0);
                                        }
                                        //echo "<pre>";
                                        //print_r($matPpto);
                                        //exit();
                                        //diferencias de cantidad e importe por comprar
                                        $rowCount++;
                                    }
                                }
                            }
                        }
                    }
                }
        
                // Formatos
                $objPHPExcel->getActiveSheet()->getStyle('A1:X'.$rowCount)->getFont()->setName('Arial')->setSize(10);
                $objPHPExcel->getActiveSheet()->getStyle('I10')->getNumberFormat()->setFormatCode(PhpOffice\PhpSpreadsheet\Style\NumberFormat::FORMAT_CURRENCY_USD_SIMPLE);
                $objPHPExcel->getActiveSheet()->getStyle('D11:D12')->getNumberFormat()->setFormatCode(PhpOffice\PhpSpreadsheet\Style\NumberFormat::FORMAT_CURRENCY_USD_SIMPLE);
                $objPHPExcel->getActiveSheet()->getStyle('I15:L'.$rowCount)->getNumberFormat()->setFormatCode(PhpOffice\PhpSpreadsheet\Style\NumberFormat::FORMAT_CURRENCY_USD_SIMPLE);
                $objPHPExcel->getActiveSheet()->getStyle('O15:O'.$rowCount)->getNumberFormat()->setFormatCode(PhpOffice\PhpSpreadsheet\Style\NumberFormat::FORMAT_CURRENCY_USD_SIMPLE);
                $objPHPExcel->getActiveSheet()->getStyle('R15:R'.$rowCount)->getNumberFormat()->setFormatCode(PhpOffice\PhpSpreadsheet\Style\NumberFormat::FORMAT_CURRENCY_USD_SIMPLE);
                $objPHPExcel->getActiveSheet()->getStyle('U15:U'.$rowCount)->getNumberFormat()->setFormatCode(PhpOffice\PhpSpreadsheet\Style\NumberFormat::FORMAT_CURRENCY_USD_SIMPLE);
                $objPHPExcel->getActiveSheet()->getStyle('W15:W'.$rowCount)->getNumberFormat()->setFormatCode(PhpOffice\PhpSpreadsheet\Style\NumberFormat::FORMAT_CURRENCY_USD_SIMPLE);
                
                $objPHPExcel->getActiveSheet()->getStyle('B9:B12')->applyFromArray(
                    array('fill' => array(
                        'fillType' => PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID,
                        'color' => array('rgb' => 'FFE699')
                    ))
                );
                $objPHPExcel->getActiveSheet()->getStyle('D9:D12')->applyFromArray(
                    array('fill' => array(
                        'fillType' => PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID,
                        'color' => array('rgb' => 'FFE699')
                    ))
                );
                $objPHPExcel->getActiveSheet()->getStyle('F9:F12')->applyFromArray(
                    array('fill' => array(
                        'fillType' => PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID,
                        'color' => array('rgb' => 'FFE699')
                    ))
                );
                $objPHPExcel->getActiveSheet()->getStyle('I9:I12')->applyFromArray(
                    array('fill' => array(
                        'fillType' => PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID,
                        'color' => array('rgb' => 'FFE699')
                    ))
                );
                $objPHPExcel->getActiveSheet()->getStyle('M12:U12')->applyFromArray(
                    array('fill' => array(
                        'fillType' => PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID,
                        'color' => array('rgb' => '000000')
                    ), 
                    'alignment' => array(
                        'horizontal' => PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER,
                        'vertical' => PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER
                    ), 
                    'font' => array(
                        'bold'  => true,
                        'color' => array('rgb' => 'FFFFFF'),
                        'size'  => 15,
                        'name'  => 'Arial'
                    ))
                );
                $objPHPExcel->getActiveSheet()->getStyle('E13:L13')->applyFromArray(
                    array('fill' => array(
                        'fillType' => PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID,
                        'color' => array('rgb' => '339933'),
                    ), 
                    'alignment' => array(
                        'horizontal' => PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER,
                        'vertical' => PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER
                    ), 
                    'font' => array(
                        'bold'  => true,
                        'color' => array('rgb' => 'FFFFFF'),
                        'size'  => 15,
                        'name'  => 'Arial'
                    ))
                );
                $objPHPExcel->getActiveSheet()->getStyle('M13:O13')->applyFromArray(
                    array('fill' => array(
                        'fillType' => PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID,
                        'color' => array('rgb' => '92d050')
                    ), 
                    'alignment' => array(
                        'horizontal' => PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER,
                        'vertical' => PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER
                    ), 
                    'font' => array(
                        'bold'  => true,
                        'color' => array('rgb' => 'FFFFFF'),
                        'size'  => 15,
                        'name'  => 'Arial'
                    ))
                );
                $objPHPExcel->getActiveSheet()->getStyle('P13:R13')->applyFromArray(
                    array('fill' => array(
                        'fillType' => PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID,
                        'color' => array('rgb' => '339933')
                    ), 
                    'alignment' => array(
                        'horizontal' => PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER,
                        'vertical' => PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER
                    ), 
                    'font' => array(
                        'bold'  => true,
                        'color' => array('rgb' => 'FFFFFF'),
                        'size'  => 15,
                        'name'  => 'Arial'
                    ))
                );
                $objPHPExcel->getActiveSheet()->getStyle('S13:U13')->applyFromArray(
                    array('fill' => array(
                        'fillType' => PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID,
                        'color' => array('rgb' => '92d050')
                    ), 
                    'alignment' => array(
                        'horizontal' => PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER,
                        'vertical' => PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER
                    ), 
                    'font' => array(
                        'bold'  => true,
                        'color' => array('rgb' => 'FFFFFF'),
                        'size'  => 15,
                        'name'  => 'Arial'
                    ))
                );
        
                //Tamaño de la columnas
                foreach(range('F','X') as $columnID) {
                    $objPHPExcel->getActiveSheet()->getColumnDimension($columnID)->setWidth(12);
                }
                $objPHPExcel->getActiveSheet()->getColumnDimension('A')->setWidth(14.16);
                $objPHPExcel->getActiveSheet()->getColumnDimension('B')->setWidth(14.16);
                $objPHPExcel->getActiveSheet()->getColumnDimension('C')->setWidth(16.8);
                $objPHPExcel->getActiveSheet()->getColumnDimension('I')->setWidth(16.8);
                $objPHPExcel->getActiveSheet()->getColumnDimension('D')->setWidth(39);
                $objPHPExcel->getActiveSheet()->getColumnDimension('E')->setWidth(42.6);
        
                $name = $qPaquete['titulo'];
                header('Content-Type: application/vnd.ms-excel');
                header('Content-Disposition: attachment;filename="' . $name . '(' . date('d-m-Y') . ').xls"');
                header('Cache-Control: max-age=0'); //no cache
                $objWriter = PhpOffice\PhpSpreadsheet\IOFactory::createWriter($objPHPExcel, 'Xls');
                // Forzamos a la descarga
                $objWriter->save('php://output');
            }
            else{
                $_SESSION['mensaje'] = 'Este paquete no tiene ningún presupuesto asociado.';
            }
        }
        else{
            $_SESSION['mensaje'] = 'No se encontro el paquete.';
        }
        redirect('rcomparativa_oc');
    }

    public function getInfoVer($idPaquete)
	    {
	        $paquete = $this->mpaquete->getById($idPaquete);
	        $qManoObra = $this->mmanoobra->getById($paquete['idManoObra']);
			$superficieM2 = $this->mprototipos->getCampo('superficieM2',$qManoObra['idPrototipo']);
	        $prototipo = $this->mprototipos->getById($qManoObra['idPrototipo']);

	        $material = $this->mmaterial->getByIdFraccIdProtIdMO($qManoObra['idFraccionamiento'], $qManoObra['idPrototipo'], $idPaquete);
	        
	        $detalle = $this->mdetallepaquete->getByIdPaquete($idPaquete);
	        if (!is_numeric($paquete) && !is_numeric($prototipo) && !is_numeric($material)) {
	            $presupuestoViv = $this->mpresupuestomat->getSumTotalImporte($material['id']);
	            $lotes = (!is_numeric($detalle)) ? $detalle->num_rows() : 0;
	            $presupuestoPaq = $presupuestoViv * $lotes;
	            $costoM2 = $presupuestoViv / $superficieM2;
	            $response = array('prototipo' => $prototipo['titulo'],
	                'fraccionamiento' => $this->mfraccionamiento->getCampo('titulo', $qManoObra['idFraccionamiento']),
	                'noCasas' => (!is_numeric($detalle))? $detalle->num_rows() : 0,
	                'presupuestoViv' => precio_format($presupuestoViv),
	                'presupuestoPaq' => precio_format($presupuestoPaq),
	                'costoM2' => precio_format($costoM2),
	                'm2Viv' => $prototipo['superficieM2']
	            );
	        } else {
	            $response = 0;
	        }
	        return $response;
	    }
}