<?php
    defined('BASEPATH') OR exit('No direct script access allowed');

    class Rcomisiones extends MX_Controller {
        public $data,$vParameters,$mainView,$fv;

        public function __construct() {
            $this->nsession = $this->config->item('nsession');
            if (!isset($_SESSION[$this->nsession]) || (($_SESSION[$this->nsession]['usuario'] == ""))) redirect('login');
            $this->fv = 'rcomisiones'; // form validation variable
            $this->mainView = 'rcomisiones';
            $this->data['fjs'] = '';
            $this->data['js'] = '
                    <script type="text/javascript" src="https://cdn.datatables.net/fixedheader/3.1.3/js/dataTables.fixedHeader.min.js"></script>
                    <script src="assets/js/rcomisiones/listado.js" type="text/javascript"></script>';
            $this->data['css'] = '<link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/1.10.16/css/jquery.dataTables.min.css">
                                  <link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/fixedheader/3.1.3/css/fixedHeader.dataTables.min.css">';
            // Tools
            $this->load->helper(array('tools','numeros','url','form','date','text','security'));
            // Modelos
            $this->load->model(array('mproyecto','mfraccionamiento','mprototipoxfraccionamiento','mprospecto','musuario'));
            $this->config->set_item('rol', $_SESSION[$this->nsession]['rol']);
            // Lbrerias
            $this->load->library('csvimport');
            $this->data['fotos_www'] = $this->config->item('base_www')."csv/";
            // $this->data['fotos_www'] = '/home/puntapro/www/uploads/inicio/';

            //Validación de usuarios
            valSession("ventas",$this->fv);
        }

        public function index(){
            $data['q'] = '';
            $data["promotores"]=$this->musuario->getPromotores();
            $this->data['contenido'] = $this->load->view($this->mainView.'/index_view',$data,true);
            $this->load->view('templates/main_template',$this->data);
        }

        public function getTotal($info){
            $total = $this->mproyecto->getComisiones($info,false,true);
            echo json_encode($total);
        }

        public function export_csv($info=""){
            $this->load->dbutil();
            $this->load->helper('download');

            $query = $this->mproyecto->getComisiones($info,true);
            if(!is_numeric($query)){
                $csv = mb_convert_encoding($this->dbutil->csv_from_result($query, ",", "\n"), "ISO-8859-1", "UTF-8");
                $date=new DateTime();
                $name = "Reporte de Comisiones ".$date->format("d-m-Y").".csv";
                force_download($name, $csv);
            }else{
                redirect('rcomisiones');
            }
        }

        public function listado($info=""){
            $q = $this->mproyecto->getComisiones($info);

            if ( !is_numeric($q) ) {
                foreach ($q->result() as $row){
                    $fechaVenta=($row->fechaVenta != "") ? new DateTime($row->fechaVenta) : "";
                    $array['aaData'][] = array(
                        'fraccionamiento' => $this->mfraccionamiento->getCampo('titulo',$row->idFraccionamiento),
                        'idPromotor' => $row->idPromotor,
                        'lote' => ($_SESSION["viv"]["rol"]==1) ? "<a href='proyectos/ver/".$row->idVivienda."'>".$row->lote."</div>" : $row->lote,
                        'manzana' => $row->manzana,
                        'calle' => $row->calle,
                        'nOficial' => $row->nOficial,
                        'fechaVenta' => $fechaVenta->format("d-m-Y"),
                        'tipoPromotor' => $row->tipoPromotor,
                        'cierre' => "<div style='text-align:right;margin-right:9px;'>$".number_format($row->cierre,2)."</div>",
                        'comision' => $row->comision."%",
                        'importeComision' => "<div style='text-align:right;margin-right:9px;'>$".number_format($row->importeComision,2)."</div>",
                        );
                }
            } else{
                $array['aaData'][] = array(
                    'fraccionamiento' => 'No hay registros',
                    'idPromotor' => 'No hay registros',
                    'lote' => 'No hay registros',
                    'manzana' => 'No hay registros',
                    'calle' => 'No hay registros',
                    'nOficial' => 'No hay registros',
                    'fechaVenta' => 'No hay registros',
                    'tipoPromotor' => 'No hay registros',
                    'cierre' => 'No hay registros',
                    'comision' => 'No hay registros',
                    'importeComision' => 'No hay registros'
                    );

            }

            echo json_encode($array);
        }
    }
?>