<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Ratencion extends MX_Controller {
	public $data,$vParameters,$mainView,$fv;
	public function __construct(){
        $this->nsession = $this->config->item('nsession');
        if (!isset($_SESSION[$this->nsession]) || (($_SESSION[$this->nsession]['usuario'] == ""))) redirect('login');

            $this->fv = 'ratencion'; // form validation variable
            $this->mainView = 'ratencion';
            $this->data['fjs'] = '';
            $this->data['js'] = ' <script src="assets/js/ratencion/listado.js" type="text/javascript"></script>
                                  <script src="assets/js/ratencion/listadoDetalle.js" type="text/javascript"></script>';
            $this->data['css'] = '';
            // Tools
            $this->load->helper(array('tools','numeros','url','form','date','text','security'));
            // Modelos
            $this->load->model(array('mprospecto','musuario','mfraccionamiento','maltaventa','mproyecto','mprototipos','mprototipoxfraccionamiento','mfraccionamientoxusuario'));

            // Debugging
            $this->output->enable_profiler(false);

           //Validación de usuarios
           valSession("mercadotecnia",$this->fv);
    }

	public function index(){
        $this->data['js'] = ' <script src="assets/js/ratencion/listado.js" type="text/javascript"></script>';
		$data['q'] = '';
        $this->data['contenido'] = $this->load->view($this->mainView.'/index_view',$data,true);
        $this->load->view('templates/main_template',$this->data);
	}

    public function listado(){
        $q = $this->mprospecto->getReporteAtencion();
        if (!is_numeric($q)){
            foreach ($q->result() as $row){
                $array['aaData'][] = array(
                    'promotor' => "<a href='ratencion/detalle/".$row->idPromotor."'>".$row->promotor."</a>",
                    'promedio' => number_format($row->promedio,0)." MINS"
                    );
            }
        }else{
            $array['aaData'][] = array(
                'promotor'=> 'No hay registros',
                'promedio' => 'No hay registros'
                );

        }
        echo json_encode($array);
    }

    public function detalle($idPromotor){
        $this->data['js'] = '<script src="assets/js/ratencion/listadoDetalle.js" type="text/javascript"></script>';
        $data["idPromotor"]=$idPromotor;
        $data["promotor"]=$this->musuario->getCampo("nombre",$idPromotor);
        $this->data['contenido'] = $this->load->view($this->mainView.'/detalle',$data,true);
        $this->load->view('templates/main_template',$this->data);
    }

    public function listadoDetalle(){
        $info= $_REQUEST['info'];
        $q = $this->mprospecto->getReporteAtencionDetalle($info);

        if (!is_numeric($q)){
            foreach ($q->result() as $row){
                $fechaAsignacion=New DateTime($row->fechaAsignacion);
                $fechaAtencion=New DateTime($row->fechaAtencion);

                $array['aaData'][] = array(
                    'promotor' => $row->promotor,
                    'fechaAsignacion' => $fechaAsignacion->format("d-m-Y"),
                    'horaAsignacion' =>$row->horaAsignacion ,
                    'fechaAtencion' => $fechaAtencion->format("d-m-Y"),
                    'horaAtencion' => $row->horaAtencion,
                    'tiempo' => $row->tiempo
                    );
            }
        }else{
            $array['aaData'][] = array(
                'promotor'=> 'No hay registros',
                'fechaAsignacion'=> 'No hay registros',
                'horaAsignacion'=> 'No hay registros',
                'fechaAtencion'=> 'No hay registros',
                'horaAtencion'=> 'No hay registros',
                'tiempo' => 'No hay registros'
                );

        }
        echo json_encode($array);
    }

}

?>