<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Publicidad_prospeccion extends MX_Controller {
	public $data,$vParameters,$mainView,$fv;
	public function __construct(){
        $this->nsession = $this->config->item('nsession');
        if (!isset($_SESSION[$this->nsession]) || (($_SESSION[$this->nsession]['usuario'] == ""))) redirect('login');

            $this->fv = 'publicidad_prospeccion'; // form validation variable
            $this->mainView = 'publicidad_prospeccion';
            $this->data['fjs'] = '';
            $this->data['js'] = ' <script src="assets/js/publicidad_prospeccion/publicidad_prospeccion.js" type="text/javascript"></script>';
            $this->data['css'] = '';
            // Tools
            $this->load->helper(array('tools','numeros','url','form','date','text','security'));
            // Modelos
            $this->load->model(array('mprospecto','musuario','mfraccionamiento','maltaventa','mproyecto','mprototipos','mprototipoxfraccionamiento','mfraccionamientoxusuario'));

            // Debugging
            $this->output->enable_profiler(false);

           //Validación de usuarios
	        valSession("ventas",$this->fv);
    }

	public function index(){
		$data['q'] = '';

        $this->data['js'] .= ' <script src="assets/js/publicidad_prospeccion/listado.js" type="text/javascript"></script>';

        //$delDia = $this->mprospecto->getCurrentDay();
        //print_r($delDia);exit();
        $this->data['contenido'] = $this->load->view($this->mainView.'/index_view',$data,true);
        $this->load->view('templates/main_template',$this->data);
	}

    public function listado(){

        $q = $this->mprospecto->getAllPublicidadP();

        if (!is_numeric($q)){
            foreach ($q->result() as $row){
                $av = $this->maltaventa->getByIdProspecto($row->id);
                if (!is_numeric($av)){
                    $idProyecto = $av['idProyecto'];
                }else{
                    $idProyecto = 100000;
                }
                $array['aaData'][] = array(
                    'promotor' => $this->musuario->getCampo('nombre',$row->idPromotor).' '.$this->musuario->getCampo('apellidoP',$row->idPromotor),
                    'nombre' => $row->nombre." ".$row->apellidoP,
                    'lugarProspeccion' => $row->lugarProspeccion, //medio de conocimiento
                    'otroLugar' => $row->otroLugar, //medio de conocimiento
                    'nss' => $row->nss.".", 
                    'tCreditoInteresado' => $row->tCreditoInteresado, 
                    'fechaNac' => ($row->fechaNac!='' && $row->fechaNac!='000-00-00')?date('d/m/Y',strtotime($row->fechaNac)):'',
                    'telefono' => $row->telefono,
                    'horaAtencion' => $row->horaAtencion,

                    'rfc' => $row->rfc,                    
                    'nombreConyuge' => $row->nombre2." ".$row->apellidoP2,
                    'rfcConyuge' => $row->rfc2,
                    'desarrollo' => $this->mfraccionamiento->getCampo('titulo',$row->idFraccionamiento),
                    'interesadoEn' =>  $this->mfraccionamiento->getCampo('titulo',$row->idFraccionamiento),//$row->interesadoEn,
                    'prototipo' => ($row->idPrototipo>0)?$this->mprototipos->getCampo("nombre",$row->idPrototipo):'', //$row->prototipo,
                    'fecha' => date_format(new DateTime($row->fecha),'d-m-Y'),//date_format($row->fecha, "d-m-Y"),
                    'statusVivienda' => estatus_proyecto_reporte($this->mproyecto->getCampo('statusVenta',$idProyecto)),
                    'acciones' => accionesP($row->id,$this->router->class, true, true, false)
                    );
            }
        }else{
            $array['aaData'][] = array(
                'promotor'=> 'No hay registros',
                'nombre' => 'No hay registros',
                'lugarProspeccion' => 'No hay registros',
                'otroLugar' => 'No hay registros',
                'nss' => 'No hay registros',
                'tipoCredito' => 'No hay registros', 
                'fechaNac' => 'No hay registros', 
                'telefono' => 'No hay registros',
                'horaAtencion' => 'No hay registros',

                'rfc' => 'No hay registros',                
                'nombreConyuge' => 'No hay registros',
                'rfcConyuge' => 'No hay registros',
                'desarrollo' => 'No hay registros',
                'interesadoEn' => 'No hay registros',                
                'prototipo' => 'No hay registros',
                'fecha' => 'No hay registros',                
                'statusVivienda' => 'No hay registros',
                'acciones' => 'No hay registros'
                );

        }

        echo json_encode($array);
    }

    public function listado2(){

        $q = $this->mprospecto->getAllPublicidadP();

        if (!is_numeric($q)){
            foreach ($q->result() as $row){
                $av = $this->maltaventa->getByIdProspecto($row->id);
                if (!is_numeric($av)){
                    $idProyecto = $av['idProyecto'];
                }else{
                    $idProyecto = 100000;
                }
                $array['aaData'][] = array(
                    'promotor' => $this->musuario->getCampo('nombre',$row->idPromotor).' '.$this->musuario->getCampo('apellidoP',$row->idPromotor),
                    'nombre' => $row->nombre." ".$row->apellidoP,
                    'lugarProspeccion' => $row->lugarProspeccion, //medio de conocimiento
                    'otroLugar' => $row->otroLugar, //medio de conocimiento
                    'nss' => $row->nss.".", 
                    'tCreditoInteresado' => $row->tCreditoInteresado, 
                    'tipoCredito' => $row->tipoCredito, //el registrado oficial 
                    'otroTCredito' => $row->otroTCredito,
                    'curp' => $row->curp,
                    'importe' => precio_format($row->importe),
                    'fechaNac' => ($row->fechaNac!='' && $row->fechaNac!='000-00-00')?date('d/m/Y',strtotime($row->fechaNac)):'',
                    'telefono' => $row->telefono,
                    'horaAtencion' => $row->horaAtencion,

                    'rfc' => $row->rfc,                    
                    'nombreConyuge' => $row->nombre2." ".$row->apellidoP2,
                    'rfcConyuge' => $row->rfc2,
                    'desarrollo' => $this->mfraccionamiento->getCampo('titulo',$row->idFraccionamiento),
                    'interesadoEn' =>  $this->mfraccionamiento->getCampo('titulo',$row->idFraccionamiento),//$row->interesadoEn,
                    'prototipo' => ($row->idPrototipo>0)?$this->mprototipos->getCampo("nombre",$row->idPrototipo):'', //$row->prototipo,
                    'fecha' => date_format(new DateTime($row->fecha),'d-m-Y'),//date_format($row->fecha, "d-m-Y"),
                    'fechaCita' => ($row->fechaCita!='' && $row->fechaCita!='000-00-00')?date('d/m/Y',strtotime($row->fechaCita)):'',
                    'statusVivienda' => estatus_proyecto_reporte($this->mproyecto->getCampo('statusVenta',$idProyecto)),
                    'acciones' => accionesP($row->id,$this->router->class, true, true, false)
                    );
            }
        }else{
            $array['aaData'][] = array(
                'promotor'=> 'No hay registros',
                'nombre' => 'No hay registros',
                'lugarProspeccion' => 'No hay registros',
                'otroLugar' => 'No hay registros',
                'nss' => 'No hay registros',
                'tCreditoInteresado' => 'No hay registros',
                'tipoCredito' => 'No hay registros', 
                'otroTCredito' => 'No hay registros', 
                'curp' => 'No hay registros', 
                'importe' => 'No hay registros', 
                'fechaNac' => 'No hay registros', 
                'telefono' => 'No hay registros',
                'horaAtencion' => 'No hay registros',

                'rfc' => 'No hay registros',                
                'nombreConyuge' => 'No hay registros',
                'rfcConyuge' => 'No hay registros',
                'desarrollo' => 'No hay registros',
                'interesadoEn' => 'No hay registros',                
                'prototipo' => 'No hay registros',
                'fecha' => 'No hay registros',                
                'fechaCita' => 'No hay registros',
                'statusVivienda' => 'No hay registros',
                'acciones' => 'No hay registros'
                );

        }

        echo json_encode($array);
    }

    public function recopilacion(){
        $data['q'] = '';

        $this->data['js'] .= ' <script src="assets/js/publicidad_prospeccion/recopilacion.js" type="text/javascript"></script>';

        $this->data['contenido'] = $this->load->view($this->mainView.'/recopilacion_view',$data,true);
        $this->load->view('templates/main_template',$this->data);
    }

    public function nuevo()
    {

        // Mensajes
        $data['msg'] = '';
        $data['promotores'] = [];
        $data['prototipos'] = [];
        // $data['promotores'] = $this->musuario->getPromotoresBySelectResult();
        $data['fraccionamientos'] = $this->mfraccionamiento->getAll();
        // $data['prototipos'] = $this->mprototipoxfraccionamiento->getAllList();
        // $data['prototipos'] = 0;
        $this->load->library('form_validation');

        $this->form_validation->set_rules('idFraccionamiento', 'Fraccionamiento', 'required');
        $this->form_validation->set_rules('idPromotor', 'Promotor', 'required');
        $this->form_validation->set_rules('nombre', 'Nombre', 'required');
        $this->form_validation->set_rules('apellidoP', 'Apellido Paterno', 'required');
        $this->form_validation->set_rules('apellidoM', 'Apellido Materno', 'trim');
        $this->form_validation->set_rules('telefono', 'Teléfono', 'trim');
        $this->form_validation->set_rules('fecha', 'Fecha', 'trim');
        $this->form_validation->set_rules('fechaAtencion', 'Fecha de Atención', 'trim');
        $this->form_validation->set_rules('horaAtencion', 'Hora de Atención', 'trim');
        $this->form_validation->set_rules('fechaNac', 'Fecha de nacimiento', 'trim');
        $this->form_validation->set_rules('lugarProspeccion', 'Medio de conocimiento', 'trim');
        $this->form_validation->set_rules('otroLugar', 'Descripción medio', 'trim');
        $this->form_validation->set_rules('statusProspecto', 'Estatus prospecto', 'trim');
        $this->form_validation->set_rules('idPrototipo', 'Prototipo', 'required');
        $this->form_validation->set_rules('comentario', 'Comentarios', 'trim');

        $aplicaNSS = $this->input->post('aplicaNSS', TRUE);
        $data['aplicaNSS'] = $aplicaNSS;
        if ($aplicaNSS==1){
            $this->form_validation->set_rules('nss', 'NSS', 'required|exact_length[11]');
        }else{
            $this->form_validation->set_rules('nss', 'NSS', 'trim|exact_length[11]');
        }

        $lugarProspeccion = $this->input->post('lugarProspeccion', TRUE);
        $data['descripcionLP'] = ($lugarProspeccion=='otros' || $lugarProspeccion=='television' || $lugarProspeccion == 'radio' || $lugarProspeccion == 'volante' || $lugarProspeccion == 'visita a empresa' || $lugarProspeccion == 'visita colonia')?true:false;

        if ($this->form_validation->run() == FALSE) {//$this->fv
            $data['msg'] = validation_errors();
            $idFraccionamiento = $this->input->post('idFraccionamiento', TRUE);
            if ( $idFraccionamiento != '' && $idFraccionamiento > 0 ) {
                $data['promotores'] =  $this->getPromotores($idFraccionamiento);
                $data['prototipos'] =  $this->getPrototiposByFraccForSelect($idFraccionamiento);
                // echo "<pre>"; print_r($data); echo "</pre>"; exit();
            }
            else {
                $data['promotores'] = [];
                $data['prototipos'] = [];
            }

        } else {
            $pData['idPromotor'] = $this->input->post('idPromotor', TRUE);
            $pData['fechaAsignacion'] = date('Y-m-d H:i:s');
            $pData['horaAsignacion'] = date('H:i:s');
            $pData['notificacionRecopilacion'] = 0;
            $pData['curp'] = $this->input->post('curp', TRUE);
            $pData['nombre'] = $this->input->post('nombre', TRUE);
            $pData['apellidoP'] = $this->input->post('apellidoP', TRUE);
            $pData['apellidoM'] = $this->input->post('apellidoM', TRUE);
            $pData['rfc'] = $this->input->post('rfc', TRUE);
            $pData['telefono'] = $this->input->post('telefono', TRUE);
            $pData['nombre2'] = $this->input->post('nombre2', TRUE);
            $pData['apellidoP2'] = $this->input->post('apellidoP2', TRUE);
            $pData['apellidoM2'] = $this->input->post('apellidoM2', TRUE);
            $pData['rfc2'] = $this->input->post('rfc2', TRUE);
            $pData['telefono2'] = $this->input->post('telefono2', TRUE);
            $fecha = $this->input->post('fecha', TRUE);
            $fecha =  str_replace('/', '-', $fecha);
            $pData['fecha'] = ($fecha!='')?date('Y-m-d', strtotime($fecha)):'0000-00-00';//date_format(new DateTime($fecha),'Y-m-d');

            $fechaAtencion = $this->input->post('fechaAtencion', TRUE);
            $fechaAtencion =  str_replace('/', '-', $fechaAtencion);
            $pData['fechaAtencion'] = ($fechaAtencion!='')?date('Y-m-d', strtotime($fechaAtencion)):'0000-00-00';
            $horaAtencion = $this->input->post('horaAtencion', TRUE);
            $pData['horaAtencion'] = ($horaAtencion!='')?$horaAtencion:"00:00";
            $pData['tCreditoInteresado'] = $this->input->post('tCreditoInteresado', TRUE);            

            $fechaNac = $this->input->post('fechaNac', TRUE);
            $fechaNac =  str_replace('/', '-', $fechaNac);
            $pData['fechaNac'] = ($fechaNac!='')?date('Y-m-d', strtotime($fechaNac)):'0000-00-00';//date_format(new DateTime($fechaNac),'Y-m-d');
            $fechaNac2 = $this->input->post('fechaNac2', TRUE);
            $fechaNac2 =  str_replace('/', '-', $fechaNac2);
            $pData['fechaNac2'] = ($fechaNac2!='')?date('Y-m-d', strtotime($fechaNac2)):'0000-00-00';
            $pData['paisNac'] = $this->input->post('paisNac', TRUE);
            $pData['nacionalidad'] = $this->input->post('nacionalidad', TRUE);
            $pData['paisResidencia'] = $this->input->post('paisResidencia', TRUE);
            $pData['lugarProspeccion'] = $lugarProspeccion;
            $pData['otroLugar'] = $this->input->post('otroLugar', TRUE);
            $pData['nss'] = $this->input->post('nss', TRUE);
            $pData['statusProspecto'] = $this->input->post('statusProspecto', TRUE);
            $pData['comentario'] = $this->input->post('comentario', TRUE);
            //$pData['interesadoEn'] = $this->input->post('interesadoEn', TRUE);
            $pData['prototipo'] = $this->input->post('prototipo', TRUE);
            $pData['idPrototipo'] = $this->input->post('idPrototipo', TRUE);
            $pData['status'] = 1;
            $pData['idFraccionamiento'] = $this->input->post('idFraccionamiento', TRUE);//$_SESSION[$this->nsession]['idFraccionamiento'];

            $pData['mercadotecnia'] = 2; // INDICA QUE VIENE DE MÓDULO PUBLICIDAD

            $validNss = $this->mprospecto->existNss($pData['nss']);
            if ($validNss == 0 || $pData['nss']==''){ // validamos que sea un nss no registrado
                $id = $this->mprospecto->insertar($pData);
                //$this->db->query("UPDATE prospectos SET created_by=".$pData['idPromotor']." WHERE id=".$id);
                

                //$autores = $this->autoRespuesta($pData);
                redirect($this->router->class);
            }else{
                $data['msgInvalid'] = 'El NSS ya se encuentra registrado';
            }

        }

        $this->data['contenido'] = $this->load->view($this->mainView . '/nuevo_view', $data, true);
        $this->load->view('templates/main_template', $this->data);
    }

    public function editar($id)
    {
        // Mensajes
        $msg = '';
        /* VALIDAR FORMULARIO*/
        $this->load->library('form_validation');

        if (isset($_POST['tipoCredito'])) {
            if ($this->form_validation->run($this->fv) == FALSE) {
                $msg = validation_errors();
            } else {
                $pData['idPromotor'] = $this->input->post('idPromotor', TRUE);

                $idPromotorOld = $this->mprospecto->getCampo('idPromotor',$id);

                $idPromotorNew= $this->musuario->getCampo("id",$pData['idPromotor']);
                if ($idPromotorOld!=$idPromotorNew){
                    $pData['fechaAsignacion'] = date('Y-m-d H:i:s');
                    $pData['horaAsignacion'] = date('H:i:s');
                    $pData['notificacionRecopilacion'] = 0;
                }

                $pData['curp'] = $this->input->post('curp', TRUE);

                //Nuevos campos captación
                $pData['tipoCredito'] = $this->input->post('tipoCredito', TRUE);
                $importe = $this->input->post('importe', TRUE);
                $pData['importe'] = toInt($importe);
                $pData['otroTCredito'] = $this->input->post('otroTCredito', TRUE);
                $fechaCita = $this->input->post('fechaCita', TRUE);
                $fechaCita =  str_replace('/', '-', $fechaCita);
                $pData['fechaCita'] = ($fechaCita!='')?date('Y-m-d', strtotime($fechaCita)):'0000-00-00';

                //$pData['nombre'] = $this->input->post('nombre', TRUE);
                //$pData['apellidoP'] = $this->input->post('apellidoP', TRUE);
                //$pData['apellidoM'] = $this->input->post('apellidoM', TRUE);
                //$pData['telefono'] = $this->input->post('telefono', TRUE);

                $pData['rfc'] = $this->input->post('rfc', TRUE);
                
                $pData['nombre2'] = $this->input->post('nombre2', TRUE);
                $pData['apellidoP2'] = $this->input->post('apellidoP2', TRUE);
                $pData['apellidoM2'] = $this->input->post('apellidoM2', TRUE);
                $pData['rfc2'] = $this->input->post('rfc2', TRUE);
                $pData['telefono2'] = $this->input->post('telefono2', TRUE);
                $fecha = $this->input->post('fecha', TRUE);
                $fecha =  str_replace('/', '-', $fecha);
                $pData['fecha'] = ($fecha!='')?date('Y-m-d', strtotime($fecha)):'0000-00-00';//date_format(new DateTime($fecha),'Y-m-d');
                $fechaNac = $this->input->post('fechaNac', TRUE);
                $fechaNac =  str_replace('/', '-', $fechaNac);
                $pData['fechaNac'] = ($fechaNac!='')?date('Y-m-d', strtotime($fechaNac)):'0000-00-00';
                $fechaNac2 = $this->input->post('fechaNac2', TRUE);
                $fechaNac2 =  str_replace('/', '-', $fechaNac2);
                $pData['fechaNac2'] = ($fechaNac2!='')?date('Y-m-d', strtotime($fechaNac2)):'0000-00-00';
                $pData['paisNac'] = $this->input->post('paisNac', TRUE);
                $pData['nacionalidad'] = $this->input->post('nacionalidad', TRUE);
                $pData['paisResidencia'] = $this->input->post('paisResidencia', TRUE);
                //$pData['lugarProspeccion'] = $this->input->post('lugarProspeccion', TRUE);
                $pData['otroLugar'] = $this->input->post('otroLugar', TRUE);
                $pData['nss'] = $this->input->post('nss', TRUE);
                $pData['statusProspecto'] = $this->input->post('statusProspecto', TRUE);
                $pData['comentario'] = $this->input->post('comentario', TRUE);
                //$pData['interesadoEn'] = $this->input->post('interesadoEn', TRUE);
                $pData['prototipo'] = $this->input->post('prototipo', TRUE);
                $pData['idPrototipo'] = $this->input->post('idPrototipo', TRUE);
                $pData['idFraccionamiento'] = $this->input->post('idFraccionamiento', TRUE);//$_SESSION[$this->nsession]['idFraccionamiento'];

                $this->mprospecto->actualizar($pData, $id);
                //$this->db->query("UPDATE prospectos SET created_by=".$pData['idPromotor']." WHERE id=".$id);
                redirect($this->router->class."?close");
            }
        }
        // Obteniendo la información
        $info = $this->mprospecto->getById($id);

        $data = $info;
        // echo "<pre>"; print_r($data); echo "</pre>"; exit();
        $data['msg']=$msg;
        // $data['promotores'] = $this->musuario->getPromotoresBySelectResult();
        $data['promotores'] = $this->musuario->getPromotoresBySelectResult2($info['idFraccionamiento']);
        $data['fraccionamientos'] = $this->mfraccionamiento->getAll();
        // $data['prototipos'] = $this->mprototipoxfraccionamiento->getAllList();
        $data['prototipos'] =  $this->getPrototiposByFraccForSelect($info['idFraccionamiento']);

        // echo "<pre>"; print_r($data['promotores']); echo "</pre>"; exit();

        $this->data['contenido'] = $this->load->view($this->mainView . '/editar_view', $data, true);
        $this->load->view('templates/main_template', $this->data);
    }

    public function getInfo(){
        $result = array();
        $id = $this->input->post('idProspecto', TRUE);
        if ($id > 0){
            $p_data = $this->mprospecto->getById($id);
            if (!is_numeric($p_data)){
                //$r = $p_data->row();
                // echo "<pre>"; print_r($p_data); echo "</pre>"; exit();
                $data['id'] = $p_data['id'];
                $data['idPromotor'] = $p_data['idPromotor'];

                $data['promotor'] = $this->musuario->getCampo("nombre",$data['idPromotor'])." ".$this->musuario->getCampo("apellidoP",$data['idPromotor']);
                $data['nombre'] = $p_data['nombre'];
                $data['apellidoP'] = $p_data['apellidoP'];
                $data['apellidoM'] = $p_data['apellidoM'];
                $data['nombre2'] = $p_data['nombre2'];
                $data['apellidoP2'] = $p_data['apellidoP2'];
                $data['apellidoM2'] = $p_data['apellidoM2'];
                $data['rfc'] = $p_data['rfc'];
                $data['telefono'] = $p_data['telefono'];
                $data['fecha'] = date_format(new DateTime($p_data['fecha']),'d/m/Y');
                $data['fechaNac'] = date_format(new DateTime($p_data['fechaNac']),'d/m/Y');
                $data['nss'] = $p_data['nss'];
                $data['statusProspecto'] = $p_data['statusProspecto'];
                $data['status'] = $p_data['status'];
                $data['success'] = 1;

                $data['idFraccionamiento'] = $p_data['idFraccionamiento'];
                $data['fraccionamiento'] = $this->mfraccionamiento->getCampo('titulo',$p_data['idFraccionamiento']);

                $lotes = $this->mproyecto->getBySelectResult2($p_data['idFraccionamiento']);
                //print_r($lotes);exit();
                $data['proyectos'] = (!is_numeric($lotes))?$lotes->result():$lotes;
                // echo "<pre>"; print_r($data); echo "</pre>"; exit();
            }else{
                $data['success'] = 0;
            }
        }else{
            $data['success'] = 0;
        }

        echo json_encode($data);
    }

    public function validarNss(){
        $nss = $this->input->post('nss', TRUE);
        $data['success'] = true;
        $validNss = $this->mprospecto->existNss($nss);
        if ($validNss!=0){
            $data['success'] = false;
        }
        if ($nss==''){
            $data['success'] = true;
        }
        echo json_encode($data);
    }

    public function eliminar(){
        $id = $this->input->post('elid');
        $q = $this->mprospecto->getById($id);
        $cValor = "true";
        $this->mprospecto->borrar($id);
        $data = json_encode(array("valor" => $cValor));
        echo $data;
    }

    public function ver($id = null)
    {
        $info = $this->mprospecto->getById($id);
        $data = $info;
        $data['module'] = 0;
        $data['mpromotor'] = $this->musuario;
        $data['mprototipos'] = $this->mprototipos;
        $data['mfraccionamiento'] = $this->mfraccionamiento;
        // echo "<pre>"; print_r($data); echo "</pre>"; exit();
        $this->data['contenido'] = $this->load->view($this->mainView . '/ver_view', $data, true);
        $this->load->view('templates/main_template', $this->data);
    }

    function autoRespuesta( $prospecto = null ) {
        // $copias = "ruben@navegantes.mx";

        /*$copiasNV = 'hsalinas@viviend.mx'. ', ';
        $copiasNV .= 'esalinas@viviend.mx';*/

        $copiasNV = 'sistemas@viviend.mx';

        // $para = $emailCliente; // Comprador

        $subject = 'Nuevo prospecto de vivienda'; // titulo

        $liga="http://viviend.mx/sistema/emailresources/";
        $liga2="http://viviend.mx/sistema/img/";
        $liga3="http://viviend.mx/sistema/";
        // $idFraccionamiento = $_SESSION['viv']['idFraccionamiento'];
        $idFraccionamiento = $prospecto['idFraccionamiento'];
        $fotoFracc = $this->mfraccionamiento->getCampo('foto',$idFraccionamiento);
        $urlLogoFracc = ($fotoFracc!=false)?'http://viviend.mx/sistema/uploads/fraccionamientos/'.$fotoFracc:'http://viviend.mx/sistema/img/logo-300.png';
        $tp = '';

        $data = array();

        $promotor = $this->musuario->getById($prospecto['idPromotor']);
        $nomPromotor = $promotor["nombre"]." ".$promotor["apellidoP"]." ".$promotor["apellidoM"];

        $cuerpo = '
                    <table id="table-prospecto" style="width: 80%;margin: 0 auto;border: 3px solid #EAC633;border-spacing: 0px;text-transform: uppercase;">
                        <tbody>
                            <tr>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> Fecha de prospección: </td>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.date_format(new DateTime($prospecto['fecha']), 'd/m/Y').' </td>
                            </tr>
                            <tr>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> Nombre de prospecto: </td>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$prospecto['nombre'].' '.$prospecto['apellidoP'].' '.$prospecto['apellidoM'].' </td>
                            </tr>
                            <tr>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> RFC: </td>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$prospecto['rfc'].' </td>
                            </tr>
                            <tr>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> Teléfono: </td>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$prospecto['telefono'].' </td>
                            </tr>
                            <tr>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> NSS: </td>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$prospecto['nss'].' </td>
                            </tr>
                            <tr>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> Fecha de nacimiento: </td>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.date_format(new DateTime($prospecto['fechaNac']), 'd/m/Y').' </td>
                            </tr>
                            <tr>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> Status prospecto: </td>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$prospecto['statusProspecto'].' </td>
                            </tr>
                            <tr>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> Lugar de prospección: </td>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$prospecto['lugarProspeccion'].' </td>
                            </tr>
                            <tr>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> Prototipo: </td>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$prospecto['prototipo'].' </td>
                            </tr>
                            <!-- <tr>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 14px;color: #548C43;font-weight: 800;"> Promotor: </td>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 13px;color: #8C8C8C;"> '.$nomPromotor.' </td>
                            </tr> -->
                            <tr>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> Comentarios: </td>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$prospecto['comentario'].' </td>
                            </tr>
                        </tbody>
                    </table>';


        $mensaje = '
        <!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 3.2 Final//EN">
        <html xmlns="http://www.w3.org/1999/xhtml">
        <head>
            <title>Email</title>
            <meta http-equiv="Content-Type" content="text/html; charset=utf-8">
            <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=yes" />
            <link href="https://fonts.googleapis.com/css?family=Lato:300,700" rel="stylesheet" type="text/css">
            <style>
                body, tr, td, span, div, p, a, li {
                    -moz-text-size-adjust:none !important;
                    -webkit-text-size-adjust:none !important;
                    margin:0px !important;
                    -ms-text-size-adjust:none !important;
                    white-space: wrap;
                }
                .lato-light{
                    font-family: "lato" sans-serif !important;
                    font-weight: 300;
                }
                .lato-bold{
                    font-family: "lato" sans-serif !important;
                    font-weight: 700;
                }
                td img {
                    display: block;
                }
                .ReadMsgBody {
                    width: 100%;
                }
                .ExternalClass * {
                    line-height: 100%;
                }

                table#table-prospecto td:nth-child(1) {
                    width: 50%;
                    padding-left: 10px;
                }
                table#table-prospecto td:nth-child(2) {
                    width: 50%;
                    padding-left: 10px;
                }

                @media only screen and (max-width:480px) {
                    #logosim{
                        padding:0!important;
                    }
                    *[class="code4email_wrapper"] {
                        width: 100% !important;
                    }
                    *[class="code4email_main_table"] {
                        width: 320px !important;
                    }
                    *[class="code4email_hide"] {
                        display: none !important;
                    }
                    *[class="code4email_hide"] {
                        display: none !important;
                    }
                    *[class="code4email_center"] {
                        text-align: center !important;
                        padding:10px !important;
                        height:20px !important;
                    }
                    *[class="code4email_clear"] {
                        width: 100% !important;
                        clear: both !important;
                        float: left !important;
                    }
                    *[class="code4email_br"] {
                        display:block !important;
                        width: 1px !important;
                        height:6px !important;
                        clear: both !important;
                    }
                    *[class="code4email_text_p10"] {
                        padding: 0px 10px 10px 10px !important;
                        height:20px !important;
                    }
                    *[class="code4email_w20"] {
                        width: 20px !important;
                    }
                    *[class="code4email_h20"] {
                        height: 20px !important;
                    }
                    *[class="code4email_h20_center"] {
                        height: 20px !important;
                        text-align: center !important;
                    }
                }
                @media only screen and (min-width:480px) and (max-width:599px) {
                    *[class="code4email_wrapper"] {
                        width: 100% !important;
                    }
                    *[class="code4email_main_table"] {
                        width: 480px !important;
                    }
                    *[class="code4email_hide"] {
                        display: none !important;
                    }
                    *[class="code4email_hide"] {
                        display: none !important;
                    }
                    *[class="code4email_center"] {
                        text-align: center !important;
                        padding:10px !important;
                        height:20px !important;
                    }
                    *[class="code4email_clear"] {
                        width: 100% !important;
                        clear: both !important;
                        float: left !important;
                    }
                    *[class="code4email_br"] {
                        display:block !important;
                        width: 1px !important;
                        height:6px !important;
                        clear: both !important;
                    }
                    *[class="code4email_text_p10"] {
                        padding: 0px 10px 10px 10px !important;
                        height:20px !important;
                    }
                    *[class="code4email_w20"] {
                        width: 20px !important;
                    }
                    *[class="code4email_h20"] {
                        height: 20px !important;
                    }
                    *[class="code4email_h20_center"] {
                        height: 20px !important;
                        text-align: center !important;
                    }
                }
            </style>
        </head>
        <body marginheight="0" marginwidth="0" leftmargin="0" topmargin="0" bgcolor="#FFFFFE" style="-moz-text-size-adjust:none !important; padding:0px !important; -webkit-text-size-adjust:none !important; margin:0px ! important; -ms-text-size-adjust:none !important; white-space: wrap;">
            <table class="code4email_wrapper" width="650px" border="0" cellspacing="0" cellpadding="0" align="center">
                <tr> <td colspan="" style="text-align: right !important;"> Fecha: '.date('d/m/Y').' </td> </tr>
                <tr>
                    <td align="center" valign="top" bgcolor="#FFFFFE"><table class="code4email_wrapper" align="center" border="0" cellpadding="0" cellspacing="0" width="650px" style="width:650px;">
                        <tr>
                            <td>
                                <a href="'.$liga3.'" target="_blank">
                                    <table   height="135px" background="" class="code4email_wrapper"  width="650px" border="0" cellspacing="0" cellpadding="0" align="center">
                                        <tr>
                                            <td  valign="middle" width="200" height="109" style="margin:0px; padding:10px 225px 10px 225px; height:109px; width: 200px;">
                                                <img width="280" src="'.$urlLogoFracc.'" />
                                            </td>
                                        </tr>
                                    </table>
                                </a>
                            </td>
                        </tr>
                        <tr>
                            <td align="left" valign="top" style="line-height:12px; padding:0px; margin:0px; font-size:12px; width:650px;">
                                <table class="code4email_wrapper" align="center" border="0" cellpadding="0" cellspacing="0" width="650" style="width:650px;">
                                    <tr>
                                        <td align="left" valign="middle" width="600" height="91" bgcolor="#FFFFFE" style="width:630px; margin:0px; height:91px; padding-bottom:15px; padding-top:25px; font-family: Arial, Helvetica, sans-serif; color: #333333; font-size: 14px; mso-line-height-rule:exactly; white-space: wrap; line-height:20px;" class="code4email_center"><span style="color: #5b5b5f; font-size: 14px; text-decoration: none;" class="lato-light">
                                            <h3 style="color: #57BA47;font-weight: bold;text-align: center;text-transform: uppercase;font-size:24px;margin-bottom: 0px;"> Nuevo prospecto </h3>
                                            <h4 style="color: #57BA47;font-weight: bold;text-align: center;text-transform: uppercase;font-size:16px;margin-top: 10px;"> De '.$nomPromotor.' </h4>
                                            <br><br>
                                            '.$cuerpo.'
                                        </td>
                                    </tr>
                                </table>
                                <div style="background: #548C43; width: 100%; border: 1px solid #548C43; height: 25px; margin-top: 75px !important;"></div>
                            </td>
                        </tr>
                    </td>
                </tr>
            </table>
        </body>
        </html>';

        // para el gerente de ventas -------------------------------------------------
        // Para enviar un correo HTML, debe establecerse la cabecera Content-type
        $cabeceras  = 'MIME-Version: 1.0' . "\r\n";
        $cabeceras .= "Content-type:text/html;charset=utf-8" . "\n";

        // $para = $this->musuario->getCampo("email", $this->musuario->getGerente());
        $para = $this->musuario->getCampo("email", $this->musuario->getGerente2($idFraccionamiento));

        // Cabeceras adicionales
        $cabeceras .= 'From: Viviend <contacto@viviend.mx>' . "\r\n";
        if ($para){
            mail($para, $subject, $mensaje, $cabeceras);
        }

        // Enviar autorespuesta a gestores por fraccionamiento -------------
        $gestores = $this->mfraccionamientoxusuario->getGestoriaSelectResultByIdFracc($idFraccionamiento);
        if ( !is_numeric($gestores) ) {
            $correoGestor = '';
            $bandRow = 0;
            foreach ($gestores->result() as $key => $value) {
                if ( $bandRow > 0 ) { $correoGestor .= ", "; }
                $correoGestor .= $this->musuario->getCampo('email',$value->id);
                $bandRow = $bandRow + 1;
            }
            mail($correoGestor, $subject, $mensaje, $cabeceras);
        }

        $subject2 = $subject;

        // para el gerente  -------------------------------------------------
        $cabecerasAdmin  = 'MIME-Version: 1.0' . "\r\n";
        $cabecerasAdmin .= "Content-type:text/html;charset=utf-8" . "\n";

        // Cabeceras adicionales
        $cabecerasAdmin .= 'From: Viviend <contacto@viviend.mx>' . "\r\n";

        // para el administrador
        mail($copiasNV, $subject2, $mensaje, $cabecerasAdmin);

        return true;
    }

    public function getPromotores($id='')
    {
        $promotores = $this->mfraccionamientoxusuario->getPromotoresSelectResultByIdFracc($id);
        $response = array();
        if ( !is_numeric($promotores) ) {
            foreach ($promotores->result() as $key => $value) {
                $response[$value->id] = $this->musuario->getCampo('nombre',$value->id)." ".$this->musuario->getCampo('apellidoP',$value->id)." ".$this->musuario->getCampo('apellidoM',$value->id);
            }
        }
        else {
            $response = [];
        }
        return $response;
    }

    public function getPrototiposByFracc($id='')
    {
        $prototipos = $this->mprototipoxfraccionamiento->getByIdFraccionamiento($id);
        $array = array();
        $response = array();
        if ( !is_numeric($prototipos) ) {
            foreach ($prototipos->result() as $key => $value) {
                $array = array(
                    'id' => $value->idPrototipo,
                    'titulo' => $this->mprototipos->getCampo('nombre',$value->idPrototipo)
                );
                array_push($response, $array);
            }
        }
        else {
            $response = 0;
        }
        echo json_encode($response);
    }

    public function getPrototiposByFraccForSelect($id='')
    {
        $prototipos = $this->mprototipoxfraccionamiento->getByIdFraccionamiento($id);
        $array = array();
        $response = array();
        if ( !is_numeric($prototipos) ) {
            foreach ($prototipos->result() as $key => $value) {
                $response[$value->idPrototipo] = $this->mprototipos->getCampo('nombre',$value->idPrototipo);
            }
        }
        else {
            $response = [];
        }
        return $response;
    }
}

?>