<?php
	defined('BASEPATH') OR exit('No direct script access allowed');

	class Prototipos extends MX_Controller {
		public $data,$vParameters,$mainView,$fv;

		public function __construct() {
			$this->nsession = $this->config->item('nsession');
			if (!isset($_SESSION[$this->nsession]) || (($_SESSION[$this->nsession]['usuario'] == ""))) redirect('login');
			$this->fv = 'prototipos'; // form validation variable
			$this->mainView = 'prototipos';
			$this->data['fjs'] = '';
			$this->data['js'] = ' <script src="assets/js/prototipos/listado.js" type="text/javascript"></script>';

			$this->data['css'] = '';
			// Tools
            $this->load->helper(array('tools','numeros','url','form','date','text','security'));
            // Modelos
            $this->load->model(array('mprototipos','musuario','mactividadesprototipo','mcategoriamo','mactividadmo','munidades','mmateriales','mmaterialesactividadprototipo','mactividadmo'));
            // Librerias
            $this->load->library('csvimport');
            //$this->load->library('excel');
            $this->data['fotos_www'] = $this->config->item('base_www').'/prototipos/';

            $this->config->set_item('rol',$_SESSION[$this->nsession]['rol']);

            //Validación de usuarios
			valSession("ventas",$this->fv);
		}

		public function index(){
			$data['q'] = '';
	        $this->data['contenido'] = $this->load->view($this->mainView.'/index_view',$data,true);
	        $this->load->view('templates/main_template',$this->data);
		}

		public function listado(){
	        $q = $this->mprototipos->getAll();

	        if (!is_numeric($q)){
	            foreach ($q->result() as $row){
	                $array['aaData'][] = array(
	                    'nombre' => $row->nombre,
	                    'acciones' => accionesPrototipos($row->id,$this->router->class,false, true, true, false)
	                );
	            }
	        } else{
	            $array['aaData'][] = array(
	                'nombre' => 'No hay registros',
	                'acciones' => 'No hay registros'
	                );
	        }

	        echo json_encode($array);
	    }

	    public function getUnidades($id=null){
	       	$idUnidad = $this->mmateriales->getCampo2('idUnidad',$id);
	        $data['unidad'] = $this->munidades->getCampo2('unidad',$idUnidad).' '.$this->munidades->getCampo2('abreviatura',$idUnidad);
	        $jdata = json_encode($data);
	        echo $jdata;
	    }

	    public function guardarMaterial(){
	        $id='';
	        $data['idActividadPrototipo'] = $this->input->post('actividadPrototipo', TRUE);
	        $data['idMaterial'] = $this->input->post('idMateriales', TRUE);
	        $data['cantidad'] = $this->input->post('cantidad', TRUE);
	        $data['success'] = $this->mmaterialesactividadprototipo->insertar($data);
	        $data = json_encode($data);
	        echo $data;
	    }

	     public function actualizarMaterial(){
	        $id='';
	        $id = $this->input->post('materialesactividadprototipo', TRUE);
	        //echo $id; exit();
	        $data['idActividadPrototipo'] = $this->input->post('actividadPrototipo', TRUE);
	        $data['idMaterial'] = $this->input->post('idMateriales', TRUE);
	        $data['cantidad'] = $this->input->post('cantidad', TRUE);
	        $data['success'] = $this->mmaterialesactividadprototipo->actualizar($data,$id);
	        $data = json_encode($data);
	        echo $data;
	    }

	    public function eliminarMaterial(){
	        $id = $this->input->post('materialesactividadprototipo', TRUE);
	        $cValor = "true";
	        $this->mmaterialesactividadprototipo->borrar($id);
	        $data = json_encode(array("valor" => $cValor));
	        echo $data;
	    }

	    public function agregarMaterial($id=null,$idPrototipo=null){
	        $data['q'] = '';
	        $data['id'] = $id;
	        $data['idPrototipo'] = $idPrototipo;
	        //echo $id; exit();
	        //$idActividadPrototipo = $this->mactividadesprototipo->getCampo2('idActividadPrototipo',$id);
	      	//echo $idActividadPrototipo; exit();
	        $idPrototipo= $this->mactividadesprototipo->getCampo2('idPrototipo',$id);
	        $data['prototipo']= $this->mprototipos->getCampo2('nombre',$idPrototipo);
	        $idCategoria= $this->mactividadesprototipo->getCampo2('idCategoria',$id);
	        $data['categoria']= $this->mcategoriamo->getCampo2('categoria',$idCategoria);
	        $idActividad= $this->mactividadesprototipo->getCampo2('idActividad',$id);
	        $data['actividad']= $this->mactividadmo->getCampo2('descripcion',$idActividad);


	        $arrayIds = $this->mmaterialesactividadprototipo->getIdsMateriales($id);
	        $data['materiales'] = $this->mmateriales->getMaterialesWhereNotIn($arrayIds);
	        $data['unidades'] = $this->munidades->getSelectResult();

	        $this->data['contenido'] = $this->load->view($this->mainView.'/agregarMaterial_view.php',$data,true);
	        $this->load->view('templates/main_template',$this->data);
	    }

	     public function listadoMat($id=0){
	        $data["msg"]="";
	        $idActividadPrototipo = $_REQUEST['idActividadPrototipo'];
	         $q = $this->mmaterialesactividadprototipo->getAllMaterialesbyidActividadPrototipo($idActividadPrototipo);
	            if (!is_numeric($q)){
	                foreach ($q->result() as $row){
	                    $idUnidad = $this->mmateriales->getCampo2('idUnidad',$row->idMaterial);
	                    $unidad = $this->munidades->getCampo2('abreviatura',$idUnidad);
	                    $nombreMat = $this->mmateriales->getCampo2('material',$row->idMaterial);
	                    //echo $nombreMat; exit();
	                    $array['aaData'][] = array(
	                        'id' => $row->id,
	                        'cantidad' => $row->cantidad,
	                        'idMaterial' => ($row->idMaterial != '')? $this->mmateriales->getCampo2('material',$row->idMaterial):'',
	                        'unidad' => ($row->idMaterial != '')? $unidad:'',
	                        'acciones' => accionesMAt($row->id,$this->router->class,true,true,$row->idMaterial,$row->cantidad,$nombreMat)
	                    );
	                }
	            }else{
	                $array['aaData'][] = array(
	                    'id' => 'No hay registros',
	                    'cantidad' => 'No hay registros',
	                    'idMaterial' => 'No hay registros',
	                    'unidad' => 'No hay registros',
	                    'acciones' => 'No hay registros'
	                    );
	            }
	            echo json_encode($array);
	    }

  			    //////PROGRAMA DE OBRA//////
	    public function programaObra($idPrototipo=0){
	    	$data['idPrototipo'] = $idPrototipo;
	    	$data["msg"]="";
    		$this->data['contenido'] = $this->load->view($this->mainView.'/programa_view',$data,true);
			$this->load->view('templates/main_template',$this->data);
	    }

		public function listadoProgramaObra($idPrototipo=0){
	        $categorias = $this->mactividadesprototipo->getCategoriasByPrototipo($idPrototipo);
	        $empty=true;

	        if (!is_numeric($categorias)){
	            foreach ($categorias->result() as $rowCategoria){
	                $array['aaData'][] = array(
	                    'id' => "",
	                    'tipo' => 1,
	                    'idCategoria' => $rowCategoria->categoria,
	                    'clave' => "",
	                    'titulo' => "",
	                    'cantidad' => "",
	                    'idUnidad' => "",
	                    'acciones' => ""
	                );

        			$actividades = $this->mactividadesprototipo->getAllByPrototipoCategoria($idPrototipo,$rowCategoria->idCategoria);
			        if (!is_numeric($actividades)){
			            foreach ($actividades->result() as $rowActividad){
			            	$empty=false;
			                $array['aaData'][] = array(
			                    'id' => $rowActividad->id,
			                    'tipo' => 2,
			                    'idCategoria' => $this->mcategoriamo->getCampo("categoria",$rowActividad->idCategoria),
			                    'clave' => $this->mactividadmo->getCampo("clave",$rowActividad->idActividad),
			                    'titulo' => $this->mactividadmo->getCampo("descripcion",$rowActividad->idActividad),
			                    'cantidad' => '<input type="text" id="actividad-'.$rowActividad->id.'" data-actividad="'.$rowActividad->id.'" value="'.$rowActividad->cantidad.'"/ class="form-control cantidad">',
			                    'idUnidad' => $this->munidades->getCampo("unidad", $this->mactividadmo->getCampo("idUnidad",$rowActividad->idCategoria)),
			                    'acciones' => accionesProgramaObra($rowActividad->id,$this->router->class,true,true,$rowActividad->id,$idPrototipo)
			                );
			            }
			        }
	            }
	        }
	        if($empty){
	            $array['aaData'][] = array(
	                'id' => 'No hay registros',
	                'idCategoria' => 'No hay registros',
	                'clave' => 'No hay registros',
	                'titulo' => 'No hay registros',
	                'cantidad' => 'No hay registros',
	                'idUnidad' => 'No hay registros',
	                'acciones' => 'No hay registros'
	                );
	        }
	        echo json_encode($array);
	    }
	    //Elimina actividad y cascada
	    public function eliminarActividad(){
	        $cValor = "true";
	        $id = $this->input->post('idActividad');
	        $this->mactividadesprototipo->borrar($id);
	        $this->mmaterialesactividadprototipo->getIdsMaterialesActividadPrototipo($id);
	        $data = json_encode(array("valor" => $cValor));
	        echo $data;
	    }

	    public function nuevo()
	    {
	    	$data['msg'] = '';

	    	$this->load->library('form_validation');
	    	if ($this->form_validation->run($this->fv) == FALSE) {
	    		$data['msg'] = validation_errors();

	    		$this->data['contenido'] = $this->load->view($this->mainView . '/nuevo_view', $data, true);
	    		$this->load->view('templates/main_template', $this->data);
	    	}
	    	else {

	            // Subida de pdf
	            $config = array();
	            $this->load->library('upload', $config);

	            if (isset($_FILES)){
	                $imagenes = array();
	                foreach($_FILES as $key=>$value){
	                    if ($_FILES[$key]['size'] > 0){
	                        $_FILES[$key]['name'] = strtolower($_FILES[$key]['name']);
	                        $imagenes[] = $key;
	                    }
	                }
	                $totalImagenes = count($imagenes);

	                for($i=0; $i< $totalImagenes; $i++){
	                    $ext = pathinfo($_FILES[$imagenes[$i]]['name'],PATHINFO_EXTENSION);
	                    //Configuracion del thumbnail
	                    if($imagenes[$i]!='pdf'){
	                        $nCampoC = explode("_",$imagenes[$i]);
	                        $tipo = $nCampoC[0];
	                        $v = $nCampoC[1];

	                    } else {
	                        $v = 0;
	                        $tipo = 'pdf';
	                    }
	                    if ($tipo == 'pdf' || $tipo == 'jpg' || $tipo == 'png'){
	                        //echo 'es tipo foto<br>';
	                        $uploaddir = $this->data['fotos_www'];
	                        //$configT['upload_path'] = $uploaddir;
	                        //$configT['image_library'] = 'gd2';
	                        //$configT['create_thumb'] = TRUE;
	                        //$configT['maintain_ratio'] = FALSE;
	                        //$configT['width'] = 150;
	                        //$configT['height'] = 150;
	                        //Configuracion de la libreria upload
	                        $nextId = $this->mprototipos->nextId();
	                        $config['file_name'] =  $nextId."_".$v;
	                        $config['overwrite'] = TRUE;
	                        $config['upload_path'] = $uploaddir;
	                        $config['max_size'] = '20000';
	                        $config['allowed_types'] = 'pdf|jpg|jpeg|png|gif';
	                        $this->upload->initialize($config);
	                        if ( ! $this->upload->do_upload($imagenes[$i]) )
	                        {
	                            $redirect = 1;
	                            $data['error'] = $this->upload->display_errors();
	                        }
	                        else
	                        {
	                            $dataFile = $this->upload->data($imagenes[$i]);
	                            $fotoI = 'pdf_'.$v;
	                            //$thumbI = 'thumbnail_'.$v;
	                            if ($v == 0){
	                                //Foto default
	                                $pData['pdf'] = $nextId.'_'.$v.'.'.$ext;//
	                            } else {
	                                $pData[$fotoI] = $nextId.'_'.$v.'.'.$ext;
	                            }
	                        }
	                    }

	                }
	            }

	    		$pData['nombre'] = strtoupper($this->input->post('nombre', TRUE));
	    		$pData['estimaciones'] = strtoupper($this->input->post('estimaciones', TRUE));
	    		$pData['superficieM2'] = strtoupper($this->input->post('superficieM2', TRUE));
	    		$pData['costoCimentacion'] = strtoupper($this->input->post('costoCimentacion', TRUE));
	    		$pData['avanceCimentacion'] = strtoupper($this->input->post('avanceCimentacion', TRUE));
	    		$pData['costoAlbPlantaBaja'] = strtoupper($this->input->post('costoAlbPlantaBaja', TRUE));
	    		$pData['avanceAlbPlantaBaja'] = strtoupper($this->input->post('avanceAlbPlantaBaja', TRUE));
	    		$pData['costoLosaEntrepiso'] = strtoupper($this->input->post('costoLosaEntrepiso', TRUE));
	    		$pData['avanceLosaEntrepiso'] = strtoupper($this->input->post('avanceLosaEntrepiso', TRUE));
	    		$pData['costoAlbPrimerNivel'] = strtoupper($this->input->post('costoAlbPrimerNivel', TRUE));
	    		$pData['avanceAlbPrimerNivel'] = strtoupper($this->input->post('avanceAlbPrimerNivel', TRUE));
	    		$pData['costoLosaPrimerNivel'] = strtoupper($this->input->post('costoLosaPrimerNivel', TRUE));
	    		$pData['avanceLosaPrimerNivel'] = strtoupper($this->input->post('avanceLosaPrimerNivel', TRUE));
	    		$pData['costoAzotea'] = strtoupper($this->input->post('costoAzotea', TRUE));
	    		$pData['avanceAzotea'] = strtoupper($this->input->post('avanceAzotea', TRUE));
	    		$pData['costoFachada'] = strtoupper($this->input->post('costoFachada', TRUE));
	    		$pData['avanceFachada'] = strtoupper($this->input->post('avanceFachada', TRUE));
	    		$pData['costoAcabados'] = strtoupper($this->input->post('costoAcabados', TRUE));
	    		$pData['avanceAcabados'] = strtoupper($this->input->post('avanceAcabados', TRUE));
	    		$pData['costoPisos'] = strtoupper($this->input->post('costoPisos', TRUE));
	    		$pData['avancePisos'] = strtoupper($this->input->post('avancePisos', TRUE));
	    		$pData['costoInstHidroGas'] = strtoupper($this->input->post('costoInstHidroGas', TRUE));
	    		$pData['avanceInstHidroGas'] = strtoupper($this->input->post('avanceInstHidroGas', TRUE));
	    		$pData['costoCanceleria'] = strtoupper($this->input->post('costoCanceleria', TRUE));
	    		$pData['avanceCanceleria'] = strtoupper($this->input->post('avanceCanceleria', TRUE));
	    		$pData['costoElectrica'] = strtoupper($this->input->post('costoElectrica', TRUE));
	    		$pData['avanceElectrica'] = strtoupper($this->input->post('avanceElectrica', TRUE));
	    		$pData['costoObraExterior'] = strtoupper($this->input->post('costoObraExterior', TRUE));
	    		$pData['avanceObraExterior'] = strtoupper($this->input->post('avanceObraExterior', TRUE));
	    		$pData['costoBardas'] = strtoupper($this->input->post('costoBardas', TRUE));
	    		$pData['avanceBardas'] = strtoupper($this->input->post('avanceBardas', TRUE));
	    		$pData['costoLimpieza'] = strtoupper($this->input->post('costoLimpieza', TRUE));
	    		$pData['avanceLimpieza'] = strtoupper($this->input->post('avanceLimpieza', TRUE));
	    		$pData['costoExtra'] = strtoupper($this->input->post('costoExtra', TRUE));
	    		$pData['avanceExtra'] = strtoupper($this->input->post('avanceExtra', TRUE));
	    		$pData['costoImpermeabilizacion'] = strtoupper($this->input->post('costoImpermeabilizacion', TRUE));
	    		$pData['avanceImpermeabilizacion'] = strtoupper($this->input->post('avanceImpermeabilizacion', TRUE));
	    		$pData['costoEcotecnologias'] = strtoupper($this->input->post('costoEcotecnologias', TRUE));
	    		$pData['avanceEcotecnologias'] = strtoupper($this->input->post('avanceEcotecnologias', TRUE));

	    		$pData['status'] = 1;
	    		// echo "<pre>"; print_r($pData); echo "</pre>"; exit();
	    		$id = $this->mprototipos->insertar($pData);
	            redirect($this->router->class);
	        }

	    }

	    public function editar($id = null)
	    {
	    	$msg = "";

	    	$this->load->library('form_validation');
	    	if ($this->form_validation->run($this->fv) == FALSE) {
	    		$data = $this->mprototipos->getById($id);
	    		$data['msg'] = validation_errors();

	    		$this->data['contenido'] = $this->load->view($this->mainView.'/editar_view',$data,true);
				$this->load->view('templates/main_template',$this->data);
	    	}
	    	else {

               	// Subida de pdf
	            $config = array();
	            $this->load->library('upload', $config);

	            if (isset($_FILES)){
	                $imagenes = array();
	                foreach($_FILES as $key=>$value){
	                    if ($_FILES[$key]['size'] > 0){
	                        $_FILES[$key]['name'] = strtolower($_FILES[$key]['name']);
	                        $imagenes[] = $key;
	                    }
	                }
	                $totalImagenes = count($imagenes);

	                for($i=0; $i< $totalImagenes; $i++){
	                    $ext = pathinfo($_FILES[$imagenes[$i]]['name'],PATHINFO_EXTENSION);
	                    //Configuracion del thumbnail
	                    if($imagenes[$i]!='pdf'){
	                        $nCampoC = explode("_",$imagenes[$i]);
	                        $tipo = $nCampoC[0];
	                        $v = $nCampoC[1];

	                    } else {
	                        $v = 0;
	                        $tipo = 'pdf';
	                    }
	                    if ($tipo == 'pdf' || $tipo == 'jpg' || $tipo == 'png'){
	                        //echo 'es tipo foto<br>';
	                        $uploaddir = $this->data['fotos_www'];
	                        $nextId = $id;
	                        $config['file_name'] =  $nextId."_".$v;
	                        $config['overwrite'] = TRUE;
	                        $config['upload_path'] = $uploaddir;
	                        $config['max_size'] = '20000';
	                        $config['allowed_types'] = 'pdf|jpg|jpeg|png|gif';
	                        $this->upload->initialize($config);
	                        if ( ! $this->upload->do_upload($imagenes[$i]) )
	                        {
	                            $redirect = 1;
	                            $data['error'] = $this->upload->display_errors();
	                        }
	                        else
	                        {
	                            $dataFile = $this->upload->data($imagenes[$i]);
	                            $fotoI = 'pdf_'.$v;
	                            //$thumbI = 'thumbnail_'.$v;
	                            if ($v == 0){
	                                //Foto default
	                                $pData['pdf'] = $nextId.'_'.$v.'.'.$ext;//
	                            } else {
	                                $pData[$fotoI] = $nextId.'_'.$v.'.'.$ext;
	                            }
	                        }
	                    }

	                }
	            }

	    		$pData['nombre'] = strtoupper($this->input->post('nombre', TRUE));
	    		$pData['estimaciones'] = strtoupper($this->input->post('estimaciones', TRUE));
	    		$pData['superficieM2'] = strtoupper($this->input->post('superficieM2', TRUE));

	    		$pData['costoCimentacion'] = strtoupper($this->input->post('costoCimentacion', TRUE));
	    		$pData['avanceCimentacion'] = strtoupper($this->input->post('avanceCimentacion', TRUE));
	    		$pData['costoAlbPlantaBaja'] = strtoupper($this->input->post('costoAlbPlantaBaja', TRUE));
	    		$pData['avanceAlbPlantaBaja'] = strtoupper($this->input->post('avanceAlbPlantaBaja', TRUE));
	    		$pData['costoLosaEntrepiso'] = strtoupper($this->input->post('costoLosaEntrepiso', TRUE));
	    		$pData['avanceLosaEntrepiso'] = strtoupper($this->input->post('avanceLosaEntrepiso', TRUE));
	    		$pData['costoAlbPrimerNivel'] = strtoupper($this->input->post('costoAlbPrimerNivel', TRUE));
	    		$pData['avanceAlbPrimerNivel'] = strtoupper($this->input->post('avanceAlbPrimerNivel', TRUE));
	    		$pData['costoLosaPrimerNivel'] = strtoupper($this->input->post('costoLosaPrimerNivel', TRUE));
	    		$pData['avanceLosaPrimerNivel'] = strtoupper($this->input->post('avanceLosaPrimerNivel', TRUE));
	    		$pData['costoAzotea'] = strtoupper($this->input->post('costoAzotea', TRUE));
	    		$pData['avanceAzotea'] = strtoupper($this->input->post('avanceAzotea', TRUE));
	    		$pData['costoFachada'] = strtoupper($this->input->post('costoFachada', TRUE));
	    		$pData['avanceFachada'] = strtoupper($this->input->post('avanceFachada', TRUE));
	    		$pData['costoAcabados'] = strtoupper($this->input->post('costoAcabados', TRUE));
	    		$pData['avanceAcabados'] = strtoupper($this->input->post('avanceAcabados', TRUE));
	    		$pData['costoPisos'] = strtoupper($this->input->post('costoPisos', TRUE));
	    		$pData['avancePisos'] = strtoupper($this->input->post('avancePisos', TRUE));
	    		$pData['costoInstHidroGas'] = strtoupper($this->input->post('costoInstHidroGas', TRUE));
	    		$pData['avanceInstHidroGas'] = strtoupper($this->input->post('avanceInstHidroGas', TRUE));
	    		$pData['costoCanceleria'] = strtoupper($this->input->post('costoCanceleria', TRUE));
	    		$pData['avanceCanceleria'] = strtoupper($this->input->post('avanceCanceleria', TRUE));
	    		$pData['costoElectrica'] = strtoupper($this->input->post('costoElectrica', TRUE));
	    		$pData['avanceElectrica'] = strtoupper($this->input->post('avanceElectrica', TRUE));
	    		$pData['costoObraExterior'] = strtoupper($this->input->post('costoObraExterior', TRUE));
	    		$pData['avanceObraExterior'] = strtoupper($this->input->post('avanceObraExterior', TRUE));
	    		$pData['costoBardas'] = strtoupper($this->input->post('costoBardas', TRUE));
	    		$pData['avanceBardas'] = strtoupper($this->input->post('avanceBardas', TRUE));
	    		$pData['costoLimpieza'] = strtoupper($this->input->post('costoLimpieza', TRUE));
	    		$pData['avanceLimpieza'] = strtoupper($this->input->post('avanceLimpieza', TRUE));
	    		$pData['costoExtra'] = strtoupper($this->input->post('costoExtra', TRUE));
	    		$pData['avanceExtra'] = strtoupper($this->input->post('avanceExtra', TRUE));
	    		$pData['costoImpermeabilizacion'] = strtoupper($this->input->post('costoImpermeabilizacion', TRUE));
	    		$pData['avanceImpermeabilizacion'] = strtoupper($this->input->post('avanceImpermeabilizacion', TRUE));
	    		$pData['costoEcotecnologias'] = strtoupper($this->input->post('costoEcotecnologias', TRUE));
	    		$pData['avanceEcotecnologias'] = strtoupper($this->input->post('avanceEcotecnologias', TRUE));

	    		// echo "<pre>"; print_r($pData); echo "</pre>"; exit();
	    		$upd = $this->mprototipos->actualizar($pData, $id);
	    		redirect($this->router->class."?close"
);
	    	}
	    }

	    public function eliminar(){
	        $id = $this->input->post('elid');
	        $q = $this->mprototipos->getById($id);
	        $cValor = "true";
	        $this->mprototipos->borrar($id);
	        $data = json_encode(array("valor" => $cValor));
	        echo $data;
	    }

	    public function eliminar_archivo()
	    {

	        if (isset($_POST['elid'])){
	            $id = $this->input->post('elid');
	            $campo = $this->input->post('elcampo'); //Obteniendo el nombre de la foto y thumbnail
	            if($campo !="0"){
	                $archivo = $this->mprototipos->getCampo('pdf_'.$campo,$id);
	                if(unlink($this->data['fotos_www'].$archivo)){// Haciendo update a la tabla
	                    $c_data['pdf_'.$campo] ='';
	                    $this->mprototipos->actualizar($c_data,$id);
	                    $c_valor = "true";
	                    //$this->msomos->borrar($id);
	                }else{ $c_valor = "false";}
	            }else{
	                $archivo = $this->mprototipos->getCampo('pdf',$id);
	                if(unlink($this->data['fotos_www'].$archivo)){// Haciendo update a la tabla
	                    $c_data['pdf'] ='';
	                    $this->mprototipos->actualizar($c_data,$id);
	                    $c_valor = "true";
	                    //$this->msomos->borrar($id);
	                }else{ $c_valor = "false";}
	            }
	            $data = json_encode(array("valor"=>$c_valor));
	            echo $data;

	        }
	    }

	    public function getDataPrototype()
	    {
	    	$id = $this->input->post('id', TRUE);
	    	$data = $this->mprototipos->getById($id);
	    	if ( !is_numeric($data) ) {
	    		$data['success'] = TRUE;
	    		echo json_encode($data);
	    	}
	    	else {
	    		$data_['success'] = FALSE;
	    		echo json_encode($data_);
	    	}
	    }




	    /* --------- Excelles ----------*/
	    public function importarcsv(){
	    	$idPrototipo = ($this->input->post('idPrototipo')) ? $this->input->post('idPrototipo'): '';
	    	if(isset($_FILES["foto"]) && $_SERVER['REQUEST_METHOD'] == 'POST'){
	    		$config['upload_path'] = $this->data['fotos_www'];
	    		$config['allowed_types'] = '*';
	    		$config['max_size'] = '2000';
	    		$this->load->library('upload', $config);
	    		if (!$this->upload->do_upload("foto")) {
	    			 // If upload failed, display error
	    			$data['idPrototipo'] = $idPrototipo;
	    			$data['msg'] = '<div style="text-align:center;"><p>'.$this->upload->display_errors().'</p></div>';
	    			$data['mdl'] = true;
	    			$this->data['contenido'] = $this->load->view($this->mainView.'/programa_view',$data,true);
	    			$this->load->view('templates/main_template',$this->data);
	    		}else {
					$checkEliminar = $this->input->post('checkEliminar', TRUE);
	    			//file uploaded
	    			$file_data = $this->upload->data();
	    			$file_path = $this->data['fotos_www'].$file_data['file_name'];
	    			if ($this->csvimport->get_array($file_path,'',TRUE)) {
	    				$csv_array = $this->csvimport->get_array($file_path);
	    				if (isset($csv_array[0])) {
	    				   $data['idPrototipo'] = $idPrototipo; //establecemos id del prototipo
	    				   $data['idCategoria'] = 0; //se establece global para preservar la categoria
	    				   $ntIns = 0; //numero de registros sin insertar
	    				   $nUpd = 0; //numero para registros actualizados
	    				   $nIsrt = 0; // numero de registros insertados
	    				   $fgIns = false;
	    				   $actProtId = 0; // para insertar o actualizar id actividesprototipo en matactivproto
						   $fgMat = '';
						   $uActividad = 0;
						   $uMaterial = 0;
						   $insActividad = 0;
						   $insMaterial = 0;
						   $dActividad = 0;
						   $dMaterial = 0;
						   $arrayActividadPrototipo = array();
						   $arrayMaterialesPrototipo = array();
	    					foreach ($csv_array as $value) { //recorremos el csv
	    						//**--- consulta para obtener el id categoria segun la categoria ---**//
	    						$qCate = $this->db->query('SELECT id FROM categorias_mo WHERE clave = "'.$value['CLAVE'].'"');
	    						$resCtg = $qCate->row();
	    						$catg = (isset($resCtg)) ? $resCtg->id : 0;
	    						$data['idCategoria'] = ($catg != 0) ? $catg : $data['idCategoria'];
	    						//**--- consulta para obtener el id de actividad segun la clave ---**//
	    						$qActv = $this->db->query('SELECT id FROM actividades_mo WHERE clave = "'.$value['CLAVE'].'"');
	    						$res = $qActv->row();
	    						$data['idActividad'] = (isset($res)) ? $res->id : 0;
	    						$data['cantidad'] = $value['CANTIDAD'];
	    						//**--- validacion: si es material no lo insertamos ---**//
	    						if ($value['TIPO'] == 'A' && $data['idActividad'] != 0) {
	    							#para saber si ya existe el registro
	    							$qUpd = $this->db->query('SELECT id FROM actividadesprototipo WHERE idPrototipo = "'.$idPrototipo.'" AND idActividad ="'.$data['idActividad'].'"');
	    							$resUpd = $qUpd->row();
	    							$upd = (isset($resUpd)) ? $resUpd->id : 0;
	    							#si existe actualizamos
	    							if($upd > 0){
	    								$this->mactividadesprototipo->actualizar($data,$upd);
	    								$actProtId = $upd;
	    								$fgMat = 'update';
	    								$nUpd++;
										$fgIns= true;
										$uActividad++;
	    							}else{
	    								# si no se inserta uno nuevo
	    								$fgMat = 'insertar';
	    								$nIsrt++;
										$upd = $this->mactividadesprototipo->insertar($data);
										$insActividad++;
	    								#quering last inserted id
	    								$last_id = $this->db->query('SELECT id FROM actividadesprototipo  ORDER BY id DESC LIMIT 1');
	    								if (!is_numeric($last_id)) {
		    								#getting last inserted id value
		    								$last = $last_id->row();
		    								$actProtId = $last->id;
		    							}
		    							$fgIns= true;
									 }
									 $arrayActividadPrototipo[$upd] = $upd;
	    						}
	    						#si es actividad y no se encuentra su registro sumamos un registro sin dar de alta
	    						elseif($value['TIPO'] == 'A' && $data['idActividad'] == 0){
	    							$ntIns++;
	    						}
	    						elseif ($value['TIPO'] == 'M') {
	    							#si es material obtenemos su id...
									$qMat = $this->db->query('SELECT id, material FROM materiales WHERE clave = "'.$value['CLAVE'].'"');
									if ($qMat->num_rows() > 0) {
										# obtener fila de valores de la query...
										$qMatRow = $qMat->row();
										#valores de materialesactividadprototipos...
										$datMat['idActividadPrototipo'] = $actProtId;
										$datMat['idMaterial'] = $qMatRow->id;
										$datMat['cantidad'] = $value['CANTIDAD'];
										//print_r($datMat);
										/*print($fgMat);
										exit();*/
										$qMatProt= $this->db->query("SELECT id FROM materialesactividadprototipo WHERE idActividadPrototipo=".$actProtId." AND idMaterial=".$qMatRow->id."");
										switch ($fgMat) {
											case 'insertar':
    											#insertamos los valores en materialesactividadprototipos...
    											#$this->mmaterialesactividadprototipo->insertar($datMat);
												if($qMatProt->num_rows() > 0){
													$idM = $qMatProt->row()->id;
													$this->mmaterialesactividadprototipo->updateMatActProt($datMat);
													$uMaterial++;
													$arrayMaterialesPrototipo[$idM] = $idM;
    											}else{
													$idM = $this->mmaterialesactividadprototipo->insertar($datMat);
													$insMaterial++;
													$arrayMaterialesPrototipo[$idM] = $idM;
												}
												break;
											case 'update':
												if($qMatProt->num_rows() > 0){
													$idM = $qMatProt->row()->id;
													$this->mmaterialesactividadprototipo->updateMatActProt($datMat);
													$uMaterial++;
													$arrayMaterialesPrototipo[$idM] = $idM;
    											}else{
													$idM = $this->mmaterialesactividadprototipo->insertar($datMat);
													$insMaterial++;
													$arrayMaterialesPrototipo[$idM] = $idM;
												}
												break;
											default:
												# code...
												break;
										}
									}
	    						}
							}

							if($checkEliminar == 'on'){
								$qM = $this->db->query('SELECT m.id FROM actividadesprototipo AS a INNER JOIN materialesactividadprototipo AS m
								ON a.id = m.idActividadPrototipo WHERE a.idPrototipo = "'.$idPrototipo.'"');
								$qM = $qM->result_array();
								$qM = array_column($qM, 'id');
								$qM = array_flip($qM);
								$searchM = array_diff_key($qM, $arrayMaterialesPrototipo);
								if(count($searchM) > 0){
									foreach($searchM as $k=>$v){
										$this->mmaterialesactividadprototipo->borrar($k);
										$dMaterial++;
									}
								}

								$qAc = $this->db->query('SELECT id FROM actividadesprototipo WHERE idPrototipo = "'.$idPrototipo.'"');
								$qAc = $qAc->result_array();
								$qAc = array_column($qAc, 'id');
								$qAc = array_flip($qAc);
								$search = array_diff_key($qAc, $arrayActividadPrototipo);
								if(count($search) > 0){
									foreach($search as $k=>$v){
										$this->mactividadesprototipo->borrar($k);
										$dActividad++;
									}
								}
							}

	    					if ($fgIns) {
	    						// preparar el modal y mostar en la vista
	    						$data['idPrototipo'] = $idPrototipo;
								$data['mdl'] = true;
								if($checkEliminar == 'on'){
									$data['msg'] = "<div style='text-align: center'>
														<p>Registros sin dar de alta: ".$ntIns."</p> 
														<p> Actividades insertados: ".$insActividad."</p>
														<p> Materiales insertados: ".$insMaterial."</p>
														<p> Actividades actualizados: ".$uActividad."</p>
														<p> Materiales actualizados: ".$uMaterial."</p>
														<p> Actividades eliminados: ".$dActividad."</p>
														<p> Materiales eliminados: ".$dMaterial."</p>
													</div>";
								}else{
									$data['msg'] = "<div style='text-align: center'>
														<p>Registros sin dar de alta: ".$ntIns."</p> 
														<p> Actividades insertados: ".$insActividad."</p>
														<p> Materiales insertados: ".$insMaterial."</p>
														<p> Actividades actualizados: ".$uActividad."</p>
														<p> Materiales actualizados: ".$uMaterial."</p>
													</div>";
								}
								/*$data['msg'] = "<div style='text-align: center'>
														<p>Registros sin dar de alta: ".$ntIns."</p> 
														<p> registros actualizados: ".$nUpd."</p>
														<p> Registros insertados: ".$nIsrt."</p>
														<p> Actividades insertados: ".$insActividad."</p>
														<p> Materiales insertados: ".$insMaterial."</p>
														<p> Actividades actualizados: ".$uActividad."</p>
														<p> Materiales actualizados: ".$uMaterial."</p>
														<p> Actividades eliminados: ".$dActividad."</p>
														<p> Materiales eliminados: ".$dMaterial."</p>
													</div>";*/
	    						$this->data['contenido'] = $this->load->view($this->mainView.'/programa_view',$data,true);
	    						$this->load->view('templates/main_template',$this->data);
	    					}
	    					//redirect($this->router->class);
	    				}
	    				@unlink($file_path);
	    			}else{
	    				$data['error'] = "Ocurrió un error";
	    			}
	    		}
	    	} else{
	    		// no file
	    	}
	    }
	    // prueba
	    public function actProgObra(){
	    	//datos para la consulta
	    	$data['id'] = ($this->input->post('id')) ? $this->input->post('id') : 0;
	    	$data['cantidad'] = ($this->input->post('val')) ? $this->input->post('val') : 0;
	    	$this->db->query('UPDATE actividadesprototipo SET cantidad ="'.$data['cantidad'].'" WHERE id = "'.$data['id'].'"');
	    	//datos para el modal
	    	$data['titulo'] = '';
	    	$data['msg'] = '<p style="text-align: center"> Registro '.$data['id'].' actualizado </p>';
	    	echo json_encode($data);
	    }
	}
?>
