<?php // Promotor
	defined('BASEPATH') OR exit('No direct script access allowed');

	class Promotores extends MX_Controller {
        
        public $data,$vParameters,$mainView,$fv;
        
        public function __construct() {
			$this->nsession = $this->config->item('nsession');
			if (!isset($_SESSION[$this->nsession]) || (($_SESSION[$this->nsession]['usuario'] == ""))) redirect('login');
			$this->fv = 'promotores'; // form validation variable
			$this->mainView = 'promotores';
			$this->data['fjs'] = '';
			$this->data['js'] = '<script src="assets/js/promotores/listado.js" type="text/javascript"></script>';
			$this->data['css'] = '';
			// Tools
			$this->load->helper(array('tools','numeros','url','form','date','text','security'));
			// Modelos
			$this->load->model(array('musuario','mfraccionamiento','mfraccionamientoxusuario'));

			// Lbrerias
			// $this->load->library(array('email','session'));
			// $this->data['fotos_www'] = $this->config->item('base_www').'/inicio/';

			// Debugging
            $this->output->enable_profiler(false);
            
            //Validación de usuarios
            valSession("ventas",$this->fv);
        }
        
        public function index() {
            $data['q'] = '';
            $fraccionamiento = $this->mfraccionamiento->getById(9);
            $data['fraccionamiento'] = (!is_numeric($fraccionamiento))?$fraccionamiento['titulo']:'';
            $this->data['contenido'] = $this->load->view($this->mainView.'/index_view',$data,true);
            $this->load->view('templates/main_template',$this->data);
        }
        
        public function listado(){
            $q = $this->musuario->getPromotores();
	        if (!is_numeric($q)){
	            foreach ($q->result() as $row){
	                $array['aaData'][] = array(
	                    'nombre' => $row->nombre.' '.$row->apellidoP.' '.$row->apellidoM,
	                    'tipo' => $row->tipoPromotor,
	                    'acciones' => acciones($row->id,'promotores', false, true, true,'promotores')
	                    );
	            }
	        } else{
	            $array['aaData'][] = array(
	                'nombre' => 'No hay registros',
	                'tipo' => 'No hay registros',
	                'acciones' => 'No hay registros'
	                );

	        }

	        echo json_encode($array);
	    }
        
        public function nuevo($tipoDeUsuario = '') {
            // Mensajes
            $data['msg'] = '';
            $data['warning_rubro'] = '';
            $data['rol'] = '';
            $data['tipoDeUsuario'] = $tipoDeUsuario;//Validamos p.e. si viene del módulo promtor
            
            if (isset($_POST['usuario'])) {
                $this->load->library('form_validation');
                if ($this->form_validation->run('usuarios') == FALSE) {
                    $data['rol'] = $this->input->post('rol', TRUE);
                    $data['msg'] = validation_errors();
                } 
                else {
                    $pData['rol'] = $this->input->post('rol', TRUE);
                    $data['rol'] = $pData['rol'];//pasamos el valor del rol a la vista
                    $pData['usuario'] = $this->input->post('usuario', TRUE);
                    $password = $this->input->post('password', TRUE);
                    $pData['password'] = sha1($password);
                    $password_2 = $this->input->post('password_2', TRUE);
                    $pData['nombre'] = $this->input->post('nombre', TRUE);
                    $pData['apellidoP'] = $this->input->post('apellidoP', TRUE);
                    $pData['apellidoM'] = $this->input->post('apellidoM', TRUE);
                    $pData['email'] = $this->input->post('email', TRUE);
                    $pData['rfc'] = $this->input->post('rfc', TRUE);
                    $pData['curp'] = $this->input->post('curp', TRUE);
                    $pData['calle'] = $this->input->post('calle', TRUE);
                    $pData['colonia'] = $this->input->post('colonia', TRUE);
                    $pData['ciudad'] = $this->input->post('ciudad', TRUE);
                    $pData['telFijo'] = $this->input->post('telFijo', TRUE);
                    $pData['celular'] = $this->input->post('celular', TRUE);
                    $pData['tipoPromotor'] = $this->input->post('tipoPromotor', TRUE);
                    $pData['comision'] = $this->input->post('comision', TRUE);
                    $fechaIngreso = $this->input->post('fechaIngreso', TRUE);
                    $fechaIngreso =  str_replace('/', '-', $fechaIngreso);
                    $pData['fechaIngreso'] = date('Y-m-d', strtotime($fechaIngreso));//date_format(new DateTime($fechaIngreso),'Y-m-d');
                    $pData['status'] =$this->input->post('status',TRUE);
                    
                    $fraccionamientos = $this->input->post('fraccionamientos', TRUE); //si se eligió algún fraccionamiento para este usuario, lo guardamos
                    // echo "<pre>"; print_r($pData); echo "</pre>"; exit();
                    //Validamos que el usuario que se intenta registrar no exista en la BD
                    $validar_email = $this->musuario->chekEmailAndUser($pData['email'],$pData['usuario']);
                    //print_r($validar_email);exit();
                    if ($validar_email == 0) {
                        
                        $id = $this->musuario->insertar($pData);
                        
                        $arrayIdUsuario = array();
                        $pushFraccxUs = array();
                        if (is_array($fraccionamientos) && count($fraccionamientos) > 0 && !empty($fraccionamientos) && $id > 0){
                            $sessionId = (isset($_SESSION[$this->nsession]['id']) && (!empty($_SESSION[$this->nsession] ['id'])) ? $_SESSION[$this->nsession]['id'] : 0);
                            //$date = date("Y-m-d H:i:s");
                            $created_by = $sessionId;
                            $updated_by = $sessionId;
                            foreach ($fraccionamientos as $idFraccionamiento) { //este array contiene los ids de usuarios
                                $created = date("Y-m-d H:i:s");
                                $updated = date("Y-m-d H:i:s");
                                $arrayIdUsuario = array(
                                    "idFraccionamiento" => $idFraccionamiento,
                                    "idUsuario" => $id,
                                    "created" => $created,
                                    "updated" => $updated,
                                    "created_by" => $created_by,
                                    "updated_by" => $updated_by
                                );
                                array_push($pushFraccxUs, $arrayIdUsuario);
                            }
                        }
                        if (count($pushFraccxUs)>0 && !empty($pushFraccxUs) ) {
                            $this->db->insert_batch('fraccionamientosxusuarios', $pushFraccxUs); //insertamos el batch de usuarios a ese fraccionamiento
                        }
                        
                        if( $pData['rol'] == 2 ) {
                            //Obtiene todos los promotores
                            $query=$this->db->query("SELECT id FROM usuarios WHERE rol=2;");
                            if($query->num_rows() > 0){
                                foreach ($query->result() as $row) {
                                    $idPromotor=$row->id;
                                    $gerentes="";
                                    //Obtiene todos tus gerentes partiendo de los fraccionamientos en los que te encuentras
                                    $query2=$this->db->query("SELECT u.id FROM fraccionamientosxusuarios AS fxu, usuarios AS u WHERE
                                    idUsuario=u.id AND u.rol=4 AND idFraccionamiento IN (SELECT idFraccionamiento FROM fraccionamientosxusuarios WHERE idUsuario=$idPromotor) GROUP BY u.id;");
                                    if($query2->num_rows() > 0){
                                        foreach ($query2->result() as $row2) {
                                            $gerentes.=$row2->id." ";
                                        }
                                    }
                                    //Actualiza created_ by con los gerentes de tus fraccionamientos
                                    $this->db->query("UPDATE usuarios SET created_by='$gerentes' WHERE id=".$row->id);
                                }
                            }
                        }
                        
                        
                        // $fxuData['idFraccionamiento'] = $_SESSION['viv']['idFraccionamiento'];
                        // $fxuData['idUsuario'] = $id;
                        // $idFraccionamiento= $this->mfraccionamientoxusuario->insertar($fxuData);
                        
                        
                        //variables para el insert_batch en fraccionamientosxusuario
                        /*$arrayIdUsuario = array();
                        $pushFraccxUs = array();
                        if (is_array($fraccionamientos) && count($fraccionamientos) > 0 && !empty($fraccionamientos) && $id > 0) {
                            $sessionId = (isset($_SESSION[$this->nsession]['id']) && (!empty($_SESSION[$this->nsession] ['id'])) ? $_SESSION[$this->nsession]['id'] : 0);
                            //$date = date("Y-m-d H:i:s");
                            $created_by = $sessionId;
                            $updated_by = $sessionId;
                            foreach ($fraccionamientos as $idFraccionamiento) { 
                                $created = date("Y-m-d H:i:s");
                                $updated = date("Y-m-d H:i:s");                            
                                $arrayIdUsuario = array(
                                    "idFraccionamiento" => $idFraccionamiento,
                                    "idUsuario" => $id,
                                    "created" => $created,
                                    "updated" => $updated,
                                    "created_by" => $created_by,
                                    "updated_by" => $updated_by
                                );
                                array_push($pushFraccxUs, $arrayIdUsuario);
                            }
                        }
                        if (count($pushFraccxUs)>0 && !empty($pushFraccxUs) ) {
                            $this->db->insert_batch('fraccionamientosxusuarios', $pushFraccxUs); fraccionamiento
                        }*/
                        $email_enviado = $this->email_contacto($pData['usuario'], $password, $pData['email']);
                        if ($email_enviado == true){
                            switch ($tipoDeUsuario) {
                                case 'promotor':
                                    redirect('promotores');
                                    break;
                                default:
                                    redirect($this->router->class);
                                    break;
                            }
                        }
                        else {
                            $data['warning_rubro'] = "Error al intentar enviar el correo, intente más tarde";
                        }
                    }
                    else {
                        if ($validar_email > 0){ //validamos que efectivamente exista el registro
                            $usuario_existente = $validar_email;
                            //$data['warning_rubro'] = "El email o nombre de usuario ya se encuentra registrado en la BD como <a href='usuarios/editar/$usuario_existente'>".$this->musuario->getCampo('nombre',$usuario_existente)."</a>";
                            $data['warning_rubro'] = "El email o nombre de usuario ya se encuentra registrado en la BD como ".$this->musuario->getCampo('nombre',$usuario_existente)." ".$this->musuario->getCampo('apellidoP',$usuario_existente)."";
                        }
                        else {
                            $data['warning_rubro'] = 'El registro no puede ser completado intente más tarde';
                        }
                    }
                }
            }
            
            $vistaLoad = ($tipoDeUsuario == 'promotor')?"/nuevo_promotor_view":"/nuevo_view";
            $data['fraccionamientos'] = $this->mfraccionamiento->getAll();
            $this->data['contenido'] = $this->load->view('usuarios' . $vistaLoad, $data, true);  //nuevo_view
            $this->load->view('templates/main_template', $this->data);
        }
        
        public function editar($id,$tipoDeUsuario = '') { 
            // Mensajes
            $msg = '';
            $enviarMail = false;
            $data['warning_rubro'] = '';
            $data['rol'] = '';
            $data['tipoDeUsuario'] = $tipoDeUsuario;//Validamos p.e. si viene del módulo promtor
            /* VALIDAR FORMULARIO*/
            $this->load->library('form_validation');
            
            if (isset($_POST['usuario'])) {
                $password = $this->input->post('password', TRUE);
                
                $validation = ($password !='')?'usuarios':'usuarios_editar';
                if ($this->form_validation->run($validation) == FALSE) {
                    $data['rol'] = $this->input->post('rol', TRUE);
                    $msg = validation_errors();
                } 
                else {
                    $pData['rol'] = $this->input->post('rol', TRUE);
                    $password_2 = $this->input->post('password_2', TRUE);
                    if ( $_POST['usuario'] != '' && $_POST['password'] != '' && $_POST['password'] == $_POST['password_2']){ //validamos que los campos usuarios y contraseña no esten vacíos , y que las contraseñas sean iguales
                        $pData['usuario'] = $this->input->post('usuario', TRUE);
                        $pData['password'] = sha1($password);
                        $enviarMail = true;
                    }
                    $data['rol'] = $pData['rol'];//pasamos el valor del rol a la vista
                    $pData['nombre'] = $this->input->post('nombre', TRUE);
                    $pData['apellidoP'] = $this->input->post('apellidoP', TRUE);
                    $pData['apellidoM'] = $this->input->post('apellidoM', TRUE);
                    $pData['email'] = $this->input->post('email', TRUE);
                    $pData['rfc'] = $this->input->post('rfc', TRUE);
                    $pData['curp'] = $this->input->post('curp', TRUE);
                    $pData['calle'] = $this->input->post('calle', TRUE);
                    $pData['colonia'] = $this->input->post('colonia', TRUE);
                    $pData['ciudad'] = $this->input->post('ciudad', TRUE);
                    $pData['telFijo'] = $this->input->post('telFijo', TRUE);
                    $pData['celular'] = $this->input->post('celular', TRUE);
                    $pData['tipoPromotor'] = $this->input->post('tipoPromotor', TRUE);
                    $pData['comision'] = $this->input->post('comision', TRUE);
                    $fechaIngreso = $this->input->post('fechaIngreso', TRUE);
                    $pData['fechaIngreso'] = date_format(new DateTime($fechaIngreso),'Y-m-d');
                    $pData['status'] =$this->input->post('status',TRUE);
                    $fraccionamientos = $this->input->post('fraccionamientos', TRUE); //si se eligió algún fraccionamiento para este usuario, lo guardamos
                    
                    $actualizar_usuario = $this->musuario->actualizar($pData, $id);
                    
                    if ($actualizar_usuario == true) {
                        $this->borrarFxU($id);//si se asocio el usuario a nuevo fraacionamiento eliminarmos el registro que tenía y actualizamos al nuevo fracc.
                        // $fxuData['idFraccionamiento'] = $_SESSION['viv']['idFraccionamiento'];
                        // $fxuData['idUsuario'] = $id;
                        // $idFraccionamiento= $this->mfraccionamientoxusuario->insertar($fxuData);
                        
                        
                        /*$arrayIdUsuario = array();
                        $pushFraccxUs = array();
                        if (is_array($fraccionamientos) && count($fraccionamientos) > 0 && !empty($fraccionamientos) && $id > 0) {
                            $sessionId = (isset($_SESSION[$this->nsession]['id']) && (!empty($_SESSION[$this->nsession] ['id'])) ? $_SESSION[$this->nsession]['id'] : 0);
                            $created_by = $sessionId;
                            $updated_by = $sessionId;
                            foreach ($fraccionamientos as $idFraccionamiento) { 
                                $created = date("Y-m-d H:i:s");
                                $updated = date("Y-m-d H:i:s");                            
                                $arrayIdUsuario = array(
                                    "idFraccionamiento" => $idFraccionamiento,
                                    "idUsuario" => $id,
                                    "created" => $created,
                                    "updated" => $updated,
                                    "created_by" => $created_by,
                                    "updated_by" => $updated_by
                                );
                                array_push($pushFraccxUs, $arrayIdUsuario);
                            }
                        }
                        if (count($pushFraccxUs)>0 && !empty($pushFraccxUs) ) {
                            $this->db->insert_batch('fraccionamientosxusuarios', $pushFraccxUs);
                        }*/
                        
                        $arrayIdUsuario = array();
                        $pushFraccxUs = array();
                        if (is_array($fraccionamientos) && count($fraccionamientos) > 0 && !empty($fraccionamientos) && $id > 0){
                            $sessionId = (isset($_SESSION[$this->nsession]['id']) && (!empty($_SESSION[$this->nsession] ['id'])) ? $_SESSION[$this->nsession]['id'] : 0);
                            //$date = date("Y-m-d H:i:s");
                            $created_by = $sessionId;
                            $updated_by = $sessionId;
                            foreach ($fraccionamientos as $idFraccionamiento) { //este array contiene los ids de usuarios
                                $created = date("Y-m-d H:i:s");
                                $updated = date("Y-m-d H:i:s");
                                $arrayIdUsuario = array(
                                    "idFraccionamiento" => $idFraccionamiento,
                                    "idUsuario" => $id,
                                    "created" => $created,
                                    "updated" => $updated,
                                    "created_by" => $created_by,
                                    "updated_by" => $updated_by
                                );
                                array_push($pushFraccxUs, $arrayIdUsuario);
                            }
                        }
                        if (count($pushFraccxUs)>0 && !empty($pushFraccxUs) ) {
                            $this->db->insert_batch('fraccionamientosxusuarios', $pushFraccxUs); //insertamos el batch de usuarios a ese fraccionamiento
                        }
                        
                        if( $pData['rol'] == 2 ) { 
                            //Obtiene todos los promotores
                            $query=$this->db->query("SELECT id FROM usuarios WHERE rol=2;");
                            if( $query->num_rows() > 0 ) { 
                                foreach ($query->result() as $row) {
                                    $idPromotor=$row->id;
                                    $gerentes="";
                                    //Obtiene todos tus gerentes partiendo de los fraccionamientos en los que te encuentras
                                    $query2=$this->db->query("SELECT u.id FROM fraccionamientosxusuarios AS fxu, usuarios AS u WHERE
                                        idUsuario=u.id AND u.rol=4 AND idFraccionamiento IN (SELECT idFraccionamiento FROM fraccionamientosxusuarios WHERE idUsuario=$idPromotor) GROUP BY u.id;");
                                    if( $query2->num_rows() > 0 ) { 
                                        foreach ($query2->result() as $row2) {
                                            $gerentes.=$row2->id." ";
                                        }
                                    }
                                    //Actualiza created_ by con los gerentes de tus fraccionamientos
                                    $this->db->query("UPDATE usuarios SET created_by='$gerentes' WHERE id=".$row->id);
                                }
                            }
                        }
                        
                        if ($enviarMail == true) { 
                            $email_enviado = $this->email_contacto($pData['usuario'], $password, $pData['email'], 'Viviend - Actualización de cuenta');
                            if ($email_enviado == true) { 
                                switch ($tipoDeUsuario) {
                                    case 'promotor':
                                        redirect('promotores');
                                        break;
                                    default:
                                        redirect($this->router->class);
                                        break;
                                }
                            }
                            else { 
                                $data['warning_rubro'] = "Error al intentar enviar el correo, intente más tarde";
                            }
                        }
                        else { 
                            switch ($tipoDeUsuario) {
                                case 'promotor':
                                    redirect('promotores');
                                    break;
                                default:
                                    redirect($this->router->class);
                                    break;
                            }
                        }                    
                        /*if ($email_enviado == true) {
                            switch ($tipoDeUsuario) {
                                case 'promotor':
                                    redirect('promotores');
                                    break;
                                default:
                                    redirect($this->router->class);
                                    break;
                            }
                        } 
                        else { 
                            $data['warning_rubro'] = "Error al intentar enviar el correo, intente más tarde";
                        }*/
                    }
                }
            }
            // Obteniendo la información
            $info = $this->musuario->getById($id);
            $data['info'] = $info;
            $data['msg']=$msg;
            
            $data['fraccionamientos'] = $this->mfraccionamiento->getAll();
            $fraccionamientosxusuario = $this->mfraccionamientoxusuario->getByIdUsuario($id);
            $arrayFraccionamientosxusuario = array();
            if (!is_numeric($fraccionamientosxusuario)){
                $i=0;
                foreach ($fraccionamientosxusuario->result() as $fu) {
                    $arrayFraccionamientosxusuario[$i] = $fu->idFraccionamiento;
                    $i++;
                }
            }
            $data['fraccionamientosxusuario'] = $arrayFraccionamientosxusuario;
            
            $vistaLoad = ($tipoDeUsuario == 'promotor')?"/editar_promotor_view":"/editar_view";
            $this->data['contenido'] = $this->load->view('usuarios' . $vistaLoad, $data, true);//$this->mainView
            $this->load->view('templates/main_template', $this->data);
        }
        
        public function borrarFxU($id) {
            $sql = "DELETE FROM fraccionamientosxusuarios where idUsuario=".$id;
            $this->db->query($sql);
        }
        
        public function eliminar() {
            $id = $this->input->post('elid');
            $q = $this->musuario->getById($id);
            $cValor = "true";
            $this->musuario->borrar($id);
            $data = json_encode(array("valor" => $cValor));
            echo $data;
        }
        
        public function email_contacto($usuario,$password,$correo,$asunto=''){
            $this->load->library('email');
            
            $mensaje = "
                    Se ha creado una cuenta en el sistema<br><br>
                    --
                    Usuario: <strong>" . $usuario . "</strong><br>
                    Password: <strong>" . $password . "</strong><br>
                    Ingresar: " . base_url() . "
                    --";
            
            if ( $asunto == "" ) {
                $asunto = 'Viviend - Creación de cuenta';
            }
            
            $this->email->clear();
            $this->email->set_mailtype("html");
            $this->email->from($correo);
            $this->email->to('aviles1189@gmail.com');
            $this->email->subject($asunto);
            $this->email->message($mensaje);
            
            
            if ( !$this->email->send()) {
                $respuesta = false;
            }
            else { 
                $respuesta = true;
            }
            
            /*  $this->email->clear();
            $this->email->set_mailtype("html");
            $this->email->from($correo);
            
            $this->email->to('jesus@navegantes.mx');
            $this->email->subject($asunto);
            $this->email->message($mensaje);
            $this->email->send();
            
            $this->email->clear();
            $this->email->set_mailtype("html");
            $this->email->from('contacto@cactusfilm-mexico.com');
            $this->email->to($correo);
            $this->email->subject($asunto);
            $this->email->message($mensaje);
            $this->email->send();*/
            
            return $respuesta;
        }
    }
?>