<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Preorden extends MX_Controller {
	public $data,$vParameters,$mainView,$fv,$estimacion;
	public function __construct(){
	$this->nsession = $this->config->item('nsession');
    if (!isset($_SESSION[$this->nsession]) || (($_SESSION[$this->nsession]['usuario'] == ""))) redirect('login');
            $this->fv = 'preorden'; // form validation variable
            $this->mainView = 'preorden';
            $this->data['fjs'] = '';
            $this->data['js'] = '';
            $this->data['css'] = '';
            // Tools
            $this->load->helper(array('tools','numeros','url','form','date','text','security'));
            // Modelos
            $this->load->model(array('musuario','mconstructores','mop_detalle','mordenes_pago','mmovimientos','mcortes','mfraccionamiento','mproyecto'));
            valSession("obra",$this->fv);
			require("Estimacion.php");
			$this->estimacion=new Estimacion();
    }

    public function index($id=0){
		$this->data['js'] = ' <script src="assets/js/preorden/listado.js?v=0.1" type="text/javascript"></script>';
		$data['q'] = '';
		$valCorte=$this->mcortes->valCorteActual($id);
		if(!is_numeric(($valCorte))){
			$data["corte"]=$corte=$valCorte->row();
			$constructor="CONCAT_WS(' ',cons.nombre,cons.apellidoP,cons.apellidoM) titulo";
			$data['constructores']=$this->db->query("SELECT op.idConstructor id,$constructor FROM ordenes_pago op 
			LEFT JOIN constructores cons ON cons.id=op.idConstructor
			WHERE $corte->semana=op.semanaAnual AND $corte->ano=YEAR(op.fecha)");
			$data['constructores2']=$this->mconstructores->getSelectResult();
			$this->data['contenido'] = $this->load->view($this->mainView.'/index_view',$data,true);
		}else{
			$this->data['contenido']="No existe el corte indicado";
		}
		$this->load->view('templates/main_template',$this->data);
	}

	public function addContratista(){
		$error="";
		if(isset($_POST["idConstructor"]) && isset($_POST["idCorte"])){
			$valCorte=$this->mcortes->valCorteActual($_POST["idCorte"]);
			if(!is_numeric(($valCorte))){
				$corte=$valCorte->row();
				$valContratista=$this->db->query("SELECT id FROM ordenes_pago WHERE $corte->semana=semanaAnual AND $corte->ano=YEAR(fecha) AND idConstructor=".$_POST["idConstructor"]);
				if($valContratista->num_rows()==0){
					$this->mordenes_pago->insertar([
						"idConstructor"=>$_POST["idConstructor"],
						"semanaAnual"=>$corte->semana,
						"fecha"=>$corte->fechaCorte,
					]);
				}else{
					$error="El contratista ya existe en la preorden";
				}
			}
		}else{
			$error="Datos Incompletos";
		}
		echo json_encode(["error"=>$error]);
	}

	public function extras($id,$idCorte){
		$data['q'] = '';
		$this->data['js'] = '<script src="assets/js/preorden/extras.js" type="text/javascript"></script>';
		$data=$this->mordenes_pago->getById($id);
		$data["idCorte"]=$idCorte;
		$data["fraccionamientos"]=$this->mfraccionamiento->getAll();
		$this->data['contenido'] = $this->load->view($this->mainView.'/extras_view',$data,true);
		$this->load->view('templates/main_template',$this->data);
	}

	public function addExtras(){
		$data=$_POST;
		$error="";
		if(COUNT($data)>5){
			$tipoExtra=$data["tipoExtra"];
			$idOrdenPago=$data["idOrdenPago"];
			$idFraccionamiento=$data["idFraccionamiento"];
			$cantidad=$data["cantidad"];
			$precioUnitario=$data["precioUnitario"];
			$descripcion=$data["descripcion"];
			$ordenPago=$this->mordenes_pago->getById($idOrdenPago);
			if($tipoExtra==1){
				$lote=$data["lote"];
				$manzana=$data["manzana"];
				$proyecto=$this->db->query("SELECT pro.id,dp.idPaquete FROM detalle_paquete dp
				LEFT JOIN proyectos pro ON pro.id=dp.idProyecto
				WHERE pro.idFraccionamiento=$idFraccionamiento AND pro.lote='$lote' AND pro.manzana='$manzana'");
				if($proyecto->num_rows()>0){
					$proyecto=$proyecto->row();
					$idOpd=$this->mop_detalle->insertar([
						"semanaActual"=>0,
						"semanaAnual"=>$ordenPago["semanaAnual"],
						"fecha"=>$ordenPago["fecha"],
						"idFraccionamiento"=>$idFraccionamiento,
						"idPaqPpto"=>0,
						"idAvance"=>0,
						"idEstimado"=>0,
						"idEstimaciones"=>0,
						"idPaquete"=>$proyecto->idPaquete,
						"idOrdenPago"=>$idOrdenPago,
						"idProyecto"=>$proyecto->id,
						"idPresupuesto"=>0,
						"idConstructor"=>$ordenPago["idConstructor"],
						"idSupervisor"=>0,
						"idInspector"=>0,
						"tipoLote"=>6,
						"iniciado"=>0,
						"calidad"=>"A",
						"descripcion"=>$descripcion,
						"precioUnitario"=>$precioUnitario,
						"cantidad"=>$cantidad,
						"percent_fg"=>0,
						"fg"=>0,
						"importe"=>$cantidad*$precioUnitario,
						"tipoActividad"=>2,
						"tipoExtra"=>$tipoExtra,
						"status"=>1,
					]);
				}else{
					$error="No existe lote y manzana";
				}
			}else if($tipoExtra==2){
				$idOpd=$this->mop_detalle->insertar([
					"semanaActual"=>0,
					"semanaAnual"=>$ordenPago["semanaAnual"],
					"fecha"=>$ordenPago["fecha"],
					"idFraccionamiento"=>$idFraccionamiento,
					"idPaqPpto"=>0,
					"idAvance"=>0,
					"idEstimado"=>0,
					"idEstimaciones"=>0,
					"idPaquete"=>0,
					"idOrdenPago"=>$idOrdenPago,
					"idProyecto"=>0,
					"idPresupuesto"=>0,
					"idConstructor"=>$ordenPago["idConstructor"],
					"idSupervisor"=>0,
					"idInspector"=>0,
					"tipoLote"=>6,
					"iniciado"=>0,
					"calidad"=>"A",
					"descripcion"=>$descripcion,
					"precioUnitario"=>$precioUnitario,
					"cantidad"=>$cantidad,
					"percent_fg"=>0,
					"fg"=>0,
					"importe"=>$cantidad*$precioUnitario,
					"tipoActividad"=>2,
					"tipoExtra"=>$tipoExtra,
					"status"=>1,
				]);
			}
		}else{
			$error="Datos incompletos";
		}
		echo json_encode(["data"=>[],"error"=>""]);
	}

	public function getManzanas($estatus=1){
		$query=0;
		if(isset($_POST["idFraccionamiento"])){
			$idFraccionamiento=$_POST["idFraccionamiento"];
			$query="
			SELECT pro.manzana id, pro.manzana titulo FROM detalle_paquete dp
			LEFT JOIN paquetes paq ON paq.id=dp.idPaquete 
			LEFT JOIN arranque arr ON FIND_IN_SET(paq.id,arr.idPaquetes) 						
			LEFT JOIN proyectos pro ON pro.id=dp.idProyecto 
			LEFT JOIN fraccionamientos fr ON fr.id=pro.idFraccionamiento
			WHERE fr.status=$estatus AND arr.estatus_arranque=2 AND fr.id=$idFraccionamiento
			GROUP BY pro.manzana ORDER BY pro.manzana+1 ASC";
		}
		if(!is_numeric($query)){
			$query=$this->db->query($query);
			if($query->num_rows()>0){
				$query=$query->result();
			}
		}
		echo json_encode($query);
	}

	public function getLotes($estatus=0){
		$query=0;
		if(isset($_POST["manzana"])){
			$manzana=$_POST["manzana"];
			$query="
			SELECT pro.id, pro.lote FROM detalle_paquete dp
			LEFT JOIN paquetes paq ON paq.id=dp.idPaquete 
			LEFT JOIN arranque arr ON FIND_IN_SET(paq.id,arr.idPaquetes) 						
			LEFT JOIN proyectos pro ON pro.id=dp.idProyecto 
			LEFT JOIN fraccionamientos fr ON fr.id=pro.idFraccionamiento
			WHERE fr.status=$estatus AND pro.manzana='$manzana' AND arr.estatus_arranque=2
			GROUP BY pro.lote ORDER BY pro.lote+1 ASC";
		}
		if(!is_numeric($query)){
			$query=$this->db->query($query);
			if($query->num_rows()>0){
				$query=$query->result();
			}
		}
		echo json_encode($query);
	}

	public function listado($id){
		$valCorte=$this->mcortes->valCorteActual($id);
		if(!is_numeric(($valCorte))){
			$corte=$valCorte->row();
			$constructor="CONCAT_WS(' ',cons.nombre,cons.apellidoP,cons.apellidoM) constructor";
			$q=$this->db->query("SELECT op.*,$constructor FROM ordenes_pago op 
			LEFT JOIN constructores cons ON cons.id=op.idConstructor
			WHERE $corte->semana=op.semanaAnual AND $corte->ano=YEAR(op.fecha)");
			if ($q->num_rows()>0){
				$importe=0;
				$extras=0;
				$total_prestamos=0;
				$total_amortizaciones=0;
				$total_retenciones=0;
				$fg=0;
				$sum_total=0;
				foreach ($q->result() as $row){
					$extra=$this->db->query("SELECT SUM(opd.importe) importe FROM op_detalle opd WHERE $corte->semana=opd.semanaAnual AND 
					$corte->ano=YEAR(opd.fecha) AND opd.tipoActividad=2 AND opd.idConstructor=$row->idConstructor");
					$retenciones=$this->db->query("SELECT SUM(monto) monto FROM movimientos WHERE idOrdenPago=$row->id AND (tipo=4 OR tipo=6 OR tipo=7)");
					$retenciones=($retenciones->num_rows()>0) ? $retenciones->row()->monto : 0;
					$prestamos=$this->db->query("SELECT SUM(monto) monto FROM movimientos WHERE idOrdenPago=$row->id AND tipo=1");
					$prestamos=($prestamos->num_rows()>0) ? $prestamos->row()->monto : 0;
					$comision=$this->db->query("SELECT SUM(monto) monto FROM movimientos WHERE idOrdenPago=$row->id AND tipo=8");
					$comision=($comision->num_rows()>0) ? $comision->row()->monto : 0;
					$comision=(($comision/100)*$row->importe);
					$amortizaciones=$this->db->query("SELECT SUM(monto) monto FROM movimientos WHERE idOrdenPago=$row->id AND tipo=3");
					$amortizaciones=($amortizaciones->num_rows()>0) ? $amortizaciones->row()->monto : 0;
					$total=($row->monto - ($amortizaciones+$retenciones+$comision) + $prestamos);
					$extra=($extra->num_rows()>0) ? $extra->row()->importe : 0;
					//sumatorias
					$importe+=$row->importe;
					$extras+=$extra; 
					$total_prestamos+=$prestamos;
					$total_amortizaciones+=$amortizaciones;
					$total_retenciones+=$retenciones;
					$fg+=$row->fg;
					$sum_total+=$total;
					$array['aaData'][] = array(
						'constructor' => $row->constructor,
						'nActividades' => $row->nActividades,
						'nLotes' => $row->nLotes,
						'nPaquetes' => $row->nPaquetes,
						'importe' => toNumber($row->importe - $extra),
						'extras' => toNumber($extra),
						'prestamos' => toNumber($prestamos),
						'amortizaciones' => toNumber($amortizaciones),
						'retenciones' => toNumber($retenciones + $comision),
						'fg' => toNumber($row->fg),
						'total' => toNumber($total),
						'acciones' => ($row->statusPago==0) ? accionesPreorden($row->id,$id,$this->router->class) : ''
					);
				}
				$array['aaData'][] = array(
					'tipo' => 'footer',
					'constructor' => "",
					'nActividades' => "",
					'nLotes' => "",
					'nPaquetes' => "",
					'importe' => toNumber($importe - $extras),
					'extras' => toNumber($extras),
					'prestamos' => toNumber($total_prestamos),
					'amortizaciones' => toNumber($total_amortizaciones),
					'retenciones' => toNumber($total_retenciones),
					'fg' => toNumber($fg),
					'total' => toNumber($sum_total),
					'acciones' => ''
				);
			}else{
				$array['aaData']=[];
			}
			echo json_encode($array);
		}
	}

	public function listadoExtras($id){
		$query=$this->db->query("SELECT * FROM op_detalle opd WHERE opd.idOrdenPago=$id AND opd.tipoActividad=2");
		if ($query->num_rows()>0){
			$totalImporte=0;
			foreach ($query->result() as $row){
				//sumatorias
				$totalImporte+=$row->importe;
				$array['aaData'][] = array(
					'fraccionamiento' => $this->mfraccionamiento->getCampo("titulo",$row->idFraccionamiento),
					'tipoExtra' => ($row->tipoExtra==1) ? "LOTE" : "FRACCIONAMIENTO",
					'Lote' => ($row->tipoExtra==1) ? $this->mproyecto->getCampo("lote",$row->idProyecto) : "",
					'manzana' => ($row->tipoExtra==1) ? $this->mproyecto->getCampo("manzana",$row->idProyecto) : "",
					'descripcion'=>$row->descripcion,
					'cantidad' => '<input id="'.$row->id.'" type="text" class="form-control myInput cantidad_'.$row->id.'" value="'.$row->cantidad.'" style="width: 80px;">',
					'precio' => '<input id="'.$row->id.'" type="text" class="form-control myInput precio_'.$row->id.'" value="'.$row->precioUnitario.'" style="width: 80px;">',
					'importe' => "<div class='importe importe_$row->id'>$row->importe</div>",
					'acciones' => '<a href="javascript:void(0);" id="'.$row->id.'" class="borrar"><i class="fa fa-trash" aria-hidden="true"></i></a>',
					'_importe' => $row->importe,
				);
			}
		}else{
			$array['aaData']=[];
		}
		echo json_encode($array);
	}

	public function eliminarDetalle(){
        $id = $this->input->post('id');
        $this->mop_detalle->borrar($id);
		echo json_encode(["error"=>"ok"]);
    }

	public function actualizarDetalle(){
		$importe=0;
		if(isset($_POST["id"]) && isset($_POST["cantidad"]) && isset($_POST["precio"])){
			$id=$_POST["id"];
			$cantidad=$_POST["cantidad"];
			$precio=$_POST["precio"];
			$importe=$cantidad*$precio;
			$this->mop_detalle->actualizar([
				"precioUnitario"=>$precio,
				"cantidad"=>$cantidad,
				"importe"=>$importe,
			],$id);
		}
		echo json_encode($importe);
	}

	public function getOpConstructor(){
		if(isset($_POST["id"])){
			$idOrdenPago=$_POST["id"];
			$idCorte=$_POST["idCorte"];
			$valCorte=$this->mcortes->valCorteActual($idCorte);
			if(!is_numeric($valCorte)){
				$query=$this->db->query("SELECT op.*,GROUP_CONCAT(DISTINCT opd.tipoLote) tipos FROM ordenes_pago op 
				LEFT JOIN op_detalle opd ON opd.idOrdenPago=$idOrdenPago AND opd.calidad='A' WHERE op.id=$idOrdenPago GROUP BY op.id");
				$tiposPpto=$this->db->query("SELECT tipoLote, ROUND(AVG(percent_fg),2) percent_fg  FROM op_detalle WHERE idOrdenPago=$idOrdenPago AND calidad='A' GROUP BY tipoLote");
				$mov=$this->mmovimientos->getByIdAndTipo($idOrdenPago,0,$valCorte->row());
				echo json_encode([
						"data" => $query->result(),
						"tipos" => ($tiposPpto->num_rows()>0) ? $tiposPpto->result() : 0,
						"movimientos"=>(!is_numeric($mov)) ? $mov->result() : 0,
					]);
			}
		}
	}

	public function saveMovimientos($id){
		$idOrdenPago=$_POST["idOrdenPago"];
		$idConstructor=$_POST["idConstructor"];
		$otros=$_POST["otros"];
		$amortizacion=$_POST["amortizacion"];
		$prestamo=$_POST["prestamo"];
		$formaPago=$_POST["formaPago"];
		$comision=$_POST["comision"];
		$tipos=$_POST["tipos"];
		$ordenPago=$this->mordenes_pago->getById($idOrdenPago);

		$valCorte=$this->mcortes->valCorteActual($id);
		if(!is_numeric(($valCorte))){
			$corte=$valCorte->row();
			$this->getArrMovimiento($idOrdenPago,1,$prestamo,$corte);
			$this->getArrMovimiento($idOrdenPago,3,$amortizacion,$corte);
			$this->getArrMovimiento($idOrdenPago,7,$otros,$corte);
			$this->getArrMovimiento($idOrdenPago,8,$comision,$corte);

			//actualizacion de fondos de garantia
			if(COUNT($tipos)>0){
				foreach ($tipos as $row) {
					$value=$row["value"];
					if($value > 0){
						$this->db->query("UPDATE op_detalle SET percent_fg=$value,fg=importe*($value/100)
						WHERE semanaAnual=$corte->semana AND YEAR(fecha)=$corte->ano AND idConstructor=$idConstructor AND calidad='A' AND tipoLote=".$row["id"]);
						//actualizacion de orden pago
						$totales=$this->db->query("SELECT SUM(importe-fg) monto,SUM(fg) fg FROM op_detalle WHERE idOrdenPago=$idOrdenPago AND calidad='A'");
						$fg=0;
						$monto=0;
						if($totales->num_rows()>0){
							$fg=$totales->row()->fg;
							$monto=$totales->row()->monto;
						}
						$this->mordenes_pago->actualizar([
							"fg"=>$fg,
							"monto"=>$monto
						],$idOrdenPago);
					}	
				}
			}
			$this->mordenes_pago->actualizar(["formaPago"=>$formaPago],$idOrdenPago);
			echo "ok";
		}else{

		}
	}

	public function getArrMovimiento($idOrdenPago,$tipo,$monto=0,$corte=[]){
		$ordenPago=$this->mordenes_pago->getById($idOrdenPago);
		if($monto != '' && is_numeric($monto)){
			$array=[];
			$array['idOrdenPago']=$idOrdenPago;
			$array['semanaAnual']=$ordenPago["semanaAnual"];
			$array['fecha']=$ordenPago["fecha"];
			$array['tipo']=$tipo;
			$array['monto']=$monto;
			$mov=$this->mmovimientos->getByIdAndTipo($idOrdenPago,$tipo,$corte);
			$saldoPrestamos=$this->mconstructores->getCampo("saldoPrestamos",$ordenPago["idConstructor"]);
			if(is_numeric($mov)){
				if($tipo==1){
					$this->mconstructores->actualizar([
						"saldoPrestamos"=>$saldoPrestamos+$monto
					],$ordenPago["idConstructor"]);
				}else if($tipo==3){
					$this->mconstructores->actualizar([
						"saldoPrestamos"=>$saldoPrestamos-$monto
					],$ordenPago["idConstructor"]);
				}
				$this->mmovimientos->insertar($array);
			}else{
				if($tipo==1){
					$this->mconstructores->actualizar([
						"saldoPrestamos"=>(($saldoPrestamos - $mov->row()->monto) + $monto)
					],$ordenPago["idConstructor"]);
				}else if($tipo==2){
					$this->mconstructores->actualizar([
						"saldoPrestamos"=>(($saldoPrestamos + $mov->row()->monto) - $monto)
					],$ordenPago["idConstructor"]);
				}
				$this->mmovimientos->actualizar($array,$mov->row()->id);
			}
		}
	}
	
	public function generar($id=0){
		//post_procesados idOrdenPago, idConstructor, idProyecto, iniciado, calidad, importe
		$valCorte=$this->mcortes->valCorteActual($id);
		if(!is_numeric(($valCorte))){
			$corte=$valCorte->row();
			$query="SELECT pmo.id myIdPpto, mo.id idManoObra, ones.nEstimacion semanaActual, $corte->semana semanaAnual, '$corte->fechaCorte' fecha, 
			paqp.id idPaqPpto, ao.id idAvance, ao.idEstimado, ones.id idEstimaciones, paq.id idPaquete, paq.tipoEstimacion,
			ao.lotes, ao.avanceC, ao.iniciado ,paq.tipoLote, paqp.lotesI, ao.calidad, ados.idPresupuesto, paq.idConstructor, ao.idConstructor idConstructorAo,
			pmo.precioUnitario, act.cantidad, mo.idFraccionamiento, arr.retencionfg,paqp.lotes lotesP
			FROM avanceobra ao
			LEFT JOIN estimados_programa ados ON ados.id=ao.idEstimado
			LEFT JOIN estimaciones_programa ones ON ones.id=ados.idEstimaciones
			LEFT JOIN estimacion_programa ion ON ion.id=ones.idEstimacion
			LEFT JOIN paquetes paq ON paq.id=ion.idPaquete
			LEFT JOIN arranque arr ON FIND_IN_SET(paq.id,arr.idPaquetes)
			LEFT JOIN detalle_paquete dp ON dp.idPaquete=paq.id
			LEFT JOIN paquete_presupuesto paqp ON paqp.idPresupuestoMO=ados.idPresupuesto AND paqp.idPaquete=paq.id
			LEFT JOIN mano_obra mo ON mo.id=paq.idManoObra
			LEFT JOIN presupuesto_mo pmo ON pmo.idManoObra=mo.id AND pmo.id=paqp.idPresupuestoMO
			LEFT JOIN actividadesprototipo act ON act.id=pmo.idActividadPrototipo
			LEFT JOIN categorias_mo cat ON cat.id=act.idCategoria
			LEFT JOIN proyectos pro ON pro.id=dp.idProyecto
			LEFT JOIN fraccionamientos fra ON fra.id=pro.idFraccionamiento
			LEFT JOIN actividades_mo actmo ON actmo.id=act.idActividad
			LEFT JOIN usuarios usr ON usr.id=dp.idResidente
			WHERE arr.estatus_arranque=2 AND (ao.lotes != '' OR ao.avanceC != '' OR ao.iniciado != '') AND $corte->semana=WEEK(ones.fecha,7) AND $corte->ano=YEAR(ones.fecha)
			GROUP BY ao.id";
			$this->db->trans_begin();
			//eliminación de estimación anterior
			$this->db->query("DELETE FROM ordenes_pago WHERE semanaAnual=$corte->semana AND $corte->ano=YEAR(fecha)");
			$this->db->query("DELETE FROM op_detalle WHERE semanaAnual=$corte->semana AND $corte->ano=YEAR(fecha) AND tipoActividad=1");
			$this->db->query("DELETE FROM movimientos WHERE semanaAnual=$corte->semana AND $corte->ano=YEAR(fecha)");
			$estatus=true;
			$query=$this->db->query($query);
			if($query->num_rows()>0){
				foreach ($query->result() as $row) {
					//desagrupacion de lotes
					$lotes=[];
					if($row->tipoEstimacion==1){
						$lotes=($row->lotes != '') ? explode(',',$row->lotes) : [];
						$res=$this->insertOpDetalle($row,$lotes,'lotes');
						if(!$res && $estatus){
							$estatus=$res;
						}
						//iniciado
						if($row->iniciado !== ''){
							$lotesI=($row->iniciado != '') ? explode(',',$row->iniciado) : [];
							$res=$this->insertOpDetalle($row,$lotesI,'iniciado');
							if(!$res && $estatus){
								$estatus=$res;
							}
						}
					}else if($row->tipoEstimacion==2){
						$lotes=($row->avanceC != '') ? json_decode($row->avanceC,true) : [];
						$res=$this->insertOpDetalle($row,$lotes);
						if(!$res && $estatus){
							$estatus=$res;
						}
					}
				}
				(!$estatus) ? $this->generar() : '';
				$this->createOrdenes($corte->id);
				$this->mcortes->actualizar(["statusCorte"=>2],$corte->id);
			}
			if ($this->db->trans_status() === FALSE){
				$this->db->trans_rollback();
			}else{
				$this->db->trans_commit();
			}
			redirect("preorden/index/$id");
		}else{
			echo "No existe el corte indicado";
		}
	}

	public function insertOpDetalle($row,$lotes,$column=""){
		$estatus=true;
		foreach ($lotes as $key => $val) {
			$ltemza=($row->tipoEstimacion==1) ? $val : $key;
			$ltemza=explode('/',$ltemza);
			$lote=$ltemza[0];
			$mza=$ltemza[1];
			$validate=false;
			//validaciones
			if($column=="lotes"){
				$validate=($this->estimacion->getStatusCheck($lote,$mza,$row->lotes) &&  
				$this->estimacion->getStatusCheck($lote,$mza,$row->lotesP));
			}else if($column=="iniciado"){
				$validate=($this->estimacion->getStatusCheck($lote,$mza,$row->iniciado) &&  
				$this->estimacion->getStatusCheck($lote,$mza,$row->lotesI));
			}else{
				$validate=true;
			}
			if($column!="" && !$validate){
				$estatus=false;
				//echo "<pre>";
				//print_r($row);
				$params['lote'] = $lote;
				$params['manzana'] = $mza;
				$params['tabla'] = 'paquete_presupuesto';
				$params['id'] = $row->idPaqPpto;
				$params['lotes'] = ($column=="lotes") ? $row->lotesP : $row->lotesI;
				$params['column'] = ($column=="lotes") ? 'lotes' : 'lotesI';
				$params['estado'] = true;
				//$this->estimacion->checkLote($params,false);
			}
			if($row->precioUnitario && $validate){
				$op_detalle['semanaActual']=$row->semanaActual;
				$op_detalle['semanaAnual']=$row->semanaAnual;
				$op_detalle['fecha']=$row->fecha;
				$op_detalle['idFraccionamiento']=$row->idFraccionamiento;
				$op_detalle['idPaqPpto']=$row->idPaqPpto;
				$op_detalle['idAvance']=$row->idAvance;
				$op_detalle['idEstimado']=$row->idEstimado;
				$op_detalle['idEstimaciones']=$row->idEstimaciones;
				$op_detalle['idPaquete']=$row->idPaquete;
				$op_detalle['idPresupuesto']=$row->idPresupuesto;
				$op_detalle['precioUnitario']=$row->precioUnitario;
				$op_detalle['cantidad']=$row->cantidad;
				$op_detalle['tipoLote']=$row->tipoLote;
				$proyecto=$this->db->query("SELECT pro.id,dp.idResidente,dp.idInspector FROM detalle_paquete dp
				LEFT JOIN proyectos pro ON pro.id=dp.idProyecto
				WHERE dp.idPaquete=$row->idPaquete AND pro.idFraccionamiento=$row->idFraccionamiento AND pro.lote='$lote' AND pro.manzana='$mza' ");
				//post procesados
				$cantidad=($row->tipoEstimacion==1) ? $row->cantidad : $this->getValAssociative($lote,$mza,$row->avanceC);
				$importe=$row->precioUnitario*$cantidad;
				if($proyecto->num_rows()>0){
					$idProyecto=$proyecto->row()->id;
					$idConstructor=$this->getValAssociative($lote,$mza,$row->idConstructorAo);
					$idConstructor=($idConstructor != '') ? $idConstructor : $row->idConstructor;
					$op_detalle['idProyecto']=$idProyecto;
					$op_detalle['idConstructor']=$idConstructor;
					$op_detalle['iniciado']=$this->getStatusLotes($lote,$mza,$row->iniciado);
					$op_detalle['calidad']=$this->getValAssociative($lote,$mza,$row->calidad);
					$op_detalle['importe']=$importe;
					$op_detalle['percent_fg']=$row->retencionfg;
					$op_detalle['fg']=($importe*($row->retencionfg/100));
					$op_detalle['idSupervisor']=$proyecto->row()->idResidente;
					$op_detalle['idInspector']=$proyecto->row()->idInspector;
					$exist=$this->db->query("SELECT id FROM op_detalle WHERE idPaquete=$row->idPaquete AND idProyecto=$idProyecto AND idPresupuesto=$row->idPresupuesto");
					if($exist->num_rows()==0){
						$this->mop_detalle->insertar($op_detalle);
					}
				}else{
					//salida test
					echo "<pre>";
					print_r($row);
				}
			}
		}
		return $estatus;
	}

	public function createOrdenes($idCorte,$redirect=false){
		$valCorte=$this->mcortes->valCorteActual($idCorte);
		if(!is_numeric(($valCorte))){
			$corte=$valCorte->row();
			$this->db->query("UPDATE op_detalle SET calidad='A' WHERE semanaAnual=$corte->semana AND YEAR(fecha)=$corte->ano");
			$this->db->query("DELETE FROM ordenes_pago WHERE semanaAnual=$corte->semana AND $corte->ano=YEAR(fecha)");
			$q=$this->db->query("SELECT opd.idConstructor,COUNT(opd.id) nActividades, COUNT(DISTINCT opd.idProyecto) nLotes, COUNT(DISTINCT opd.idPaquete) nPaquetes, opd.fecha,
			SUM(opd.importe) importe, opd.semanaAnual, SUM(opd.fg) fg, SUM(opd.importe - opd.fg) total
			FROM op_detalle opd
			LEFT JOIN constructores cons ON cons.id=opd.idConstructor
			LEFT JOIN paquetes paq ON paq.id=opd.idPaquete
			LEFT JOIN arranque arr ON FIND_IN_SET(paq.id,arr.idPaquetes)
			WHERE $corte->semana=opd.semanaAnual AND $corte->ano=YEAR(opd.fecha) AND opd.calidad='A'
			GROUP BY opd.idConstructor");

			$orden=[];
			if($q->num_rows() > 0){
				foreach ($q->result() as $row) {
					$exist=$this->db->query("SELECT id FROM ordenes_pago WHERE idConstructor=$row->idConstructor AND semanaAnual=$row->semanaAnual AND YEAR(fecha)=YEAR('$row->fecha')");
					$orden["idConstructor"]=$row->idConstructor;
					$orden["semanaAnual"]=$row->semanaAnual;
					$orden["nActividades"]=$row->nActividades;
					$orden["nLotes"]=$row->nLotes;
					$orden["nPaquetes"]=$row->nPaquetes;
					$orden["fecha"]=$row->fecha;
					$orden["importe"]=$row->importe;
					$orden["fg"]=$row->fg;
					$orden["monto"]=$row->total;
					$orden["statusPago"]=0;
					$orden["formaPago"]=1;
					if($exist->num_rows()==0){
						$id=$this->mordenes_pago->insertar($orden);
						$exist=$this->db->query("UPDATE op_detalle SET idOrdenPago=$id WHERE idConstructor=$row->idConstructor AND semanaAnual=$row->semanaAnual AND YEAR(fecha)=YEAR('$row->fecha')");
					}
				}
			}
		}
		($redirect) ? redirect("preorden/index/".$idCorte) : false;
	}

	private function getValAssociative($lote, $manzana, $lotes = null) {
		$ltemza = $lote . '/' . $manzana;
		$value = '';
		$myLotes = $lotes ?? '';
		if ($myLotes !== 'null' && $myLotes !== '' && $myLotes !== null && !empty($myLotes)) {
			$lotesMap = json_decode($myLotes, true);
			if (array_key_exists($ltemza, $lotesMap)) {
				$value = $lotesMap[$ltemza];
			}
		}
		return $value;
	}

	private function getStatusLotes($lote, $manzana, $lotes = null) {
		$lotesArray = (!is_null($lotes) && $lotes !== '') ? explode(',', $lotes) : [];
		$ltemza = $lote . '/' . $manzana;
		return in_array($ltemza, $lotesArray);
	}


}
