<?php
	defined('BASEPATH') OR exit('No direct script access allowed');

	class Pptomat extends MX_Controller {
		public $data,$vParameters,$mainView,$fv;

		public function __construct() {
			$this->nsession = $this->config->item('nsession');
			if (!isset($_SESSION[$this->nsession]) || (($_SESSION[$this->nsession]['usuario'] == ""))) redirect('login');
			$this->fv = 'pptomat'; // form validation variable
			$this->mainView = 'pptomat';
			$this->data['fjs'] = '';
			$this->data['js'] = ' <script src="assets/js/pptomat/listado.js?v=0.1" type="text/javascript"></script>
								  <script src="assets/js/pptomat/listadoDetalle.js?v=0.2" type="text/javascript"></script>
								  <script src="assets/js/pptomat/listadoResumen.js?v=0.1" type="text/javascript"></script>
								  <script src="assets/js/pptomat/bootstrap-fileinput.js" type="text/javascript"></script> ';
			$this->data['css'] = '<link href="assets/css/bootstrap-fileinput.css" rel="stylesheet" type="text/css" />';
			// Tools
            $this->load->helper(array('tools','numeros','url','form','date','text','security'));
            // Modelos
            $this->load->model(array('mfraccionamiento', 'mprototipoxfraccionamiento', 'mprototipos', 'mpaquete', 'mactividadesprototipo', 
			'mmaterialesactividadprototipo', 'mmaterial', 'mpresupuestomat','mmateriales', 'munidades', 'mproveedor', 'mareamaterial', 'musuario', 
			'mmanoobra','mordencompra','mdetallepaquete','mpresupuestomo','malmacenes','mconstructores','mempresas','mcategoriamat','marranque','majustes'));

			$this->load->library('csvimport');
			$this->load->library('excel');
            $this->data['fotos_www'] = $this->config->item('base_www').'/pmat/';
			valSession("costos",$this->fv);
		}

		public function index(){
			$data['q'] = '';
			$data['msg'] = '';
			$this->data['contenido'] = $this->load->view($this->mainView.'/index_view',$data,true);
	        $this->load->view('templates/main_template',$this->data);
		}

		public function sync(){
			require('Ms.php');
			$ms=new Ms();
			$precios=[];
			if(isset($_POST["idEmpresa"]) && isset($_POST["data"])){
				$idEmpresa=$_POST["idEmpresa"];
				$data=$_POST["data"];
				foreach ($data as $row) {
					$res=$ms->GetPrecioUnitarioCM(['un' => $idEmpresa, 'id_proveedor' => $row['idProveedor'], 'id_articulo' => $row['idMaterial']]);
					if($res > 0 && ($res != $row['precioUnitario'])){
						array_push($precios,["id"=>$row['id'],"precioUnitario"=>$res]);
					}
				}
			}
			echo json_encode($precios);
		}
		
	    public function excel(){
	       $columnas = array(
	                    0 => 'PAQUETE',
	                    1 => 'PROTOTIPO',
	                    2 => 'TOTAL UNITARIO',
	                    3 => 'TOTAL PAQUETE'
	  		);
			$idEmpresa = $_SESSION["viv"]['idEmpresa'];
		    $q = $this->mmaterial->getByIdEmpresa($idEmpresa);
			$array = array();
		    if (!is_numeric($q)){
				foreach ($q->result() as $row){	
					$prototipo = $this->mprototipos->getCampo2('nombre', $row->idPrototipo);
					$paquete = $this->mpaquete->getCampo('titulo', $row->idPaquete);
					$totalUnitario = $this->mpresupuestomat->getSumTotalUnitario($row->id);
					$qPaquete = $this->mpaquete->getById($row->idPaquete);
					$lotesManzana = contarLotesManzanas($qPaquete['rango_lotes']);
					$lotes = $lotesManzana['total'];
					$totalPresupuesto = $totalUnitario * $lotes;
		            $array[] = array(
		                0 => $paquete,
		                1 => $prototipo,
		               	2 => precio_format($totalUnitario),
		               	3 => precio_format($totalPresupuesto)
		            );
		        }
		    }
	       	crearExcel($array,'pmat',$columnas,'array');
	    }

		public function listado(){
			$idEmpresa = $_SESSION["viv"]['idEmpresa'];
	        $q = $this->mmaterial->getByIdEmpresa($idEmpresa);
	        if (!is_numeric($q)){
				foreach ($q->result() as $row){
					$validar = true;
					$qArranque = $this->db->query("SELECT * FROM arranque WHERE status = 1 AND FIND_IN_SET('$row->idPaquete',idPaquetes)");
					if($qArranque->num_rows() > 0){
						if($qArranque->row()->estatus_arranque == 3){
							$validar = false;
						}
					}
					//$inputFile =  'No disponible';
						$inputFile = '<form id="'. $row->id .'" role="form" enctype="multipart/form-data" action="'. $this->router->class . '/editar/'.$row->id. '" method="post">
											<label><input type="checkbox" name="checkEliminar"> Actualizar Y Eliminar</label><br>
											<div class="form-group">
												<div class="col-md-2">
													<div class="fileinput fileinput-new" data-provides="fileinput">
														<div class="input-group">
															<div class="form-control uneditable-input input-fixed" data-trigger="fileinput">
																<i class="fa fa-file fileinput-exists"></i>&nbsp;
																<span class="fileinput-filename"> </span>
															</div>
															<span class="input-group-addon btn default btn-file">
																<span class="fileinput-new"> Seleccionar </span>
																<span class="fileinput-exists"> Cambiar </span>
																<input type="file" name="archivoMateriales" accept=".csv"> </span>
															<a href="javascript:;" class="input-group-addon btn red fileinput-exists" data-dismiss="fileinput" onClick="editar('.$row->id.');"> Actualizar </a>
														</div>
													</div>
												</div>
											</div>
										</form>';
					//$qEstPaq = $this->db->query('SELECT statusPaquete FROM paquetes WHERE idManoObra = ' . $row->idManoObra . '');
					$eliminar=true;
					$estPaq = $qArranque->row_array();
					if (isset($estPaq)) {
						$etPaq = $estPaq['estatus_arranque'];

						switch($etPaq){
							case 2: $inputFile = "<p>Arranque En Curso :  No Puedes Actualizar.</p>";
								$eliminar=false;
								break;
							case 3: $inputFile = "<p>Arranque Finalizado :  No Puedes Actualizar.</p>";
								$eliminar=false;
								break;
							default: break;
						}	
					}
					$prototipo = $this->mprototipos->getCampo2('nombre', $row->idPrototipo);
					$paquete = $this->mpaquete->getCampo('titulo', $row->idPaquete);
					$totalUnitario = $this->mpresupuestomat->getSumTotalUnitario($row->id);
					$qPaquete = $this->mpaquete->getById($row->idPaquete);
					$lotesManzana = contarLotesManzanas($qPaquete['rango_lotes']);
					$lotes = $lotesManzana['total'];
					$totalPresupuesto = $totalUnitario * $lotes;
	                $array['aaData'][] = array(
	                    'paquete' => $paquete,
	                    'prototipo' => $prototipo,
	                   	'totalUnitario' => precio_format($totalUnitario),
	                   	'totalPaquete' => precio_format($totalPresupuesto),
	                    'inputFile' => $inputFile,
	                    'acciones' => accionesPresupuestoMat($row->id, $this->router->class, false, false, $eliminar, $validar, true, true)
	                );
	            }
	        }else{
	            $array['aaData'][] = array(
	                'paquete' => 'No hay registros',
	                'prototipo' => 'No hay registros',
					'totalUnitario' => 'No hay registros',
					'totalPaquete' => 'No hay registros',
					'inputFile' => 'No hay registros',
	                'acciones' => 'No hay registros'
	                );
	        }

	        echo json_encode($array);
	    }

		public function uploadFile($file_path="",$data=[]){
			$idEmpresa=(!isset($data["idEmpresa"])) ? $this->input->post("idEmpresa") : $data["idEmpresa"];
			$idMaterial=(!isset($data["idMaterial"])) ? $this->input->post("idMaterial") : $data["idMaterial"];
			$config['upload_path'] = $this->data['fotos_www'];
			$config['allowed_types'] = 'csv';
			$config['max_size'] = '200000';

			$this->load->library('upload', $config);
			if ($this->upload->do_upload("file") || $file_path != "") {
				if($file_path==""){
					$file_data = $this->upload->data();
					$file_path = $this->data['fotos_www'] . $file_data['file_name'];
				}
				$csv_array = $this->csvimport->get_array($file_path);
				$this->db->query("DELETE FROM presupuesto_mat WHERE idMaterial=$idMaterial");
				if(isset($csv_array[0]['CLAVE']) && isset($csv_array[0]['CLAVE_CAT']) && isset($csv_array[0]['PRECIO UNITARIO'])  && isset($csv_array[0]['CANTIDAD']) && isset($csv_array[0]['SEMANA']) && isset($csv_array[0]['PROVEEDOR'])) {
					if($csv_array[0]['CLAVE'] != "" && ($csv_array[0]['CANTIDAD'] != "" && $csv_array[0]['CANTIDAD'] > 0)  && ($csv_array[0]['PRECIO UNITARIO'] != "" && $csv_array[0]['PRECIO UNITARIO'] > 0)){
						foreach ($csv_array as $r) {
							//INSERTANDO materialesactividadprototipo
							$exist=$this->mmateriales->getByClave($r['CLAVE'], $idEmpresa);
							if(!is_numeric($exist)){
								$qProveedor = $this->mproveedor->getByNombre($r['PROVEEDOR'], $idEmpresa);
								if(!is_numeric($qProveedor) && $qProveedor['id'] != ''){
									$categoriamat=$this->mcategoriamat->getByClave($r['CLAVE_CAT']);
									if(!is_numeric($categoriamat)){
										$precioUnitario=str_replace("$", '', $r["PRECIO UNITARIO"]);
										if((is_numeric($precioUnitario) && $precioUnitario > 0) && (is_numeric($r['CANTIDAD']) && $r['CANTIDAD'] > 0)){
											$mapData['idActividadPrototipo']=0;
											$mapData['idMaterial']=$exist->id;
											$mapData['cantidad']=floatval($r['CANTIDAD']);
											$mapData['tipo']=2;
											$idMap = $this->mmaterialesactividadprototipo->insertar($mapData);

											$pData['idMaterial'] = $idMaterial;
											$pData['idMateriales'] = $idMap;
											$idProveedor = (!is_numeric($qProveedor)) ? $qProveedor['id'] : 0;
											$pData['idProveedor'] = $idProveedor;
											$pData['clave_cat'] = $r["CLAVE_CAT"];
											$pData['clave'] = $r["CLAVE"];
											$pData['precioUnitario'] = (is_numeric($precioUnitario) || is_float($precioUnitario)) ? $precioUnitario : 0;
											$pData['precioUnitario'] = floatval($pData['precioUnitario']);
											$pData['importe'] =floatval($r['CANTIDAD']) * floatval($pData['precioUnitario']);
											$pData['semana'] = ($r['SEMANA'] != '') ? $r['SEMANA'] : 0;
											$pData['status'] = 1;
											$idPresupuestoMaterial = $this->mpresupuestomat->insertar($pData);
										}
									}else{
										echo $r['CLAVE_CAT']." categoría no existe<br>";
									}
								}else{
									echo $r['PROVEEDOR']." proveedor no existe<br>";
								}
							}else{
								echo $r["CLAVE"]." clave no existe<br>";
							}
						}
					}
				}
			}
			//redirect("presupuestos");
		}
		
		public function __editar($id = null)
		{
			$idMaterial = $id;
			$material = $this->mmaterial->getById($id);
			$paquete = $this->mpaquete->getById($material['idPaquete']);
			$idManoObra = $paquete['idManoObra'];
			$idPrototipo = $material['idPrototipo'];
			$idEmpresa = (!is_numeric($material)) ? $material['idEmpresa'] : 0;
			$materialesPresupuesto = $this->mpresupuestomat->getByIdMaterial($material['id'], 0);
			$actualizados = 0;
			$noActualizadosOc = 0;
			$registrados = 0;
			$noRegistradosProveedor = 0;
			$noRegistradosOc = 0;
			$eliminados = 0;
			$noEliminadosOc = 0;
			if(isset($_FILES['archivoMateriales']) && !empty($_FILES['archivoMateriales']['name'])){
				$empty = true;
				$checkEliminar = $this->input->post('checkEliminar', TRUE);
				if (!is_numeric($materialesPresupuesto)) {
					$arrayPresupuestoMAT = array();
					foreach ($materialesPresupuesto->result() as $row) {
						$materialActividadPrototipo = $this->mmaterialesactividadprototipo->getById($row->idMateriales);
						if(!is_numeric($materialActividadPrototipo)){
							$material = $this->mmateriales->getById2($materialActividadPrototipo['idMaterial'], $material["idEmpresa"]);
							if(!is_numeric($material)){
								$empty = false;
								$proveedor = $this->mproveedor->getCampo2('nombre', $row->idProveedor);
								if (!array_key_exists($material['clave'], $arrayPresupuestoMAT)) {
									$arrayPresupuestoMAT[$material['clave']][$row->id] = array('clave' => $material['clave'], 'idMaterial' => $material['id'], 'idPresupuestoMAT' => $row->id, 'idMaterialesPrototipo' => $materialActividadPrototipo['id'], 'proveedor' => $proveedor, 'idProveedor' => $row->idProveedor, 'cantidad' => $materialActividadPrototipo['cantidad'], 'precioUnitario' => $row->precioUnitario, 'semana' => $row->semana);
								}else{
									$arrayPresupuestoMAT[$material['clave']][$row->id] = array('clave' => $material['clave'], 'idMaterial' => $material['id'], 'idPresupuestoMAT' => $row->id, 'idMaterialesPrototipo' => $materialActividadPrototipo['id'], 'proveedor' => $proveedor, 'idProveedor' => $row->idProveedor, 'cantidad' => $materialActividadPrototipo['cantidad'], 'precioUnitario' => $row->precioUnitario, 'semana' => $row->semana);
								}
							}
						}
					}
				}

				if(!$empty){
					if (isset($_FILES['archivoMateriales']) && $_SERVER['REQUEST_METHOD'] == 'POST') {
						$config['upload_path'] = $this->data['fotos_www'];
						$config['allowed_types'] = 'csv';
						$config['max_size'] = '2000';

						$this->load->library('upload', $config);
						if (!$this->upload->do_upload("archivoMateriales")) {
							$msg = $this->upload->display_errors();
						}else{
							$file_data = $this->upload->data();
							$file_path = $this->data['fotos_www'] . $file_data['file_name'];

							if ($this->csvimport->get_array($file_path, '', TRUE)) {
								$csv_array = $this->csvimport->get_array($file_path);

								if (isset($csv_array[0]['CLAVE']) && isset($csv_array[0]['PRECIO UNITARIO']) && isset($csv_array[0]['SEMANA'])) {
									foreach ($csv_array as $r) {
										if (count($arrayPresupuestoMAT) > 0) {
											if (array_key_exists($r['CLAVE'], $arrayPresupuestoMAT)) {
												$existMaterial = $arrayPresupuestoMAT[$r['CLAVE']];
												$existeKey = 0;
												foreach ($existMaterial as $key => $value) {
													if($existMaterial[$key]['clave'] == $r['CLAVE'] && $existMaterial[$key]['proveedor'] == $r['PROVEEDOR'] && $existMaterial[$key]['semana'] == $r['SEMANA']){
														//Se busca si hay coincidencias de semanas en ese material
														$existeKey = $key;
													}
												}
												
												if($existeKey > 0){
													//Se actualiza
													$existInOrdenCompra = $this->mpresupuestomat->getByIdMaterialSemanaIn($idMaterial, $r['SEMANA']);
													if(is_numeric($existInOrdenCompra)){
														$mapUData['idActividadPrototipo']=0;
														$mapUData['idMaterial']=$existMaterial[$existeKey]['idMaterial'];
														$mapUData['cantidad']=$r['CANTIDAD'];
														$mapUData['tipo']=2;

														$this->mmaterialesactividadprototipo->actualizar($mapUData, $existMaterial[$existeKey]['idMaterialesPrototipo']);

														$uData['idMaterial'] = $idMaterial;
														$uData['idMateriales'] = $existMaterial[$existeKey]['idMaterialesPrototipo'];
														$uData['idProveedor'] = $existMaterial[$existeKey]['idProveedor'];
														$uData['precioUnitario'] = (is_numeric($r['PRECIO UNITARIO']) || is_float($r['PRECIO UNITARIO'])) ? $r['PRECIO UNITARIO'] : 0;
														$uData['precioUnitario'] = round($uData['precioUnitario'], 2);
														$uData['importe'] = round($r['CANTIDAD'] * $uData['precioUnitario'], 2);
														$uData['semana'] = ($r['SEMANA'] != '') ? $r['SEMANA'] : 0;
														$uData['status'] = 1;

														$this->mpresupuestomat->actualizar($uData, $existMaterial[$existeKey]['idPresupuestoMAT']);

														$actualizados++;

														unset($arrayPresupuestoMAT[$r['CLAVE']][$existeKey]);
														if(count($arrayPresupuestoMAT[$r['CLAVE']]) > 0){

														}else{
															unset($arrayPresupuestoMAT[$r['CLAVE']]);
														}
													}else{
														$noActualizadosOc++;
														unset($arrayPresupuestoMAT[$r['CLAVE']][$existeKey]);
														if(count($arrayPresupuestoMAT[$r['CLAVE']]) > 0){

														}else{
															unset($arrayPresupuestoMAT[$r['CLAVE']]);
														}
													}
												}else{
													//Se inserta
													$existInOrdenCompra = $this->mpresupuestomat->getByIdMaterialSemanaIn($idMaterial, $r['SEMANA']);
													if(is_numeric($existInOrdenCompra)){
														$qProveedor = $this->mproveedor->getByNombre($r['PROVEEDOR'],$idEmpresa);
														if(!is_numeric($qProveedor) && $qProveedor['id'] != ''){
															$exist=$this->mmateriales->getByClave($r['CLAVE'], $idEmpresa);
															$mapData['idActividadPrototipo']=0;
															$mapData['idMaterial']=$exist->id;
															$mapData['cantidad']=$r['CANTIDAD'];
															$mapData['tipo']=2;
															$idMap = $this->mmaterialesactividadprototipo->insertar($mapData);

															$pData['idMaterial'] = $idMaterial;
															$pData['idMateriales'] = $idMap;
															$idProveedor = (!is_numeric($qProveedor)) ? $qProveedor['id'] : 0;
															$pData['idProveedor'] = $idProveedor;
															$pData['precioUnitario'] = (is_numeric($r['PRECIO UNITARIO']) || is_float($r['PRECIO UNITARIO'])) ? $r['PRECIO UNITARIO'] : 0;
															$pData['precioUnitario'] = round($pData['precioUnitario'], 2);
															$pData['importe'] = round($r['CANTIDAD'] * $pData['precioUnitario'], 2);
															$pData['semana'] = ($r['SEMANA'] != '') ? $r['SEMANA'] : 0;
															$pData['status'] = 1;
															$idPresupuestoMaterial = $this->mpresupuestomat->insertar($pData);

															$registrados++;
														}else{
															$noRegistradosProveedor++;
														}
													}else{
														$noRegistradosOc++;
													}
												}
											}else{
												//Insertar Nuevo Material
												$existInOrdenCompra = $this->mpresupuestomat->getByIdMaterialSemanaIn($idMaterial, $r['SEMANA']);
												if(is_numeric($existInOrdenCompra)){
													$qProveedor = $this->mproveedor->getByNombre($r['PROVEEDOR'],$idEmpresa);
													if(!is_numeric($qProveedor) && $qProveedor['id'] != ''){
														
														$exist=$this->mmateriales->getByClave($r['CLAVE'], $idEmpresa);
														if(!is_numeric($exist)){
															$mapData['idActividadPrototipo']=0;
															$mapData['idMaterial']=$exist->id;
															$mapData['cantidad']=$r['CANTIDAD'];
															$mapData['tipo']=2;
															$idMap = $this->mmaterialesactividadprototipo->insertar($mapData);

															$pData['idMaterial'] = $idMaterial;
															$pData['idMateriales'] = $idMap;
															$idProveedor = (!is_numeric($qProveedor)) ? $qProveedor['id'] : 0;
															$pData['idProveedor'] = $idProveedor;
															$pData['precioUnitario'] = (is_numeric($r['PRECIO UNITARIO']) || is_float($r['PRECIO UNITARIO'])) ? $r['PRECIO UNITARIO'] : 0;
															$pData['precioUnitario'] = round($pData['precioUnitario'], 2);
															$pData['importe'] = round($r['CANTIDAD'] * $pData['precioUnitario'], 2);
															$pData['semana'] = ($r['SEMANA'] != '') ? $r['SEMANA'] : 0;
															$pData['status'] = 1;
															$idPresupuestoMaterial = $this->mpresupuestomat->insertar($pData);

															$registrados++;
														}
													}else{
														$noRegistradosProveedor++;
													}
												}else{
													$noRegistradosOc++;
												}
											}
										}else{
											//Insertar Nuevo Material
											$existInOrdenCompra = $this->mpresupuestomat->getByIdMaterialSemanaIn($idMaterial, $r['SEMANA']);
											if(is_numeric($existInOrdenCompra)){
												$qProveedor = $this->mproveedor->getByNombre($r['PROVEEDOR'],$idEmpresa);
												if(!is_numeric($qProveedor) && $qProveedor['id'] != ''){
													
													$exist=$this->mmateriales->getByClave($r['CLAVE'], $idEmpresa);
													$mapData['idActividadPrototipo']=0;
													$mapData['idMaterial']=$exist->id;
													$mapData['cantidad']=$r['CANTIDAD'];
													$mapData['tipo']=2;
													$idMap = $this->mmaterialesactividadprototipo->insertar($mapData);

													$pData['idMaterial'] = $idMaterial;
													$pData['idMateriales'] = $idMap;
													$idProveedor = (!is_numeric($qProveedor)) ? $qProveedor['id'] : 0;
													$pData['idProveedor'] = $idProveedor;
													$pData['precioUnitario'] = (is_numeric($r['PRECIO UNITARIO']) || is_float($r['PRECIO UNITARIO'])) ? $r['PRECIO UNITARIO'] : 0;
													$pData['precioUnitario'] = round($pData['precioUnitario'], 2);
													$pData['importe'] = round($r['CANTIDAD'] * $pData['precioUnitario'], 2);
													$pData['semana'] = ($r['SEMANA'] != '') ? $r['SEMANA'] : 0;
													$pData['status'] = 1;
													$idPresupuestoMaterial = $this->mpresupuestomat->insertar($pData);

													$registrados++;

												}else{
													$noRegistradosProveedor++;
												}
											}else{
												$noRegistradosOc++;
											}
										}
									}

									if($checkEliminar == 'on'){
										foreach ($arrayPresupuestoMAT as $key => $value) {
											if(count($arrayPresupuestoMAT[$key]) > 0){
												$array = $arrayPresupuestoMAT[$key];
												foreach ($array as $k => $v) {
													$existInOrdenCompra = $this->mpresupuestomat->getByIdMaterialSemanaIn($idMaterial, $v['semana']);
													if(is_numeric($existInOrdenCompra)){
														$this->mmaterialesactividadprototipo->borrar($v['idMaterialesPrototipo']);
														$this->mpresupuestomat->borrar($v['idPresupuestoMAT']);
														$eliminados++;
													}else{
														$noEliminadosOc++;
													}
												}
											}
										}
									}
									
								}
								@unlink($file_path);
							}
						}
					}
				}
			}

			if($checkEliminar == 'on'){
				$data['msg'] = "<div style='text-align: center'>
									<p> Registros Actualizados : <span style='color: red;'> ".$actualizados." <span/></p>
									<p> Registros Insertados : <span style='color: red;'> ".$registrados."<span/></p>
									<p> Registros Eliminados : <span style='color: red;'> ".$eliminados."<span/></p>
									<p> Registros que no se pudieron actualizar porque ya existe una orden de compra : <span style='color: red;'> ".$noActualizadosOc."<span/></p>
									<p> Registros que no se pudieron insertar porque ya existe una orden de compra : <span style='color: red;'> ".$noRegistradosOc."<span/></p>
									<p> Registros que no se pudieron insertar porque no existe un proveedor : <span style='color: red;'> ".$noRegistradosProveedor."<span/></p>
									<p> Registros que no se pudieron eliminar porque ya existe una orden de compra : <span style='color: red;'> ".$noEliminadosOc."<span/></p>
								</div>";
			}else{
				$data['msg'] = "<div style='text-align: center'>
									<p> Registros Actualizados : <span style='color: red;'> ".$actualizados."<span/></p>
									<p> Registros Insertados : <span style='color: red;'> ".$registrados."<span/></p>
									<p> Registros que no se pudieron actualizar porque ya existe una orden de compra : <span style='color: red;'> ".$noActualizadosOc."<span/></p>
									<p> Registros que no se pudieron insertar porque ya existe una orden de compra : <span style='color: red;'> ".$noRegistradosOc."<span/></p>
									<p> Registros que no se pudieron insertar porque no existe un proveedor : <span style='color: red;'> ".$noRegistradosProveedor."<span/></p>
								</div>";
			}

			$this->data['contenido'] = $this->load->view($this->mainView . '/index_view', $data, true);
			$this->load->view('templates/main_template', $this->data);
		}

		public function eliminar(){
			$id = $this->input->post('elid');
			$q = $this->mmaterial->getById($id);
			$cValor = "true";
			$valorBorrar = $this->mmaterial->borrar($id);
			$this->db->query("DELETE FROM presupuesto_mat WHERE idMaterial=$id");
			$data = json_encode(array("valor" => $cValor));
			echo $data;
		}

	    public function detallepmat($id=0, $edit=0){
			$data["msg"] = "";
			$data['material'] = $material = $this->mmaterial->getById($id);
			$data['claveMateriales'] = $this->mmateriales->getSelectResult($material["idEmpresa"]);
			$data['proveedores'] = $this->mproveedor->getSelectResult($material["idEmpresa"]);

			$query = $this->db->query('SELECT semana AS id, semana AS titulo FROM presupuesto_mat WHERE idMaterial = '.$id.' GROUP BY semana ORDER BY semana ASC');
			if ($query->num_rows() > 0) {
				$data['semana'] = $query;
			}else{
				$data['semana'] = 0;
			}
			$data['total_unitario']=$this->mpresupuestomat->getSumTotalUnitario($id);
			$data['fraccionamiento'] = $this->mfraccionamiento->getCampo2('titulo', $material["idFraccionamiento"]);
			$data['folio'] = $this->mordencompra->getCampo2('folio',$material['idFraccionamiento']);
			$data['prototipo'] = $this->mprototipos->getCampo2('nombre', $material['idPrototipo']);
			$this->data['contenido'] = $this->load->view($this->mainView . '/detalle_view', $data, true);
			$this->load->view('templates/main_template', $this->data);
	    }

		public function listadoDetallepmat($idMaterial = 0, $filtroSemana="")
		{
			$material = $this->mmaterial->getById($idMaterial);
			$materialesPresupuesto = $this->mpresupuestomat->getByIdMaterial($idMaterial, $filtroSemana);
			$empty = true;
			$estatus_arranque=1;
			if (!is_numeric($materialesPresupuesto)) {
				$arrayPresupuestoMAT = array();
				foreach ($materialesPresupuesto->result() as $row) {
					$materialActividadPrototipo = $this->mmaterialesactividadprototipo->getById($row->idMateriales);
					if(!is_numeric($materialActividadPrototipo)){
						$material = $this->mmateriales->getById2($materialActividadPrototipo['idMaterial'],$material["idEmpresa"]);
						if(!is_numeric($material)){
							$empty = false;
							//$area = $this->mareamaterial->getCampo2('area', $material['idArea']);
							$proveedor = $this->mproveedor->getCampo2('nombre', $row->idProveedor);
							//$nameUnidad = $this->munidades->getCampo2('unidad', $material['idUnidad']);
							//$abrevUnidad = $this->munidades->getCampo2('abreviatura', $material['idUnidad']);
							//$unidad = $nameUnidad . ' (' . $abrevUnidad .')';
							$unidad = $material['unidad_compra'];
							$clasificacion = $material['linea_art'];
							$categoriamat=$this->mcategoriamat->getByClave($row->clave_cat);
							$categoriamat=(!is_numeric($categoriamat)) ? $categoriamat["categoria"] : "N/A";
							array_push($arrayPresupuestoMAT, array('tipo'=> $row->tipo,'clave' => $row->clave,'categoria' => $categoriamat, 'proveedor' => $proveedor, 
							'descripcion' => $material['nombre'], 'unidad' => $unidad, 'clasificacion' => $clasificacion, 'cantidad' => $materialActividadPrototipo['cantidad'], 
							'precioUnitario' => $row->precioUnitario, 'importe' => $row->importe, 'idPresupuesto' => $row->id, 'semana' => $row->semana, 
							'idProveedor' => $row->idProveedor, 'idMaterial' => $materialActividadPrototipo['idMaterial']));
						}
					}
				}
			}

			if (!$empty) {
				if (count($arrayPresupuestoMAT) > 0) {
					foreach ($arrayPresupuestoMAT as $row) {
						$ajustes=$this->db->query("SELECT SUM(cantidad) total FROM ajustes WHERE status=10 AND idPresupuesto=".$row["idPresupuesto"]." AND tipoPpto=1 AND tipo=".$row['tipo']);
						$signo=($row["tipo"]==3) ? "+" : "-";
						$ajuste="";
						if($row["tipo"]==3 || $row["tipo"]==4){
							$ajuste=($ajustes->row()->total > 0) ? '<span id="ajuste_' . $row['idPresupuesto'] . '" class="input-group-addon">'.$signo.$ajustes->row()->total.'</span>' : 
							'<span id="ajuste_' . $row['idPresupuesto'] . '" style="display:none" class="input-group-addon">'.$signo.$ajustes->row()->total.'</span>';
						}
						$cantidad = '
						<div class="input-group">
							<input id="cantidadPresupuesto_' . $row['idPresupuesto'] . '" type="text" class="form-control" value="' . $row['cantidad'] . '" disabled="disabled" style="width: 80px;">
						</div>';
						$input = '<div class="input-group">
											<input class="precioUnitario form-control" id="' . $row['idPresupuesto'] . '" data-idProveedor="' . $row['idProveedor'] . '" data-idMaterial="' . $row['idMaterial'] . '" type="text"  value="' . $row['precioUnitario'] . '" disabled="disabled" style="width: 80px;">
											<span class="input-group-addon">
												<a id="editar_' . $row['idPresupuesto'] . '" data-id="' . $row['idPresupuesto'] . '" onclick="habilitarInput($(this));"><i class="fa fa-edit" /></i></a>
											</span>
											<span class="input-group-addon">
												<a id="aceptar_' . $row['idPresupuesto'] . '" data-id="' . $row['idPresupuesto'] . '" onclick="updatePrecio($(this));"><i class="fa fa-check" /></i></a>
											</span>
									</div>';
						$importe = '<span id="importePresupuesto_' . $row['idPresupuesto'] . '">' . precio_format($row['importe']) . '</span>';
						$array['aaData'][] = array(
							'ajustes'=>$ajuste,
							'tipo' => '<span id="tipo_' . $row['idPresupuesto'] . '"">'.getTipoAjuste($row['tipo']).'</span>',
							'clave' => $row['clave'],
							'categoria' => $row['categoria'],
							'clasificacion' => $row['clasificacion'],
							'proveedor' => $row['proveedor'],
							'descripcion' => $row['descripcion'],
							'unidad' => $row['unidad'],
							'cantidad' => $cantidad,
							'precioUnitario' => $input,
							'importe' => $importe,
							'semana' => $row['semana'],
							'acciones' => ($estatus_arranque==1) ? '<a href="javascript:void(0);" id="accionBorrar-'.$row['idPresupuesto'].'" data-id="'.$row['idPresupuesto'].'" onclick="accionBorrar($(this));"><i class="fa fa-trash" aria-hidden="true"></i></a>' : '',
						);
					}
				} else {
					$array['aaData']=[];
				}
			} else {
				$array['aaData']=[];
			}
			echo json_encode($array);
		}
		
		public function resumenpmat($id=0){
			$data["msg"]="";
			$data['material'] = $this->mmaterial->getById($id);
			$idPaq = $data['material']['idPaquete'];
			$qPaquetePmat = $this->mpaquete->getById($idPaq);
			$idPrototipo = $this->mmanoobra->getCampo('idPrototipo', $qPaquetePmat['idManoObra']);
			$superficieM2 = $this->mprototipos->getCampo('superficieM2',$idPrototipo);
			$lotesManzana = contarLotesManzanas($qPaquetePmat['rango_lotes']);
			$idFraccionamiento = $this->mmanoobra->getCampo('idFraccionamiento', $qPaquetePmat['idManoObra']);
	        $totalPresupuestoMO = $this->mpresupuestomo->getSumTotalUnitario($qPaquetePmat["idManoObra"]);
	        $totalUnitario = $totalPresupuestoMO;
			$costoM2 = $totalUnitario / $superficieM2;
	        $lotesManzana = contarLotesManzanas($qPaquetePmat['rango_lotes']);
	        $lotes = $lotesManzana['total'];
			$data['lotes'] = $lotes;
			$totalPaquete = $totalUnitario * $lotes;
			$manzana = '';

			//-----
			$arranque=$this->marranque->getByIdPaquete($idPaq);
			$data["estatus_arranque"]=(!is_numeric($arranque)) ? $arranque["estatus_arranque"] : 0;
	        if(!is_numeric($qPaquetePmat)){
	            foreach($lotesManzana['arrayMzs'] as $mz => $lotes){
	                $manzana = $manzana . $mz . ', ';
	            }
	        	// echo $qPaquetePmat['idConstructor']; exit();
	            $manzana = substr($manzana, 0, -2);
	            $paquetemat = array('titulo' => $qPaquetePmat['titulo'],
	                'fraccionamiento' => $this->mfraccionamiento->getCampo('titulo',$idFraccionamiento), 
	                'prototipo' => $this->mprototipos->getCampo('nombre', $idPrototipo),
	                'almacen' => $this->malmacenes->getCampo('nombre', $idPrototipo),
	                'manzana' => $manzana,
	                'statusPaquete' => $qPaquetePmat['statusPaquete'],
	                'fecha_inicio' => $qPaquetePmat['fecha_inicio'],
	                'fecha_fin' => $qPaquetePmat['fecha_fin'],
	                'contratista' => $this->mconstructores->getCampo("CONCAT(nombre,' ',apellidoP,' ',apellidoM)", $qPaquetePmat['idConstructor']),
	                'rango_lotes' => $lotesManzana['lotes'],
	                'total_unitario' => "$".number_format($totalUnitario,2),
	                'total_paquete' => "$".number_format($totalPaquete,2),
	                'costoM2' => "$".number_format($costoM2,2),
	            );
	            $idContratista = $qPaquetePmat['idConstructor'];
	            $lotes = $lotesManzana['total'];
	        }
	        $data['paquetemat'] = $paquetemat;




			$idPaquete = $this->mmaterial->getCampo('idPaquete',$id);
			$idMO = $this->mpaquete->getCampo('idManoObra', $idPaquete);
			$qPaquete = $this->mpaquete->getById($idPaquete);

			$query = $this->db->query('SELECT semana AS id, semana AS titulo FROM presupuesto_mat WHERE idMaterial = '.$id.' GROUP BY semana');
			if ($query->num_rows() > 0) {
				$data['semana'] = $query;
			}else{
				$data['semana'] = 0;
			}
			$data['fraccionamiento'] = $this->mfraccionamiento->getCampo2('titulo', $data['material']['idFraccionamiento']);
			$data['prototipo'] = $this->mprototipos->getCampo2('nombre', $data['material']['idPrototipo']);
			$data['paquete'] = $this->mpaquete->getById($data['material']['idPaquete']);
			$data['manoObra'] = $this->mmanoobra->getCampo2('titulo', $data['paquete']['idManoObra']);
			$data['paq'] = $qPaquetePmat['titulo'];
			
			require('Arranque.php');

            $arranque = new Arranque();
			$getInfo = $arranque->getInfoVer($qPaquete['id']);
			$sum = 0;
			$sum += ($getInfo != 0) ?  $getInfo['totalEncabezado'] : 0.00 ;

            if($getInfo != 0){
                $data['prototipo'] = $getInfo['prototipo'];
                $data['fraccionamiento'] = $getInfo['fraccionamiento'];
                $data['rangoLotes'] = $getInfo['rangoLotes'];
                $data['presupuestoViv'] = $getInfo['presupuestoViv'];
                $data['presupuestoPaq'] = $getInfo['presupuestoPaq'];
                $data['total_unitario'] = $getInfo['total_unitario'];
                $data['total_paquete'] = $getInfo['total_paquete'];
                $data['costoM2'] = $getInfo['costoM2'];
                $data['m2Viv'] = $getInfo['m2Viv'];
                $data['totalEncabezado'] = $sum;
                $data['pptoTotal'] = $getInfo['pptoTotal'];
                $data['contratista'] = $getInfo['contratista'];
                //ppt unitario materuales
            }else{
                $data['prototipo'] = '';
                $data['fraccionamiento'] = '';
                $data['rangoLotes'] = '';
                $data['presupuestoViv'] = '';
                $data['presupuestoPaq'] = '';
                $data['total_unitario'] = '';
                $data['total_paquete'] = '';
                $data['costoM2'] = '';
                $data['pptoTotal'] = '';
                $data['m2Viv'] = '';
                $data['totalEncabezado'] = '';
                $data['contratista'] = '';
            }
    		$this->data['contenido'] = $this->load->view($this->mainView.'/resumen_view',$data,true);
			$this->load->view('templates/main_template',$this->data);
	    }


	    public function getInfoVer($idPaquete)
	    {
	        $paquete = $this->mpaquete->getById($idPaquete);
	        $qManoObra = $this->mmanoobra->getById($paquete['idManoObra']);
			$superficieM2 = $this->mprototipos->getCampo('superficieM2',$qManoObra['idPrototipo']);
			$prototipo = $this->mprototipos->getById($qManoObra['idPrototipo']);
			
			$totalPresupuestoMO = $this->mpresupuestomo->getSumTotalUnitario($paquete["idManoObra"]);
			$totalUnitario = $totalPresupuestoMO;
			$lotesManzana = contarLotesManzanas($paquete['rango_lotes']);
			$lotes = $lotesManzana['total'];
			$totalPaquete = $totalUnitario * $lotes;

	        $material = $this->mmaterial->getByIdFraccIdProtIdMO($qManoObra['idFraccionamiento'], $qManoObra['idPrototipo'], $idPaquete);
	        
	        $detalle = $this->mdetallepaquete->getByIdPaquete($idPaquete);
	        if (!is_numeric($paquete) && !is_numeric($prototipo) && !is_numeric($material)) {
	            $presupuestoViv = $this->mpresupuestomat->getSumTotalImporte($material['id']);
	            //$lotes = (!is_numeric($detalle)) ? $detalle->num_rows() : 0;
	            $presupuestoPaq = $presupuestoViv * $lotes;
	            $costoM2 = $presupuestoViv / $superficieM2;
	            $response = array('prototipo' => $prototipo['titulo'],
	                'fraccionamiento' => $this->mfraccionamiento->getCampo('titulo', $qManoObra['idFraccionamiento']),
	                'rangoLotes' => (!is_numeric($detalle))? $detalle->num_rows() : 0,
	                'presupuestoViv' => precio_format($presupuestoViv),
					'presupuestoPaq' => precio_format($presupuestoPaq),
					'total_unitario' => "$".number_format($totalUnitario,2),
					'total_paquete' => "$".number_format($totalPaquete,2),
	                'costoM2' => precio_format($costoM2),
	                'm2Viv' => $prototipo['superficieM2']
	            );
	        } else {
	            $response = 0;
	        }
	        return $response;
	    }

		public function listadoResumenpmat($idMaterial = 0, $filtroSemana ="")
		{
			$material = $this->mmaterial->getById($idMaterial);
			$paquete = $this->mpaquete->getById($material['idPaquete']);
			$idManoObra = $paquete['idManoObra'];
			$idPrototipo = $material['idPrototipo'];
			$materialesPresupuesto = $this->mpresupuestomat->getByIdMaterial($idMaterial, $filtroSemana);
			$empty = true;
			if (!is_numeric($materialesPresupuesto)) {
				$arrayPresupuestoMAT = array();
				$countArray = 0;
				foreach ($materialesPresupuesto->result() as $row) {
					$existe = 0;
					$materialActividadPrototipo = $this->mmaterialesactividadprototipo->getById($row->idMateriales);
					if (!is_numeric($materialActividadPrototipo)) {
						$material = $this->mmateriales->getById2($materialActividadPrototipo['idMaterial'],$_SESSION[$this->nsession]["idEmpresa"]);
						if (!is_numeric($material)) {
							$empty = false;
							//$area = $this->mareamaterial->getCampo2('area', $material['idArea']);
							$proveedor = $this->mproveedor->getCampo2('nombre', $row->idProveedor);
							//$nameUnidad = $this->munidades->getCampo2('unidad', $material['idUnidad']);
							//$abrevUnidad = $this->munidades->getCampo2('abreviatura', $material['idUnidad']);
							//$unidad = $nameUnidad . ' (' . $abrevUnidad . ')';
							$unidad = $material['unidad_compra'];
							$clasificacion = $material['linea_art'];
							$categoriamat=$this->mcategoriamat->getByClave($row->clave_cat);
							$categoriamat=(!is_numeric($categoriamat)) ? $categoriamat["categoria"] : "N/A";
							array_push($arrayPresupuestoMAT, array('tipo'=>  $row->tipo,'clave' => $row->clave, 'categoria' => $categoriamat ,'proveedor' => $proveedor, 'descripcion' => $material['nombre'], 'unidad' => $unidad, 'clasificacion' => $clasificacion, 'cantidad' => $materialActividadPrototipo['cantidad'], 'precioUnitario' => $row->precioUnitario, 'importe' => $row->importe, 'idPresupuesto' => $row->id, 'semana' => $row->semana));
						}
					}
				}
			}

			if (!$empty) {
				if (count($arrayPresupuestoMAT) > 0) {
					foreach ($arrayPresupuestoMAT as $row) {
						$array['aaData'][] = array(
							'tipo' => getTipoAjuste($row['tipo']),
							'clave' => $row['clave'],
							'categoria' => $row['categoria'],
							'clasificacion' => $row['clasificacion'],
							'proveedor' => $row['proveedor'],
							'descripcion' => $row['descripcion'],
							'unidad' => $row['unidad'],
							'cantidad' => $row['cantidad'],
							'precioUnitario' => precio_format($row['precioUnitario']),
							'importe' => precio_format($row['importe']),
							'semana' => $row['semana']
						);
					}
				} else {
					$array['aaData']=[];
				}
			} else {
				$array['aaData']=[];
			}
			echo json_encode($array);
		}

		public function getPrototiposByFracc($id = '')
		{
			$prototipos = $this->mprototipoxfraccionamiento->getByIdFraccionamiento($id);
			$array = array();
			$response = array();
			if (!is_numeric($prototipos)) {
				foreach ($prototipos->result() as $key => $value) {
					$array = array(
						'id' => $value->idPrototipo,
						'titulo' => $this->mprototipos->getCampo('nombre', $value->idPrototipo)
					);
					array_push($response, $array);
				}
			} else {
				$response = 0;
			}
			echo json_encode($response);
		}

		public function getPaquetesByFraccProto($idFraccionamiento = '', $idPrototipo = '')
		{
			$paquetes = $this->mpaquete->getByIdFraccionamientoPrototipo($idFraccionamiento, $idPrototipo, true, 'material');
			$array = array();
			$response = array();
			if (!is_numeric($paquetes)) {
				foreach ($paquetes->result() as $key => $value) {
					$array = array(
						'id' => $value->id,
						'titulo' => $this->mpaquete->getCampo('titulo', $value->id)
					);
					array_push($response, $array);
				}
			} else {
				$response = 0;
			}
			echo json_encode($response);
		}

		public function updatePrecio(){
			$idPresupuesto = $this->input->post('idPresupuesto');
			$presupuesto = $this->mpresupuestomat->getById($idPresupuesto);
			$idMaterial = $this->input->post('idMaterial');
			$cantidad = $this->input->post('cantidad');
			$precioUnitario = $this->input->post('precioUnitario');
			$material=$this->mmaterial->getById($idMaterial);
			$idPaquete=$material["idPaquete"];
			$arranque=$this->marranque->getByIdPaquete($idPaquete);
			$estatus_arranque=(!is_numeric($arranque)) ? $arranque["estatus_arranque"] : 0;
			
			//ajustes
			if($estatus_arranque==2 && $presupuesto["tipo"]!=2){
				$mact=$this->mmaterialesactividadprototipo->getById($presupuesto['idMateriales']);
				$ajustes=$this->db->query("SELECT SUM(cantidad) total FROM ajustes WHERE idPaquete=$idPaquete AND idPresupuesto=$idPresupuesto AND
				tipoPpto=1 AND tipo=".$presupuesto["tipo"]);
				$totalAjustes=$ajustes->row()->total;
				$signo='';
				$tipo=0;

				if($presupuesto["tipo"]==3){
					$cantidadOriginal=$mact["cantidad"] - $totalAjustes;
				}else if($presupuesto["tipo"]==4){
					$cantidadOriginal=$mact["cantidad"] + $totalAjustes;
				}else{
					$cantidadOriginal=$mact["cantidad"];
				}
				
				$ajuste["idPaquete"] = $idPaquete;
				$ajuste["idPresupuesto"] = $idPresupuesto;
				$ajuste["tipoPpto"] = 1;
				if($cantidadOriginal==$cantidad){
					$tipo=1;
					$this->db->query("DELETE FROM ajustes WHERE idPaquete=$idPaquete AND idPresupuesto=$idPresupuesto AND tipoPpto=1 AND (tipo=3 OR tipo=4)");
				}else if(($cantidad - $cantidadOriginal) > 0){
					$signo="+";
					$ajuste["cantidad"] = ($presupuesto["tipo"]==4) ? abs($cantidad - $cantidadOriginal) : abs($cantidad - $mact["cantidad"]);
					$ajuste["tipo"] = $tipo = 3;
					$this->db->query("DELETE FROM ajustes WHERE idPaquete=$idPaquete AND idPresupuesto=$idPresupuesto AND tipoPpto=1 AND tipo=4");
					$this->majustes->insertar($ajuste);	
				}else if(($cantidad - $cantidadOriginal) < 0){
					$signo="-";
					$ajuste["cantidad"] = ($presupuesto["tipo"]==3) ? abs($cantidad - $cantidadOriginal) : abs($cantidad - $mact["cantidad"]);
					$ajuste["tipo"] = $tipo = 4;
					$this->db->query("DELETE FROM ajustes WHERE idPaquete=$idPaquete AND idPresupuesto=$idPresupuesto AND tipoPpto=1 AND tipo=3");
					$this->majustes->insertar($ajuste);	
				}
			}
			$signo="";
			$tipo=1;
			//actualizaciones
			$uData['cantidad'] = $cantidad;
			$this->mmaterialesactividadprototipo->actualizar($uData, $presupuesto['idMateriales']);
			$pData['precioUnitario'] = round($precioUnitario, 2);
			$pData['importe'] = round($cantidad * $pData['precioUnitario'], 2);
			$pData['tipo'] = 1;	
			$this->mpresupuestomat->actualizar($pData, $idPresupuesto);
			//respuesta
			$ajustes=$this->db->query("SELECT SUM(cantidad) total FROM ajustes WHERE idPaquete=$idPaquete AND idPresupuesto=$idPresupuesto AND tipoPpto=1 AND tipo=".$tipo);
			$totalAjustes=$ajustes->row()->total;
			$array = array('importe' => precio_format($pData['importe']),'tipo'=>getTipoAjuste($tipo),'ajuste'=>$signo.$totalAjustes);
			echo json_encode($array);
		}

		public function exportarEjemplo(){
			$objPHPExcel = new PhpOffice\PhpSpreadsheet\Spreadsheet();
			$objPHPExcel->getActiveSheet()->setTitle('Presupuesto de Materiales');
			$objPHPExcel->setActiveSheetIndex(0);
			$objPHPExcel->getActiveSheet()->SetCellValue('A1', 'CLAVE');
			$objPHPExcel->getActiveSheet()->SetCellValue('B1', 'CLAVE_CAT');
			$objPHPExcel->getActiveSheet()->SetCellValue('C1', 'DESCRIPCION_CAT');
			$objPHPExcel->getActiveSheet()->SetCellValue('D1', 'PROVEEDOR');
			$objPHPExcel->getActiveSheet()->SetCellValue('E1', 'SEMANA');
			$objPHPExcel->getActiveSheet()->SetCellValue('F1', 'DESCRIPCION');
			$objPHPExcel->getActiveSheet()->SetCellValue('G1', 'CANTIDAD');
			$objPHPExcel->getActiveSheet()->SetCellValue('H1', 'PRECIO UNITARIO');
			
			$name = 'Ejemplo de Importación de Presupuesto de Materiales';
			header('Content-Type: application/vnd.ms-excel');
			header('Content-Disposition: attachment;filename="' . $name . '_' . date('Ymd') . '.xls"');
			header('Cache-Control: max-age=0'); //no cache
			$objWriter = PhpOffice\PhpSpreadsheet\IOFactory::createWriter($objPHPExcel, 'Xls');
			// Forzamos a la descarga
			$objWriter->save('php://output');
		}

		public function exportarPpto($idMaterial){
			$material = $this->mmaterial->getById($idMaterial);
			$exportar = false;
			if(!is_numeric($material)){
				$objPHPExcel = new PhpOffice\PhpSpreadsheet\Spreadsheet();
				$objPHPExcel->getActiveSheet()->setTitle('Presupuesto de Materiales');
				$objPHPExcel->setActiveSheetIndex(0);
				$objPHPExcel->getActiveSheet()->SetCellValue('A1', 'CLAVE');
				$objPHPExcel->getActiveSheet()->SetCellValue('B1', 'CATEGORIA');
				$objPHPExcel->getActiveSheet()->SetCellValue('C1', 'DESCRIPCION');
				$objPHPExcel->getActiveSheet()->SetCellValue('D1', 'PROVEEDOR');
				$objPHPExcel->getActiveSheet()->SetCellValue('E1', 'SEMANA');
				$objPHPExcel->getActiveSheet()->SetCellValue('F1', 'PRECIO UNITARIO');
				$objPHPExcel->getActiveSheet()->SetCellValue('G1', 'CANTIDAD');
				$objPHPExcel->getActiveSheet()->SetCellValue('H1', 'TOTAL');
				$presupuesto = $this->mpresupuestomat->getByIdMaterial($material['id'], 0);
				if(!is_numeric($presupuesto)){
					$exportar = true;
					$rowCount = 2;
					$sumaTotal=0;
					foreach($presupuesto->result() as $row){
						$materialActividadPrototipo = $this->mmaterialesactividadprototipo->getById($row->idMateriales);
						if(!is_numeric($materialActividadPrototipo)){
							$materiales = $this->mmateriales->getById2($materialActividadPrototipo['idMaterial'],$_SESSION[$this->nsession]["idEmpresa"]);
							if(!is_numeric($materiales)){
								$proveedor = $this->mproveedor->getCampo2('nombre', $row->idProveedor);
								$categoriamat=$this->mcategoriamat->getByClave($row->clave_cat);
								$categoriamat=(!is_numeric($categoriamat)) ? $categoriamat["categoria"] : "N/A";
								$objPHPExcel->getActiveSheet()->SetCellValue('A'.$rowCount, $materiales['clave']);
								$objPHPExcel->getActiveSheet()->SetCellValue('B'.$rowCount, $categoriamat);
								$objPHPExcel->getActiveSheet()->SetCellValue('C'.$rowCount, $materiales['nombre']);
								$objPHPExcel->getActiveSheet()->SetCellValue('D'.$rowCount, $proveedor);
								$objPHPExcel->getActiveSheet()->SetCellValue('E'.$rowCount, $row->semana);
								$objPHPExcel->getActiveSheet()->SetCellValue('F'.$rowCount, $row->precioUnitario);
								$objPHPExcel->getActiveSheet()->SetCellValue('G'.$rowCount, $materialActividadPrototipo['cantidad']);
								$total=ROUND($row->precioUnitario * $materialActividadPrototipo['cantidad'],2);
								$sumaTotal+=$total;
								$objPHPExcel->getActiveSheet()->SetCellValue('H'.$rowCount, $total);
							}
						}
						$rowCount++;
					}
					$objPHPExcel->getActiveSheet()->SetCellValue('H'.$rowCount, $sumaTotal);
				}

			}
			
			if($exportar){
				$name = 'Presupuesto de Materiales';
				header('Content-Type: application/vnd.ms-excel');
				header('Content-Disposition: attachment;filename="' . $name . '_' . date('Ymd') . '.xls"');
				header('Cache-Control: max-age=0'); //no cache
				$objWriter = PhpOffice\PhpSpreadsheet\IOFactory::createWriter($objPHPExcel, 'Xls');
				// Forzamos a la descarga
				$objWriter->save('php://output');
			}
		}

		public function getPaqueteByFraccProto($idFraccionamiento = '', $idPrototipo = '')
		{
			$manoobra = $this->mpaquete->getByIdFraccionamientoPrototipo3($idFraccionamiento, $idPrototipo);
			$array = array();
			$response = array();
			if (!is_numeric($manoobra)) {
				foreach ($manoobra->result() as $key => $value) {
					$array = array(
						'id' => $value->id,
						'titulo' => $value->titulo
					);
					array_push($response, $array);
				}
			} else {
				$response = 0;
			}
			echo json_encode($response);
		}

		public function borrarMatPresupuesto()
		{
			$response['status'] = 0;
			$idPresupuesto = $this->input->post('idPresupuesto');
			$presupuesto = $this->mpresupuestomat->getById($idPresupuesto);
			$idMaterial = $this->input->post('idMaterial');
			$material = $this->mmaterial->getById($idMaterial);
			$existInOrdenCompra = $this->mpresupuestomat->getByIdMaterialSemanaIn($idMaterial, $presupuesto['semana']);
			if(is_numeric($existInOrdenCompra)){
				$this->mmaterialesactividadprototipo->borrar($presupuesto['idMateriales']);
				$this->mpresupuestomat->borrar($idPresupuesto);
				$response['status'] = 1;
			}
			echo json_encode($response);
		}

		public function addMatPresupuesto()
		{
			$response['status'] = 0;
			$response['count'] = 0;
			$response['rows'] = array();
			$idMaterial = $this->input->post('idMaterial');
			$material = $this->mmaterial->getById($idMaterial);
			$arrayMateriales = $this->input->post('arrayMateriales');
			$count = count($arrayMateriales);
			$i=0;
			$list = '';
			$estatus_arranque=1;

			foreach ($arrayMateriales as $key => $value) {
					$qProveedor = $this->mproveedor->getByNombre($value['proveedor'],$material["idEmpresa"]);
					if(!is_numeric($qProveedor) && $qProveedor['id'] != ''){
						$exist=$this->mmateriales->getByClave($value['clave'],$material['idEmpresa']);
						$qExistPptoSem = $this->db->query("SELECT p.* FROM presupuesto_mat p 
						LEFT JOIN materialesactividadprototipo m ON m.id = p.idMateriales 
						WHERE p.idMaterial=$idMaterial AND m.idMaterial = $exist->id AND p.idProveedor = ".$qProveedor['id']."");

						if($qExistPptoSem->num_rows() == 0){
							$mapData['idActividadPrototipo']=0;
							$mapData['idMaterial']=$exist->id;
							$mapData['cantidad']=$value['cantidad'];
							$mapData['tipo']=2;
							$idMap = $this->mmaterialesactividadprototipo->insertar($mapData);

							$pData['idMaterial'] = $idMaterial;
							$pData['idMateriales'] = $idMap;
							$idProveedor = (!is_numeric($qProveedor)) ? $qProveedor['id'] : 0;
							$pData['idProveedor'] = $idProveedor;
							$pData['precioUnitario'] = ($value['precioUnitario'] != '') ? $value['precioUnitario'] : 0;
							$pData['precioUnitario'] = round($pData['precioUnitario'], 2);
							$pData['cantidad']=$value['cantidad'];
							$pData['importe'] = round($value['cantidad'] * $pData['precioUnitario'], 2);
							$pData['semana'] = ($value['semana'] != '') ? $value['semana'] : 0;
							$pData['tipo'] = 1;
							$pData['status'] = 1;
							$idPresupuestoMaterial = $this->mpresupuestomat->insertar($pData);

							if($estatus_arranque == 2){
								//$ajuste["idPaquete"] = $idPaquete;
								$ajuste["idPresupuesto"] = $idPresupuestoMaterial;
								$ajuste["cantidad"] = $pData['cantidad'];
								$ajuste["precioUnitario"] = $pData['precioUnitario'];
								$ajuste["tipo"] = $pData['tipo'];
								$ajuste["tipoPpto"] = 1;
								$this->majustes->insertar($ajuste);
							}

							$response['count'] = $response['count'] + 1;

							$cantidad = '<input id="cantidadPresupuesto_' . $idPresupuestoMaterial . '" type="text" class="form-control" value="' . $value['cantidad'] . '" disabled="disabled" style="width: 80px;">';
							$input = '<div class="input-group">
												<input id="' . $idPresupuestoMaterial . '" type="text" class="form-control" value="' . $value['precioUnitario'] . '" disabled="disabled" style="width: 80px;">
												<span class="input-group-addon">
													<a id="editar_' . $idPresupuestoMaterial . '" data-id="' . $idPresupuestoMaterial . '" onclick="habilitarInput($(this));"><i class="fa fa-edit" /></i></a>
												</span>
												<span class="input-group-addon">
													<a id="aceptar_' . $idPresupuestoMaterial . '" data-id="' . $idPresupuestoMaterial . '" onclick="updatePrecio($(this));"><i class="fa fa-check" /></i></a>
												</span>
										</div>';
							$importe = '<span id="importePresupuesto_' . $idPresupuestoMaterial . '">' . precio_format($pData['importe']) . '</span>';

							$borrar = '<a href="javascript:void(0);" id="accionBorrar-'.$idPresupuestoMaterial.'" data-id="'.$idPresupuestoMaterial.'" onclick="accionBorrar($(this));"><i class="fa fa-trash" aria-hidden="true"></i></a>';

							$response['rows'][$key] = "<tr>
														<td>".$exist->linea_art."</td>
														<td>".$exist->clave."</td>
														<td>".$qProveedor['nombre']."</td>
														<td>".$pData['semana']."</td>
														<td>".$exist->nombre."</td>
														<td>".$exist->unidad_compra."</td>
														<td>".$cantidad."</td>
														<td>".$input."</td>
														<td>".$importe."</td>
														<td>".$borrar."</td>
													</tr>";
						}else{
							if($i == $count - 1){
								$list .= $value['clave'].'';
							}else{
								$list .= $value['clave'].', ';
							}
						}
					}else{
						if($i == $count - 1){
							$list .= $value['clave'].'';
						}else{
							$list .= $value['clave'].', ';
						}
					}
				$i++;
			}

			if($response['count'] == $count){
				$response['status'] = 1;
			}
			$response['list'] = $list;

			echo json_encode($response);
		}
	}
?>